"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OrgOAuthSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org_redirect_uri': 'str',
        'issuer_id': 'str',
        'o_auth_key_configurations': 'OAuthKeyConfigurationsListType',
        'enabled': 'bool',
        'client_id': 'str',
        'client_secret': 'str',
        'user_authorization_endpoint': 'str',
        'access_token_endpoint': 'str',
        'user_info_endpoint': 'str',
        'scim_endpoint': 'str',
        'scope': 'list[str]',
        'oidc_attribute_mapping': 'OIDCAttributeMappingType',
        'max_clock_skew': 'int'
    }

    attribute_map = {
        'org_redirect_uri': 'orgRedirectUri',
        'issuer_id': 'issuerId',
        'o_auth_key_configurations': 'oAuthKeyConfigurations',
        'enabled': 'enabled',
        'client_id': 'clientId',
        'client_secret': 'clientSecret',
        'user_authorization_endpoint': 'userAuthorizationEndpoint',
        'access_token_endpoint': 'accessTokenEndpoint',
        'user_info_endpoint': 'userInfoEndpoint',
        'scim_endpoint': 'scimEndpoint',
        'scope': 'scope',
        'oidc_attribute_mapping': 'oidcAttributeMapping',
        'max_clock_skew': 'maxClockSkew'
    }

    def __init__(self, org_redirect_uri=None,issuer_id=None,o_auth_key_configurations=None,enabled=None,client_id=None,client_secret=None,user_authorization_endpoint=None,access_token_endpoint=None,user_info_endpoint=None,scim_endpoint=None,scope=None,oidc_attribute_mapping=None,max_clock_skew=None):
        self._org_redirect_uri = None
        self._issuer_id = None
        self._o_auth_key_configurations = None
        self._enabled = None
        self._client_id = None
        self._client_secret = None
        self._user_authorization_endpoint = None
        self._access_token_endpoint = None
        self._user_info_endpoint = None
        self._scim_endpoint = None
        self._scope = None
        self._oidc_attribute_mapping = None
        self._max_clock_skew = None

        if org_redirect_uri is not None:
            self.org_redirect_uri = org_redirect_uri
        if issuer_id is not None:
            self.issuer_id = issuer_id
        if o_auth_key_configurations is not None:
            self.o_auth_key_configurations = o_auth_key_configurations
        if enabled is not None:
            self.enabled = enabled
        if client_id is not None:
            self.client_id = client_id
        if client_secret is not None:
            self.client_secret = client_secret
        if user_authorization_endpoint is not None:
            self.user_authorization_endpoint = user_authorization_endpoint
        if access_token_endpoint is not None:
            self.access_token_endpoint = access_token_endpoint
        if user_info_endpoint is not None:
            self.user_info_endpoint = user_info_endpoint
        if scim_endpoint is not None:
            self.scim_endpoint = scim_endpoint
        if scope is not None:
            self.scope = scope
        if oidc_attribute_mapping is not None:
            self.oidc_attribute_mapping = oidc_attribute_mapping
        if max_clock_skew is not None:
            self.max_clock_skew = max_clock_skew

    @property
    def org_redirect_uri(self):
        return self._org_redirect_uri
    
    @org_redirect_uri.setter
    def org_redirect_uri(self, org_redirect_uri):
        self._org_redirect_uri = org_redirect_uri

    @property
    def issuer_id(self):
        return self._issuer_id
    
    @issuer_id.setter
    def issuer_id(self, issuer_id):
        self._issuer_id = issuer_id

    @property
    def o_auth_key_configurations(self):
        return self._o_auth_key_configurations
    
    @o_auth_key_configurations.setter
    def o_auth_key_configurations(self, o_auth_key_configurations):
        self._o_auth_key_configurations = o_auth_key_configurations

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def client_id(self):
        return self._client_id
    
    @client_id.setter
    def client_id(self, client_id):
        self._client_id = client_id

    @property
    def client_secret(self):
        return self._client_secret
    
    @client_secret.setter
    def client_secret(self, client_secret):
        self._client_secret = client_secret

    @property
    def user_authorization_endpoint(self):
        return self._user_authorization_endpoint
    
    @user_authorization_endpoint.setter
    def user_authorization_endpoint(self, user_authorization_endpoint):
        self._user_authorization_endpoint = user_authorization_endpoint

    @property
    def access_token_endpoint(self):
        return self._access_token_endpoint
    
    @access_token_endpoint.setter
    def access_token_endpoint(self, access_token_endpoint):
        self._access_token_endpoint = access_token_endpoint

    @property
    def user_info_endpoint(self):
        return self._user_info_endpoint
    
    @user_info_endpoint.setter
    def user_info_endpoint(self, user_info_endpoint):
        self._user_info_endpoint = user_info_endpoint

    @property
    def scim_endpoint(self):
        return self._scim_endpoint
    
    @scim_endpoint.setter
    def scim_endpoint(self, scim_endpoint):
        self._scim_endpoint = scim_endpoint

    @property
    def scope(self):
        return self._scope
    
    @scope.setter
    def scope(self, scope):
        self._scope = scope

    @property
    def oidc_attribute_mapping(self):
        return self._oidc_attribute_mapping
    
    @oidc_attribute_mapping.setter
    def oidc_attribute_mapping(self, oidc_attribute_mapping):
        self._oidc_attribute_mapping = oidc_attribute_mapping

    @property
    def max_clock_skew(self):
        return self._max_clock_skew
    
    @max_clock_skew.setter
    def max_clock_skew(self, max_clock_skew):
        self._max_clock_skew = max_clock_skew


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgOAuthSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
