"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class OperatingSystemFamilyInfoType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'operating_system_family_id': 'int',
        'operating_system': 'list[OperatingSystemInfoType]'
    }

    attribute_map = {
        'name': 'name',
        'operating_system_family_id': 'operatingSystemFamilyId',
        'operating_system': 'operatingSystem'
    }

    def __init__(self, name=None,operating_system_family_id=None,operating_system=None):
        self._name = None
        self._operating_system_family_id = None
        self._operating_system = None

        if name is not None:
            self.name = name
        if operating_system_family_id is not None:
            self.operating_system_family_id = operating_system_family_id
        if operating_system is not None:
            self.operating_system = operating_system

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def operating_system_family_id(self):
        return self._operating_system_family_id
    
    @operating_system_family_id.setter
    def operating_system_family_id(self, operating_system_family_id):
        self._operating_system_family_id = operating_system_family_id

    @property
    def operating_system(self):
        return self._operating_system
    
    @operating_system.setter
    def operating_system(self, operating_system):
        self._operating_system = operating_system


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OperatingSystemFamilyInfoType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
