"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OpenIdProviderConfigurationType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org_o_auth_settings': 'OrgOAuthSettingsType',
        'provider_config_response': 'str'
    }

    attribute_map = {
        'org_o_auth_settings': 'orgOAuthSettings',
        'provider_config_response': 'providerConfigResponse'
    }

    def __init__(self, org_o_auth_settings=None,provider_config_response=None):
        self._org_o_auth_settings = None
        self._provider_config_response = None

        if org_o_auth_settings is not None:
            self.org_o_auth_settings = org_o_auth_settings
        if provider_config_response is not None:
            self.provider_config_response = provider_config_response

    @property
    def org_o_auth_settings(self):
        return self._org_o_auth_settings
    
    @org_o_auth_settings.setter
    def org_o_auth_settings(self, org_o_auth_settings):
        self._org_o_auth_settings = org_o_auth_settings

    @property
    def provider_config_response(self):
        return self._provider_config_response
    
    @provider_config_response.setter
    def provider_config_response(self, provider_config_response):
        self._provider_config_response = provider_config_response


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OpenIdProviderConfigurationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
