"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .params_type import ParamsType


class MoveVAppParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source': 'ReferenceType',
        'section': 'list[SectionType]',
        'sourced_item': 'list[SourcedCompositionItemParamType]'
    }

    attribute_map = {
        'source': 'source',
        'section': 'section',
        'sourced_item': 'sourcedItem'
    }

    def __init__(self, source=None,section=None,sourced_item=None):
        self._source = None
        self._section = None
        self._sourced_item = None

        if source is not None:
            self.source = source
        if section is not None:
            self.section = section
        if sourced_item is not None:
            self.sourced_item = sourced_item

    @property
    def source(self):
        return self._source
    
    @source.setter
    def source(self, source):
        self._source = source

    @property
    def section(self):
        return self._section
    
    @section.setter
    def section(self, section):
        self._section = section

    @property
    def sourced_item(self):
        return self._sourced_item
    
    @sourced_item.setter
    def sourced_item(self, sourced_item):
        self._sourced_item = sourced_item


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MoveVAppParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
