"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class LoadBalancerPoolType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'service_port': 'list[LBPoolServicePortType]',
        'member': 'list[LBPoolMemberType]',
        'operational': 'bool',
        'error_details': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'service_port': 'servicePort',
        'member': 'member',
        'operational': 'operational',
        'error_details': 'errorDetails'
    }

    def __init__(self, id=None,name=None,description=None,service_port=None,member=None,operational=None,error_details=None):
        self._id = None
        self._name = None
        self._description = None
        self._service_port = None
        self._member = None
        self._operational = None
        self._error_details = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if service_port is not None:
            self.service_port = service_port
        if member is not None:
            self.member = member
        if operational is not None:
            self.operational = operational
        if error_details is not None:
            self.error_details = error_details

    @property
    def id(self):
        return self._id
    
    @id.setter
    def id(self, id):
        self._id = id

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def service_port(self):
        return self._service_port
    
    @service_port.setter
    def service_port(self, service_port):
        self._service_port = service_port

    @property
    def member(self):
        return self._member
    
    @member.setter
    def member(self, member):
        self._member = member

    @property
    def operational(self):
        return self._operational
    
    @operational.setter
    def operational(self, operational):
        self._operational = operational

    @property
    def error_details(self):
        return self._error_details
    
    @error_details.setter
    def error_details(self, error_details):
        self._error_details = error_details


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LoadBalancerPoolType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
