"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class IpScopeType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_inherited': 'bool',
        'gateway': 'str',
        'netmask': 'str',
        'subnet_prefix_length': 'int',
        'dns1': 'str',
        'dns2': 'str',
        'dns_suffix': 'str',
        'is_enabled': 'bool',
        'ip_ranges': 'IpRangesType',
        'allocated_ip_addresses': 'IpAddressesType',
        'sub_allocations': 'SubAllocationsType'
    }

    attribute_map = {
        'is_inherited': 'isInherited',
        'gateway': 'gateway',
        'netmask': 'netmask',
        'subnet_prefix_length': 'subnetPrefixLength',
        'dns1': 'dns1',
        'dns2': 'dns2',
        'dns_suffix': 'dnsSuffix',
        'is_enabled': 'isEnabled',
        'ip_ranges': 'ipRanges',
        'allocated_ip_addresses': 'allocatedIpAddresses',
        'sub_allocations': 'subAllocations'
    }

    def __init__(self, is_inherited=None,gateway=None,netmask=None,subnet_prefix_length=None,dns1=None,dns2=None,dns_suffix=None,is_enabled=None,ip_ranges=None,allocated_ip_addresses=None,sub_allocations=None):
        self._is_inherited = None
        self._gateway = None
        self._netmask = None
        self._subnet_prefix_length = None
        self._dns1 = None
        self._dns2 = None
        self._dns_suffix = None
        self._is_enabled = None
        self._ip_ranges = None
        self._allocated_ip_addresses = None
        self._sub_allocations = None

        if is_inherited is not None:
            self.is_inherited = is_inherited
        if gateway is not None:
            self.gateway = gateway
        if netmask is not None:
            self.netmask = netmask
        if subnet_prefix_length is not None:
            self.subnet_prefix_length = subnet_prefix_length
        if dns1 is not None:
            self.dns1 = dns1
        if dns2 is not None:
            self.dns2 = dns2
        if dns_suffix is not None:
            self.dns_suffix = dns_suffix
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if ip_ranges is not None:
            self.ip_ranges = ip_ranges
        if allocated_ip_addresses is not None:
            self.allocated_ip_addresses = allocated_ip_addresses
        if sub_allocations is not None:
            self.sub_allocations = sub_allocations

    @property
    def is_inherited(self):
        return self._is_inherited
    
    @is_inherited.setter
    def is_inherited(self, is_inherited):
        self._is_inherited = is_inherited

    @property
    def gateway(self):
        return self._gateway
    
    @gateway.setter
    def gateway(self, gateway):
        self._gateway = gateway

    @property
    def netmask(self):
        return self._netmask
    
    @netmask.setter
    def netmask(self, netmask):
        self._netmask = netmask

    @property
    def subnet_prefix_length(self):
        return self._subnet_prefix_length
    
    @subnet_prefix_length.setter
    def subnet_prefix_length(self, subnet_prefix_length):
        self._subnet_prefix_length = subnet_prefix_length

    @property
    def dns1(self):
        return self._dns1
    
    @dns1.setter
    def dns1(self, dns1):
        self._dns1 = dns1

    @property
    def dns2(self):
        return self._dns2
    
    @dns2.setter
    def dns2(self, dns2):
        self._dns2 = dns2

    @property
    def dns_suffix(self):
        return self._dns_suffix
    
    @dns_suffix.setter
    def dns_suffix(self, dns_suffix):
        self._dns_suffix = dns_suffix

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def ip_ranges(self):
        return self._ip_ranges
    
    @ip_ranges.setter
    def ip_ranges(self, ip_ranges):
        self._ip_ranges = ip_ranges

    @property
    def allocated_ip_addresses(self):
        return self._allocated_ip_addresses
    
    @allocated_ip_addresses.setter
    def allocated_ip_addresses(self, allocated_ip_addresses):
        self._allocated_ip_addresses = allocated_ip_addresses

    @property
    def sub_allocations(self):
        return self._sub_allocations
    
    @sub_allocations.setter
    def sub_allocations(self, sub_allocations):
        self._sub_allocations = sub_allocations


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IpScopeType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
