"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_app_creation_params_type import VAppCreationParamsType


class InstantiateVAppParamsType(VAppCreationParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source': 'ReferenceType',
        'is_source_delete': 'bool',
        'sourced_vm_instantiation_params': 'list[SourcedVmInstantiationParamsType]',
        'sourced_item': 'list[SourcedCompositionItemParamType]',
        'linked_clone': 'bool'
    }

    attribute_map = {
        'source': 'source',
        'is_source_delete': 'isSourceDelete',
        'sourced_vm_instantiation_params': 'sourcedVmInstantiationParams',
        'sourced_item': 'sourcedItem',
        'linked_clone': 'linkedClone'
    }

    def __init__(self, source=None,is_source_delete=None,sourced_vm_instantiation_params=None,sourced_item=None,linked_clone=None):
        self._source = None
        self._is_source_delete = None
        self._sourced_vm_instantiation_params = None
        self._sourced_item = None
        self._linked_clone = None

        if source is not None:
            self.source = source
        if is_source_delete is not None:
            self.is_source_delete = is_source_delete
        if sourced_vm_instantiation_params is not None:
            self.sourced_vm_instantiation_params = sourced_vm_instantiation_params
        if sourced_item is not None:
            self.sourced_item = sourced_item
        if linked_clone is not None:
            self.linked_clone = linked_clone

    @property
    def source(self):
        return self._source
    
    @source.setter
    def source(self, source):
        self._source = source

    @property
    def is_source_delete(self):
        return self._is_source_delete
    
    @is_source_delete.setter
    def is_source_delete(self, is_source_delete):
        self._is_source_delete = is_source_delete

    @property
    def sourced_vm_instantiation_params(self):
        return self._sourced_vm_instantiation_params
    
    @sourced_vm_instantiation_params.setter
    def sourced_vm_instantiation_params(self, sourced_vm_instantiation_params):
        self._sourced_vm_instantiation_params = sourced_vm_instantiation_params

    @property
    def sourced_item(self):
        return self._sourced_item
    
    @sourced_item.setter
    def sourced_item(self, sourced_item):
        self._sourced_item = sourced_item

    @property
    def linked_clone(self):
        return self._linked_clone
    
    @linked_clone.setter
    def linked_clone(self, linked_clone):
        self._linked_clone = linked_clone


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InstantiateVAppParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
