"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class HybridSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cloud_proxy_base_uri': 'str',
        'cloud_proxy_base_uri_public_cert_chain': 'str',
        'cloud_proxy_base_uri_override': 'str',
        'cloud_proxy_base_uri_public_cert_chain_override': 'str',
        'cloud_proxy_from_cloud_tunnel_host': 'str',
        'cloud_proxy_from_cloud_tunnel_host_override': 'str'
    }

    attribute_map = {
        'cloud_proxy_base_uri': 'cloudProxyBaseUri',
        'cloud_proxy_base_uri_public_cert_chain': 'cloudProxyBaseUriPublicCertChain',
        'cloud_proxy_base_uri_override': 'cloudProxyBaseUriOverride',
        'cloud_proxy_base_uri_public_cert_chain_override': 'cloudProxyBaseUriPublicCertChainOverride',
        'cloud_proxy_from_cloud_tunnel_host': 'cloudProxyFromCloudTunnelHost',
        'cloud_proxy_from_cloud_tunnel_host_override': 'cloudProxyFromCloudTunnelHostOverride'
    }

    def __init__(self, cloud_proxy_base_uri=None,cloud_proxy_base_uri_public_cert_chain=None,cloud_proxy_base_uri_override=None,cloud_proxy_base_uri_public_cert_chain_override=None,cloud_proxy_from_cloud_tunnel_host=None,cloud_proxy_from_cloud_tunnel_host_override=None):
        self._cloud_proxy_base_uri = None
        self._cloud_proxy_base_uri_public_cert_chain = None
        self._cloud_proxy_base_uri_override = None
        self._cloud_proxy_base_uri_public_cert_chain_override = None
        self._cloud_proxy_from_cloud_tunnel_host = None
        self._cloud_proxy_from_cloud_tunnel_host_override = None

        if cloud_proxy_base_uri is not None:
            self.cloud_proxy_base_uri = cloud_proxy_base_uri
        if cloud_proxy_base_uri_public_cert_chain is not None:
            self.cloud_proxy_base_uri_public_cert_chain = cloud_proxy_base_uri_public_cert_chain
        if cloud_proxy_base_uri_override is not None:
            self.cloud_proxy_base_uri_override = cloud_proxy_base_uri_override
        if cloud_proxy_base_uri_public_cert_chain_override is not None:
            self.cloud_proxy_base_uri_public_cert_chain_override = cloud_proxy_base_uri_public_cert_chain_override
        if cloud_proxy_from_cloud_tunnel_host is not None:
            self.cloud_proxy_from_cloud_tunnel_host = cloud_proxy_from_cloud_tunnel_host
        if cloud_proxy_from_cloud_tunnel_host_override is not None:
            self.cloud_proxy_from_cloud_tunnel_host_override = cloud_proxy_from_cloud_tunnel_host_override

    @property
    def cloud_proxy_base_uri(self):
        return self._cloud_proxy_base_uri
    
    @cloud_proxy_base_uri.setter
    def cloud_proxy_base_uri(self, cloud_proxy_base_uri):
        self._cloud_proxy_base_uri = cloud_proxy_base_uri

    @property
    def cloud_proxy_base_uri_public_cert_chain(self):
        return self._cloud_proxy_base_uri_public_cert_chain
    
    @cloud_proxy_base_uri_public_cert_chain.setter
    def cloud_proxy_base_uri_public_cert_chain(self, cloud_proxy_base_uri_public_cert_chain):
        self._cloud_proxy_base_uri_public_cert_chain = cloud_proxy_base_uri_public_cert_chain

    @property
    def cloud_proxy_base_uri_override(self):
        return self._cloud_proxy_base_uri_override
    
    @cloud_proxy_base_uri_override.setter
    def cloud_proxy_base_uri_override(self, cloud_proxy_base_uri_override):
        self._cloud_proxy_base_uri_override = cloud_proxy_base_uri_override

    @property
    def cloud_proxy_base_uri_public_cert_chain_override(self):
        return self._cloud_proxy_base_uri_public_cert_chain_override
    
    @cloud_proxy_base_uri_public_cert_chain_override.setter
    def cloud_proxy_base_uri_public_cert_chain_override(self, cloud_proxy_base_uri_public_cert_chain_override):
        self._cloud_proxy_base_uri_public_cert_chain_override = cloud_proxy_base_uri_public_cert_chain_override

    @property
    def cloud_proxy_from_cloud_tunnel_host(self):
        return self._cloud_proxy_from_cloud_tunnel_host
    
    @cloud_proxy_from_cloud_tunnel_host.setter
    def cloud_proxy_from_cloud_tunnel_host(self, cloud_proxy_from_cloud_tunnel_host):
        self._cloud_proxy_from_cloud_tunnel_host = cloud_proxy_from_cloud_tunnel_host

    @property
    def cloud_proxy_from_cloud_tunnel_host_override(self):
        return self._cloud_proxy_from_cloud_tunnel_host_override
    
    @cloud_proxy_from_cloud_tunnel_host_override.setter
    def cloud_proxy_from_cloud_tunnel_host_override(self, cloud_proxy_from_cloud_tunnel_host_override):
        self._cloud_proxy_from_cloud_tunnel_host_override = cloud_proxy_from_cloud_tunnel_host_override


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HybridSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
