"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class GatewayIpsecVpnTunnelType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'ipsec_vpn_peer': 'IpsecVpnPeerType',
        'peer_ip_address': 'str',
        'peer_id': 'str',
        'local_ip_address': 'str',
        'local_id': 'str',
        'local_subnet': 'list[IpsecVpnSubnetType]',
        'peer_subnet': 'list[IpsecVpnSubnetType]',
        'shared_secret': 'str',
        'shared_secret_encrypted': 'bool',
        'encryption_protocol': 'str',
        'mtu': 'int',
        'is_enabled': 'bool',
        'is_operational': 'bool',
        'error_details': 'str'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'ipsec_vpn_peer': 'ipsecVpnPeer',
        'peer_ip_address': 'peerIpAddress',
        'peer_id': 'peerId',
        'local_ip_address': 'localIpAddress',
        'local_id': 'localId',
        'local_subnet': 'localSubnet',
        'peer_subnet': 'peerSubnet',
        'shared_secret': 'sharedSecret',
        'shared_secret_encrypted': 'sharedSecretEncrypted',
        'encryption_protocol': 'encryptionProtocol',
        'mtu': 'mtu',
        'is_enabled': 'isEnabled',
        'is_operational': 'isOperational',
        'error_details': 'errorDetails'
    }

    def __init__(self, name=None,description=None,ipsec_vpn_peer=None,peer_ip_address=None,peer_id=None,local_ip_address=None,local_id=None,local_subnet=None,peer_subnet=None,shared_secret=None,shared_secret_encrypted=None,encryption_protocol=None,mtu=None,is_enabled=None,is_operational=None,error_details=None):
        self._name = None
        self._description = None
        self._ipsec_vpn_peer = None
        self._peer_ip_address = None
        self._peer_id = None
        self._local_ip_address = None
        self._local_id = None
        self._local_subnet = None
        self._peer_subnet = None
        self._shared_secret = None
        self._shared_secret_encrypted = None
        self._encryption_protocol = None
        self._mtu = None
        self._is_enabled = None
        self._is_operational = None
        self._error_details = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if ipsec_vpn_peer is not None:
            self.ipsec_vpn_peer = ipsec_vpn_peer
        if peer_ip_address is not None:
            self.peer_ip_address = peer_ip_address
        if peer_id is not None:
            self.peer_id = peer_id
        if local_ip_address is not None:
            self.local_ip_address = local_ip_address
        if local_id is not None:
            self.local_id = local_id
        if local_subnet is not None:
            self.local_subnet = local_subnet
        if peer_subnet is not None:
            self.peer_subnet = peer_subnet
        if shared_secret is not None:
            self.shared_secret = shared_secret
        if shared_secret_encrypted is not None:
            self.shared_secret_encrypted = shared_secret_encrypted
        if encryption_protocol is not None:
            self.encryption_protocol = encryption_protocol
        if mtu is not None:
            self.mtu = mtu
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_operational is not None:
            self.is_operational = is_operational
        if error_details is not None:
            self.error_details = error_details

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def ipsec_vpn_peer(self):
        return self._ipsec_vpn_peer
    
    @ipsec_vpn_peer.setter
    def ipsec_vpn_peer(self, ipsec_vpn_peer):
        self._ipsec_vpn_peer = ipsec_vpn_peer

    @property
    def peer_ip_address(self):
        return self._peer_ip_address
    
    @peer_ip_address.setter
    def peer_ip_address(self, peer_ip_address):
        self._peer_ip_address = peer_ip_address

    @property
    def peer_id(self):
        return self._peer_id
    
    @peer_id.setter
    def peer_id(self, peer_id):
        self._peer_id = peer_id

    @property
    def local_ip_address(self):
        return self._local_ip_address
    
    @local_ip_address.setter
    def local_ip_address(self, local_ip_address):
        self._local_ip_address = local_ip_address

    @property
    def local_id(self):
        return self._local_id
    
    @local_id.setter
    def local_id(self, local_id):
        self._local_id = local_id

    @property
    def local_subnet(self):
        return self._local_subnet
    
    @local_subnet.setter
    def local_subnet(self, local_subnet):
        self._local_subnet = local_subnet

    @property
    def peer_subnet(self):
        return self._peer_subnet
    
    @peer_subnet.setter
    def peer_subnet(self, peer_subnet):
        self._peer_subnet = peer_subnet

    @property
    def shared_secret(self):
        return self._shared_secret
    
    @shared_secret.setter
    def shared_secret(self, shared_secret):
        self._shared_secret = shared_secret

    @property
    def shared_secret_encrypted(self):
        return self._shared_secret_encrypted
    
    @shared_secret_encrypted.setter
    def shared_secret_encrypted(self, shared_secret_encrypted):
        self._shared_secret_encrypted = shared_secret_encrypted

    @property
    def encryption_protocol(self):
        return self._encryption_protocol
    
    @encryption_protocol.setter
    def encryption_protocol(self, encryption_protocol):
        self._encryption_protocol = encryption_protocol

    @property
    def mtu(self):
        return self._mtu
    
    @mtu.setter
    def mtu(self, mtu):
        self._mtu = mtu

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def is_operational(self):
        return self._is_operational
    
    @is_operational.setter
    def is_operational(self, is_operational):
        self._is_operational = is_operational

    @property
    def error_details(self):
        return self._error_details
    
    @error_details.setter
    def error_details(self, error_details):
        self._error_details = error_details


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GatewayIpsecVpnTunnelType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
