"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class ExternalCatalogSubscriptionParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'subscribe_to_external_feeds': 'bool',
        'location': 'str',
        'password': 'str',
        'expected_ssl_thumbprint': 'str',
        'local_copy': 'bool',
        'library_id': 'str'
    }

    attribute_map = {
        'subscribe_to_external_feeds': 'subscribeToExternalFeeds',
        'location': 'location',
        'password': 'password',
        'expected_ssl_thumbprint': 'expectedSslThumbprint',
        'local_copy': 'localCopy',
        'library_id': 'libraryId'
    }

    def __init__(self, subscribe_to_external_feeds=None,location=None,password=None,expected_ssl_thumbprint=None,local_copy=None,library_id=None):
        self._subscribe_to_external_feeds = None
        self._location = None
        self._password = None
        self._expected_ssl_thumbprint = None
        self._local_copy = None
        self._library_id = None

        if subscribe_to_external_feeds is not None:
            self.subscribe_to_external_feeds = subscribe_to_external_feeds
        if location is not None:
            self.location = location
        if password is not None:
            self.password = password
        if expected_ssl_thumbprint is not None:
            self.expected_ssl_thumbprint = expected_ssl_thumbprint
        if local_copy is not None:
            self.local_copy = local_copy
        if library_id is not None:
            self.library_id = library_id

    @property
    def subscribe_to_external_feeds(self):
        return self._subscribe_to_external_feeds
    
    @subscribe_to_external_feeds.setter
    def subscribe_to_external_feeds(self, subscribe_to_external_feeds):
        self._subscribe_to_external_feeds = subscribe_to_external_feeds

    @property
    def location(self):
        return self._location
    
    @location.setter
    def location(self, location):
        self._location = location

    @property
    def password(self):
        return self._password
    
    @password.setter
    def password(self, password):
        self._password = password

    @property
    def expected_ssl_thumbprint(self):
        return self._expected_ssl_thumbprint
    
    @expected_ssl_thumbprint.setter
    def expected_ssl_thumbprint(self, expected_ssl_thumbprint):
        self._expected_ssl_thumbprint = expected_ssl_thumbprint

    @property
    def local_copy(self):
        return self._local_copy
    
    @local_copy.setter
    def local_copy(self, local_copy):
        self._local_copy = local_copy

    @property
    def library_id(self):
        return self._library_id
    
    @library_id.setter
    def library_id(self, library_id):
        self._library_id = library_id


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExternalCatalogSubscriptionParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
