"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..provider_vdc_type import ProviderVdcType


class VMWProviderVdcType(ProviderVdcType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'data_store_refs': 'VimObjectRefsType',
        'resource_pool_refs': 'VimObjectRefsType',
        'vim_server': 'list[ReferenceType]',
        'nsx_t_manager_reference': 'ReferenceType',
        'host_references': 'VMWHostReferencesType',
        'highest_supported_hardware_version': 'str',
        'available_universal_network_pool': 'ReferenceType',
        'compute_provider_scope': 'str'
    }

    attribute_map = {
        'data_store_refs': 'dataStoreRefs',
        'resource_pool_refs': 'resourcePoolRefs',
        'vim_server': 'vimServer',
        'nsx_t_manager_reference': 'nsxTManagerReference',
        'host_references': 'hostReferences',
        'highest_supported_hardware_version': 'highestSupportedHardwareVersion',
        'available_universal_network_pool': 'availableUniversalNetworkPool',
        'compute_provider_scope': 'computeProviderScope'
    }

    def __init__(self, data_store_refs=None,resource_pool_refs=None,vim_server=None,nsx_t_manager_reference=None,host_references=None,highest_supported_hardware_version=None,available_universal_network_pool=None,compute_provider_scope=None):
        self._data_store_refs = None
        self._resource_pool_refs = None
        self._vim_server = None
        self._nsx_t_manager_reference = None
        self._host_references = None
        self._highest_supported_hardware_version = None
        self._available_universal_network_pool = None
        self._compute_provider_scope = None

        if data_store_refs is not None:
            self.data_store_refs = data_store_refs
        if resource_pool_refs is not None:
            self.resource_pool_refs = resource_pool_refs
        if vim_server is not None:
            self.vim_server = vim_server
        if nsx_t_manager_reference is not None:
            self.nsx_t_manager_reference = nsx_t_manager_reference
        if host_references is not None:
            self.host_references = host_references
        if highest_supported_hardware_version is not None:
            self.highest_supported_hardware_version = highest_supported_hardware_version
        if available_universal_network_pool is not None:
            self.available_universal_network_pool = available_universal_network_pool
        if compute_provider_scope is not None:
            self.compute_provider_scope = compute_provider_scope

    @property
    def data_store_refs(self):
        return self._data_store_refs
    
    @data_store_refs.setter
    def data_store_refs(self, data_store_refs):
        self._data_store_refs = data_store_refs

    @property
    def resource_pool_refs(self):
        return self._resource_pool_refs
    
    @resource_pool_refs.setter
    def resource_pool_refs(self, resource_pool_refs):
        self._resource_pool_refs = resource_pool_refs

    @property
    def vim_server(self):
        return self._vim_server
    
    @vim_server.setter
    def vim_server(self, vim_server):
        self._vim_server = vim_server

    @property
    def nsx_t_manager_reference(self):
        return self._nsx_t_manager_reference
    
    @nsx_t_manager_reference.setter
    def nsx_t_manager_reference(self, nsx_t_manager_reference):
        self._nsx_t_manager_reference = nsx_t_manager_reference

    @property
    def host_references(self):
        return self._host_references
    
    @host_references.setter
    def host_references(self, host_references):
        self._host_references = host_references

    @property
    def highest_supported_hardware_version(self):
        return self._highest_supported_hardware_version
    
    @highest_supported_hardware_version.setter
    def highest_supported_hardware_version(self, highest_supported_hardware_version):
        self._highest_supported_hardware_version = highest_supported_hardware_version

    @property
    def available_universal_network_pool(self):
        return self._available_universal_network_pool
    
    @available_universal_network_pool.setter
    def available_universal_network_pool(self, available_universal_network_pool):
        self._available_universal_network_pool = available_universal_network_pool

    @property
    def compute_provider_scope(self):
        return self._compute_provider_scope
    
    @compute_provider_scope.setter
    def compute_provider_scope(self, compute_provider_scope):
        self._compute_provider_scope = compute_provider_scope


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMWProviderVdcType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
