"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..params_type import ParamsType


class VMWProviderVdcParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'resource_pool_refs': 'VimObjectRefsType',
        'vim_server': 'list[ReferenceType]',
        'nsx_t_manager_reference': 'ReferenceType',
        'vxlan_network_pool': 'ReferenceType',
        'network_pool': 'ReferenceType',
        'highest_supported_hardware_version': 'str',
        'is_enabled': 'bool',
        'storage_profile': 'list[str]',
        'host_refs': 'HostObjectRefsType',
        'default_password': 'str',
        'default_username': 'str',
        'auto_create_network_pool': 'bool'
    }

    attribute_map = {
        'resource_pool_refs': 'resourcePoolRefs',
        'vim_server': 'vimServer',
        'nsx_t_manager_reference': 'nsxTManagerReference',
        'vxlan_network_pool': 'vxlanNetworkPool',
        'network_pool': 'networkPool',
        'highest_supported_hardware_version': 'highestSupportedHardwareVersion',
        'is_enabled': 'isEnabled',
        'storage_profile': 'storageProfile',
        'host_refs': 'hostRefs',
        'default_password': 'defaultPassword',
        'default_username': 'defaultUsername',
        'auto_create_network_pool': 'autoCreateNetworkPool'
    }

    def __init__(self, resource_pool_refs=None,vim_server=None,nsx_t_manager_reference=None,vxlan_network_pool=None,network_pool=None,highest_supported_hardware_version=None,is_enabled=None,storage_profile=None,host_refs=None,default_password=None,default_username=None,auto_create_network_pool=None):
        self._resource_pool_refs = None
        self._vim_server = None
        self._nsx_t_manager_reference = None
        self._vxlan_network_pool = None
        self._network_pool = None
        self._highest_supported_hardware_version = None
        self._is_enabled = None
        self._storage_profile = None
        self._host_refs = None
        self._default_password = None
        self._default_username = None
        self._auto_create_network_pool = None

        if resource_pool_refs is not None:
            self.resource_pool_refs = resource_pool_refs
        if vim_server is not None:
            self.vim_server = vim_server
        if nsx_t_manager_reference is not None:
            self.nsx_t_manager_reference = nsx_t_manager_reference
        if vxlan_network_pool is not None:
            self.vxlan_network_pool = vxlan_network_pool
        if network_pool is not None:
            self.network_pool = network_pool
        if highest_supported_hardware_version is not None:
            self.highest_supported_hardware_version = highest_supported_hardware_version
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if storage_profile is not None:
            self.storage_profile = storage_profile
        if host_refs is not None:
            self.host_refs = host_refs
        if default_password is not None:
            self.default_password = default_password
        if default_username is not None:
            self.default_username = default_username
        if auto_create_network_pool is not None:
            self.auto_create_network_pool = auto_create_network_pool

    @property
    def resource_pool_refs(self):
        return self._resource_pool_refs
    
    @resource_pool_refs.setter
    def resource_pool_refs(self, resource_pool_refs):
        self._resource_pool_refs = resource_pool_refs

    @property
    def vim_server(self):
        return self._vim_server
    
    @vim_server.setter
    def vim_server(self, vim_server):
        self._vim_server = vim_server

    @property
    def nsx_t_manager_reference(self):
        return self._nsx_t_manager_reference
    
    @nsx_t_manager_reference.setter
    def nsx_t_manager_reference(self, nsx_t_manager_reference):
        self._nsx_t_manager_reference = nsx_t_manager_reference

    @property
    def vxlan_network_pool(self):
        return self._vxlan_network_pool
    
    @vxlan_network_pool.setter
    def vxlan_network_pool(self, vxlan_network_pool):
        self._vxlan_network_pool = vxlan_network_pool

    @property
    def network_pool(self):
        return self._network_pool
    
    @network_pool.setter
    def network_pool(self, network_pool):
        self._network_pool = network_pool

    @property
    def highest_supported_hardware_version(self):
        return self._highest_supported_hardware_version
    
    @highest_supported_hardware_version.setter
    def highest_supported_hardware_version(self, highest_supported_hardware_version):
        self._highest_supported_hardware_version = highest_supported_hardware_version

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def storage_profile(self):
        return self._storage_profile
    
    @storage_profile.setter
    def storage_profile(self, storage_profile):
        self._storage_profile = storage_profile

    @property
    def host_refs(self):
        return self._host_refs
    
    @host_refs.setter
    def host_refs(self, host_refs):
        self._host_refs = host_refs

    @property
    def default_password(self):
        return self._default_password
    
    @default_password.setter
    def default_password(self, default_password):
        self._default_password = default_password

    @property
    def default_username(self):
        return self._default_username
    
    @default_username.setter
    def default_username(self, default_username):
        self._default_username = default_username

    @property
    def auto_create_network_pool(self):
        return self._auto_create_network_pool
    
    @auto_create_network_pool.setter
    def auto_create_network_pool(self, auto_create_network_pool):
        self._auto_create_network_pool = auto_create_network_pool


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMWProviderVdcParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
