"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class VmVimInfoType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vm_vim_object_ref': 'VimObjectRefType',
        'datastore_vim_object_ref': 'VimObjectRefType',
        'vm_disk_datastores': 'list[DiskDatastoreType]',
        'host_vim_object_ref': 'VimObjectRefType',
        'virtual_disks_max_chain_length': 'int'
    }

    attribute_map = {
        'vm_vim_object_ref': 'vmVimObjectRef',
        'datastore_vim_object_ref': 'datastoreVimObjectRef',
        'vm_disk_datastores': 'vmDiskDatastores',
        'host_vim_object_ref': 'hostVimObjectRef',
        'virtual_disks_max_chain_length': 'virtualDisksMaxChainLength'
    }

    def __init__(self, vm_vim_object_ref=None,datastore_vim_object_ref=None,vm_disk_datastores=None,host_vim_object_ref=None,virtual_disks_max_chain_length=None):
        self._vm_vim_object_ref = None
        self._datastore_vim_object_ref = None
        self._vm_disk_datastores = None
        self._host_vim_object_ref = None
        self._virtual_disks_max_chain_length = None

        if vm_vim_object_ref is not None:
            self.vm_vim_object_ref = vm_vim_object_ref
        if datastore_vim_object_ref is not None:
            self.datastore_vim_object_ref = datastore_vim_object_ref
        if vm_disk_datastores is not None:
            self.vm_disk_datastores = vm_disk_datastores
        if host_vim_object_ref is not None:
            self.host_vim_object_ref = host_vim_object_ref
        if virtual_disks_max_chain_length is not None:
            self.virtual_disks_max_chain_length = virtual_disks_max_chain_length

    @property
    def vm_vim_object_ref(self):
        return self._vm_vim_object_ref
    
    @vm_vim_object_ref.setter
    def vm_vim_object_ref(self, vm_vim_object_ref):
        self._vm_vim_object_ref = vm_vim_object_ref

    @property
    def datastore_vim_object_ref(self):
        return self._datastore_vim_object_ref
    
    @datastore_vim_object_ref.setter
    def datastore_vim_object_ref(self, datastore_vim_object_ref):
        self._datastore_vim_object_ref = datastore_vim_object_ref

    @property
    def vm_disk_datastores(self):
        return self._vm_disk_datastores
    
    @vm_disk_datastores.setter
    def vm_disk_datastores(self, vm_disk_datastores):
        self._vm_disk_datastores = vm_disk_datastores

    @property
    def host_vim_object_ref(self):
        return self._host_vim_object_ref
    
    @host_vim_object_ref.setter
    def host_vim_object_ref(self, host_vim_object_ref):
        self._host_vim_object_ref = host_vim_object_ref

    @property
    def virtual_disks_max_chain_length(self):
        return self._virtual_disks_max_chain_length
    
    @virtual_disks_max_chain_length.setter
    def virtual_disks_max_chain_length(self, virtual_disks_max_chain_length):
        self._virtual_disks_max_chain_length = virtual_disks_max_chain_length


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmVimInfoType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
