"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class SmtpSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'use_authentication': 'bool',
        'smtp_server_name': 'str',
        'smtp_server_port': 'int',
        'ssl': 'bool',
        'smtp_secure_mode': 'SmtpSecureModeType',
        'ssl_trust_store': 'str',
        'user_name': 'str',
        'password': 'str'
    }

    attribute_map = {
        'use_authentication': 'useAuthentication',
        'smtp_server_name': 'smtpServerName',
        'smtp_server_port': 'smtpServerPort',
        'ssl': 'ssl',
        'smtp_secure_mode': 'smtpSecureMode',
        'ssl_trust_store': 'sslTrustStore',
        'user_name': 'userName',
        'password': 'password'
    }

    def __init__(self, use_authentication=None,smtp_server_name=None,smtp_server_port=None,ssl=None,smtp_secure_mode=None,ssl_trust_store=None,user_name=None,password=None):
        self._use_authentication = None
        self._smtp_server_name = None
        self._smtp_server_port = None
        self._ssl = None
        self._smtp_secure_mode = None
        self._ssl_trust_store = None
        self._user_name = None
        self._password = None

        if use_authentication is not None:
            self.use_authentication = use_authentication
        if smtp_server_name is not None:
            self.smtp_server_name = smtp_server_name
        if smtp_server_port is not None:
            self.smtp_server_port = smtp_server_port
        if ssl is not None:
            self.ssl = ssl
        if smtp_secure_mode is not None:
            self.smtp_secure_mode = smtp_secure_mode
        if ssl_trust_store is not None:
            self.ssl_trust_store = ssl_trust_store
        if user_name is not None:
            self.user_name = user_name
        if password is not None:
            self.password = password

    @property
    def use_authentication(self):
        return self._use_authentication
    
    @use_authentication.setter
    def use_authentication(self, use_authentication):
        self._use_authentication = use_authentication

    @property
    def smtp_server_name(self):
        return self._smtp_server_name
    
    @smtp_server_name.setter
    def smtp_server_name(self, smtp_server_name):
        self._smtp_server_name = smtp_server_name

    @property
    def smtp_server_port(self):
        return self._smtp_server_port
    
    @smtp_server_port.setter
    def smtp_server_port(self, smtp_server_port):
        self._smtp_server_port = smtp_server_port

    @property
    def ssl(self):
        return self._ssl
    
    @ssl.setter
    def ssl(self, ssl):
        self._ssl = ssl

    @property
    def smtp_secure_mode(self):
        return self._smtp_secure_mode
    
    @smtp_secure_mode.setter
    def smtp_secure_mode(self, smtp_secure_mode):
        self._smtp_secure_mode = smtp_secure_mode

    @property
    def ssl_trust_store(self):
        return self._ssl_trust_store
    
    @ssl_trust_store.setter
    def ssl_trust_store(self, ssl_trust_store):
        self._ssl_trust_store = ssl_trust_store

    @property
    def user_name(self):
        return self._user_name
    
    @user_name.setter
    def user_name(self, user_name):
        self._user_name = user_name

    @property
    def password(self):
        return self._password
    
    @password.setter
    def password(self, password):
        self._password = password


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SmtpSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
