"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .server_type import ServerType


class NsxTManagerType(ServerType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'deployment_type': 'str',
        'virtual_center_reference': 'ReferenceType',
        'service_app_reference': 'ReferenceType',
        'network_provider_scope': 'str',
        'version': 'str',
        'proxy_configuration_reference': 'ReferenceType'
    }

    attribute_map = {
        'deployment_type': 'deploymentType',
        'virtual_center_reference': 'virtualCenterReference',
        'service_app_reference': 'serviceAppReference',
        'network_provider_scope': 'networkProviderScope',
        'version': 'version',
        'proxy_configuration_reference': 'proxyConfigurationReference'
    }

    def __init__(self, deployment_type=None,virtual_center_reference=None,service_app_reference=None,network_provider_scope=None,version=None,proxy_configuration_reference=None):
        self._deployment_type = None
        self._virtual_center_reference = None
        self._service_app_reference = None
        self._network_provider_scope = None
        self._version = None
        self._proxy_configuration_reference = None

        if deployment_type is not None:
            self.deployment_type = deployment_type
        if virtual_center_reference is not None:
            self.virtual_center_reference = virtual_center_reference
        if service_app_reference is not None:
            self.service_app_reference = service_app_reference
        if network_provider_scope is not None:
            self.network_provider_scope = network_provider_scope
        if version is not None:
            self.version = version
        if proxy_configuration_reference is not None:
            self.proxy_configuration_reference = proxy_configuration_reference

    @property
    def deployment_type(self):
        return self._deployment_type
    
    @deployment_type.setter
    def deployment_type(self, deployment_type):
        self._deployment_type = deployment_type

    @property
    def virtual_center_reference(self):
        return self._virtual_center_reference
    
    @virtual_center_reference.setter
    def virtual_center_reference(self, virtual_center_reference):
        self._virtual_center_reference = virtual_center_reference

    @property
    def service_app_reference(self):
        return self._service_app_reference
    
    @service_app_reference.setter
    def service_app_reference(self, service_app_reference):
        self._service_app_reference = service_app_reference

    @property
    def network_provider_scope(self):
        return self._network_provider_scope
    
    @network_provider_scope.setter
    def network_provider_scope(self, network_provider_scope):
        self._network_provider_scope = network_provider_scope

    @property
    def version(self):
        return self._version
    
    @version.setter
    def version(self, version):
        self._version = version

    @property
    def proxy_configuration_reference(self):
        return self._proxy_configuration_reference
    
    @proxy_configuration_reference.setter
    def proxy_configuration_reference(self, proxy_configuration_reference):
        self._proxy_configuration_reference = proxy_configuration_reference


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NsxTManagerType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
