"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..v_cloud_extensible_type import VCloudExtensibleType


class NotificationType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'list[LinkType]',
        'entity_link': 'list[EntityLinkType]',
        'timestamp': 'str',
        'operation_success': 'bool',
        'type': 'str',
        'event_id': 'str'
    }

    attribute_map = {
        'link': 'link',
        'entity_link': 'entityLink',
        'timestamp': 'timestamp',
        'operation_success': 'operationSuccess',
        'type': 'type',
        'event_id': 'eventId'
    }

    def __init__(self, link=None,entity_link=None,timestamp=None,operation_success=None,type=None,event_id=None):
        self._link = None
        self._entity_link = None
        self._timestamp = None
        self._operation_success = None
        self._type = None
        self._event_id = None

        if link is not None:
            self.link = link
        if entity_link is not None:
            self.entity_link = entity_link
        if timestamp is not None:
            self.timestamp = timestamp
        if operation_success is not None:
            self.operation_success = operation_success
        if type is not None:
            self.type = type
        if event_id is not None:
            self.event_id = event_id

    @property
    def link(self):
        return self._link
    
    @link.setter
    def link(self, link):
        self._link = link

    @property
    def entity_link(self):
        return self._entity_link
    
    @entity_link.setter
    def entity_link(self, entity_link):
        self._entity_link = entity_link

    @property
    def timestamp(self):
        return self._timestamp
    
    @timestamp.setter
    def timestamp(self, timestamp):
        self._timestamp = timestamp

    @property
    def operation_success(self):
        return self._operation_success
    
    @operation_success.setter
    def operation_success(self, operation_success):
        self._operation_success = operation_success

    @property
    def type(self):
        return self._type
    
    @type.setter
    def type(self, type):
        self._type = type

    @property
    def event_id(self):
        return self._event_id
    
    @event_id.setter
    def event_id(self, event_id):
        self._event_id = event_id


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NotificationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
