"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class LicensingVirtualMachineType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vim_object_ref': 'VimObjectRefType',
        'cpu': 'int',
        'memory': 'int'
    }

    attribute_map = {
        'vim_object_ref': 'vimObjectRef',
        'cpu': 'cpu',
        'memory': 'memory'
    }

    def __init__(self, vim_object_ref=None,cpu=None,memory=None):
        self._vim_object_ref = None
        self._cpu = None
        self._memory = None

        if vim_object_ref is not None:
            self.vim_object_ref = vim_object_ref
        if cpu is not None:
            self.cpu = cpu
        if memory is not None:
            self.memory = memory

    @property
    def vim_object_ref(self):
        return self._vim_object_ref
    
    @vim_object_ref.setter
    def vim_object_ref(self, vim_object_ref):
        self._vim_object_ref = vim_object_ref

    @property
    def cpu(self):
        return self._cpu
    
    @cpu.setter
    def cpu(self, cpu):
        self._cpu = cpu

    @property
    def memory(self):
        return self._memory
    
    @memory.setter
    def memory(self, memory):
        self._memory = memory


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LicensingVirtualMachineType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
