"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..entity_type import EntityType


class AdminApiDefinitionType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'entry_point': 'str',
        'namespace': 'str',
        'api_vendor': 'str',
        'supported_api_versions': 'VersionsType',
        'files': 'AdminFileDescriptorsType'
    }

    attribute_map = {
        'entry_point': 'entryPoint',
        'namespace': 'namespace',
        'api_vendor': 'apiVendor',
        'supported_api_versions': 'supportedApiVersions',
        'files': 'files'
    }

    def __init__(self, entry_point=None,namespace=None,api_vendor=None,supported_api_versions=None,files=None):
        self._entry_point = None
        self._namespace = None
        self._api_vendor = None
        self._supported_api_versions = None
        self._files = None

        if entry_point is not None:
            self.entry_point = entry_point
        if namespace is not None:
            self.namespace = namespace
        if api_vendor is not None:
            self.api_vendor = api_vendor
        if supported_api_versions is not None:
            self.supported_api_versions = supported_api_versions
        if files is not None:
            self.files = files

    @property
    def entry_point(self):
        return self._entry_point
    
    @entry_point.setter
    def entry_point(self, entry_point):
        self._entry_point = entry_point

    @property
    def namespace(self):
        return self._namespace
    
    @namespace.setter
    def namespace(self, namespace):
        self._namespace = namespace

    @property
    def api_vendor(self):
        return self._api_vendor
    
    @api_vendor.setter
    def api_vendor(self, api_vendor):
        self._api_vendor = api_vendor

    @property
    def supported_api_versions(self):
        return self._supported_api_versions
    
    @supported_api_versions.setter
    def supported_api_versions(self, supported_api_versions):
        self._supported_api_versions = supported_api_versions

    @property
    def files(self):
        return self._files
    
    @files.setter
    def files(self, files):
        self._files = files


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdminApiDefinitionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
