"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class DiskMoveParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vdc': 'ReferenceType',
        'storage_policy': 'ReferenceType',
        'iops': 'int'
    }

    attribute_map = {
        'vdc': 'vdc',
        'storage_policy': 'storagePolicy',
        'iops': 'iops'
    }

    def __init__(self, vdc=None,storage_policy=None,iops=None):
        self._vdc = None
        self._storage_policy = None
        self._iops = None

        if vdc is not None:
            self.vdc = vdc
        if storage_policy is not None:
            self.storage_policy = storage_policy
        if iops is not None:
            self.iops = iops

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def storage_policy(self):
        return self._storage_policy
    
    @storage_policy.setter
    def storage_policy(self, storage_policy):
        self._storage_policy = storage_policy

    @property
    def iops(self):
        return self._iops
    
    @iops.setter
    def iops(self, iops):
        self._iops = iops


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DiskMoveParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
