"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class DeployVAppParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'power_on': 'bool',
        'deployment_lease_seconds': 'int',
        'force_customization': 'bool'
    }

    attribute_map = {
        'power_on': 'powerOn',
        'deployment_lease_seconds': 'deploymentLeaseSeconds',
        'force_customization': 'forceCustomization'
    }

    def __init__(self, power_on=None,deployment_lease_seconds=None,force_customization=None):
        self._power_on = None
        self._deployment_lease_seconds = None
        self._force_customization = None

        if power_on is not None:
            self.power_on = power_on
        if deployment_lease_seconds is not None:
            self.deployment_lease_seconds = deployment_lease_seconds
        if force_customization is not None:
            self.force_customization = force_customization

    @property
    def power_on(self):
        return self._power_on
    
    @power_on.setter
    def power_on(self, power_on):
        self._power_on = power_on

    @property
    def deployment_lease_seconds(self):
        return self._deployment_lease_seconds
    
    @deployment_lease_seconds.setter
    def deployment_lease_seconds(self, deployment_lease_seconds):
        self._deployment_lease_seconds = deployment_lease_seconds

    @property
    def force_customization(self):
        return self._force_customization
    
    @force_customization.setter
    def force_customization(self, force_customization):
        self._force_customization = force_customization


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeployVAppParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
