"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .params_type import ParamsType


class CreateVdcParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allocation_model': 'str',
        'compute_capacity': 'ComputeCapacityType',
        'nic_quota': 'int',
        'network_quota': 'int',
        'vm_quota': 'int',
        'is_enabled': 'bool',
        'vdc_storage_profile': 'list[VdcStorageProfileParamsType]',
        'resource_guaranteed_memory': 'int',
        'resource_guaranteed_cpu': 'int',
        'v_cpu_in_mhz': 'int',
        'is_thin_provision': 'bool',
        'network_pool_reference': 'ReferenceType',
        'provider_vdc_reference': 'ReferenceType',
        'resource_pool_refs': 'VimObjectRefsType',
        'uses_fast_provisioning': 'bool',
        'over_commit_allowed': 'bool',
        'vm_discovery_enabled': 'bool',
        'default_compute_policy': 'ReferenceType',
        'max_compute_policy': 'ReferenceType',
        'is_elastic': 'bool',
        'include_memory_overhead': 'bool'
    }

    attribute_map = {
        'allocation_model': 'allocationModel',
        'compute_capacity': 'computeCapacity',
        'nic_quota': 'nicQuota',
        'network_quota': 'networkQuota',
        'vm_quota': 'vmQuota',
        'is_enabled': 'isEnabled',
        'vdc_storage_profile': 'vdcStorageProfile',
        'resource_guaranteed_memory': 'resourceGuaranteedMemory',
        'resource_guaranteed_cpu': 'resourceGuaranteedCpu',
        'v_cpu_in_mhz': 'vCpuInMhz',
        'is_thin_provision': 'isThinProvision',
        'network_pool_reference': 'networkPoolReference',
        'provider_vdc_reference': 'providerVdcReference',
        'resource_pool_refs': 'resourcePoolRefs',
        'uses_fast_provisioning': 'usesFastProvisioning',
        'over_commit_allowed': 'overCommitAllowed',
        'vm_discovery_enabled': 'vmDiscoveryEnabled',
        'default_compute_policy': 'defaultComputePolicy',
        'max_compute_policy': 'maxComputePolicy',
        'is_elastic': 'isElastic',
        'include_memory_overhead': 'includeMemoryOverhead'
    }

    def __init__(self, allocation_model=None,compute_capacity=None,nic_quota=None,network_quota=None,vm_quota=None,is_enabled=None,vdc_storage_profile=None,resource_guaranteed_memory=None,resource_guaranteed_cpu=None,v_cpu_in_mhz=None,is_thin_provision=None,network_pool_reference=None,provider_vdc_reference=None,resource_pool_refs=None,uses_fast_provisioning=None,over_commit_allowed=None,vm_discovery_enabled=None,default_compute_policy=None,max_compute_policy=None,is_elastic=None,include_memory_overhead=None):
        self._allocation_model = None
        self._compute_capacity = None
        self._nic_quota = None
        self._network_quota = None
        self._vm_quota = None
        self._is_enabled = None
        self._vdc_storage_profile = None
        self._resource_guaranteed_memory = None
        self._resource_guaranteed_cpu = None
        self._v_cpu_in_mhz = None
        self._is_thin_provision = None
        self._network_pool_reference = None
        self._provider_vdc_reference = None
        self._resource_pool_refs = None
        self._uses_fast_provisioning = None
        self._over_commit_allowed = None
        self._vm_discovery_enabled = None
        self._default_compute_policy = None
        self._max_compute_policy = None
        self._is_elastic = None
        self._include_memory_overhead = None

        if allocation_model is not None:
            self.allocation_model = allocation_model
        if compute_capacity is not None:
            self.compute_capacity = compute_capacity
        if nic_quota is not None:
            self.nic_quota = nic_quota
        if network_quota is not None:
            self.network_quota = network_quota
        if vm_quota is not None:
            self.vm_quota = vm_quota
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if vdc_storage_profile is not None:
            self.vdc_storage_profile = vdc_storage_profile
        if resource_guaranteed_memory is not None:
            self.resource_guaranteed_memory = resource_guaranteed_memory
        if resource_guaranteed_cpu is not None:
            self.resource_guaranteed_cpu = resource_guaranteed_cpu
        if v_cpu_in_mhz is not None:
            self.v_cpu_in_mhz = v_cpu_in_mhz
        if is_thin_provision is not None:
            self.is_thin_provision = is_thin_provision
        if network_pool_reference is not None:
            self.network_pool_reference = network_pool_reference
        if provider_vdc_reference is not None:
            self.provider_vdc_reference = provider_vdc_reference
        if resource_pool_refs is not None:
            self.resource_pool_refs = resource_pool_refs
        if uses_fast_provisioning is not None:
            self.uses_fast_provisioning = uses_fast_provisioning
        if over_commit_allowed is not None:
            self.over_commit_allowed = over_commit_allowed
        if vm_discovery_enabled is not None:
            self.vm_discovery_enabled = vm_discovery_enabled
        if default_compute_policy is not None:
            self.default_compute_policy = default_compute_policy
        if max_compute_policy is not None:
            self.max_compute_policy = max_compute_policy
        if is_elastic is not None:
            self.is_elastic = is_elastic
        if include_memory_overhead is not None:
            self.include_memory_overhead = include_memory_overhead

    @property
    def allocation_model(self):
        return self._allocation_model
    
    @allocation_model.setter
    def allocation_model(self, allocation_model):
        self._allocation_model = allocation_model

    @property
    def compute_capacity(self):
        return self._compute_capacity
    
    @compute_capacity.setter
    def compute_capacity(self, compute_capacity):
        self._compute_capacity = compute_capacity

    @property
    def nic_quota(self):
        return self._nic_quota
    
    @nic_quota.setter
    def nic_quota(self, nic_quota):
        self._nic_quota = nic_quota

    @property
    def network_quota(self):
        return self._network_quota
    
    @network_quota.setter
    def network_quota(self, network_quota):
        self._network_quota = network_quota

    @property
    def vm_quota(self):
        return self._vm_quota
    
    @vm_quota.setter
    def vm_quota(self, vm_quota):
        self._vm_quota = vm_quota

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def vdc_storage_profile(self):
        return self._vdc_storage_profile
    
    @vdc_storage_profile.setter
    def vdc_storage_profile(self, vdc_storage_profile):
        self._vdc_storage_profile = vdc_storage_profile

    @property
    def resource_guaranteed_memory(self):
        return self._resource_guaranteed_memory
    
    @resource_guaranteed_memory.setter
    def resource_guaranteed_memory(self, resource_guaranteed_memory):
        self._resource_guaranteed_memory = resource_guaranteed_memory

    @property
    def resource_guaranteed_cpu(self):
        return self._resource_guaranteed_cpu
    
    @resource_guaranteed_cpu.setter
    def resource_guaranteed_cpu(self, resource_guaranteed_cpu):
        self._resource_guaranteed_cpu = resource_guaranteed_cpu

    @property
    def v_cpu_in_mhz(self):
        return self._v_cpu_in_mhz
    
    @v_cpu_in_mhz.setter
    def v_cpu_in_mhz(self, v_cpu_in_mhz):
        self._v_cpu_in_mhz = v_cpu_in_mhz

    @property
    def is_thin_provision(self):
        return self._is_thin_provision
    
    @is_thin_provision.setter
    def is_thin_provision(self, is_thin_provision):
        self._is_thin_provision = is_thin_provision

    @property
    def network_pool_reference(self):
        return self._network_pool_reference
    
    @network_pool_reference.setter
    def network_pool_reference(self, network_pool_reference):
        self._network_pool_reference = network_pool_reference

    @property
    def provider_vdc_reference(self):
        return self._provider_vdc_reference
    
    @provider_vdc_reference.setter
    def provider_vdc_reference(self, provider_vdc_reference):
        self._provider_vdc_reference = provider_vdc_reference

    @property
    def resource_pool_refs(self):
        return self._resource_pool_refs
    
    @resource_pool_refs.setter
    def resource_pool_refs(self, resource_pool_refs):
        self._resource_pool_refs = resource_pool_refs

    @property
    def uses_fast_provisioning(self):
        return self._uses_fast_provisioning
    
    @uses_fast_provisioning.setter
    def uses_fast_provisioning(self, uses_fast_provisioning):
        self._uses_fast_provisioning = uses_fast_provisioning

    @property
    def over_commit_allowed(self):
        return self._over_commit_allowed
    
    @over_commit_allowed.setter
    def over_commit_allowed(self, over_commit_allowed):
        self._over_commit_allowed = over_commit_allowed

    @property
    def vm_discovery_enabled(self):
        return self._vm_discovery_enabled
    
    @vm_discovery_enabled.setter
    def vm_discovery_enabled(self, vm_discovery_enabled):
        self._vm_discovery_enabled = vm_discovery_enabled

    @property
    def default_compute_policy(self):
        return self._default_compute_policy
    
    @default_compute_policy.setter
    def default_compute_policy(self, default_compute_policy):
        self._default_compute_policy = default_compute_policy

    @property
    def max_compute_policy(self):
        return self._max_compute_policy
    
    @max_compute_policy.setter
    def max_compute_policy(self, max_compute_policy):
        self._max_compute_policy = max_compute_policy

    @property
    def is_elastic(self):
        return self._is_elastic
    
    @is_elastic.setter
    def is_elastic(self, is_elastic):
        self._is_elastic = is_elastic

    @property
    def include_memory_overhead(self):
        return self._include_memory_overhead
    
    @include_memory_overhead.setter
    def include_memory_overhead(self, include_memory_overhead):
        self._include_memory_overhead = include_memory_overhead


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateVdcParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
