"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class ControlAccessParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_shared_to_everyone': 'bool',
        'everyone_access_level': 'str',
        'access_settings': 'AccessSettingsType'
    }

    attribute_map = {
        'is_shared_to_everyone': 'isSharedToEveryone',
        'everyone_access_level': 'everyoneAccessLevel',
        'access_settings': 'accessSettings'
    }

    def __init__(self, is_shared_to_everyone=None,everyone_access_level=None,access_settings=None):
        self._is_shared_to_everyone = None
        self._everyone_access_level = None
        self._access_settings = None

        if is_shared_to_everyone is not None:
            self.is_shared_to_everyone = is_shared_to_everyone
        if everyone_access_level is not None:
            self.everyone_access_level = everyone_access_level
        if access_settings is not None:
            self.access_settings = access_settings

    @property
    def is_shared_to_everyone(self):
        return self._is_shared_to_everyone
    
    @is_shared_to_everyone.setter
    def is_shared_to_everyone(self, is_shared_to_everyone):
        self._is_shared_to_everyone = is_shared_to_everyone

    @property
    def everyone_access_level(self):
        return self._everyone_access_level
    
    @everyone_access_level.setter
    def everyone_access_level(self, everyone_access_level):
        self._everyone_access_level = everyone_access_level

    @property
    def access_settings(self):
        return self._access_settings
    
    @access_settings.setter
    def access_settings(self, access_settings):
        self._access_settings = access_settings


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ControlAccessParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
