"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class ComputePolicyType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vm_placement_policy': 'ReferenceType',
        'vm_placement_policy_final': 'bool',
        'vm_sizing_policy': 'ReferenceType',
        'vm_sizing_policy_final': 'bool'
    }

    attribute_map = {
        'vm_placement_policy': 'vmPlacementPolicy',
        'vm_placement_policy_final': 'vmPlacementPolicyFinal',
        'vm_sizing_policy': 'vmSizingPolicy',
        'vm_sizing_policy_final': 'vmSizingPolicyFinal'
    }

    def __init__(self, vm_placement_policy=None,vm_placement_policy_final=None,vm_sizing_policy=None,vm_sizing_policy_final=None):
        self._vm_placement_policy = None
        self._vm_placement_policy_final = None
        self._vm_sizing_policy = None
        self._vm_sizing_policy_final = None

        if vm_placement_policy is not None:
            self.vm_placement_policy = vm_placement_policy
        if vm_placement_policy_final is not None:
            self.vm_placement_policy_final = vm_placement_policy_final
        if vm_sizing_policy is not None:
            self.vm_sizing_policy = vm_sizing_policy
        if vm_sizing_policy_final is not None:
            self.vm_sizing_policy_final = vm_sizing_policy_final

    @property
    def vm_placement_policy(self):
        return self._vm_placement_policy
    
    @vm_placement_policy.setter
    def vm_placement_policy(self, vm_placement_policy):
        self._vm_placement_policy = vm_placement_policy

    @property
    def vm_placement_policy_final(self):
        return self._vm_placement_policy_final
    
    @vm_placement_policy_final.setter
    def vm_placement_policy_final(self, vm_placement_policy_final):
        self._vm_placement_policy_final = vm_placement_policy_final

    @property
    def vm_sizing_policy(self):
        return self._vm_sizing_policy
    
    @vm_sizing_policy.setter
    def vm_sizing_policy(self, vm_sizing_policy):
        self._vm_sizing_policy = vm_sizing_policy

    @property
    def vm_sizing_policy_final(self):
        return self._vm_sizing_policy_final
    
    @vm_sizing_policy_final.setter
    def vm_sizing_policy_final(self, vm_sizing_policy_final):
        self._vm_sizing_policy_final = vm_sizing_policy_final


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ComputePolicyType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
