"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class CatalogItemType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'entity': 'ReferenceType',
        '_property': 'list[PropertyType]',
        'date_created': 'str',
        'version_number': 'int',
        'size': 'int'
    }

    attribute_map = {
        'entity': 'entity',
        '_property': '_property',
        'date_created': 'dateCreated',
        'version_number': 'versionNumber',
        'size': 'size'
    }

    def __init__(self, entity=None,_property=None,date_created=None,version_number=None,size=None):
        self._entity = None
        self.__property = None
        self._date_created = None
        self._version_number = None
        self._size = None

        if entity is not None:
            self.entity = entity
        if _property is not None:
            self._property = _property
        if date_created is not None:
            self.date_created = date_created
        if version_number is not None:
            self.version_number = version_number
        if size is not None:
            self.size = size

    @property
    def entity(self):
        return self._entity
    
    @entity.setter
    def entity(self, entity):
        self._entity = entity

    @property
    def _property(self):
        return self.__property
    
    @_property.setter
    def _property(self, _property):
        self.__property = _property

    @property
    def date_created(self):
        return self._date_created
    
    @date_created.setter
    def date_created(self, date_created):
        self._date_created = date_created

    @property
    def version_number(self):
        return self._version_number
    
    @version_number.setter
    def version_number(self, version_number):
        self._version_number = version_number

    @property
    def size(self):
        return self._size
    
    @size.setter
    def size(self, size):
        self._size = size


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CatalogItemType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
