"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .capacity_type import CapacityType


class CapacityWithUsageType(CapacityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'reserved': 'int',
        'used': 'int',
        'overhead': 'int',
        'reservation_used': 'int'
    }

    attribute_map = {
        'reserved': 'reserved',
        'used': 'used',
        'overhead': 'overhead',
        'reservation_used': 'reservationUsed'
    }

    def __init__(self, reserved=None,used=None,overhead=None,reservation_used=None):
        self._reserved = None
        self._used = None
        self._overhead = None
        self._reservation_used = None

        if reserved is not None:
            self.reserved = reserved
        if used is not None:
            self.used = used
        if overhead is not None:
            self.overhead = overhead
        if reservation_used is not None:
            self.reservation_used = reservation_used

    @property
    def reserved(self):
        return self._reserved
    
    @reserved.setter
    def reserved(self, reserved):
        self._reserved = reserved

    @property
    def used(self):
        return self._used
    
    @used.setter
    def used(self, used):
        self._used = used

    @property
    def overhead(self):
        return self._overhead
    
    @overhead.setter
    def overhead(self, overhead):
        self._overhead = overhead

    @property
    def reservation_used(self):
        return self._reservation_used
    
    @reservation_used.setter
    def reservation_used(self, reservation_used):
        self._reservation_used = reservation_used


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CapacityWithUsageType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
