"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class AuthorizedLocationType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'location_id': 'str',
        'location_name': 'str',
        'site_name': 'str',
        'org_name': 'str',
        'rest_api_endpoint': 'str',
        'ui_endpoint': 'str',
        'use_multisite_token': 'bool',
        'auth_context': 'str',
        'api_version': 'str'
    }

    attribute_map = {
        'location_id': 'locationId',
        'location_name': 'locationName',
        'site_name': 'siteName',
        'org_name': 'orgName',
        'rest_api_endpoint': 'restApiEndpoint',
        'ui_endpoint': 'uiEndpoint',
        'use_multisite_token': 'useMultisiteToken',
        'auth_context': 'authContext',
        'api_version': 'apiVersion'
    }

    def __init__(self, location_id=None,location_name=None,site_name=None,org_name=None,rest_api_endpoint=None,ui_endpoint=None,use_multisite_token=None,auth_context=None,api_version=None):
        self._location_id = None
        self._location_name = None
        self._site_name = None
        self._org_name = None
        self._rest_api_endpoint = None
        self._ui_endpoint = None
        self._use_multisite_token = None
        self._auth_context = None
        self._api_version = None

        if location_id is not None:
            self.location_id = location_id
        if location_name is not None:
            self.location_name = location_name
        if site_name is not None:
            self.site_name = site_name
        if org_name is not None:
            self.org_name = org_name
        if rest_api_endpoint is not None:
            self.rest_api_endpoint = rest_api_endpoint
        if ui_endpoint is not None:
            self.ui_endpoint = ui_endpoint
        if use_multisite_token is not None:
            self.use_multisite_token = use_multisite_token
        if auth_context is not None:
            self.auth_context = auth_context
        if api_version is not None:
            self.api_version = api_version

    @property
    def location_id(self):
        return self._location_id
    
    @location_id.setter
    def location_id(self, location_id):
        self._location_id = location_id

    @property
    def location_name(self):
        return self._location_name
    
    @location_name.setter
    def location_name(self, location_name):
        self._location_name = location_name

    @property
    def site_name(self):
        return self._site_name
    
    @site_name.setter
    def site_name(self, site_name):
        self._site_name = site_name

    @property
    def org_name(self):
        return self._org_name
    
    @org_name.setter
    def org_name(self, org_name):
        self._org_name = org_name

    @property
    def rest_api_endpoint(self):
        return self._rest_api_endpoint
    
    @rest_api_endpoint.setter
    def rest_api_endpoint(self, rest_api_endpoint):
        self._rest_api_endpoint = rest_api_endpoint

    @property
    def ui_endpoint(self):
        return self._ui_endpoint
    
    @ui_endpoint.setter
    def ui_endpoint(self, ui_endpoint):
        self._ui_endpoint = ui_endpoint

    @property
    def use_multisite_token(self):
        return self._use_multisite_token
    
    @use_multisite_token.setter
    def use_multisite_token(self, use_multisite_token):
        self._use_multisite_token = use_multisite_token

    @property
    def auth_context(self):
        return self._auth_context
    
    @auth_context.setter
    def auth_context(self, auth_context):
        self._auth_context = auth_context

    @property
    def api_version(self):
        return self._api_version
    
    @api_version.setter
    def api_version(self, api_version):
        self._api_version = api_version


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuthorizedLocationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
