"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class AllocatedIpAddressType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ip_address': 'str',
        'is_deployed': 'bool',
        'allocation_type': 'str'
    }

    attribute_map = {
        'ip_address': 'ipAddress',
        'is_deployed': 'isDeployed',
        'allocation_type': 'allocationType'
    }

    def __init__(self, ip_address=None,is_deployed=None,allocation_type=None):
        self._ip_address = None
        self._is_deployed = None
        self._allocation_type = None

        if ip_address is not None:
            self.ip_address = ip_address
        if is_deployed is not None:
            self.is_deployed = is_deployed
        if allocation_type is not None:
            self.allocation_type = allocation_type

    @property
    def ip_address(self):
        return self._ip_address
    
    @ip_address.setter
    def ip_address(self, ip_address):
        self._ip_address = ip_address

    @property
    def is_deployed(self):
        return self._is_deployed
    
    @is_deployed.setter
    def is_deployed(self, is_deployed):
        self._is_deployed = is_deployed

    @property
    def allocation_type(self):
        return self._allocation_type
    
    @allocation_type.setter
    def allocation_type(self, allocation_type):
        self._allocation_type = allocation_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AllocatedIpAddressType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
