"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .identifiable_resource_type import IdentifiableResourceType


class AffinityRuleType(IdentifiableResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'is_enabled': 'bool',
        'is_mandatory': 'bool',
        'polarity': 'str'
    }

    attribute_map = {
        'name': 'name',
        'is_enabled': 'isEnabled',
        'is_mandatory': 'isMandatory',
        'polarity': 'polarity'
    }

    def __init__(self, name=None,is_enabled=None,is_mandatory=None,polarity=None):
        self._name = None
        self._is_enabled = None
        self._is_mandatory = None
        self._polarity = None

        if name is not None:
            self.name = name
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_mandatory is not None:
            self.is_mandatory = is_mandatory
        if polarity is not None:
            self.polarity = polarity

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def is_mandatory(self):
        return self._is_mandatory
    
    @is_mandatory.setter
    def is_mandatory(self, is_mandatory):
        self._is_mandatory = is_mandatory

    @property
    def polarity(self):
        return self._polarity
    
    @polarity.setter
    def polarity(self, polarity):
        self._polarity = polarity


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AffinityRuleType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
