"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_entity_type import ResourceEntityType


class AbstractVAppType(ResourceEntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'v_app_parent': 'ReferenceType',
        'section': 'list[SectionType]',
        'date_created': 'str',
        'deployed': 'bool'
    }

    attribute_map = {
        'v_app_parent': 'vAppParent',
        'section': 'section',
        'date_created': 'dateCreated',
        'deployed': 'deployed'
    }

    def __init__(self, v_app_parent=None,section=None,date_created=None,deployed=None):
        self._v_app_parent = None
        self._section = None
        self._date_created = None
        self._deployed = None

        if v_app_parent is not None:
            self.v_app_parent = v_app_parent
        if section is not None:
            self.section = section
        if date_created is not None:
            self.date_created = date_created
        if deployed is not None:
            self.deployed = deployed

    @property
    def v_app_parent(self):
        return self._v_app_parent
    
    @v_app_parent.setter
    def v_app_parent(self, v_app_parent):
        self._v_app_parent = v_app_parent

    @property
    def section(self):
        return self._section
    
    @section.setter
    def section(self, section):
        self._section = section

    @property
    def date_created(self):
        return self._date_created
    
    @date_created.setter
    def date_created(self, date_created):
        self._date_created = date_created

    @property
    def deployed(self):
        return self._deployed
    
    @deployed.setter
    def deployed(self, deployed):
        self._deployed = deployed


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AbstractVAppType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
