"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class VersionInfoType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'version': 'str',
        'login_url': 'str',
        'provider_login_url': 'str',
        'media_type_mapping': 'list[MediaTypeMappingType]',
        'any': 'list[object]',
        'deprecated': 'bool',
        'other_attributes': 'object'
    }

    attribute_map = {
        'version': 'version',
        'login_url': 'loginUrl',
        'provider_login_url': 'providerLoginUrl',
        'media_type_mapping': 'mediaTypeMapping',
        'any': 'any',
        'deprecated': 'deprecated',
        'other_attributes': 'otherAttributes'
    }

    def __init__(self, version=None,login_url=None,provider_login_url=None,media_type_mapping=None,any=None,deprecated=None,other_attributes=None):
        self._version = None
        self._login_url = None
        self._provider_login_url = None
        self._media_type_mapping = None
        self._any = None
        self._deprecated = None
        self._other_attributes = None

        if version is not None:
            self.version = version
        if login_url is not None:
            self.login_url = login_url
        if provider_login_url is not None:
            self.provider_login_url = provider_login_url
        if media_type_mapping is not None:
            self.media_type_mapping = media_type_mapping
        if any is not None:
            self.any = any
        if deprecated is not None:
            self.deprecated = deprecated
        if other_attributes is not None:
            self.other_attributes = other_attributes

    @property
    def version(self):
        return self._version
    
    @version.setter
    def version(self, version):
        self._version = version

    @property
    def login_url(self):
        return self._login_url
    
    @login_url.setter
    def login_url(self, login_url):
        self._login_url = login_url

    @property
    def provider_login_url(self):
        return self._provider_login_url
    
    @provider_login_url.setter
    def provider_login_url(self, provider_login_url):
        self._provider_login_url = provider_login_url

    @property
    def media_type_mapping(self):
        return self._media_type_mapping
    
    @media_type_mapping.setter
    def media_type_mapping(self, media_type_mapping):
        self._media_type_mapping = media_type_mapping

    @property
    def any(self):
        return self._any
    
    @any.setter
    def any(self, any):
        self._any = any

    @property
    def deprecated(self):
        return self._deprecated
    
    @deprecated.setter
    def deprecated(self, deprecated):
        self._deprecated = deprecated

    @property
    def other_attributes(self):
        return self._other_attributes
    
    @other_attributes.setter
    def other_attributes(self, other_attributes):
        self._other_attributes = other_attributes


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VersionInfoType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
