"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class VirtualDiskDescType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'any': 'list[object]',
        'disk_id': 'str',
        'file_ref': 'str',
        'capacity': 'str',
        'capacity_allocation_units': 'str',
        'format': 'str',
        'populated_size': 'int',
        'parent_ref': 'str',
        'other_attributes': 'object'
    }

    attribute_map = {
        'any': 'any',
        'disk_id': 'diskId',
        'file_ref': 'fileRef',
        'capacity': 'capacity',
        'capacity_allocation_units': 'capacityAllocationUnits',
        'format': 'format',
        'populated_size': 'populatedSize',
        'parent_ref': 'parentRef',
        'other_attributes': 'otherAttributes'
    }

    def __init__(self, any=None,disk_id=None,file_ref=None,capacity=None,capacity_allocation_units=None,format=None,populated_size=None,parent_ref=None,other_attributes=None):
        self._any = None
        self._disk_id = None
        self._file_ref = None
        self._capacity = None
        self._capacity_allocation_units = None
        self._format = None
        self._populated_size = None
        self._parent_ref = None
        self._other_attributes = None

        if any is not None:
            self.any = any
        if disk_id is not None:
            self.disk_id = disk_id
        if file_ref is not None:
            self.file_ref = file_ref
        if capacity is not None:
            self.capacity = capacity
        if capacity_allocation_units is not None:
            self.capacity_allocation_units = capacity_allocation_units
        if format is not None:
            self.format = format
        if populated_size is not None:
            self.populated_size = populated_size
        if parent_ref is not None:
            self.parent_ref = parent_ref
        if other_attributes is not None:
            self.other_attributes = other_attributes

    @property
    def any(self):
        return self._any
    
    @any.setter
    def any(self, any):
        self._any = any

    @property
    def disk_id(self):
        return self._disk_id
    
    @disk_id.setter
    def disk_id(self, disk_id):
        self._disk_id = disk_id

    @property
    def file_ref(self):
        return self._file_ref
    
    @file_ref.setter
    def file_ref(self, file_ref):
        self._file_ref = file_ref

    @property
    def capacity(self):
        return self._capacity
    
    @capacity.setter
    def capacity(self, capacity):
        self._capacity = capacity

    @property
    def capacity_allocation_units(self):
        return self._capacity_allocation_units
    
    @capacity_allocation_units.setter
    def capacity_allocation_units(self, capacity_allocation_units):
        self._capacity_allocation_units = capacity_allocation_units

    @property
    def format(self):
        return self._format
    
    @format.setter
    def format(self, format):
        self._format = format

    @property
    def populated_size(self):
        return self._populated_size
    
    @populated_size.setter
    def populated_size(self, populated_size):
        self._populated_size = populated_size

    @property
    def parent_ref(self):
        return self._parent_ref
    
    @parent_ref.setter
    def parent_ref(self, parent_ref):
        self._parent_ref = parent_ref

    @property
    def other_attributes(self):
        return self._other_attributes
    
    @other_attributes.setter
    def other_attributes(self, other_attributes):
        self._other_attributes = other_attributes


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualDiskDescType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
