"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class EnvelopeType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'references': 'ReferencesType',
        'section': 'list[SectionType]',
        'content': 'ContentType',
        'strings': 'list[StringsType]',
        'lang': 'str',
        'other_attributes': 'object'
    }

    attribute_map = {
        'references': 'references',
        'section': 'section',
        'content': 'content',
        'strings': 'strings',
        'lang': 'lang',
        'other_attributes': 'otherAttributes'
    }

    def __init__(self, references=None,section=None,content=None,strings=None,lang=None,other_attributes=None):
        self._references = None
        self._section = None
        self._content = None
        self._strings = None
        self._lang = None
        self._other_attributes = None

        if references is not None:
            self.references = references
        if section is not None:
            self.section = section
        if content is not None:
            self.content = content
        if strings is not None:
            self.strings = strings
        if lang is not None:
            self.lang = lang
        if other_attributes is not None:
            self.other_attributes = other_attributes

    @property
    def references(self):
        return self._references
    
    @references.setter
    def references(self, references):
        self._references = references

    @property
    def section(self):
        return self._section
    
    @section.setter
    def section(self, section):
        self._section = section

    @property
    def content(self):
        return self._content
    
    @content.setter
    def content(self, content):
        self._content = content

    @property
    def strings(self):
        return self._strings
    
    @strings.setter
    def strings(self, strings):
        self._strings = strings

    @property
    def lang(self):
        return self._lang
    
    @lang.setter
    def lang(self, lang):
        self._lang = lang

    @property
    def other_attributes(self):
        return self._other_attributes
    
    @other_attributes.setter
    def other_attributes(self, other_attributes):
        self._other_attributes = other_attributes


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnvelopeType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
