"""
Documentation build configuration file for the `proc` package.
"""

# Author: Peter Odding <peter@peterodding.com>
# Last Change: April 26, 2020
# URL: https://proc.readthedocs.io

import os
import sys

# Add the 'proc' source distribution's root directory to the module search path.
sys.path.insert(0, os.path.abspath('..'))

# -- General configuration -----------------------------------------------------

# Sphinx extension module names.
extensions = [
    'sphinx.ext.doctest',
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'humanfriendly.sphinx',
    'property_manager.sphinx',
]

# Paths that contain templates, relative to this directory.
templates_path = ['templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'proc'
copyright = '2020, Peter Odding'

# Find the package version and make it the release.
from proc import __version__ as proc_version

# The short X.Y version (replacement for |version|).
version = '.'.join(proc_version.split('.')[:2])

# The full version, including alpha/beta/rc tags (replacement for |release|).
release = proc_version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['build']

# If true, '()' will be appended to :func: etc. cross-reference text.
add_function_parentheses = True

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# References to external documentation.
intersphinx_mapping = dict(
    python2=('https://docs.python.org/2', None),
    python3=('https://docs.python.org/3', None),
    executor=('https://executor.readthedocs.io/en/latest', None),
    humanfriendly=('https://humanfriendly.readthedocs.io/en/latest', None),
    propertymanager=('https://property-manager.readthedocs.io/en/latest', None),
)

# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'nature'
