"""Added initial tables

Revision ID: c5e78990adf6
Revises: b7dda7cf354c
Create Date: 2016-11-03 19:08:58.489098

"""

# revision identifiers, used by Alembic.
revision = "c5e78990adf6"
down_revision = "3aa82a9abe67"
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "PeekPluginInfo",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("name", sa.String(50), nullable=False),
        sa.Column("version", sa.String(40), nullable=False),
        sa.Column("creator", sa.String(), nullable=True),
        sa.Column("website", sa.String(), nullable=True),
        sa.Column("buildNumber", sa.String(), nullable=True),
        sa.Column("buildDate", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        schema="peek_logic_service",
    )
    op.create_index(
        "idx_PeekPluginInfo_NameVersion",
        "PeekPluginInfo",
        ["name", "version"],
        unique=True,
        schema="peek_logic_service",
    )
    op.create_table(
        "Setting",
        sa.Column("id", sa.Integer(), nullable=False, autoincrement=True),
        sa.Column("name", sa.String(50), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        schema="peek_logic_service",
    )
    op.create_table(
        "SettingProperty",
        sa.Column("id", sa.Integer(), nullable=False, autoincrement=True),
        sa.Column("settingId", sa.Integer(), nullable=False),
        sa.Column("key", sa.String(60), nullable=False),
        sa.Column("type", sa.String(length=16), nullable=True),
        sa.Column("int_value", sa.Integer(), nullable=True),
        sa.Column("char_value", sa.String(), nullable=True),
        sa.Column("boolean_value", sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(
            ["settingId"],
            ["peek_logic_service.Setting.id"],
        ),
        sa.PrimaryKeyConstraint("id", "settingId", "key"),
        schema="peek_logic_service",
    )
    op.create_index(
        "idx_SettingProperty_settingId",
        "SettingProperty",
        ["settingId"],
        unique=False,
        schema="peek_logic_service",
    )
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "idx_SettingProperty_settingId",
        table_name="SettingProperty",
        schema="peek_logic_service",
    )
    op.drop_table("SettingProperty", schema="peek_logic_service")
    op.drop_table("Setting", schema="peek_logic_service")
    op.drop_index(
        "idx_PeekPluginInfo_NameVersion",
        table_name="PeekPluginInfo",
        schema="peek_logic_service",
    )
    op.drop_table("PeekPluginInfo", schema="peek_logic_service")
    ### end Alembic commands ###
