import click

import sdccli.usecases.scanning.vulnerability as use_case


@click.group(name='bundle', short_help='Vulnerability bundle operations')
def bundle():
    pass


@bundle.command(name='list', short_help="Lists all the vulnerability exception bundles")
@click.pass_obj
def list_bundles(cnf):
    """
    Lists all the vulnerability exception bundles
    """
    try:
        res = use_case.list_vulnerability_exception_bundles(cnf.sdscanning)
        cnf.formatter.format(res, "vulnExceptionBundlesList")
    except Exception as ex:
        print(ex)


@bundle.command(name='add', short_help="Add a vulnerability exception bundle")
@click.argument('name', nargs=1)
@click.option('--description', nargs=1, help="The descprition of vulnerability exception bundle.")
@click.pass_obj
def add(cnf, name, description=""):
    try:
        res = use_case.add_vulnerability_exception_bundle(cnf.sdscanning, name, description)
        cnf.formatter.format(res, "vulnExceptionBundlesAdded")
    except Exception as ex:
        print(ex)


@bundle.command(name='get', short_help="Retrieves information from a vulneability exception bundle")
@click.argument('bundleid', nargs=1)
@click.pass_obj
def get(cnf, bundleid):
    """
    BUNDLEID: Bundle ID to retrieve info from
    """
    try:
        res = use_case.get_vulnerability_exception_bundle(cnf.sdscanning, bundleid)
        cnf.formatter.format(res, "vulnExceptionBundle")
    except Exception as ex:
        print(ex)

@bundle.command(name="del", short_help="Removes a vulnerability exception bundle")
@click.argument('bundleid', nargs=1)
@click.pass_obj
def delete(cnf, bundleid):
    """
    BUNDLEID: Bundle ID to remove
    """
    try:
        use_case.delete_vulnerability_exception_bundle(cnf.sdscanning, bundleid)
        print("Succeed")
    except Exception as ex:
        print(ex)