/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankTokenizer;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import java.io.Reader;

public class PennTreeReaderFactory
implements TreeReaderFactory {
    private final TreeFactory tf;
    private final TreeNormalizer tn;

    public PennTreeReaderFactory() {
        this(new LabeledScoredTreeFactory());
    }

    public PennTreeReaderFactory(TreeFactory tf) {
        this(tf, new TreeNormalizer());
    }

    public PennTreeReaderFactory(TreeNormalizer tn) {
        this(new LabeledScoredTreeFactory(), tn);
    }

    public PennTreeReaderFactory(TreeFactory tf, TreeNormalizer tn) {
        this.tf = tf;
        this.tn = tn;
    }

    @Override
    public TreeReader newTreeReader(Reader in) {
        return new PennTreeReader(in, this.tf, this.tn, new PennTreebankTokenizer(in));
    }
}

