/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.morph;

import edu.stanford.nlp.international.morph.MorphoFeatures;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class MorphoFeatureSpecification
implements Serializable {
    private static final long serialVersionUID = -5720683653931585664L;
    public static final String MORPHO_MARK = "~#";
    public static final String LEMMA_MARK = "|||";
    public static final String NO_ANALYSIS = "XXX";
    protected final Set<MorphoFeatureType> activeFeatures = Generics.newHashSet();

    public void activate(MorphoFeatureType feat) {
        this.activeFeatures.add(feat);
    }

    public boolean isActive(MorphoFeatureType feat) {
        return this.activeFeatures.contains((Object)feat);
    }

    public abstract List<String> getValues(MorphoFeatureType var1);

    public abstract MorphoFeatures strToFeatures(String var1);

    public static Pair<String, String> splitMorphString(String word, String morphStr) {
        if (morphStr == null || morphStr.trim().equals("")) {
            return new Pair<String, String>(word, NO_ANALYSIS);
        }
        String[] toks = morphStr.split(Pattern.quote(LEMMA_MARK));
        if (toks.length != 2) {
            throw new RuntimeException("Invalid morphology string: " + morphStr);
        }
        return new Pair<String, String>(toks[0], toks[1]);
    }

    public String toString() {
        return this.activeFeatures.toString();
    }

    public static enum MorphoFeatureType {
        TENSE,
        DEF,
        ASP,
        MOOD,
        NNUM,
        NUM,
        NGEN,
        GEN,
        CASE,
        PER,
        POSS,
        VOICE,
        OTHER,
        PROP;

    }
}

