"""Data downloaded from NCBI Gene data converted into Python data."""

# Copyright (C) 2014-2018, DV Klopfenstein. All rights reserved

downloaded = "2016_02_22" # 20913 items

# Downloaded as a tsv from NCBI Gene. Then translated to Python:
# 
# http://www.ncbi.nlm.nih.gov/gene/?term=genetype+protein+coding%5BProperties%5D+AND+%229606%22%5BTaxonomy+ID%5D+AND+alive%5Bproperty%5D
# 
# or follow link to "Search for Human Protein-Coding Genes" found here:
# 
# https://github.com/dvklopfenstein/biocode/blob/master/biodownloads/README.md

import collections as cx

NtData = cx.namedtuple('NtData', 'tax_id Org_name GeneID CurrentID Status Symbol Aliases description other_designations map_location chromosome genomic_nucleotide_accession_version start_position_on_the_genomic_accession end_position_on_the_genomic_accession orientation exon_count OMIM no_hdr0')
GENEID2NT = {
  1 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1, CurrentID=0, Status='live', Symbol='A1BG', Aliases='A1B, ABG, GAB, HYST2477', description='alpha-1-B glycoprotein', other_designations='HEL-S-163pA|epididymis secretory sperm binding protein Li 163pA', map_location='19q13.4', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=58346806, end_position_on_the_genomic_accession=58353499, orientation='minus', exon_count=8, OMIM=138670, no_hdr0=''),
  2 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2, CurrentID=0, Status='live', Symbol='A2M', Aliases='A2MD, CPAMD5, FWP007, S863-7', description='alpha-2-macroglobulin', other_designations='C3 and PZP-like alpha-2-macroglobulin domain-containing protein 5|alpha-2-M', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=9067708, end_position_on_the_genomic_accession=9115962, orientation='minus', exon_count=36, OMIM=103950, no_hdr0=''),
  131076 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131076, CurrentID=0, Status='live', Symbol='CCDC58', Aliases='', description='coiled-coil domain containing 58', other_designations='', map_location='3q21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=122359589, end_position_on_the_genomic_accession=122383281, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  9 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=9, CurrentID=0, Status='live', Symbol='NAT1', Aliases='AAC1, MNAT, NAT-1, NATI', description='N-acetyltransferase 1 (arylamine N-acetyltransferase)', other_designations='N-acetyltransferase type 1|arylamide acetylase 1|monomorphic arylamine N-acetyltransferase', map_location='8p22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=18170462, end_position_on_the_genomic_accession=18223689, orientation='plus', exon_count=11, OMIM=108345, no_hdr0=''),
  10 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=10, CurrentID=0, Status='live', Symbol='NAT2', Aliases='AAC2, NAT-2, PNAT', description='N-acetyltransferase 2 (arylamine N-acetyltransferase)', other_designations='N-acetyltransferase type 2|arylamide acetylase 2', map_location='8p22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=18391245, end_position_on_the_genomic_accession=18401219, orientation='plus', exon_count=3, OMIM=612182, no_hdr0=''),
  12 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=12, CurrentID=0, Status='live', Symbol='SERPINA3', Aliases='AACT, ACT, GIG24, GIG25', description='serpin peptidase inhibitor, clade A (alpha-1 antiproteinase, antitrypsin), member 3', other_designations='cell growth-inhibiting gene 24/25 protein|growth-inhibiting protein 24|growth-inhibiting protein 25|serine (or cysteine) proteinase inhibitor, clade A, member 3|serpin A3', map_location='14q32.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=94612377, end_position_on_the_genomic_accession=94624053, orientation='plus', exon_count=5, OMIM=107280, no_hdr0=''),
  13 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=13, CurrentID=0, Status='live', Symbol='AADAC', Aliases='CES5A1, DAC', description='arylacetamide deacetylase', other_designations='arylacetamide deacetylase (esterase)', map_location='3q25.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=151814025, end_position_on_the_genomic_accession=151828488, orientation='plus', exon_count=5, OMIM=600338, no_hdr0=''),
  14 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=14, CurrentID=0, Status='live', Symbol='AAMP', Aliases='', description='angio associated migratory cell protein', other_designations='angio-associated, migratory cell protein', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=218264129, end_position_on_the_genomic_accession=218270209, orientation='minus', exon_count=11, OMIM=603488, no_hdr0=''),
  15 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=15, CurrentID=0, Status='live', Symbol='AANAT', Aliases='DSPS, SNAT', description='aralkylamine N-acetyltransferase', other_designations='arylalkylamine N-acetyltransferase|serotonin acetylase', map_location='17q25.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=76452853, end_position_on_the_genomic_accession=76470790, orientation='plus', exon_count=11, OMIM=600950, no_hdr0=''),
  16 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=16, CurrentID=0, Status='live', Symbol='AARS', Aliases='CMT2N, EIEE29', description='alanyl-tRNA synthetase', other_designations='alaRS|alanine tRNA ligase 1, cytoplasmic|alanyl-tRNA synthetase, cytoplasmic|renal carcinoma antigen NY-REN-42', map_location='16q22', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=70252295, end_position_on_the_genomic_accession=70289550, orientation='minus', exon_count=21, OMIM=601065, no_hdr0=''),
  100128088 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100128088, CurrentID=0, Status='live', Symbol='LOC100128088', Aliases='', description='matrix metallopeptidase 1-like', other_designations='', map_location='11q22.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.9', start_position_on_the_genomic_accession=102621798, end_position_on_the_genomic_accession=102625674, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  18 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=18, CurrentID=0, Status='live', Symbol='ABAT', Aliases='GABA-AT, GABAT, NPD009', description='4-aminobutyrate aminotransferase', other_designations='(S)-3-amino-2-methylpropionate transaminase|4-aminobutyrate transaminase|GABA aminotransferase|GABA transaminase|GABA transferase|gamma-amino-N-butyrate transaminase', map_location='16p13.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=8674587, end_position_on_the_genomic_accession=8784575, orientation='plus', exon_count=20, OMIM=137150, no_hdr0=''),
  19 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=19, CurrentID=0, Status='live', Symbol='ABCA1', Aliases='ABC-1, ABC1, CERP, HDLDT1, TGD', description='ATP binding cassette subfamily A member 1', other_designations='ATP-binding cassette transporter A1|ATP-binding cassette, sub-family A (ABC1), member 1|cholesterol efflux regulatory protein|membrane-bound', map_location='9q31.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=104781002, end_position_on_the_genomic_accession=104928246, orientation='minus', exon_count=53, OMIM=600046, no_hdr0=''),
  20 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=20, CurrentID=0, Status='live', Symbol='ABCA2', Aliases='ABC2', description='ATP binding cassette subfamily A member 2', other_designations='ATP-binding cassette 2|ATP-binding cassette transporter 2|ATP-binding cassette, sub-family A (ABC1), member 2|ATP-binding cassette, sub-family A, member 2', map_location='9q34', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=137007234, end_position_on_the_genomic_accession=137028974, orientation='minus', exon_count=50, OMIM=600047, no_hdr0=''),
  21 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=21, CurrentID=0, Status='live', Symbol='ABCA3', Aliases='ABC-C, ABC3, EST111653, LBM180, SMDP3', description='ATP binding cassette subfamily A member 3', other_designations='ABC transporter 3|ABC-C transporter|ATP-binding cassette transporter 3|ATP-binding cassette, sub-family A (ABC1), member 3', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2275878, end_position_on_the_genomic_accession=2340746, orientation='minus', exon_count=33, OMIM=601615, no_hdr0=''),
  22 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=22, CurrentID=0, Status='live', Symbol='ABCB7', Aliases='ABC7, ASAT, Atm1p, EST140535', description='ATP binding cassette subfamily B member 7', other_designations='ABC transporter 7 protein|ATP-binding cassette sub-family B member 7|ATP-binding cassette transporter 7|ATP-binding cassette, sub-family B (MDR/TAP), member 7', map_location='Xq13.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=75053172, end_position_on_the_genomic_accession=75156340, orientation='minus', exon_count=16, OMIM=300135, no_hdr0=''),
  23 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=23, CurrentID=0, Status='live', Symbol='ABCF1', Aliases='ABC27, ABC50', description='ATP binding cassette subfamily F member 1', other_designations='ATP-binding cassette 50 (TNF-alpha stimulated)|ATP-binding cassette, sub-family F (GCN20), member 1|TNF-alpha-stimulated ABC protein|TNFalpha-inducible ATP-binding protein', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=30571393, end_position_on_the_genomic_accession=30591532, orientation='plus', exon_count=25, OMIM=603429, no_hdr0=''),
  24 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=24, CurrentID=0, Status='live', Symbol='ABCA4', Aliases='ABC10, ABCR, ARMD2, CORD3, FFM, RMP, RP19, STGD, STGD1', description='ATP binding cassette subfamily A member 4', other_designations='ATP binding cassette transporter|ATP-binding cassette sub-family A member 4|ATP-binding cassette transporter, retinal-specific|ATP-binding cassette, sub-family A (ABC1), member 4|ATP-binding transporter, retina-specific|RIM ABC transporter|RIM protein|photoreceptor rim protein|retina-specific ABC transporter|stargardt disease protein', map_location='1p22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=93992837, end_position_on_the_genomic_accession=94121149, orientation='minus', exon_count=50, OMIM=601691, no_hdr0=''),
  25 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=25, CurrentID=0, Status='live', Symbol='ABL1', Aliases='ABL, JTK7, bcr/abl, c-ABL, c-ABL1, p150, v-abl', description='ABL proto-oncogene 1, non-receptor tyrosine kinase', other_designations='Abelson tyrosine-protein kinase 1|bcr/c-abl oncogene protein|c-abl oncogene 1, receptor tyrosine kinase|proto-oncogene c-Abl|proto-oncogene tyrosine-protein kinase ABL1|v-abl Abelson murine leukemia viral oncogene homolog 1', map_location='9q34.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=130713881, end_position_on_the_genomic_accession=130887675, orientation='plus', exon_count=12, OMIM=189980, no_hdr0=''),
  26 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=26, CurrentID=0, Status='live', Symbol='AOC1', Aliases='ABP, ABP1, DAO, DAO1, KAO', description='amine oxidase, copper containing 1', other_designations='amiloride binding protein 1 (amine oxidase (copper-containing))|amiloride-binding protein 1|amiloride-sensitive amine oxidase|amine oxidase copper domain-containing protein 1|diamine oxidase|histaminase|kidney amine oxidase', map_location='7q36.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=150826393, end_position_on_the_genomic_accession=150861291, orientation='plus', exon_count=9, OMIM=104610, no_hdr0=''),
  27 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=27, CurrentID=0, Status='live', Symbol='ABL2', Aliases='ABLL, ARG', description='ABL proto-oncogene 2, non-receptor tyrosine kinase', other_designations='abelson-related gene protein|c-abl oncogene 2, non-receptor tyrosine kinase|tyrosine-protein kinase ARG|v-abl Abelson murine leukemia viral oncogene homolog 2', map_location='1q25.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=179099327, end_position_on_the_genomic_accession=179229693, orientation='minus', exon_count=15, OMIM=164690, no_hdr0=''),
  28 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=28, CurrentID=0, Status='live', Symbol='ABO', Aliases='A3GALNT, A3GALT1, GTB, NAGAT', description='ABO blood group (transferase A, alpha 1-3-N-acetylgalactosaminyltransferase; transferase B, alpha 1-3-galactosyltransferase)', other_designations='A1-specific alpha 1-3-N-acetylgalactosaminyltransferase|ABO A3 transferase|ABO glycosyltransferase|ABO weak transfer|B(A) alpha-1,3-galactosyltransferase|fucosylglycoprotein|fucosylglycoprotein 3-alpha-galactosyltransferase|fucosylglycoprotein alpha-N-acetylgalactosaminyltransferase|glycoprotein-fucosylgalactoside alpha-N-acetylgalactosaminyltransferase|glycoprotein-fucosylgalactoside alpha-galactosyltransferase|glycosyltransferase A|glycosyltransferase B|histo-blood group A transferase|histo-blood group A2 transferase|histo-blood group B transferase', map_location='9q34.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=133255176, end_position_on_the_genomic_accession=133275214, orientation='minus', exon_count=7, OMIM=110300, no_hdr0=''),
  29 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=29, CurrentID=0, Status='live', Symbol='ABR', Aliases='MDB', description='active BCR-related', other_designations='', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=1003518, end_position_on_the_genomic_accession=1187322, orientation='minus', exon_count=33, OMIM=600365, no_hdr0=''),
  30 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=30, CurrentID=0, Status='live', Symbol='ACAA1', Aliases='ACAA, PTHIO, THIO', description='acetyl-CoA acyltransferase 1', other_designations='acetyl-Coenzyme A acyltransferase 1|beta-ketothiolase|peroxisomal 3-oxoacyl-CoA thiolase|peroxisomal 3-oxoacyl-Coenzyme A thiolase', map_location='3p22.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=38122710, end_position_on_the_genomic_accession=38137242, orientation='minus', exon_count=12, OMIM=604054, no_hdr0=''),
  31 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=31, CurrentID=0, Status='live', Symbol='ACACA', Aliases='ACACD, ACC, ACC1, ACCA, ACACA', description='acetyl-CoA carboxylase alpha', other_designations='ACC-alpha|acetyl-Coenzyme A carboxylase alpha', map_location='17q21', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=37084992, end_position_on_the_genomic_accession=37406822, orientation='minus', exon_count=65, OMIM=200350, no_hdr0=''),
  32 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=32, CurrentID=0, Status='live', Symbol='ACACB', Aliases='ACC2, ACCB, HACC275', description='acetyl-CoA carboxylase beta', other_designations='ACC-beta|acetyl-Coenzyme A carboxylase beta', map_location='12q24.11', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=109111184, end_position_on_the_genomic_accession=109268226, orientation='plus', exon_count=58, OMIM=601557, no_hdr0=''),
  33 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=33, CurrentID=0, Status='live', Symbol='ACADL', Aliases='ACAD4, LCAD', description='acyl-CoA dehydrogenase, long chain', other_designations='acyl-Coenzyme A dehydrogenase, long chain', map_location='2q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=210187990, end_position_on_the_genomic_accession=210225491, orientation='minus', exon_count=12, OMIM=609576, no_hdr0=''),
  34 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=34, CurrentID=0, Status='live', Symbol='ACADM', Aliases='ACAD1, MCAD, MCADH', description='acyl-CoA dehydrogenase, C-4 to C-12 straight chain', other_designations='acyl-CoA dehydrogenase C-4 to C-12 straight chain|acyl-Coenzyme A dehydrogenase, C-4 to C-12 straight chain', map_location='1p31', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=75724347, end_position_on_the_genomic_accession=75763679, orientation='plus', exon_count=13, OMIM=607008, no_hdr0=''),
  35 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=35, CurrentID=0, Status='live', Symbol='ACADS', Aliases='ACAD3, SCAD', description='acyl-CoA dehydrogenase, C-2 to C-3 short chain', other_designations='acyl-Coenzyme A dehydrogenase, C-2 to C-3 short chain|butyryl-CoA dehydrogenase|mitochondrial short-chain specific acyl-CoA dehydrogenase|unsaturated acyl-CoA reductase', map_location='12q24.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=120725738, end_position_on_the_genomic_accession=120740008, orientation='plus', exon_count=11, OMIM=606885, no_hdr0=''),
  36 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=36, CurrentID=0, Status='live', Symbol='ACADSB', Aliases='2-MEBCAD, ACAD7, SBCAD', description='acyl-CoA dehydrogenase, short/branched chain', other_designations='2-methyl branched chain acyl-CoA dehydrogenase|2-methylbutyryl-coenzyme A dehydrogenase|acyl-CoA dehydrogenase short/branched chain|acyl-Coenzyme A dehydrogenase, short/branched chain', map_location='10q26.13', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=123008913, end_position_on_the_genomic_accession=123058290, orientation='plus', exon_count=11, OMIM=600301, no_hdr0=''),
  37 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=37, CurrentID=0, Status='live', Symbol='ACADVL', Aliases='ACAD6, LCACD, VLCAD', description='acyl-CoA dehydrogenase, very long chain', other_designations='acyl-Coenzyme A dehydrogenase, very long chain', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7217125, end_position_on_the_genomic_accession=7225267, orientation='plus', exon_count=22, OMIM=609575, no_hdr0=''),
  38 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=38, CurrentID=0, Status='live', Symbol='ACAT1', Aliases='ACAT, MAT, T2, THIL', description='acetyl-CoA acetyltransferase 1', other_designations='acetoacetyl Coenzyme A thiolase|acetoacetyl-CoA thiolase|acetyl-Coenzyme A acetyltransferase 1|mitochondrial acetoacetyl-CoA thiolase', map_location='11q22.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=108121531, end_position_on_the_genomic_accession=108148168, orientation='plus', exon_count=14, OMIM=607809, no_hdr0=''),
  39 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=39, CurrentID=0, Status='live', Symbol='ACAT2', Aliases='', description='acetyl-CoA acetyltransferase 2', other_designations='acetoacetyl Coenzyme A thiolase|acetyl-CoA transferase-like protein|cytosolic acetoacetyl-CoA thiolase', map_location='6q25.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=159761957, end_position_on_the_genomic_accession=159779112, orientation='plus', exon_count=10, OMIM=100678, no_hdr0=''),
  40 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=40, CurrentID=0, Status='live', Symbol='ASIC2', Aliases='ACCN, ACCN1a, BNC1, BNaC1, MDEG, hBNaC1, ASIC2', description='acid sensing ion channel subunit 2', other_designations='acid sensing (proton gated) ion channel 2|acid sensing ion channel 2|acid-sensing (proton-gated) ion channel 2|amiloride-sensitive cation channel 1, neuronal|brain sodium channel 1|mammalian degenerin homolog|neuronal amiloride-sensitive cation channel 1', map_location='17q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=33013087, end_position_on_the_genomic_accession=34156806, orientation='minus', exon_count=11, OMIM=601784, no_hdr0=''),
  41 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=41, CurrentID=0, Status='live', Symbol='ASIC1', Aliases='ACCN2, ASIC, BNaC2', description='acid sensing ion channel subunit 1', other_designations='Cation channel, amiloride-sensitive, neuronal, 2|acid sensing (proton gated) ion channel 1|acid sensing ion channel 1|acid-sensing (proton-gated) ion channel 1|acid-sensing ion channel 1a protein|amiloride-sensitive cation channel 2, neuronal|brain sodium channel 2', map_location='12q12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=50057637, end_position_on_the_genomic_accession=50083622, orientation='plus', exon_count=14, OMIM=602866, no_hdr0=''),
  163882 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=163882, CurrentID=0, Status='live', Symbol='CNST', Aliases='C1orf71, PPP1R64', description='consortin, connexin sorting protein', other_designations='protein phosphatase 1, regulatory subunit 64', map_location='1q44', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=246566337, end_position_on_the_genomic_accession=246668587, orientation='plus', exon_count=14, OMIM=613439, no_hdr0=''),
  43 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=43, CurrentID=0, Status='live', Symbol='ACHE', Aliases='ACEE, ARACHE, N-ACHE, YT', description='acetylcholinesterase (Yt blood group)', other_designations='Yt blood group|apoptosis-related acetylcholinesterase', map_location='7q22', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=100889994, end_position_on_the_genomic_accession=100896686, orientation='minus', exon_count=7, OMIM=100740, no_hdr0=''),
  400224 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=400224, CurrentID=0, Status='live', Symbol='PLEKHD1', Aliases='UPF0639', description='pleckstrin homology and coiled-coil domain containing D1', other_designations='PH domain-containing family D member 1|UPF0639 protein|pleckstrin homology domain containing, family D (with M protein repeats) member 1|pleckstrin homology domain containing, family D (with coiled-coil domains) member 1', map_location='14q24.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=69484754, end_position_on_the_genomic_accession=69529327, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  131118 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131118, CurrentID=0, Status='live', Symbol='DNAJC19', Aliases='PAM18, TIM14, TIMM14', description='DnaJ heat shock protein family (Hsp40) member C19', other_designations='DnaJ (Hsp40) homolog, subfamily C, member 19|DnaJ-like protein subfamily C member 19|homolog of yeast TIM14', map_location='3q26.33', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=180983709, end_position_on_the_genomic_accession=180989774, orientation='minus', exon_count=7, OMIM=608977, no_hdr0=''),
  47 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=47, CurrentID=0, Status='live', Symbol='ACLY', Aliases='ACL, ATPCL, CLATP', description='ATP citrate lyase', other_designations='ATP citrate synthase|ATP-citrate (pro-S-)-lyase|citrate cleavage enzyme', map_location='17q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=41866916, end_position_on_the_genomic_accession=41930542, orientation='minus', exon_count=30, OMIM=108728, no_hdr0=''),
  48 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=48, CurrentID=0, Status='live', Symbol='ACO1', Aliases='ACONS, HEL60, IREB1, IREBP, IREBP1, IRP1', description='aconitase 1', other_designations='IRE-BP 1|aconitase 1, soluble|aconitate hydratase, cytoplasmic|citrate hydro-lyase|cytosplasmic aconitase|epididymis luminal protein 60|ferritin repressor protein|iron regulatory protein 1|iron-responsive element binding protein 1|iron-responsive element-binding protein 1|soluble aconitase', map_location='9p21.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=32384603, end_position_on_the_genomic_accession=32450836, orientation='plus', exon_count=23, OMIM=100880, no_hdr0=''),
  49 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=49, CurrentID=0, Status='live', Symbol='ACR', Aliases='', description='acrosin', other_designations='acrosin light and heavy chain prepropeptide|preproacrosin|proacrosin', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50738224, end_position_on_the_genomic_accession=50745299, orientation='plus', exon_count=5, OMIM=102480, no_hdr0=''),
  50 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=50, CurrentID=0, Status='live', Symbol='ACO2', Aliases='ACONM, HEL-S-284, ICRD, OCA8', description='aconitase 2', other_designations='aconitase 2, mitochondrial|citrate hydro-lyase|epididymis secretory sperm binding protein Li 284|mitochondrial aconitase', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=41469125, end_position_on_the_genomic_accession=41528989, orientation='plus', exon_count=18, OMIM=100850, no_hdr0=''),
  51 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=51, CurrentID=0, Status='live', Symbol='ACOX1', Aliases='ACOX, PALMCOX, SCOX', description='acyl-CoA oxidase 1, palmitoyl', other_designations='AOX|acyl-CoA oxidase, straight-chain|acyl-Coenzyme A oxidase 1, palmitoyl|palmitoyl-CoA oxidase|peroxisomal fatty acyl-CoA oxidase|straight-chain acyl-CoA oxidase', map_location='17q25.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=75941507, end_position_on_the_genomic_accession=75979434, orientation='minus', exon_count=15, OMIM=609751, no_hdr0=''),
  52 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=52, CurrentID=0, Status='live', Symbol='ACP1', Aliases='HAAP, LMW-PTP', description='acid phosphatase 1, soluble', other_designations='LMW-PTPase|acid phosphatase of erythrocyte|adipocyte acid phosphatase|cytoplasmic phosphotyrosyl protein phosphatase|low molecular weight cytosolic acid phosphatase|protein tyrosine phosphatase|red cell acid phosphatase 1', map_location='2p25', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=264140, end_position_on_the_genomic_accession=278283, orientation='plus', exon_count=8, OMIM=171500, no_hdr0=''),
  53 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=53, CurrentID=0, Status='live', Symbol='ACP2', Aliases='LAP', description='acid phosphatase 2, lysosomal', other_designations='', map_location='11p12-p11', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=47239302, end_position_on_the_genomic_accession=47248847, orientation='minus', exon_count=12, OMIM=171650, no_hdr0=''),
  54 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=54, CurrentID=0, Status='live', Symbol='ACP5', Aliases='HPAP, SPENCDI, TRAP', description='acid phosphatase 5, tartrate resistant', other_designations='TrATPase|human purple acid phosphatase|tartrate-resistant acid ATPase', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=11574660, end_position_on_the_genomic_accession=11578986, orientation='minus', exon_count=8, OMIM=171640, no_hdr0=''),
  55 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=55, CurrentID=0, Status='live', Symbol='ACPP', Aliases="5'-NT, ACP-3, ACP3", description='acid phosphatase, prostate', other_designations="5'-nucleotidase|TMPase|ecto-5'-nucleotidase|prostatic acid phosphotase|thiamine monophosphatase", map_location='3q22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=132317367, end_position_on_the_genomic_accession=132368302, orientation='plus', exon_count=12, OMIM=171790, no_hdr0=''),
  56 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=56, CurrentID=0, Status='live', Symbol='ACRV1', Aliases='D11S4365, SP-10, SPACA2', description='acrosomal vesicle protein 1', other_designations='sperm protein 10', map_location='11q24.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=125672334, end_position_on_the_genomic_accession=125680898, orientation='minus', exon_count=5, OMIM=102525, no_hdr0=''),
  100526772 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100526772, CurrentID=0, Status='live', Symbol='TMEM110-MUSTN1', Aliases='', description='TMEM110-MUSTN1 readthrough', other_designations='TMEM110-MUSTN1 read-through transcript', map_location='', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=52833115, end_position_on_the_genomic_accession=52897581, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  58 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=58, CurrentID=0, Status='live', Symbol='ACTA1', Aliases='ACTA, ASMA, CFTD, CFTD1, CFTDM, MPFD, NEM1, NEM2, NEM3', description='actin, alpha 1, skeletal muscle', other_designations='nemaline myopathy type 3', map_location='1q42.13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=229431245, end_position_on_the_genomic_accession=229434096, orientation='minus', exon_count=7, OMIM=102610, no_hdr0=''),
  59 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=59, CurrentID=0, Status='live', Symbol='ACTA2', Aliases='AAT6, ACTSA, MYMY5', description='actin, alpha 2, smooth muscle, aorta', other_designations='alpha-cardiac actin|cell growth-inhibiting gene 46 protein', map_location='10q23.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=88935074, end_position_on_the_genomic_accession=88991390, orientation='minus', exon_count=10, OMIM=102620, no_hdr0=''),
  60 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=60, CurrentID=0, Status='live', Symbol='ACTB', Aliases='BRWS1, PS1TP5BP1', description='actin, beta', other_designations='PS1TP5-binding protein 1|beta cytoskeletal actin', map_location='7p22', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=5527148, end_position_on_the_genomic_accession=5530601, orientation='minus', exon_count=6, OMIM=102630, no_hdr0=''),
  70 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=70, CurrentID=0, Status='live', Symbol='ACTC1', Aliases='ACTC, ASD5, CMD1R, CMH11, LVNC4', description='actin, alpha, cardiac muscle 1', other_designations='', map_location='15q14', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=34788096, end_position_on_the_genomic_accession=34795726, orientation='minus', exon_count=7, OMIM=102540, no_hdr0=''),
  71 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=71, CurrentID=0, Status='live', Symbol='ACTG1', Aliases='ACT, ACTG, BRWS2, DFNA20, DFNA26, HEL-176', description='actin gamma 1', other_designations='cytoskeletal gamma-actin|epididymis luminal protein 176', map_location='17q25', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=81509971, end_position_on_the_genomic_accession=81512866, orientation='minus', exon_count=7, OMIM=102560, no_hdr0=''),
  72 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=72, CurrentID=0, Status='live', Symbol='ACTG2', Aliases='ACT, ACTA3, ACTE, ACTL3, ACTSG, VSCM', description='actin, gamma 2, smooth muscle, enteric', other_designations='actin-like protein|alpha-actin-3', map_location='2p13.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=73892966, end_position_on_the_genomic_accession=73919653, orientation='plus', exon_count=9, OMIM=102545, no_hdr0=''),
  131149 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131149, CurrentID=0, Status='live', Symbol='OTOL1', Aliases='C1QTNF15', description='otolin 1', other_designations='C1q and tumor necrosis factor related protein 15|otolin 1 homolog', map_location='3q26.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=161429601, end_position_on_the_genomic_accession=161503975, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  81 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=81, CurrentID=0, Status='live', Symbol='ACTN4', Aliases='ACTININ-4, FSGS, FSGS1', description='actinin alpha 4', other_designations='F-actin cross-linking protein|actinin alpha4 isoform|actinin, alpha 4|focal segmental glomerulosclerosis 1|non-muscle alpha-actinin 4', map_location='19q13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=38647616, end_position_on_the_genomic_accession=38730531, orientation='plus', exon_count=23, OMIM=604638, no_hdr0=''),
  86 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=86, CurrentID=0, Status='live', Symbol='ACTL6A', Aliases='ACTL6, ARPN-BETA, Arp4, BAF53A, INO80K', description='actin like 6A', other_designations='53 kDa BRG1-associated factor A|BAF complex 53 kDa subunit|BAF53|BRG1-associated factor 53A|INO80 complex subunit K|actin-like 6A|actin-related protein 4|actin-related protein Baf53a|arpNbeta|hArpN beta', map_location='3q26.33', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=179562880, end_position_on_the_genomic_accession=179588405, orientation='plus', exon_count=14, OMIM=604958, no_hdr0=''),
  87 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=87, CurrentID=0, Status='live', Symbol='ACTN1', Aliases='BDPLT15', description='actinin alpha 1', other_designations='F-actin cross-linking protein|actinin 1 smooth muscle|actinin, alpha 1|alpha-actinin cytoskeletal isoform|non-muscle alpha-actinin-1', map_location='14q22-q24', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=68874123, end_position_on_the_genomic_accession=68979366, orientation='minus', exon_count=24, OMIM=102575, no_hdr0=''),
  88 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=88, CurrentID=0, Status='live', Symbol='ACTN2', Aliases='CMD1AA, CMH23', description='actinin alpha 2', other_designations='F-actin cross-linking protein|actinin, alpha 2|alpha-actinin skeletal muscle', map_location='1q42-q43', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=236686454, end_position_on_the_genomic_accession=236764631, orientation='plus', exon_count=23, OMIM=102573, no_hdr0=''),
  89 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=89, CurrentID=0, Status='live', Symbol='ACTN3', Aliases='', description='actinin alpha 3 (gene/pseudogene)', other_designations='F-actin cross-linking protein|actinin, alpha 3|alpha-actinin skeletal muscle', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=66546395, end_position_on_the_genomic_accession=66563329, orientation='plus', exon_count=22, OMIM=102574, no_hdr0=''),
  90 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=90, CurrentID=0, Status='live', Symbol='ACVR1', Aliases='ACTRIA, ACVRLK2, ALK2, FOP, SKR1, TSRI, ACVR1', description='activin A receptor type I', other_designations='TGF-B superfamily receptor type I|activin A receptor, type I|activin A receptor, type II-like kinase 2|activin receptor type I|activin receptor-like kinase 2|hydroxyalkyl-protein kinase|serine/threonine-protein kinase receptor R1', map_location='2q23-q24', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=157736444, end_position_on_the_genomic_accession=157875862, orientation='minus', exon_count=18, OMIM=102576, no_hdr0=''),
  91 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=91, CurrentID=0, Status='live', Symbol='ACVR1B', Aliases='ACTRIB, ACVRLK4, ALK4, SKR2', description='activin A receptor type IB', other_designations='activin A receptor, type IB|activin A receptor, type II-like kinase 4|activin receptor-like kinase 4|serine/threonine-protein kinase receptor R2', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=51951667, end_position_on_the_genomic_accession=51997079, orientation='plus', exon_count=12, OMIM=601300, no_hdr0=''),
  92 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=92, CurrentID=0, Status='live', Symbol='ACVR2A', Aliases='ACTRII, ACVR2', description='activin A receptor type IIA', other_designations='activin A receptor, type IIA', map_location='2q22.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=147844517, end_position_on_the_genomic_accession=147930827, orientation='plus', exon_count=12, OMIM=102581, no_hdr0=''),
  93 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=93, CurrentID=0, Status='live', Symbol='ACVR2B', Aliases='ACTRIIB, ActR-IIB, HTX4', description='activin A receptor type IIB', other_designations='activin A receptor, type IIB', map_location='3p22', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=38454299, end_position_on_the_genomic_accession=38493142, orientation='plus', exon_count=12, OMIM=602730, no_hdr0=''),
  94 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=94, CurrentID=0, Status='live', Symbol='ACVRL1', Aliases='ACVRLK1, ALK-1, ALK1, HHT, HHT2, ORW2, SKR3, TSR-I', description='activin A receptor type IL', other_designations='TGF-B superfamily receptor type I|activin A receptor type II-like 1|activin A receptor, type II-like kinase 1', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=51906913, end_position_on_the_genomic_accession=51923361, orientation='plus', exon_count=11, OMIM=601284, no_hdr0=''),
  95 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=95, CurrentID=0, Status='live', Symbol='ACY1', Aliases='ACY-1D, HEL-S-5, ACY1', description='aminoacylase 1', other_designations='N-acyl-L-amino-acid amidohydrolase|acylase|epididymis secretory protein Li 5', map_location='3p21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=51983284, end_position_on_the_genomic_accession=51989202, orientation='plus', exon_count=15, OMIM=104620, no_hdr0=''),
  97 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=97, CurrentID=0, Status='live', Symbol='ACYP1', Aliases='ACYPE', description='acylphosphatase 1, erythrocyte (common) type', other_designations='acylphosphatase, erythrocyte isozyme|acylphosphatase, organ-common type isozyme|acylphosphate phosphohydrolase 1', map_location='14q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=75053221, end_position_on_the_genomic_accession=75069483, orientation='minus', exon_count=5, OMIM=600875, no_hdr0=''),
  98 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=98, CurrentID=0, Status='live', Symbol='ACYP2', Aliases='ACYM, ACYP', description='acylphosphatase 2, muscle type', other_designations='acylphosphatase, muscle type isozyme|acylphosphate phosphohydrolase 2', map_location='2p16.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=54115273, end_position_on_the_genomic_accession=54305300, orientation='plus', exon_count=4, OMIM=102595, no_hdr0=''),
  100 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100, CurrentID=0, Status='live', Symbol='ADA', Aliases='', description='adenosine deaminase', other_designations='adenosine aminohydrolase|mutant adenosine deaminase', map_location='20q13.12', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=44619522, end_position_on_the_genomic_accession=44652233, orientation='minus', exon_count=13, OMIM=608958, no_hdr0=''),
  101 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=101, CurrentID=0, Status='live', Symbol='ADAM8', Aliases='CD156, CD156a, MS2', description='ADAM metallopeptidase domain 8', other_designations='a disintegrin and metalloproteinase domain 8|cell surface antigen MS2|human leukocyte differentiation antigen', map_location='10q26.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=133262416, end_position_on_the_genomic_accession=133276903, orientation='minus', exon_count=25, OMIM=602267, no_hdr0=''),
  102 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=102, CurrentID=0, Status='live', Symbol='ADAM10', Aliases='AD10, AD18, CD156c, HsT18717, MADM, RAK, kuz', description='ADAM metallopeptidase domain 10', other_designations='CDw156|a disintegrin and metalloprotease domain 10|kuzbanian protein homolog|mammalian disintegrin-metalloprotease', map_location='15q22', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=58595204, end_position_on_the_genomic_accession=58749978, orientation='minus', exon_count=16, OMIM=602192, no_hdr0=''),
  103 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=103, CurrentID=0, Status='live', Symbol='ADAR', Aliases='ADAR1, AGS6, DRADA, DSH, DSRAD, G1P1, IFI-4, IFI4, K88DSRBP, P136', description='adenosine deaminase, RNA-specific', other_designations='136 kDa double-stranded RNA-binding protein|adenosine deaminase acting on RNA 1-A|dsRNA adenosine deaminase|interferon-induced protein 4|interferon-inducible protein 4', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=154582057, end_position_on_the_genomic_accession=154628013, orientation='minus', exon_count=18, OMIM=146920, no_hdr0=''),
  104 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=104, CurrentID=0, Status='live', Symbol='ADARB1', Aliases='ADAR2, DRABA2, DRADA2, RED1', description='adenosine deaminase, RNA-specific, B1', other_designations='RED1 homolog|RNA editase|RNA editing deaminase 1|RNA-editing deaminase 1|RNA-editing enzyme 1|adenosine deaminase, RNA-specific, B1 (RED1 homolog rat)|adenosine deaminase, RNA-specific, B1 (homolog of rat RED1)|dsRNA adenosine deaminase DRADA2', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=45074578, end_position_on_the_genomic_accession=45226563, orientation='plus', exon_count=19, OMIM=601218, no_hdr0=''),
  105 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105, CurrentID=0, Status='live', Symbol='ADARB2', Aliases='ADAR3, RED2', description='adenosine deaminase, RNA-specific, B2 (inactive)', other_designations='RED2 homolog|RNA-dependent adenosine deaminase 3|RNA-editing deaminase 2|RNA-editing enzyme 2|adenosine deaminase, RNA-specific, B2 (RED1 homolog rat)|adenosine deaminase, RNA-specific, B2 (RED2 homolog rat)|adenosine deaminase, RNA-specific, B2 (non-functional)|dsRNA adenosine deaminase B2|homolog of rat BLUE', map_location='10p15.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=1177313, end_position_on_the_genomic_accession=1737498, orientation='minus', exon_count=11, OMIM=602065, no_hdr0=''),
  107 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=107, CurrentID=0, Status='live', Symbol='ADCY1', Aliases='AC1, DFNB44', description='adenylate cyclase 1 (brain)', other_designations="3',5'-cyclic AMP synthetase|ATP pyrophosphate-lyase 1|Ca(2+)/calmodulin-activated adenylyl cyclase|adenyl cyclase|adenylate cyclase type I|adenylyl cyclase 1", map_location='7p12.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=45574140, end_position_on_the_genomic_accession=45723116, orientation='plus', exon_count=22, OMIM=103072, no_hdr0=''),
  108 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=108, CurrentID=0, Status='live', Symbol='ADCY2', Aliases='AC2, HBAC2', description='adenylate cyclase 2 (brain)', other_designations="3',5'-cyclic AMP synthetase|ATP pyrophosphate-lyase 2|adenylate cyclase II|adenylate cyclase type II|adenylyl cyclase 2|type II adenylate cyclase", map_location='5p15.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=7396230, end_position_on_the_genomic_accession=7830081, orientation='plus', exon_count=25, OMIM=103071, no_hdr0=''),
  109 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=109, CurrentID=0, Status='live', Symbol='ADCY3', Aliases='AC3', description='adenylate cyclase 3', other_designations='AC-III|ATP pyrophosphate-lyase 3|adenylate cyclase type III|adenylate cyclase, olfactive type|adenylyl cyclase 3|adenylyl cyclase, type III', map_location='2p23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=24819169, end_position_on_the_genomic_accession=24919733, orientation='minus', exon_count=26, OMIM=600291, no_hdr0=''),
  111 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=111, CurrentID=0, Status='live', Symbol='ADCY5', Aliases='AC5, FDFM', description='adenylate cyclase 5', other_designations='ATP pyrophosphate-lyase 5|adenylate cyclase type V|adenylyl cyclase 5', map_location='3q21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=123282296, end_position_on_the_genomic_accession=123448638, orientation='minus', exon_count=29, OMIM=600293, no_hdr0=''),
  112 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=112, CurrentID=0, Status='live', Symbol='ADCY6', Aliases='AC6, LCCS8', description='adenylate cyclase 6', other_designations='ATP pyrophosphate-lyase 6|adenylate cyclase type VI|ca(2+)-inhibitable adenylyl cyclase', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=48766192, end_position_on_the_genomic_accession=48789037, orientation='minus', exon_count=23, OMIM=600294, no_hdr0=''),
  113 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=113, CurrentID=0, Status='live', Symbol='ADCY7', Aliases='AC7', description='adenylate cyclase 7', other_designations='ATP pyrophosphate-lyase 7|adenylate cyclase type VII|adenylyl cyclase 7', map_location='16q12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=50244749, end_position_on_the_genomic_accession=50318135, orientation='plus', exon_count=31, OMIM=600385, no_hdr0=''),
  114 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=114, CurrentID=0, Status='live', Symbol='ADCY8', Aliases='AC8, ADCY3, HBAC1', description='adenylate cyclase 8 (brain)', other_designations='ATP pyrophosphate-lyase 8|HEL-S-172mP|adenylate cyclase type VIII|adenylyl cyclase 8|adenylyl cyclase-8, brain|ca(2+)/calmodulin-activated adenylyl cyclase|epididymis secretory sperm binding protein Li 172mP', map_location='8q24', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=130780300, end_position_on_the_genomic_accession=131041598, orientation='minus', exon_count=18, OMIM=103070, no_hdr0=''),
  115 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=115, CurrentID=0, Status='live', Symbol='ADCY9', Aliases='AC9, ACIX', description='adenylate cyclase 9', other_designations='ATP pyrophosphate-lyase 9|adenylate cyclase type IX|adenylyl cyclase 9|type IX ATP pyrophosphate-lyase', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=3953387, end_position_on_the_genomic_accession=4116185, orientation='minus', exon_count=12, OMIM=603302, no_hdr0=''),
  116 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=116, CurrentID=0, Status='live', Symbol='ADCYAP1', Aliases='PACAP', description='adenylate cyclase activating polypeptide 1 (pituitary)', other_designations='pituitary adenylate cyclase activating polypeptide|prepro-PACAP', map_location='18p11', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=904345, end_position_on_the_genomic_accession=912172, orientation='plus', exon_count=6, OMIM=102980, no_hdr0=''),
  117 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=117, CurrentID=0, Status='live', Symbol='ADCYAP1R1', Aliases='PAC1, PAC1R, PACAPR, PACAPRI', description='adenylate cyclase activating polypeptide 1 (pituitary) receptor type I', other_designations='PACAP receptor 1|PACAP type I receptor|PACAP-R1|pituitary adenylate cyclase activating polypeptide 1 receptor type I Hiphop', map_location='7p14', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=31052341, end_position_on_the_genomic_accession=31111479, orientation='plus', exon_count=18, OMIM=102981, no_hdr0=''),
  118 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=118, CurrentID=0, Status='live', Symbol='ADD1', Aliases='ADDA', description='adducin 1', other_designations='adducin 1 (alpha)|erythrocyte adducin alpha subunit', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=2843727, end_position_on_the_genomic_accession=2930076, orientation='plus', exon_count=19, OMIM=102680, no_hdr0=''),
  119 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=119, CurrentID=0, Status='live', Symbol='ADD2', Aliases='ADDB', description='adducin 2', other_designations='adducin 2 (beta)|erythrocyte adducin subunit beta', map_location='2p13.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=70661202, end_position_on_the_genomic_accession=70768243, orientation='minus', exon_count=20, OMIM=102681, no_hdr0=''),
  120 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=120, CurrentID=0, Status='live', Symbol='ADD3', Aliases='ADDL', description='adducin 3', other_designations='adducin 3 (gamma)|adducin-like protein 70', map_location='10q25.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=109996365, end_position_on_the_genomic_accession=110135565, orientation='plus', exon_count=23, OMIM=601568, no_hdr0=''),
  123 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=123, CurrentID=0, Status='live', Symbol='PLIN2', Aliases='ADFP, ADRP', description='perilipin 2', other_designations='adipophilin|adipose differentiation-related protein', map_location='9p22.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=19108388, end_position_on_the_genomic_accession=19127606, orientation='minus', exon_count=9, OMIM=103195, no_hdr0=''),
  124 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=124, CurrentID=0, Status='live', Symbol='ADH1A', Aliases='ADH1', description='alcohol dehydrogenase 1A (class I), alpha polypeptide', other_designations='ADH, alpha subunit|alcohol dehydrogenase 1 (class I), alpha polypeptide|alcohol dehydrogenase subunit alpha|aldehyde reductase', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99276366, end_position_on_the_genomic_accession=99291028, orientation='minus', exon_count=9, OMIM=103700, no_hdr0=''),
  125 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=125, CurrentID=0, Status='live', Symbol='ADH1B', Aliases='ADH2, HEL-S-117', description='alcohol dehydrogenase 1B (class I), beta polypeptide', other_designations='ADH, beta subunit|alcohol dehydrogenase 2 (class I), beta polypeptide|alcohol dehydrogenase subunit beta|aldehyde reductase|epididymis secretory protein Li 117', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99306387, end_position_on_the_genomic_accession=99321442, orientation='minus', exon_count=10, OMIM=103720, no_hdr0=''),
  126 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=126, CurrentID=0, Status='live', Symbol='ADH1C', Aliases='ADH3', description='alcohol dehydrogenase 1C (class I), gamma polypeptide', other_designations='ADH, gamma subunit|alcohol dehydrogenase 3 (class I), gamma polypeptide|aldehyde reductase', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99336492, end_position_on_the_genomic_accession=99353045, orientation='minus', exon_count=10, OMIM=103730, no_hdr0=''),
  127 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=127, CurrentID=0, Status='live', Symbol='ADH4', Aliases='ADH-2, HEL-S-4', description='alcohol dehydrogenase 4 (class II), pi polypeptide', other_designations='alcohol dehydrogenase class II pi chain|aldehyde reductase|epididymis secretory protein Li 4', map_location='4q22', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99123681, end_position_on_the_genomic_accession=99144314, orientation='minus', exon_count=11, OMIM=103740, no_hdr0=''),
  128 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=128, CurrentID=0, Status='live', Symbol='ADH5', Aliases='ADH-3, ADHX, FALDH, FDH, GSH-FDH, GSNOR, HEL-S-60p', description='alcohol dehydrogenase 5 (class III), chi polypeptide', other_designations='S-(hydroxymethyl)glutathione dehydrogenase|alcohol dehydrogenase (class III), chi polypeptide|alcohol dehydrogenase class chi chain|alcohol dehydrogenase class-III|epididymis secretory sperm binding protein Li 60p|formaldehyde dehydrogenase|glutathione-dependent formaldehyde dehydrogenase', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99070978, end_position_on_the_genomic_accession=99088788, orientation='minus', exon_count=9, OMIM=103710, no_hdr0=''),
  130 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=130, CurrentID=0, Status='live', Symbol='ADH6', Aliases='ADH-5', description='alcohol dehydrogenase 6 (class V)', other_designations='aldehyde reductase', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99202638, end_position_on_the_genomic_accession=99219246, orientation='minus', exon_count=9, OMIM=103735, no_hdr0=''),
  131 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131, CurrentID=0, Status='live', Symbol='ADH7', Aliases='ADH4', description='alcohol dehydrogenase 7 (class IV), mu or sigma polypeptide', other_designations='alcohol dehydrogenase VII|alcohol dehydrogenase class IV mu/sigma chain|alcohol dehydrogenase-7|class IV sigma-1 alcohol dehydrogenase|class IV sigmasigma alcohol dehydrogenase|gastric alcohol dehydrogenase|retinol dehydrogenase', map_location='4q23-q24', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99412261, end_position_on_the_genomic_accession=99435510, orientation='minus', exon_count=10, OMIM=600086, no_hdr0=''),
  132 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132, CurrentID=0, Status='live', Symbol='ADK', Aliases='AK', description='adenosine kinase', other_designations="adenosine 5'-phosphotransferase", map_location='10q11-q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=74151185, end_position_on_the_genomic_accession=74709303, orientation='plus', exon_count=13, OMIM=102750, no_hdr0=''),
  133 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=133, CurrentID=0, Status='live', Symbol='ADM', Aliases='AM, PAMP', description='adrenomedullin', other_designations='preproadrenomedullin|proadrenomedullin N-20 terminal peptide', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=10304980, end_position_on_the_genomic_accession=10307402, orientation='plus', exon_count=4, OMIM=103275, no_hdr0=''),
  134 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=134, CurrentID=0, Status='live', Symbol='ADORA1', Aliases='RDC7', description='adenosine A1 receptor', other_designations='adenosine A1 receptor variant 1|adenosine A1 receptor variant 2', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=203127705, end_position_on_the_genomic_accession=203167405, orientation='plus', exon_count=6, OMIM=102775, no_hdr0=''),
  135 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=135, CurrentID=0, Status='live', Symbol='ADORA2A', Aliases='A2aR, ADORA2, RDC8', description='adenosine A2a receptor', other_designations='adenosine receptor subtype A2a', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=24423597, end_position_on_the_genomic_accession=24442360, orientation='plus', exon_count=6, OMIM=102776, no_hdr0=''),
  136 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=136, CurrentID=0, Status='live', Symbol='ADORA2B', Aliases='ADORA2', description='adenosine A2b receptor', other_designations='', map_location='17p12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=15927783, end_position_on_the_genomic_accession=15975896, orientation='plus', exon_count=6, OMIM=600446, no_hdr0=''),
  100128108 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100128108, CurrentID=0, Status='live', Symbol='LOC100128108', Aliases='', description='putative ubiquitin-conjugating enzyme E2Q2-like protein', other_designations='', map_location='15q26.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=101724664, end_position_on_the_genomic_accession=101747827, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  140 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=140, CurrentID=0, Status='live', Symbol='ADORA3', Aliases='A3AR', description='adenosine A3 receptor', other_designations='', map_location='1p13.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=111499429, end_position_on_the_genomic_accession=111504121, orientation='minus', exon_count=2, OMIM=600445, no_hdr0=''),
  141 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=141, CurrentID=0, Status='live', Symbol='ADPRH', Aliases='ARH1', description='ADP-ribosylarginine hydrolase', other_designations='ADP-ribose-L-arginine cleaving enzyme|[Protein ADP-ribosylarginine] hydrolase', map_location='3q13.31-q13.33', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=119579433, end_position_on_the_genomic_accession=119589945, orientation='plus', exon_count=5, OMIM=603081, no_hdr0=''),
  142 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=142, CurrentID=0, Status='live', Symbol='PARP1', Aliases='ADPRT, ADPRT 1, ADPRT1, ARTD1, PARP, PARP-1, PPOL, pADPRT-1', description='poly(ADP-ribose) polymerase 1', other_designations='ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase)|ADP-ribosyltransferase NAD(+)|ADP-ribosyltransferase diphtheria toxin-like 1|NAD(+) ADP-ribosyltransferase 1|poly (ADP-ribose) polymerase 1|poly (ADP-ribose) polymerase family, member 1|poly(ADP-ribose) polymerase|poly(ADP-ribose) synthetase|poly(ADP-ribosyl)transferase|poly[ADP-ribose] synthase 1', map_location='1q41-q42', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=226360691, end_position_on_the_genomic_accession=226408100, orientation='minus', exon_count=23, OMIM=173870, no_hdr0=''),
  143 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=143, CurrentID=0, Status='live', Symbol='PARP4', Aliases='ADPRTL1, ARTD4, PARP-4, PARPL, PH5P, VAULT3, VPARP, VWA5C, p193', description='poly(ADP-ribose) polymerase family member 4', other_designations='193 kDa vault protein|ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase)-like 1|ADP-ribosyltransferase diphtheria toxin-like 4|H5 proline-rich|I-alpha-I-related|PARP-related|PARP-related/IalphaI-related H5/proline-rich|poly (ADP-ribose) polymerase family, member 4|poly(ADP-ribose) synthetase|poly(ADP-ribosyl)transferase-like 1|vault poly(ADP-ribose) polymerase|vault protein, 193-kDa|von Willebrand factor A domain containing 5C', map_location='13q11', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=24420930, end_position_on_the_genomic_accession=24512993, orientation='minus', exon_count=36, OMIM=607519, no_hdr0=''),
  221504 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=221504, CurrentID=0, Status='live', Symbol='ZBTB9', Aliases='ZNF919', description='zinc finger and BTB domain containing 9', other_designations='', map_location='6p21.32', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=33454579, end_position_on_the_genomic_accession=33457544, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  131096 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131096, CurrentID=0, Status='live', Symbol='KCNH8', Aliases='ELK, ELK1, Kv12.1, elk3', description='potassium voltage-gated channel subfamily H member 8', other_designations='ELK channel 3|ether-a-go-go-like potassium channel 1|ether-a-go-go-like potassium channel 3|hElk1|potassium channel, voltage gated eag related subfamily H, member 8|potassium voltage-gated channel, subfamily H (eag-related), member 8|voltage-gated potassium channel subunit Kv12.1', map_location='3p24.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=19147093, end_position_on_the_genomic_accession=19535643, orientation='plus', exon_count=19, OMIM=608260, no_hdr0=''),
  146 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=146, CurrentID=0, Status='live', Symbol='ADRA1D', Aliases='ADRA1, ADRA1A, ADRA1R, ALPHA1, DAR, dJ779E11.2', description='adrenoceptor alpha 1D', other_designations='adrenergic, alpha -1D-, receptor|adrenergic, alpha-1A-, receptor|adrenergic, alpha-1D-, receptor|alpha-1A adrenergic receptor|alpha-1D adrenoceptor|alpha-1D adrenoreceptor|alpha-1D-adrenergic receptor|alpha-adrenergic receptor 1a', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=4220631, end_position_on_the_genomic_accession=4249012, orientation='minus', exon_count=2, OMIM=104219, no_hdr0=''),
  147 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=147, CurrentID=0, Status='live', Symbol='ADRA1B', Aliases='ADRA1, ALPHA1BAR', description='adrenoceptor alpha 1B', other_designations='adrenergic, alpha-1B-, receptor|alpha-1B adrenoceptor|alpha-1B adrenoreceptor|alpha-1B-adrenergic receptor', map_location='5q33.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=159916733, end_position_on_the_genomic_accession=159986178, orientation='plus', exon_count=8, OMIM=104220, no_hdr0=''),
  148 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=148, CurrentID=0, Status='live', Symbol='ADRA1A', Aliases='ADRA1C, ADRA1L1, ALPHA1AAR', description='adrenoceptor alpha 1A', other_designations='G protein coupled receptor|adrenergic, alpha-1A-, receptor variant 1|adrenergic, alpha-1A-, receptor variant 11|adrenergic, alpha-1A-, receptor variant 2|adrenergic, alpha-1A-, receptor variant 3|adrenergic, alpha-1A-, receptor variant 4|adrenergic, alpha-1A-, receptor variant 5|adrenergic, alpha-1A-, receptor variant 6|adrenergic, alpha-1A-, receptor variant 8|adrenergic, alpha-1A-, receptor variant 9|alpha-1A adrenoceptor|alpha-1A adrenoreceptor|alpha-1C adrenergic receptor', map_location='8p21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=26742847, end_position_on_the_genomic_accession=26871008, orientation='minus', exon_count=8, OMIM=104221, no_hdr0=''),
  150 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=150, CurrentID=0, Status='live', Symbol='ADRA2A', Aliases='ADRA2, ADRA2R, ADRAR, ALPHA2AAR, ZNF32', description='adrenoceptor alpha 2A', other_designations='adrenergic, alpha-2A-, receptor|alpha-2 adrenergic receptor subtype C10|alpha-2-adrenergic receptor, platelet type|alpha-2A adrenoceptor|alpha-2A adrenoreceptor|alpha-2AAR subtype C10', map_location='10q25.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=111077032, end_position_on_the_genomic_accession=111080907, orientation='plus', exon_count=1, OMIM=104210, no_hdr0=''),
  151 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=151, CurrentID=0, Status='live', Symbol='ADRA2B', Aliases='ADRA2L1, ADRA2RL1, ADRARL1, ALPHA2BAR, FAME2, alpha-2BAR', description='adrenoceptor alpha 2B', other_designations='ADRA2B adrenergic, alpha-2B-, receptor|G-protein coupled receptor|alpha-2 adrenergic receptor subtype C2|alpha-2-adrenergic receptor-like 1|alpha-2B adrenoreceptor', map_location='2q11.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=96112875, end_position_on_the_genomic_accession=96116245, orientation='minus', exon_count=1, OMIM=104260, no_hdr0=''),
  152 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=152, CurrentID=0, Status='live', Symbol='ADRA2C', Aliases='ADRA2L2, ADRA2RL2, ADRARL2, ALPHA2CAR', description='adrenoceptor alpha 2C', other_designations='adrenergic, alpha-2C-, receptor|alpha-2 adrenergic receptor subtype C4|alpha-2C adrenoceptor|alpha-2C adrenoreceptor|alpha-2C-adrenergic receptor|alpha-2CAR|alpha2-AR-C4', map_location='4p16', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=3766569, end_position_on_the_genomic_accession=3768526, orientation='plus', exon_count=1, OMIM=104250, no_hdr0=''),
  153 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=153, CurrentID=0, Status='live', Symbol='ADRB1', Aliases='ADRB1R, B1AR, BETA1AR, RHR', description='adrenoceptor beta 1', other_designations='adrenergic, beta-1-, receptor|beta-1 adrenoceptor|beta-1 adrenoreceptor', map_location='10q25.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=114044047, end_position_on_the_genomic_accession=114046908, orientation='plus', exon_count=1, OMIM=109630, no_hdr0=''),
  154 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=154, CurrentID=0, Status='live', Symbol='ADRB2', Aliases='ADRB2R, ADRBR, B2AR, BAR, BETA2AR', description='adrenoceptor beta 2', other_designations='adrenergic, beta-2-, receptor, surface|adrenoceptor beta 2 surface|adrenoceptor beta 2, surface|beta-2 adrenoceptor|beta-2 adrenoreceptor|catecholamine receptor', map_location='5q31-q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=148826593, end_position_on_the_genomic_accession=148828634, orientation='plus', exon_count=1, OMIM=109690, no_hdr0=''),
  155 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=155, CurrentID=0, Status='live', Symbol='ADRB3', Aliases='BETA3AR', description='adrenoceptor beta 3', other_designations='adrenergic, beta-3-, receptor|beta-3 adrenoceptor|beta-3 adrenoreceptor', map_location='8p11.23', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=37962995, end_position_on_the_genomic_accession=37966666, orientation='minus', exon_count=2, OMIM=109691, no_hdr0=''),
  156 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=156, CurrentID=0, Status='live', Symbol='ADRBK1', Aliases='BARK1, BETA-ARK1, GRK2', description='adrenergic, beta, receptor kinase 1', other_designations='G-protein coupled receptor kinase 2|adrenergic beta receptor kinase 1|beta-ARK-1', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=67266400, end_position_on_the_genomic_accession=67286558, orientation='plus', exon_count=22, OMIM=109635, no_hdr0=''),
  157 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=157, CurrentID=0, Status='live', Symbol='ADRBK2', Aliases='BARK2, GRK3', description='adrenergic, beta, receptor kinase 2', other_designations='G-protein-coupled receptor kinase 3|beta-ARK-2', map_location='22q12.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=25517856, end_position_on_the_genomic_accession=25729294, orientation='plus', exon_count=25, OMIM=109636, no_hdr0=''),
  158 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=158, CurrentID=0, Status='live', Symbol='ADSL', Aliases='AMPS, ASASE, ASL', description='adenylosuccinate lyase', other_designations='adenylosuccinase', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=40346500, end_position_on_the_genomic_accession=40387408, orientation='plus', exon_count=16, OMIM=608222, no_hdr0=''),
  159 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=159, CurrentID=0, Status='live', Symbol='ADSS', Aliases='ADEH 2, ADSS', description='adenylosuccinate synthase', other_designations='AMPSase 2|IMP--aspartate ligase 2|L-type adenylosuccinate synthetase|adSS 2|adenylosuccinate synthetase (Ade(-)H-complementing)|adenylosuccinate synthetase, acidic isozyme|adenylosuccinate synthetase, liver isozyme', map_location='1q44', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=244408492, end_position_on_the_genomic_accession=244452134, orientation='minus', exon_count=14, OMIM=103060, no_hdr0=''),
  160 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=160, CurrentID=0, Status='live', Symbol='AP2A1', Aliases='ADTAA, AP2-ALPHA, CLAPA1', description='adaptor related protein complex 2 alpha 1 subunit', other_designations='100 kDa coated vesicle protein A|adapter-related protein complex 2 alpha-1 subunit|adapter-related protein complex 2 subunit alpha-1|adaptin, alpha A|adaptor protein complex AP-2 subunit alpha-1|adaptor related protein complex 2, alpha 1 subunit|adaptor-related protein complex 2 subunit alpha-1|adaptor-related protein complex 2, alpha 1 subunit|alpha-adaptin A|alpha1-adaptin|clathrin assembly protein complex 2 alpha-A large chain|clathrin-associated/assembly/adaptor protein, large, alpha 1|plasma membrane adaptor HA2/AP2 adaptin alpha A subunit', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=49766923, end_position_on_the_genomic_accession=49807112, orientation='plus', exon_count=25, OMIM=601026, no_hdr0=''),
  161 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=161, CurrentID=0, Status='live', Symbol='AP2A2', Aliases='ADTAB, CLAPA2, HIP-9, HIP9, HYPJ', description='adaptor related protein complex 2 alpha 2 subunit', other_designations='100 kDa coated vesicle protein C|adapter-related protein complex 2 subunit alpha-2|adaptin, alpha B|adaptor related protein complex 2, alpha 2 subunit|adaptor-related protein complex 2 subunit alpha-2|adaptor-related protein complex 2, alpha 2 subunit|alpha-adaptin C; Huntingtin interacting protein J|alpha2-adaptin|clathrin assembly protein complex 2 alpha-C large chain|clathrin-associated/assembly/adaptor protein, large, alpha 2|huntingtin yeast partner J|huntingtin-interacting protein 9|plasma membrane adaptor HA2/AP2 adaptin alpha C subunit', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=925809, end_position_on_the_genomic_accession=1012245, orientation='plus', exon_count=25, OMIM=607242, no_hdr0=''),
  162 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=162, CurrentID=0, Status='live', Symbol='AP1B1', Aliases='ADTB1, AP105A, BAM22, CLAPB2', description='adaptor related protein complex 1 beta 1 subunit', other_designations='Golgi adaptor HA1/AP1 adaptin beta subunit|adapter-related protein complex 1 subunit beta-1|adaptor protein complex AP-1 subunit beta-1|adaptor-related protein complex 1 beta 1 subunit|adaptor-related protein complex 1 subunit beta-1|adaptor-related protein complex 1, beta 1 subunit|beta-1-adaptin|beta-adaptin 1|beta-prime-adaptin|beta1-adaptin|clathrin assembly protein complex 1 beta large chain|plasma membrane adaptor HA2/AP2 adaptor beta subunit', map_location='22q12.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=29327680, end_position_on_the_genomic_accession=29388583, orientation='minus', exon_count=23, OMIM=600157, no_hdr0=''),
  163 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=163, CurrentID=0, Status='live', Symbol='AP2B1', Aliases='ADTB2, AP105B, AP2-BETA, CLAPB1', description='adaptor related protein complex 2 beta 1 subunit', other_designations='adapter-related protein complex 2 beta subunit|adapter-related protein complex 2 subunit beta|adaptin, beta 2 (beta)|adaptor protein complex AP-2 subunit beta|adaptor related protein complex 2, beta 1 subunit|adaptor-related protein complex 2 subunit beta|adaptor-related protein complex 2, beta 1 subunit|beta-2-adaptin|beta-adaptin|clathrin assembly protein complex 2 beta large chain|clathrin-associated/assembly/adaptor protein, large, beta 1|plasma membrane adaptor HA2/AP2 adaptin beta subunit', map_location='17q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=35586899, end_position_on_the_genomic_accession=35726417, orientation='plus', exon_count=26, OMIM=601025, no_hdr0=''),
  164 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=164, CurrentID=0, Status='live', Symbol='AP1G1', Aliases='ADTG, CLAPG1', description='adaptor related protein complex 1 gamma 1 subunit', other_designations='adapter-related protein complex 1 subunit gamma-1|adaptor protein complex AP-1 subunit gamma-1|adaptor-related protein complex 1 gamma 1 subunit|adaptor-related protein complex 1 subunit gamma-1|adaptor-related protein complex 1, gamma 1 subunit|clathrin assembly protein complex 1 gamma large chain|clathrin assembly protein complex 1 gamma-1 large chain|clathrin-associated/assembly/adaptor protein, large, gamma 1|gamma adaptin|gamma1-adaptin|golgi adaptor HA1/AP1 adaptin gamma subunit|golgi adaptor HA1/AP1 adaptin subunit gamma-1', map_location='16q23', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=71729000, end_position_on_the_genomic_accession=71809073, orientation='minus', exon_count=24, OMIM=603533, no_hdr0=''),
  165 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=165, CurrentID=0, Status='live', Symbol='AEBP1', Aliases='ACLP', description='AE binding protein 1', other_designations='aortic carboxypeptidase-like protein', map_location='7p13', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=44104320, end_position_on_the_genomic_accession=44114565, orientation='plus', exon_count=21, OMIM=602981, no_hdr0=''),
  166 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=166, CurrentID=0, Status='live', Symbol='AES', Aliases='AES-1-2, ESP1, GRG, GRG5, Grg-5, TLE5, AES', description='amino-terminal enhancer of split', other_designations='gp130-associated protein GAM|groucho-related protein 5', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=3052910, end_position_on_the_genomic_accession=3063107, orientation='minus', exon_count=8, OMIM=600188, no_hdr0=''),
  167 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=167, CurrentID=0, Status='live', Symbol='CRISP1', Aliases='AEGL1, ARP, CRISP-1, HEL-S-57, HSCRISP1D, HSCRISP1G, HUMARP', description='cysteine rich secretory protein 1', other_designations='AEG-like protein|AEG-related protein|acidic epididymal glycoprotein homolog|acidic epididymal glycoprotein-like 1|cysteine-rich secretory protein-1 delta|epididymis secretory protein Li 57', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=49834257, end_position_on_the_genomic_accession=49877096, orientation='minus', exon_count=10, OMIM=601193, no_hdr0=''),
  100128851 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100128851, CurrentID=0, Status='live', Symbol='LOC100128851', Aliases='', description='uncharacterized LOC100128851', other_designations='', map_location='17p11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.9', start_position_on_the_genomic_accession=19163539, end_position_on_the_genomic_accession=19164242, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  173 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=173, CurrentID=0, Status='live', Symbol='AFM', Aliases='ALB2, ALBA, ALF', description='afamin', other_designations='alpha-Alb|alpha-albumin', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=73481745, end_position_on_the_genomic_accession=73504001, orientation='plus', exon_count=15, OMIM=104145, no_hdr0=''),
  174 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=174, CurrentID=0, Status='live', Symbol='AFP', Aliases='AFPD, FETA, HPAFP', description='alpha fetoprotein', other_designations='alpha-1-fetoprotein|alpha-fetoglobulin', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=73423104, end_position_on_the_genomic_accession=73455785, orientation='plus', exon_count=16, OMIM=104150, no_hdr0=''),
  175 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=175, CurrentID=0, Status='live', Symbol='AGA', Aliases='AGU, ASRG, GA', description='aspartylglucosaminidase', other_designations='N4-(N-acetyl-beta-glucosaminyl)-L-asparagine amidase|aspartylglucosylamine deaspartylase|glycosylasparaginase', map_location='4q34.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=177430774, end_position_on_the_genomic_accession=177442503, orientation='minus', exon_count=9, OMIM=613228, no_hdr0=''),
  176 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=176, CurrentID=0, Status='live', Symbol='ACAN', Aliases='AGC1, AGCAN, CSPG1, CSPGCP, MSK16, SEDK', description='aggrecan', other_designations='cartilage-specific proteoglycan core protein|chondroitin sulfate proteoglycan core protein 1|large aggregating proteoglycan', map_location='15q26.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=88803442, end_position_on_the_genomic_accession=88875354, orientation='plus', exon_count=19, OMIM=155760, no_hdr0=''),
  177 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=177, CurrentID=0, Status='live', Symbol='AGER', Aliases='RAGE', description='advanced glycosylation end product-specific receptor', other_designations='RAGE isoform NtRAGE-delta|RAGE isoform sRAGE-delta|receptor for advanced glycation end-products variant 20', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=32180968, end_position_on_the_genomic_accession=32184322, orientation='minus', exon_count=11, OMIM=600214, no_hdr0=''),
  178 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=178, CurrentID=0, Status='live', Symbol='AGL', Aliases='GDE', description='amylo-alpha-1, 6-glucosidase, 4-alpha-glucanotransferase', other_designations='amylo-1, 6-glucosidase, 4-alpha-glucanotransferase|amylo-alpha-1, 6-glucosidase, 4-alpha-glucanotransferaseprovided|glycogen debrancher|glycogen debranching protein', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=99850077, end_position_on_the_genomic_accession=99924023, orientation='plus', exon_count=36, OMIM=610860, no_hdr0=''),
  181 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=181, CurrentID=0, Status='live', Symbol='AGRP', Aliases='AGRT, ART, ASIP2', description='agouti related neuropeptide', other_designations='agouti related protein homolog', map_location='16q22', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=67482571, end_position_on_the_genomic_accession=67484083, orientation='minus', exon_count=5, OMIM=602311, no_hdr0=''),
  182 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=182, CurrentID=0, Status='live', Symbol='JAG1', Aliases='AGS, AHD, AWS, CD339, HJ1, JAGL1', description='jagged 1', other_designations='', map_location='20p12.1-p11.23', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=10637684, end_position_on_the_genomic_accession=10674046, orientation='minus', exon_count=26, OMIM=601920, no_hdr0=''),
  183 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=183, CurrentID=0, Status='live', Symbol='AGT', Aliases='ANHU, SERPINA8', description='angiotensinogen', other_designations='alpha-1 antiproteinase, antitrypsin|angiotensin I|angiotensin II|angiotensinogen (serpin peptidase inhibitor, clade A, member 8)|pre-angiotensinogen|serine (or cysteine) proteinase inhibitor|serpin A8', map_location='1q42.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=230702523, end_position_on_the_genomic_accession=230714590, orientation='minus', exon_count=5, OMIM=106150, no_hdr0=''),
  196792 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=196792, CurrentID=0, Status='live', Symbol='FAM24B', Aliases='', description='family with sequence similarity 24 member B', other_designations='family with sequence similarity 24, member B', map_location='10q26.13', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=122849094, end_position_on_the_genomic_accession=122879641, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  185 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=185, CurrentID=0, Status='live', Symbol='AGTR1', Aliases='AG2SB, AT1, AT1AR, AT1B, AT1BR, AT1R, AT2R1, HAT1R, AGTR1', description='angiotensin II receptor type 1', other_designations='angiotensin II receptor, type 1|type-1B angiotensin II receptor', map_location='3q24', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=148697871, end_position_on_the_genomic_accession=148743003, orientation='plus', exon_count=5, OMIM=106165, no_hdr0=''),
  186 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=186, CurrentID=0, Status='live', Symbol='AGTR2', Aliases='AT2, ATGR2, MRX88', description='angiotensin II receptor type 2', other_designations='angiotensin II receptor, type 2|angiotensin II type-2 receptor', map_location='Xq22-q23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=116170705, end_position_on_the_genomic_accession=116174972, orientation='plus', exon_count=3, OMIM=300034, no_hdr0=''),
  187 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=187, CurrentID=0, Status='live', Symbol='APLNR', Aliases='AGTRL1, APJ, APJR, HG11', description='apelin receptor', other_designations='APJ (apelin) receptor|APJ receptor|G protein-coupled receptor APJ|G-protein coupled receptor APJ|G-protein coupled receptor HG11|HG11 orphan receptor|angiotensin II receptor-like 1|angiotensin receptor-like 1', map_location='11q12', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=57233577, end_position_on_the_genomic_accession=57237453, orientation='minus', exon_count=1, OMIM=600052, no_hdr0=''),
  189 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=189, CurrentID=0, Status='live', Symbol='AGXT', Aliases='AGT, AGT11, PH1, SPAT, SPT, TLH6, AGXT', description='alanine-glyoxylate aminotransferase', other_designations='L-alanine: glyoxylate aminotransferase 1|alanine--glyoxylate aminotransferase|hepatic peroxisomal alanine:glyoxylate aminotransferase|serine-pyruvate aminotransferase|serine:pyruvate aminotransferase', map_location='2q37.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=240868745, end_position_on_the_genomic_accession=240879119, orientation='plus', exon_count=11, OMIM=604285, no_hdr0=''),
  190 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=190, CurrentID=0, Status='live', Symbol='NR0B1', Aliases='AHC, AHCH, AHX, DAX-1, DAX1, DSS, GTD, HHG, NROB1, SRXY2', description='nuclear receptor subfamily 0 group B member 1', other_designations='DSS-AHC critical region on the X chromosome protein 1|nuclear hormone receptor|nuclear receptor DAX-1|nuclear receptor subfamily 0, group B, member 1', map_location='Xp21.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=30304422, end_position_on_the_genomic_accession=30309378, orientation='minus', exon_count=2, OMIM=300473, no_hdr0=''),
  191 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=191, CurrentID=0, Status='live', Symbol='AHCY', Aliases='SAHH, adoHcyase', description='adenosylhomocysteinase', other_designations='S-adenosyl-L-homocysteine hydrolase|S-adenosylhomocysteine hydrolase', map_location='20q11.22', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=34234840, end_position_on_the_genomic_accession=34311976, orientation='minus', exon_count=17, OMIM=180960, no_hdr0=''),
  645073 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=645073, CurrentID=0, Status='live', Symbol='GAGE12G', Aliases='AL4, CT4.7, GAGE-12G', description='G antigen 12G', other_designations='cancer/testis antigen 4.7|g antigen 12F/G/I', map_location='Xp11.23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=49570400, end_position_on_the_genomic_accession=49577757, orientation='plus', exon_count=5, OMIM=300731, no_hdr0=''),
  400451 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=400451, CurrentID=0, Status='live', Symbol='FAM174B', Aliases='', description='family with sequence similarity 174 member B', other_designations='family with sequence similarity 174, member B', map_location='15q26.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=92617448, end_position_on_the_genomic_accession=92812338, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  387787 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=387787, CurrentID=0, Status='live', Symbol='LIPT2', Aliases='', description='lipoyl(octanoyl) transferase 2 (putative)', other_designations='lipoate-protein ligase B|lipoyl/octanoyl transferase|octanoyl-[acyl-carrier-protein]-protein N-octanoyltransferase|putative octanoyltransferase, mitochondrial', map_location='11q13.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=74490727, end_position_on_the_genomic_accession=74493719, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  196 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=196, CurrentID=0, Status='live', Symbol='AHR', Aliases='bHLHe76', description='aryl hydrocarbon receptor', other_designations='AH-receptor|ah receptor|aromatic hydrocarbon receptor|class E basic helix-loop-helix protein 76', map_location='7p15', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=17298652, end_position_on_the_genomic_accession=17346151, orientation='plus', exon_count=11, OMIM=600253, no_hdr0=''),
  197 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=197, CurrentID=0, Status='live', Symbol='AHSG', Aliases='A2HS, AHS, FETUA, HSGA', description='alpha-2-HS-glycoprotein', other_designations='alpha-2-Z-globulin|ba-alpha-2-glycoprotein|fetuin-A', map_location='3q27', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186613061, end_position_on_the_genomic_accession=186621318, orientation='plus', exon_count=7, OMIM=138680, no_hdr0=''),
  199 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=199, CurrentID=0, Status='live', Symbol='AIF1', Aliases='AIF-1, IBA1, IRT-1, IRT1', description='allograft inflammatory factor 1', other_designations='interferon gamma responsive transcript|ionized calcium-binding adapter molecule 1|protein G1', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31615192, end_position_on_the_genomic_accession=31617021, orientation='plus', exon_count=6, OMIM=601833, no_hdr0=''),
  202 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=202, CurrentID=0, Status='live', Symbol='AIM1', Aliases='CRYBG1, ST4', description='absent in melanoma 1', other_designations='beta-gamma crystallin domain containing 1|beta/gamma crystallin domain-containing protein 1|suppression of tumorigenicity 4 (malignant melanoma)', map_location='6q21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=106360808, end_position_on_the_genomic_accession=106570451, orientation='plus', exon_count=22, OMIM=601797, no_hdr0=''),
  203 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=203, CurrentID=0, Status='live', Symbol='AK1', Aliases='HTL-S-58j', description='adenylate kinase 1', other_designations='ATP-AMP transphosphorylase 1|ATP:AMP phosphotransferase|adenylate monophosphate kinase|myokinase|testis secretory sperm binding protein Li 58j', map_location='9q34.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=127866480, end_position_on_the_genomic_accession=127877743, orientation='minus', exon_count=9, OMIM=103000, no_hdr0=''),
  204 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=204, CurrentID=0, Status='live', Symbol='AK2', Aliases='ADK2', description='adenylate kinase 2', other_designations='AK 2|ATP-AMP transphosphorylase 2|ATP:AMP phosphotransferase|adenylate kinase isoenzyme 2, mitochondrial|adenylate monophosphate kinase', map_location='1p34', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=33007940, end_position_on_the_genomic_accession=33036911, orientation='minus', exon_count=8, OMIM=103020, no_hdr0=''),
  205 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=205, CurrentID=0, Status='live', Symbol='AK4', Aliases='AK 4, AK3, AK3L1, AK3L2', description='adenylate kinase 4', other_designations='AK 4|ATP-AMP transphosphorylase|GTP:AMP phosphotransferase AK4, mitochondrial|adenylate kinase 3-like 1|adenylate kinase isoenzyme 4, mitochondrial|mitochondrial adenylate kinase-3|nucleoside-triphosphate-adenylate kinase', map_location='1p31.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=65147549, end_position_on_the_genomic_accession=65232145, orientation='plus', exon_count=7, OMIM=103030, no_hdr0=''),
  207 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=207, CurrentID=0, Status='live', Symbol='AKT1', Aliases='AKT, CWS6, PKB, PKB-ALPHA, PRKBA, RAC, RAC-ALPHA', description='v-akt murine thymoma viral oncogene homolog 1', other_designations='AKT1m|PKB alpha|RAC-PK-alpha|protein kinase B alpha|proto-oncogene c-Akt|rac protein kinase alpha|v-akt murine thymoma viral oncogene-like protein 1', map_location='14q32.32', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=104769349, end_position_on_the_genomic_accession=104795743, orientation='minus', exon_count=17, OMIM=164730, no_hdr0=''),
  208 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=208, CurrentID=0, Status='live', Symbol='AKT2', Aliases='HIHGHH, PKBB, PKBBETA, PRKBB, RAC-BETA', description='v-akt murine thymoma viral oncogene homolog 2', other_designations='PKB beta|RAC-PK-beta|murine thymoma viral (v-akt) homolog-2|protein kinase Akt-2|protein kinase B beta|putative v-akt murine thymoma viral oncoprotein 2|rac protein kinase beta', map_location='19q13.1-q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40230317, end_position_on_the_genomic_accession=40285531, orientation='minus', exon_count=23, OMIM=164731, no_hdr0=''),
  345895 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=345895, CurrentID=0, Status='live', Symbol='RSPH4A', Aliases='CILD11, RSHL3, RSPH6B, dJ412I7.1', description='radial spoke head 4 homolog A (Chlamydomonas)', other_designations='radial spoke head-like protein 3|radial spokehead-like 3', map_location='6q22.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=116593900, end_position_on_the_genomic_accession=116633051, orientation='plus', exon_count=9, OMIM=612647, no_hdr0=''),
  210 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=210, CurrentID=0, Status='live', Symbol='ALAD', Aliases='ALADH, PBGS', description='aminolevulinate dehydratase', other_designations='aminolevulinate, delta-, dehydratase|porphobilinogen synthase', map_location='9q33.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=113386312, end_position_on_the_genomic_accession=113401338, orientation='minus', exon_count=16, OMIM=125270, no_hdr0=''),
  211 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=211, CurrentID=0, Status='live', Symbol='ALAS1', Aliases='ALAS, ALAS-H, ALAS3, ALASH, MIG4', description="5'-aminolevulinate synthase 1", other_designations='5-aminolevulinic acid synthase 1|aminolevulinate, delta-, synthase 1|delta-ALA synthase 1|delta-aminolevulinate synthase 1|migration-inducing protein 4', map_location='3p21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=52198083, end_position_on_the_genomic_accession=52214327, orientation='plus', exon_count=12, OMIM=125290, no_hdr0=''),
  212 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=212, CurrentID=0, Status='live', Symbol='ALAS2', Aliases='ALAS-E, ALASE, ANH1, ASB, XLDPP, XLEPP, XLSA', description="5'-aminolevulinate synthase 2", other_designations='5-aminolevulinic acid synthase 2|aminolevulinate, delta-, synthase 2|delta-ALA synthase 2|delta-ALA synthetase|delta-aminolevulinate synthase 2', map_location='Xp11.21', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=55009055, end_position_on_the_genomic_accession=55031064, orientation='minus', exon_count=12, OMIM=301300, no_hdr0=''),
  213 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=213, CurrentID=0, Status='live', Symbol='ALB', Aliases='ANALBA, FDAH, PRO0883, PRO0903, PRO1341', description='albumin', other_designations='albumin (32 AA)|albumin (AA 34)|cell growth inhibiting protein 42|growth-inhibiting protein 20', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=73404255, end_position_on_the_genomic_accession=73421412, orientation='plus', exon_count=15, OMIM=103600, no_hdr0=''),
  214 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=214, CurrentID=0, Status='live', Symbol='ALCAM', Aliases='CD166, MEMD', description='activated leukocyte cell adhesion molecule', other_designations='', map_location='3q13.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=105366713, end_position_on_the_genomic_accession=105576913, orientation='plus', exon_count=16, OMIM=601662, no_hdr0=''),
  215 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=215, CurrentID=0, Status='live', Symbol='ABCD1', Aliases='ABC42, ALD, ALDP, AMN', description='ATP binding cassette subfamily D member 1', other_designations='ATP-binding cassette, sub-family D (ALD), member 1|adrenoleukodystrophy protein', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153724851, end_position_on_the_genomic_accession=153744762, orientation='plus', exon_count=11, OMIM=300371, no_hdr0=''),
  216 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=216, CurrentID=0, Status='live', Symbol='ALDH1A1', Aliases='ALDC, ALDH-E1, ALDH1, ALDH11, HEL-9, HEL-S-53e, HEL12, PUMB1, RALDH1', description='aldehyde dehydrogenase 1 family member A1', other_designations='ALDH class 1|ALHDII|RALDH 1|acetaldehyde dehydrogenase 1|aldehyde dehydrogenase 1 family, member A1|aldehyde dehydrogenase 1, soluble|aldehyde dehydrogenase, liver cytosolic|epididymis luminal protein 12|epididymis luminal protein 9|epididymis secretory sperm binding protein Li 53e|retinaldehyde dehydrogenase 1', map_location='9q21.13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=72900662, end_position_on_the_genomic_accession=72953317, orientation='minus', exon_count=13, OMIM=100640, no_hdr0=''),
  217 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=217, CurrentID=0, Status='live', Symbol='ALDH2', Aliases='ALDH-E2, ALDHI, ALDM', description='aldehyde dehydrogenase 2 family (mitochondrial)', other_designations='ALDH class 2|acetaldehyde dehydrogenase 2|liver mitochondrial ALDH|nucleus-encoded mitochondrial aldehyde dehydrogenase 2', map_location='12q24.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=111766887, end_position_on_the_genomic_accession=111809985, orientation='plus', exon_count=13, OMIM=100650, no_hdr0=''),
  218 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=218, CurrentID=0, Status='live', Symbol='ALDH3A1', Aliases='ALDH3, ALDHIII', description='aldehyde dehydrogenase 3 family member A1', other_designations='aldehyde dehydrogenase 3 family, member A1|aldehyde dehydrogenase isozyme 3|aldehyde dehydrogenase type III|stomach aldehyde dehydrogenase', map_location='17p11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=19737984, end_position_on_the_genomic_accession=19748433, orientation='minus', exon_count=13, OMIM=100660, no_hdr0=''),
  219 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=219, CurrentID=0, Status='live', Symbol='ALDH1B1', Aliases='ALDH5, ALDHX', description='aldehyde dehydrogenase 1 family member B1', other_designations='ALDH class 2|acetaldehyde dehydrogenase 5|aldehyde dehydrogenase 1 family, member B1|aldehyde dehydrogenase 5', map_location='9p11.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=38392664, end_position_on_the_genomic_accession=38398665, orientation='plus', exon_count=3, OMIM=100670, no_hdr0=''),
  220 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=220, CurrentID=0, Status='live', Symbol='ALDH1A3', Aliases='ALDH1A6, ALDH6, MCOP8, RALDH3', description='aldehyde dehydrogenase 1 family member A3', other_designations='acetaldehyde dehydrogenase 6|aldehyde dehydrogenase 1 family, member A3|aldehyde dehydrogenase 6|retinaldehyde dehydrogenase 3', map_location='15q26.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=100879692, end_position_on_the_genomic_accession=100916626, orientation='plus', exon_count=13, OMIM=600463, no_hdr0=''),
  221 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=221, CurrentID=0, Status='live', Symbol='ALDH3B1', Aliases='ALDH4, ALDH7', description='aldehyde dehydrogenase 3 family member B1', other_designations='aldehyde dehydrogenase 3 family, member B1|aldehyde dehydrogenase 3B1|aldehyde dehydrogenase 7', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=68008547, end_position_on_the_genomic_accession=68029282, orientation='plus', exon_count=11, OMIM=600466, no_hdr0=''),
  222 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=222, CurrentID=0, Status='live', Symbol='ALDH3B2', Aliases='ALDH8', description='aldehyde dehydrogenase 3 family member B2', other_designations='acetaldehyde dehydrogenase 8|aldehyde dehydrogenase 3 family, member B2|aldehyde dehydrogenase 8', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=67662155, end_position_on_the_genomic_accession=67681214, orientation='minus', exon_count=11, OMIM=601917, no_hdr0=''),
  223 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=223, CurrentID=0, Status='live', Symbol='ALDH9A1', Aliases='ALDH4, ALDH7, ALDH9, E3, TMABADH', description='aldehyde dehydrogenase 9 family member A1', other_designations='R-aminobutyraldehyde dehydrogenase|aldehyde dehydrogenase (NAD+)|aldehyde dehydrogenase 9 family, member A1|aldehyde dehydrogenase E3 isozyme|aldehyde dehydrogenase family 9 member A1|gamma-aminobutyraldehyde dehydrogenase', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=165662212, end_position_on_the_genomic_accession=165698663, orientation='minus', exon_count=11, OMIM=602733, no_hdr0=''),
  224 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=224, CurrentID=0, Status='live', Symbol='ALDH3A2', Aliases='ALDH10, FALDH, SLS', description='aldehyde dehydrogenase 3 family member A2', other_designations='aldehyde dehydrogenase 10|aldehyde dehydrogenase 3 family, member A2|aldehyde dehydrogenase family 3 member A2|microsomal aldehyde dehydrogenase', map_location='17p11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=19648136, end_position_on_the_genomic_accession=19677596, orientation='plus', exon_count=13, OMIM=609523, no_hdr0=''),
  225 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=225, CurrentID=0, Status='live', Symbol='ABCD2', Aliases='ABC39, ALDL1, ALDR, ALDRP, hALDR', description='ATP binding cassette subfamily D member 2', other_designations='ATP-binding cassette, sub-family D (ALD), member 2|adrenoleukodystrophy-like 1|adrenoleukodystrophy-related protein', map_location='12q12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=39550353, end_position_on_the_genomic_accession=39651328, orientation='minus', exon_count=12, OMIM=601081, no_hdr0=''),
  226 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=226, CurrentID=0, Status='live', Symbol='ALDOA', Aliases='ALDA, GSD12, HEL-S-87p', description='aldolase, fructose-bisphosphate A', other_designations='aldolase A, fructose-bisphosphate|epididymis secretory sperm binding protein Li 87p|fructose-1,6-bisphosphate triosephosphate-lyase|lung cancer antigen NY-LU-1|muscle-type aldolase', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=30053090, end_position_on_the_genomic_accession=30070420, orientation='plus', exon_count=17, OMIM=103850, no_hdr0=''),
  229 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=229, CurrentID=0, Status='live', Symbol='ALDOB', Aliases='ALDB, ALDO2', description='aldolase, fructose-bisphosphate B', other_designations='aldolase 2|aldolase B, fructose-bisphosphatase|aldolase B, fructose-bisphosphate|liver-type aldolase', map_location='9q21.3-q22.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=101420560, end_position_on_the_genomic_accession=101435780, orientation='minus', exon_count=9, OMIM=612724, no_hdr0=''),
  230 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=230, CurrentID=0, Status='live', Symbol='ALDOC', Aliases='ALDC', description='aldolase, fructose-bisphosphate C', other_designations='aldolase 3|aldolase C, fructose-bisphosphate|brain-type aldolase|fructoaldolase C|fructose-1,6-biphosphate triosephosphate lyase', map_location='17cen-q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=28573115, end_position_on_the_genomic_accession=28576948, orientation='minus', exon_count=10, OMIM=103870, no_hdr0=''),
  231 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=231, CurrentID=0, Status='live', Symbol='AKR1B1', Aliases='ADR, ALDR1, ALR2, AR', description='aldo-keto reductase family 1, member B1 (aldose reductase)', other_designations='Lii5-2 CTCL tumor antigen|aldehyde reductase 1|aldo-keto reductase family 1 member B1|low Km aldose reductase', map_location='7q35', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=134442351, end_position_on_the_genomic_accession=134459136, orientation='minus', exon_count=10, OMIM=103880, no_hdr0=''),
  152956 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=152956, CurrentID=0, Status='live', Symbol='FLJ12425', Aliases='', description='uncharacterized protein FLJ12425', other_designations='', map_location='4q22.3', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  238 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=238, CurrentID=0, Status='live', Symbol='ALK', Aliases='CD246, NBLST3', description='anaplastic lymphoma receptor tyrosine kinase', other_designations='CD246 antigen|mutant anaplastic lymphoma kinase', map_location='2p23', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=29192774, end_position_on_the_genomic_accession=29921611, orientation='minus', exon_count=29, OMIM=105590, no_hdr0=''),
  239 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=239, CurrentID=0, Status='live', Symbol='ALOX12', Aliases='12-LOX, 12S-LOX, LOG12', description='arachidonate 12-lipoxygenase', other_designations='12(S)-lipoxygenase|12S-lipoxygenase|lipoxin synthase 12-LO|platelet 12-LOX|platelet-type 12-lipoxygenase|platelet-type lipoxygenase 12', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=6994196, end_position_on_the_genomic_accession=7010754, orientation='plus', exon_count=14, OMIM=152391, no_hdr0=''),
  240 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=240, CurrentID=0, Status='live', Symbol='ALOX5', Aliases='5-LO, 5-LOX, 5LPG, LOG5', description='arachidonate 5-lipoxygenase', other_designations='LOX-5|arachidonic 5-lipoxygenase alpha-10 isoform|arachidonic 5-lipoxygenase delta-10-13 isoform|arachidonic 5-lipoxygenase delta-13 isoform|arachidonic 5-lipoxygenase delta-p10 isoform|arachidonic acid 5-lipoxygenase|leukotriene A4 synthase', map_location='10q11.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=45374176, end_position_on_the_genomic_accession=45446121, orientation='plus', exon_count=14, OMIM=152390, no_hdr0=''),
  241 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=241, CurrentID=0, Status='live', Symbol='ALOX5AP', Aliases='FLAP', description='arachidonate 5-lipoxygenase activating protein', other_designations='MK-886-binding protein', map_location='13q12', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=30713478, end_position_on_the_genomic_accession=30764428, orientation='plus', exon_count=8, OMIM=603700, no_hdr0=''),
  242 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=242, CurrentID=0, Status='live', Symbol='ALOX12B', Aliases='12R-LOX, ARCI2', description='arachidonate 12-lipoxygenase, 12R type', other_designations='12R-lipoxygenase|epidermis-type lipoxygenase 12', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=8072636, end_position_on_the_genomic_accession=8087703, orientation='minus', exon_count=15, OMIM=603741, no_hdr0=''),
  246 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=246, CurrentID=0, Status='live', Symbol='ALOX15', Aliases='12-LOX, 15-LOX-1, 15LOX-1', description='arachidonate 15-lipoxygenase', other_designations='12/15-lipoxygenase|15-LOX|15-lipooxygenase-1|arachidonate 12-lipoxygenase, leukocyte-type|arachidonate omega-6 lipoxygenase', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=4630919, end_position_on_the_genomic_accession=4641665, orientation='minus', exon_count=14, OMIM=152392, no_hdr0=''),
  247 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=247, CurrentID=0, Status='live', Symbol='ALOX15B', Aliases='15-LOX-2', description='arachidonate 15-lipoxygenase, type B', other_designations='15-LOX-B|15S-lipoxygenase|arachidonate 15-lipoxygenase 2|arachidonate 15-lipoxygenase type II|arachidonate 15-lipoxygenase, second type|arachidonate omega(6) lipoxygenase|linoleate 13-lipoxygenase 15-LOb', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=8039040, end_position_on_the_genomic_accession=8049134, orientation='plus', exon_count=14, OMIM=603697, no_hdr0=''),
  248 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=248, CurrentID=0, Status='live', Symbol='ALPI', Aliases='IAP', description='alkaline phosphatase, intestinal', other_designations='Kasahara isozyme|alkaline phosphomonoesterase|glycerophosphatase|intestinal alkaline phosphatase', map_location='2q37.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232456112, end_position_on_the_genomic_accession=232460745, orientation='plus', exon_count=11, OMIM=171740, no_hdr0=''),
  249 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=249, CurrentID=0, Status='live', Symbol='ALPL', Aliases='AP-TNAP, APTNAP, HOPS, TNAP, TNSALP', description='alkaline phosphatase, liver/bone/kidney', other_designations='alkaline phosphatase liver/bone/kidney isozyme|liver/bone/kidney-type alkaline phosphatase|tissue-nonspecific ALP', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=21508982, end_position_on_the_genomic_accession=21578412, orientation='plus', exon_count=15, OMIM=171760, no_hdr0=''),
  250 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=250, CurrentID=0, Status='live', Symbol='ALPP', Aliases='ALP, PALP, PLAP, PLAP-1', description='alkaline phosphatase, placental', other_designations='alkaline phosphatase Regan isozyme|alkaline phosphomonoesterase|glycerophosphatase|placental alkaline phosphatase 1', map_location='2q37', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232378534, end_position_on_the_genomic_accession=232382889, orientation='plus', exon_count=11, OMIM=171800, no_hdr0=''),
  251 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=251, CurrentID=0, Status='live', Symbol='ALPPL2', Aliases='ALPG, ALPPL, GCAP', description='alkaline phosphatase, placental like 2', other_designations='ALP-1|Nagao isozyme|alkaline phosphatase Nagao isozyme|alkaline phosphatase, placental-like 2|germ cell alkaline phosphatase|placental-like alkaline phosphatase|testicular and thymus alkaline phosphatase', map_location='2q37', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232406842, end_position_on_the_genomic_accession=232410714, orientation='plus', exon_count=11, OMIM=171810, no_hdr0=''),
  338645 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=338645, CurrentID=0, Status='live', Symbol='LUZP2', Aliases='KFSP2566, PRO6246', description='leucine zipper protein 2', other_designations='', map_location='11p14.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=24496488, end_position_on_the_genomic_accession=25082640, orientation='plus', exon_count=15, OMIM=608178, no_hdr0=''),
  257 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=257, CurrentID=0, Status='live', Symbol='ALX3', Aliases='FND, FND1', description='ALX homeobox 3', other_designations='aristaless-like homeobox 3|frontonasal dysplasia|proline-rich transcription factor ALX3', map_location='1p13.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=110060375, end_position_on_the_genomic_accession=110070700, orientation='minus', exon_count=4, OMIM=606014, no_hdr0=''),
  258 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=258, CurrentID=0, Status='live', Symbol='AMBN', Aliases='AI1F', description='ameloblastin', other_designations='ameloblastin (enamel matrix protein)|enamel matrix protein', map_location='4q21', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=70592258, end_position_on_the_genomic_accession=70607288, orientation='plus', exon_count=13, OMIM=601259, no_hdr0=''),
  259 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=259, CurrentID=0, Status='live', Symbol='AMBP', Aliases='A1M, EDC1, HCP, HI30, IATIL, ITI, ITIL, ITILC, UTI', description='alpha-1-microglobulin/bikunin precursor', other_designations='bikunin|complex-forming glycoprotein heterogeneous in charge|growth-inhibiting protein 19|inter-alpha-trypsin inhibitor light chain|protein HC|trypstatin|uristatin|uronic-acid-rich protein', map_location='9q32-q33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=114060127, end_position_on_the_genomic_accession=114078472, orientation='minus', exon_count=10, OMIM=176870, no_hdr0=''),
  101929876 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=101929876, CurrentID=0, Status='live', Symbol='LOC101929876', Aliases='', description='40S ribosomal protein S26', other_designations='', map_location='', chromosome='20', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  10966 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=10966, CurrentID=0, Status='live', Symbol='RAB40B', Aliases='RAR, SEC4L', description='RAB40B, member RAS oncogene family', other_designations='GTP-binding protein homologous to Saccharomyces cerevisiae SEC4|SOCS box-containing protein RAR|protein Rar', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=82654959, end_position_on_the_genomic_accession=82698722, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  262 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=262, CurrentID=0, Status='live', Symbol='AMD1', Aliases='ADOMETDC, AMD, SAMDC', description='adenosylmethionine decarboxylase 1', other_designations='S-adenosylmethionine decarboxylase 1', map_location='6q21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=110814621, end_position_on_the_genomic_accession=110895713, orientation='plus', exon_count=10, OMIM=180980, no_hdr0=''),
  265 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=265, CurrentID=0, Status='live', Symbol='AMELX', Aliases='AI1E, AIH1, ALGN, AMG, AMGL, AMGX', description='amelogenin, X-linked', other_designations='amelogenesis imperfecta 1|amelogenin (X chromosome, amelogenesis imperfecta 1)|amelogenin (amelogenesis imperfecta 1, X-linked)', map_location='Xp22.31-p22.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=11292578, end_position_on_the_genomic_accession=11300761, orientation='plus', exon_count=8, OMIM=300391, no_hdr0=''),
  266 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=266, CurrentID=0, Status='live', Symbol='AMELY', Aliases='AMGL, AMGY', description='amelogenin, Y-linked', other_designations='amelogenin (Y chromosome)', map_location='Yp11.2', chromosome='Y', genomic_nucleotide_accession_version='NC_000024.10', start_position_on_the_genomic_accession=6865918, end_position_on_the_genomic_accession=6911937, orientation='minus', exon_count=8, OMIM=410000, no_hdr0=''),
  267 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=267, CurrentID=0, Status='live', Symbol='AMFR', Aliases='GP78, RNF45', description='autocrine motility factor receptor, E3 ubiquitin protein ligase', other_designations='RING finger protein 45', map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=56361452, end_position_on_the_genomic_accession=56425538, orientation='minus', exon_count=16, OMIM=603243, no_hdr0=''),
  268 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=268, CurrentID=0, Status='live', Symbol='AMH', Aliases='MIF, MIS', description='anti-Mullerian hormone', other_designations='Mullerian inhibiting factor|Mullerian inhibiting substance|anti-Muellerian hormone|muellerian-inhibiting substance', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=2249114, end_position_on_the_genomic_accession=2252073, orientation='plus', exon_count=5, OMIM=600957, no_hdr0=''),
  269 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=269, CurrentID=0, Status='live', Symbol='AMHR2', Aliases='AMHR, MISR2, MISRII, MRII', description='anti-Mullerian hormone receptor type II', other_designations='AMH type II receptor|MIS type II receptor|Muellerian inhibiting substance type II receptor|Mullerian inhibiting substance type II receptor|anti-Muellerian hormone type II receptor|anti-Mullerian hormone receptor, type II', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=53423855, end_position_on_the_genomic_accession=53431534, orientation='plus', exon_count=13, OMIM=600956, no_hdr0=''),
  270 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=270, CurrentID=0, Status='live', Symbol='AMPD1', Aliases='MAD, MADA, MMDD', description='adenosine monophosphate deaminase 1', other_designations='AMPD|adenosine monophosphate deaminase 1 (isoform M)|adenosine monophosphate deaminase-1 (muscle)|myoadenylate deaminase|skeletal muscle AMPD', map_location='1p13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=114673098, end_position_on_the_genomic_accession=114695618, orientation='minus', exon_count=16, OMIM=102770, no_hdr0=''),
  271 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=271, CurrentID=0, Status='live', Symbol='AMPD2', Aliases='PCH9, SPG63', description='adenosine monophosphate deaminase 2', other_designations='AMPD|adenosine monophosphate deaminase 2 (isoform L)', map_location='1p13.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=109619659, end_position_on_the_genomic_accession=109632055, orientation='plus', exon_count=20, OMIM=102771, no_hdr0=''),
  272 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=272, CurrentID=0, Status='live', Symbol='AMPD3', Aliases='', description='adenosine monophosphate deaminase 3', other_designations='AMP aminohydrolase|adenosine monophosphate deaminase (isoform E)|erythrocyte AMP deaminase|erythrocyte type AMP deaminase|erythrocyte-specific AMP deaminase|myoadenylate deaminase', map_location='11p15', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=10450321, end_position_on_the_genomic_accession=10507579, orientation='plus', exon_count=19, OMIM=102772, no_hdr0=''),
  273 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=273, CurrentID=0, Status='live', Symbol='AMPH', Aliases='AMPH1', description='amphiphysin', other_designations='amphiphysin (Stiff-Mann syndrome with breast cancer 128kD autoantigen)|amphiphysin I', map_location='7p14-p13', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=38383694, end_position_on_the_genomic_accession=38631567, orientation='minus', exon_count=23, OMIM=600418, no_hdr0=''),
  274 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=274, CurrentID=0, Status='live', Symbol='BIN1', Aliases='AMPH2, AMPHL, SH3P9', description='bridging integrator 1', other_designations='amphiphysin II|amphiphysin-like protein|box dependant MYC interacting protein 1|box-dependent myc-interacting protein 1', map_location='2q14', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=127048023, end_position_on_the_genomic_accession=127107400, orientation='minus', exon_count=22, OMIM=601248, no_hdr0=''),
  275 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=275, CurrentID=0, Status='live', Symbol='AMT', Aliases='GCE, GCST, GCVT, NKH', description='aminomethyltransferase', other_designations='glycine cleavage system T protein', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=49416778, end_position_on_the_genomic_accession=49422678, orientation='minus', exon_count=9, OMIM=238310, no_hdr0=''),
  276 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=276, CurrentID=0, Status='live', Symbol='AMY1A', Aliases='AMY1', description='amylase, alpha 1A (salivary)', other_designations='1,4-alpha-D-glucan glucanohydrolase 1|amylase, salivary, alpha-1A|glycogenase|salivary alpha-amylase|salivary amylase alpha 1A', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103655519, end_position_on_the_genomic_accession=103664551, orientation='plus', exon_count=11, OMIM=104700, no_hdr0=''),
  277 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=277, CurrentID=0, Status='live', Symbol='AMY1B', Aliases='AMY1', description='amylase, alpha 1B (salivary)', other_designations='1,4-alpha-D-glucan glucanohydrolase 1|amylase, salivary, alpha-1B|glycogenase|salivary alpha-amylase|salivary amylase alpha 1B', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103687415, end_position_on_the_genomic_accession=103696452, orientation='minus', exon_count=12, OMIM=104701, no_hdr0=''),
  278 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=278, CurrentID=0, Status='live', Symbol='AMY1C', Aliases='AMY1', description='amylase, alpha 1C (salivary)', other_designations='1,4-alpha-D-glucan glucanohydrolase 1|amylase, salivary, alpha-1C|glycogenase|salivary alpha-amylase|salivary amylase alpha 1C', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103749656, end_position_on_the_genomic_accession=103758692, orientation='plus', exon_count=11, OMIM=104702, no_hdr0=''),
  279 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=279, CurrentID=0, Status='live', Symbol='AMY2A', Aliases='AMY2, PA', description='amylase, alpha 2A (pancreatic)', other_designations='1,4-alpha-D-glucan glucanohydrolase|glycogenase|pancreatic amylase alpha 2A', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103617332, end_position_on_the_genomic_accession=103625780, orientation='plus', exon_count=10, OMIM=104650, no_hdr0=''),
  280 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=280, CurrentID=0, Status='live', Symbol='AMY2B', Aliases='AMY2, AMY3, HXA', description='amylase, alpha 2B (pancreatic)', other_designations='1,4-alpha-D-glucan glucanohydrolase 2B|carcinoid alpha-amylase|glycogenase', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103554644, end_position_on_the_genomic_accession=103579534, orientation='plus', exon_count=12, OMIM=104660, no_hdr0=''),
  283 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=283, CurrentID=0, Status='live', Symbol='ANG', Aliases='ALS9, HEL168, RAA1, RNASE4, RNASE5', description='angiogenin, ribonuclease, RNase A family, 5', other_designations='RNase 5|epididymis luminal protein 168|ribonuclease 5|ribonuclease A A1', map_location='14q11.1-q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=20684177, end_position_on_the_genomic_accession=20694186, orientation='plus', exon_count=3, OMIM=105850, no_hdr0=''),
  284 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284, CurrentID=0, Status='live', Symbol='ANGPT1', Aliases='AGP1, AGPT, ANG1', description='angiopoietin 1', other_designations='ANG-1', map_location='8q23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=107249482, end_position_on_the_genomic_accession=107498026, orientation='minus', exon_count=9, OMIM=601667, no_hdr0=''),
  285 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=285, CurrentID=0, Status='live', Symbol='ANGPT2', Aliases='AGPT2, ANG2', description='angiopoietin 2', other_designations='ANG-2|Tie2-ligand|angiopoietin-2B|angiopoietin-2a', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6499651, end_position_on_the_genomic_accession=6563263, orientation='minus', exon_count=9, OMIM=601922, no_hdr0=''),
  286 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=286, CurrentID=0, Status='live', Symbol='ANK1', Aliases='ANK, SPH1, SPH2', description='ankyrin 1', other_designations='ANK-1|ankyrin 1, erythrocytic|ankyrin-R|erythrocyte ankyrin', map_location='8p11.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=41653225, end_position_on_the_genomic_accession=41896762, orientation='minus', exon_count=49, OMIM=612641, no_hdr0=''),
  287 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=287, CurrentID=0, Status='live', Symbol='ANK2', Aliases='ANK-2, LQT4, brank-2', description='ankyrin 2, neuronal', other_designations='ankyrin B|ankyrin, brain|ankyrin-2, nonerythrocytic|non-erythroid ankyrin', map_location='4q25-q27', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=112818083, end_position_on_the_genomic_accession=113383740, orientation='plus', exon_count=55, OMIM=106410, no_hdr0=''),
  288 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=288, CurrentID=0, Status='live', Symbol='ANK3', Aliases='ANKYRIN-G, MRT37', description='ankyrin 3, node of Ranvier (ankyrin G)', other_designations='ankyrin G119', map_location='10q21', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=60026298, end_position_on_the_genomic_accession=60733526, orientation='minus', exon_count=60, OMIM=600465, no_hdr0=''),
  290 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=290, CurrentID=0, Status='live', Symbol='ANPEP', Aliases='APN, CD13, GP150, LAP1, P150, PEPN', description='alanyl aminopeptidase, membrane', other_designations='AP-M|AP-N|alanyl (membrane) aminopeptidase|alanyl aminopeptidase|aminopeptidase M|hAPN|membrane alanyl aminopeptidase|microsomal aminopeptidase|myeloid plasma membrane glycoprotein CD13', map_location='15q25-q26', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=89784895, end_position_on_the_genomic_accession=89814854, orientation='minus', exon_count=21, OMIM=151530, no_hdr0=''),
  291 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=291, CurrentID=0, Status='live', Symbol='SLC25A4', Aliases='AAC1, ANT, ANT 1, ANT1, MTDPS12, PEO2, PEO3, T1', description='solute carrier family 25 member 4', other_designations='ADP,ATP carrier protein 1|ADP,ATP carrier protein, heart/skeletal muscle|adenine nucleotide translocator 1 (skeletal muscle)|heart/skeletal muscle ATP/ADP translocator|solute carrier family 25 (mitochondrial carrier; adenine nucleotide translocator), member 4', map_location='4q35', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=185143263, end_position_on_the_genomic_accession=185150384, orientation='plus', exon_count=4, OMIM=103220, no_hdr0=''),
  292 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=292, CurrentID=0, Status='live', Symbol='SLC25A5', Aliases='2F1, AAC2, ANT2, T2, T3', description='solute carrier family 25 (mitochondrial carrier; adenine nucleotide translocator), member 5', other_designations='ADP,ATP carrier protein, fibroblast isoform|adenine nucleotide translocator 2 (fibroblast)', map_location='Xq24', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=119468400, end_position_on_the_genomic_accession=119471396, orientation='plus', exon_count=4, OMIM=300150, no_hdr0=''),
  293 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=293, CurrentID=0, Status='live', Symbol='SLC25A6', Aliases='AAC3, ANT, ANT 2, ANT 3, ANT3, ANT3Y', description='solute carrier family 25 member 6', other_designations='ADP,ATP carrier protein|ADP,ATP carrier protein 3|ADP,ATP carrier protein, liver|ADP/ATP translocator of liver|adenine nucleotide translocator 3|solute carrier family 25 (mitochondrial carrier; adenine nucleotide translocator), member 6', map_location='Xp22.32 and Yp11.3', chromosome='Y', genomic_nucleotide_accession_version='NC_000024.10', start_position_on_the_genomic_accession=1386152, end_position_on_the_genomic_accession=1392146, orientation='minus', exon_count=4, OMIM='300151,403000', no_hdr0=''),
  131368 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131368, CurrentID=0, Status='live', Symbol='ZPLD1', Aliases='', description='zona pellucida-like domain containing 1', other_designations='ZP domain-containing protein 1', map_location='3q12.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=102357481, end_position_on_the_genomic_accession=102479841, orientation='plus', exon_count=14, OMIM=615915, no_hdr0=''),
  301 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=301, CurrentID=0, Status='live', Symbol='ANXA1', Aliases='ANX1, LPC1', description='annexin A1', other_designations='annexin I (lipocortin I)|annexin-1|calpactin II|calpactin-2|chromobindin-9|phospholipase A2 inhibitory protein', map_location='9q21.13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=73151731, end_position_on_the_genomic_accession=73170393, orientation='plus', exon_count=15, OMIM=151690, no_hdr0=''),
  302 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=302, CurrentID=0, Status='live', Symbol='ANXA2', Aliases='ANX2, ANX2L4, CAL1H, HEL-S-270, LIP2, LPC2, LPC2D, P36, PAP-IV', description='annexin A2', other_designations='annexin II|annexin-2|calpactin I heavy chain|calpactin I heavy polypeptide|calpactin-1 heavy chain|chromobindin 8|chromobindin-8|epididymis secretory protein Li 270|lipocortin II|placental anticoagulant protein IV|protein I', map_location='15q22.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=60347151, end_position_on_the_genomic_accession=60397986, orientation='minus', exon_count=17, OMIM=151740, no_hdr0=''),
  131375 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131375, CurrentID=0, Status='live', Symbol='LYZL4', Aliases='LYC4, LYZA', description='lysozyme like 4', other_designations='lysozyme A|lysozyme-4|lysozyme-like 4', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=42360768, end_position_on_the_genomic_accession=42410652, orientation='minus', exon_count=6, OMIM=612750, no_hdr0=''),
  131377 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131377, CurrentID=0, Status='live', Symbol='KLHL40', Aliases='KBTBD5, NEM8, SRYP, SYRP', description='kelch like family member 40', other_designations='kelch repeat and BTB (POZ) domain containing 5|kelch repeat and BTB domain-containing protein 5|kelch-like family member 40|nemaline myopathy type 8|sarcosynapsin', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=42685519, end_position_on_the_genomic_accession=42692446, orientation='plus', exon_count=6, OMIM=615340, no_hdr0=''),
  306 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=306, CurrentID=0, Status='live', Symbol='ANXA3', Aliases='ANX3', description='annexin A3', other_designations='35-alpha calcimedin|Annexin III (lipocortin III)|PAP-III|annexin III (lipocortin III, 1,2-cyclic-inositol-phosphate phosphodiesterase, placental anticoagulant protein III, calcimedin 35-alpha)|annexin-3|calcimedin 35-alpha|inositol 1,2-cyclic phosphate 2-phosphohydrolase|lipocortin III|placental anticoagulant protein III', map_location='4q21.21', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=78551588, end_position_on_the_genomic_accession=78610451, orientation='plus', exon_count=15, OMIM=106490, no_hdr0=''),
  307 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=307, CurrentID=0, Status='live', Symbol='ANXA4', Aliases='ANX4, HEL-S-274, PIG28, ZAP36', description='annexin A4', other_designations='35-beta calcimedin|P32.5|PAP-II|PP4-X|annexin IV (placental anticoagulant protein II)|annexin-4|carbohydrate-binding protein p33/p41|chromobindin-4|endonexin I|epididymis secretory protein Li 274|lipocortin IV|placental anticoagulant protein II|proliferation-inducing gene 28|proliferation-inducing protein 28|protein II', map_location='2p13', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=69644100, end_position_on_the_genomic_accession=69826464, orientation='plus', exon_count=16, OMIM=106491, no_hdr0=''),
  308 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=308, CurrentID=0, Status='live', Symbol='ANXA5', Aliases='ANX5, ENX2, HEL-S-7, PP4, RPRGL3', description='annexin A5', other_designations='CBP-I|PAP-I|VAC-alpha|anchorin CII|annexin V|annexin-5|calphobindin I|endonexin II|epididymis secretory protein Li 7|lipocortin V|placental anticoagulant protein 4|placental anticoagulant protein I|thromboplastin inhibitor|vascular anticoagulant-alpha', map_location='4q27', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=121667997, end_position_on_the_genomic_accession=121696992, orientation='minus', exon_count=13, OMIM=131230, no_hdr0=''),
  309 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=309, CurrentID=0, Status='live', Symbol='ANXA6', Aliases='ANX6, CBP68', description='annexin A6', other_designations='67 kDa calelectrin|CPB-II|annexin VI (p68)|annexin-6|calcium-binding protein p68|calelectrin|calphobindin II|calphobindin-II|chromobindin-20|lipocortin VI|p68|p70', map_location='5q33.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=151100706, end_position_on_the_genomic_accession=151157882, orientation='minus', exon_count=27, OMIM=114070, no_hdr0=''),
  310 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=310, CurrentID=0, Status='live', Symbol='ANXA7', Aliases='ANX7, SNX, SYNEXIN', description='annexin A7', other_designations='annexin VII|annexin-7', map_location='10q22.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=73375431, end_position_on_the_genomic_accession=73414083, orientation='minus', exon_count=14, OMIM=186360, no_hdr0=''),
  311 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=311, CurrentID=0, Status='live', Symbol='ANXA11', Aliases='ANX11, CAP50', description='annexin A11', other_designations='56 kDa autoantigen|CAP-50|annexin XI|annexin-11|autoantigen, 56-kD|calcyclin-associated annexin 50', map_location='10q23', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=80152610, end_position_on_the_genomic_accession=80205677, orientation='minus', exon_count=21, OMIM=602572, no_hdr0=''),
  312 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=312, CurrentID=0, Status='live', Symbol='ANXA13', Aliases='ANX13, ISA', description='annexin A13', other_designations='annexin XIII|annexin, intestine-specific|annexin-13|intestine-specific annexin', map_location='8q24.13', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=123680794, end_position_on_the_genomic_accession=123737407, orientation='minus', exon_count=12, OMIM=602573, no_hdr0=''),
  313 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=313, CurrentID=0, Status='live', Symbol='AOAH', Aliases='', description='acyloxyacyl hydrolase', other_designations='acyloxyacyl hydrolase (neutrophil)', map_location='7p14.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=36512941, end_position_on_the_genomic_accession=36724549, orientation='minus', exon_count=29, OMIM=102593, no_hdr0=''),
  314 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=314, CurrentID=0, Status='live', Symbol='AOC2', Aliases='DAO2, RAO', description='amine oxidase, copper containing 2', other_designations='SSAO|amine oxidase copper containing 2|amine oxidase, copper containing 2 (retina-specific)|semicarbazide-sensitive amine oxidase', map_location='17q21', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=42844592, end_position_on_the_genomic_accession=42850707, orientation='plus', exon_count=4, OMIM=602268, no_hdr0=''),
  316 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=316, CurrentID=0, Status='live', Symbol='AOX1', Aliases='AO, AOH1', description='aldehyde oxidase 1', other_designations='azaheterocycle hydroxylase', map_location='2q33', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=200585952, end_position_on_the_genomic_accession=200682241, orientation='plus', exon_count=38, OMIM=602841, no_hdr0=''),
  317 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=317, CurrentID=0, Status='live', Symbol='APAF1', Aliases='APAF-1, CED4', description='apoptotic peptidase activating factor 1', other_designations='', map_location='12q23', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=98645228, end_position_on_the_genomic_accession=98735433, orientation='plus', exon_count=29, OMIM=602233, no_hdr0=''),
  318 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=318, CurrentID=0, Status='live', Symbol='NUDT2', Aliases='APAH1', description='nudix hydrolase 2', other_designations="Ap4A hydrolase 1|Ap4Aase|bis(5'-nucleosyl)-tetraphosphatase (asymmetrical)|diadenosine 5',5'''-P1,P4-tetraphosphate asymmetrical hydrolase|diadenosine 5',5''-P1,P4-tetraphosphate pyrophosphohydrolase|diadenosine tetraphosphatase|nucleoside diphosphate-linked moiety X motif 2|nudix (nucleoside diphosphate linked moiety X)-type motif 2|nudix motif 2", map_location='9p13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=34329506, end_position_on_the_genomic_accession=34343713, orientation='plus', exon_count=5, OMIM=602852, no_hdr0=''),
  319 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=319, CurrentID=0, Status='live', Symbol='APOF', Aliases='Apo-F, LTIP', description='apolipoprotein F', other_designations='lipid transfer inhibitor protein', map_location='12q13.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=56360571, end_position_on_the_genomic_accession=56362799, orientation='minus', exon_count=2, OMIM=107760, no_hdr0=''),
  320 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=320, CurrentID=0, Status='live', Symbol='APBA1', Aliases='D9S411E, LIN10, MINT1, X11, X11A, X11ALPHA', description='amyloid beta precursor protein binding family A member 1', other_designations='adapter protein X11alpha|adaptor protein X11alpha|amyloid beta (A4) precursor protein-binding, family A, member 1 (X11)|mint-1|neuron-specific X11 protein|neuronal munc18-1-interacting protein 1|phosphotyrosine-binding/-interacting domain (PTB)-bearing protein', map_location='9q21.12', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=69427532, end_position_on_the_genomic_accession=69673617, orientation='minus', exon_count=16, OMIM=602414, no_hdr0=''),
  321 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=321, CurrentID=0, Status='live', Symbol='APBA2', Aliases='D15S1518E, HsT16821, LIN-10, MGC:14091, MINT2, X11-BETA, X11L', description='amyloid beta precursor protein binding family A member 2', other_designations='X11-like protein|adapter protein X11beta|amyloid beta (A4) precursor protein-binding, family A, member 2 (X11-like)|mint-2|neuron-specific X11L protein|neuronal munc18-1-interacting protein 2|phosphotyrosine-binding/-interacting domain (PTB)-bearing protein', map_location='15q11-q12', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=28885994, end_position_on_the_genomic_accession=29118315, orientation='plus', exon_count=21, OMIM=602712, no_hdr0=''),
  322 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=322, CurrentID=0, Status='live', Symbol='APBB1', Aliases='FE65, MGC:9072, RIR', description='amyloid beta precursor protein binding family B member 1', other_designations='adaptor protein FE65a2|amyloid beta (A4) precursor protein-binding, family B, member 1 (Fe65)|stat-like protein', map_location='11p15', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=6395124, end_position_on_the_genomic_accession=6419472, orientation='minus', exon_count=19, OMIM=602709, no_hdr0=''),
  169355 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=169355, CurrentID=0, Status='live', Symbol='IDO2', Aliases='INDOL1', description='indoleamine 2,3-dioxygenase 2', other_designations='IDO-2|indoleamine 2,3-dioxygenase-like 1 protein|indoleamine 2,3-dioxygenase-like protein 1|indoleamine-pyrrole 2,3 dioxygenase-like 1|indoleamine-pyrrole 2,3-dioxygenase-like protein 1', map_location='8p11.21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=39934955, end_position_on_the_genomic_accession=40016391, orientation='plus', exon_count=11, OMIM=612129, no_hdr0=''),
  324 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=324, CurrentID=0, Status='live', Symbol='APC', Aliases='BTPS2, DP2, DP2.5, DP3, GS, PPP1R46', description='adenomatous polyposis coli', other_designations='adenomatosis polyposis coli tumor suppressor|deleted in polyposis 2.5|protein phosphatase 1, regulatory subunit 46|truncated adenomatosis polyposis coli', map_location='5q21-q22', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=112707505, end_position_on_the_genomic_accession=112846239, orientation='plus', exon_count=18, OMIM=611731, no_hdr0=''),
  325 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=325, CurrentID=0, Status='live', Symbol='APCS', Aliases='HEL-S-92n, PTX2, SAP', description='amyloid P component, serum', other_designations='9.5S alpha-1-glycoprotein|epididymis secretory sperm binding protein Li 92n|pentaxin-related|pentraxin-related', map_location='1q21-q23', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=159587826, end_position_on_the_genomic_accession=159588871, orientation='plus', exon_count=2, OMIM=104770, no_hdr0=''),
  326 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=326, CurrentID=0, Status='live', Symbol='AIRE', Aliases='AIRE1, APECED, APS1, APSI, PGA1', description='autoimmune regulator', other_designations='autoimmune polyendocrinopathy candidiasis ectodermal dystrophy protein', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=44285838, end_position_on_the_genomic_accession=44298219, orientation='plus', exon_count=14, OMIM=607358, no_hdr0=''),
  327 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=327, CurrentID=0, Status='live', Symbol='APEH', Aliases='AARE, ACPH, APH, D3F15S2, D3S48E, DNF15S2, OPH', description='acylaminoacyl-peptide hydrolase', other_designations='N-acylaminoacyl-peptide hydrolase|acyl-peptide hydrolase|acylaminoacyl-peptidase|oxidized protein hydrolase', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=49673130, end_position_on_the_genomic_accession=49683504, orientation='plus', exon_count=24, OMIM=102645, no_hdr0=''),
  328 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=328, CurrentID=0, Status='live', Symbol='APEX1', Aliases='APE, APE1, APEN, APEX, APX, HAP1, REF1', description='APEX nuclease (multifunctional DNA repair enzyme) 1', other_designations='AP endonuclease class I|AP lyase|apurinic-apyrimidinic endonuclease 1|apurinic/apyrimidinic (abasic) endonuclease|deoxyribonuclease (apurinic or apyrimidinic)|protein REF-1|redox factor-1', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=20455131, end_position_on_the_genomic_accession=20457772, orientation='plus', exon_count=5, OMIM=107748, no_hdr0=''),
  329 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=329, CurrentID=0, Status='live', Symbol='BIRC2', Aliases='API1, HIAP2, Hiap-2, MIHB, RNF48, c-IAP1, cIAP1', description='baculoviral IAP repeat containing 2', other_designations='IAP homolog B|IAP-2|NFR2-TRAF signalling complex protein|RING finger protein 48|TNFR2-TRAF-signaling complex protein 2|apoptosis inhibitor 1|baculoviral IAP repeat-containing 2|inhibitor of apoptosis protein 2', map_location='11q22', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=102347182, end_position_on_the_genomic_accession=102378670, orientation='plus', exon_count=9, OMIM=601712, no_hdr0=''),
  330 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=330, CurrentID=0, Status='live', Symbol='BIRC3', Aliases='AIP1, API2, CIAP2, HAIP1, HIAP1, MALT2, MIHC, RNF49, c-IAP2', description='baculoviral IAP repeat containing 3', other_designations='IAP homolog C|IAP-1|RING finger protein 49|TNFR2-TRAF signaling complex protein|TNFR2-TRAF-signaling complex protein 1|apoptosis inhibitor 2|baculoviral IAP repeat-containing 3|inhibitor of apoptosis protein 1|mammalian IAP homolog C', map_location='11q22', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=102317373, end_position_on_the_genomic_accession=102339403, orientation='plus', exon_count=9, OMIM=601721, no_hdr0=''),
  331 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=331, CurrentID=0, Status='live', Symbol='XIAP', Aliases='API3, BIRC4, IAP-3, ILP1, MIHA, XLP2, hIAP-3, hIAP3', description='X-linked inhibitor of apoptosis', other_designations='IAP-like protein|X-linked IAP|X-linked inhibitor of apoptosis, E3 ubiquitin protein ligase|baculoviral IAP repeat-containing protein 4|inhibitor of apoptosis protein 3', map_location='Xq25', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=123859812, end_position_on_the_genomic_accession=123913979, orientation='plus', exon_count=9, OMIM=300079, no_hdr0=''),
  332 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=332, CurrentID=0, Status='live', Symbol='BIRC5', Aliases='API4, EPR-1', description='baculoviral IAP repeat containing 5', other_designations='apoptosis inhibitor 4|apoptosis inhibitor survivin|survivin variant 3 alpha', map_location='17q25', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=78214196, end_position_on_the_genomic_accession=78225635, orientation='plus', exon_count=6, OMIM=603352, no_hdr0=''),
  333 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=333, CurrentID=0, Status='live', Symbol='APLP1', Aliases='APLP', description='amyloid beta precursor like protein 1', other_designations='APLP-1|amyloid beta (A4) precursor-like protein 1|amyloid precursor-like protein 1', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=35868499, end_position_on_the_genomic_accession=35879797, orientation='plus', exon_count=17, OMIM=104775, no_hdr0=''),
  334 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=334, CurrentID=0, Status='live', Symbol='APLP2', Aliases='APLP-2, APPH, APPL2, CDEBP', description='amyloid beta precursor like protein 2', other_designations='CDEI box-binding protein|amyloid beta (A4) precursor-like protein 2|amyloid precursor protein homolog HSD-2', map_location='11q24', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=130069821, end_position_on_the_genomic_accession=130144811, orientation='plus', exon_count=19, OMIM=104776, no_hdr0=''),
  335 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=335, CurrentID=0, Status='live', Symbol='APOA1', Aliases='apo(a)', description='apolipoprotein A-I', other_designations='apo-AI', map_location='11q23-q24', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=116835751, end_position_on_the_genomic_accession=116837647, orientation='minus', exon_count=4, OMIM=107680, no_hdr0=''),
  336 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=336, CurrentID=0, Status='live', Symbol='APOA2', Aliases='Apo-AII, ApoA-II, apoAII', description='apolipoprotein A-II', other_designations='apolipoprotein A2', map_location='1q23.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=161222293, end_position_on_the_genomic_accession=161223628, orientation='minus', exon_count=4, OMIM=107670, no_hdr0=''),
  337 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=337, CurrentID=0, Status='live', Symbol='APOA4', Aliases='', description='apolipoprotein A-IV', other_designations='apo-AIV|apoA-IV|apolipoprotein A4', map_location='11q23', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=116820702, end_position_on_the_genomic_accession=116823295, orientation='minus', exon_count=3, OMIM=107690, no_hdr0=''),
  338 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=338, CurrentID=0, Status='live', Symbol='APOB', Aliases='FLDB, LDLCQ4, apoB-100, apoB-48', description='apolipoprotein B', other_designations='apolipoprotein B (including Ag(x) antigen)|apolipoprotein B48', map_location='2p24-p23', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=20999218, end_position_on_the_genomic_accession=21044073, orientation='minus', exon_count=31, OMIM=107730, no_hdr0=''),
  339 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=339, CurrentID=0, Status='live', Symbol='APOBEC1', Aliases='APOBEC-1, BEDP, CDAR1, HEPR', description='apolipoprotein B mRNA editing enzyme catalytic polypeptide 1', other_designations='apolipoprotein B mRNA editing enzyme complex-1|apolipoprotein B mRNA editing enzyme, catalytic polypeptide 1|apolipoprotein B mRNA-editing enzyme 1|mRNA(cytosine(6666)) deaminase 1', map_location='12p13.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=7649400, end_position_on_the_genomic_accession=7670599, orientation='minus', exon_count=6, OMIM=600130, no_hdr0=''),
  341 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=341, CurrentID=0, Status='live', Symbol='APOC1', Aliases='Apo-CI, ApoC-I', description='apolipoprotein C-I', other_designations='apo-CIB|apoC-IB|apolipoprotein C-I variant I|apolipoprotein C-I variant II|apolipoprotein C1', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44914325, end_position_on_the_genomic_accession=44919349, orientation='plus', exon_count=5, OMIM=107710, no_hdr0=''),
  343 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=343, CurrentID=0, Status='live', Symbol='AQP8', Aliases='AQP-8', description='aquaporin 8', other_designations='', map_location='16p12', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=25216916, end_position_on_the_genomic_accession=25228932, orientation='plus', exon_count=6, OMIM=603750, no_hdr0=''),
  344 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=344, CurrentID=0, Status='live', Symbol='APOC2', Aliases='APO-CII, APOC-II', description='apolipoprotein C-II', other_designations='apolipoprotein C2', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44945982, end_position_on_the_genomic_accession=44949565, orientation='plus', exon_count=4, OMIM=608083, no_hdr0=''),
  345 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=345, CurrentID=0, Status='live', Symbol='APOC3', Aliases='APOCIII, HALP2', description='apolipoprotein C-III', other_designations='apo-CIII|apoC-III|apolipoprotein C3', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=116829908, end_position_on_the_genomic_accession=116833071, orientation='plus', exon_count=4, OMIM=107720, no_hdr0=''),
  346 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=346, CurrentID=0, Status='live', Symbol='APOC4', Aliases='APO-CIV, APOC-IV', description='apolipoprotein C-IV', other_designations='apolipoprotein C4', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44942238, end_position_on_the_genomic_accession=44945496, orientation='plus', exon_count=3, OMIM=600745, no_hdr0=''),
  347 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=347, CurrentID=0, Status='live', Symbol='APOD', Aliases='', description='apolipoprotein D', other_designations='apo-D', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=195568702, end_position_on_the_genomic_accession=195584205, orientation='minus', exon_count=5, OMIM=107740, no_hdr0=''),
  348 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=348, CurrentID=0, Status='live', Symbol='APOE', Aliases='AD2, APO-E, LDLCQ5, LPG', description='apolipoprotein E', other_designations='apolipoprotein E3', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44905749, end_position_on_the_genomic_accession=44909395, orientation='plus', exon_count=6, OMIM=107741, no_hdr0=''),
  350 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=350, CurrentID=0, Status='live', Symbol='APOH', Aliases='B2G1, B2GP1, BG', description='apolipoprotein H', other_designations='APC inhibitor|B2GPI|activated protein C-binding protein|anticardiolipin cofactor|apo-H|apolipoprotein H (beta-2-glycoprotein I)|beta(2)GPI', map_location='17q24.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=66212029, end_position_on_the_genomic_accession=66229438, orientation='minus', exon_count=8, OMIM=138700, no_hdr0=''),
  351 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=351, CurrentID=0, Status='live', Symbol='APP', Aliases='AAA, ABETA, ABPP, AD1I, CTFgamma, CVAP, PN-II, PN2, APP', description='amyloid beta precursor protein', other_designations='alzheimer disease amyloid protein|beta-amyloid peptide|beta-amyloid peptide(1-40)|beta-amyloid peptide(1-42)|cerebral vascular amyloid peptide|peptidase nexin-II|preA4|protease nexin-II', map_location='21q21.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=25880550, end_position_on_the_genomic_accession=26171128, orientation='minus', exon_count=20, OMIM=104760, no_hdr0=''),
  353 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=353, CurrentID=0, Status='live', Symbol='APRT', Aliases='AMPD, APRT', description='adenine phosphoribosyltransferase', other_designations='AMP diphosphorylase|AMP pyrophosphorylase|transphosphoribosidase', map_location='16q24', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=88809469, end_position_on_the_genomic_accession=88811934, orientation='minus', exon_count=5, OMIM=102600, no_hdr0=''),
  354 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=354, CurrentID=0, Status='live', Symbol='KLK3', Aliases='APS, KLK2A1, PSA, hK3', description='kallikrein related peptidase 3', other_designations='P-30 antigen|gamma-seminoprotein|kallikrein-3|kallikrein-related peptidase 3|prostate specific antigen|semenogelase|seminin', map_location='19q13.41', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=50854915, end_position_on_the_genomic_accession=50877702, orientation='plus', exon_count=6, OMIM=176820, no_hdr0=''),
  355 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=355, CurrentID=0, Status='live', Symbol='FAS', Aliases='ALPS1A, APO-1, APT1, CD951, FASTM, TNFRSF6, FAS', description='Fas cell surface death receptor', other_designations='APO-1 cell surface antigen|CD95 antigen|Delta Fas/APO-1/CD95|FAS 827dupA|FAS receptor variant 9|FASLG receptor|Fas (TNF receptor superfamily, member 6)|Fas AMA|TNF receptor superfamily member 6|apoptosis antigen 1|apoptosis-mediating surface antigen FAS|tumor necrosis factor receptor superfamily, member 6', map_location='10q24.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=88969801, end_position_on_the_genomic_accession=89017059, orientation='plus', exon_count=14, OMIM=134637, no_hdr0=''),
  356 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=356, CurrentID=0, Status='live', Symbol='FASLG', Aliases='ALPS1B, APT1LG1, APTL, CD178, CD95-L, CD95L, FASL, TNFSF6, TNLG1A', description='Fas ligand', other_designations='CD95 ligand|Fas ligand (TNF superfamily, member 6)|apoptosis (APO-1) antigen ligand 1|apoptosis antigen ligand|fas antigen ligand|mutant tumor necrosis factor family member 6|tumor necrosis factor ligand 1A', map_location='1q23', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=172659008, end_position_on_the_genomic_accession=172666873, orientation='plus', exon_count=4, OMIM=134638, no_hdr0=''),
  357 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=357, CurrentID=0, Status='live', Symbol='SHROOM2', Aliases='APXL, HSAPXL', description='shroom family member 2', other_designations='APX homolog of Xenopus|apical-like protein', map_location='Xp22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=9786402, end_position_on_the_genomic_accession=9949443, orientation='plus', exon_count=11, OMIM=300103, no_hdr0=''),
  358 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=358, CurrentID=0, Status='live', Symbol='AQP1', Aliases='AQP-CHIP, CHIP28, CO', description='aquaporin 1 (Colton blood group)', other_designations='aquaporin 1 (channel-forming integral protein, 28kDa, CO blood group)|aquaporin 1, Colton blood group antigen|aquaporin-CHIP|channel-like integral membrane protein, 28-kDa|urine water channel|water channel protein for red blood cells and kidney proximal tubule', map_location='7p14', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=30911800, end_position_on_the_genomic_accession=30925516, orientation='plus', exon_count=7, OMIM=107776, no_hdr0=''),
  359 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=359, CurrentID=0, Status='live', Symbol='AQP2', Aliases='AQP-CD, WCH-CD', description='aquaporin 2', other_designations='ADH water channel|AQP-2|aquaporin 2 (collecting duct)|aquaporin-CD|collecting duct water channel protein|water channel protein for renal collecting duct|water-channel aquaporin 2', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=49950741, end_position_on_the_genomic_accession=49958881, orientation='plus', exon_count=4, OMIM=107777, no_hdr0=''),
  360 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=360, CurrentID=0, Status='live', Symbol='AQP3', Aliases='AQP-3, GIL', description='aquaporin 3 (Gill blood group)', other_designations='aquaglyceroporin-3|aquaporin 3 (GIL blood group)', map_location='9p13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=33441154, end_position_on_the_genomic_accession=33447633, orientation='minus', exon_count=6, OMIM=600170, no_hdr0=''),
  361 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=361, CurrentID=0, Status='live', Symbol='AQP4', Aliases='MIWC, WCH4', description='aquaporin 4', other_designations='aquaporin type4|mercurial-insensitive water channel', map_location='18q11.2-q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=26852043, end_position_on_the_genomic_accession=26865752, orientation='minus', exon_count=6, OMIM=600308, no_hdr0=''),
  362 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=362, CurrentID=0, Status='live', Symbol='AQP5', Aliases='AQP-5, PPKB', description='aquaporin 5', other_designations='', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=49961496, end_position_on_the_genomic_accession=49965682, orientation='plus', exon_count=5, OMIM=600442, no_hdr0=''),
  363 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=363, CurrentID=0, Status='live', Symbol='AQP6', Aliases='AQP2L, KID', description='aquaporin 6', other_designations='AQP-6|aquaporin 2-like, kidney specific|aquaporin 6, kidney specific|aquaporin-6, kidney specific|hKID|kidney-specific aquaporin', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=49972837, end_position_on_the_genomic_accession=49977139, orientation='plus', exon_count=4, OMIM=601383, no_hdr0=''),
  364 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=364, CurrentID=0, Status='live', Symbol='AQP7', Aliases='AQP7L, AQPap, GLYCQTL', description='aquaporin 7', other_designations='aquaglyceroporin-7|aquaporin adipose', map_location='9p13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=33384947, end_position_on_the_genomic_accession=33402645, orientation='minus', exon_count=11, OMIM=602974, no_hdr0=''),
  105378081 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105378081, CurrentID=0, Status='live', Symbol='LOC105378081', Aliases='', description='uncharacterized LOC105378081', other_designations='', map_location='', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=159051766, end_position_on_the_genomic_accession=159121467, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  366 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=366, CurrentID=0, Status='live', Symbol='AQP9', Aliases='AQP-9, HsT17287, SSC1', description='aquaporin 9', other_designations='aquaglyceroporin-9|small solute channel 1', map_location='15q', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=58138209, end_position_on_the_genomic_accession=58185911, orientation='plus', exon_count=6, OMIM=602914, no_hdr0=''),
  367 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=367, CurrentID=0, Status='live', Symbol='AR', Aliases='AIS8, DHTR, HUMARA, HYSP1, KD, NR3C4, SBMA, SMAX1, TFM, AR', description='androgen receptor', other_designations='androgen nuclear receptor variant 2|androgen receptor splice variant 4b|dihydrotestosterone receptor|nuclear receptor subfamily 3 group C member 4', map_location='Xq12', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=67544032, end_position_on_the_genomic_accession=67730619, orientation='plus', exon_count=9, OMIM=313700, no_hdr0=''),
  368 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=368, CurrentID=0, Status='live', Symbol='ABCC6', Aliases='ABC34, ARA, EST349056, GACI2, MLP1, MOAT-E, MOATE, MRP6, PXE, PXE1, URG7', description='ATP binding cassette subfamily C member 6', other_designations='ATP-binding cassette sub-family C member 6|ATP-binding cassette, sub-family C (CFTR/MRP), member 6|anthracycline resistance-associated protein|multi-specific organic anion transporter E', map_location='16p13.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=16149565, end_position_on_the_genomic_accession=16223673, orientation='minus', exon_count=34, OMIM=603234, no_hdr0=''),
  369 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=369, CurrentID=0, Status='live', Symbol='ARAF', Aliases='A-RAF1, PKS2, RAFA1, ARAF', description='A-Raf proto-oncogene, serine/threonine kinase', other_designations='A-Raf proto-oncogene serine/threonine-protein kinase|Oncogene ARAF1|Ras-binding protein DA-Raf|proto-oncogene A-Raf-1|proto-oncogene Pks|v-raf murine sarcoma 3611 viral oncogene homolog 1|v-raf murine sarcoma 3611 viral oncogene-like protein', map_location='Xp11.4-p11.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=47561100, end_position_on_the_genomic_accession=47571921, orientation='plus', exon_count=18, OMIM=311010, no_hdr0=''),
  124401 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=124401, CurrentID=0, Status='live', Symbol='ANKS3', Aliases='', description='ankyrin repeat and sterile alpha motif domain containing 3', other_designations='', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=4696510, end_position_on_the_genomic_accession=4734377, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  372 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=372, CurrentID=0, Status='live', Symbol='ARCN1', Aliases='COPD', description='archain 1', other_designations='archain vesicle transport protein 1|coatomer delta subunit|coatomer protein complex, subunit delta|coatomer protein delta-COP|delta-COP|delta-coat protein', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118572387, end_position_on_the_genomic_accession=118603033, orientation='plus', exon_count=10, OMIM=600820, no_hdr0=''),
  373 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=373, CurrentID=0, Status='live', Symbol='TRIM23', Aliases='ARD1, ARFD1, RNF46', description='tripartite motif containing 23', other_designations='ADP-ribosylation factor domain protein 1, 64kDa|ADP-ribosylation factor domain-containing protein 1|ARF domain protein 1|GTP-binding protein ARD-1|RING finger protein 46|tripartite motif protein TRIM23|tripartite motif-containing 23|tripartite motif-containing protein 23', map_location='5q12.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=65589680, end_position_on_the_genomic_accession=65624360, orientation='minus', exon_count=14, OMIM=601747, no_hdr0=''),
  374 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=374, CurrentID=0, Status='live', Symbol='AREG', Aliases='ARB, CRDGF, SDGF, AREG', description='amphiregulin', other_designations='amphiregulin B|colorectum cell-derived growth factor|schwannoma-derived growth factor', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=74445098, end_position_on_the_genomic_accession=74455009, orientation='plus', exon_count=6, OMIM=104640, no_hdr0=''),
  375 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=375, CurrentID=0, Status='live', Symbol='ARF1', Aliases='', description='ADP ribosylation factor 1', other_designations='', map_location='1q42', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=228082660, end_position_on_the_genomic_accession=228099212, orientation='plus', exon_count=6, OMIM=103180, no_hdr0=''),
  377 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=377, CurrentID=0, Status='live', Symbol='ARF3', Aliases='', description='ADP ribosylation factor 3', other_designations='small GTP binding protein', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=48931156, end_position_on_the_genomic_accession=48957526, orientation='minus', exon_count=8, OMIM=103190, no_hdr0=''),
  131450 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131450, CurrentID=0, Status='live', Symbol='CD200R1', Aliases='CD200R, HCRTR2, MOX2R, OX2R', description='CD200 receptor 1', other_designations='CD200 cell surface glycoprotein receptor|MOX2 receptor|cell surface glycoprotein OX2 receptor 1|cell surface glycoprotein receptor CD200', map_location='3q13.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=112921057, end_position_on_the_genomic_accession=112975122, orientation='minus', exon_count=8, OMIM=607546, no_hdr0=''),
  379 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=379, CurrentID=0, Status='live', Symbol='ARL4D', Aliases='ARF4L, ARL6', description='ADP ribosylation factor like GTPase 4D', other_designations='ADP-ribosylation factor like GTPase 4D|ADP-ribosylation factor-like 4D|ADP-ribosylation factor-like 6|ADP-ribosylation factor-like protein 4L', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43398985, end_position_on_the_genomic_accession=43401136, orientation='plus', exon_count=3, OMIM=600732, no_hdr0=''),
  381 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=381, CurrentID=0, Status='live', Symbol='ARF5', Aliases='', description='ADP ribosylation factor 5', other_designations='', map_location='7q31.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=127588352, end_position_on_the_genomic_accession=127591705, orientation='plus', exon_count=6, OMIM=103188, no_hdr0=''),
  382 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=382, CurrentID=0, Status='live', Symbol='ARF6', Aliases='', description='ADP ribosylation factor 6', other_designations='', map_location='14q21.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=49893018, end_position_on_the_genomic_accession=49897054, orientation='plus', exon_count=2, OMIM=600464, no_hdr0=''),
  383 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=383, CurrentID=0, Status='live', Symbol='ARG1', Aliases='', description='arginase 1', other_designations='arginase, liver|liver-type arginase|type I arginase', map_location='6q23', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=131573203, end_position_on_the_genomic_accession=131584332, orientation='plus', exon_count=8, OMIM=608313, no_hdr0=''),
  384 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=384, CurrentID=0, Status='live', Symbol='ARG2', Aliases='', description='arginase 2', other_designations='L-arginine amidinohydrolase|L-arginine ureahydrolase|arginase, type II|kidney arginase|kidney-type arginase|non-hepatic arginase|nonhepatic arginase|type II arginase', map_location='14q24.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=67619862, end_position_on_the_genomic_accession=67651720, orientation='plus', exon_count=8, OMIM=107830, no_hdr0=''),
  196993 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=196993, CurrentID=0, Status='live', Symbol='CT62', Aliases='', description='cancer/testis antigen 62', other_designations='', map_location='15q23', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=71110244, end_position_on_the_genomic_accession=71115500, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  387 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=387, CurrentID=0, Status='live', Symbol='RHOA', Aliases='ARH12, ARHA, RHO12, RHOH12', description='ras homolog family member A', other_designations='Aplysia ras-related homolog 12|oncogene RHO H12|small GTP binding protein RhoA', map_location='3p21.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=49359136, end_position_on_the_genomic_accession=49412093, orientation='minus', exon_count=6, OMIM=165390, no_hdr0=''),
  388 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=388, CurrentID=0, Status='live', Symbol='RHOB', Aliases='ARH6, ARHB, MST081, MSTP081, RHOH6', description='ras homolog family member B', other_designations='Aplysia RAS-related homolog 6|h6|oncogene RHO H6|ras homolog gene family, member B|rho cDNA clone 6', map_location='2p24', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=20447071, end_position_on_the_genomic_accession=20449445, orientation='plus', exon_count=1, OMIM=165370, no_hdr0=''),
  389 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=389, CurrentID=0, Status='live', Symbol='RHOC', Aliases='ARH9, ARHC, H9, RHOH9', description='ras homolog family member C', other_designations='RAS-related homolog 9|oncogene RHO H9|ras homolog gene family, member C|rho cDNA clone 9|rhoC GTPase|small GTP binding protein RhoC', map_location='1p13.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=112701127, end_position_on_the_genomic_accession=112707403, orientation='minus', exon_count=7, OMIM=165380, no_hdr0=''),
  390 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=390, CurrentID=0, Status='live', Symbol='RND3', Aliases='ARHE, Rho8, RhoE, memB', description='Rho family GTPase 3', other_designations='protein MemB|ras homolog gene family, member E|rho-related GTP-binding protein Rho8|small GTP binding protein Rho8', map_location='2q23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=150468193, end_position_on_the_genomic_accession=150487695, orientation='minus', exon_count=6, OMIM=602924, no_hdr0=''),
  391 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=391, CurrentID=0, Status='live', Symbol='RHOG', Aliases='ARHG', description='ras homolog family member G', other_designations='ras homolog gene family, member G (rho G)', map_location='11p15.5-p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=3826978, end_position_on_the_genomic_accession=3840983, orientation='minus', exon_count=3, OMIM=179505, no_hdr0=''),
  392 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=392, CurrentID=0, Status='live', Symbol='ARHGAP1', Aliases='CDC42GAP, RHOGAP, RHOGAP1, p50rhoGAP', description='Rho GTPase activating protein 1', other_designations='CDC42 GTPase-activating protein|GTPase-activating protein rhoGAP|GTPase-activating protein rhoOGAP|GTPase-activating protein, Rho, 1|rho-related small GTPase protein activator|rho-type GTPase-activating protein 1', map_location='11p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=46677075, end_position_on_the_genomic_accession=46700665, orientation='minus', exon_count=14, OMIM=602732, no_hdr0=''),
  393 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=393, CurrentID=0, Status='live', Symbol='ARHGAP4', Aliases='C1, RGC1, RhoGAP4, SrGAP4, p115', description='Rho GTPase activating protein 4', other_designations='Rho-GAP hematopoietic protein C1|rho-type GTPase-activating protein 4', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153907376, end_position_on_the_genomic_accession=153926260, orientation='minus', exon_count=23, OMIM=300023, no_hdr0=''),
  394 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=394, CurrentID=0, Status='live', Symbol='ARHGAP5', Aliases='GFI2, RhoGAP5, p190-B, p190BRhoGAP', description='Rho GTPase activating protein 5', other_designations='growth factor independent 2|p100 RasGAP-associated p105 protein|p105 RhoGAP|rho-type GTPase-activating protein 5', map_location='14q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=32076458, end_position_on_the_genomic_accession=32159728, orientation='plus', exon_count=9, OMIM=602680, no_hdr0=''),
  395 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=395, CurrentID=0, Status='live', Symbol='ARHGAP6', Aliases='RHOGAP6, RHOGAPX-1', description='Rho GTPase activating protein 6', other_designations='Rho-type GTPase-activating protein RhoGAPX-1|rho-type GTPase-activating protein 6', map_location='Xp22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=11137543, end_position_on_the_genomic_accession=11665701, orientation='minus', exon_count=17, OMIM=300118, no_hdr0=''),
  396 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=396, CurrentID=0, Status='live', Symbol='ARHGDIA', Aliases='GDIA1, HEL-S-47e, NPHS8, RHOGDI, RHOGDI-1', description='Rho GDP dissociation inhibitor (GDI) alpha', other_designations='GDP-dissociation inhibitor, aplysia RAS-related 1|Rho GDP dissociation inhibitor alpha|epididymis secretory sperm binding protein Li 47e', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=81867719, end_position_on_the_genomic_accession=81871406, orientation='minus', exon_count=7, OMIM=601925, no_hdr0=''),
  397 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=397, CurrentID=0, Status='live', Symbol='ARHGDIB', Aliases='D4, GDIA2, GDID4, LYGDI, Ly-GDI, RAP1GN1, RhoGDI2', description='Rho GDP dissociation inhibitor (GDI) beta', other_designations='Rho GDI 2|rho-GDI beta', map_location='12p12.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=14942015, end_position_on_the_genomic_accession=14961628, orientation='minus', exon_count=8, OMIM=602843, no_hdr0=''),
  398 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=398, CurrentID=0, Status='live', Symbol='ARHGDIG', Aliases='RHOGDI-3', description='Rho GDP dissociation inhibitor (GDI) gamma', other_designations='RhoGDI gamma|rho GDI 3|rho-GDI gamma', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=280606, end_position_on_the_genomic_accession=283003, orientation='plus', exon_count=6, OMIM=602844, no_hdr0=''),
  399 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=399, CurrentID=0, Status='live', Symbol='RHOH', Aliases='ARHH, TTF', description='ras homolog family member H', other_designations='GTP-binding protein TTF|TTF, translocation three four|ras homolog gene family, member H', map_location='4p13', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=40191011, end_position_on_the_genomic_accession=40244764, orientation='plus', exon_count=10, OMIM=602037, no_hdr0=''),
  400 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=400, CurrentID=0, Status='live', Symbol='ARL1', Aliases='ARFL1', description='ADP ribosylation factor like GTPase 1', other_designations='ADP-ribosylation factor like GTPase 1|ADP-ribosylation factor-like 1', map_location='12q23.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=101393120, end_position_on_the_genomic_accession=101407820, orientation='minus', exon_count=6, OMIM=603425, no_hdr0=''),
  401 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=401, CurrentID=0, Status='live', Symbol='PHOX2A', Aliases='ARIX, CFEOM2, FEOM2, NCAM2, PMX2A', description='paired like homeobox 2a', other_designations='ARIX1 homeodomain protein|aristaless homeobox homolog|aristaless homeobox protein homolog|arix homeodomain protein|paired-like homeobox 2a', map_location='11q13.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=72239077, end_position_on_the_genomic_accession=72244176, orientation='minus', exon_count=3, OMIM=602753, no_hdr0=''),
  402 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=402, CurrentID=0, Status='live', Symbol='ARL2', Aliases='ARFL2', description='ADP ribosylation factor like GTPase 2', other_designations='ADP-ribosylation factor like GTPase 2|ADP-ribosylation factor-like 2', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65014113, end_position_on_the_genomic_accession=65022185, orientation='plus', exon_count=5, OMIM=601175, no_hdr0=''),
  403 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=403, CurrentID=0, Status='live', Symbol='ARL3', Aliases='ARFL3', description='ADP ribosylation factor like GTPase 3', other_designations='ADP-ribosylation factor like GTPase 3|ADP-ribosylation factor-like 3|ARF-like 3', map_location='10q23.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=102673727, end_position_on_the_genomic_accession=102714433, orientation='minus', exon_count=6, OMIM=604695, no_hdr0=''),
  405 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=405, CurrentID=0, Status='live', Symbol='ARNT', Aliases='HIF-1-beta, HIF-1beta, HIF1-beta, HIF1B, HIF1BETA, TANGO, bHLHe2', description='aryl hydrocarbon receptor nuclear translocator', other_designations='class E basic helix-loop-helix protein 2|dioxin receptor, nuclear translocator|hypoxia-inducible factor 1, beta subunit', map_location='1q21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150809705, end_position_on_the_genomic_accession=150876768, orientation='minus', exon_count=25, OMIM=126110, no_hdr0=''),
  406 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=406, CurrentID=0, Status='live', Symbol='ARNTL', Aliases='BMAL1, BMAL1c, JAP3, MOP3, PASD3, TIC, bHLHe5', description='aryl hydrocarbon receptor nuclear translocator like', other_designations='ARNT-like protein 1, brain and muscle|PAS domain-containing protein 3|bHLH-PAS protein JAP3|basic-helix-loop-helix-PAS orphan MOP3|basic-helix-loop-helix-PAS protein MOP3|brain and muscle ARNT-like 1|class E basic helix-loop-helix protein 5|member of PAS protein 3|member of PAS superfamily 3', map_location='11p15', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=13277727, end_position_on_the_genomic_accession=13387811, orientation='plus', exon_count=21, OMIM=602550, no_hdr0=''),
  407 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=407, CurrentID=0, Status='live', Symbol='ARR3', Aliases='ARRX', description='arrestin 3, retinal (X-arrestin)', other_designations='C-arrestin|X-arrestin|arrestin 4|cArr|cone arrestin|retinal cone arrestin-3', map_location='Xcen-q21', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=70263503, end_position_on_the_genomic_accession=70281840, orientation='plus', exon_count=17, OMIM=301770, no_hdr0=''),
  408 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=408, CurrentID=0, Status='live', Symbol='ARRB1', Aliases='ARB1, ARR1', description='arrestin, beta 1', other_designations='arrestin 2', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=75260122, end_position_on_the_genomic_accession=75351831, orientation='minus', exon_count=19, OMIM=107940, no_hdr0=''),
  409 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=409, CurrentID=0, Status='live', Symbol='ARRB2', Aliases='ARB2, ARR2, BARR2', description='arrestin, beta 2', other_designations='arrestin 3|arrestin beta-2', map_location='17p13', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=4710494, end_position_on_the_genomic_accession=4721500, orientation='plus', exon_count=17, OMIM=107941, no_hdr0=''),
  410 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=410, CurrentID=0, Status='live', Symbol='ARSA', Aliases='MLD', description='arylsulfatase A', other_designations='ASA|cerebroside-sulfatase', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50622754, end_position_on_the_genomic_accession=50628173, orientation='minus', exon_count=9, OMIM=607574, no_hdr0=''),
  411 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=411, CurrentID=0, Status='live', Symbol='ARSB', Aliases='ASB, G4S, MPS6', description='arylsulfatase B', other_designations='N-acetylgalactosamine-4-sulfatase', map_location='5q14.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=78777209, end_position_on_the_genomic_accession=78986534, orientation='minus', exon_count=14, OMIM=611542, no_hdr0=''),
  412 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=412, CurrentID=0, Status='live', Symbol='STS', Aliases='ARSC, ARSC1, ASC, ES, SSDD, XLI', description='steroid sulfatase (microsomal), isozyme S', other_designations='arylsulfatase C|estrone sulfatase|steryl-sulfate sulfohydrolase', map_location='Xp22.32', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=7146517, end_position_on_the_genomic_accession=7354641, orientation='plus', exon_count=16, OMIM=300747, no_hdr0=''),
  197021 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=197021, CurrentID=0, Status='live', Symbol='LCTL', Aliases='KLG, KLPH', description='lactase like', other_designations='KL lactase phlorizin hydrolase|klotho gamma|klotho/lactase-phlorizin hydrolase-related protein|lactase-like', map_location='15q22.31', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=66547468, end_position_on_the_genomic_accession=66565979, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  414 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=414, CurrentID=0, Status='live', Symbol='ARSD', Aliases='ASD', description='arylsulfatase D', other_designations='', map_location='Xp22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=2903970, end_position_on_the_genomic_accession=2929375, orientation='minus', exon_count=11, OMIM=300002, no_hdr0=''),
  415 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=415, CurrentID=0, Status='live', Symbol='ARSE', Aliases='ASE, CDPX, CDPX1, CDPXR', description='arylsulfatase E (chondrodysplasia punctata 1)', other_designations='', map_location='Xp22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=2934632, end_position_on_the_genomic_accession=2968310, orientation='minus', exon_count=13, OMIM=300180, no_hdr0=''),
  416 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=416, CurrentID=0, Status='live', Symbol='ARSF', Aliases='ASF', description='arylsulfatase F', other_designations='', map_location='Xp22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=3040234, end_position_on_the_genomic_accession=3112729, orientation='plus', exon_count=14, OMIM=300003, no_hdr0=''),
  417 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=417, CurrentID=0, Status='live', Symbol='ART1', Aliases='ART2, ARTC1, CD296, RT6', description='ADP-ribosyltransferase 1', other_designations='ADP-ribosyltransferase 2|ADP-ribosyltransferase C2 and C3 toxin-like 1|mono(ADP-ribosyl)transferase 1', map_location='11p15', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=3642234, end_position_on_the_genomic_accession=3665075, orientation='plus', exon_count=7, OMIM=601625, no_hdr0=''),
  419 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=419, CurrentID=0, Status='live', Symbol='ART3', Aliases='ARTC3', description='ADP-ribosyltransferase 3', other_designations='ADP-ribosyltransferase C2 and C3 toxin-like 3|NAD(P)(+)--arginine ADP-ribosyltransferase 3|mono(ADP-ribosyl)transferase 3|mono-ADP-ribosyltransferase', map_location='4p15.1-p14', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=76011180, end_position_on_the_genomic_accession=76112802, orientation='plus', exon_count=16, OMIM=603086, no_hdr0=''),
  420 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=420, CurrentID=0, Status='live', Symbol='ART4', Aliases='ARTC4, CD297, DO, DOK1', description='ADP-ribosyltransferase 4 (Dombrock blood group)', other_designations='ADP-ribosyltransferase 4 (DO blood group)|ADP-ribosyltransferase C2 and C3 toxin-like 4|Dombrock blood group carrier molecule|NAD(P)(+)--arginine ADP-ribosyltransferase 4|mono-ADP-ribosyltransferase 4', map_location='12p13-p12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=14829311, end_position_on_the_genomic_accession=14843479, orientation='minus', exon_count=3, OMIM=110600, no_hdr0=''),
  421 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=421, CurrentID=0, Status='live', Symbol='ARVCF', Aliases='', description='armadillo repeat gene deleted in velocardiofacial syndrome', other_designations='', map_location='22q11.21', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=19966603, end_position_on_the_genomic_accession=20016802, orientation='minus', exon_count=27, OMIM=602269, no_hdr0=''),
  79696 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=79696, CurrentID=0, Status='live', Symbol='ZC2HC1C', Aliases='C14orf140, FAM164C', description='zinc finger C2HC-type containing 1C', other_designations='family with sequence similarity 164, member C|protein FAM164C|zinc finger, C2HC-type containing 1C', map_location='14q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=75069232, end_position_on_the_genomic_accession=75079987, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  427 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=427, CurrentID=0, Status='live', Symbol='ASAH1', Aliases='AC, ACDase, ASAH, PHP, PHP32, SMAPME', description='N-acylsphingosine amidohydrolase (acid ceramidase) 1', other_designations='acid CDase|acylsphingosine deacylase|putative 32 kDa heart protein', map_location='8p22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=18056416, end_position_on_the_genomic_accession=18084998, orientation='minus', exon_count=16, OMIM=613468, no_hdr0=''),
  429 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=429, CurrentID=0, Status='live', Symbol='ASCL1', Aliases='ASH1, HASH1, MASH1, bHLHa46', description='achaete-scute family bHLH transcription factor 1', other_designations='ASH-1|achaete scute protein|achaete-scute complex homolog 1|achaete-scute complex-like 1|class A basic helix-loop-helix protein 46', map_location='12q23.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=102957674, end_position_on_the_genomic_accession=102960516, orientation='plus', exon_count=2, OMIM=100790, no_hdr0=''),
  430 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=430, CurrentID=0, Status='live', Symbol='ASCL2', Aliases='ASH2, HASH2, MASH2, bHLHa45', description='achaete-scute family bHLH transcription factor 2', other_designations='ASH-2|achaete-scute complex homolog 2|achaete-scute complex-like 2|class A basic helix-loop-helix protein 45|mammalian achaete/scute homologue 2', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=2268498, end_position_on_the_genomic_accession=2270952, orientation='minus', exon_count=2, OMIM=601886, no_hdr0=''),
  432 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=432, CurrentID=0, Status='live', Symbol='ASGR1', Aliases='ASGPR, ASGPR1, CLEC4H1, HL-1', description='asialoglycoprotein receptor 1', other_designations='C-type lectin domain family 4 member H1|hepatic lectin H1', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7173431, end_position_on_the_genomic_accession=7179564, orientation='minus', exon_count=10, OMIM=108360, no_hdr0=''),
  433 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=433, CurrentID=0, Status='live', Symbol='ASGR2', Aliases='ASGP-R2, ASGPR2, CLEC4H2, HBXBP, HL-2', description='asialoglycoprotein receptor 2', other_designations='C-type lectin domain family 4 member H2|HBxAg-binding protein|hepatic lectin H2', map_location='17p', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7101322, end_position_on_the_genomic_accession=7115522, orientation='minus', exon_count=11, OMIM=108361, no_hdr0=''),
  434 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=434, CurrentID=0, Status='live', Symbol='ASIP', Aliases='AGSW, AGTI, AGTIL, ASP, SHEP9', description='agouti signaling protein', other_designations='agouti signaling protein, nonagouti homolog|agouti switch protein|nonagouti homolog', map_location='20q11.2-q12', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=34186493, end_position_on_the_genomic_accession=34269344, orientation='plus', exon_count=8, OMIM=600201, no_hdr0=''),
  435 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=435, CurrentID=0, Status='live', Symbol='ASL', Aliases='ASAL', description='argininosuccinate lyase', other_designations='argininosuccinase|arginosuccinase', map_location='7q11.21', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=66075789, end_position_on_the_genomic_accession=66093343, orientation='plus', exon_count=17, OMIM=608310, no_hdr0=''),
  438 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=438, CurrentID=0, Status='live', Symbol='ASMT', Aliases='ASMTY, HIOMT, HIOMTY', description='acetylserotonin O-methyltransferase', other_designations='acetylserotonin N-methyltransferase|acetylserotonin methyltransferase (Y chromosome)|hydroxyindole O-methyltransferase', map_location='Xp22.3 or Yp11.3', chromosome='Y', genomic_nucleotide_accession_version='NC_000024.10', start_position_on_the_genomic_accession=1595455, end_position_on_the_genomic_accession=1643081, orientation='plus', exon_count=10, OMIM='300015,402500', no_hdr0=''),
  439 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=439, CurrentID=0, Status='live', Symbol='ASNA1', Aliases='ARSA-I, ARSA1, ASNA-I, GET3, TRC40, hASNA-I', description='arsA arsenite transporter, ATP-binding, homolog 1 (bacterial)', other_designations='golgi to ER traffic 3 homolog|transmembrane domain recognition complex 40 kDa ATPase subunit|transmembrane domain recognition complex, 40kDa', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12737492, end_position_on_the_genomic_accession=12748323, orientation='plus', exon_count=7, OMIM=601913, no_hdr0=''),
  440 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=440, CurrentID=0, Status='live', Symbol='ASNS', Aliases='ASNSD, TS11', description='asparagine synthetase (glutamine-hydrolyzing)', other_designations='TS11 cell cycle control protein|glutamine-dependent asparagine synthetase', map_location='7q21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=97852117, end_position_on_the_genomic_accession=97872542, orientation='minus', exon_count=15, OMIM=108370, no_hdr0=''),
  65977 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65977, CurrentID=0, Status='live', Symbol='PLEKHA3', Aliases='FAPP1', description='pleckstrin homology domain containing A3', other_designations='FAPP-1|PH domain-containing family A member 3|four-phosphate-adaptor protein 1|phosphatidylinositol-four-phosphate adapter protein 1|phosphoinositol 4-phosphate adapter protein 1|pleckstrin homology domain containing, family A (phosphoinositide binding specific) member 3|pleckstrin homology domain-containing, family A (phosphoinositide binding specific) member 3', map_location='2q31.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=178480410, end_position_on_the_genomic_accession=178505586, orientation='plus', exon_count=9, OMIM=607774, no_hdr0=''),
  443 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=443, CurrentID=0, Status='live', Symbol='ASPA', Aliases='ACY2, ASP', description='aspartoacylase', other_designations='ACY-2|aminoacylase 2|aminoacylase-2', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=3474110, end_position_on_the_genomic_accession=3499406, orientation='plus', exon_count=9, OMIM=608034, no_hdr0=''),
  444 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=444, CurrentID=0, Status='live', Symbol='ASPH', Aliases='AAH, BAH, CASQ2BP1, FDLAB, HAAH, JCTN, junctin', description='aspartate beta-hydroxylase', other_designations='A beta H-J-J|ASP beta-hydroxylase|aspartyl/asparaginyl-beta-hydroxylase|cardiac junctin|humbug|junctate|peptide-aspartate beta-dioxygenase', map_location='8q12.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=61500556, end_position_on_the_genomic_accession=61714640, orientation='minus', exon_count=32, OMIM=600582, no_hdr0=''),
  445 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=445, CurrentID=0, Status='live', Symbol='ASS1', Aliases='ASS, CTLN1', description='argininosuccinate synthase 1', other_designations='argininosuccinate synthetase 1|citrulline--aspartate ligase|citrulline-aspartate ligase', map_location='9q34.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=130444707, end_position_on_the_genomic_accession=130501274, orientation='plus', exon_count=18, OMIM=603470, no_hdr0=''),
  65982 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65982, CurrentID=0, Status='live', Symbol='ZSCAN18', Aliases='ZNF447', description='zinc finger and SCAN domain containing 18', other_designations='zinc finger protein 447', map_location='19q13.43', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=58083834, end_position_on_the_genomic_accession=58118433, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  65983 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65983, CurrentID=0, Status='live', Symbol='GRAMD3', Aliases='NS3TP2', description='GRAM domain containing 3', other_designations='HCV NS3-transactivated protein 2|hepatitis C virus nonstructural protein 3-transactivating protein 2', map_location='5q23.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=126360096, end_position_on_the_genomic_accession=126494364, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  65985 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65985, CurrentID=0, Status='live', Symbol='AACS', Aliases='ACSF1, SUR-5', description='acetoacetyl-CoA synthetase', other_designations='acetoacetate-CoA ligase|acyl-CoA synthetase family member 1|homolog of C. elegans supressor of ras 5 (sur-5)|protein sur-5 homolog', map_location='12q24.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=125065379, end_position_on_the_genomic_accession=125143327, orientation='plus', exon_count=19, OMIM=614364, no_hdr0=''),
  65986 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65986, CurrentID=0, Status='live', Symbol='ZBTB10', Aliases='RINZF', description='zinc finger and BTB domain containing 10', other_designations='zinc finger protein RIN ZF|zinc finger protein RINZF', map_location='8q13-q21.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=80485619, end_position_on_the_genomic_accession=80526265, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  65987 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65987, CurrentID=0, Status='live', Symbol='KCTD14', Aliases='', description='potassium channel tetramerization domain containing 14', other_designations='potassium channel tetramerisation domain containing 14', map_location='11q14.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=78015715, end_position_on_the_genomic_accession=78046191, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  65988 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65988, CurrentID=0, Status='live', Symbol='ZNF747', Aliases='', description='zinc finger protein 747', other_designations='', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=30530367, end_position_on_the_genomic_accession=30534970, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  65989 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65989, CurrentID=0, Status='live', Symbol='DLK2', Aliases='DLK-2, EGFL9', description='delta-like 2 homolog (Drosophila)', other_designations='EGF-like protein 9|EGF-like-domain, multiple 9|epidermal growth factor-like protein 9', map_location='6p21.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=43450352, end_position_on_the_genomic_accession=43456632, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  65990 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65990, CurrentID=0, Status='live', Symbol='FAM173A', Aliases='C16orf24', description='family with sequence similarity 173 member A', other_designations='family with sequence similarity 173, member A', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=720581, end_position_on_the_genomic_accession=722590, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  65991 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65991, CurrentID=0, Status='live', Symbol='FUNDC2', Aliases='DC44, HCBP6, HCC3, PD03104', description='FUN14 domain containing 2', other_designations='HCC-3|cervical cancer oncogene 3|cervical cancer proto-oncogene 3 protein|hepatitis C virus core-binding protein 6', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=155026789, end_position_on_the_genomic_accession=155056916, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  65992 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65992, CurrentID=0, Status='live', Symbol='DDRGK1', Aliases='C20orf116, UFBP1, dJ1187M17.3', description='DDRGK domain containing 1', other_designations='Dashurin|UFM1-binding and PCI domain-containing protein 1|UFM1-binding protein 1 containing a PCI domain', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=3190366, end_position_on_the_genomic_accession=3204649, orientation='minus', exon_count=9, OMIM=616177, no_hdr0=''),
  65993 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65993, CurrentID=0, Status='live', Symbol='MRPS34', Aliases='MRP-S12, MRP-S34, MRPS12', description='mitochondrial ribosomal protein S34', other_designations='S34mt|mitochondrial 28S ribosomal protein S34', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=1771895, end_position_on_the_genomic_accession=1773139, orientation='minus', exon_count=3, OMIM=611994, no_hdr0=''),
  460 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=460, CurrentID=0, Status='live', Symbol='ASTN1', Aliases='ASTN', description='astrotactin 1', other_designations='', map_location='1q25.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=176857305, end_position_on_the_genomic_accession=177164904, orientation='minus', exon_count=26, OMIM=600904, no_hdr0=''),
  65997 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=65997, CurrentID=0, Status='live', Symbol='RASL11B', Aliases='', description='RAS like family 11 member B', other_designations='RAS-like family 11 member B|RAS-like, family 11, member B', map_location='4q12', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=52862328, end_position_on_the_genomic_accession=52866835, orientation='plus', exon_count=4, OMIM=612404, no_hdr0=''),
  462 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=462, CurrentID=0, Status='live', Symbol='SERPINC1', Aliases='AT3, AT3D, ATIII, THPH7', description='serpin peptidase inhibitor, clade C (antithrombin), member 1', other_designations='serine (or cysteine) proteinase inhibitor, clade C (antithrombin), member 1|serpin peptidase inhibitor clade C member 1', map_location='1q25.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=173903800, end_position_on_the_genomic_accession=173917378, orientation='minus', exon_count=8, OMIM=107300, no_hdr0=''),
  463 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=463, CurrentID=0, Status='live', Symbol='ZFHX3', Aliases='ATBF1, ATBT, ZNF927', description='zinc finger homeobox 3', other_designations='AT motif-binding factor 1|AT-binding transcription factor 1|ZFH-3|alpha-fetoprotein enhancer binding protein|alpha-fetoprotein enhancer-binding protein|zinc finger homeodomain protein 3', map_location='16q22.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=72782885, end_position_on_the_genomic_accession=73058635, orientation='minus', exon_count=11, OMIM=104155, no_hdr0=''),
  22929 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=22929, CurrentID=0, Status='live', Symbol='SEPHS1', Aliases='SELD, SPS, SPS1', description='selenophosphate synthetase 1', other_designations='selenium donor protein 1|selenophosphate synthase 1|selenophosphate synthetase 1 +E9|selenophosphate synthetase 1 +E9a|selenophosphate synthetase 1 delta E2|selenophosphate synthetase 1 delta E8|selenophosphate synthetase 1 major', map_location='10p14', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=13317428, end_position_on_the_genomic_accession=13348298, orientation='minus', exon_count=9, OMIM=600902, no_hdr0=''),
  466 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=466, CurrentID=0, Status='live', Symbol='ATF1', Aliases='EWS-ATF1, FUS/ATF-1, TREB36', description='activating transcription factor 1', other_designations='cAMP-dependent transcription factor ATF-1', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=50763710, end_position_on_the_genomic_accession=50821167, orientation='plus', exon_count=9, OMIM=123803, no_hdr0=''),
  467 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=467, CurrentID=0, Status='live', Symbol='ATF3', Aliases='', description='activating transcription factor 3', other_designations='cAMP-dependent transcription factor ATF-3', map_location='1q32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=212565334, end_position_on_the_genomic_accession=212620777, orientation='plus', exon_count=7, OMIM=603148, no_hdr0=''),
  468 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=468, CurrentID=0, Status='live', Symbol='ATF4', Aliases='CREB-2, CREB2, TAXREB67, TXREB', description='activating transcription factor 4', other_designations='DNA-binding protein TAXREB67|cAMP response element-binding protein 2|cAMP-dependent transcription factor ATF-4|cAMP-responsive element-binding protein 2|cyclic AMP-responsive element-binding protein 2|tax-responsive enhancer element B67|tax-responsive enhancer element-binding protein 67', map_location='22q13.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=39520559, end_position_on_the_genomic_accession=39522686, orientation='plus', exon_count=3, OMIM=604064, no_hdr0=''),
  66005 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=66005, CurrentID=0, Status='live', Symbol='CHID1', Aliases='GL008, SI-CLP, SICLP', description='chitinase domain containing 1', other_designations='stabilin-1 interacting chitinase-like protein|stabilin-1-interacting chitinase-like protein', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=867859, end_position_on_the_genomic_accession=915058, orientation='minus', exon_count=19, OMIM=615692, no_hdr0=''),
  471 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=471, CurrentID=0, Status='live', Symbol='ATIC', Aliases='AICAR, AICARFT, HEL-S-70p, IMPCHASE, PURH', description='5-aminoimidazole-4-carboxamide ribonucleotide formyltransferase/IMP cyclohydrolase', other_designations='5-aminoimidazole-4-carboxamide-1-beta-D-ribonucleotide transformylase/inosinicase|AICAR formyltransferase/IMP cyclohydrolase bifunctional enzyme|AICARFT/IMPCHASE|epididymis secretory sperm binding protein Li 70p|phosphoribosylaminoimidazolecarboxamide formyltransferase/IMP cyclohydrolase', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=215311956, end_position_on_the_genomic_accession=215349773, orientation='plus', exon_count=16, OMIM=601731, no_hdr0=''),
  472 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=472, CurrentID=0, Status='live', Symbol='ATM', Aliases='AT1, ATA, ATC, ATD, ATDC, ATE, TEL1, TELO1', description='ATM serine/threonine kinase', other_designations='A-T mutated|AT mutated|TEL1, telomere maintenance 1, homolog|ataxia telangiectasia mutated', map_location='11q22-q23', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=108222500, end_position_on_the_genomic_accession=108369102, orientation='plus', exon_count=69, OMIM=607585, no_hdr0=''),
  473 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=473, CurrentID=0, Status='live', Symbol='RERE', Aliases='ARG, ARP, ATN1L, DNB1', description='arginine-glutamic acid dipeptide (RE) repeats', other_designations='atrophin 2|atrophin-1 like protein|atrophin-1 related protein|atrophin-1-like protein|atrophin-1-related protein', map_location='1p36.23', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=8352404, end_position_on_the_genomic_accession=8817691, orientation='minus', exon_count=28, OMIM=605226, no_hdr0=''),
  474 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=474, CurrentID=0, Status='live', Symbol='ATOH1', Aliases='ATH1, HATH1, MATH-1, bHLHa14', description='atonal bHLH transcription factor 1', other_designations='atonal homolog 1|atonal homolog bHLH transcription factor 1|class A basic helix-loop-helix protein 14|helix-loop-helix protein hATH-1', map_location='4q22', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=93828927, end_position_on_the_genomic_accession=93829991, orientation='plus', exon_count=1, OMIM=601461, no_hdr0=''),
  475 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=475, CurrentID=0, Status='live', Symbol='ATOX1', Aliases='ATX1, HAH1', description='antioxidant 1 copper chaperone', other_designations='ATX1 antioxidant protein 1 homolog|metal transport protein ATX1', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=151742822, end_position_on_the_genomic_accession=151758649, orientation='minus', exon_count=4, OMIM=602270, no_hdr0=''),
  476 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=476, CurrentID=0, Status='live', Symbol='ATP1A1', Aliases='', description='ATPase Na+/K+ transporting subunit alpha 1', other_designations='ATPase, Na+/K+ transporting, alpha 1 polypeptide|Na(+)/K(+) ATPase alpha-1 subunit|Na+, K+ ATPase alpha subunit|Na+/K+ ATPase 1|Na, K-ATPase, alpha-A catalytic polypeptide|Na,K-ATPase alpha-1 subunit|Na,K-ATPase catalytic subunit alpha-A protein|sodium pump 1|sodium pump subunit alpha-1|sodium-potassium ATPase catalytic subunit alpha-1|sodium-potassium-ATPase, alpha 1 polypeptide', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=116372185, end_position_on_the_genomic_accession=116404774, orientation='plus', exon_count=26, OMIM=182310, no_hdr0=''),
  477 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=477, CurrentID=0, Status='live', Symbol='ATP1A2', Aliases='FHM2, MHP2', description='ATPase Na+/K+ transporting subunit alpha 2', other_designations='ATPase Na+/K+ transporting alpha 2 polypeptide|ATPase, Na+/K+ transporting, alpha 2 polypeptide|Na(+)/K(+) ATPase alpha-2 subunit|Na+/K+ ATPase, alpha-A(+) catalytic polypeptide|Na+/K+ ATPase, alpha-B polypeptide|sodium pump subunit alpha-2|sodium-potassium ATPase catalytic subunit alpha-2|sodium/potassium-transporting ATPase alpha-2 chain', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160115730, end_position_on_the_genomic_accession=160143591, orientation='plus', exon_count=23, OMIM=182340, no_hdr0=''),
  478 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=478, CurrentID=0, Status='live', Symbol='ATP1A3', Aliases='AHC2, CAPOS, DYT12, RDP', description='ATPase Na+/K+ transporting subunit alpha 3', other_designations='ATPase, Na+/K+ transporting, alpha 3 polypeptide|Na(+)/K(+) ATPase alpha(III) subunit|Na(+)/K(+) ATPase alpha-3 subunit|Na+/K+ ATPase 3|sodium pump subunit alpha-3|sodium-potassium ATPase catalytic subunit alpha-3|sodium-potassium-ATPase, alpha 3 polypeptide|sodium/potassium-transporting ATPase alpha-3 chain', map_location='19q13.31', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41966582, end_position_on_the_genomic_accession=41994276, orientation='minus', exon_count=24, OMIM=182350, no_hdr0=''),
  479 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=479, CurrentID=0, Status='live', Symbol='ATP12A', Aliases='ATP1AL1, HK', description='ATPase H+/K+ transporting non-gastric alpha2 subunit', other_designations='ATPase, H+/K+ transporting, nongastric, alpha polypeptide|ATPase, Na+/K+ transporting, alpha polypeptide-like 1|non-gastric H(+)/K(+) ATPase alpha subunit|non-gastric H(+)/K(+) ATPase subunit alpha|proton pump', map_location='13q12.1-q12.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=24680411, end_position_on_the_genomic_accession=24711785, orientation='plus', exon_count=23, OMIM=182360, no_hdr0=''),
  480 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=480, CurrentID=0, Status='live', Symbol='ATP1A4', Aliases='ATP1A1, ATP1AL2', description='ATPase Na+/K+ transporting subunit alpha 4', other_designations='ATPase, Na+/K+ transporting, alpha 4 polypeptide|ATPase, Na+/K+ transporting, alpha polypeptide-like 2|Na(+)/K(+) ATPase alpha-4 subunit|Na+/K+ ATPase 4|Na+/K+ ATPase, alpha-D polypeptide|Na,K-ATPase subunit alpha-C|sodium pump 4|sodium pump subunit alpha-4|sodium-potassium ATPase catalytic subunit alpha-4|sodium/potassium-transporting ATPase alpha-4 chain', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160151562, end_position_on_the_genomic_accession=160186977, orientation='plus', exon_count=23, OMIM=607321, no_hdr0=''),
  481 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=481, CurrentID=0, Status='live', Symbol='ATP1B1', Aliases='ATP1B', description='ATPase Na+/K+ transporting subunit beta 1', other_designations='ATPase, Na+/K+ transporting, beta 1 polypeptide|Beta 1-subunit of Na(+),K(+)-ATPase|Na, K-ATPase beta-1 polypeptide|adenosinetriphosphatase|sodium pump subunit beta-1|sodium-potassium ATPase subunit beta 1 (non-catalytic)|sodium/potassium-dependent ATPase beta-1 subunit|sodium/potassium-transporting ATPase beta-1 chain', map_location='1q24', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=169106709, end_position_on_the_genomic_accession=169132722, orientation='plus', exon_count=6, OMIM=182330, no_hdr0=''),
  482 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=482, CurrentID=0, Status='live', Symbol='ATP1B2', Aliases='AMOG', description='ATPase Na+/K+ transporting subunit beta 2', other_designations='ATPase, Na+/K+ transporting, beta 2 polypeptide|Na, K-ATPase beta-2 polypeptide|adhesion molecule in glia|adhesion molecule on glia|sodium pump subunit beta-2|sodium-potassium ATPase subunit beta 2 (non-catalytic)|sodium/potassium-dependent ATPase beta-2 subunit|sodium/potassium-dependent ATPase subunit beta-2|sodium/potassium-transporting ATPase beta-2 chain', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7646627, end_position_on_the_genomic_accession=7657771, orientation='plus', exon_count=8, OMIM=182331, no_hdr0=''),
  483 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=483, CurrentID=0, Status='live', Symbol='ATP1B3', Aliases='ATPB-3, CD298', description='ATPase Na+/K+ transporting subunit beta 3', other_designations='ATPase, Na+/K+ transporting, beta 3 polypeptide|Na, K-ATPase beta-3 polypeptide|sodium pump subunit beta-3|sodium-potassium ATPase subunit beta 3 (non-catalytic)|sodium/potassium-dependent ATPase beta-3 subunit|sodium/potassium-dependent ATPase subunit beta-3|sodium/potassium-transporting ATPase beta-3 chain', map_location='3q23', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=141876628, end_position_on_the_genomic_accession=141926540, orientation='plus', exon_count=7, OMIM=601867, no_hdr0=''),
  486 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=486, CurrentID=0, Status='live', Symbol='FXYD2', Aliases='ATP1G1, HOMG2', description='FXYD domain containing ion transport regulator 2', other_designations='ATPase, Na+/K+ transporting, gamma 1 polypeptide|Na(+)/K(+) ATPase subunit gamma|sodium pump gamma chain', map_location='11q23', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=117820075, end_position_on_the_genomic_accession=117828092, orientation='minus', exon_count=7, OMIM=601814, no_hdr0=''),
  487 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=487, CurrentID=0, Status='live', Symbol='ATP2A1', Aliases='ATP2A, SERCA1', description='ATPase sarcoplasmic/endoplasmic reticulum Ca2+ transporting 1', other_designations='ATPase, Ca++ transporting, cardiac muscle, fast twitch 1|SR Ca(2+)-ATPase 1|calcium pump 1|calcium-transporting ATPase sarcoplasmic reticulum type, fast twitch skeletal muscle isoform|endoplasmic reticulum class 1/2 Ca(2+) ATPase', map_location='16p12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=28878488, end_position_on_the_genomic_accession=28904509, orientation='plus', exon_count=24, OMIM=108730, no_hdr0=''),
  488 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=488, CurrentID=0, Status='live', Symbol='ATP2A2', Aliases='ATP2B, DAR, DD, SERCA2', description='ATPase sarcoplasmic/endoplasmic reticulum Ca2+ transporting 2', other_designations='ATPase Ca++ transporting cardiac muscle slow twitch 2|ATPase, Ca++ dependent, slow-twitch, cardiac muscle-2|ATPase, Ca++ transporting, cardiac muscle, slow twitch 2|SR Ca(2+)-ATPase 2|calcium pump 2|calcium-transporting ATPase sarcoplasmic reticulum type, slow twitch skeletal muscle isoform|cardiac Ca2+ ATPase|endoplasmic reticulum class 1/2 Ca(2+) ATPase', map_location='12q24.11', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=110281227, end_position_on_the_genomic_accession=110351093, orientation='plus', exon_count=21, OMIM=108740, no_hdr0=''),
  489 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=489, CurrentID=0, Status='live', Symbol='ATP2A3', Aliases='SERCA3', description='ATPase sarcoplasmic/endoplasmic reticulum Ca2+ transporting 3', other_designations='ATPase, Ca(2+)-transporting, ubiquitous|ATPase, Ca++ transporting, ubiquitous|SR Ca(2+)-ATPase 3|adenosine triphosphatase, calcium|calcium pump 3|calcium-translocating P-type ATPase|sarco/endoplasmic reticulum Ca2+ -ATPase', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=3923869, end_position_on_the_genomic_accession=3964464, orientation='minus', exon_count=26, OMIM=601929, no_hdr0=''),
  490 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=490, CurrentID=0, Status='live', Symbol='ATP2B1', Aliases='PMCA1, PMCA1kb', description='ATPase plasma membrane Ca2+ transporting 1', other_designations='ATPase, Ca++ transporting, plasma membrane 1|plasma membrane calcium pump', map_location='12q21.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=89588049, end_position_on_the_genomic_accession=89709353, orientation='minus', exon_count=24, OMIM=108731, no_hdr0=''),
  491 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=491, CurrentID=0, Status='live', Symbol='ATP2B2', Aliases='PMCA2, PMCA2a, PMCA2i', description='ATPase plasma membrane Ca2+ transporting 2', other_designations='ATPase, Ca++ transporting, plasma membrane 2|plasma membrane Ca(2+)-ATPase|plasma membrane Ca2+ pump 2|plasma membrane calcium ATPase|plasma membrane calcium pump', map_location='3p25.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=10324023, end_position_on_the_genomic_accession=10707993, orientation='minus', exon_count=31, OMIM=108733, no_hdr0=''),
  492 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=492, CurrentID=0, Status='live', Symbol='ATP2B3', Aliases='CFAP39, CLA2, OPCA, PMCA3, PMCA3a, SCAX1', description='ATPase plasma membrane Ca2+ transporting 3', other_designations='ATPase, Ca++ transporting, plasma membrane 3|cilia and flagella associated protein 39|plasma membrane calcium ATPase|plasma membrane calcium pump', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153517665, end_position_on_the_genomic_accession=153582929, orientation='plus', exon_count=25, OMIM=300014, no_hdr0=''),
  493 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=493, CurrentID=0, Status='live', Symbol='ATP2B4', Aliases='ATP2B2, MXRA1, PMCA4, PMCA4b, PMCA4x', description='ATPase plasma membrane Ca2+ transporting 4', other_designations='ATPase, Ca++ transporting, plasma membrane 4|matrix-remodeling-associated protein 1|sarcolemmal calcium pump', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=203626787, end_position_on_the_genomic_accession=203744081, orientation='plus', exon_count=22, OMIM=108732, no_hdr0=''),
  131566 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131566, CurrentID=0, Status='live', Symbol='DCBLD2', Aliases='CLCP1, ESDN', description='discoidin, CUB and LCCL domain containing 2', other_designations='1700055P21Rik|CUB, LCCL and coagulation factor V/VIII-homology domains protein 1|coagulation factor V/VIII-homology domains protein 1|endothelial and smooth muscle cell-derived neuropilin-like protein', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=98795970, end_position_on_the_genomic_accession=98901689, orientation='minus', exon_count=16, OMIM=608698, no_hdr0=''),
  495 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=495, CurrentID=0, Status='live', Symbol='ATP4A', Aliases='ATP6A', description='ATPase H+/K+ transporting alpha subunit', other_designations='ATPase, H+/K+ exchanging, alpha polypeptide|ATPase, H+/K+ transporting, alpha polypeptide|H(+)-K(+)-ATPase alpha subunit|gastric H(+)/K(+) ATPase subunit alpha|gastric H+/K+ ATPase alpha subunit|gastric H,K-ATPase alpha subunit|gastric H,K-ATPase catalytic subunit|gastric hydrogen-potassium ATPase|proton pump', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=35550193, end_position_on_the_genomic_accession=35563658, orientation='minus', exon_count=22, OMIM=137216, no_hdr0=''),
  496 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=496, CurrentID=0, Status='live', Symbol='ATP4B', Aliases='ATP6B', description='ATPase H+/K+ transporting beta subunit', other_designations='ATPase, H+/K+ exchanging, beta polypeptide|ATPase, H+/K+ transporting, beta polypeptide|gastric H(+)/K(+) ATPase subunit beta|gastric H+/K+ ATPase beta subunit|gastric hydrogen-potassium ATPase, beta|potassium-transporting ATPase beta chain|proton pump beta chain', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=113648804, end_position_on_the_genomic_accession=113658198, orientation='minus', exon_count=7, OMIM=137217, no_hdr0=''),
  498 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=498, CurrentID=0, Status='live', Symbol='ATP5A1', Aliases='ATP5A, ATP5AL2, ATPM, COXPD22, HEL-S-123m, MC5DN4, MOM2, OMR, ORM, hATP1', description='ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit 1, cardiac muscle', other_designations='ATP synthase alpha chain, mitochondrial|ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit, isoform 1, cardiac muscle|ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit, isoform 2, non-cardiac muscle-like 2|ATP sythase (F1-ATPase) alpha subunit|epididymis secretory sperm binding protein Li 123m|mitochondrial ATP synthetase, oligomycin-resistant', map_location='18q21', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=46084144, end_position_on_the_genomic_accession=46104233, orientation='minus', exon_count=13, OMIM=164360, no_hdr0=''),
  66035 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=66035, CurrentID=0, Status='live', Symbol='SLC2A11', Aliases='GLUT10, GLUT11', description='solute carrier family 2 member 11', other_designations='facilitative glucose transporter GLUT11|glucose transporter protein 10|glucose transporter protein 11|glucose transporter type 10|glucose transporter type 11|glucose transporter-like protein XI|solute carrier family 2 (facilitated glucose transporter), member 11', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=23856703, end_position_on_the_genomic_accession=23886112, orientation='plus', exon_count=14, OMIM=610367, no_hdr0=''),
  66036 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=66036, CurrentID=0, Status='live', Symbol='MTMR9', Aliases='C8orf9, LIP-STYX, MTMR8', description='myotubularin related protein 9', other_designations='myotubularin related protein 8', map_location='8p23-p22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=11284491, end_position_on_the_genomic_accession=11328146, orientation='plus', exon_count=12, OMIM=606260, no_hdr0=''),
  501 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=501, CurrentID=0, Status='live', Symbol='ALDH7A1', Aliases='ATQ1, EPD, PDE', description='aldehyde dehydrogenase 7 family member A1', other_designations='26g turgor protein homolog|P6c dehydrogenase|aldehyde dehydrogenase 7 family, member A1|alpha-AASA dehydrogenase|antiquitin-1|betaine aldehyde dehydrogenase|delta1-piperideine-6-carboxylate dehydrogenase', map_location='5q31', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=126541841, end_position_on_the_genomic_accession=126595390, orientation='minus', exon_count=19, OMIM=107323, no_hdr0=''),
  100532726 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100532726, CurrentID=0, Status='live', Symbol='NDUFC2-KCTD14', Aliases='', description='NDUFC2-KCTD14 readthrough', other_designations='NDUFC2-KCTD14 readthrough transcript protein', map_location='11q14.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=78015715, end_position_on_the_genomic_accession=78080219, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  100505741 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100505741, CurrentID=0, Status='live', Symbol='SPATA1', Aliases='SP-2, SPAP1', description='spermatogenesis associated 1', other_designations='sperm-specific protein SP-2|spermatogenesis associated protein 1', map_location='1p22.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=84506301, end_position_on_the_genomic_accession=84556495, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  729528 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=729528, CurrentID=0, Status='live', Symbol='PRAMEF14', Aliases='', description='PRAME family member 14', other_designations='', map_location='1p36.21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=13341892, end_position_on_the_genomic_accession=13347134, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  506 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=506, CurrentID=0, Status='live', Symbol='ATP5B', Aliases='ATPMB, ATPSB, HEL-S-271', description='ATP synthase, H+ transporting, mitochondrial F1 complex, beta polypeptide', other_designations='epididymis secretory protein Li 271|mitochondrial ATP synthase beta subunit|mitochondrial ATP synthetase, beta subunit', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=56638175, end_position_on_the_genomic_accession=56646068, orientation='minus', exon_count=10, OMIM=102910, no_hdr0=''),
  100532731 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100532731, CurrentID=0, Status='live', Symbol='COMMD3-BMI1', Aliases='', description='COMMD3-BMI1 readthrough', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=22316383, end_position_on_the_genomic_accession=22331485, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  29068 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=29068, CurrentID=0, Status='live', Symbol='ZBTB44', Aliases='BTBD15, HSPC063, ZNF851', description='zinc finger and BTB domain containing 44', other_designations='BTB (POZ) domain containing 15|BTB/POZ domain-containing protein 15|zinc finger protein 851', map_location='11q24.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=130226677, end_position_on_the_genomic_accession=130314769, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  509 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=509, CurrentID=0, Status='live', Symbol='ATP5C1', Aliases='ATP5C, ATP5CL1', description='ATP synthase, H+ transporting, mitochondrial F1 complex, gamma polypeptide 1', other_designations='ATP synthase gamma chain, mitochondrial|F-ATPase gamma subunit|mitochondrial ATP synthase, gamma subunit 1', map_location='10p15.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=7788130, end_position_on_the_genomic_accession=7807801, orientation='plus', exon_count=10, OMIM=108729, no_hdr0=''),
  131583 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131583, CurrentID=0, Status='live', Symbol='FAM43A', Aliases='', description='family with sequence similarity 43 member A', other_designations='family with sequence similarity 43, member A', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=194685893, end_position_on_the_genomic_accession=194689037, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  100532736 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100532736, CurrentID=0, Status='live', Symbol='MINOS1-NBL1', Aliases='C1orf151-NBL1', description='MINOS1-NBL1 readthrough', other_designations='', map_location='1p36.13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=19596977, end_position_on_the_genomic_accession=19658456, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  513 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=513, CurrentID=0, Status='live', Symbol='ATP5D', Aliases='', description='ATP synthase, H+ transporting, mitochondrial F1 complex, delta subunit', other_designations='F-ATPase delta subunit|mitochondrial ATP synthase complex delta-subunit precusor|mitochondrial ATP synthase, delta subunit', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1241750, end_position_on_the_genomic_accession=1244825, orientation='plus', exon_count=5, OMIM=603150, no_hdr0=''),
  514 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=514, CurrentID=0, Status='live', Symbol='ATP5E', Aliases='ATPE, MC5DN3', description='ATP synthase, H+ transporting, mitochondrial F1 complex, epsilon subunit', other_designations='F(0)F(1)-ATPase|H(+)-transporting two-sector ATPase|mitochondrial ATP synthase epsilon chain|mitochondrial ATPase', map_location='20q13.32', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=59028678, end_position_on_the_genomic_accession=59032367, orientation='minus', exon_count=3, OMIM=606153, no_hdr0=''),
  515 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=515, CurrentID=0, Status='live', Symbol='ATP5F1', Aliases='PIG47', description='ATP synthase, H+ transporting, mitochondrial Fo complex subunit B1', other_designations='ATP synthase B chain, mitochondrial|ATP synthase proton-transporting mitochondrial F(0) complex subunit B1|ATP synthase subunit b, mitochondrial|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit B1|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit b|ATP synthase, H+ transporting, mitochondrial Fo complex, subunit B1|ATPase subunit b|H+-ATP synthase subunit b|cell proliferation-inducing protein 47', map_location='1p13.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=111449121, end_position_on_the_genomic_accession=111461918, orientation='plus', exon_count=7, OMIM=603270, no_hdr0=''),
  516 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=516, CurrentID=0, Status='live', Symbol='ATP5G1', Aliases='ATP5A, ATP5G', description='ATP synthase, H+ transporting, mitochondrial Fo complex subunit C1 (subunit 9)', other_designations='ATP synthase lipid-binding protein, mitochondrial|ATP synthase proteolipid P1|ATP synthase proton-transporting mitochondrial F(0) complex subunit C1|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit C1 (subunit 9)|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit c (subunit 9)|ATP synthase, H+ transporting, mitochondrial Fo complex, subunit C1 (subunit 9)|ATPase protein 9|ATPase subunit 9|ATPase subunit C|mitochondrial ATP synthase, subunit 9|mitochondrial ATP synthase, subunit C', map_location='17q21.32', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=48892786, end_position_on_the_genomic_accession=48895871, orientation='plus', exon_count=5, OMIM=603192, no_hdr0=''),
  517 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=517, CurrentID=0, Status='live', Symbol='ATP5G2', Aliases='ATP5A', description='ATP synthase, H+ transporting, mitochondrial Fo complex subunit C2 (subunit 9)', other_designations='ATP synthase c subunit|ATP synthase lipid-binding protein, mitochondrial|ATP synthase proteolipid P2|ATP synthase proton-transporting mitochondrial F(0) complex subunit C2|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit C2 (subunit 9)|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit c (subunit 9)|ATP synthase, H+ transporting, mitochondrial Fo complex, subunit C2 (subunit 9)|ATPase protein 9|ATPase subunit C|mitochondrial ATP synthase, subunit C (subunit 9)', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=53665160, end_position_on_the_genomic_accession=53676728, orientation='minus', exon_count=6, OMIM=603193, no_hdr0=''),
  518 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=518, CurrentID=0, Status='live', Symbol='ATP5G3', Aliases='P3', description='ATP synthase, H+ transporting, mitochondrial Fo complex subunit C3 (subunit 9)', other_designations='ATP synthase lipid-binding protein, mitochondrial|ATP synthase proteolipid P3|ATP synthase proton-transporting mitochondrial F(0) complex subunit C3|ATP synthase subunit 9|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit C3 (subunit 9)|ATP synthase, H+ transporting, mitochondrial Fo complex, subunit C3 (subunit 9)|ATP synthase, mitochondrial, C subunit-3|ATPase protein 9|ATPase subunit C', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=175176258, end_position_on_the_genomic_accession=175181762, orientation='minus', exon_count=4, OMIM=602736, no_hdr0=''),
  521 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=521, CurrentID=0, Status='live', Symbol='ATP5I', Aliases='ATP5K', description='ATP synthase, H+ transporting, mitochondrial Fo complex subunit E', other_designations='ATP synthase e chain, mitochondrial|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit E|ATP synthase, H+ transporting, mitochondrial Fo complex, subunit E|ATPase subunit e|F1F0-ATP synthase, murine e subunit', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=672436, end_position_on_the_genomic_accession=674338, orientation='minus', exon_count=4, OMIM=601519, no_hdr0=''),
  522 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=522, CurrentID=0, Status='live', Symbol='ATP5J', Aliases='ATP5, ATP5A, ATPM, CF6, F6', description='ATP synthase, H+ transporting, mitochondrial Fo complex subunit F6', other_designations='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit F6|ATP synthase, H+ transporting, mitochondrial Fo complex, subunit F6|ATPase subunit F6|coupling factor 6|mitochondrial ATP synthase, coupling factor 6|mitochondrial ATP synthase, subunit F6|mitochondrial ATPase coupling factor 6|proliferation-inducing protein 36', map_location='21q21.1', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=25724480, end_position_on_the_genomic_accession=25735654, orientation='minus', exon_count=6, OMIM=603152, no_hdr0=''),
  197131 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=197131, CurrentID=0, Status='live', Symbol='UBR1', Aliases='JBS', description='ubiquitin protein ligase E3 component n-recognin 1', other_designations='E3a ligase|N-recognin-1|ubiquitin ligase E3 alpha-I|ubiquitin-protein ligase E3-alpha|ubiquitin-protein ligase E3-alpha-1|ubiquitin-protein ligase E3-alpha-I', map_location='15q13', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=42942897, end_position_on_the_genomic_accession=43106088, orientation='minus', exon_count=47, OMIM=605981, no_hdr0=''),
  525 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=525, CurrentID=0, Status='live', Symbol='ATP6V1B1', Aliases='ATP6B1, RTA1B, VATB, VMA2, VPP3', description='ATPase H+ transporting V1 subunit B1', other_designations='H(+)-transporting two-sector ATPase, 58kD subunit|H+-ATPase beta 1 subunit|V-ATPase B1 subunit|V-ATPase subunit B 1|endomembrane proton pump 58 kDa subunit|vacuolar proton pump 3|vacuolar proton pump subunit B 1|vacuolar proton pump, subunit 3', map_location='2p13.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=70935868, end_position_on_the_genomic_accession=70965431, orientation='plus', exon_count=15, OMIM=192132, no_hdr0=''),
  526 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=526, CurrentID=0, Status='live', Symbol='ATP6V1B2', Aliases='ATP6B1B2, ATP6B2, HO57, VATB, VPP3, Vma2', description='ATPase H+ transporting V1 subunit B2', other_designations='ATPase, H+ transporting, lysosomal 56/58kDa, V1 subunit B2|H+ transporting two-sector ATPase|V-ATPase B2 subunit|V-ATPase subunit B 2|endomembrane proton pump 58 kDa subunit|vacuolar H+-ATPase 56,000 subunit|vacuolar proton pump subunit B 2', map_location='8p21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=20197193, end_position_on_the_genomic_accession=20221696, orientation='plus', exon_count=14, OMIM=606939, no_hdr0=''),
  527 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=527, CurrentID=0, Status='live', Symbol='ATP6V0C', Aliases='ATP6C, ATP6L, ATPL, VATL, VPPC, Vma3', description='ATPase H+ transporting V0 subunit c', other_designations='ATPase, H+ transporting, lysosomal 16kDa, V0 subunit c|H(+)-transporting two-sector ATPase, 16 kDa subunit|V-ATPase 16 kDa proteolipid subunit|vacuolar ATP synthase 16 kDa proteolipid subunit|vacuolar H+ ATPase proton channel subunit|vacuolar proton pump 16 kDa proteolipid subunit', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2513726, end_position_on_the_genomic_accession=2520223, orientation='plus', exon_count=4, OMIM=108745, no_hdr0=''),
  528 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=528, CurrentID=0, Status='live', Symbol='ATP6V1C1', Aliases='ATP6C, ATP6D, VATC, Vma5', description='ATPase H+ transporting V1 subunit C1', other_designations='ATPase, H+ transporting, lysosomal 42kDa, V1 subunit C1|H(+)-transporting two-sector ATPase, subunit C|H+ -ATPase C subunit|H+-transporting ATPase chain C, vacuolar|V-ATPase C subunit|V-ATPase subunit C 1|subunit C of vacuolar proton-ATPase V1 domain|vacuolar ATP synthase subunit C|vacuolar proton pump C subunit|vacuolar proton pump subunit C 1|vacuolar proton pump, 42-kD subunit|vacuolar proton-ATPase, subunit C, VI domain', map_location='8q22.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=103021020, end_position_on_the_genomic_accession=103073057, orientation='plus', exon_count=13, OMIM=603097, no_hdr0=''),
  529 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=529, CurrentID=0, Status='live', Symbol='ATP6V1E1', Aliases='ATP6E, ATP6E2, ATP6V1E, P31, Vma4', description='ATPase H+ transporting V1 subunit E1', other_designations='ATPase, H+ transporting, lysosomal 31kDa, V1 subunit E1|H(+)-transporting two-sector ATPase, 31kDa subunit|H+-transporting ATP synthase chain E, vacuolar|V-ATPase 31 kDa subunit|V-ATPase subunit E 1|V-ATPase, subunit E|vacuolar proton pump subunit E 1', map_location='22q11.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=17592136, end_position_on_the_genomic_accession=17628822, orientation='minus', exon_count=9, OMIM=108746, no_hdr0=''),
  533 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=533, CurrentID=0, Status='live', Symbol='ATP6V0B', Aliases='ATP6F, HATPL, VMA16', description='ATPase H+ transporting V0 subunit b', other_designations="ATPase, H+ transporting, lysosomal 21kDa, V0 subunit b|ATPase, H+ transporting, lysosomal, 21-KD, V0 subunit C-prime, prime|ATPase, H+ transporting, lysosomal, subunit F|H(+)-transporting two-sector ATPase, subunit F|V-ATPase 21 kDa proteolipid subunit|V-ATPase subunit c''|vacuolar ATP synthase 21 kDa proteolipid subunit|vacuolar proton pump 21 kDa proteolipid subunit", map_location='1p32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=43974648, end_position_on_the_genomic_accession=43978300, orientation='plus', exon_count=8, OMIM=603717, no_hdr0=''),
  534 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=534, CurrentID=0, Status='live', Symbol='ATP6V1G2', Aliases='ATP6G, ATP6G2, NG38, VMA10', description='ATPase H+ transporting V1 subunit G2', other_designations='ATPase, H+ transporting, lysosomal (vacuolar proton pump)|ATPase, H+ transporting, lysosomal 13kDa, V1 subunit G2|H(+)-transporting two-sector ATPase, subunit G2|V-ATPase 13 kDa subunit 2|vacuolar ATP synthase subunit G 2|vacuolar proton pump G subunit 2', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31544451, end_position_on_the_genomic_accession=31546848, orientation='minus', exon_count=3, OMIM=606853, no_hdr0=''),
  535 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=535, CurrentID=0, Status='live', Symbol='ATP6V0A1', Aliases='ATP6N1, ATP6N1A, Stv1, VPP1, Vph1, a1', description='ATPase H+ transporting V0 subunit a1', other_designations='ATPase, H+ transporting, lysosomal (vacuolar proton pump) non-catalytic accessory protein 1A (110/116kD)|ATPase, H+ transporting, lysosomal V0 subunit a1|ATPase, H+ transporting, lysosomal non-catalytic accessory protein 1 (110/116kD)|H(+)-transporting two-sector ATPase, 116 kDa accessory protein A1|V-ATPase 116 kDa|V-type proton ATPase 116 kDa subunit a|clathrin-coated vesicle/synaptic vesicle proton pump 116 kDa subunit|vacuolar adenosine triphosphatase subunit Ac116|vacuolar proton pump subunit 1|vacuolar proton pump, subunit 1|vacuolar proton translocating ATPase 116 kDa subunit A|vacuolar-type H(+)-ATPase 115 kDa subunit', map_location='17q21', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=42458844, end_position_on_the_genomic_accession=42522579, orientation='plus', exon_count=23, OMIM=192130, no_hdr0=''),
  537 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=537, CurrentID=0, Status='live', Symbol='ATP6AP1', Aliases='16A, ATP6IP1, ATP6S1, Ac45, CF2, VATPS1, XAP-3, XAP3', description='ATPase H+ transporting accessory protein 1', other_designations='ATPase, H+ transporting, lysosomal (vacuolar proton pump), subunit 1|ATPase, H+ transporting, lysosomal accessory protein 1|ATPase, H+ transporting, lysosomal interacting protein 1|H-ATPase subunit|V-ATPase Ac45 subunit|V-ATPase S1 accessory protein|V-ATPase subunit S1|protein XAP-3|vacuolar proton pump subunit S1', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154428632, end_position_on_the_genomic_accession=154436517, orientation='plus', exon_count=11, OMIM=300197, no_hdr0=''),
  538 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=538, CurrentID=0, Status='live', Symbol='ATP7A', Aliases='DSMAX, MK, MNK, SMAX3', description='ATPase copper transporting alpha', other_designations='ATPase, Cu++ transporting, alpha polypeptide|Cu++-transporting P-type ATPase|Menkes disease-associated protein|copper pump 1', map_location='Xq21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=77910656, end_position_on_the_genomic_accession=78050395, orientation='plus', exon_count=23, OMIM=300011, no_hdr0=''),
  539 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=539, CurrentID=0, Status='live', Symbol='ATP5O', Aliases='ATPO, HMC08D05, OSCP', description='ATP synthase, H+ transporting, mitochondrial F1 complex, O subunit', other_designations='human ATP synthase OSCP subunit|oligomycin sensitivity conferral protein oscp-like protein|oligomycin sensitivity conferring protein', map_location='21q22.11', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=33903453, end_position_on_the_genomic_accession=33915854, orientation='minus', exon_count=7, OMIM=600828, no_hdr0=''),
  540 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=540, CurrentID=0, Status='live', Symbol='ATP7B', Aliases='PWD, WC1, WD, WND', description='ATPase copper transporting beta', other_designations='ATPase, Cu(2+)- transporting, beta polypeptide|ATPase, Cu++ transporting, beta polypeptide|Wilson disease-associated protein|copper pump 2', map_location='13q14.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=51891086, end_position_on_the_genomic_accession=52012099, orientation='minus', exon_count=34, OMIM=606882, no_hdr0=''),
  131616 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131616, CurrentID=0, Status='live', Symbol='TMEM42', Aliases='', description='transmembrane protein 42', other_designations='', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=44861723, end_position_on_the_genomic_accession=44865667, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  545 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=545, CurrentID=0, Status='live', Symbol='ATR', Aliases='FCTCS, FRP1, MEC1, SCKL, SCKL1', description='ATR serine/threonine kinase', other_designations='FRAP-related protein-1|MEC1, mitosis entry checkpoint 1, homolog|ataxia telangiectasia and Rad3-related protein', map_location='3q23', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=142449235, end_position_on_the_genomic_accession=142578826, orientation='minus', exon_count=49, OMIM=601215, no_hdr0=''),
  546 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=546, CurrentID=0, Status='live', Symbol='ATRX', Aliases='ATR2, JMS, MRX52, MRXHF1, RAD54, RAD54L, SFM1, SHS, XH2, XNP, ZNF-HX', description='alpha thalassemia/mental retardation syndrome X-linked', other_designations='ATP-dependent helicase ATRX|DNA dependent ATPase and helicase|X-linked helicase II|X-linked nuclear protein|Zinc finger helicase|alpha thalassemia/mental retardation syndrome X-linked (RAD54 homolog, S. cerevisiae)|helicase 2, X-linked|mental retardation, X-linked 52', map_location='Xq21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=77504878, end_position_on_the_genomic_accession=77786269, orientation='minus', exon_count=37, OMIM='300032,300504', no_hdr0=''),
  547 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=547, CurrentID=0, Status='live', Symbol='KIF1A', Aliases='ATSV, C2orf20, HSN2C, MRD9, SPG30, UNC104', description='kinesin family member 1A', other_designations='axonal transporter of synaptic vesicles|kinesin, heavy chain, member 1A, homolog of mouse|microtubule-based motor KIF1A|tmp_locus_27|unc-104- and KIF1A-related protein', map_location='2q37.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=240713764, end_position_on_the_genomic_accession=240821025, orientation='minus', exon_count=54, OMIM=601255, no_hdr0=''),
  549 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=549, CurrentID=0, Status='live', Symbol='AUH', Aliases='', description='AU RNA binding protein/enoyl-CoA hydratase', other_designations='3-methylglutaconyl-CoA hydratase|AU RNA-binding protein/enoyl-Coenzyme A hydratase|AU-binding protein/Enoyl-CoA hydratase|AU-specific RNA-binding enoyl-CoA hydratase', map_location='9q22.31', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=91213815, end_position_on_the_genomic_accession=91361939, orientation='minus', exon_count=18, OMIM=600529, no_hdr0=''),
  550 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=550, CurrentID=0, Status='live', Symbol='AUP1', Aliases='', description='ancient ubiquitous protein 1', other_designations='', map_location='2p13', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=74526648, end_position_on_the_genomic_accession=74529897, orientation='minus', exon_count=12, OMIM=602434, no_hdr0=''),
  551 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=551, CurrentID=0, Status='live', Symbol='AVP', Aliases='ADH, ARVP-NPII, AVRP, VP, AVP', description='arginine vasopressin', other_designations='antidiuretic hormone|copeptin|neurohypophyseal|prepro-AVP-NP II|prepro-arginine-vasopressin-neurophysin II|vasopressin-neurophysin II-copeptin', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=3082555, end_position_on_the_genomic_accession=3093521, orientation='minus', exon_count=4, OMIM=192340, no_hdr0=''),
  552 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=552, CurrentID=0, Status='live', Symbol='AVPR1A', Aliases='AVPR V1a, AVPR1, V1aR', description='arginine vasopressin receptor 1A', other_designations='SCCL vasopressin subtype 1a receptor|V1-vascular vasopressin receptor AVPR1A|V1a vasopressin receptor|antidiuretic hormone receptor 1A|vascular/hepatic-type arginine vasopressin receptor', map_location='12q14.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=63142287, end_position_on_the_genomic_accession=63153860, orientation='minus', exon_count=3, OMIM=600821, no_hdr0=''),
  553 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=553, CurrentID=0, Status='live', Symbol='AVPR1B', Aliases='AVPR3', description='arginine vasopressin receptor 1B', other_designations='AVPR V1b|AVPR V3|V1bR|antidiuretic hormone receptor 1B|arginine vasopressin receptor 3|pituitary vasopressin receptor 3|vasopressin V3 receptor', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=206109849, end_position_on_the_genomic_accession=206117048, orientation='minus', exon_count=2, OMIM=600264, no_hdr0=''),
  554 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=554, CurrentID=0, Status='live', Symbol='AVPR2', Aliases='ADHR, DI1, DIR, DIR3, NDI, V2R', description='arginine vasopressin receptor 2', other_designations='AVPR V2|antidiuretic hormone receptor|renal-type arginine vasopressin receptor', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153902531, end_position_on_the_genomic_accession=153907166, orientation='plus', exon_count=5, OMIM=300538, no_hdr0=''),
  92935 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=92935, CurrentID=0, Status='live', Symbol='MARS2', Aliases='COXPD25, MetRS, mtMetRS', description='methionyl-tRNA synthetase 2, mitochondrial', other_designations='methionine tRNA ligase 2, mitochondrial|methionine--tRNA ligase 2|methionine-tRNA synthetase 2, mitochondrial', map_location='2q33.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=197705304, end_position_on_the_genomic_accession=197708390, orientation='plus', exon_count=1, OMIM=609728, no_hdr0=''),
  730183 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=730183, CurrentID=0, Status='live', Symbol='LOC730183', Aliases='', description='uncharacterized LOC730183', other_designations='', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=30697704, end_position_on_the_genomic_accession=30698489, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  558 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=558, CurrentID=0, Status='live', Symbol='AXL', Aliases='ARK, JTK11, Tyro7, UFO', description='AXL receptor tyrosine kinase', other_designations='AXL oncogene|AXL transforming sequence/gene', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41219199, end_position_on_the_genomic_accession=41261767, orientation='plus', exon_count=21, OMIM=109135, no_hdr0=''),
  163933 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=163933, CurrentID=0, Status='live', Symbol='FAM43B', Aliases='', description='family with sequence similarity 43 member B', other_designations='family with sequence similarity 43, member B', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=20552439, end_position_on_the_genomic_accession=20555020, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  563 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=563, CurrentID=0, Status='live', Symbol='AZGP1', Aliases='ZA2G, ZAG', description='alpha-2-glycoprotein 1, zinc-binding', other_designations='Alpha-2-glycoprotein, zinc|Zn-alpha2-glycoprotein|zn-alpha-2-GP|zn-alpha-2-glycoprotein', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=99966727, end_position_on_the_genomic_accession=99976112, orientation='minus', exon_count=4, OMIM=194460, no_hdr0=''),
  566 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=566, CurrentID=0, Status='live', Symbol='AZU1', Aliases='AZAMP, AZU, CAP37, HBP, HUMAZUR, NAZC, hHBP', description='azurocidin 1', other_designations='cationic antimicrobial protein 37|cationic antimicrobial protein CAP37|heparin-binding protein|neutrophil azurocidin', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=827831, end_position_on_the_genomic_accession=832017, orientation='plus', exon_count=5, OMIM=162815, no_hdr0=''),
  567 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=567, CurrentID=0, Status='live', Symbol='B2M', Aliases='', description='beta-2-microglobulin', other_designations='beta chain of MHC class I molecules|beta-2-microglobin', map_location='15q21.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=44711487, end_position_on_the_genomic_accession=44718159, orientation='plus', exon_count=4, OMIM=109700, no_hdr0=''),
  570 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=570, CurrentID=0, Status='live', Symbol='BAAT', Aliases='BACAT, BAT', description='bile acid-CoA:amino acid N-acyltransferase', other_designations='bile acid CoA: amino acid N-acyltransferase (glycine N-choloyltransferase)|bile acid CoA:amino acid N-acyltransferase|bile acid Coenzyme A: amino acid N-acyltransferase (glycine N-choloyltransferase)|long-chain fatty-acyl-CoA hydrolase', map_location='9q22.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=101360417, end_position_on_the_genomic_accession=101385005, orientation='minus', exon_count=5, OMIM=602938, no_hdr0=''),
  571 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=571, CurrentID=0, Status='live', Symbol='BACH1', Aliases='BACH-1, BTBD24', description='BTB and CNC homology 1, basic leucine zipper transcription factor 1', other_designations='basic region leucine zipper transcriptional regulator BACH1', map_location='21q22.11', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=29298795, end_position_on_the_genomic_accession=29361896, orientation='plus', exon_count=11, OMIM=602751, no_hdr0=''),
  572 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=572, CurrentID=0, Status='live', Symbol='BAD', Aliases='BBC2, BCL2L8', description='BCL2 associated agonist of cell death', other_designations='BCL-X/BCL-2 binding protein|BCL2-antagonist of cell death protein|BCL2-associated agonist of cell death|BCL2-binding component 6|BCL2-binding protein|bcl-2-binding component 6|bcl-2-like protein 8|bcl-XL/Bcl-2-associated death promoter|bcl2 antagonist of cell death|bcl2-L-8', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=64269828, end_position_on_the_genomic_accession=64284704, orientation='minus', exon_count=3, OMIM=603167, no_hdr0=''),
  573 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=573, CurrentID=0, Status='live', Symbol='BAG1', Aliases='BAG-1, HAP, RAP46', description='BCL2 associated athanogene 1', other_designations='BCL2-associated athanogene|Bcl-2 associating athanogene-1 protein|Bcl-2-binding protein|glucocortoid receptor-associated protein RAP46|receptor-associated protein, 46-KD', map_location='9p12', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=33252471, end_position_on_the_genomic_accession=33264761, orientation='minus', exon_count=7, OMIM=601497, no_hdr0=''),
  574 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=574, CurrentID=0, Status='live', Symbol='BAGE', Aliases='BAGE1, CT2.1', description='B melanoma antigen', other_designations='antigen MZ2-BA|cancer/testis antigen 2.1|cancer/testis antigen family 2, member 1', map_location='21p11.1 not on reference assembly', chromosome='21', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=605167, no_hdr0=''),
  575 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=575, CurrentID=0, Status='live', Symbol='ADGRB1', Aliases='BAI1, GDAIF', description='adhesion G protein-coupled receptor B1', other_designations='', map_location='8q24.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=142449888, end_position_on_the_genomic_accession=142545008, orientation='plus', exon_count=31, OMIM=602682, no_hdr0=''),
  576 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=576, CurrentID=0, Status='live', Symbol='ADGRB2', Aliases='BAI2', description='adhesion G protein-coupled receptor B2', other_designations='brain-specific angiogenesis inhibitor 2', map_location='1p35', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=31727105, end_position_on_the_genomic_accession=31764063, orientation='minus', exon_count=33, OMIM=602683, no_hdr0=''),
  577 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=577, CurrentID=0, Status='live', Symbol='ADGRB3', Aliases='BAI3', description='adhesion G protein-coupled receptor B3', other_designations='brain-specific angiogenesis inhibitor 3|dJ91B17.1 (brain-specific angiogenesis inhibitor 3)', map_location='6q12', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=68635282, end_position_on_the_genomic_accession=69389511, orientation='plus', exon_count=35, OMIM=602684, no_hdr0=''),
  578 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=578, CurrentID=0, Status='live', Symbol='BAK1', Aliases='BAK, BAK-LIKE, BCL2L7, CDN1', description='BCL2-antagonist/killer 1', other_designations='BCL2-like 7 protein|apoptosis regulator BAK|bcl-2-like protein 7|bcl2-L-7|pro-apoptotic protein BAK', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=33572546, end_position_on_the_genomic_accession=33580299, orientation='minus', exon_count=7, OMIM=600516, no_hdr0=''),
  579 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=579, CurrentID=0, Status='live', Symbol='NKX3-2', Aliases='BAPX1, NKX3.2, NKX3B, SMMD', description='NK3 homeobox 2', other_designations='bagpipe homeobox protein homolog 1|homeobox protein NK-3 homolog B', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=13540830, end_position_on_the_genomic_accession=13544490, orientation='minus', exon_count=2, OMIM=602183, no_hdr0=''),
  580 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=580, CurrentID=0, Status='live', Symbol='BARD1', Aliases='', description='BRCA1 associated RING domain 1', other_designations='BRCA1-associated RING domain gene 1', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=214725646, end_position_on_the_genomic_accession=214809711, orientation='minus', exon_count=13, OMIM=601593, no_hdr0=''),
  581 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=581, CurrentID=0, Status='live', Symbol='BAX', Aliases='BCL2L4', description='BCL2-associated X protein', other_designations='BCL2-associated X protein omega|Baxdelta2G9|Baxdelta2G9omega|Baxdelta2omega|bcl-2-like protein 4|bcl2-L-4', map_location='19q13.3-q13.4', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48954860, end_position_on_the_genomic_accession=48961798, orientation='plus', exon_count=7, OMIM=600040, no_hdr0=''),
  582 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=582, CurrentID=0, Status='live', Symbol='BBS1', Aliases='BBS2L2', description='Bardet-Biedl syndrome 1', other_designations='BBS2-like protein 2', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=66510648, end_position_on_the_genomic_accession=66533613, orientation='plus', exon_count=17, OMIM=209901, no_hdr0=''),
  583 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=583, CurrentID=0, Status='live', Symbol='BBS2', Aliases='BBS', description='Bardet-Biedl syndrome 2', other_designations='', map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=56470389, end_position_on_the_genomic_accession=56520096, orientation='minus', exon_count=20, OMIM=606151, no_hdr0=''),
  585 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=585, CurrentID=0, Status='live', Symbol='BBS4', Aliases='', description='Bardet-Biedl syndrome 4', other_designations='', map_location='15q22.3-q23', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=72686179, end_position_on_the_genomic_accession=72738476, orientation='plus', exon_count=17, OMIM=600374, no_hdr0=''),
  586 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=586, CurrentID=0, Status='live', Symbol='BCAT1', Aliases='BCATC, BCT1, ECA39, MECA39, PNAS121, PP18', description='branched chain amino-acid transaminase 1, cytosolic', other_designations='branched chain aminotransferase 1, cytosolic|placental protein 18', map_location='12p12.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=24810024, end_position_on_the_genomic_accession=24949459, orientation='minus', exon_count=13, OMIM=113520, no_hdr0=''),
  587 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=587, CurrentID=0, Status='live', Symbol='BCAT2', Aliases='BCAM, BCATM, BCT2, PP18', description='branched chain amino-acid transaminase 2, mitochondrial', other_designations='branched chain aminotransferase 2, mitochondrial|placental protein 18', map_location='19q13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48795062, end_position_on_the_genomic_accession=48811063, orientation='minus', exon_count=12, OMIM=113530, no_hdr0=''),
  590 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=590, CurrentID=0, Status='live', Symbol='BCHE', Aliases='CHE1, CHE2, E1', description='butyrylcholinesterase', other_designations='acylcholine acylhydrolase|butyrylcholine esterase|choline esterase II|cholinesterase (serum) 2|cholinesterase 1|pseudocholinesterase', map_location='3q26.1-q26.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=165772904, end_position_on_the_genomic_accession=165837472, orientation='minus', exon_count=4, OMIM=177400, no_hdr0=''),
  593 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=593, CurrentID=0, Status='live', Symbol='BCKDHA', Aliases='BCKDE1A, MSU, MSUD1, OVD1A', description='branched chain keto acid dehydrogenase E1, alpha polypeptide', other_designations='2-oxoisovalerate dehydrogenase (lipoamide)|BCKDH E1-alpha|branched chain keto acid dehydrogenase E1 alpha protein|branched-chain alpha-keto acid dehydrogenase E1 component alpha chain', map_location='19q13.1-q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41397789, end_position_on_the_genomic_accession=41425005, orientation='plus', exon_count=9, OMIM=608348, no_hdr0=''),
  594 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=594, CurrentID=0, Status='live', Symbol='BCKDHB', Aliases='BCKDE1B, BCKDH E1-beta, E1B', description='branched chain keto acid dehydrogenase E1, beta polypeptide', other_designations='E1b-beta subunit of the branched-chain complex|branched chain alpha-ketoacid dehydrogenase E1-beta subunit|branched-chain alpha-keto acid dehydrogenase E1 component beta chain', map_location='6q14.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=80106627, end_position_on_the_genomic_accession=80346270, orientation='plus', exon_count=16, OMIM=248611, no_hdr0=''),
  595 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=595, CurrentID=0, Status='live', Symbol='CCND1', Aliases='BCL1, D11S287E, PRAD1, U21B31', description='cyclin D1', other_designations='B-cell CLL/lymphoma 1|B-cell lymphoma 1 protein|BCL-1 oncogene|PRAD1 oncogene', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=69641105, end_position_on_the_genomic_accession=69654474, orientation='plus', exon_count=6, OMIM=168461, no_hdr0=''),
  596 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=596, CurrentID=0, Status='live', Symbol='BCL2', Aliases='Bcl-2, PPP1R50', description='B-cell CLL/lymphoma 2', other_designations='protein phosphatase 1, regulatory subunit 50', map_location='18q21.3', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=63123346, end_position_on_the_genomic_accession=63319778, orientation='minus', exon_count=6, OMIM=151430, no_hdr0=''),
  597 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=597, CurrentID=0, Status='live', Symbol='BCL2A1', Aliases='ACC-1, ACC-2, ACC1, ACC2, BCL2L5, BFL1, GRS, HBPA1', description='BCL2 related protein A1', other_designations='BCL2-related protein A1|bcl-2-like protein 5|bcl2-L-5|hematopoietic BCL2-related protein A1|hemopoietic-specific early response protein|protein BFL-1', map_location='15q24.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=79960890, end_position_on_the_genomic_accession=79971301, orientation='minus', exon_count=3, OMIM=601056, no_hdr0=''),
  598 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=598, CurrentID=0, Status='live', Symbol='BCL2L1', Aliases='BCL-XL/S, BCL2L, BCLX, Bcl-X, PPP1R52', description='BCL2 like 1', other_designations='BCL2-like 1|apoptosis regulator Bcl-X|protein phosphatase 1, regulatory subunit 52', map_location='20q11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=31664452, end_position_on_the_genomic_accession=31723964, orientation='minus', exon_count=8, OMIM=600039, no_hdr0=''),
  599 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=599, CurrentID=0, Status='live', Symbol='BCL2L2', Aliases='BCL-W, BCL2-L-2, BCLW, PPP1R51', description='BCL2-like 2', other_designations='apoptosis regulator BCL-W|protein phosphatase 1, regulatory subunit 51', map_location='14q11.2-q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=23306762, end_position_on_the_genomic_accession=23311759, orientation='plus', exon_count=4, OMIM=601931, no_hdr0=''),
  602 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=602, CurrentID=0, Status='live', Symbol='BCL3', Aliases='BCL4, D19S37', description='B-cell CLL/lymphoma 3', other_designations='B-cell leukemia/lymphoma 3|B-cell lymphoma 3-encoded protein|BCL-3|chronic lymphatic leukemia protein|proto-oncogene BCL3', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44748045, end_position_on_the_genomic_accession=44760044, orientation='plus', exon_count=11, OMIM=109560, no_hdr0=''),
  604 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=604, CurrentID=0, Status='live', Symbol='BCL6', Aliases='BCL5A, LAZ3, ZBTB27, ZNF51, BCL6', description='B-cell CLL/lymphoma 6', other_designations='B-cell lymphoma 5 protein|B-cell lymphoma 6 protein transcript|BCL-5|BCL-6|cys-his2 zinc finger transcription factor|lymphoma-associated zinc finger gene on chromosome 3|protein LAZ-3|zinc finger and BTB domain-containing protein 27|zinc finger protein 51|zinc finger transcription factor BCL6S', map_location='3q27', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=187721377, end_position_on_the_genomic_accession=187745725, orientation='minus', exon_count=12, OMIM=109565, no_hdr0=''),
  605 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=605, CurrentID=0, Status='live', Symbol='BCL7A', Aliases='BCL7', description='B-cell CLL/lymphoma 7A', other_designations='B-cell CLL/lymphoma-7', map_location='12q24.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=122021886, end_position_on_the_genomic_accession=122062044, orientation='plus', exon_count=6, OMIM=601406, no_hdr0=''),
  607 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=607, CurrentID=0, Status='live', Symbol='BCL9', Aliases='LGS', description='B-cell CLL/lymphoma 9', other_designations='B-cell lymphoma 9 protein|bcl-9|protein legless homolog', map_location='1q21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=147541401, end_position_on_the_genomic_accession=147626219, orientation='plus', exon_count=12, OMIM=602597, no_hdr0=''),
  608 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=608, CurrentID=0, Status='live', Symbol='TNFRSF17', Aliases='BCM, BCMA, CD269, TNFRSF13A', description='tumor necrosis factor receptor superfamily member 17', other_designations='B cell maturation antigen|B-cell maturation factor|B-cell maturation protein|tumor necrosis factor receptor superfamily, member 17', map_location='16p13.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=11965107, end_position_on_the_genomic_accession=11968068, orientation='plus', exon_count=3, OMIM=109545, no_hdr0=''),
  610 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=610, CurrentID=0, Status='live', Symbol='HCN2', Aliases='BCNG-2, BCNG2, HAC-1', description='hyperpolarization activated cyclic nucleotide gated potassium channel 2', other_designations='brain cyclic nucleotide gated channel 2|brain cyclic nucleotide-gated channel 2|hyperpolarization activated cyclic nucleotide-gated potassium channel 2', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=589893, end_position_on_the_genomic_accession=617159, orientation='plus', exon_count=8, OMIM=602781, no_hdr0=''),
  611 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=611, CurrentID=0, Status='live', Symbol='OPN1SW', Aliases='BCP, BOP, CBT', description='opsin 1 (cone pigments), short-wave-sensitive', other_designations='blue cone photoreceptor pigment|blue-sensitive opsin', map_location='7q32.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=128772489, end_position_on_the_genomic_accession=128775790, orientation='minus', exon_count=5, OMIM=613522, no_hdr0=''),
  613 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=613, CurrentID=0, Status='live', Symbol='BCR', Aliases='ALL1, CML, D22S11, D22S662, PHL, BCR', description='breakpoint cluster region', other_designations='BCR/FGFR1 chimera protein|FGFR1/BCR chimera protein|renal carcinoma antigen NY-REN-26', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=23180365, end_position_on_the_genomic_accession=23318037, orientation='plus', exon_count=23, OMIM=151410, no_hdr0=''),
  728224 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=728224, CurrentID=0, Status='live', Symbol='KRTAP4-8', Aliases='KAP4.8, KRTAP4.8', description='keratin associated protein 4-8', other_designations='keratin associated protein 4.8|keratin-associated protein 4.8|ultrahigh sulfur keratin-associated protein 4.8', map_location='17q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=41096981, end_position_on_the_genomic_accession=41098123, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  617 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=617, CurrentID=0, Status='live', Symbol='BCS1L', Aliases='BCS, BCS1, BJS, FLNMS, GRACILE, Hs.6719, MC3DN1, PTD, h-BCS', description='BCS1 homolog, ubiquinol-cytochrome c reductase complex chaperone', other_designations='BC1 (ubiquinol-cytochrome c reductase) synthesis-like|BCS1-like protein|h-BCS1|mitochondrial complex III assembly', map_location='2q33', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=218659656, end_position_on_the_genomic_accession=218663443, orientation='plus', exon_count=10, OMIM=603647, no_hdr0=''),
  344167 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=344167, CurrentID=0, Status='live', Symbol='FOXI3', Aliases='', description='forkhead box I3', other_designations='', map_location='2p11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=88448207, end_position_on_the_genomic_accession=88452535, orientation='minus', exon_count=2, OMIM=612351, no_hdr0=''),
  222611 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=222611, CurrentID=0, Status='live', Symbol='ADGRF2', Aliases='GPR111, PGR20, hGPCR35', description='adhesion G protein-coupled receptor F2', other_designations='G protein-coupled receptor 111|probable G-protein coupled receptor 111', map_location='6p12.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=47656590, end_position_on_the_genomic_accession=47697797, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  622 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=622, CurrentID=0, Status='live', Symbol='BDH1', Aliases='BDH, SDR9C1', description='3-hydroxybutyrate dehydrogenase, type 1', other_designations='(R)-3-hydroxybutyrate dehydrogenase|3-hydroxybutyrate dehydrogenase (heart, mitochondrial)|short chain dehydrogenase/reductase family 9C member 1|short chain dehydrogenase/reductase family 9C, member 1', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=197509783, end_position_on_the_genomic_accession=197573323, orientation='minus', exon_count=13, OMIM=603063, no_hdr0=''),
  623 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=623, CurrentID=0, Status='live', Symbol='BDKRB1', Aliases='B1BKR, B1R, BDKRB2, BKB1R, BKR1, BRADYB1', description='bradykinin receptor B1', other_designations='BK-1 receptor|bradykinin B1 receptor|bradykinin receptor 1|bradykinin receptor B2', map_location='14q32.1-q32.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=96256210, end_position_on_the_genomic_accession=96264763, orientation='plus', exon_count=3, OMIM=600337, no_hdr0=''),
  624 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=624, CurrentID=0, Status='live', Symbol='BDKRB2', Aliases='B2R, BK-2, BK2, BKR2, BRB2', description='bradykinin receptor B2', other_designations='BK-2 receptor', map_location='14q32.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=96204798, end_position_on_the_genomic_accession=96244329, orientation='plus', exon_count=3, OMIM=113503, no_hdr0=''),
  627 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=627, CurrentID=0, Status='live', Symbol='BDNF', Aliases='ANON2, BULN2', description='brain-derived neurotrophic factor', other_designations='abrineurin|neurotrophin', map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=27654893, end_position_on_the_genomic_accession=27722058, orientation='minus', exon_count=12, OMIM=113505, no_hdr0=''),
  629 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=629, CurrentID=0, Status='live', Symbol='CFB', Aliases='AHUS4, ARMD14, BF, BFD, CFABD, FB, FBI12, GBG, H2-Bf, PBF2, CFB', description='complement factor B', other_designations='B-factor, properdin|C3 proaccelerator|C3 proactivator|C3/C5 convertase|glycine-rich beta glycoprotein|glycine-rich beta-glycoprotein|properdin factor B', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31945944, end_position_on_the_genomic_accession=31952084, orientation='plus', exon_count=18, OMIM=138470, no_hdr0=''),
  631 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=631, CurrentID=0, Status='live', Symbol='BFSP1', Aliases='CP115, CP94, CTRCT33, LIFL-H', description='beaded filament structural protein 1', other_designations='beaded filament structural protein 1, filensin|cytoskeletal protein, 115 KD|lens fiber cell beaded-filament structural protein CP 115|lens intermediate filament-like heavy', map_location='20p12.1', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=17493905, end_position_on_the_genomic_accession=17569220, orientation='minus', exon_count=14, OMIM=603307, no_hdr0=''),
  632 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=632, CurrentID=0, Status='live', Symbol='BGLAP', Aliases='BGP, OC, OCN', description='bone gamma-carboxyglutamate (gla) protein', other_designations='bone gamma-carboxyglutamate (gla) protein (osteocalcin)|gamma-carboxyglutamic acid-containing protein', map_location='1q22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=156242160, end_position_on_the_genomic_accession=156243332, orientation='plus', exon_count=4, OMIM=112260, no_hdr0=''),
  633 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=633, CurrentID=0, Status='live', Symbol='BGN', Aliases='DSPG1, PG-S1, PGI, SLRR1A', description='biglycan', other_designations='bone/cartilage proteoglycan-I|dermatan sulphate proteoglycan I|small leucine-rich protein 1A', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153494889, end_position_on_the_genomic_accession=153509546, orientation='plus', exon_count=8, OMIM=301870, no_hdr0=''),
  634 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=634, CurrentID=0, Status='live', Symbol='CEACAM1', Aliases='BGP, BGP1, BGPI', description='carcinoembryonic antigen related cell adhesion molecule 1', other_designations='CD66a antigen|antigen CD66|carcinoembryonic antigen-related cell adhesion molecule 1 (biliary glycoprotein)', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=42507306, end_position_on_the_genomic_accession=42528509, orientation='minus', exon_count=10, OMIM=109770, no_hdr0=''),
  635 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=635, CurrentID=0, Status='live', Symbol='BHMT', Aliases='BHMT1, HEL-S-61p', description='betaine--homocysteine S-methyltransferase', other_designations='epididymis secretory sperm binding protein Li 61p', map_location='5q14.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=79111781, end_position_on_the_genomic_accession=79132290, orientation='plus', exon_count=8, OMIM=602888, no_hdr0=''),
  636 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=636, CurrentID=0, Status='live', Symbol='BICD1', Aliases='BICD', description='bicaudal D homolog 1 (Drosophila)', other_designations='bic-D 1|cytoskeleton-like bicaudal D protein homolog 1', map_location='12p11.2-p11.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=32106736, end_position_on_the_genomic_accession=32383650, orientation='plus', exon_count=12, OMIM=602204, no_hdr0=''),
  637 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=637, CurrentID=0, Status='live', Symbol='BID', Aliases='FP497', description='BH3 interacting domain death agonist', other_designations='BID isoform ES(1b)|BID isoform L(2)|BID isoform Si6|Human BID coding sequence|apoptic death agonist|desmocollin type 4|p22 BID', map_location='22q11.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=17734140, end_position_on_the_genomic_accession=17774665, orientation='minus', exon_count=8, OMIM=601997, no_hdr0=''),
  638 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=638, CurrentID=0, Status='live', Symbol='BIK', Aliases='BIP1, BP4, NBK', description='BCL2-interacting killer', other_designations='BCL2-interacting killer (apoptosis-inducing)|apoptosis inducer NBK|apoptosis-inducing NBK|natural born killer', map_location='22q13.31', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=43110748, end_position_on_the_genomic_accession=43129712, orientation='plus', exon_count=5, OMIM=603392, no_hdr0=''),
  639 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=639, CurrentID=0, Status='live', Symbol='PRDM1', Aliases='BLIMP1, PRDI-BF1', description='PR domain 1', other_designations='B-lymphocyte-induced maturation protein 1|BLIMP-1|PR domain containing 1, with ZNF domain|PRDI-binding factor-1|beta-interferon gene positive-regulatory domain I binding factor', map_location='6q21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=106086320, end_position_on_the_genomic_accession=106109939, orientation='plus', exon_count=10, OMIM=603423, no_hdr0=''),
  640 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=640, CurrentID=0, Status='live', Symbol='BLK', Aliases='MODY11', description='BLK proto-oncogene, Src family tyrosine kinase', other_designations='B lymphoid tyrosine kinase|BLK nonreceptor tyrosine kinase|b lymphocyte kinase|p55-Blk', map_location='8p23-p22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=11493991, end_position_on_the_genomic_accession=11564599, orientation='plus', exon_count=16, OMIM=191305, no_hdr0=''),
  641 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=641, CurrentID=0, Status='live', Symbol='BLM', Aliases='BS, RECQ2, RECQL2, RECQL3', description='Bloom syndrome RecQ like helicase', other_designations='Bloom syndrome, RecQ helicase-like|DNA helicase, RecQ-like type 2|recQ protein-like 3', map_location='15q26.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=90717327, end_position_on_the_genomic_accession=90815462, orientation='plus', exon_count=25, OMIM=604610, no_hdr0=''),
  642 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=642, CurrentID=0, Status='live', Symbol='BLMH', Aliases='BH, BMH', description='bleomycin hydrolase', other_designations='BLM hydrolase', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=30248195, end_position_on_the_genomic_accession=30292166, orientation='minus', exon_count=12, OMIM=602403, no_hdr0=''),
  643 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=643, CurrentID=0, Status='live', Symbol='CXCR5', Aliases='BLR1, CD185, MDR15', description='chemokine (C-X-C motif) receptor 5', other_designations='Burkitt lymphoma receptor 1, GTP binding protein (chemokine (C-X-C motif) receptor 5)|Burkitt lymphoma receptor 1, GTP-binding protein|CXC-R5|CXCR-5|MDR-15|monocyte-derived receptor 15', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118883766, end_position_on_the_genomic_accession=118896271, orientation='plus', exon_count=2, OMIM=601613, no_hdr0=''),
  644 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=644, CurrentID=0, Status='live', Symbol='BLVRA', Aliases='BLVR, BVR, BVRA', description='biliverdin reductase A', other_designations='BVR A|biliverdin-IX alpha-reductase', map_location='7p13', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=43758192, end_position_on_the_genomic_accession=43807342, orientation='plus', exon_count=10, OMIM=109750, no_hdr0=''),
  645 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=645, CurrentID=0, Status='live', Symbol='BLVRB', Aliases='BVRB, FLR, HEL-S-10, SDR43U1', description='biliverdin reductase B', other_designations='BVR-B|FR|GHBP|NADPH-dependent diaphorase|NADPH-flavin reductase|biliverdin reductase B (flavin reductase (NADPH))|biliverdin-IX beta-reductase|epididymis secretory protein Li 10|green heme-binding protein|short chain dehydrogenase/reductase family 43U, member 1', map_location='19q13.1-q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40447784, end_position_on_the_genomic_accession=40465818, orientation='minus', exon_count=5, OMIM=600941, no_hdr0=''),
  646 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=646, CurrentID=0, Status='live', Symbol='BNC1', Aliases='BNC, BSN1, HsT19447', description='basonuclin 1', other_designations='', map_location='15q25.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=83255884, end_position_on_the_genomic_accession=83284716, orientation='minus', exon_count=7, OMIM=601930, no_hdr0=''),
  648 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=648, CurrentID=0, Status='live', Symbol='BMI1', Aliases='FLVI2/BMI1, PCGF4, RNF51, flvi-2/bmi-1', description='BMI1 proto-oncogene, polycomb ring finger', other_designations='B lymphoma Mo-MLV insertion region 1 homolog|BMI1 polycomb ring finger oncogene|BMI1 polycomb ring finger proto-oncogene|murine leukemia viral (bmi-1) oncogene homolog|polycomb group RING finger protein 4|polycomb group protein Bmi1|ring finger protein 51', map_location='10p11.23', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=22321210, end_position_on_the_genomic_accession=22331485, orientation='plus', exon_count=10, OMIM=164831, no_hdr0=''),
  649 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=649, CurrentID=0, Status='live', Symbol='BMP1', Aliases='OI13, PCOLC, PCP, PCP2, TLD', description='bone morphogenetic protein 1', other_designations='mammalian tolloid protein|procollagen C-endopeptidase|procollagen C-proteinase 3', map_location='8p21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=22165140, end_position_on_the_genomic_accession=22212326, orientation='plus', exon_count=25, OMIM=112264, no_hdr0=''),
  650 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=650, CurrentID=0, Status='live', Symbol='BMP2', Aliases='BDA2A, BMP2', description='bone morphogenetic protein 2', other_designations='bone morphogenetic protein 2A', map_location='20p12', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=6767694, end_position_on_the_genomic_accession=6780263, orientation='plus', exon_count=3, OMIM=112261, no_hdr0=''),
  651 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=651, CurrentID=0, Status='live', Symbol='BMP3', Aliases='BMP-3A', description='bone morphogenetic protein 3', other_designations='BMP-3|bone morphogenetic protein 3 (osteogenic)|bone morphogenetic protein 3A|bone morphogenetic protein-3|osteogenin', map_location='4q21', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=81030622, end_position_on_the_genomic_accession=81057531, orientation='plus', exon_count=3, OMIM=112263, no_hdr0=''),
  652 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=652, CurrentID=0, Status='live', Symbol='BMP4', Aliases='BMP2B, BMP2B1, MCOPS6, OFC11, ZYME', description='bone morphogenetic protein 4', other_designations='bone morphogenetic protein 2B', map_location='14q22-q23', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=53949736, end_position_on_the_genomic_accession=53956836, orientation='minus', exon_count=6, OMIM=112262, no_hdr0=''),
  653 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=653, CurrentID=0, Status='live', Symbol='BMP5', Aliases='', description='bone morphogenetic protein 5', other_designations='BMP-5|bone morphogenenic protein-5', map_location='6p12.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=55753653, end_position_on_the_genomic_accession=55875593, orientation='minus', exon_count=8, OMIM=112265, no_hdr0=''),
  654 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=654, CurrentID=0, Status='live', Symbol='BMP6', Aliases='VGR, VGR1', description='bone morphogenetic protein 6', other_designations='BMP-6|VG-1-R|VG-1-related protein|VGR-1|Vg1-related sequence|vegetal related growth factor (TGFB-related)|vegetal-related (TGFB related) cytokine', map_location='6p24-p23', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=7726778, end_position_on_the_genomic_accession=7881728, orientation='plus', exon_count=7, OMIM=112266, no_hdr0=''),
  655 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=655, CurrentID=0, Status='live', Symbol='BMP7', Aliases='OP-1', description='bone morphogenetic protein 7', other_designations='osteogenic protein 1', map_location='20q13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=57168753, end_position_on_the_genomic_accession=57266651, orientation='minus', exon_count=7, OMIM=112267, no_hdr0=''),
  656 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=656, CurrentID=0, Status='live', Symbol='BMP8B', Aliases='BMP8, OP2', description='bone morphogenetic protein 8b', other_designations='BMP-8|BMP-8B|bone morphogenetic protein 8 (osteogenic protein 2)|dJ118J21.1 (bone morphogenetic protein 8 (osteogenic protein 2))|osteogenic protein 2', map_location='1p35-p32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=39757182, end_position_on_the_genomic_accession=39788861, orientation='minus', exon_count=12, OMIM=602284, no_hdr0=''),
  657 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=657, CurrentID=0, Status='live', Symbol='BMPR1A', Aliases='10q23del, ACVRLK3, ALK3, CD292, SKR5', description='bone morphogenetic protein receptor type 1A', other_designations='ALK-3|BMP type-1A receptor|BMPR-1A|activin A receptor, type II-like kinase 3|activin receptor-like kinase 3|bone morphogenetic protein receptor type IA|bone morphogenetic protein receptor, type IA|serine/threonine-protein kinase receptor R5', map_location='10q22.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=86755786, end_position_on_the_genomic_accession=86925188, orientation='plus', exon_count=15, OMIM=601299, no_hdr0=''),
  658 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=658, CurrentID=0, Status='live', Symbol='BMPR1B', Aliases='ALK-6, ALK6, AMDD, CDw293', description='bone morphogenetic protein receptor type 1B', other_designations='BMP type-1B receptor|BMPR-1B|activin receptor-like kinase 6|bone morphogenetic protein receptor type IB|bone morphogenetic protein receptor, type IB|serine/threonine receptor kinase', map_location='4q22-q24', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=94757977, end_position_on_the_genomic_accession=95158450, orientation='plus', exon_count=17, OMIM=603248, no_hdr0=''),
  659 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=659, CurrentID=0, Status='live', Symbol='BMPR2', Aliases='BMPR-II, BMPR3, BMR2, BRK-3, POVD1, PPH1, T-ALK', description='bone morphogenetic protein receptor type II', other_designations='BMP type II receptor|BMP type-2 receptor|BMPR-2|bone morphogenetic protein receptor, type II (serine/threonine kinase)|type II activin receptor-like kinase|type II receptor for bone morphogenetic protein-4', map_location='2q33-q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=202376310, end_position_on_the_genomic_accession=202567751, orientation='plus', exon_count=13, OMIM=600799, no_hdr0=''),
  660 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=660, CurrentID=0, Status='live', Symbol='BMX', Aliases='ETK, PSCTK2, PSCTK3', description='BMX non-receptor tyrosine kinase', other_designations='BTK-like on X chromosome|Etk/Bmx cytosolic tyrosine kinase|NTK38 tyrosine kinase|bone marrow tyrosine kinase gene in chromosome X protein|epithelial and endothelial tyrosine kinase', map_location='Xp22.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=15500777, end_position_on_the_genomic_accession=15556529, orientation='plus', exon_count=20, OMIM=300101, no_hdr0=''),
  661 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=661, CurrentID=0, Status='live', Symbol='POLR3D', Aliases='BN51T, RPC4, RPC53, TSBN51', description='polymerase (RNA) III (DNA directed) polypeptide D, 44kDa', other_designations='BN51 (BHK21) temperature sensitivity complementing|DNA-directed RNA polymerase III 47 kDa polypeptide|DNA-directed RNA polymerase III subunit D|RNA polymerase III 47 kDa subunit|RNA polymerase III subunit C4|RPC53 homolog|temperature sensitive complementation, cell cycle specific, tsBN51', map_location='8q21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=22245104, end_position_on_the_genomic_accession=22254355, orientation='plus', exon_count=9, OMIM=187280, no_hdr0=''),
  662 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=662, CurrentID=0, Status='live', Symbol='BNIP1', Aliases='NIP1, SEC20, TRG-8', description='BCL2/adenovirus E1B 19kDa interacting protein 1', other_designations='BCL2/adenovirus E1B 19 kDa protein-interacting protein 1|transformation-related gene 8 protein', map_location='5q33-q34', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=173144442, end_position_on_the_genomic_accession=173164387, orientation='plus', exon_count=9, OMIM=603291, no_hdr0=''),
  663 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=663, CurrentID=0, Status='live', Symbol='BNIP2', Aliases='BNIP-2, NIP2', description='BCL2/adenovirus E1B 19kDa interacting protein 2', other_designations='', map_location='15q22.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=59659146, end_position_on_the_genomic_accession=59689529, orientation='minus', exon_count=12, OMIM=603292, no_hdr0=''),
  664 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=664, CurrentID=0, Status='live', Symbol='BNIP3', Aliases='NIP3', description='BCL2/adenovirus E1B 19kDa interacting protein 3', other_designations='', map_location='10q26.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=131967683, end_position_on_the_genomic_accession=131982013, orientation='minus', exon_count=6, OMIM=603293, no_hdr0=''),
  665 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=665, CurrentID=0, Status='live', Symbol='BNIP3L', Aliases='BNIP3a, NIX', description='BCL2/adenovirus E1B 19kDa interacting protein 3-like', other_designations='BCL2/adenovirus E1B 19 kDa protein-interacting protein 3A|BCL2/adenovirus E1B 19-kd protein-interacting protein 3a|NIP3-like protein X|NIP3L|adenovirus E1B19k-binding protein B5', map_location='8p21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=26383007, end_position_on_the_genomic_accession=26413129, orientation='plus', exon_count=8, OMIM=605368, no_hdr0=''),
  666 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=666, CurrentID=0, Status='live', Symbol='BOK', Aliases='BCL2L9L, BOK', description='BCL2-related ovarian killer', other_designations='bcl-2-like protein 9|bcl2-L-9|hBOK', map_location='2q37.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=241558064, end_position_on_the_genomic_accession=241574138, orientation='plus', exon_count=8, OMIM=605404, no_hdr0=''),
  667 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=667, CurrentID=0, Status='live', Symbol='DST', Aliases='BP240, BPA, BPAG1, CATX-15, CATX15, D6S1101, DMH, DT, EBSB2, HSAN6, MACF2', description='dystonin', other_designations='bullous pemphigoid antigen 1|dystonia musculorum protein|hemidesmosomal plaque protein|trabeculin-beta', map_location='6p12.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=56457987, end_position_on_the_genomic_accession=56954628, orientation='minus', exon_count=111, OMIM=113810, no_hdr0=''),
  668 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=668, CurrentID=0, Status='live', Symbol='FOXL2', Aliases='BPES, BPES1, PFRK, PINTO, POF3', description='forkhead box L2', other_designations='forkhead transcription factor FOXL2', map_location='3q23', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=138944224, end_position_on_the_genomic_accession=138947140, orientation='minus', exon_count=1, OMIM=605597, no_hdr0=''),
  669 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=669, CurrentID=0, Status='live', Symbol='BPGM', Aliases='DPGM', description='bisphosphoglycerate mutase', other_designations='2,3-bisphosphoglycerate mutase|2,3-bisphosphoglycerate mutase, erythrocyte|2,3-bisphosphoglycerate synthase|2,3-diphosphoglycerate mutase|BPG-dependent PGAM|erythrocyte 2,3-bisphosphoglycerate mutase', map_location='7q33', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=134646779, end_position_on_the_genomic_accession=134679816, orientation='plus', exon_count=6, OMIM=613896, no_hdr0=''),
  670 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=670, CurrentID=0, Status='live', Symbol='BPHL', Aliases='BPH-RP, MCNAA, VACVASE', description='biphenyl hydrolase-like (serine hydrolase)', other_designations='biphenyl hydrolase-related protein|breast epithelial mucin-associated antigen|valacyclovirase', map_location='6p25', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=3118376, end_position_on_the_genomic_accession=3153198, orientation='plus', exon_count=9, OMIM=603156, no_hdr0=''),
  671 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=671, CurrentID=0, Status='live', Symbol='BPI', Aliases='BPIFD1, rBPI', description='bactericidal/permeability-increasing protein', other_designations='BPI fold containing family D, member 1|CAP 57|recombinant BPI holoprotein, rBPI', map_location='20q11.23', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=38304150, end_position_on_the_genomic_accession=38337505, orientation='plus', exon_count=16, OMIM=109195, no_hdr0=''),
  672 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=672, CurrentID=0, Status='live', Symbol='BRCA1', Aliases='BRCAI, BRCC1, BROVCA1, FANCS, IRIS, PNCA4, PPP1R53, PSCP, RNF53', description='breast cancer 1', other_designations='BRCA1/BRCA2-containing complex, subunit 1|Fanconi anemia, complementation group S|RING finger protein 53|breast and ovarian cancer susceptibility protein 1|breast and ovarian cancer sususceptibility protein 1|breast cancer 1, early onset|early onset breast cancer 1|protein phosphatase 1, regulatory subunit 53|truncated BRCA1|truncated breast and ovarian cancer susceptibility protein 1|truncated breast and ovarian cancer sususceptibility protein 1|truncated breast cancer type 1 susceptibility protein', map_location='17q21', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43044295, end_position_on_the_genomic_accession=43125483, orientation='minus', exon_count=24, OMIM=113705, no_hdr0=''),
  673 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=673, CurrentID=0, Status='live', Symbol='BRAF', Aliases='B-RAF11, NS7, RAFB1, BRAF', description='B-Raf proto-oncogene, serine/threonine kinase', other_designations='94 kDa B-raf protein|B-Raf proto-oncogene serine/threonine-protein kinase (p94)|murine sarcoma viral (v-raf) oncogene homolog B1|proto-oncogene B-Raf|v-raf murine sarcoma viral oncogene homolog B|v-raf murine sarcoma viral oncogene homolog B1', map_location='7q34', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=140715951, end_position_on_the_genomic_accession=140924764, orientation='minus', exon_count=22, OMIM=164757, no_hdr0=''),
  675 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=675, CurrentID=0, Status='live', Symbol='BRCA2', Aliases='BRCC2, BROVCA2, FACD, FAD, FAD1, FANCD, FANCD1, GLM3, PNCA2, XRCC11', description='breast cancer 2', other_designations='BRCA1/BRCA2-containing complex, subunit 2|Fanconi anemia group D1 protein|breast and ovarian cancer susceptibility gene, early onset|breast and ovarian cancer susceptibility protein 2|breast cancer 2 tumor suppressor|breast cancer 2, early onset|mutant BRCA2', map_location='13q12.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=32314862, end_position_on_the_genomic_accession=32399850, orientation='plus', exon_count=28, OMIM=600185, no_hdr0=''),
  676 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=676, CurrentID=0, Status='live', Symbol='BRDT', Aliases='BRD6, CT9', description='bromodomain, testis-specific', other_designations='RING3-like protein|cancer/testis antigen 9', map_location='1p22.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=91949371, end_position_on_the_genomic_accession=92014428, orientation='plus', exon_count=22, OMIM=602144, no_hdr0=''),
  677 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=677, CurrentID=0, Status='live', Symbol='ZFP36L1', Aliases='BRF1, Berg36, ERF-1, ERF1, RNF162B, TIS11B, cMG1', description='ZFP36 ring finger protein-like 1', other_designations='EGF-response factor 1|butyrate response factor 1|early response factor Berg36|zinc finger protein 36, C3H type-like 1|zinc finger protein, C3H type, 36-like 1', map_location='14q24.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=68787655, end_position_on_the_genomic_accession=68796243, orientation='minus', exon_count=4, OMIM=601064, no_hdr0=''),
  678 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=678, CurrentID=0, Status='live', Symbol='ZFP36L2', Aliases='BRF2, ERF-2, ERF2, RNF162C, TIS11D', description='ZFP36 ring finger protein-like 2', other_designations='EGF-response factor 2|ZFP36-like 2|butyrate response factor 2|zinc finger protein 36, C3H type-like 1|zinc finger protein 36, C3H type-like 2|zinc finger protein, C3H type, 36-like 2', map_location='2p22.3-p21', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=43222402, end_position_on_the_genomic_accession=43226606, orientation='minus', exon_count=2, OMIM=612053, no_hdr0=''),
  680 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=680, CurrentID=0, Status='live', Symbol='BRS3', Aliases='BB3', description='bombesin like receptor 3', other_designations='BRS-3|G-protein coupled receptor|bombesin receptor subtype 3|bombesin-like receptor 3', map_location='Xq26.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=136463815, end_position_on_the_genomic_accession=136493774, orientation='plus', exon_count=5, OMIM=300107, no_hdr0=''),
  682 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=682, CurrentID=0, Status='live', Symbol='BSG', Aliases='5F7, CD147, EMMPRIN, M6, OK, TCSF', description='basigin (Ok blood group)', other_designations='CD147 antigen|OK blood group antigen|collagenase stimulatory factor|extracellular matrix metalloproteinase inducer|leukocyte activation antigen M6|tumor cell-derived collagenase stimulatory factor', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=571277, end_position_on_the_genomic_accession=583493, orientation='plus', exon_count=10, OMIM=109480, no_hdr0=''),
  683 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=683, CurrentID=0, Status='live', Symbol='BST1', Aliases='CD157', description='bone marrow stromal cell antigen 1', other_designations='ADP-ribosyl cyclase 2|BST-1|NAD(+) nucleosidase|bone marrow stromal antigen 1|cADPr hydrolase 2|cyclic ADP-ribose hydrolase 2', map_location='4p15', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=15702950, end_position_on_the_genomic_accession=15774190, orientation='plus', exon_count=15, OMIM=600387, no_hdr0=''),
  684 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=684, CurrentID=0, Status='live', Symbol='BST2', Aliases='CD317, TETHERIN', description='bone marrow stromal cell antigen 2', other_designations='BST-2|HM1.24 antigen|NPC-A-7', map_location='19p13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=17402939, end_position_on_the_genomic_accession=17405648, orientation='minus', exon_count=5, OMIM=600534, no_hdr0=''),
  685 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=685, CurrentID=0, Status='live', Symbol='BTC', Aliases='', description='betacellulin', other_designations='', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=74744759, end_position_on_the_genomic_accession=74794672, orientation='minus', exon_count=7, OMIM=600345, no_hdr0=''),
  686 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=686, CurrentID=0, Status='live', Symbol='BTD', Aliases='', description='biotinidase', other_designations='biotinase', map_location='3p25', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=15601352, end_position_on_the_genomic_accession=15647642, orientation='plus', exon_count=9, OMIM=609019, no_hdr0=''),
  687 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=687, CurrentID=0, Status='live', Symbol='KLF9', Aliases='BTEB, BTEB1', description='Kruppel-like factor 9', other_designations='BTE-binding protein 1|GC-box-binding protein 1|basic transcription element binding protein 1|basic transcription element-binding protein 1|transcription factor BTEB1', map_location='9q13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=70384597, end_position_on_the_genomic_accession=70414657, orientation='minus', exon_count=2, OMIM=602902, no_hdr0=''),
  688 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=688, CurrentID=0, Status='live', Symbol='KLF5', Aliases='BTEB2, CKLF, IKLF', description='Kruppel-like factor 5 (intestinal)', other_designations='BTE-binding protein 2|GC box binding protein 2|Klf5C isoform|basic transcription element binding protein 2|colon krueppel-like factor|colon kruppel-like factor|intestinal-enriched krueppel-like factor|intestinal-enriched kruppel-like factor|transcription factor BTEB2', map_location='13q22.1', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=73054976, end_position_on_the_genomic_accession=73077542, orientation='plus', exon_count=5, OMIM=602903, no_hdr0=''),
  689 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=689, CurrentID=0, Status='live', Symbol='BTF3', Aliases='BETA-NACa, BTF3b, NACB, BTF3', description='basic transcription factor 3', other_designations='NAC-beta|RNA polymerase B transcription factor 3|nascent polypeptide-associated complex subunit beta|nascent-polypeptide-associated complex beta polypeptide', map_location='5q13.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=73498425, end_position_on_the_genomic_accession=73505623, orientation='plus', exon_count=6, OMIM=602542, no_hdr0=''),
  694 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=694, CurrentID=0, Status='live', Symbol='BTG1', Aliases='', description='B-cell translocation gene 1, anti-proliferative', other_designations='B-cell translocation gene 1 protein', map_location='12q22', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=92140278, end_position_on_the_genomic_accession=92145897, orientation='minus', exon_count=2, OMIM=109580, no_hdr0=''),
  695 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=695, CurrentID=0, Status='live', Symbol='BTK', Aliases='AGMX1, AT, ATK, BPK, IMD1, PSCTK1, XLA', description='Bruton tyrosine kinase', other_designations="B-cell progenitor kinase|Bruton agammaglobulinemia tyrosine kinase|Bruton's tyrosine kinase|agammaglobulinaemia tyrosine kinase|dominant-negative kinase-deficient Brutons tyrosine kinase|truncated Bruton agammaglobulinemia tyrosine kinase|tyrosine-protein kinase BTK isoform (lacking exon 13 to 17)|tyrosine-protein kinase BTK isoform (lacking exon 14)", map_location='Xq21.33-q22', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=101349447, end_position_on_the_genomic_accession=101390796, orientation='minus', exon_count=21, OMIM=300300, no_hdr0=''),
  696 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=696, CurrentID=0, Status='live', Symbol='BTN1A1', Aliases='BT, BTN, BTN1', description='butyrophilin subfamily 1 member A1', other_designations='bK14H9.2 (butyrophilin, subfamily 1, member A1)|butyrophilin, subfamily 1, member A1', map_location='6p22.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=26499306, end_position_on_the_genomic_accession=26510425, orientation='plus', exon_count=8, OMIM=601610, no_hdr0=''),
  699 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=699, CurrentID=0, Status='live', Symbol='BUB1', Aliases='BUB1AL, hBUB1, BUB1', description='BUB1 mitotic checkpoint serine/threonine kinase', other_designations='BUB1 budding uninhibited by benzimidazoles 1 homolog|BUB1, mitotic checkpoint serine/threonine kinase|budding uninhibited by benzimidazoles 1 homolog|mitotic spindle checkpoint kinase|putative serine/threonine-protein kinase', map_location='2q14', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=110637527, end_position_on_the_genomic_accession=110678107, orientation='minus', exon_count=25, OMIM=602452, no_hdr0=''),
  701 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=701, CurrentID=0, Status='live', Symbol='BUB1B', Aliases='BUB1beta, BUBR1, Bub1A, MAD3L, MVA1, SSK1, hBUBR1', description='BUB1 mitotic checkpoint serine/threonine kinase B', other_designations='BUB1B, mitotic checkpoint serine/threonine kinase|MAD3/BUB1-related protein kinase|budding uninhibited by benzimidazoles 1 homolog beta|mitotic checkpoint kinase MAD3L', map_location='15q15', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=40161009, end_position_on_the_genomic_accession=40221136, orientation='plus', exon_count=23, OMIM=602860, no_hdr0=''),
  705 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=705, CurrentID=0, Status='live', Symbol='BYSL', Aliases='BYSTIN', description='bystin like', other_designations='by the ribosomal protein s6 gene, drosophila, homolog-like|bystin-like', map_location='6p21.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=41907847, end_position_on_the_genomic_accession=41933046, orientation='plus', exon_count=8, OMIM=603871, no_hdr0=''),
  706 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=706, CurrentID=0, Status='live', Symbol='TSPO', Aliases='BPBS, BZRP, DBI, IBP, MBR, PBR, PBS, PKBS, PTBR, mDRC, pk18', description='translocator protein', other_designations='benzodiazepine peripheral binding site|mitochondrial benzodiazepine receptor|peripheral-type benzodiazepine receptor|translocator protein (18kDa)', map_location='22q13.31', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=43151514, end_position_on_the_genomic_accession=43163242, orientation='plus', exon_count=5, OMIM=109610, no_hdr0=''),
  708 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=708, CurrentID=0, Status='live', Symbol='C1QBP', Aliases='GC1QBP, HABP1, SF2p32, gC1Q-R, gC1qR, p32', description='complement component 1, q subcomponent binding protein', other_designations='ASF/SF2-associated protein p32|C1q globular domain-binding protein|glycoprotein gC1qBP|hyaluronan-binding protein 1|mitochondrial matrix protein p32|p33|splicing factor SF2-associated protein', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=5432779, end_position_on_the_genomic_accession=5439151, orientation='minus', exon_count=6, OMIM=601269, no_hdr0=''),
  710 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=710, CurrentID=0, Status='live', Symbol='SERPING1', Aliases='C1IN, C1INH, C1NH, HAE1, HAE2', description='serpin peptidase inhibitor, clade G (C1 inhibitor), member 1', other_designations='C1 esterase inhibitor|C1-inhibiting factor|complement component 1 inhibitor|serine/cysteine proteinase inhibitor clade G member 1|serpin G1|serpin peptidase inhibitor clade G member 1', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=57597554, end_position_on_the_genomic_accession=57614853, orientation='plus', exon_count=8, OMIM=606860, no_hdr0=''),
  105373242 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105373242, CurrentID=0, Status='live', Symbol='LOC105373242', Aliases='', description='uncharacterized LOC105373242', other_designations='', map_location='', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=69031633, end_position_on_the_genomic_accession=69083878, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  712 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=712, CurrentID=0, Status='live', Symbol='C1QA', Aliases='', description='complement component 1, q subcomponent, A chain', other_designations='complement component 1, q subcomponent, alpha polypeptide|complement component C1q, A chain', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22636625, end_position_on_the_genomic_accession=22639682, orientation='plus', exon_count=3, OMIM=120550, no_hdr0=''),
  713 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=713, CurrentID=0, Status='live', Symbol='C1QB', Aliases='', description='complement component 1, q subcomponent, B chain', other_designations='complement component 1, q subcomponent, beta polypeptide|complement component C1q, B chain|complement subcomponent C1q chain B', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22653179, end_position_on_the_genomic_accession=22661552, orientation='plus', exon_count=4, OMIM=120570, no_hdr0=''),
  714 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=714, CurrentID=0, Status='live', Symbol='C1QC', Aliases='C1Q-C, C1QG', description='complement component 1, q subcomponent, C chain', other_designations='complement component 1, q subcomponent, gamma polypeptide', map_location='1p36.11', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22643625, end_position_on_the_genomic_accession=22648110, orientation='plus', exon_count=3, OMIM=120575, no_hdr0=''),
  715 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=715, CurrentID=0, Status='live', Symbol='C1R', Aliases='', description='complement component 1, r subcomponent', other_designations='', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=7085860, end_position_on_the_genomic_accession=7092447, orientation='minus', exon_count=11, OMIM=613785, no_hdr0=''),
  716 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=716, CurrentID=0, Status='live', Symbol='C1S', Aliases='', description='complement component 1, s subcomponent', other_designations='C1 esterase|basic proline-rich peptide IB-1|complement component 1 subcomponent s', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=7060676, end_position_on_the_genomic_accession=7071032, orientation='plus', exon_count=13, OMIM=120580, no_hdr0=''),
  717 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=717, CurrentID=0, Status='live', Symbol='C2', Aliases='ARMD14, CO2', description='complement component 2', other_designations='C3/C5 convertase|complement component C2', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31897785, end_position_on_the_genomic_accession=31945674, orientation='plus', exon_count=20, OMIM=613927, no_hdr0=''),
  718 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=718, CurrentID=0, Status='live', Symbol='C3', Aliases='AHUS5, ARMD9, ASPa, C3b, CPAMD1, HEL-S-62p, C3', description='complement component 3', other_designations='C3 and PZP-like alpha-2-macroglobulin domain-containing protein 1|C3a anaphylatoxin|acylation-stimulating protein cleavage product|complement component C3a|complement component C3b|epididymis secretory sperm binding protein Li 62p|prepro-C3', map_location='19p13.3-p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=6677835, end_position_on_the_genomic_accession=6720682, orientation='minus', exon_count=41, OMIM=120700, no_hdr0=''),
  719 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=719, CurrentID=0, Status='live', Symbol='C3AR1', Aliases='AZ3B, C3AR, HNFAG09', description='complement component 3a receptor 1', other_designations='C3a-R|complement component 3 receptor 1', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=8058323, end_position_on_the_genomic_accession=8066359, orientation='minus', exon_count=2, OMIM=605246, no_hdr0=''),
  720 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=720, CurrentID=0, Status='live', Symbol='C4A', Aliases='C42, C4A3, C4A4, C4A6, C4AD, C4S, CO4, CPAMD2, RG, C4A', description='complement component 4A (Rodgers blood group)', other_designations='C3 and PZP-like alpha-2-macroglobulin domain-containing protein 2|C4A anaphylatoxin|Rodgers form of C4|acidic C4|acidic complement C4', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31982057, end_position_on_the_genomic_accession=32002680, orientation='plus', exon_count=41, OMIM=120810, no_hdr0=''),
  721 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=721, CurrentID=0, Status='live', Symbol='C4B', Aliases='C4B112, C4B2, C4B3, C4B5, C4BD, C4B_2, C4F, CH, CO4, CPAMD3, C4B', description='complement component 4B (Chido blood group)', other_designations='C3 and PZP-like alpha-2-macroglobulin domain-containing protein 3|Chido form of C4|basic complement C4|complement C4B1a', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=32014795, end_position_on_the_genomic_accession=32035418, orientation='plus', exon_count=41, OMIM=120820, no_hdr0=''),
  722 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=722, CurrentID=0, Status='live', Symbol='C4BPA', Aliases='C4BP, PRP', description='complement component 4 binding protein, alpha', other_designations='proline-rich protein', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207104238, end_position_on_the_genomic_accession=207144972, orientation='plus', exon_count=12, OMIM=120830, no_hdr0=''),
  725 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=725, CurrentID=0, Status='live', Symbol='C4BPB', Aliases='C4BP', description='complement component 4 binding protein, beta', other_designations='', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207088850, end_position_on_the_genomic_accession=207099993, orientation='plus', exon_count=8, OMIM=120831, no_hdr0=''),
  726 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=726, CurrentID=0, Status='live', Symbol='CAPN5', Aliases='ADNIV, HTRA3, VRNI, nCL-3', description='calpain 5', other_designations='calpain htra-3|new calpain 3', map_location='11q14', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=77066945, end_position_on_the_genomic_accession=77126155, orientation='plus', exon_count=14, OMIM=602537, no_hdr0=''),
  727 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=727, CurrentID=0, Status='live', Symbol='C5', Aliases='C5Da, C5b, CPAMD4, ECLZB, C5', description='complement component 5', other_designations='C3 and PZP-like alpha-2-macroglobulin domain-containing protein 4|C5a anaphylatoxin|anaphylatoxin C5a analog|prepro-C5', map_location='9q33-q34', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=120952335, end_position_on_the_genomic_accession=121074925, orientation='minus', exon_count=45, OMIM=120900, no_hdr0=''),
  728 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=728, CurrentID=0, Status='live', Symbol='C5AR1', Aliases='C5A, C5AR, C5R1, CD88', description='complement component 5a receptor 1', other_designations='C5a anaphylatoxin receptor|C5a ligand|C5a-R|complement component 5 receptor 1', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=47307745, end_position_on_the_genomic_accession=47322070, orientation='plus', exon_count=4, OMIM=113995, no_hdr0=''),
  729 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=729, CurrentID=0, Status='live', Symbol='C6', Aliases='', description='complement component 6', other_designations='', map_location='5p13', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=41142146, end_position_on_the_genomic_accession=41261486, orientation='minus', exon_count=23, OMIM=217050, no_hdr0=''),
  730 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=730, CurrentID=0, Status='live', Symbol='C7', Aliases='', description='complement component 7', other_designations='', map_location='5p13', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=40909473, end_position_on_the_genomic_accession=41016004, orientation='plus', exon_count=19, OMIM=217070, no_hdr0=''),
  731 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=731, CurrentID=0, Status='live', Symbol='C8A', Aliases='', description='complement component 8, alpha polypeptide', other_designations='complement component 8 subunit alpha', map_location='1p32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=56854770, end_position_on_the_genomic_accession=56918221, orientation='plus', exon_count=12, OMIM=120950, no_hdr0=''),
  732 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=732, CurrentID=0, Status='live', Symbol='C8B', Aliases='C82', description='complement component 8, beta polypeptide', other_designations='complement component 8 subunit beta', map_location='1p32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=56929210, end_position_on_the_genomic_accession=56966140, orientation='minus', exon_count=14, OMIM=120960, no_hdr0=''),
  733 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=733, CurrentID=0, Status='live', Symbol='C8G', Aliases='C8C', description='complement component 8, gamma polypeptide', other_designations='', map_location='9q34.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=136944875, end_position_on_the_genomic_accession=136946974, orientation='plus', exon_count=7, OMIM=120930, no_hdr0=''),
  197342 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=197342, CurrentID=0, Status='live', Symbol='EME2', Aliases='SLX2B, gs125', description='essential meiotic structure-specific endonuclease subunit 2', other_designations='SLX2 structure-specific endonuclease subunit homolog B|essential meiotic endonuclease 1 homolog 2|homolog of yeast EME1 endonuclease 2', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=1773228, end_position_on_the_genomic_accession=1776238, orientation='plus', exon_count=8, OMIM=610886, no_hdr0=''),
  735 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=735, CurrentID=0, Status='live', Symbol='C9', Aliases='ARMD15D, C9', description='complement component 9', other_designations='', map_location='5p14-p12', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=39284275, end_position_on_the_genomic_accession=39364553, orientation='minus', exon_count=11, OMIM=120940, no_hdr0=''),
  284112 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284112, CurrentID=0, Status='live', Symbol='LOC284112', Aliases='', description='uncharacterized LOC284112', other_designations='', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  738 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=738, CurrentID=0, Status='live', Symbol='VPS51', Aliases='ANG2, ANG3, C11orf2, C11orf3, FFR', description='VPS51 GARP complex subunit', other_designations='another new gene 2 protein|protein fat-free homolog|vacuolar protein sorting 51 homolog', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65096115, end_position_on_the_genomic_accession=65111860, orientation='plus', exon_count=10, OMIM=615738, no_hdr0=''),
  740 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=740, CurrentID=0, Status='live', Symbol='MRPL49', Aliases='C11orf4, L49mt, MRP-L49, NOF, NOF1', description='mitochondrial ribosomal protein L49', other_designations='neighbor of FAU|next to FAU', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65122183, end_position_on_the_genomic_accession=65127369, orientation='plus', exon_count=4, OMIM=606866, no_hdr0=''),
  741 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=741, CurrentID=0, Status='live', Symbol='ZNHIT2', Aliases='C11orf5, FON', description='zinc finger HIT-type containing 2', other_designations='zinc finger, HIT domain containing 2|zinc finger, HIT type 2|zinc finger, HIT-type containing 2', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65116403, end_position_on_the_genomic_accession=65117738, orientation='minus', exon_count=1, OMIM=604575, no_hdr0=''),
  389558 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=389558, CurrentID=0, Status='live', Symbol='FAM180A', Aliases='UNQ1940', description='family with sequence similarity 180 member A', other_designations='HWKM1940|family with sequence similarity 180, member A', map_location='7q33', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=135729598, end_position_on_the_genomic_accession=135748867, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  744 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=744, CurrentID=0, Status='live', Symbol='MPPED2', Aliases='239FB, C11orf8', description='metallophosphoesterase domain containing 2', other_designations='fetal brain protein 239|metallophosphoesterase domain-containing protein 2', map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=30384493, end_position_on_the_genomic_accession=30586714, orientation='minus', exon_count=14, OMIM=600911, no_hdr0=''),
  745 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=745, CurrentID=0, Status='live', Symbol='MYRF', Aliases='C11orf9, MRF, Ndt80, pqn-47', description='myelin regulatory factor', other_designations='myelin gene regulatory factor', map_location='11q12-q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61752637, end_position_on_the_genomic_accession=61788518, orientation='plus', exon_count=28, OMIM=608329, no_hdr0=''),
  746 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=746, CurrentID=0, Status='live', Symbol='TMEM258', Aliases='C11orf10', description='transmembrane protein 258', other_designations='UPF0197 transmembrane protein C11orf10', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61789130, end_position_on_the_genomic_accession=61792613, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  747 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=747, CurrentID=0, Status='live', Symbol='DAGLA', Aliases='C11orf11, DAGL(ALPHA)LPHA, NSDDR, DAGLA', description='diacylglycerol lipase, alpha', other_designations='DGL-alpha|neural stem cell-derived dendrite regulator', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61680433, end_position_on_the_genomic_accession=61747002, orientation='plus', exon_count=23, OMIM=614015, no_hdr0=''),
  284114 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284114, CurrentID=0, Status='live', Symbol='TMEM102', Aliases='CBAP', description='transmembrane protein 102', other_designations='common beta-chain associated protein|common beta-chain-associated protein', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7428825, end_position_on_the_genomic_accession=7437679, orientation='plus', exon_count=6, OMIM=613936, no_hdr0=''),
  197358 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=197358, CurrentID=0, Status='live', Symbol='NLRC3', Aliases='CLR16.2, NOD3', description='NLR family, CARD domain containing 3', other_designations='CARD15-like protein|NOD-like receptor C3|caterpiller protein 16.2|nucleotide-binding oligomerization domain, leucine rich repeat and CARD domain containing 3', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=3539033, end_position_on_the_genomic_accession=3578373, orientation='minus', exon_count=25, OMIM=615648, no_hdr0=''),
  752 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=752, CurrentID=0, Status='live', Symbol='FMNL1', Aliases='C17orf1, C17orf1B, FHOD4, FMNL, KW-13', description='formin like 1', other_designations='CLL-associated antigen KW-13|formin-like 1|leukocyte formin', map_location='17q21', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=45221906, end_position_on_the_genomic_accession=45247320, orientation='plus', exon_count=29, OMIM=604656, no_hdr0=''),
  753 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=753, CurrentID=0, Status='live', Symbol='LDLRAD4', Aliases='C18orf1', description='low density lipoprotein receptor class A domain containing 4', other_designations='clone 22', map_location='18p11.21', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=13218730, end_position_on_the_genomic_accession=13652754, orientation='plus', exon_count=14, OMIM=606571, no_hdr0=''),
  754 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=754, CurrentID=0, Status='live', Symbol='PTTG1IP', Aliases='C21orf1, C21orf3, PBF', description='pituitary tumor-transforming 1 interacting protein', other_designations='PTTG-binding factor|pituitary tumor-transforming gene protein-binding factor', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=44849585, end_position_on_the_genomic_accession=44873903, orientation='minus', exon_count=6, OMIM=603784, no_hdr0=''),
  755 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=755, CurrentID=0, Status='live', Symbol='C21orf2', Aliases='LRRC76, YF5/A2', description='chromosome 21 open reading frame 2', other_designations='leucine rich repeat containing 76', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=44328944, end_position_on_the_genomic_accession=44339402, orientation='minus', exon_count=9, OMIM=603191, no_hdr0=''),
  645974 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=645974, CurrentID=0, Status='live', Symbol='PABPC1L2B', Aliases='RBM32B', description='poly(A) binding protein, cytoplasmic 1-like 2B', other_designations='RNA binding motif protein 32B|RNA-binding motif protein 32|RNA-binding protein 32', map_location='Xq13.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=73003513, end_position_on_the_genomic_accession=73005712, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  757 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=757, CurrentID=0, Status='live', Symbol='TMEM50B', Aliases='C21orf4, HCVP7TP3', description='transmembrane protein 50B', other_designations='HCV p7-trans-regulated protein 3|HCV p7-transregulated protein 3', map_location='21q22.11', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=33432486, end_position_on_the_genomic_accession=33480009, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  758 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=758, CurrentID=0, Status='live', Symbol='MPPED1', Aliases='239AB, C22orf1, FAM1A', description='metallophosphoesterase domain containing 1', other_designations='adult brain protein 239', map_location='22q13.31', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=43412014, end_position_on_the_genomic_accession=43507808, orientation='plus', exon_count=8, OMIM=602112, no_hdr0=''),
  759 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=759, CurrentID=0, Status='live', Symbol='CA1', Aliases='CA-I, CAB, Car1, HEL-S-11', description='carbonic anhydrase I', other_designations='carbonate dehydratase I|carbonic anhydrase B|epididymis secretory protein Li 11', map_location='8q21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=85328229, end_position_on_the_genomic_accession=85378154, orientation='minus', exon_count=11, OMIM=114800, no_hdr0=''),
  760 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=760, CurrentID=0, Status='live', Symbol='CA2', Aliases='CA-II, CAC, CAII, Car2, HEL-76, HEL-S-282', description='carbonic anhydrase II', other_designations='carbonate dehydratase II|carbonic anhydrase B|carbonic anhydrase C|carbonic dehydratase|epididymis luminal protein 76|epididymis secretory protein Li 282', map_location='8q22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=85463902, end_position_on_the_genomic_accession=85481492, orientation='plus', exon_count=7, OMIM=611492, no_hdr0=''),
  761 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=761, CurrentID=0, Status='live', Symbol='CA3', Aliases='CAIII, Car3', description='carbonic anhydrase III', other_designations='CA-III|HEL-S-167mP|carbonate dehydratase III|carbonic anhydrase III, muscle specific|epididymis secretory sperm binding protein Li 167mP', map_location='8q21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=85438827, end_position_on_the_genomic_accession=85449040, orientation='plus', exon_count=7, OMIM=114750, no_hdr0=''),
  762 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=762, CurrentID=0, Status='live', Symbol='CA4', Aliases='CAIV, Car4, RP17', description='carbonic anhydrase IV', other_designations='CA-IV|carbonate dehydratase IV|carbonic dehydratase IV', map_location='17q23', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=60149941, end_position_on_the_genomic_accession=60159546, orientation='plus', exon_count=9, OMIM=114760, no_hdr0=''),
  763 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=763, CurrentID=0, Status='live', Symbol='CA5A', Aliases='CA5D, CAV, CAVA, GS1-21A4.1, CA5A', description='carbonic anhydrase VA, mitochondrial', other_designations='CA-VA|carbonate dehydratase VA|carbonic anhydrase V, mitochondrial|carbonic dehydratase', map_location='16q24.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=87888019, end_position_on_the_genomic_accession=87936569, orientation='minus', exon_count=10, OMIM=114761, no_hdr0=''),
  765 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=765, CurrentID=0, Status='live', Symbol='CA6', Aliases='CA-VI, GUSTIN', description='carbonic anhydrase VI', other_designations='carbonate dehydratase VI|carbonic anhydrase VI nirs variant 2|salivary carbonic anhydrase|secreted carbonic anhydrase', map_location='1p36.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=8945785, end_position_on_the_genomic_accession=8975092, orientation='plus', exon_count=10, OMIM=114780, no_hdr0=''),
  766 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=766, CurrentID=0, Status='live', Symbol='CA7', Aliases='CAVII', description='carbonic anhydrase VII', other_designations='CA-VII|carbonate dehydratase VII|carbonic dehydratase VII', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=66844379, end_position_on_the_genomic_accession=66854149, orientation='plus', exon_count=9, OMIM=114770, no_hdr0=''),
  767 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=767, CurrentID=0, Status='live', Symbol='CA8', Aliases='CA-VIII, CALS, CAMRQ3, CARP', description='carbonic anhydrase VIII', other_designations='CA-related protein|carbonate dehydratase|carbonic anhydrase-like sequence', map_location='8q12.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=60187347, end_position_on_the_genomic_accession=60281395, orientation='minus', exon_count=13, OMIM=114815, no_hdr0=''),
  768 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=768, CurrentID=0, Status='live', Symbol='CA9', Aliases='CAIX, MN', description='carbonic anhydrase IX', other_designations='CA-IX|P54/58N|RCC-associated antigen G250|RCC-associated protein G250|carbonate dehydratase IX|carbonic dehydratase|membrane antigen MN|pMW1|renal cell carcinoma-associated antigen G250', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=35673918, end_position_on_the_genomic_accession=35681159, orientation='plus', exon_count=12, OMIM=603179, no_hdr0=''),
  770 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=770, CurrentID=0, Status='live', Symbol='CA11', Aliases='CARPX1', description='carbonic anhydrase XI', other_designations='CA-RP II|CA-XI|CARP XI|CARP-2|carbonic anhydrase-related protein 2|carbonic anhydrase-related protein XI', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48638015, end_position_on_the_genomic_accession=48646194, orientation='minus', exon_count=9, OMIM=604644, no_hdr0=''),
  771 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=771, CurrentID=0, Status='live', Symbol='CA12', Aliases='CAXII, HsT18816', description='carbonic anhydrase XII', other_designations='CA-XII|carbonate dehydratase XII|carbonic dehydratase|tumor antigen HOM-RCC-3.1.3', map_location='15q22', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=63323531, end_position_on_the_genomic_accession=63382110, orientation='minus', exon_count=11, OMIM=603263, no_hdr0=''),
  773 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=773, CurrentID=0, Status='live', Symbol='CACNA1A', Aliases='APCA, BI, CACNL1A4, CAV2.1, EA2, FHM, HPCA, MHP, MHP1, SCA6', description='calcium voltage-gated channel subunit alpha1 A', other_designations='brain calcium channel 1|brain calcium channel I|calcium channel, L type, alpha-1 polypeptide|calcium channel, voltage-dependent, P/Q type, alpha 1A subunit|fetal brain Ca2+ voltage-gated channel alpha1A pore-forming subunit|voltage-gated calcium channel subunit alpha Cav2.1', map_location='19p13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=13206442, end_position_on_the_genomic_accession=13506460, orientation='minus', exon_count=49, OMIM=601011, no_hdr0=''),
  774 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=774, CurrentID=0, Status='live', Symbol='CACNA1B', Aliases='BIII, CACNL1A5, CACNN, Cav2.2, DYT23', description='calcium voltage-gated channel subunit alpha1 B', other_designations='Cav2.2 voltage-gated Ca2+ channel|brain calcium channel III|calcium channel alpha12.2 subunit|calcium channel, L type, alpha-1 polypeptide|calcium channel, voltage-dependent, L type, alpha 1B subunit|calcium channel, voltage-dependent, N type, alpha 1B subunit|voltage-gated calcium channel alpha subunit Cav2.2|voltage-gated calcium channel subunit alpha Cav2.2', map_location='9q34', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=137877789, end_position_on_the_genomic_accession=138124624, orientation='plus', exon_count=51, OMIM=601012, no_hdr0=''),
  775 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=775, CurrentID=0, Status='live', Symbol='CACNA1C', Aliases='CACH2, CACN2, CACNL1A1, CCHL1A1, CaV1.2, LQT8, TS', description='calcium voltage-gated channel subunit alpha1 C', other_designations='DHPR, alpha-1 subunit|calcium channel, L type, alpha-1 polypeptide, isoform 1, cardiac muscle|calcium channel, cardic dihydropyridine-sensitive, alpha-1 subunit|calcium channel, voltage-dependent, L type, alpha 1C subunit|voltage-dependent L-type Ca2+ channel alpha 1 subunit|voltage-gated L-type calcium channel Cav1.2 alpha 1 subunit, splice variant 10*', map_location='12p13.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=1970786, end_position_on_the_genomic_accession=2697949, orientation='plus', exon_count=56, OMIM=114205, no_hdr0=''),
  776 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=776, CurrentID=0, Status='live', Symbol='CACNA1D', Aliases='CACH3, CACN4, CACNL1A2, CCHL1A2, Cav1.3, PASNA, SANDD', description='calcium voltage-gated channel subunit alpha1 D', other_designations='calcium channel, L type, alpha-1 polypeptide|calcium channel, neuroendocrine/brain-type, alpha 1 subunit|calcium channel, voltage-dependent, L type, alpha 1D subunit|voltage-gated calcium channel alpha 1 subunit|voltage-gated calcium channel alpha subunit Cav1.3', map_location='3p14.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=53494976, end_position_on_the_genomic_accession=53813151, orientation='plus', exon_count=55, OMIM=114206, no_hdr0=''),
  777 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=777, CurrentID=0, Status='live', Symbol='CACNA1E', Aliases='BII, CACH6, CACNL1A6, Cav2.3', description='calcium voltage-gated channel subunit alpha1 E', other_designations='brain calcium channel II|calcium channel, L type, alpha-1 polypeptide|calcium channel, R type, alpha-1 polypeptide|calcium channel, voltage-dependent, R type, alpha 1E subunit|calcium channel, voltage-dependent, alpha 1E subunit|voltage-dependent calcium channel alpha 1E subunit|voltage-gated calcium channel alpha 1E subunit|voltage-gated calcium channel alpha subunit Cav2.3|voltage-gated calcium channel subunit alpha Cav2.3', map_location='1q25.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=181483311, end_position_on_the_genomic_accession=181806784, orientation='plus', exon_count=48, OMIM=601013, no_hdr0=''),
  778 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=778, CurrentID=0, Status='live', Symbol='CACNA1F', Aliases='AIED, COD3, COD4, CORDX, CORDX3, CSNB2, CSNB2A, CSNBX2, Cav1.4, Cav1.4alpha1, JM8, JMC8, OA2', description='calcium voltage-gated channel subunit alpha1 F', other_designations='calcium channel, voltage-dependent, L type, alpha 1F subunit|voltage-gated calcium channel subunit alpha Cav1.4', map_location='Xp11.23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=49205063, end_position_on_the_genomic_accession=49233671, orientation='minus', exon_count=48, OMIM=300110, no_hdr0=''),
  779 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=779, CurrentID=0, Status='live', Symbol='CACNA1S', Aliases='CACNL1A3, CCHL1A3, Cav1.1, HOKPP, HOKPP1, MHS5, TTPP1, hypoPP', description='calcium voltage-gated channel subunit alpha1 S', other_designations='calcium channel, L type, alpha 1 polypeptide, isoform 3 (skeletal muscle, hypokalemic periodic paralysis)|calcium channel, voltage-dependent, L type, alpha 1S subunit|dihydropyridine receptor|dihydropyridine-sensitive L-type calcium channel alpha-1 subunit|voltage-gated calcium channel subunit alpha Cav1.1', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=201039507, end_position_on_the_genomic_accession=201112566, orientation='minus', exon_count=44, OMIM=114208, no_hdr0=''),
  780 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=780, CurrentID=0, Status='live', Symbol='DDR1', Aliases='CAK, CD167, DDR, EDDR1, HGK2, MCK10, NEP, NTRK4, PTK3, PTK3A, RTK6, TRKE', description='discoidin domain receptor tyrosine kinase 1', other_designations='CD167 antigen-like family member A|PTK3A protein tyrosine kinase 3A|cell adhesion kinase|mammary carcinoma kinase 10|neuroepithelial tyrosine kinase|neurotrophic tyrosine kinase, receptor, type 4|protein-tyrosine kinase RTK-6|tyrosine kinase DDR|tyrosine-protein kinase CAK', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=30880909, end_position_on_the_genomic_accession=30900156, orientation='plus', exon_count=23, OMIM=600408, no_hdr0=''),
  781 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=781, CurrentID=0, Status='live', Symbol='CACNA2D1', Aliases='CACNA2, CACNL2A, CCHL2A, LINC01112, lncRNA-N3', description='calcium voltage-gated channel auxiliary subunit alpha2delta 1', other_designations='calcium channel, L type, alpha 2 polypeptide|calcium channel, voltage-dependent, alpha 2/delta subunit 1|dihydropyridine-sensitive L-type, calcium channel alpha-2/delta subunit|voltage-gated calcium channel subunit alpha-2/delta-1', map_location='7q21-q22', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=81946444, end_position_on_the_genomic_accession=82443806, orientation='minus', exon_count=47, OMIM=114204, no_hdr0=''),
  782 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=782, CurrentID=0, Status='live', Symbol='CACNB1', Aliases='CAB1, CACNLB1, CCHLB1', description='calcium voltage-gated channel auxiliary subunit beta 1', other_designations='calcium channel voltage-dependent subunit beta 1|calcium channel, L type, beta 1 polypeptide|calcium channel, voltage-dependent, beta 1 subunit|dihydropyridine-sensitive L-type, calcium channel beta-1 subunit', map_location='17q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=39173456, end_position_on_the_genomic_accession=39197703, orientation='minus', exon_count=18, OMIM=114207, no_hdr0=''),
  783 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=783, CurrentID=0, Status='live', Symbol='CACNB2', Aliases='CACNLB2, CAVB2, MYSB', description='calcium voltage-gated channel auxiliary subunit beta 2', other_designations='CAB2|calcium channel voltage-dependent subunit beta 2|calcium channel, voltage-dependent, beta 2 subunit|lambert-Eaton myasthenic syndrome antigen B|myasthenic (Lambert-Eaton) syndrome antigen B', map_location='10p12', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=18140677, end_position_on_the_genomic_accession=18541759, orientation='plus', exon_count=20, OMIM=600003, no_hdr0=''),
  784 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=784, CurrentID=0, Status='live', Symbol='CACNB3', Aliases='CAB3, CACNLB3', description='calcium voltage-gated channel auxiliary subunit beta 3', other_designations='calcium channel, voltage-dependent, beta 3 subunit', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=48814432, end_position_on_the_genomic_accession=48828943, orientation='plus', exon_count=19, OMIM=601958, no_hdr0=''),
  785 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=785, CurrentID=0, Status='live', Symbol='CACNB4', Aliases='CAB4, CACNLB4, EA5, EIG9, EJM, EJM4, EJM6', description='calcium voltage-gated channel auxiliary subunit beta 4', other_designations='calcium channel voltage-dependent subunit beta 4|calcium channel, voltage-dependent, beta 4 subunit|dihydropyridine-sensitive L-type, calcium channel beta-4 subunit', map_location='2q23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=151832771, end_position_on_the_genomic_accession=152099988, orientation='minus', exon_count=21, OMIM=601949, no_hdr0=''),
  786 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=786, CurrentID=0, Status='live', Symbol='CACNG1', Aliases='CACNLG', description='calcium voltage-gated channel auxiliary subunit gamma 1', other_designations='L-type calcium channel gamma polypeptide|calcium channel, voltage-dependent, gamma subunit 1|dihydropyridine-sensitive L-type, skeletal muscle calcium channel subunit gamma|neuronal dihydropyridine-sensitive calcium channel gamma subunit', map_location='17q24', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=67044536, end_position_on_the_genomic_accession=67056797, orientation='plus', exon_count=4, OMIM=114209, no_hdr0=''),
  219539 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=219539, CurrentID=0, Status='live', Symbol='YPEL4', Aliases='', description='yippee like 4', other_designations='yippee-like 4', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=57645087, end_position_on_the_genomic_accession=57649944, orientation='minus', exon_count=6, OMIM=609725, no_hdr0=''),
  788 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=788, CurrentID=0, Status='live', Symbol='SLC25A20', Aliases='CAC, CACT', description='solute carrier family 25 (carnitine/acylcarnitine translocase), member 20', other_designations='', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48856923, end_position_on_the_genomic_accession=48898993, orientation='minus', exon_count=9, OMIM=613698, no_hdr0=''),
  790 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=790, CurrentID=0, Status='live', Symbol='CAD', Aliases='', description='carbamoyl-phosphate synthetase 2, aspartate transcarbamylase, and dihydroorotase', other_designations='CAD trifunctional protein|multifunctional protein CAD', map_location='2p22-p21', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=27217390, end_position_on_the_genomic_accession=27243792, orientation='plus', exon_count=45, OMIM=114010, no_hdr0=''),
  492311 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=492311, CurrentID=0, Status='live', Symbol='IGIP', Aliases='C5orf53', description='IgA-inducing protein', other_designations='IgA-inducing protein homolog (Bos taurus)', map_location='5q31', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=140125936, end_position_on_the_genomic_accession=140128806, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  793 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=793, CurrentID=0, Status='live', Symbol='CALB1', Aliases='CALB, D-28K', description='calbindin 1', other_designations='RTVL-H protein|calbindin 1, (28kD)|calbindin 1, 28kDa|calbindin D28|vitamin D-dependent calcium-binding protein, avian-type', map_location='8q21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=90058608, end_position_on_the_genomic_accession=90082881, orientation='minus', exon_count=11, OMIM=114050, no_hdr0=''),
  794 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=794, CurrentID=0, Status='live', Symbol='CALB2', Aliases='CAB29, CAL2, CR', description='calbindin 2', other_designations='29 kDa calbindin|calbindin 2, (29kD, calretinin)|calbindin D29K', map_location='16q22.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=71358713, end_position_on_the_genomic_accession=71390438, orientation='plus', exon_count=11, OMIM=114051, no_hdr0=''),
  795 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=795, CurrentID=0, Status='live', Symbol='S100G', Aliases='CABP, CABP1, CABP9K, CALB3', description='S100 calcium binding protein G', other_designations='S100 calcium-binding protein G|calbindin 3, (vitamin D-dependent calcium-binding protein)|calbindin D9K|calbindin-D9K|vitamin D-dependent calcium-binding protein, intestinal', map_location='Xp22.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=16650158, end_position_on_the_genomic_accession=16654668, orientation='plus', exon_count=3, OMIM=302020, no_hdr0=''),
  796 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=796, CurrentID=0, Status='live', Symbol='CALCA', Aliases='CALC1, CGRP, CGRP-I, CGRP1, CT, KC, PCT', description='calcitonin-related polypeptide alpha', other_designations='alpha-type CGRP|calcitonin 1|calcitonin gene-related peptide I|calcitonin/calcitonin-related polypeptide, alpha|katacalcin', map_location='11p15.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=14966669, end_position_on_the_genomic_accession=14972286, orientation='minus', exon_count=6, OMIM=114130, no_hdr0=''),
  797 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=797, CurrentID=0, Status='live', Symbol='CALCB', Aliases='CALC2, CGRP-II, CGRP2', description='calcitonin-related polypeptide beta', other_designations='beta-CGRP|beta-type CGRP|calcitonin 2|calcitonin gene-related peptide II', map_location='11p15.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=15073600, end_position_on_the_genomic_accession=15078631, orientation='plus', exon_count=5, OMIM=114160, no_hdr0=''),
  131870 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131870, CurrentID=0, Status='live', Symbol='NUDT16', Aliases='', description='nudix hydrolase 16', other_designations='IDP phosphatase|IDPase|U8 snoRNA-binding protein H29K|inosine diphosphate phosphatase|m7GpppN-mRNA hydrolase|nucleoside diphosphate-linked moiety X motif 16|nudix (nucleoside diphosphate linked moiety X)-type motif 16|nudix motif 16', map_location='3q22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=131381671, end_position_on_the_genomic_accession=131388830, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  799 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=799, CurrentID=0, Status='live', Symbol='CALCR', Aliases='CRT, CT-R, CTR, CTR1', description='calcitonin receptor', other_designations='', map_location='7q21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=93424487, end_position_on_the_genomic_accession=93574730, orientation='minus', exon_count=17, OMIM=114131, no_hdr0=''),
  800 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=800, CurrentID=0, Status='live', Symbol='CALD1', Aliases='CDM, H-CAD, HCAD, L-CAD, LCAD, NAG22', description='caldesmon 1', other_designations='', map_location='7q33', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=134779413, end_position_on_the_genomic_accession=134970729, orientation='plus', exon_count=18, OMIM=114213, no_hdr0=''),
  801 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=801, CurrentID=0, Status='live', Symbol='CALM1', Aliases='CALML2, CAMI, CPVT4, DD132, LQT14, PHKD, caM', description='calmodulin 1 (phosphorylase kinase, delta)', other_designations='phosphorylase kinase, delta subunit|prepro-calmodulin 1', map_location='14q32.11', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=90396983, end_position_on_the_genomic_accession=90408275, orientation='plus', exon_count=7, OMIM=114180, no_hdr0=''),
  100996571 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100996571, CurrentID=0, Status='live', Symbol='CYYR1-AS1', Aliases='', description='cysteine/tyrosine-rich 1 antisense RNA 1', other_designations='', map_location='', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=26405943, end_position_on_the_genomic_accession=26569263, orientation='plus', exon_count=5, OMIM=616021, no_hdr0=''),
  805 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=805, CurrentID=0, Status='live', Symbol='CALM2', Aliases='CAMII, LQT15, PHKD, PHKD2, caM', description='calmodulin 2 (phosphorylase kinase, delta)', other_designations='LP7057 protein|phosphorylase kinase delta|prepro-calmodulin 2', map_location='2p21', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=47160082, end_position_on_the_genomic_accession=47176601, orientation='minus', exon_count=6, OMIM=114182, no_hdr0=''),
  153918 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=153918, CurrentID=0, Status='live', Symbol='ZC2HC1B', Aliases='C6orf94, FAM164B, dJ468K18.5', description='zinc finger C2HC-type containing 1B', other_designations='family with sequence similarity 164, member B|protein FAM164B|zinc finger, C2HC-type containing 1B', map_location='6q24.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=143864436, end_position_on_the_genomic_accession=143938346, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  808 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=808, CurrentID=0, Status='live', Symbol='CALM3', Aliases='HEL-S-72, PHKD, PHKD3', description='calmodulin 3 (phosphorylase kinase, delta)', other_designations='caM|epididymis secretory protein Li 72|prepro-calmodulin 3', map_location='19q13.2-q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=46601255, end_position_on_the_genomic_accession=46610782, orientation='plus', exon_count=6, OMIM=114183, no_hdr0=''),
  169436 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=169436, CurrentID=0, Status='live', Symbol='STKLD1', Aliases='C9orf96, SgK071, Sk521', description='serine/threonine kinase-like domain containing 1', other_designations='probable inactive protein kinase-like protein SgK071|serine/threonine kinase-like domain-containing protein 1|sugen kinase 071', map_location='9q34.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=133376413, end_position_on_the_genomic_accession=133406096, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  810 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=810, CurrentID=0, Status='live', Symbol='CALML3', Aliases='CLP', description='calmodulin like 3', other_designations='caM-like protein|calmodulin-like 3|calmodulin-related protein NB-1', map_location='10p15.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=5524889, end_position_on_the_genomic_accession=5526268, orientation='plus', exon_count=1, OMIM=114184, no_hdr0=''),
  811 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=811, CurrentID=0, Status='live', Symbol='CALR', Aliases='CRT, HEL-S-99n, RO, SSA, cC1qR', description='calreticulin', other_designations='CRP55|ERp60|HACBP|Sicca syndrome antigen A (autoantigen Ro; calreticulin)|calregulin|endoplasmic reticulum resident protein 60|epididymis secretory sperm binding protein Li 99n|grp60', map_location='19p13.13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12938600, end_position_on_the_genomic_accession=12944490, orientation='plus', exon_count=9, OMIM=109091, no_hdr0=''),
  813 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=813, CurrentID=0, Status='live', Symbol='CALU', Aliases='', description='calumenin', other_designations='IEF SSP 9302|crocalbin-like protein|multiple EF-hand protein', map_location='7q32.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=128739292, end_position_on_the_genomic_accession=128773423, orientation='plus', exon_count=9, OMIM=603420, no_hdr0=''),
  814 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=814, CurrentID=0, Status='live', Symbol='CAMK4', Aliases='CaMK IV, CaMK-GR, IV, caMK', description='calcium/calmodulin-dependent protein kinase IV', other_designations='CAM kinase IV|CAM kinase- GR|brain Ca(2+)-calmodulin-dependent protein kinase type IV|brain Ca++-calmodulin-dependent protein kinase type IV|caM kinase-GR|calcium/calmodulin-dependent protein kinase type IV catalytic chain', map_location='5q21.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=111224249, end_position_on_the_genomic_accession=111494886, orientation='plus', exon_count=12, OMIM=114080, no_hdr0=''),
  815 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=815, CurrentID=0, Status='live', Symbol='CAMK2A', Aliases='CAMKA', description='calcium/calmodulin-dependent protein kinase II alpha', other_designations='CaM kinase II alpha subunit|CaM-kinase II alpha chain|CaMK-II alpha subunit|CaMKIINalpha|caM kinase II subunit alpha|caMK-II subunit alpha|calcium/calmodulin-dependent protein kinase (CaM kinase) II alpha|calcium/calmodulin-dependent protein kinase II alpha-B subunit|calcium/calmodulin-dependent protein kinase type II alpha chain', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=150219491, end_position_on_the_genomic_accession=150289840, orientation='minus', exon_count=19, OMIM=114078, no_hdr0=''),
  164656 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=164656, CurrentID=0, Status='live', Symbol='TMPRSS6', Aliases='IRIDA', description='transmembrane protease, serine 6', other_designations='matriptase-2|membrane-bound mosaic serine proteinase matriptase-2|type II transmembrane serine protease 6', map_location='22q12.3', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=37065436, end_position_on_the_genomic_accession=37110635, orientation='minus', exon_count=22, OMIM=609862, no_hdr0=''),
  817 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=817, CurrentID=0, Status='live', Symbol='CAMK2D', Aliases='CAMKD', description='calcium/calmodulin-dependent protein kinase II delta', other_designations='CaM kinase II delta subunit|CaM-kinase II delta chain|CaMK-II delta subunit|caM kinase II subunit delta|caMK-II subunit delta|calcium/calmodulin-dependent protein kinase (CaM kinase) II delta|calcium/calmodulin-dependent protein kinase type II delta chain', map_location='4q26', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=113451032, end_position_on_the_genomic_accession=113762133, orientation='minus', exon_count=27, OMIM=607708, no_hdr0=''),
  818 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=818, CurrentID=0, Status='live', Symbol='CAMK2G', Aliases='CAMK, CAMK-II, CAMKG', description='calcium/calmodulin-dependent protein kinase II gamma', other_designations='caMK-II subunit gamma|calcium/calmodulin-dependent protein kinase (CaM kinase) II gamma', map_location='10q22', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=73812501, end_position_on_the_genomic_accession=73874591, orientation='minus', exon_count=27, OMIM=602123, no_hdr0=''),
  819 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=819, CurrentID=0, Status='live', Symbol='CAMLG', Aliases='CAML', description='calcium modulating ligand', other_designations='calcium-modulating cyclophilin ligand|calcium-signal modulating cyclophilin ligand|cyclophilin B-binding protein', map_location='5q23', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=134737927, end_position_on_the_genomic_accession=134752160, orientation='plus', exon_count=4, OMIM=601118, no_hdr0=''),
  820 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=820, CurrentID=0, Status='live', Symbol='CAMP', Aliases='CAP-18, CAP18, CRAMP, FALL-39, FALL39, HSD26, LL37', description='cathelicidin antimicrobial peptide', other_designations='18 kDa cationic antimicrobial protein', map_location='3p21.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48223347, end_position_on_the_genomic_accession=48225491, orientation='plus', exon_count=4, OMIM=600474, no_hdr0=''),
  821 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=821, CurrentID=0, Status='live', Symbol='CANX', Aliases='CNX, IP90, P90', description='calnexin', other_designations='major histocompatibility complex class I antigen-binding protein p88', map_location='5q35', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=179678646, end_position_on_the_genomic_accession=179731641, orientation='plus', exon_count=17, OMIM=114217, no_hdr0=''),
  822 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=822, CurrentID=0, Status='live', Symbol='CAPG', Aliases='AFCP, HEL-S-66, MCP', description='capping actin protein, gelsolin like', other_designations='actin regulatory protein CAP-G|actin-regulatory protein CAP-G|capping protein (actin filament), gelsolin-like|epididymis secretory protein Li 66|gelsolin-like capping protein|macrophage capping protein', map_location='2p11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=85394748, end_position_on_the_genomic_accession=85418467, orientation='minus', exon_count=14, OMIM=153615, no_hdr0=''),
  823 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=823, CurrentID=0, Status='live', Symbol='CAPN1', Aliases='CANP, CANP1, CANPL1, muCANP, muCL', description='calpain 1', other_designations='CANP 1|calcium-activated neutral proteinase 1|calpain 1, (mu/I) large subunit|calpain mu-type|calpain, large polypeptide L1|calpain-1 large subunit|cell proliferation-inducing gene 30 protein|cell proliferation-inducing protein 30|micromolar-calpain', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65181215, end_position_on_the_genomic_accession=65212006, orientation='plus', exon_count=24, OMIM=114220, no_hdr0=''),
  824 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=824, CurrentID=0, Status='live', Symbol='CAPN2', Aliases='CANP2, CANPL2, CANPml, mCANP', description='calpain 2', other_designations='CANP 2|M-calpain|calcium-activated neutral proteinase 2|calpain 2, (m/II) large subunit|calpain 2, large [catalytic] subunit|calpain 2, large subunit|calpain M-type|calpain large polypeptide L2|calpain, large polypeptide L2|calpain-2 large subunit|millimolar-calpain', map_location='1q41-q42', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=223701593, end_position_on_the_genomic_accession=223776018, orientation='plus', exon_count=23, OMIM=114230, no_hdr0=''),
  825 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=825, CurrentID=0, Status='live', Symbol='CAPN3', Aliases='CANP3, CANPL3, LGMD2, LGMD2A, nCL-1, p94', description='calpain 3', other_designations='calpain 3, (p94)|calpain p94, large [catalytic] subunit|calpain, large polypeptide L3|muscle-specific calcium-activated neutral protease 3 large subunit|new calpain 1', map_location='15q15.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=42359500, end_position_on_the_genomic_accession=42412317, orientation='plus', exon_count=26, OMIM=114240, no_hdr0=''),
  826 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=826, CurrentID=0, Status='live', Symbol='CAPNS1', Aliases='CALPAIN4, CANP, CANPS, CAPN4, CDPS, CSS1', description='calpain small subunit 1', other_designations='CANP small subunit|calcium-activated neutral proteinase small subunit|calcium-dependent protease small subunit 1|calcium-dependent protease, small subunit|calpain 4, small subunit (30K)|calpain regulatory subunit|calpain, small polypeptide|calpain, small subunit 1', map_location='19q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=36139926, end_position_on_the_genomic_accession=36150353, orientation='plus', exon_count=13, OMIM=114170, no_hdr0=''),
  827 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=827, CurrentID=0, Status='live', Symbol='CAPN6', Aliases='CANPX, CAPNX, CalpM, DJ914P14.1', description='calpain 6', other_designations='calpain-like protease X-linked|calpamodulin', map_location='Xq23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=111245099, end_position_on_the_genomic_accession=111270546, orientation='minus', exon_count=13, OMIM=300146, no_hdr0=''),
  164668 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=164668, CurrentID=0, Status='live', Symbol='APOBEC3H', Aliases='A3H, ARP-10, ARP10', description='apolipoprotein B mRNA editing enzyme catalytic polypeptide like 3H', other_designations='APOBEC-related protein 10|apolipoprotein B mRNA editing enzyme, catalytic polypeptide-like 3H', map_location='22q13.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=39097223, end_position_on_the_genomic_accession=39104067, orientation='plus', exon_count=6, OMIM=610976, no_hdr0=''),
  829 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=829, CurrentID=0, Status='live', Symbol='CAPZA1', Aliases='CAPPA1, CAPZ, CAZ1', description='capping actin protein of muscle Z-line alpha subunit 1', other_designations='Cap Z|capZ alpha-1|capping protein (actin filament) muscle Z-line, alpha 1', map_location='1p13.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=112619453, end_position_on_the_genomic_accession=112671619, orientation='plus', exon_count=11, OMIM=601580, no_hdr0=''),
  830 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=830, CurrentID=0, Status='live', Symbol='CAPZA2', Aliases='CAPPA2, CAPZ', description='capping actin protein of muscle Z-line alpha subunit 2', other_designations='F-actin capping protein alpha-2 subunit|capZ alpha-2|capping protein (actin filament) muscle Z-line, alpha 2', map_location='7q31.2-q31.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=116862509, end_position_on_the_genomic_accession=116919259, orientation='plus', exon_count=10, OMIM=601571, no_hdr0=''),
  831 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=831, CurrentID=0, Status='live', Symbol='CAST', Aliases='BS-17, PLACK', description='calpastatin', other_designations='calpain inhibitor|sperm BS-17 component', map_location='5q15', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=96662037, end_position_on_the_genomic_accession=96774683, orientation='plus', exon_count=38, OMIM=114090, no_hdr0=''),
  832 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=832, CurrentID=0, Status='live', Symbol='CAPZB', Aliases='CAPB, CAPPB, CAPZ', description='capping actin protein of muscle Z-line beta subunit', other_designations='capZ beta|capping protein (actin filament) muscle Z-line, beta', map_location='1p36.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=19338773, end_position_on_the_genomic_accession=19485641, orientation='minus', exon_count=14, OMIM=601572, no_hdr0=''),
  833 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=833, CurrentID=0, Status='live', Symbol='CARS', Aliases='CARS1, CYSRS, MGC:11246', description='cysteinyl-tRNA synthetase', other_designations='cysteine tRNA ligase 1, cytoplasmic|cysteine translase', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=3000922, end_position_on_the_genomic_accession=3057451, orientation='minus', exon_count=23, OMIM=123859, no_hdr0=''),
  834 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=834, CurrentID=0, Status='live', Symbol='CASP1', Aliases='ICE, IL1BC, P45', description='caspase 1', other_designations='CASP1 nirs variant 1|IL-1 beta-converting enzyme|IL1B-convertase|caspase 1, apoptosis-related cysteine peptidase (interleukin 1, beta, convertase)|interleukin 1, beta, convertase|interleukin 1-B converting enzyme', map_location='11q23', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=105025508, end_position_on_the_genomic_accession=105036662, orientation='minus', exon_count=11, OMIM=147678, no_hdr0=''),
  835 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=835, CurrentID=0, Status='live', Symbol='CASP2', Aliases='CASP-2, ICH1, NEDD-2, NEDD2, PPP1R57', description='caspase 2', other_designations='caspase 2 apoptosis-related cysteine peptidase|neural precursor cell expressed developmentally down-regulated protein 2|protease ICH-1|protein phosphatase 1, regulatory subunit 57', map_location='7q34-q35', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=143288215, end_position_on_the_genomic_accession=143307696, orientation='plus', exon_count=13, OMIM=600639, no_hdr0=''),
  836 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=836, CurrentID=0, Status='live', Symbol='CASP3', Aliases='CPP32, CPP32B, SCA-1', description='caspase 3', other_designations='CASP-3|CPP-32|PARP cleavage protease|SREBP cleavage activity 1|apopain|caspase 3, apoptosis-related cysteine peptidase|caspase 3, apoptosis-related cysteine protease|cysteine protease CPP32|procaspase3|protein Yama', map_location='4q34', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=184627696, end_position_on_the_genomic_accession=184649475, orientation='minus', exon_count=8, OMIM=600636, no_hdr0=''),
  837 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=837, CurrentID=0, Status='live', Symbol='CASP4', Aliases='ICE(rel)II, ICEREL-II, ICH-2, Mih1/TX, TX', description='caspase 4', other_designations='CASP-4|ICE(rel)-II|apoptotic cysteine protease Mih1/TX|caspase 4, apoptosis-related cysteine peptidase|caspase 4, apoptosis-related cysteine protease|protease ICH-2|protease TX', map_location='11q22.2-q22.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=104942866, end_position_on_the_genomic_accession=104968598, orientation='minus', exon_count=10, OMIM=602664, no_hdr0=''),
  838 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=838, CurrentID=0, Status='live', Symbol='CASP5', Aliases='ICE(rel)III, ICEREL-III, ICH-3', description='caspase 5', other_designations='CASP-5|ICE(rel)-III|TY protease|caspase 5, apoptosis-related cysteine peptidase|caspase 5, apoptosis-related cysteine protease|protease ICH-3|protease TY', map_location='11q22.2-q22.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=104992633, end_position_on_the_genomic_accession=105023221, orientation='minus', exon_count=10, OMIM=602665, no_hdr0=''),
  839 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=839, CurrentID=0, Status='live', Symbol='CASP6', Aliases='MCH2', description='caspase 6', other_designations='apoptotic protease MCH-2|caspase 6, apoptosis-related cysteine peptidase|caspase 6, apoptosis-related cysteine protease', map_location='4q25', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=109688628, end_position_on_the_genomic_accession=109713904, orientation='minus', exon_count=8, OMIM=601532, no_hdr0=''),
  840 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=840, CurrentID=0, Status='live', Symbol='CASP7', Aliases='CASP-7, CMH-1, ICE-LAP3, LICE2, MCH3', description='caspase 7', other_designations='ICE-like apoptotic protease 3|apoptotic protease MCH-3|caspase 7, apoptosis-related cysteine peptidase|caspase 7, apoptosis-related cysteine protease', map_location='10q25', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=113679162, end_position_on_the_genomic_accession=113730909, orientation='plus', exon_count=12, OMIM=601761, no_hdr0=''),
  841 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=841, CurrentID=0, Status='live', Symbol='CASP8', Aliases='ALPS2B, CAP4, Casp-8, FLICE, MACH, MCH5', description='caspase 8', other_designations='FADD-homologous ICE/CED-3-like protease|FADD-like ICE|ICE-like apoptotic protease 5|MACH-alpha-1/2/3 protein|MACH-beta-1/2/3/4 protein|MORT1-associated ced-3 homolog|apoptotic cysteine protease|apoptotic protease Mch-5|caspase 8, apoptosis-related cysteine peptidase|caspase 8, apoptosis-related cysteine protease', map_location='2q33-q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=201233443, end_position_on_the_genomic_accession=201287711, orientation='plus', exon_count=16, OMIM=601763, no_hdr0=''),
  842 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=842, CurrentID=0, Status='live', Symbol='CASP9', Aliases='APAF-3, APAF3, ICE-LAP6, MCH6, PPP1R56', description='caspase 9', other_designations='ICE-like apoptotic protease 6|apoptotic protease MCH-6|apoptotic protease activating factor 3|caspase 9, apoptosis-related cysteine peptidase|protein phosphatase 1, regulatory subunit 56', map_location='1p36.21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=15491401, end_position_on_the_genomic_accession=15526529, orientation='minus', exon_count=14, OMIM=602234, no_hdr0=''),
  843 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=843, CurrentID=0, Status='live', Symbol='CASP10', Aliases='ALPS2, FLICE2, MCH4', description='caspase 10', other_designations='CASP-10|FADD-like ICE2|FAS-associated death domain protein interleukin-1B-converting enzyme 2|ICE-like apoptotic protease 4|apoptotic protease MCH-4|caspase 10 apoptosis-related cysteine peptidase|caspase 10, apoptosis-related cysteine peptidase|caspase 10, apoptosis-related cysteine protease|interleukin-1B-converting enzyme 2', map_location='2q33-q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=201182898, end_position_on_the_genomic_accession=201229406, orientation='plus', exon_count=13, OMIM=601762, no_hdr0=''),
  844 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=844, CurrentID=0, Status='live', Symbol='CASQ1', Aliases='CASQ, PDIB1, VMCQA', description='calsequestrin 1', other_designations='calmitin|calmitine|calsequestrin 1 (fast-twitch, skeletal muscle)|calsequestrin, skeletal muscle isoform', map_location='1q21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160190495, end_position_on_the_genomic_accession=160201886, orientation='plus', exon_count=11, OMIM=114250, no_hdr0=''),
  845 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=845, CurrentID=0, Status='live', Symbol='CASQ2', Aliases='PDIB2', description='calsequestrin 2', other_designations='calsequestrin 2 (cardiac muscle)|calsequestrin 2, fast-twitch, cardiac muscle|calsequestrin, cardiac muscle isoform', map_location='1p13.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=115700003, end_position_on_the_genomic_accession=115768805, orientation='minus', exon_count=11, OMIM=114251, no_hdr0=''),
  846 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=846, CurrentID=0, Status='live', Symbol='CASR', Aliases='CAR, EIG8, FHH, FIH, GPRC2A, HHC, HHC1, HYPOC1, NSHPT, PCAR1', description='calcium sensing receptor', other_designations='calcium-sensing receptor|parathyroid Ca(2+)-sensing receptor 1|parathyroid cell calcium-sensing receptor 1', map_location='3q13', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=122183667, end_position_on_the_genomic_accession=122286503, orientation='plus', exon_count=12, OMIM=601199, no_hdr0=''),
  847 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=847, CurrentID=0, Status='live', Symbol='CAT', Aliases='', description='catalase', other_designations='', map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=34438925, end_position_on_the_genomic_accession=34472060, orientation='plus', exon_count=13, OMIM=115500, no_hdr0=''),
  131920 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131920, CurrentID=0, Status='live', Symbol='TMEM207', Aliases='UNQ846', description='transmembrane protein 207', other_designations='SRSR846', map_location='3q28', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=190428655, end_position_on_the_genomic_accession=190449876, orientation='minus', exon_count=6, OMIM=614786, no_hdr0=''),
  284131 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284131, CurrentID=0, Status='live', Symbol='ENDOV', Aliases='', description='endonuclease V', other_designations='hEndoV|inosine-specific endoribonuclease', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=80415117, end_position_on_the_genomic_accession=80438086, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  404281 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=404281, CurrentID=0, Status='live', Symbol='YY2', Aliases='ZNF631', description='YY2 transcription factor', other_designations='transcription factor yin yang 2|yin and yang 2|zinc finger protein 631', map_location='Xp22.2-p22.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=21855987, end_position_on_the_genomic_accession=21858727, orientation='plus', exon_count=1, OMIM=300570, no_hdr0=''),
  857 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=857, CurrentID=0, Status='live', Symbol='CAV1', Aliases='BSCL3, CGL3, LCCNS, MSTP085, PPH3, VIP21', description='caveolin 1', other_designations='caveolin 1, caveolae protein, 22kDa|cell growth-inhibiting protein 32', map_location='7q31.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=116524785, end_position_on_the_genomic_accession=116561185, orientation='plus', exon_count=4, OMIM=601047, no_hdr0=''),
  858 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=858, CurrentID=0, Status='live', Symbol='CAV2', Aliases='CAV', description='caveolin 2', other_designations='caveolae protein, 20-kD|caveolin 2 isoform a and b', map_location='7q31.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=116499601, end_position_on_the_genomic_accession=116508541, orientation='plus', exon_count=3, OMIM=601048, no_hdr0=''),
  859 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=859, CurrentID=0, Status='live', Symbol='CAV3', Aliases='LGMD1C, LQT9, VIP-21, VIP21', description='caveolin 3', other_designations='M-caveolin', map_location='3p25', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=8733800, end_position_on_the_genomic_accession=8746765, orientation='plus', exon_count=2, OMIM=601253, no_hdr0=''),
  860 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=860, CurrentID=0, Status='live', Symbol='RUNX2', Aliases='AML3, CBF-alpha-1, CBFA1, CCD, CCD1, CLCD, OSF-2, OSF2, PEA2aA, PEBP2aA', description='runt related transcription factor 2', other_designations='PEA2-alpha A|PEBP2-alpha A|SL3-3 enhancer factor 1 alpha A subunit|SL3/AKV core-binding factor alpha A subunit|acute myeloid leukemia 3 protein|core-binding factor, runt domain, alpha subunit 1|oncogene AML-3|osteoblast-specific transcription factor 2|polyomavirus enhancer-binding protein 2 alpha A subunit', map_location='6p21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=45327800, end_position_on_the_genomic_accession=45664032, orientation='plus', exon_count=16, OMIM=600211, no_hdr0=''),
  861 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=861, CurrentID=0, Status='live', Symbol='RUNX1', Aliases='AML1, AML1-EVI-1, AMLCR1, CBF2alpha, CBFA2, EVI-1, PEBP2aB, PEBP2alpha', description='runt related transcription factor 1', other_designations='AML1-EVI-1 fusion protein|CBF-alpha-2|PEA2-alpha B|PEBP2-alpha B|SL3-3 enhancer factor 1 alpha B subunit|SL3/AKV core-binding factor alpha B subunit|acute myeloid leukemia 1 protein|core-binding factor, runt domain, alpha subunit 2|oncogene AML-1|polyomavirus enhancer-binding protein 2 alpha B subunit|transcription factor', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=34787801, end_position_on_the_genomic_accession=35049310, orientation='minus', exon_count=13, OMIM=151385, no_hdr0=''),
  862 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=862, CurrentID=0, Status='live', Symbol='RUNX1T1', Aliases='AML1-MTG8, AML1T1, CBFA2T1, CDR, ETO, MTG8, ZMYND2', description='runt related transcription factor 1; translocated to, 1 (cyclin D related)', other_designations='CBFA2T1 isoform r1t1-11a61|CBFA2T1 isoform r1t1-11a62|CBFA2T1 isoform r1t1-11a63|CBFA2T1 isoform r1t1-11a64|CBFA2T1 isoform r1t1-11a65|CBFA2T1 isoform r1t1-7a47|CBFA2T1 isoform r1t1-7a48|CBFA2T1 isoform r1t1-7a49|CBFA2T1 isoform r1t1-7a50|CBFA2T1 isoform r1t1-7a51|CBFA2T1 isoform r1t1-7a52|CBFA2T1 isoform r1t1-7d53|CBFA2T1 isoform r1t1-7d54|CBFA2T1 isoform r1t1-7d55|CBFA2T1 isoform r1t1-7d56|CBFA2T1 isoform r1t1-8a57|CBFA2T1 isoform r1t1-8a58|CBFA2T1 isoform r1t1-8a59|CBFA2T1 isoform r1t1-8a60|acute myelogenous leukemia 1 translocation 1, cyclin-D related|core-binding factor, runt domain, alpha subunit 2; translocated to, 1; cyclin D-related|eight twenty one protein|myeloid translocation gene on 8q22|runt-related transcription factor 1; translocated to, 1 (cyclin D-related)|zinc finger MYND domain-containing protein 2', map_location='8q22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=91954967, end_position_on_the_genomic_accession=92103226, orientation='minus', exon_count=18, OMIM=133435, no_hdr0=''),
  863 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=863, CurrentID=0, Status='live', Symbol='CBFA2T3', Aliases='ETO2, MTG16, MTGR2, ZMYND4', description='core-binding factor, runt domain, alpha subunit 2; translocated to, 3', other_designations='MTG8-related gene 2|MTG8-related protein 2|myeloid translocation gene 8 and 16b|myeloid translocation gene on chromosome 16 protein|zinc finger MYND domain-containing protein 4', map_location='16q24', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=88874855, end_position_on_the_genomic_accession=88977199, orientation='minus', exon_count=16, OMIM=603870, no_hdr0=''),
  864 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=864, CurrentID=0, Status='live', Symbol='RUNX3', Aliases='AML2, CBFA3, PEBP2aC', description='runt related transcription factor 3', other_designations='CBF-alpha-3|PEA2 alpha C|PEA2-alpha C|PEBP2 alpha C|PEBP2-alpha C|SL3-3 enhancer factor 1 alpha C subunit|SL3/AKV core-binding factor alpha C subunit|acute myeloid leukemia 2 protein|acute myeloid leukemia gene 2|core-binding factor subunit alpha-3|core-binding factor, runt domain, alpha subunit 3|oncogene AML-2|polyomavirus enhancer-binding protein 2 alpha C subunit|transcription factor AML2', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=24899511, end_position_on_the_genomic_accession=24965157, orientation='minus', exon_count=7, OMIM=600210, no_hdr0=''),
  865 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=865, CurrentID=0, Status='live', Symbol='CBFB', Aliases='PEBP2B', description='core-binding factor, beta subunit', other_designations='CBF-beta|PEA2-beta|PEBP2-beta|SL3-3 enhancer factor 1 beta subunit|SL3-3 enhancer factor 1 subunit beta|SL3/AKV core-binding factor beta subunit|polyomavirus enhancer binding protein 2, beta subunit|polyomavirus enhancer-binding protein 2 beta subunit', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=67029147, end_position_on_the_genomic_accession=67101058, orientation='plus', exon_count=6, OMIM=121360, no_hdr0=''),
  866 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=866, CurrentID=0, Status='live', Symbol='SERPINA6', Aliases='CBG', description='serpin peptidase inhibitor, clade A (alpha-1 antiproteinase, antitrypsin), member 6', other_designations='corticosteroid binding globulin|serine (or cysteine) proteinase inhibitor, clade A (alpha-1 antiproteinase, antitrypsin), member 6|serpin A6|transcortin', map_location='14q32.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=94304248, end_position_on_the_genomic_accession=94323351, orientation='minus', exon_count=5, OMIM=122500, no_hdr0=''),
  867 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=867, CurrentID=0, Status='live', Symbol='CBL', Aliases='C-CBL2, FRA11B, NSLL, RNF55, CBL', description='Cbl proto-oncogene, E3 ubiquitin protein ligase', other_designations='Cas-Br-M (murine) ecotropic retroviral transforming sequence|RING finger protein 55|casitas B-lineage lymphoma proto-oncogene|fragile site, folic acid type, rare, fra(11)(q23.3)|oncogene CBL2|proto-oncogene c-Cbl|signal transduction protein CBL', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=119206276, end_position_on_the_genomic_accession=119308149, orientation='plus', exon_count=17, OMIM=165360, no_hdr0=''),
  868 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=868, CurrentID=0, Status='live', Symbol='CBLB', Aliases='Cbl-b, Nbla00127, RNF56', description='Cbl proto-oncogene B, E3 ubiquitin protein ligase', other_designations='Cas-Br-M (murine) ecotropic retroviral transforming sequence b|Cas-Br-M (murine) ectropic retroviral transforming sequence b|Cbl proto-oncogene, E3 ubiquitin protein ligase B|RING finger protein 56|SH3-binding protein CBL-B|casitas B-lineage lymphoma proto-oncogene b|signal transduction protein CBL-B', map_location='3q13.11', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=105655461, end_position_on_the_genomic_accession=105869552, orientation='minus', exon_count=22, OMIM=604491, no_hdr0=''),
  103910 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=103910, CurrentID=0, Status='live', Symbol='MYL12B', Aliases='MLC-B, MRLC2', description='myosin light chain 12B', other_designations='MLC-2|MLC-2A|MLC20|SHUJUN-1|myosin regulatory light chain 2|myosin regulatory light chain 2-B, smooth muscle isoform|myosin regulatory light chain 20 kDa|myosin regulatory light chain MRLC2|myosin, light chain 12B, regulatory', map_location='18p11.31', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=3262113, end_position_on_the_genomic_accession=3278284, orientation='plus', exon_count=5, OMIM=609211, no_hdr0=''),
  871 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=871, CurrentID=0, Status='live', Symbol='SERPINH1', Aliases='AsTP3, CBP1, CBP2, HSP47, OI10, PIG14, PPROM, RA-A47, SERPINH2, gp46', description='serpin peptidase inhibitor, clade H (heat shock protein 47), member 1, (collagen binding protein 1)', other_designations='47 kDa heat shock protein|arsenic-transactivated protein 3|cell proliferation-inducing gene 14 protein|colligin-1|colligin-2|rheumatoid arthritis antigen A-47|rheumatoid arthritis-related antigen RA-A47|serine (or cysteine) proteinase inhibitor, clade H (heat shock protein 47), member 1, (collagen binding protein 1)|serine (or cysteine) proteinase inhibitor, clade H (heat shock protein 47), member 2, (collagen-binding protein 2)', map_location='11q13.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=75562056, end_position_on_the_genomic_accession=75572804, orientation='plus', exon_count=8, OMIM=600943, no_hdr0=''),
  873 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=873, CurrentID=0, Status='live', Symbol='CBR1', Aliases='CBR, SDR21C1, hCBR1', description='carbonyl reductase 1', other_designations='15-hydroxyprostaglandin dehydrogenase|NADPH-dependent carbonyl reductase 1|carbonyl reductase (NADPH) 1|prostaglandin 9-ketoreductase|prostaglandin-E(2) 9-reductase|short chain dehydrogenase/reductase family 21C member 1|short chain dehydrogenase/reductase family 21C, member 1', map_location='21q22.13', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=36069924, end_position_on_the_genomic_accession=36073177, orientation='plus', exon_count=3, OMIM=114830, no_hdr0=''),
  874 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=874, CurrentID=0, Status='live', Symbol='CBR3', Aliases='HEL-S-25, SDR21C2, hCBR3', description='carbonyl reductase 3', other_designations='NADPH-dependent carbonyl reductase 3|carbonyl reductase (NADPH) 3|epididymis secretory protein Li 25|short chain dehydrogenase/reductase family 21C member 2|short chain dehydrogenase/reductase family 21C, member 2', map_location='21q22.2', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=36134900, end_position_on_the_genomic_accession=36146562, orientation='plus', exon_count=4, OMIM=603608, no_hdr0=''),
  875 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=875, CurrentID=0, Status='live', Symbol='CBS', Aliases='HIP4', description='cystathionine-beta-synthase', other_designations='beta-thionase|methylcysteine synthase|serine sulfhydrase', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=43053191, end_position_on_the_genomic_accession=43076868, orientation='minus', exon_count=24, OMIM=613381, no_hdr0=''),
  100533105 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100533105, CurrentID=0, Status='live', Symbol='C8orf44-SGK3', Aliases='', description='C8orf44-SGK3 readthrough', other_designations='cytokine-independent survival kinase|serum/glucocorticoid-regulated kinase 3', map_location='', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=66667552, end_position_on_the_genomic_accession=66862022, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  100533106 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100533106, CurrentID=0, Status='live', Symbol='ZHX1-C8orf76', Aliases='', description='ZHX1-C8orf76 readthrough', other_designations='ZHX1-C8orf76 readthrough transcript protein', map_location='8q', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=123226189, end_position_on_the_genomic_accession=123274487, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  883 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=883, CurrentID=0, Status='live', Symbol='CCBL1', Aliases='GTK, KAT1, KATI', description='cysteine conjugate-beta lyase, cytoplasmic', other_designations='beta-lysase, kidney|cysteine conjugate-beta lyase; cytoplasmic (glutamine transaminase K, kyneurenine aminotransferase)|cysteine-S-conjugate beta-lyase|glutamine transaminase K|glutamine--phenylpyruvate transaminase|glutamine-phenylpyruvate aminotransferase|kyneurenine aminotransferase|kynurenine aminotransferase I|kynurenine--oxoglutarate transaminase I', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=128832942, end_position_on_the_genomic_accession=128882513, orientation='minus', exon_count=19, OMIM=600547, no_hdr0=''),
  885 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=885, CurrentID=0, Status='live', Symbol='CCK', Aliases='', description='cholecystokinin', other_designations='cholecystokinin triacontatriapeptide|prepro-cholecystokinin', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=42257826, end_position_on_the_genomic_accession=42266170, orientation='minus', exon_count=6, OMIM=118440, no_hdr0=''),
  886 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=886, CurrentID=0, Status='live', Symbol='CCKAR', Aliases='CCK-A, CCK1-R, CCK1R, CCKRA', description='cholecystokinin A receptor', other_designations='CCK-A receptor|CCK-AR|cholecystokinin type-A receptor|cholecystokinin-1 receptor', map_location='4p15.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=26481396, end_position_on_the_genomic_accession=26490420, orientation='minus', exon_count=5, OMIM=118444, no_hdr0=''),
  887 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=887, CurrentID=0, Status='live', Symbol='CCKBR', Aliases='CCK-B, CCK2R, GASR', description='cholecystokinin B receptor', other_designations='CCK-B receptor|CCK-BR|CCK2 receptor|CCK2-R|cholecystokinin-2 receptor|gastrin receptor', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=6259611, end_position_on_the_genomic_accession=6272127, orientation='plus', exon_count=5, OMIM=118445, no_hdr0=''),
  889 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=889, CurrentID=0, Status='live', Symbol='KRIT1', Aliases='CAM, CCM1', description='KRIT1, ankyrin repeat containing', other_designations='ankyrin repeat-containing protein Krit1|cerebral cavernous malformations 1 protein|krev interaction trapped 1', map_location='7q21.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=92198969, end_position_on_the_genomic_accession=92246128, orientation='minus', exon_count=20, OMIM=604214, no_hdr0=''),
  890 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=890, CurrentID=0, Status='live', Symbol='CCNA2', Aliases='CCN1, CCNA', description='cyclin A2', other_designations='cyclin-A', map_location='4q27', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=121816444, end_position_on_the_genomic_accession=121823933, orientation='minus', exon_count=8, OMIM=123835, no_hdr0=''),
  891 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=891, CurrentID=0, Status='live', Symbol='CCNB1', Aliases='CCNB', description='cyclin B1', other_designations='G2/mitotic-specific cyclin B1', map_location='5q12', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=69167010, end_position_on_the_genomic_accession=69178245, orientation='plus', exon_count=9, OMIM=123836, no_hdr0=''),
  892 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=892, CurrentID=0, Status='live', Symbol='CCNC', Aliases='CycC', description='cyclin C', other_designations='SRB11 homolog|hSRB11', map_location='6q21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=99542387, end_position_on_the_genomic_accession=99568973, orientation='minus', exon_count=14, OMIM=123838, no_hdr0=''),
  131965 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=131965, CurrentID=0, Status='live', Symbol='METTL6', Aliases='', description='methyltransferase like 6', other_designations='', map_location='3p25.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=15381063, end_position_on_the_genomic_accession=15427547, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  894 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=894, CurrentID=0, Status='live', Symbol='CCND2', Aliases='KIAK0002, MPPH3', description='cyclin D2', other_designations='', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=4273733, end_position_on_the_genomic_accession=4305356, orientation='plus', exon_count=6, OMIM=123833, no_hdr0=''),
  100129763 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100129763, CurrentID=0, Status='live', Symbol='LOC100129763', Aliases='', description='uncharacterized LOC100129763', other_designations='', map_location='4p16.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.10', start_position_on_the_genomic_accession=8294512, end_position_on_the_genomic_accession=8295185, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  896 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=896, CurrentID=0, Status='live', Symbol='CCND3', Aliases='', description='cyclin D3', other_designations='D3-type cyclin', map_location='6p21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=41934933, end_position_on_the_genomic_accession=42048894, orientation='minus', exon_count=7, OMIM=123834, no_hdr0=''),
  898 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=898, CurrentID=0, Status='live', Symbol='CCNE1', Aliases='CCNE, pCCNE1', description='cyclin E1', other_designations='cyclin E variant ex5del|cyclin E variant ex7del|cyclin Es|cyclin Et|pluripotent specific cyclin E1', map_location='19q12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=29811898, end_position_on_the_genomic_accession=29824312, orientation='plus', exon_count=12, OMIM=123837, no_hdr0=''),
  899 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=899, CurrentID=0, Status='live', Symbol='CCNF', Aliases='FBX1, FBXO1', description='cyclin F', other_designations='F-box only protein 1|G2/mitotic-specific cyclin-F', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2429394, end_position_on_the_genomic_accession=2458858, orientation='plus', exon_count=17, OMIM=600227, no_hdr0=''),
  900 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=900, CurrentID=0, Status='live', Symbol='CCNG1', Aliases='CCNG', description='cyclin G1', other_designations='cyclin-G', map_location='5q32-q34', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=163437270, end_position_on_the_genomic_accession=163445016, orientation='plus', exon_count=8, OMIM=601578, no_hdr0=''),
  901 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=901, CurrentID=0, Status='live', Symbol='CCNG2', Aliases='', description='cyclin G2', other_designations='', map_location='4q21.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=77157204, end_position_on_the_genomic_accession=77170060, orientation='plus', exon_count=10, OMIM=603203, no_hdr0=''),
  902 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=902, CurrentID=0, Status='live', Symbol='CCNH', Aliases='CAK, CycH, p34, p37', description='cyclin H', other_designations='CAK complex subunit|CDK-activating kinase complex subunit|MO15-associated protein|cyclin-dependent kinase-activating kinase complex subunit', map_location='5q13.3-q14', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=87391493, end_position_on_the_genomic_accession=87413033, orientation='minus', exon_count=10, OMIM=601953, no_hdr0=''),
  904 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=904, CurrentID=0, Status='live', Symbol='CCNT1', Aliases='CCNT, CYCT1, HIVE1', description='cyclin T1', other_designations='CDK9-associated C-type protein|cyclin C-related protein|human immunodeficiency virus type 1 (HIV-1) expression (elevated) 1', map_location='12q13.11', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=48688458, end_position_on_the_genomic_accession=48716998, orientation='minus', exon_count=9, OMIM=143055, no_hdr0=''),
  905 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=905, CurrentID=0, Status='live', Symbol='CCNT2', Aliases='CYCT2', description='cyclin T2', other_designations='SDS-stable vimentin-bound DNA fragment HEF42VIM22|cyclin T2a|cyclin T2b|subunit of positive elongation transcription factor b', map_location='2q21.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=134918822, end_position_on_the_genomic_accession=134959345, orientation='plus', exon_count=12, OMIM=603862, no_hdr0=''),
  100303755 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100303755, CurrentID=0, Status='live', Symbol='PET117', Aliases='CSRP2BP', description='PET117 homolog', other_designations='alternative protein CSRP2BP', map_location='20p11.23', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=18137855, end_position_on_the_genomic_accession=18143169, orientation='plus', exon_count=2, OMIM=614771, no_hdr0=''),
  908 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=908, CurrentID=0, Status='live', Symbol='CCT6A', Aliases='CCT-zeta, CCT-zeta-1, CCT6, Cctz, HTR3, MoDP-2, TCP-1-zeta, TCP20, TCPZ, TTCP20', description='chaperonin containing TCP1 subunit 6A', other_designations='T-complex protein 1, zeta subunit|acute morphine dependence related protein 2|acute morphine dependence-related protein 2|amino acid transport defect-complementing|chaperonin containing T-complex subunit 6|chaperonin containing TCP1, subunit 6A (zeta 1)|histidine transport regulator 3', map_location='7p11.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=56051685, end_position_on_the_genomic_accession=56063989, orientation='plus', exon_count=14, OMIM=104613, no_hdr0=''),
  909 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=909, CurrentID=0, Status='live', Symbol='CD1A', Aliases='CD1, FCB6, HTA1, R4, T6', description='CD1a molecule', other_designations='CD1A antigen, a polypeptide|T-cell surface antigen T6/Leu-6|cluster of differentiation 1 A|cortical thymocyte antigen CD1A|differentiation antigen CD1-alpha-3|epidermal dendritic cell marker CD1a|hTa1 thymocyte antigen', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158248329, end_position_on_the_genomic_accession=158258269, orientation='plus', exon_count=7, OMIM=188370, no_hdr0=''),
  910 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=910, CurrentID=0, Status='live', Symbol='CD1B', Aliases='CD1, CD1A, R1', description='CD1b molecule', other_designations='CD1B antigen, b polypeptide|cortical thymocyte antigen CD1B|differentiation antigen CD1-alpha-3', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158327950, end_position_on_the_genomic_accession=158331531, orientation='minus', exon_count=6, OMIM=188360, no_hdr0=''),
  911 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=911, CurrentID=0, Status='live', Symbol='CD1C', Aliases='BDCA1, CD1, CD1A, R7', description='CD1c molecule', other_designations='CD1C antigen, c polypeptide|cortical thymocyte antigen CD1C|differentiation antigen CD1-alpha-3', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158289773, end_position_on_the_genomic_accession=158294774, orientation='plus', exon_count=6, OMIM=188340, no_hdr0=''),
  912 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=912, CurrentID=0, Status='live', Symbol='CD1D', Aliases='CD1A, R3, R3G1', description='CD1d molecule', other_designations='CD1D antigen, d polypeptide|HMC class I antigen-like glycoprotein CD1D|T-cell surface glycoprotein CD1d|differentiation antigen CD1-alpha-3|thymocyte antigen CD1D', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158178038, end_position_on_the_genomic_accession=158186427, orientation='plus', exon_count=8, OMIM=188410, no_hdr0=''),
  913 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=913, CurrentID=0, Status='live', Symbol='CD1E', Aliases='CD1A, R2', description='CD1e molecule', other_designations='CD1E antigen, e polypeptide|R2G1|differentiation antigen CD1-alpha-3|hCD1e|leukocyte differentiation antigen|thymocyte antigen CD1E', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158353435, end_position_on_the_genomic_accession=158357553, orientation='plus', exon_count=6, OMIM=188411, no_hdr0=''),
  914 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=914, CurrentID=0, Status='live', Symbol='CD2', Aliases='LFA-2, SRBC, T11', description='CD2 molecule', other_designations='CD2 antigen (p50), sheep red blood cell receptor|LFA-3 receptor|T-cell surface antigen T11/Leu-5|erythrocyte receptor|lymphocyte-function antigen-2|rosette receptor', map_location='1p13.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=116754435, end_position_on_the_genomic_accession=116769229, orientation='plus', exon_count=5, OMIM=186990, no_hdr0=''),
  915 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=915, CurrentID=0, Status='live', Symbol='CD3D', Aliases='CD3-DELTA, IMD19, T3D', description='CD3d molecule', other_designations='CD3 antigen, delta subunit|CD3 delta|CD3d antigen, delta polypeptide (TiT3 complex)|CD3d molecule, delta (CD3-TCR complex)|OKT3, delta chain|T-cell receptor T3 delta chain', map_location='11q23', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118339074, end_position_on_the_genomic_accession=118342744, orientation='minus', exon_count=5, OMIM=186790, no_hdr0=''),
  916 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=916, CurrentID=0, Status='live', Symbol='CD3E', Aliases='IMD18, T3E, TCRE', description='CD3e molecule', other_designations='CD3-epsilon|CD3e antigen, epsilon polypeptide (TiT3 complex)|CD3e molecule, epsilon (CD3-TCR complex)|T-cell antigen receptor complex, epsilon subunit of T3|T-cell surface antigen T3/Leu-4 epsilon chain', map_location='11q23', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118304580, end_position_on_the_genomic_accession=118316175, orientation='plus', exon_count=9, OMIM=186830, no_hdr0=''),
  917 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=917, CurrentID=0, Status='live', Symbol='CD3G', Aliases='CD3-GAMMA, IMD17, T3G', description='CD3g molecule', other_designations='CD3g antigen, gamma polypeptide (TiT3 complex)|CD3g molecule, epsilon (CD3-TCR complex)|CD3g molecule, gamma (CD3-TCR complex)|T-cell antigen receptor complex, gamma subunit of T3|T-cell receptor T3 gamma chain', map_location='11q23', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118344316, end_position_on_the_genomic_accession=118353782, orientation='plus', exon_count=7, OMIM=186740, no_hdr0=''),
  80774 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=80774, CurrentID=0, Status='live', Symbol='LIMD2', Aliases='', description='LIM domain containing 2', other_designations='', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63695889, end_position_on_the_genomic_accession=63701769, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  919 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=919, CurrentID=0, Status='live', Symbol='CD247', Aliases='CD3-ZETA, CD3H, CD3Q, CD3Z, IMD25, T3Z, TCRZ', description='CD247 molecule', other_designations='CD247 antigen, zeta subunit|CD3Z antigen, zeta polypeptide (TiT3 complex)|CD3zeta chain|T-cell antigen receptor complex, zeta subunit of CD3|T-cell receptor T3 zeta chain|TCR zeta chain', map_location='1q24.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=167430640, end_position_on_the_genomic_accession=167518616, orientation='minus', exon_count=9, OMIM=186780, no_hdr0=''),
  920 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=920, CurrentID=0, Status='live', Symbol='CD4', Aliases='CD4mut', description='CD4 molecule', other_designations='CD4 antigen (p55)|CD4 receptor|T-cell surface antigen T4/Leu-3', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6789472, end_position_on_the_genomic_accession=6820810, orientation='plus', exon_count=10, OMIM=186940, no_hdr0=''),
  921 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=921, CurrentID=0, Status='live', Symbol='CD5', Aliases='LEU1, T1', description='CD5 molecule', other_designations='CD5 antigen (p56-62)|lymphocyte antigen T1/Leu-1', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61102458, end_position_on_the_genomic_accession=61127852, orientation='plus', exon_count=11, OMIM=153340, no_hdr0=''),
  922 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=922, CurrentID=0, Status='live', Symbol='CD5L', Aliases='AIM, API6, CT-2, PRO229, SP-ALPHA, Spalpha', description='CD5 molecule like', other_designations='CD5 antigen-like (scavenger receptor cysteine rich family)|CD5 molecule-like|apoptosis inhibitor 6|apoptosis inhibitor of macrophage|igM-associated peptide', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=157827071, end_position_on_the_genomic_accession=157841844, orientation='minus', exon_count=7, OMIM=602592, no_hdr0=''),
  923 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=923, CurrentID=0, Status='live', Symbol='CD6', Aliases='TP120', description='CD6 molecule', other_designations='CD6 antigen|T12', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=60971641, end_position_on_the_genomic_accession=61020377, orientation='plus', exon_count=13, OMIM=186720, no_hdr0=''),
  924 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=924, CurrentID=0, Status='live', Symbol='CD7', Aliases='GP40, LEU-9, TP41, Tp40', description='CD7 molecule', other_designations='CD7 antigen (p41)|T-cell leukemia antigen|T-cell surface antigen Leu-9|p41 protein', map_location='17q25.2-q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=82314865, end_position_on_the_genomic_accession=82317604, orientation='minus', exon_count=4, OMIM=186820, no_hdr0=''),
  925 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=925, CurrentID=0, Status='live', Symbol='CD8A', Aliases='CD8, Leu2, MAL, p32', description='CD8a molecule', other_designations='CD8 antigen, alpha polypeptide (p32)|Leu2 T-lymphocyte antigen|OKT8 T-cell antigen|T cell co-receptor|T-cell antigen Leu2|T-lymphocyte differentiation antigen T8/Leu-2|T8 T-cell antigen', map_location='2p12', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=86784605, end_position_on_the_genomic_accession=86808396, orientation='minus', exon_count=10, OMIM=186910, no_hdr0=''),
  926 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=926, CurrentID=0, Status='live', Symbol='CD8B', Aliases='CD8B1, LEU2, LY3, LYT3, P37', description='CD8b molecule', other_designations='CD8 antigen, beta polypeptide 1 (p37)|T lymphocyte surface glycoprotein beta chain', map_location='2p12', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=86815337, end_position_on_the_genomic_accession=86861924, orientation='minus', exon_count=8, OMIM=186730, no_hdr0=''),
  928 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=928, CurrentID=0, Status='live', Symbol='CD9', Aliases='BTCC-1, DRAP-27, MIC3, MRP-1, TSPAN-29, TSPAN29', description='CD9 molecule', other_designations='5H9 antigen|BA-2/p24 antigen|CD9 antigen (p24)|cell growth-inhibiting gene 2 protein|leukocyte antigen MIC3|motility related protein-1|tetraspanin-29', map_location='12p13.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6199844, end_position_on_the_genomic_accession=6238271, orientation='plus', exon_count=9, OMIM=143030, no_hdr0=''),
  929 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=929, CurrentID=0, Status='live', Symbol='CD14', Aliases='', description='CD14 molecule', other_designations='myeloid cell-specific leucine-rich glycoprotein', map_location='5q31.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=140631728, end_position_on_the_genomic_accession=140633701, orientation='minus', exon_count=3, OMIM=158120, no_hdr0=''),
  930 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=930, CurrentID=0, Status='live', Symbol='CD19', Aliases='B4, CVID3', description='CD19 molecule', other_designations='B-lymphocyte surface antigen B4|T-cell surface antigen Leu-12|differentiation antigen CD19', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=28931916, end_position_on_the_genomic_accession=28939347, orientation='plus', exon_count=15, OMIM=107265, no_hdr0=''),
  931 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=931, CurrentID=0, Status='live', Symbol='MS4A1', Aliases='B1, Bp35, CD20, CVID5, LEU-16, MS4A2, S7', description='membrane spanning 4-domains A1', other_designations='B-lymphocyte cell-surface antigen B1|CD20 antigen|CD20 receptor|leukocyte surface antigen Leu-16|membrane-spanning 4-domains subfamily A member 1|membrane-spanning 4-domains, subfamily A, member 1', map_location='11q12', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=60455809, end_position_on_the_genomic_accession=60470752, orientation='plus', exon_count=8, OMIM=112210, no_hdr0=''),
  932 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=932, CurrentID=0, Status='live', Symbol='MS4A3', Aliases='CD20L, HTM4', description='membrane spanning 4-domains A3', other_designations='CD20 antigen homolog|CD20 antigen-like protein|IgE receptor beta chain|IgE receptor beta subunit|hematopoietic cell 4 transmembrane protein|hematopoietic-specific transmembrane protein 4|membrane-spanning 4-domains, subfamily A, member 3 (hematopoietic cell-specific)', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=60056628, end_position_on_the_genomic_accession=60071116, orientation='plus', exon_count=8, OMIM=606498, no_hdr0=''),
  933 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=933, CurrentID=0, Status='live', Symbol='CD22', Aliases='SIGLEC-2, SIGLEC2', description='CD22 molecule', other_designations='B-lymphocyte cell adhesion molecule|BL-CAM|CD22 antigen|T-cell surface antigen Leu-14|sialic acid binding Ig-like lectin 2|sialic acid-binding Ig-like lectin 2', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=35329166, end_position_on_the_genomic_accession=35347361, orientation='plus', exon_count=14, OMIM=107266, no_hdr0=''),
  939 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=939, CurrentID=0, Status='live', Symbol='CD27', Aliases='S152, S152. LPFS2, T14, TNFRSF7, Tp55', description='CD27 molecule', other_designations='CD27L receptor|T cell activation antigen S152|T-cell activation antigen CD27|tumor necrosis factor receptor superfamily, member 7', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6444885, end_position_on_the_genomic_accession=6451718, orientation='plus', exon_count=7, OMIM=186711, no_hdr0=''),
  940 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=940, CurrentID=0, Status='live', Symbol='CD28', Aliases='Tp44', description='CD28 molecule', other_designations='CD28 antigen', map_location='2q33', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=203706475, end_position_on_the_genomic_accession=203738912, orientation='plus', exon_count=4, OMIM=186760, no_hdr0=''),
  941 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=941, CurrentID=0, Status='live', Symbol='CD80', Aliases='B7, B7-1, B7.1, BB1, CD28LG, CD28LG1, LAB7', description='CD80 molecule', other_designations='B-lymphocyte activation antigen B7|CD80 antigen (CD28 antigen ligand 1, B7-1 antigen)|CTLA-4 counter-receptor B7.1|activation B7-1 antigen|costimulatory factor CD80|costimulatory molecule variant IgV-CD80', map_location='3q13.3-q21', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=119523948, end_position_on_the_genomic_accession=119559634, orientation='minus', exon_count=10, OMIM=112203, no_hdr0=''),
  942 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=942, CurrentID=0, Status='live', Symbol='CD86', Aliases='B7-2, B7.2, B70, CD28LG2, LAB72', description='CD86 molecule', other_designations='B-lymphocyte activation antigen B7-2|BU63|CD86 antigen (CD28 antigen ligand 2, B7-2 antigen)|CTLA-4 counter-receptor B7.2|FUN-1', map_location='3q21', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=122055362, end_position_on_the_genomic_accession=122121143, orientation='plus', exon_count=8, OMIM=601020, no_hdr0=''),
  943 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=943, CurrentID=0, Status='live', Symbol='TNFRSF8', Aliases='CD30, D1S166E, Ki-1', description='tumor necrosis factor receptor superfamily member 8', other_designations='CD30L receptor|Ki-1 antigen|cytokine receptor CD30|lymphocyte activation antigen CD30|tumor necrosis factor receptor superfamily, member 8', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=12063330, end_position_on_the_genomic_accession=12144207, orientation='plus', exon_count=18, OMIM=153243, no_hdr0=''),
  944 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=944, CurrentID=0, Status='live', Symbol='TNFSF8', Aliases='CD153, CD30L, CD30LG, TNLG3A', description='tumor necrosis factor superfamily member 8', other_designations='CD153 antigen|CD30 antigen ligand|CD30 ligand|CD30-L|tumor necrosis factor (ligand) superfamily member 8|tumor necrosis factor (ligand) superfamily, member 8|tumor necrosis factor ligand 3A', map_location='9q33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=114893343, end_position_on_the_genomic_accession=114930595, orientation='minus', exon_count=5, OMIM=603875, no_hdr0=''),
  945 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=945, CurrentID=0, Status='live', Symbol='CD33', Aliases='SIGLEC-3, SIGLEC3, p67', description='CD33 molecule', other_designations='CD33 antigen (gp67)|gp67|sialic acid binding Ig-like lectin 3|sialic acid-binding Ig-like lectin 3', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=51215537, end_position_on_the_genomic_accession=51240019, orientation='plus', exon_count=11, OMIM=159590, no_hdr0=''),
  946 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=946, CurrentID=0, Status='live', Symbol='SIGLEC6', Aliases='CD327, CD33L, CD33L1, CD33L2, CDW327, OBBP1', description='sialic acid binding Ig like lectin 6', other_designations='CD33 antigen-like 1|obesity-binding protein 1|sialic acid binding Ig-like lectin 6', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=51519530, end_position_on_the_genomic_accession=51531863, orientation='minus', exon_count=11, OMIM=604405, no_hdr0=''),
  947 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=947, CurrentID=0, Status='live', Symbol='CD34', Aliases='', description='CD34 molecule', other_designations='CD34 antigen', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207881028, end_position_on_the_genomic_accession=207911338, orientation='minus', exon_count=9, OMIM=142230, no_hdr0=''),
  948 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=948, CurrentID=0, Status='live', Symbol='CD36', Aliases='BDPLT10, CHDS7, FAT, GP3B, GP4, GPIV, PASIV, SCARB3', description='CD36 molecule', other_designations='CD36 antigen (collagen type I receptor, thrombospondin receptor)|CD36 molecule (thrombospondin receptor)|GPIIIB|PAS IV|PAS-4 protein|cluster determinant 36|fatty acid translocase|glycoprotein IIIb|leukocyte differentiation antigen CD36|platelet glycoprotein IV|scavenger receptor class B, member 3', map_location='7q11.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=80602188, end_position_on_the_genomic_accession=80679277, orientation='plus', exon_count=18, OMIM=173510, no_hdr0=''),
  949 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=949, CurrentID=0, Status='live', Symbol='SCARB1', Aliases='CD36L1, CLA-1, CLA1, HDLQTL6, SR-BI, SRB1', description='scavenger receptor class B member 1', other_designations='CD36 and LIMPII analogous 1|CD36 antigen (collagen type I receptor, thrombospondin receptor)-like 1|scavenger receptor class B type III|scavenger receptor class B, member 1', map_location='12q24.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=124777628, end_position_on_the_genomic_accession=124863973, orientation='minus', exon_count=13, OMIM=601040, no_hdr0=''),
  950 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=950, CurrentID=0, Status='live', Symbol='SCARB2', Aliases='AMRF, CD36L2, EPM4, HLGP85, LGP85, LIMP-2, LIMPII, SR-BII', description='scavenger receptor class B member 2', other_designations='85 kDa lysosomal membrane sialoglycoprotein|85 kDa lysosomal sialoglycoprotein scavenger receptor class B, member 2|CD36 antigen (collagen type I receptor, thrombospondin receptor)-like 2 (lysosomal integral membrane protein II)|CD36 antigen-like 2|LIMP II|lysosome membrane protein II|scavenger receptor class B, member 2', map_location='4q21.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=76158737, end_position_on_the_genomic_accession=76213899, orientation='minus', exon_count=12, OMIM=602257, no_hdr0=''),
  951 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=951, CurrentID=0, Status='live', Symbol='CD37', Aliases='GP52-40, TSPAN26', description='CD37 molecule', other_designations='cell differentiation antigen 37|leukocyte surface antigen CD37|tetraspanin-26|tspan-26', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=49335365, end_position_on_the_genomic_accession=49340606, orientation='plus', exon_count=8, OMIM=151523, no_hdr0=''),
  952 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=952, CurrentID=0, Status='live', Symbol='CD38', Aliases='ADPRC 1, ADPRC1', description='CD38 molecule', other_designations="2'-phospho-ADP-ribosyl cyclase|2'-phospho-cyclic-ADP-ribose transferase|ADP-ribosyl cyclase 1|CD38 antigen (p45)|NAD(+) nucleosidase|cluster of differentiation 38|cyclic ADP-ribose hydrolase 1|ecto-nicotinamide adenine dinucleotide glycohydrolase", map_location='4p15', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=15778298, end_position_on_the_genomic_accession=15849083, orientation='plus', exon_count=8, OMIM=107270, no_hdr0=''),
  953 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=953, CurrentID=0, Status='live', Symbol='ENTPD1', Aliases='ATPDase, CD39, NTPDase-1, SPG64', description='ectonucleoside triphosphate diphosphohydrolase 1', other_designations='CD39 antigen|NTPDase 1|ecto-ATP diphosphohydrolase 1|ecto-ATPDase 1|ecto-ATPase 1|ecto-apyrase|lymphoid cell activation antigen', map_location='10q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=95710906, end_position_on_the_genomic_accession=95877266, orientation='plus', exon_count=16, OMIM=601752, no_hdr0=''),
  954 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=954, CurrentID=0, Status='live', Symbol='ENTPD2', Aliases='CD39L1, NTPDase-2', description='ectonucleoside triphosphate diphosphohydrolase 2', other_designations='CD39 antigen-like 1|NTPDase 2|ecto-ATP diphosphohydrolase 2|ecto-ATPDase 2|ecto-ATPase 2', map_location='9q34', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=137048098, end_position_on_the_genomic_accession=137054069, orientation='minus', exon_count=9, OMIM=602012, no_hdr0=''),
  955 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=955, CurrentID=0, Status='live', Symbol='ENTPD6', Aliases='CD39L2, IL-6SAG, IL6ST2, NTPDase-6', description='ectonucleoside triphosphate diphosphohydrolase 6 (putative)', other_designations='CD39 antigen-like 2|CD39-like 2|HCV-E2 binding protein 1|NTPDase 6|ectonucleoside triphosphate diphosphohydrolase 6 (putative function)|interleukin 6 signal transducer-2', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=25195670, end_position_on_the_genomic_accession=25226724, orientation='plus', exon_count=18, OMIM=603160, no_hdr0=''),
  956 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=956, CurrentID=0, Status='live', Symbol='ENTPD3', Aliases='CD39L3, HB6, NTPDase-3', description='ectonucleoside triphosphate diphosphohydrolase 3', other_designations='CD39 antigen-like 3|NTPDase 3|ecto-ATP diphosphohydrolase 3|ecto-ATPDase 3|ecto-ATPase 3|ecto-apyrase 3', map_location='3p21.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=40387156, end_position_on_the_genomic_accession=40428626, orientation='plus', exon_count=13, OMIM=603161, no_hdr0=''),
  957 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=957, CurrentID=0, Status='live', Symbol='ENTPD5', Aliases='CD39L4, NTPDase-5, PCPH', description='ectonucleoside triphosphate diphosphohydrolase 5', other_designations='CD39 antigen-like 4|CD39-like 4|ER-UDPase|GDPase ENTPD5|NTPDase 5|Pcph proto-oncogene protein|UDPase ENTPD5|guanosine-diphosphatase ENTPD5|nucleoside diphosphatase|proto-oncogene CPH|uridine-diphosphatase ENTPD5', map_location='14q24', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=73959467, end_position_on_the_genomic_accession=74019326, orientation='minus', exon_count=22, OMIM=603162, no_hdr0=''),
  958 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=958, CurrentID=0, Status='live', Symbol='CD40', Aliases='Bp50, CDW40, TNFRSF5, p50', description='CD40 molecule', other_designations='B cell surface antigen CD40|B cell-associated molecule|CD40 antigen (TNF receptor superfamily member 5)|CD40 molecule TNF receptor superfamily member 5|CD40 molecule, TNF receptor superfamily member 5|CD40 type II isoform|CD40L receptor|nerve growth factor receptor-related B-lymphocyte activation molecule', map_location='20q12-q13.2', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=46118250, end_position_on_the_genomic_accession=46129745, orientation='plus', exon_count=9, OMIM=109535, no_hdr0=''),
  959 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=959, CurrentID=0, Status='live', Symbol='CD40LG', Aliases='CD154, CD40L, HIGM1, IGM, IMD3, T-BAM, TNFSF5, TRAP, gp39, hCD40L', description='CD40 ligand', other_designations='CD40 antigen ligand|CD40-L|T-B cell-activating molecule|T-cell antigen Gp39|TNF-related activation protein|tumor necrosis factor (ligand) superfamily member 5', map_location='Xq26', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=136648177, end_position_on_the_genomic_accession=136660390, orientation='plus', exon_count=5, OMIM=300386, no_hdr0=''),
  960 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=960, CurrentID=0, Status='live', Symbol='CD44', Aliases='CDW44, CSPG8, ECMR-III, HCELL, HUTCH-I, IN, LHR, MC56, MDU2, MDU3, MIC4, Pgp1', description='CD44 molecule (Indian blood group)', other_designations='GP90 lymphocyte homing/adhesion receptor|Hermes antigen|cell surface glycoprotein CD44|chondroitin sulfate proteoglycan 8|epican|extracellular matrix receptor III|hematopoietic cell E- and L-selectin ligand|heparan sulfate proteoglycan|homing function and Indian blood group system|hyaluronate receptor|phagocytic glycoprotein 1|soluble CD44', map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=35138870, end_position_on_the_genomic_accession=35232402, orientation='plus', exon_count=21, OMIM=107269, no_hdr0=''),
  961 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=961, CurrentID=0, Status='live', Symbol='CD47', Aliases='IAP, MER6, OA3', description='CD47 molecule', other_designations='CD47 antigen (Rh-related antigen, integrin-associated signal transducer)|CD47 glycoprotein|Rh-related antigen|antigen identified by monoclonal antibody 1D8|antigenic surface determinant protein OA3|integrin associated protein|integrin-associated protein|integrin-associated signal transducer', map_location='3q13.1-q13.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=108043094, end_position_on_the_genomic_accession=108091088, orientation='minus', exon_count=13, OMIM=601028, no_hdr0=''),
  962 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=962, CurrentID=0, Status='live', Symbol='CD48', Aliases='BCM1, BLAST, BLAST1, MEM-102, SLAMF2, hCD48, mCD48', description='CD48 molecule', other_designations='B-lymphocyte activation marker BLAST-1|BCM1 surface antigen|CD48 antigen (B-cell membrane protein)|SLAM family member 2|TCT.1|leukocyte antigen MEM-102|signaling lymphocytic activation molecule 2', map_location='1q21.3-q22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160678746, end_position_on_the_genomic_accession=160711851, orientation='minus', exon_count=5, OMIM=109530, no_hdr0=''),
  963 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=963, CurrentID=0, Status='live', Symbol='CD53', Aliases='MOX44, TSPAN25', description='CD53 molecule', other_designations='CD53 antigen|CD53 glycoprotein|CD53 tetraspan antigen|antigen MOX44 identified by monoclonal antibody MRC-OX44|cell surface antigen|cell surface glycoprotein CD53|tetraspanin-25|transmembrane glycoprotein|tspan-25', map_location='1p13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=110871199, end_position_on_the_genomic_accession=110899936, orientation='plus', exon_count=9, OMIM=151525, no_hdr0=''),
  965 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=965, CurrentID=0, Status='live', Symbol='CD58', Aliases='LFA-3, LFA3, ag3', description='CD58 molecule', other_designations='CD58 antigen, (lymphocyte function-associated antigen 3)|surface glycoprotein LFA-3', map_location='1p13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=116514534, end_position_on_the_genomic_accession=116571093, orientation='minus', exon_count=6, OMIM=153420, no_hdr0=''),
  966 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=966, CurrentID=0, Status='live', Symbol='CD59', Aliases='16.3A5, 1F5, EJ16, EJ30, EL32, G344, HRF-20, HRF20, MAC-IP, MACIF, MEM43, MIC11, MIN1, MIN2, MIN3, MIRL, MSK21, p18-20', description='CD59 molecule', other_designations='1F5 antigen|20 kDa homologous restriction factor|CD59 antigen p18-20 (antigen identified by monoclonal antibodies 16.3A5, EJ16, EJ30, EL32 and G344)|CD59 molecule, complement regulatory protein|Ly-6-like protein|MEM43 antigen|T cell-activating protein|human leukocyte antigen MIC11|lymphocytic antigen CD59/MEM43|membrane attack complex (MAC) inhibition factor|membrane attack complex inhibition factor|membrane inhibitor of reactive lysis|protectin|surface anitgen recognized by monoclonal antibody 16.3A5', map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=33703010, end_position_on_the_genomic_accession=33736479, orientation='minus', exon_count=7, OMIM=107271, no_hdr0=''),
  967 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=967, CurrentID=0, Status='live', Symbol='CD63', Aliases='LAMP-3, ME491, MLA1, OMA81H, TSPAN30', description='CD63 molecule', other_designations='CD63 antigen (melanoma 1 antigen)|granulophysin|lysosomal-associated membrane protein 3|lysosome-associated membrane glycoprotein 3|melanoma-associated antigen ME491|melanoma-associated antigen MLA1|ocular melanoma-associated antigen|tetraspanin-30|tspan-30', map_location='12q13.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=55725443, end_position_on_the_genomic_accession=55729673, orientation='minus', exon_count=12, OMIM=155740, no_hdr0=''),
  968 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=968, CurrentID=0, Status='live', Symbol='CD68', Aliases='GP110, LAMP4, SCARD1', description='CD68 molecule', other_designations='CD68 antigen|macrophage antigen CD68|scavenger receptor class D, member 1', map_location='17p13', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7579487, end_position_on_the_genomic_accession=7582111, orientation='plus', exon_count=6, OMIM=153634, no_hdr0=''),
  969 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=969, CurrentID=0, Status='live', Symbol='CD69', Aliases='AIM, BL-AC/P26, CLEC2C, EA1, GP32/28, MLR-3', description='CD69 molecule', other_designations='C-type lectin domain family 2, member C|CD69 antigen (p60, early T-cell activation antigen)|activation inducer molecule (AIM/CD69)|early T-cell activation antigen p60|early lymphocyte activation antigen|leukocyte surface antigen Leu-23', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=9752486, end_position_on_the_genomic_accession=9760901, orientation='minus', exon_count=5, OMIM=107273, no_hdr0=''),
  970 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=970, CurrentID=0, Status='live', Symbol='CD70', Aliases='CD27L, CD27LG, TNFSF7, TNLG8A', description='CD70 molecule', other_designations='CD27 ligand|CD27-L|Ki-24 antigen|surface antigen CD70|tumor necrosis factor (ligand) superfamily, member 7|tumor necrosis factor ligand 8A|tumor necrosis factor ligand superfamily member 7', map_location='19p13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=6585839, end_position_on_the_genomic_accession=6591152, orientation='minus', exon_count=3, OMIM=602840, no_hdr0=''),
  971 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=971, CurrentID=0, Status='live', Symbol='CD72', Aliases='CD72b, LYB2', description='CD72 molecule', other_designations='CD72 antigen|lyb-2', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=35609979, end_position_on_the_genomic_accession=35646857, orientation='minus', exon_count=11, OMIM=107272, no_hdr0=''),
  972 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=972, CurrentID=0, Status='live', Symbol='CD74', Aliases='DHLAG, HLADG, II, Ia-GAMMA', description='CD74 molecule', other_designations='CD74 antigen (invariant polypeptide of major histocompatibility complex, class II antigen-associated)|CD74 molecule, major histocompatibility complex, class II invariant chain|HLA-DR antigens-associated invariant chain|HLA-DR-gamma|Ia-associated invariant chain|MHC HLA-DR gamma chain|gamma chain of class II antigens|p33', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=150401637, end_position_on_the_genomic_accession=150412936, orientation='minus', exon_count=9, OMIM=142790, no_hdr0=''),
  973 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=973, CurrentID=0, Status='live', Symbol='CD79A', Aliases='IGA, MB-1', description='CD79a molecule', other_designations='CD79a antigen (immunoglobulin-associated alpha)|CD79a molecule, immunoglobulin-associated alpha|MB-1 membrane glycoprotein|ig-alpha|membrane-bound immunoglobulin-associated protein|surface IgM-associated protein', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41877120, end_position_on_the_genomic_accession=41881372, orientation='plus', exon_count=5, OMIM=112205, no_hdr0=''),
  974 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=974, CurrentID=0, Status='live', Symbol='CD79B', Aliases='AGM6, B29, IGB', description='CD79b molecule', other_designations='B-cell-specific glycoprotein B29|CD79b antigen (immunoglobulin-associated beta)|CD79b molecule, immunoglobulin-associated beta|Ig-beta|immunoglobulin-associated B29 protein', map_location='17q23', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63928738, end_position_on_the_genomic_accession=63932353, orientation='minus', exon_count=6, OMIM=147245, no_hdr0=''),
  975 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=975, CurrentID=0, Status='live', Symbol='CD81', Aliases='CVID6, S5.7, TAPA1, TSPAN28', description='CD81 molecule', other_designations='26 kDa cell surface protein TAPA-1|CD81 antigen (target of antiproliferative antibody 1)|tetraspanin-28|tspan-28', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=2376177, end_position_on_the_genomic_accession=2397419, orientation='plus', exon_count=10, OMIM=186845, no_hdr0=''),
  976 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=976, CurrentID=0, Status='live', Symbol='ADGRE5', Aliases='CD97, TM7LN1', description='adhesion G protein-coupled receptor E5', other_designations='CD97 molecule|leukocyte antigen CD97|seven transmembrane helix receptor|seven-span transmembrane protein|seven-transmembrane, heterodimeric receptor associated with inflammation', map_location='19p13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=14381144, end_position_on_the_genomic_accession=14408725, orientation='plus', exon_count=20, OMIM=601211, no_hdr0=''),
  977 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=977, CurrentID=0, Status='live', Symbol='CD151', Aliases='GP27, MER2, PETA-3, RAPH, SFA1, TSPAN24', description='CD151 molecule (Raph blood group)', other_designations='CD151 antigen (Raph blood group)|hemidesmosomal tetraspanin CD151|membrane glycoprotein SFA-1|platelet surface glycoprotein gp27|platelet-endothelial cell tetraspan antigen 3|platelet-endothelial tetraspan antigen 3|tetraspanin-24|tspan-24', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=832952, end_position_on_the_genomic_accession=838835, orientation='plus', exon_count=9, OMIM=602243, no_hdr0=''),
  978 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=978, CurrentID=0, Status='live', Symbol='CDA', Aliases='CDD', description='cytidine deaminase', other_designations='cytidine aminohydrolase|cytosine nucleoside deaminase|small cytidine deaminase', map_location='1p36.2-p35', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=20588951, end_position_on_the_genomic_accession=20618908, orientation='plus', exon_count=4, OMIM=123920, no_hdr0=''),
  983 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=983, CurrentID=0, Status='live', Symbol='CDK1', Aliases='CDC2, CDC28A, P34CDC2', description='cyclin-dependent kinase 1', other_designations='cell cycle controller CDC2|cell division control protein 2 homolog|cell division cycle 2, G1 to S and G2 to M|cell division protein kinase 1|p34 protein kinase', map_location='10q21.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=60778331, end_position_on_the_genomic_accession=60794852, orientation='plus', exon_count=9, OMIM=116940, no_hdr0=''),
  984 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=984, CurrentID=0, Status='live', Symbol='CDK11B', Aliases='CDC2L1, CDK11, CDK11-p110, CDK11-p46, CDK11-p58, CLK-1, PITSLREA, PK58, p58, p58CDC2L1, p58CLK-1', description='cyclin-dependent kinase 11B', other_designations='CDC-related protein kinase p58|PITSLRE serine/threonine-protein kinase CDC2L1|cell division cycle 2-like 1 (PITSLRE proteins)|cell division protein kinase 11B|galactosyltransferase-associated protein kinase p58/GTA|p58 CLK-1', map_location='1p36.33', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=1635226, end_position_on_the_genomic_accession=1659839, orientation='minus', exon_count=22, OMIM=176873, no_hdr0=''),
  987 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=987, CurrentID=0, Status='live', Symbol='LRBA', Aliases='BGL, CDC4L, CVID8, LAB300, LBA', description='LPS-responsive vesicle trafficking, beach and anchor containing', other_designations='CDC4-like protein|vesicle trafficking, beach and anchor containing', map_location='4q31.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=150264659, end_position_on_the_genomic_accession=151015727, orientation='minus', exon_count=60, OMIM=606453, no_hdr0=''),
  988 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=988, CurrentID=0, Status='live', Symbol='CDC5L', Aliases='CDC5, CDC5-LIKE, CEF1, PCDC5RP, dJ319D22.1', description='cell division cycle 5 like', other_designations='CDC5 cell division cycle 5-like|Cdc5-related protein|dJ319D22.1 (CDC5-like protein)|pombe cdc5-related protein', map_location='6p21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=44387514, end_position_on_the_genomic_accession=44450424, orientation='plus', exon_count=18, OMIM=602868, no_hdr0=''),
  989 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=989, CurrentID=0, Status='live', Symbol='SEPT7', Aliases='CDC10, CDC3, NBLA02942A, SEPT7', description='septin 7', other_designations='CDC10 (cell division cycle 10, S. cerevisiae, homolog)|CDC10 protein homolog|septin 7 variant 4', map_location='7p14.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=35800986, end_position_on_the_genomic_accession=35915763, orientation='plus', exon_count=19, OMIM=603151, no_hdr0=''),
  990 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=990, CurrentID=0, Status='live', Symbol='CDC6', Aliases='CDC18L, HsCDC18, HsCDC6', description='cell division cycle 6', other_designations='CDC6 cell division cycle 6 homolog|CDC6-related protein|cdc18-related protein|cell division cycle 6 homolog|p62(cdc6)', map_location='17q21.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=40287689, end_position_on_the_genomic_accession=40303161, orientation='plus', exon_count=13, OMIM=602627, no_hdr0=''),
  991 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=991, CurrentID=0, Status='live', Symbol='CDC20', Aliases='CDC20A, bA276H19.3, p55CDC', description='cell division cycle 20', other_designations='CDC20 cell division cycle 20 homolog|cell division cycle 20 homolog', map_location='1p34.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=43358955, end_position_on_the_genomic_accession=43363203, orientation='plus', exon_count=11, OMIM=603618, no_hdr0=''),
  164832 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=164832, CurrentID=0, Status='live', Symbol='LONRF2', Aliases='RNF192', description='LON peptidase N-terminal domain and ring finger 2', other_designations='RING finger protein 192|neuroblastoma apoptosis-related protease', map_location='2q11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=100273291, end_position_on_the_genomic_accession=100322733, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  993 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=993, CurrentID=0, Status='live', Symbol='CDC25A', Aliases='CDC25A2', description='cell division cycle 25A', other_designations='CDC25 isoform A1-CAG|CDC25A2-CAG isoform|dual specificity phosphatase CDC25A', map_location='3p21', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48157178, end_position_on_the_genomic_accession=48188658, orientation='minus', exon_count=15, OMIM=116947, no_hdr0=''),
  994 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=994, CurrentID=0, Status='live', Symbol='CDC25B', Aliases='', description='cell division cycle 25B', other_designations='dual specificity phosphatase Cdc25B', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=3786772, end_position_on_the_genomic_accession=3806121, orientation='plus', exon_count=18, OMIM=116949, no_hdr0=''),
  995 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=995, CurrentID=0, Status='live', Symbol='CDC25C', Aliases='CDC25, PPP1R60', description='cell division cycle 25C', other_designations='dual specificity phosphatase CDC25C|mitosis inducer CDC25|phosphotyrosine phosphatase|protein phosphatase 1, regulatory subunit 60', map_location='5q31', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=138285265, end_position_on_the_genomic_accession=138338355, orientation='minus', exon_count=15, OMIM=157680, no_hdr0=''),
  996 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=996, CurrentID=0, Status='live', Symbol='CDC27', Aliases='ANAPC3, APC3Hs, D0S1430E, D17S978E, H-NUC, HNUC, NUC2, CDC27', description='cell division cycle 27', other_designations='anaphase promoting complex subunit 3|anaphase-promoting complex, protein 3|cell division cycle 27 homolog|nuc2 homolog', map_location='17q21.32', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=47117697, end_position_on_the_genomic_accession=47189312, orientation='minus', exon_count=20, OMIM=116946, no_hdr0=''),
  997 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=997, CurrentID=0, Status='live', Symbol='CDC34', Aliases='E2-CDC34, UBC3, UBCH3, UBE2R1', description='cell division cycle 34', other_designations='(E3-independent) E2 ubiquitin-conjugating enzyme R1|E2 ubiquitin-conjugating enzyme R1|cell division cycle 34 homolog|ubiquitin carrier protein|ubiquitin-conjugating enzyme E2-32 KDA complementing|ubiquitin-conjugating enzyme E2-CDC34|ubiquitin-protein ligase R1', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=531719, end_position_on_the_genomic_accession=542088, orientation='plus', exon_count=6, OMIM=116948, no_hdr0=''),
  998 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=998, CurrentID=0, Status='live', Symbol='CDC42', Aliases='CDC42Hs, G25K, TKS', description='cell division cycle 42', other_designations='G25K GTP-binding protein|GTP binding protein, 25kDa|GTP-binding protein, 25kD|dJ224A6.1.1 (cell division cycle 42 (GTP-binding protein, 25kD))|dJ224A6.1.2 (cell division cycle 42 (GTP-binding protein, 25kD))|growth-regulating protein|small GTP binding protein CDC42', map_location='1p36.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22052627, end_position_on_the_genomic_accession=22092943, orientation='plus', exon_count=8, OMIM=116952, no_hdr0=''),
  999 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=999, CurrentID=0, Status='live', Symbol='CDH1', Aliases='Arc-1, CD324, CDHE, ECAD, LCAM, UVO', description='cadherin 1', other_designations='CAM 120/80|E-Cadherin|E-cadherin 1|cadherin 1, E-cadherin (epithelial)|cadherin 1, type 1|cadherin 1, type 1, E-cadherin (epithelial)|calcium-dependent adhesion protein, epithelial|cell-CAM 120/80|epithelial cadherin|uvomorulin', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=68737292, end_position_on_the_genomic_accession=68835542, orientation='plus', exon_count=18, OMIM=192090, no_hdr0=''),
  1000 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1000, CurrentID=0, Status='live', Symbol='CDH2', Aliases='CD325, CDHN, CDw325, NCAD', description='cadherin 2', other_designations='N-cadherin 1|cadherin 2, type 1, N-cadherin (neuronal)|calcium-dependent adhesion protein, neuronal|neural cadherin', map_location='18q11.2', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=27932879, end_position_on_the_genomic_accession=28177481, orientation='minus', exon_count=20, OMIM=114020, no_hdr0=''),
  1001 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1001, CurrentID=0, Status='live', Symbol='CDH3', Aliases='CDHP, HJMD, PCAD', description='cadherin 3', other_designations='cadherin 3, type 1, P-cadherin (placental)|calcium-dependent adhesion protein, placental', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=68644248, end_position_on_the_genomic_accession=68727577, orientation='plus', exon_count=18, OMIM=114021, no_hdr0=''),
  1002 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1002, CurrentID=0, Status='live', Symbol='CDH4', Aliases='CAD4, R-CAD, RCAD', description='cadherin 4', other_designations='R-cadherin|cadherin 4, type 1, R-cadherin (retinal)|cadherin 4, type 1, preproprotein|retinal cadherin', map_location='20q13.3', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=61252426, end_position_on_the_genomic_accession=61940617, orientation='plus', exon_count=18, OMIM=603006, no_hdr0=''),
  1003 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1003, CurrentID=0, Status='live', Symbol='CDH5', Aliases='7B4, CD144', description='cadherin 5', other_designations='7B4 antigen|VE-cadherin|cadherin 5, type 2 (vascular endothelium)|cadherin 5, type 2, VE-cadherin (vascular epithelium)|cd144 antigen|endothelial-specific cadherin|vascular endothelial cadherin', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=66366622, end_position_on_the_genomic_accession=66404786, orientation='plus', exon_count=12, OMIM=601120, no_hdr0=''),
  1004 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1004, CurrentID=0, Status='live', Symbol='CDH6', Aliases='CAD6, KCAD', description='cadherin 6', other_designations='cadherin 6, type 2, K-cadherin (fetal kidney)', map_location='5p13.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=31193655, end_position_on_the_genomic_accession=31329146, orientation='plus', exon_count=13, OMIM=603007, no_hdr0=''),
  1005 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1005, CurrentID=0, Status='live', Symbol='CDH7', Aliases='CDH7L1', description='cadherin 7', other_designations='cadherin 7, type 2', map_location='18q22.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=65750252, end_position_on_the_genomic_accession=65880939, orientation='plus', exon_count=14, OMIM=605806, no_hdr0=''),
  1006 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1006, CurrentID=0, Status='live', Symbol='CDH8', Aliases='Nbla04261', description='cadherin 8', other_designations='cadherin 8, type 2', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=61647244, end_position_on_the_genomic_accession=62037035, orientation='minus', exon_count=14, OMIM=603008, no_hdr0=''),
  1007 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1007, CurrentID=0, Status='live', Symbol='CDH9', Aliases='', description='cadherin 9', other_designations='T1-cadherin|cadherin 9, type 2 (T1-cadherin)', map_location='5p14', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=26880600, end_position_on_the_genomic_accession=27121198, orientation='minus', exon_count=13, OMIM=609974, no_hdr0=''),
  1008 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1008, CurrentID=0, Status='live', Symbol='CDH10', Aliases='', description='cadherin 10', other_designations='T2-cadherin|cadherin 10 type 2|cadherin 10, type 2 (T2-cadherin)', map_location='5p14.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=24487100, end_position_on_the_genomic_accession=24645024, orientation='minus', exon_count=14, OMIM=604555, no_hdr0=''),
  1009 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1009, CurrentID=0, Status='live', Symbol='CDH11', Aliases='CAD11, CDHOB, OB, OSF-4', description='cadherin 11', other_designations='cadherin 11, type 2, OB-cadherin (osteoblast)', map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=64945226, end_position_on_the_genomic_accession=65126112, orientation='minus', exon_count=18, OMIM=600023, no_hdr0=''),
  1010 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1010, CurrentID=0, Status='live', Symbol='CDH12', Aliases='CDHB', description='cadherin 12', other_designations='Br-cadherin|N-cadherin 2|brain cadherin|brain-cadherin|cadherin 12, type 2 (N-cadherin 2)|cadherin, neural type, 2|neural type cadherin 2|neuronal cadherin 2', map_location='5p14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=21750864, end_position_on_the_genomic_accession=22853622, orientation='minus', exon_count=16, OMIM=600562, no_hdr0=''),
  105373244 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105373244, CurrentID=0, Status='live', Symbol='LOC105373244', Aliases='', description='uncharacterized LOC105373244', other_designations='', map_location='', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=70427361, end_position_on_the_genomic_accession=70435494, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  1012 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1012, CurrentID=0, Status='live', Symbol='CDH13', Aliases='CDHH, P105', description='cadherin 13', other_designations='H-cadherin (heart)|T-cad|T-cadherin|cadherin 13, H-cadherin (heart)|heart cadherin', map_location='16q23.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=82626794, end_position_on_the_genomic_accession=83796610, orientation='plus', exon_count=20, OMIM=601364, no_hdr0=''),
  1013 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1013, CurrentID=0, Status='live', Symbol='CDH15', Aliases='CDH14, CDH3, CDHM, MCAD, MRD3', description='cadherin 15', other_designations='cadherin 15, type 1, M-cadherin (myotubule)|cadherin-14|cadherin-3|muscle-cadherin', map_location='16q24.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=89171755, end_position_on_the_genomic_accession=89195492, orientation='plus', exon_count=14, OMIM=114019, no_hdr0=''),
  1014 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1014, CurrentID=0, Status='live', Symbol='CDH16', Aliases='', description='cadherin 16', other_designations='KSP-cadherin|cadherin 16, KSP-cadherin|kidney-specific cadherin', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=66908122, end_position_on_the_genomic_accession=66918984, orientation='minus', exon_count=18, OMIM=603118, no_hdr0=''),
  1015 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1015, CurrentID=0, Status='live', Symbol='CDH17', Aliases='CDH16, HPT-1, HPT1', description='cadherin 17', other_designations='HPT-1 cadherin|LI cadherin|LI-cadherin|cadherin 17, LI cadherin (liver-intestine)|cadherin-16|human intestinal peptide-associated transporter HPT-1|human peptide transporter 1|intestinal peptide-associated transporter HPT-1|liver-intestine cadherin', map_location='8q22.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=94127162, end_position_on_the_genomic_accession=94217303, orientation='minus', exon_count=19, OMIM=603017, no_hdr0=''),
  1016 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1016, CurrentID=0, Status='live', Symbol='CDH18', Aliases='CDH14, CDH14L, CDH24', description='cadherin 18', other_designations='cadherin 18, type 2|cadherin-14|cadherin-like 24|ey-cadherin', map_location='5p14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=19472930, end_position_on_the_genomic_accession=20575873, orientation='minus', exon_count=21, OMIM=603019, no_hdr0=''),
  1017 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1017, CurrentID=0, Status='live', Symbol='CDK2', Aliases='CDKN2, p33(CDK2)', description='cyclin-dependent kinase 2', other_designations='cdc2-related protein kinase|cell division protein kinase 2|p33 protein kinase', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=55966769, end_position_on_the_genomic_accession=55972789, orientation='plus', exon_count=8, OMIM=116953, no_hdr0=''),
  1018 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1018, CurrentID=0, Status='live', Symbol='CDK3', Aliases='', description='cyclin-dependent kinase 3', other_designations='cell division protein kinase 3', map_location='17q25.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=76000906, end_position_on_the_genomic_accession=76005999, orientation='plus', exon_count=8, OMIM=123828, no_hdr0=''),
  1019 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1019, CurrentID=0, Status='live', Symbol='CDK4', Aliases='CMM3, PSK-J3', description='cyclin-dependent kinase 4', other_designations='cell division protein kinase 4', map_location='12q14', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=57747727, end_position_on_the_genomic_accession=57752447, orientation='minus', exon_count=8, OMIM=123829, no_hdr0=''),
  1020 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1020, CurrentID=0, Status='live', Symbol='CDK5', Aliases='LIS7, PSSALRE', description='cyclin-dependent kinase 5', other_designations='TPKII catalytic subunit|cell division protein kinase 5|protein kinase CDK5 splicing|serine/threonine-protein kinase PSSALRE|tau protein kinase II catalytic subunit', map_location='7q36', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=151053812, end_position_on_the_genomic_accession=151057965, orientation='minus', exon_count=12, OMIM=123831, no_hdr0=''),
  1021 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1021, CurrentID=0, Status='live', Symbol='CDK6', Aliases='MCPH12, PLSTIRE', description='cyclin-dependent kinase 6', other_designations='cell division protein kinase 6|serine/threonine-protein kinase PLSTIRE', map_location='7q21-q22', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=92604921, end_position_on_the_genomic_accession=92836627, orientation='minus', exon_count=11, OMIM=603368, no_hdr0=''),
  1022 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1022, CurrentID=0, Status='live', Symbol='CDK7', Aliases='CAK1, CDKN7, HCAK, MO15, STK1, p39MO15', description='cyclin-dependent kinase 7', other_designations='39 KDa protein kinase|CAK|CDK-activating kinase 1|TFIIH basal transcription factor complex kinase subunit|cell division protein kinase 7|cyclin-dependent kinase 7 (MO15 homolog, Xenopus laevis, cdk-activating kinase)|homolog of Xenopus MO15 Cdk-activating kinase|kinase subunit of CAK|p39 Mo15|protein kinase|serine/threonine kinase stk1|serine/threonine protein kinase 1|serine/threonine protein kinase MO15|serine/threonine-protein kinase 1', map_location='5q12.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=69234795, end_position_on_the_genomic_accession=69277430, orientation='plus', exon_count=12, OMIM=601955, no_hdr0=''),
  338773 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=338773, CurrentID=0, Status='live', Symbol='TMEM119', Aliases='OBIF', description='transmembrane protein 119', other_designations='osteoblast induction factor', map_location='12q23.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=108589846, end_position_on_the_genomic_accession=108598118, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  1024 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1024, CurrentID=0, Status='live', Symbol='CDK8', Aliases='K35', description='cyclin-dependent kinase 8', other_designations='CDK8 protein kinase|cell division protein kinase 8|mediator complex subunit CDK8|mediator of RNA polymerase II transcription subunit CDK8|protein kinase K35', map_location='13q12', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=26254125, end_position_on_the_genomic_accession=26405238, orientation='plus', exon_count=16, OMIM=603184, no_hdr0=''),
  1025 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1025, CurrentID=0, Status='live', Symbol='CDK9', Aliases='C-2k, CDC2L4, CTK1, PITALRE, TAK', description='cyclin-dependent kinase 9', other_designations='CDC2-related kinase|cell division cycle 2-like protein kinase 4|cell division protein kinase 9|serine/threonine protein kinase PITALRE|tat-associated kinase complex catalytic subunit', map_location='9q34.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=127786026, end_position_on_the_genomic_accession=127790773, orientation='plus', exon_count=7, OMIM=603251, no_hdr0=''),
  1026 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1026, CurrentID=0, Status='live', Symbol='CDKN1A', Aliases='CAP20, CDKN1, CIP1, MDA-6, P21, SDI1, WAF1, p21CIP1', description='cyclin-dependent kinase inhibitor 1A (p21, Cip1)', other_designations='CDK-interacting protein 1|CDK-interaction protein 1|DNA synthesis inhibitor|melanoma differentiation associated protein 6|wild-type p53-activated fragment 1', map_location='6p21.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=36676460, end_position_on_the_genomic_accession=36687339, orientation='plus', exon_count=6, OMIM=116899, no_hdr0=''),
  1027 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1027, CurrentID=0, Status='live', Symbol='CDKN1B', Aliases='CDKN4, KIP1, MEN1B, MEN4, P27KIP1', description='cyclin-dependent kinase inhibitor 1B (p27, Kip1)', other_designations='', map_location='12p13.1-p12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=12717270, end_position_on_the_genomic_accession=12722383, orientation='plus', exon_count=3, OMIM=600778, no_hdr0=''),
  1028 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1028, CurrentID=0, Status='live', Symbol='CDKN1C', Aliases='BWCR, BWS, KIP2, WBS, p57, p57Kip2', description='cyclin-dependent kinase inhibitor 1C (p57, Kip2)', other_designations='cyclin-dependent kinase inhibitor p57', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=2883218, end_position_on_the_genomic_accession=2885816, orientation='minus', exon_count=4, OMIM=600856, no_hdr0=''),
  1029 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1029, CurrentID=0, Status='live', Symbol='CDKN2A', Aliases='ARF, CDK4I, CDKN2, CMM2, INK4, INK4A, MLM, MTS-1, MTS1, P14, P14ARF, P16, P16-INK4A, P16INK4, P16INK4A, P19, P19ARF, TP16', description='cyclin-dependent kinase inhibitor 2A', other_designations='CDK4 inhibitor p16-INK4|alternative reading frame|cell cycle negative regulator beta|cyclin-dependent kinase 4 inhibitor A|cyclin-dependent kinase inhibitor 2A (melanoma, p16, inhibits CDK4)|multiple tumor suppressor 1', map_location='9p21', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=21967752, end_position_on_the_genomic_accession=21995043, orientation='minus', exon_count=12, OMIM=600160, no_hdr0=''),
  1030 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1030, CurrentID=0, Status='live', Symbol='CDKN2B', Aliases='CDK4I, INK4B, MTS2, P15, TP15, p15INK4b', description='cyclin-dependent kinase inhibitor 2B (p15, inhibits CDK4)', other_designations='CDK inhibitory protein|CDK4B inhibitor|MTS-2|cyclin-dependent kinases 4 and 6 binding protein|multiple tumor suppressor 2|p14-INK4b|p14_CDK inhibitor|p14_INK4B|p15 CDK inhibitor|p15-INK4b|p15_INK4B', map_location='9p21', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=22002903, end_position_on_the_genomic_accession=22009313, orientation='minus', exon_count=2, OMIM=600431, no_hdr0=''),
  1031 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1031, CurrentID=0, Status='live', Symbol='CDKN2C', Aliases='INK4C, p18, p18-INK4C', description='cyclin-dependent kinase inhibitor 2C (p18, inhibits CDK4)', other_designations='CDK6 inhibitor p18|cyclin-dependent inhibitor|cyclin-dependent kinase 6 inhibitor p18|p18-INK6', map_location='1p32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=50968695, end_position_on_the_genomic_accession=50974637, orientation='plus', exon_count=3, OMIM=603369, no_hdr0=''),
  1032 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1032, CurrentID=0, Status='live', Symbol='CDKN2D', Aliases='INK4D, p19, p19-INK4D', description='cyclin-dependent kinase inhibitor 2D (p19, inhibits CDK4)', other_designations='CDK inhibitor p19INK4d|cell cycle inhibitor, Nur77 associating protein|cyclin-dependent kinase 4 inhibitor D p19|inhibitor of cyclin-dependent kinase 4d', map_location='19p13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=10566462, end_position_on_the_genomic_accession=10568979, orientation='minus', exon_count=2, OMIM=600927, no_hdr0=''),
  1033 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1033, CurrentID=0, Status='live', Symbol='CDKN3', Aliases='CDI1, CIP2, KAP, KAP1', description='cyclin-dependent kinase inhibitor 3', other_designations='CDK2-associated dual specificity phosphatase|CDK2-associated dual-specificity phosphatase|Cdk-associated protein phosphatase|cyclin-dependent kinase interacting protein 2|cyclin-dependent kinase interactor 1|cyclin-dependent kinase-interacting protein 2|kinase associated phosphatase|kinase-associated phosphatase', map_location='14q22', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=54396934, end_position_on_the_genomic_accession=54420218, orientation='plus', exon_count=9, OMIM=123832, no_hdr0=''),
  1036 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1036, CurrentID=0, Status='live', Symbol='CDO1', Aliases='', description='cysteine dioxygenase type 1', other_designations='CDO|CDO-I|cysteine dioxygenase, type I', map_location='5q23.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=115804733, end_position_on_the_genomic_accession=115816954, orientation='minus', exon_count=6, OMIM=603943, no_hdr0=''),
  1038 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1038, CurrentID=0, Status='live', Symbol='CDR1', Aliases='CDR, CDR34, CDR62A', description='cerebellar degeneration related protein 1', other_designations='cerebellar degeneration-related protein 1, 34kDa', map_location='Xq27.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=140783260, end_position_on_the_genomic_accession=140784558, orientation='minus', exon_count=1, OMIM=302650, no_hdr0=''),
  1039 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1039, CurrentID=0, Status='live', Symbol='CDR2', Aliases='CDR62, Yo', description='cerebellar degeneration related protein 2', other_designations='Yo paraneoplastic antigen|cerebellar degeneration-related protein 2, 62kDa|major Yo paraneoplastic antigen|paraneoplastic cerebellar degeneration-associated antigen', map_location='16p12.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=22345936, end_position_on_the_genomic_accession=22374617, orientation='minus', exon_count=5, OMIM=117340, no_hdr0=''),
  1040 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1040, CurrentID=0, Status='live', Symbol='CDS1', Aliases='CDS', description='CDP-diacylglycerol synthase 1', other_designations='CDP-DAG synthase 1|CDP-DG synthase 1|CDP-DG synthetase 1|CDP-diacylglycerol synthase (phosphatidate cytidylyltransferase) 1|CDP-diglyceride pyrophosphorylase 1|CDP-diglyceride synthase 1|CDP-diglyceride synthetase 1|CDS 1|CTP:phosphatidate cytidylyltransferase 1', map_location='4q21.23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=84582904, end_position_on_the_genomic_accession=84651340, orientation='plus', exon_count=13, OMIM=603548, no_hdr0=''),
  1041 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1041, CurrentID=0, Status='live', Symbol='CDSN', Aliases='HTSS, HTSS1, HYPT2, PSS, PSS1, S', description='corneodesmosin', other_designations='differentiated keratinocyte S protein', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31115088, end_position_on_the_genomic_accession=31120475, orientation='minus', exon_count=2, OMIM=602593, no_hdr0=''),
  105373434 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105373434, CurrentID=0, Status='live', Symbol='LOC105373434', Aliases='', description='uncharacterized LOC105373434', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  1043 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1043, CurrentID=0, Status='live', Symbol='CD52', Aliases='CDW52', description='CD52 molecule', other_designations='CD52 antigen (CAMPATH-1 antigen)|CDW52 antigen (CAMPATH-1 antigen)|HEL-S-171mP|cambridge pathology 1 antigen|epididymal secretory protein E5|epididymis secretory sperm binding protein Li 171mP|he5|human epididymis-specific protein 5', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=26317920, end_position_on_the_genomic_accession=26320523, orientation='plus', exon_count=2, OMIM=114280, no_hdr0=''),
  1044 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1044, CurrentID=0, Status='live', Symbol='CDX1', Aliases='', description='caudal type homeobox 1', other_designations='caudal type homeo box transcription factor 1|caudal type homeobox transcription factor 1|caudal-type homeobox protein 1|caudal-type homeobox protein CDX1', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=150166781, end_position_on_the_genomic_accession=150184558, orientation='plus', exon_count=3, OMIM=600746, no_hdr0=''),
  1045 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1045, CurrentID=0, Status='live', Symbol='CDX2', Aliases='CDX-3/AS, CDX3, CDX2', description='caudal type homeobox 2', other_designations='caudal type homeo box transcription factor 2|caudal type homeobox transcription factor 2|caudal-type homeobox protein 2|homeobox protein miniCDX2', map_location='13q12.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=27960057, end_position_on_the_genomic_accession=27969368, orientation='minus', exon_count=5, OMIM=600297, no_hdr0=''),
  1046 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1046, CurrentID=0, Status='live', Symbol='CDX4', Aliases='', description='caudal type homeobox 4', other_designations='caudal type homeobox transcription factor 4|caudal-type homeobox protein 4', map_location='Xq13.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=73447254, end_position_on_the_genomic_accession=73454585, orientation='plus', exon_count=3, OMIM=300025, no_hdr0=''),
  1047 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1047, CurrentID=0, Status='live', Symbol='CLGN', Aliases='', description='calmegin', other_designations='', map_location='4q28.3-q31.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=140388453, end_position_on_the_genomic_accession=140427661, orientation='minus', exon_count=16, OMIM=601858, no_hdr0=''),
  1048 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1048, CurrentID=0, Status='live', Symbol='CEACAM5', Aliases='CD66e, CEA', description='carcinoembryonic antigen related cell adhesion molecule 5', other_designations='meconium antigen 100', map_location='19q13.1-q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41708611, end_position_on_the_genomic_accession=41730433, orientation='plus', exon_count=10, OMIM=114890, no_hdr0=''),
  1050 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1050, CurrentID=0, Status='live', Symbol='CEBPA', Aliases='C/EBP-alpha, CEBP', description='CCAAT/enhancer binding protein alpha', other_designations='CCAAT/enhancer binding protein (C/EBP), alpha', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=33299934, end_position_on_the_genomic_accession=33302564, orientation='minus', exon_count=1, OMIM=116897, no_hdr0=''),
  1051 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1051, CurrentID=0, Status='live', Symbol='CEBPB', Aliases='C/EBP-beta, IL6DBP, NF-IL6, TCF5', description='CCAAT/enhancer binding protein beta', other_designations='CCAAT/enhancer binding protein (C/EBP), beta|interleukin 6-dependent DNA-binding protein|nuclear factor NF-IL6|nuclear factor of interleukin 6|transcription factor 5|transcription factor C/EBP beta', map_location='20q13.1', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=50190583, end_position_on_the_genomic_accession=50192690, orientation='plus', exon_count=1, OMIM=189965, no_hdr0=''),
  1052 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1052, CurrentID=0, Status='live', Symbol='CEBPD', Aliases='C/EBP-delta, CELF, CRP3, NF-IL6-beta', description='CCAAT/enhancer binding protein delta', other_designations='CCAAT/enhancer binding protein (C/EBP), delta|c/EBP delta|nuclear factor NF-IL6-beta', map_location='8p11.2-p11.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=47736914, end_position_on_the_genomic_accession=47738164, orientation='minus', exon_count=1, OMIM=116898, no_hdr0=''),
  1053 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1053, CurrentID=0, Status='live', Symbol='CEBPE', Aliases='C/EBP-epsilon, CRP1', description='CCAAT/enhancer binding protein epsilon', other_designations='CCAAT/enhancer binding protein (C/EBP), epsilon|c/EBP epsilon', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=23117306, end_position_on_the_genomic_accession=23119985, orientation='minus', exon_count=3, OMIM=600749, no_hdr0=''),
  1054 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1054, CurrentID=0, Status='live', Symbol='CEBPG', Aliases='GPE1BP, IG/EBP-1', description='CCAAT/enhancer binding protein gamma', other_designations='CCAAT/enhancer binding protein (C/EBP), gamma|c/EBP gamma', map_location='19q13.11', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=33373669, end_position_on_the_genomic_accession=33382686, orientation='plus', exon_count=3, OMIM=138972, no_hdr0=''),
  1056 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1056, CurrentID=0, Status='live', Symbol='CEL', Aliases='BAL, BSDL, BSSLL, CEase, FAP, FAPP, LIPA, MODY8, CEL', description='carboxyl ester lipase', other_designations='bile salt-dependent lipase, oncofetal isoform|bucelipase|carboxyl ester hydrolase|carboxyl ester lipase (bile salt-stimulated lipase)|cholesterol esterase|fetoacinar pancreatic protein|lysophospholipase, pancreatic|sterol esterase', map_location='9q34.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=133061978, end_position_on_the_genomic_accession=133071863, orientation='plus', exon_count=11, OMIM=114840, no_hdr0=''),
  645984 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=645984, CurrentID=0, Status='live', Symbol='LOC645984', Aliases='', description='uncharacterized LOC645984', other_designations='', map_location='10p11.23', chromosome='10', genomic_nucleotide_accession_version='NC_000010.9', start_position_on_the_genomic_accession=31256940, end_position_on_the_genomic_accession=31259731, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  1058 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1058, CurrentID=0, Status='live', Symbol='CENPA', Aliases='CENP-A, CenH3', description='centromere protein A', other_designations='centromere autoantigen A|centromere protein A, 17kDa|centromere-specific histone', map_location='2p23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=26786014, end_position_on_the_genomic_accession=26794589, orientation='plus', exon_count=5, OMIM=117139, no_hdr0=''),
  1059 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1059, CurrentID=0, Status='live', Symbol='CENPB', Aliases='', description='centromere protein B', other_designations='CENP-B|centromere autoantigen B|centromere protein B, 80kDa', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=3783851, end_position_on_the_genomic_accession=3786690, orientation='minus', exon_count=1, OMIM=117140, no_hdr0=''),
  1060 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1060, CurrentID=0, Status='live', Symbol='CENPC', Aliases='CENP-C1, MIF2, hcp-4, CENPC', description='centromere protein C', other_designations='CENP-C 1|centromere autoantigen C|centromere autoantigen C1|centromere protein C 1|interphase centromere complex protein 7', map_location='4q13.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=67472271, end_position_on_the_genomic_accession=67545538, orientation='minus', exon_count=21, OMIM=117141, no_hdr0=''),
  1062 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1062, CurrentID=0, Status='live', Symbol='CENPE', Aliases='CENP-E, KIF10, MCPH13, PPP1R61', description='centromere protein E', other_designations='Centromere autoantigen E (312kD)|centromere protein E, 312kDa|kinesin family member 10|kinesin-related protein CENPE|protein phosphatase 1, regulatory subunit 61', map_location='4q24-q25', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=103105806, end_position_on_the_genomic_accession=103198409, orientation='minus', exon_count=49, OMIM=117143, no_hdr0=''),
  1063 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1063, CurrentID=0, Status='live', Symbol='CENPF', Aliases='CENF, CILD31, PRO1779, hcp-1', description='centromere protein F', other_designations='AH antigen|CENP-F kinetochore protein|cell-cycle-dependent 350K nuclear protein|centromere protein F, 350/400kDa (mitosin)|centromere protein F, 350/400ka (mitosin)|kinetochore protein CENPF|mitosin', map_location='1q41', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=214603179, end_position_on_the_genomic_accession=214664571, orientation='plus', exon_count=21, OMIM=600236, no_hdr0=''),
  731996 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=731996, CurrentID=0, Status='live', Symbol='LOC731996', Aliases='', description='uncharacterized LOC731996', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  1066 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1066, CurrentID=0, Status='live', Symbol='CES1', Aliases='ACAT, CE-1, CEH, CES2, HMSE, HMSE1, PCE-1, REH, SES1, TGH, hCE-1', description='carboxylesterase 1', other_designations='acyl coenzyme A:cholesterol acyltransferase|acyl-coenzyme A:cholesterol acyltransferase|brain carboxylesterase hBr1|carboxylesterase 1 (monocyte/macrophage serine esterase 1)|carboxylesterase 2 (liver)|cholesteryl ester hydrolase|cocaine carboxylesterase|egasyn|human monocyte/macrophage serine esterase 1|methylumbelliferyl-acetate deacetylase 1|monocyte/macrophage serine esterase|retinyl ester hydrolase|serine esterase 1|triacylglycerol hydrolase', map_location='16q22.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=55802851, end_position_on_the_genomic_accession=55833186, orientation='minus', exon_count=15, OMIM=114835, no_hdr0=''),
  1068 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1068, CurrentID=0, Status='live', Symbol='CETN1', Aliases='CEN1, CETN', description='centrin 1', other_designations='EF-hand protein|calcium binding protein|caltractin|centrin, EF-hand protein, 1', map_location='18p11.32', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=580343, end_position_on_the_genomic_accession=582020, orientation='plus', exon_count=1, OMIM=603187, no_hdr0=''),
  1069 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1069, CurrentID=0, Status='live', Symbol='CETN2', Aliases='CALT, CEN2', description='centrin 2', other_designations='caltractin (20kD calcium-binding protein)|centrin, EF-hand protein, 2', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=152827327, end_position_on_the_genomic_accession=152830757, orientation='minus', exon_count=5, OMIM=300006, no_hdr0=''),
  1070 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1070, CurrentID=0, Status='live', Symbol='CETN3', Aliases='CDC31, CEN3', description='centrin 3', other_designations='CDC31 yeast homolog|EF-hand superfamily member|centrin, EF-hand protein, 3 (CDC31 homolog, yeast)', map_location='5q14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=90393335, end_position_on_the_genomic_accession=90409786, orientation='minus', exon_count=6, OMIM=602907, no_hdr0=''),
  1071 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1071, CurrentID=0, Status='live', Symbol='CETP', Aliases='BPIFF, HDLCQ10', description='cholesteryl ester transfer protein, plasma', other_designations='BPI fold containing family F|cholesteryl ester transfer protein plasma|lipid transfer protein I', map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=56961923, end_position_on_the_genomic_accession=56983844, orientation='plus', exon_count=17, OMIM=118470, no_hdr0=''),
  1072 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1072, CurrentID=0, Status='live', Symbol='CFL1', Aliases='CFL, HEL-S-15, cofilin', description='cofilin 1', other_designations='18 kDa phosphoprotein|cofilin 1 (non-muscle)|cofilin, non-muscle isoform|epididymis secretory protein Li 15|p18', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65854811, end_position_on_the_genomic_accession=65858333, orientation='minus', exon_count=4, OMIM=601442, no_hdr0=''),
  1073 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1073, CurrentID=0, Status='live', Symbol='CFL2', Aliases='NEM7', description='cofilin 2', other_designations='cofilin 2 (muscle)|cofilin, muscle isoform|nemaline myopathy type 7', map_location='14q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=34710382, end_position_on_the_genomic_accession=34714823, orientation='minus', exon_count=6, OMIM=601443, no_hdr0=''),
  1075 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1075, CurrentID=0, Status='live', Symbol='CTSC', Aliases='CPPI, DPP-I, DPP1, DPPI, HMS, JP, JPD, PALS, PDON1, PLS', description='cathepsin C', other_designations='cathepsin J|dipeptidyl peptidase I|dipeptidyl transferase|dipeptidyl-peptidase I', map_location='11q14.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=88293592, end_position_on_the_genomic_accession=88337773, orientation='minus', exon_count=9, OMIM=602365, no_hdr0=''),
  105375817 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105375817, CurrentID=0, Status='live', Symbol='LOC105375817', Aliases='', description='POTE ankyrin domain family member A-like', other_designations='', map_location='', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=47100920, end_position_on_the_genomic_accession=47168769, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  100128265 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100128265, CurrentID=0, Status='live', Symbol='LOC100128265', Aliases='', description='uncharacterized LOC100128265', other_designations='', map_location='Xq27.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.9', start_position_on_the_genomic_accession=145507941, end_position_on_the_genomic_accession=145508828, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  1080 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1080, CurrentID=0, Status='live', Symbol='CFTR', Aliases='ABC35, ABCC7, CF/MRP, MRP7, TNR-CFTR, dJ760C5.1, CFTR', description='cystic fibrosis transmembrane conductance regulator', other_designations='cAMP-dependent chloride channel|channel conductance-controlling ATPase|cystic fibrosis transmembrane conductance regulator (ATP-binding cassette sub-family C, member 7)', map_location='7q31.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=117478340, end_position_on_the_genomic_accession=117668665, orientation='plus', exon_count=33, OMIM=602421, no_hdr0=''),
  1081 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1081, CurrentID=0, Status='live', Symbol='CGA', Aliases='CG-ALPHA, FSHA, GPHA1, GPHa, HCG, LHA, TSHA', description='glycoprotein hormones, alpha polypeptide', other_designations='FSH-alpha|LSH-alpha|TSH-alpha|anterior pituitary glycoprotein hormones common subunit alpha|choriogonadotropin alpha chain|chorionic gonadotrophin subunit alpha|chorionic gonadotropin, alpha polypeptide|follicle-stimulating hormone alpha chain|follicle-stimulating hormone alpha subunit|follitropin alpha chain|luteinizing hormone alpha chain|lutropin alpha chain|thyroid-stimulating hormone alpha chain|thyrotropin alpha chain', map_location='6q14.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=87085498, end_position_on_the_genomic_accession=87095147, orientation='minus', exon_count=5, OMIM=118850, no_hdr0=''),
  1082 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1082, CurrentID=0, Status='live', Symbol='CGB3', Aliases='CGB, CGB5, CGB7, CGB8, hCGB', description='chorionic gonadotropin beta subunit 3', other_designations='CG-beta|chorionic gonadotrophin chain beta|chorionic gonadotropin beta 3 subunit|chorionic gonadotropin beta chain|chorionic gonadotropin beta subunit|chorionic gonadotropin, beta polypeptide', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=49022869, end_position_on_the_genomic_accession=49024375, orientation='minus', exon_count=3, OMIM=118860, no_hdr0=''),
  1084 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1084, CurrentID=0, Status='live', Symbol='CEACAM3', Aliases='CD66D, CEA, CGM1, W264, W282', description='carcinoembryonic antigen related cell adhesion molecule 3', other_designations='CD66d antigen|carcinoembryonic antigen CGM1|carcinoembryonic antigen gene family member 1|nonspecific cross-reacting antigen', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41796590, end_position_on_the_genomic_accession=41811553, orientation='plus', exon_count=8, OMIM=609142, no_hdr0=''),
  105378105 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105378105, CurrentID=0, Status='live', Symbol='LOC105378105', Aliases='', description='uncharacterized LOC105378105', other_designations='', map_location='', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=163711976, end_position_on_the_genomic_accession=163714377, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  132158 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132158, CurrentID=0, Status='live', Symbol='GLYCTK', Aliases='HBEBP2, HBEBP4, HBeAgBP4A', description='glycerate kinase', other_designations='HBeAg binding protein 4|HBeAg-binding protein 2', map_location='3p21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=52287820, end_position_on_the_genomic_accession=52295256, orientation='plus', exon_count=5, OMIM=610516, no_hdr0=''),
  1087 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1087, CurrentID=0, Status='live', Symbol='CEACAM7', Aliases='CGM2', description='carcinoembryonic antigen related cell adhesion molecule 7', other_designations='carcinoembryonic antigen CGM2|carcinoembryonic antigen gene family member 2', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41673307, end_position_on_the_genomic_accession=41688277, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  1088 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1088, CurrentID=0, Status='live', Symbol='CEACAM8', Aliases='CD66b, CD67, CGM6, NCA-95', description='carcinoembryonic antigen related cell adhesion molecule 8', other_designations='CD67 antigen|carcinoembryonic antigen CGM6|carcinoembryonic antigen gene family member 6|non-specific cross-reacting antigen NCA-95', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=42580243, end_position_on_the_genomic_accession=42594939, orientation='minus', exon_count=8, OMIM=615747, no_hdr0=''),
  1089 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1089, CurrentID=0, Status='live', Symbol='CEACAM4', Aliases='CGM7, CGM7_HUMAN, NCA', description='carcinoembryonic antigen related cell adhesion molecule 4', other_designations='Nonspecific cross-reacting antigen (NCA)|carcinoembryonic antigen CGM7|carcinoembryonic antigen gene family member 7|carcinoembryonic antigen-related cell adhesion molecule 4-sv1|carcinoembryonic antigen-related cell adhesion molecule 4-sv2|non-specific cross-reacting antigen W236|nonspecific cross-reacting antigen W236', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41616986, end_position_on_the_genomic_accession=41627084, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  166979 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=166979, CurrentID=0, Status='live', Symbol='CDC20B', Aliases='G6VTS76519', description='cell division cycle 20B', other_designations='CDC20 cell division cycle 20 homolog B|CDC20-like protein|cell division cycle 20 homolog B', map_location='5q11.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=55112971, end_position_on_the_genomic_accession=55173177, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  81871 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=81871, CurrentID=0, Status='live', Symbol='KRTAP4-6', Aliases='KAP4.15, KAP4.6, KRTAP4-15, KRTAP4.15', description='keratin associated protein 4-6', other_designations='keratin associated protein 4-15|keratin-associated protein 4.6|ultrahigh sulfur keratin-associated protein 4.15', map_location='17q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=41139433, end_position_on_the_genomic_accession=41140487, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11105 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=11105, CurrentID=0, Status='live', Symbol='PRDM7', Aliases='PFM4, ZNF910', description='PR domain 7', other_designations='PR domain containing 7|PR domain zinc finger protein 7|PR-domain family protein 4', map_location='16q24.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=90056566, end_position_on_the_genomic_accession=90077339, orientation='minus', exon_count=11, OMIM=609759, no_hdr0=''),
  112611 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=112611, CurrentID=0, Status='live', Symbol='RWDD2A', Aliases='RWDD2, dJ747H23.2', description='RWD domain containing 2A', other_designations='RWD domain containing 2', map_location='6q14.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=83193313, end_position_on_the_genomic_accession=83198932, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  55684 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=55684, CurrentID=0, Status='live', Symbol='RABL6', Aliases='C9orf86, PARF, RBEL1, pp8875', description='RAB, member RAS oncogene family-like 6', other_designations='Rab-like GTP-binding protein 1C|partner of ARF|putative GTP-binding protein Parf', map_location='9q34.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=136807922, end_position_on_the_genomic_accession=136841187, orientation='plus', exon_count=16, OMIM=610615, no_hdr0=''),
  1101 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1101, CurrentID=0, Status='live', Symbol='CHAD', Aliases='SLRR4A', description='chondroadherin', other_designations='cartilage leucine-rich protein|chondroadherin proteoglycan', map_location='17q21.33', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=50464492, end_position_on_the_genomic_accession=50469881, orientation='minus', exon_count=4, OMIM=602178, no_hdr0=''),
  1102 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1102, CurrentID=0, Status='live', Symbol='RCBTB2', Aliases='CHC1L, RLG', description='RCC1 and BTB domain containing protein 2', other_designations='RCC1-like G exchanging factor RLG|regulator of chromosome condensation (RCC1) and BTB (POZ) domain containing protein 2', map_location='13q14.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=48488963, end_position_on_the_genomic_accession=48533256, orientation='minus', exon_count=16, OMIM=603524, no_hdr0=''),
  1103 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1103, CurrentID=0, Status='live', Symbol='CHAT', Aliases='CHOACTASE, CMS1A, CMS1A2, CMS6', description='choline O-acetyltransferase', other_designations='acetyl CoA:choline O-acetyltransferase|choline acetylase', map_location='10q11.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=49609095, end_position_on_the_genomic_accession=49665104, orientation='plus', exon_count=18, OMIM=118490, no_hdr0=''),
  1104 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1104, CurrentID=0, Status='live', Symbol='RCC1', Aliases='CHC1-I, SNHG3-RCC1, RCC1', description='regulator of chromosome condensation 1', other_designations='SNHG3-RCC1 readthrough|cell cycle regulatory protein|guanine nucleotide-releasing protein', map_location='1p36.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=28505943, end_position_on_the_genomic_accession=28539196, orientation='plus', exon_count=15, OMIM=179710, no_hdr0=''),
  1105 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1105, CurrentID=0, Status='live', Symbol='CHD1', Aliases='', description='chromodomain helicase DNA binding protein 1', other_designations='ATP-dependent helicase CHD1|CHD-1', map_location='5q15-q21', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=98855204, end_position_on_the_genomic_accession=98928623, orientation='minus', exon_count=37, OMIM=602118, no_hdr0=''),
  1106 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1106, CurrentID=0, Status='live', Symbol='CHD2', Aliases='EEOC', description='chromodomain helicase DNA binding protein 2', other_designations='ATP-dependent helicase CHD2|CHD-2', map_location='15q26', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=92900321, end_position_on_the_genomic_accession=93028007, orientation='plus', exon_count=39, OMIM=602119, no_hdr0=''),
  1107 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1107, CurrentID=0, Status='live', Symbol='CHD3', Aliases='Mi-2a, Mi2-ALPHA, ZFH', description='chromodomain helicase DNA binding protein 3', other_designations='ATP-dependent helicase CHD3|CHD-3|hZFH|mi-2 autoantigen 240 kDa protein|zinc finger helicase|zinc-finger helicase (Snf2-like)', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7884776, end_position_on_the_genomic_accession=7912757, orientation='plus', exon_count=45, OMIM=602120, no_hdr0=''),
  1108 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1108, CurrentID=0, Status='live', Symbol='CHD4', Aliases='CHD-4, Mi-2b, Mi2-BETA', description='chromodomain helicase DNA binding protein 4', other_designations='ATP-dependent helicase CHD4|Mi-2 autoantigen 218 kDa protein', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6570082, end_position_on_the_genomic_accession=6607439, orientation='minus', exon_count=40, OMIM=603277, no_hdr0=''),
  1109 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1109, CurrentID=0, Status='live', Symbol='AKR1C4', Aliases='3-alpha-HSD, C11, CDR, CHDR, DD-4, DD4, HAKRA', description='aldo-keto reductase family 1, member C4', other_designations='3-alpha-HSD1|chlordecone reductase; 3-alpha hydroxysteroid dehydrogenase, type I; dihydrodiol dehydrogenase 4|dihydrodiol dehydrogenase isozyme DD4|type I 3-alpha-hydroxysteroid dehydrogenase', map_location='10p15.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=5196809, end_position_on_the_genomic_accession=5220633, orientation='plus', exon_count=9, OMIM=600451, no_hdr0=''),
  1111 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1111, CurrentID=0, Status='live', Symbol='CHEK1', Aliases='CHK1', description='checkpoint kinase 1', other_designations='CHK1 checkpoint homolog|Checkpoint, S. pombe, homolog of, 1|Chk1-S|cell cycle checkpoint kinase|checkpoint kinase-1', map_location='11q24.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=125624920, end_position_on_the_genomic_accession=125676259, orientation='plus', exon_count=16, OMIM=603078, no_hdr0=''),
  1112 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1112, CurrentID=0, Status='live', Symbol='FOXN3', Aliases='C14orf116, CHES1, PRO1635', description='forkhead box N3', other_designations='checkpoint suppressor 1', map_location='14q31.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=89156172, end_position_on_the_genomic_accession=89619150, orientation='minus', exon_count=8, OMIM=602628, no_hdr0=''),
  1113 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1113, CurrentID=0, Status='live', Symbol='CHGA', Aliases='CGA', description='chromogranin A', other_designations='SP-I|betagranin (N-terminal fragment of chromogranin A)|catestatin|chromofungin|parathyroid secretory protein 1|pituitary secretory protein I', map_location='14q32', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=92922589, end_position_on_the_genomic_accession=92935293, orientation='plus', exon_count=9, OMIM=118910, no_hdr0=''),
  1114 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1114, CurrentID=0, Status='live', Symbol='CHGB', Aliases='SCG1', description='chromogranin B', other_designations='cgB|chromogranin-B|secretogranin B|secretogranin I|sgI', map_location='20p12.3', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=5911328, end_position_on_the_genomic_accession=5925361, orientation='plus', exon_count=5, OMIM=118920, no_hdr0=''),
  105375302 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105375302, CurrentID=0, Status='live', Symbol='LOC105375302', Aliases='', description='protein FAM182A-like', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=57770209, end_position_on_the_genomic_accession=57840981, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  1116 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1116, CurrentID=0, Status='live', Symbol='CHI3L1', Aliases='ASRT7, CGP-39, GP-39, GP39, HC-gp39, HCGP-3P, YKL-40, YKL40, YYL-40, hCGP-39', description='chitinase 3 like 1', other_designations='39 kDa synovial protein|cartilage glycoprotein 39|chitinase 3-like 1 (cartilage glycoprotein-39)', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=203178931, end_position_on_the_genomic_accession=203186960, orientation='minus', exon_count=10, OMIM=601525, no_hdr0=''),
  1117 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1117, CurrentID=0, Status='live', Symbol='CHI3L2', Aliases='CHIL2, YKL-39, YKL39', description='chitinase 3 like 2', other_designations='chitinase 3-like 2|chondrocyte protein 39', map_location='1p13.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=111227659, end_position_on_the_genomic_accession=111243440, orientation='plus', exon_count=11, OMIM=601526, no_hdr0=''),
  1118 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1118, CurrentID=0, Status='live', Symbol='CHIT1', Aliases='CHI3, CHIT, CHITD', description='chitinase 1', other_designations='chitinase 1 (chitotriosidase)|plasma methylumbelliferyl tetra-N-acetylchitotetraoside hydrolase', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=203212823, end_position_on_the_genomic_accession=203230099, orientation='minus', exon_count=15, OMIM=600031, no_hdr0=''),
  1119 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1119, CurrentID=0, Status='live', Symbol='CHKA', Aliases='CHK, CK, CKI, EK', description='choline kinase alpha', other_designations='CHETK-alpha|ethanolamine kinase', map_location='11q13.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=68052859, end_position_on_the_genomic_accession=68121391, orientation='minus', exon_count=17, OMIM=118491, no_hdr0=''),
  1120 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1120, CurrentID=0, Status='live', Symbol='CHKB', Aliases='CHETK, CHKL, CK, CKB, CKEKB, EK, EKB, MDCMC', description='choline kinase beta', other_designations='choline kinase-like protein|ethanolamine kinase beta', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50578958, end_position_on_the_genomic_accession=50582999, orientation='minus', exon_count=11, OMIM=612395, no_hdr0=''),
  1121 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1121, CurrentID=0, Status='live', Symbol='CHM', Aliases='DXS540, GGTA, HSD-32, REP-1, TCD', description='choroideremia (Rab escort protein 1)', other_designations='', map_location='Xq21.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=85861180, end_position_on_the_genomic_accession=86047562, orientation='minus', exon_count=18, OMIM=300390, no_hdr0=''),
  1122 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1122, CurrentID=0, Status='live', Symbol='CHML', Aliases='REP2', description='choroideremia-like (Rab escort protein 2)', other_designations='choroideraemia-like protein|choroideremia-like protein', map_location='1q43', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=241628864, end_position_on_the_genomic_accession=241635930, orientation='minus', exon_count=1, OMIM=118825, no_hdr0=''),
  1123 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1123, CurrentID=0, Status='live', Symbol='CHN1', Aliases='ARHGAP2, CHN, DURS2, NC, RHOGAP2', description='chimerin 1', other_designations='A-chimaerin|Rho GTPase-activating protein 2|a2-chimaerin|alpha-chimerin|chimaerin 1|chimerin (chimaerin) 1|n-chimerin', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=174799314, end_position_on_the_genomic_accession=175005379, orientation='minus', exon_count=14, OMIM=118423, no_hdr0=''),
  1124 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1124, CurrentID=0, Status='live', Symbol='CHN2', Aliases='ARHGAP3, BCH-3, RHOGAP3, CHN2', description='chimerin 2', other_designations='beta-chimerin|beta3-chimaerin|chimerin (chimaerin) 2|chimerin, beta-2|chimerin, testis-specific|rho-GTPase-activating protein 3', map_location='7p15.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=29146547, end_position_on_the_genomic_accession=29514335, orientation='plus', exon_count=21, OMIM=602857, no_hdr0=''),
  1128 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1128, CurrentID=0, Status='live', Symbol='CHRM1', Aliases='HM1, M1, M1R', description='cholinergic receptor, muscarinic 1', other_designations='acetylcholine receptor, muscarinic 1', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=62908679, end_position_on_the_genomic_accession=62921861, orientation='minus', exon_count=3, OMIM=118510, no_hdr0=''),
  1129 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1129, CurrentID=0, Status='live', Symbol='CHRM2', Aliases='HM2', description='cholinergic receptor, muscarinic 2', other_designations='7TM receptor|acetylcholine receptor, muscarinic 2|muscarinic M2 receptor', map_location='7q31-q35', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=136868652, end_position_on_the_genomic_accession=137020255, orientation='plus', exon_count=9, OMIM=118493, no_hdr0=''),
  1130 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1130, CurrentID=0, Status='live', Symbol='LYST', Aliases='CHS, CHS1', description='lysosomal trafficking regulator', other_designations='Chediak-Higashi syndrome 1|beige homolog', map_location='1q42.1-q42.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=235661031, end_position_on_the_genomic_accession=235883708, orientation='minus', exon_count=61, OMIM=606897, no_hdr0=''),
  1131 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1131, CurrentID=0, Status='live', Symbol='CHRM3', Aliases='EGBRS, HM3, PBS', description='cholinergic receptor, muscarinic 3', other_designations='acetylcholine receptor, muscarinic 3|m3 muscarinic receptor', map_location='1q43', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=239386518, end_position_on_the_genomic_accession=239387227, orientation='plus', exon_count=12, OMIM=118494, no_hdr0=''),
  1132 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1132, CurrentID=0, Status='live', Symbol='CHRM4', Aliases='HM4, M4R', description='cholinergic receptor, muscarinic 4', other_designations='acetylcholine receptor, muscarinic 4', map_location='11p12-p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=46384792, end_position_on_the_genomic_accession=46386608, orientation='minus', exon_count=1, OMIM=118495, no_hdr0=''),
  1133 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1133, CurrentID=0, Status='live', Symbol='CHRM5', Aliases='HM5', description='cholinergic receptor, muscarinic 5', other_designations='acetylcholine receptor, muscarinic 5', map_location='15q26', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=33968245, end_position_on_the_genomic_accession=34065094, orientation='plus', exon_count=4, OMIM=118496, no_hdr0=''),
  1134 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1134, CurrentID=0, Status='live', Symbol='CHRNA1', Aliases='ACHRA, ACHRD, CHRNA, CMS1A, CMS1B, CMS2A, FCCMS, SCCMS', description='cholinergic receptor nicotinic alpha 1 subunit', other_designations='acetylcholine receptor, nicotinic, alpha 1 (muscle)|cholinergic receptor, nicotinic alpha 1|cholinergic receptor, nicotinic, alpha 1 (muscle)|cholinergic receptor, nicotinic, alpha polypeptide 1 (muscle)|muscle nicotinic acetylcholine receptor|nicotinic acetylcholine receptor alpha subunit|nicotinic cholinergic receptor alpha 1', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=174747592, end_position_on_the_genomic_accession=174764472, orientation='minus', exon_count=10, OMIM=100690, no_hdr0=''),
  1135 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1135, CurrentID=0, Status='live', Symbol='CHRNA2', Aliases='', description='cholinergic receptor nicotinic alpha 2 subunit', other_designations='acetylcholine receptor, nicotinic, alpha 2 (neuronal)|cholinergic receptor, nicotinic alpha 2|cholinergic receptor, nicotinic, alpha 2 (neuronal)|cholinergic receptor, nicotinic, alpha polypeptide 2 (neuronal)', map_location='8p21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=27459761, end_position_on_the_genomic_accession=27479296, orientation='minus', exon_count=8, OMIM=118502, no_hdr0=''),
  1136 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1136, CurrentID=0, Status='live', Symbol='CHRNA3', Aliases='LNCR2, NACHRA3, PAOD2', description='cholinergic receptor nicotinic alpha 3 subunit', other_designations='cholinergic receptor, nicotinic alpha 3|cholinergic receptor, nicotinic, alpha 3 (neuronal)|cholinergic receptor, nicotinic, alpha polypeptide 3|neuronal nicotinic acetylcholine receptor, alpha3 subunit', map_location='15q24', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78593052, end_position_on_the_genomic_accession=78621295, orientation='minus', exon_count=10, OMIM=118503, no_hdr0=''),
  1137 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1137, CurrentID=0, Status='live', Symbol='CHRNA4', Aliases='BFNC, EBN, EBN1, NACHR, NACHRA4, NACRA4', description='cholinergic receptor nicotinic alpha 4 subunit', other_designations='cholinergic receptor, nicotinic alpha 4|cholinergic receptor, nicotinic, alpha 4 (neuronal)|cholinergic receptor, nicotinic, alpha polypeptide 4|neuronal nicotinic acetylcholine receptor alpha-4 subunit', map_location='20q13.33', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=63343310, end_position_on_the_genomic_accession=63361396, orientation='minus', exon_count=7, OMIM=118504, no_hdr0=''),
  1138 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1138, CurrentID=0, Status='live', Symbol='CHRNA5', Aliases='LNCR2', description='cholinergic receptor nicotinic alpha 5 subunit', other_designations='Cholinergic receptor, neuronal nicotinic, alpha polypeptide-5|acetylcholine receptor, nicotinic, alpha 5 (neuronal)|cholinergic receptor, nicotinic alpha 5|cholinergic receptor, nicotinic, alpha 5 (neuronal)|neuronal nicotinic acetylcholine receptor, alpha5 subunit', map_location='15q24', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78565520, end_position_on_the_genomic_accession=78595269, orientation='plus', exon_count=6, OMIM=118505, no_hdr0=''),
  1139 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1139, CurrentID=0, Status='live', Symbol='CHRNA7', Aliases='CHRNA7-2, NACHRA7', description='cholinergic receptor nicotinic alpha 7 subunit', other_designations='a7 nicotinic acetylcholine receptor|alpha 7 neuronal nicotinic acetylcholine receptor|alpha-7 nicotinic cholinergic receptor subunit|cholinergic receptor, nicotinic alpha 7|cholinergic receptor, nicotinic, alpha 7 (neuronal)|cholinergic receptor, nicotinic, alpha polypeptide 7|neuronal acetylcholine receptor protein, alpha-7 chain', map_location='15q14', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=32030483, end_position_on_the_genomic_accession=32172521, orientation='plus', exon_count=13, OMIM=118511, no_hdr0=''),
  1140 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1140, CurrentID=0, Status='live', Symbol='CHRNB1', Aliases='ACHRB, CHRNB, CMS1D, CMS2A, CMS2C, SCCMS', description='cholinergic receptor nicotinic beta 1 subunit', other_designations='acetylcholine receptor, nicotinic, beta 1 (muscle)|cholinergic receptor, nicotinic beta 1|cholinergic receptor, nicotinic, beta 1 (muscle)|cholinergic receptor, nicotinic, beta polypeptide 1 (muscle)', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7445087, end_position_on_the_genomic_accession=7457613, orientation='plus', exon_count=11, OMIM=100710, no_hdr0=''),
  1141 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1141, CurrentID=0, Status='live', Symbol='CHRNB2', Aliases='EFNL3, nAChRB2', description='cholinergic receptor nicotinic beta 2 subunit', other_designations='acetylcholine receptor, nicotinic, beta 2 (neuronal)|beta2 human neuronal nicotinic acetylcholine receptor|cholinergic receptor, nicotinic beta 2|cholinergic receptor, nicotinic, beta 2 (neuronal)|cholinergic receptor, nicotinic, beta polypeptide 2 (neuronal)|neuronal nicotinic acetylcholine receptor beta 2', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=154567781, end_position_on_the_genomic_accession=154579878, orientation='plus', exon_count=6, OMIM=118507, no_hdr0=''),
  1142 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1142, CurrentID=0, Status='live', Symbol='CHRNB3', Aliases='', description='cholinergic receptor nicotinic beta 3 subunit', other_designations='acetylcholine receptor, neuronal nicotinic, beta-3 subunit|acetylcholine receptor, nicotinic, beta 3 (neuronal)|cholinergic receptor, nicotinic beta 3|cholinergic receptor, nicotinic, beta 3 (neuronal)|cholinergic receptor, nicotinic, beta polypeptide 3', map_location='8p11.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=42697419, end_position_on_the_genomic_accession=42737407, orientation='plus', exon_count=7, OMIM=118508, no_hdr0=''),
  1143 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1143, CurrentID=0, Status='live', Symbol='CHRNB4', Aliases='', description='cholinergic receptor nicotinic beta 4 subunit', other_designations='acetylcholine receptor, nicotinic, beta 4 (neuronal)|cholinergic receptor, nicotinic beta 4|cholinergic receptor, nicotinic, beta 4 (neuronal)|cholinergic receptor, nicotinic, beta polypeptide 4|neuronal nicotinic receptor beta 4 subunit', map_location='15q24', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78623297, end_position_on_the_genomic_accession=78655586, orientation='minus', exon_count=18, OMIM=118509, no_hdr0=''),
  1144 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1144, CurrentID=0, Status='live', Symbol='CHRND', Aliases='ACHRD, CMS2A, CMS3A, CMS3B, CMS3C, FCCMS, SCCMS', description='cholinergic receptor nicotinic delta subunit', other_designations='acetylcholine receptor, nicotinic, delta (muscle)|cholinergic receptor, nicotinic delta|cholinergic receptor, nicotinic, delta (muscle)|cholinergic receptor, nicotinic, delta polypeptide', map_location='2q37.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232526160, end_position_on_the_genomic_accession=232536665, orientation='plus', exon_count=12, OMIM=100720, no_hdr0=''),
  1145 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1145, CurrentID=0, Status='live', Symbol='CHRNE', Aliases='ACHRE, CMS1D, CMS1E, CMS2A, CMS4A, CMS4B, CMS4C, FCCMS, SCCMS', description='cholinergic receptor nicotinic epsilon subunit', other_designations='AchR epsilon subunit|acetylcholine receptor, nicotinic, epsilon (muscle)|cholinergic receptor, nicotinic epsilon|cholinergic receptor, nicotinic, epsilon (muscle)|cholinergic receptor, nicotinic, epsilon polypeptide', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=4897769, end_position_on_the_genomic_accession=4903128, orientation='minus', exon_count=12, OMIM=100725, no_hdr0=''),
  1146 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1146, CurrentID=0, Status='live', Symbol='CHRNG', Aliases='ACHRG', description='cholinergic receptor nicotinic gamma subunit', other_designations='acetylcholine receptor, muscle, gamma subunit|acetylcholine receptor, nicotinic, gamma (muscle)|cholinergic receptor, nicotinic gamma|cholinergic receptor, nicotinic, gamma (muscle)|cholinergic receptor, nicotinic, gamma polypeptide', map_location='2q37.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232539727, end_position_on_the_genomic_accession=232546328, orientation='plus', exon_count=12, OMIM=100730, no_hdr0=''),
  1147 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1147, CurrentID=0, Status='live', Symbol='CHUK', Aliases='IKBKA, IKK-alpha, IKK1, IKKA, NFKBIKA, TCF16', description='conserved helix-loop-helix ubiquitous kinase', other_designations='I-kappa-B kinase 1|I-kappa-B kinase-alpha|IKK-a kinase|IkB kinase alpha subunit|Nuclear factor NFkappaB inhibitor kinase alpha|TCF-16|transcription factor 16', map_location='10q24-q25', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=100186113, end_position_on_the_genomic_accession=100229610, orientation='minus', exon_count=23, OMIM=600664, no_hdr0=''),
  1149 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1149, CurrentID=0, Status='live', Symbol='CIDEA', Aliases='CIDE-A', description='cell death-inducing DFFA-like effector a', other_designations='', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=12254319, end_position_on_the_genomic_accession=12277595, orientation='plus', exon_count=6, OMIM=604440, no_hdr0=''),
  1152 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1152, CurrentID=0, Status='live', Symbol='CKB', Aliases='B-CK, BCKB, HEL-211, HEL-S-29, CKB', description='creatine kinase, brain', other_designations='creatine kinase B chain|creatine kinase brain|creatine kinase-B|epididymis luminal protein 211|epididymis secretory protein Li 29', map_location='14q32', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=103519658, end_position_on_the_genomic_accession=103522859, orientation='minus', exon_count=8, OMIM=123280, no_hdr0=''),
  1153 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1153, CurrentID=0, Status='live', Symbol='CIRBP', Aliases='CIRP', description='cold inducible RNA binding protein', other_designations='A18 hnRNP|cold inducible RNA-binding protein|glycine-rich RNA binding protein', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1269266, end_position_on_the_genomic_accession=1274810, orientation='plus', exon_count=9, OMIM=602649, no_hdr0=''),
  1154 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1154, CurrentID=0, Status='live', Symbol='CISH', Aliases='BACTS2, CIS, CIS-1, G18, SOCS', description='cytokine inducible SH2-containing protein', other_designations='cytokine-inducible inhibitor of signaling type 1B|suppressor of cytokine signaling', map_location='3p21.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=50606454, end_position_on_the_genomic_accession=50611831, orientation='minus', exon_count=4, OMIM=602441, no_hdr0=''),
  1155 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1155, CurrentID=0, Status='live', Symbol='TBCB', Aliases='CG22, CKAP1, CKAPI', description='tubulin folding cofactor B', other_designations='cytoskeleton associated protein 1|cytoskeleton-associated protein CKAPI|tubulin-specific chaperone B', map_location='19q13.11-q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=36114986, end_position_on_the_genomic_accession=36125948, orientation='plus', exon_count=7, OMIM=601303, no_hdr0=''),
  132228 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132228, CurrentID=0, Status='live', Symbol='LSMEM2', Aliases='C3orf45', description='leucine-rich single-pass membrane protein 2', other_designations='', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=50277915, end_position_on_the_genomic_accession=50288114, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  1158 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1158, CurrentID=0, Status='live', Symbol='CKM', Aliases='CKMM, M-CK', description='creatine kinase, M-type', other_designations='creatine kinase M chain|creatine kinase, muscle', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45306413, end_position_on_the_genomic_accession=45322977, orientation='minus', exon_count=8, OMIM=123310, no_hdr0=''),
  1159 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1159, CurrentID=0, Status='live', Symbol='CKMT1B', Aliases='CKMT, CKMT1, UMTCK', description='creatine kinase, mitochondrial 1B', other_designations='U-MtCK|acidic-type mitochondrial creatine kinase|creatine kinase, mitochondrial 1 (ubiquitous)|mia-CK|ubiquitous mitochondrial creatine kinase', map_location='15q15', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=43592862, end_position_on_the_genomic_accession=43599406, orientation='plus', exon_count=10, OMIM=123290, no_hdr0=''),
  1160 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1160, CurrentID=0, Status='live', Symbol='CKMT2', Aliases='SMTCK', description='creatine kinase, mitochondrial 2', other_designations='S-MtCK|basic-type mitochondrial creatine kinase|creatine kinase, mitochondrial 2 (sarcomeric)|mib-CK|sarcomeric mitochondrial creatine kinase', map_location='5q13.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=81233320, end_position_on_the_genomic_accession=81266398, orientation='plus', exon_count=11, OMIM=123295, no_hdr0=''),
  1161 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1161, CurrentID=0, Status='live', Symbol='ERCC8', Aliases='CKN1, CSA, UVSS2', description='excision repair cross-complementation group 8', other_designations='Cockayne syndrome WD-repeat protein CSA|cockayne syndrome WD repeat protein CSA|excision repair cross-complementing rodent repair deficiency complementation group 8|excision repair cross-complementing rodent repair deficiency, complementation group 8', map_location='5q12.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=60873832, end_position_on_the_genomic_accession=60945078, orientation='minus', exon_count=13, OMIM=609412, no_hdr0=''),
  1163 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1163, CurrentID=0, Status='live', Symbol='CKS1B', Aliases='CKS1, PNAS-16, PNAS-18, ckshs1', description='CDC28 protein kinase regulatory subunit 1B', other_designations='CDC2-associated protein CKS1|CDC28 protein kinase 1|CDC28 protein kinase 1B|CKS-1|NB4 apoptosis/differentiation related protein|PNAS-143|cell division control protein CKS1', map_location='1q21.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=154974642, end_position_on_the_genomic_accession=154979249, orientation='plus', exon_count=3, OMIM=116900, no_hdr0=''),
  1164 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1164, CurrentID=0, Status='live', Symbol='CKS2', Aliases='CKSHS2', description='CDC28 protein kinase regulatory subunit 2', other_designations='CDC28 protein kinase 2|CKS-2|CKS1(S. cerevisiae Cdc28/Cdc2 kinase subunit) homolog-2', map_location='9q22', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=89311195, end_position_on_the_genomic_accession=89316703, orientation='plus', exon_count=3, OMIM=116901, no_hdr0=''),
  147650 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=147650, CurrentID=0, Status='live', Symbol='SPACA6', Aliases='LET7EH, LINC00085, NCRNA00085P, SPACA6', description='sperm acrosome associated 6', other_designations='BACHELOR-like protein|Let-7e host|long intergenic non-protein coding RNA 85|sperm acrosome associated 6, pseudogene', map_location='19q13.41', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=51693340, end_position_on_the_genomic_accession=51705190, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  254272 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=254272, CurrentID=0, Status='live', Symbol='TBC1D28', Aliases='', description='TBC1 domain family member 28', other_designations='TBC1 domain family, member 28', map_location='17p11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=18634434, end_position_on_the_genomic_accession=18644433, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  284184 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284184, CurrentID=0, Status='live', Symbol='C17orf89', Aliases='', description='chromosome 17 open reading frame 89', other_designations='', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=81239311, end_position_on_the_genomic_accession=81241298, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  132243 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132243, CurrentID=0, Status='live', Symbol='H1FOO', Aliases='H1.8, H1oo, osH1', description='H1 histone family member O, oocyte specific', other_designations='H1 histone family, member O, oocyte-specific|oocyte-specific histone H1|oocyte-specific linker histone H1', map_location='3q22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=129543214, end_position_on_the_genomic_accession=129551467, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  1173 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1173, CurrentID=0, Status='live', Symbol='AP2M1', Aliases='AP50, CLAPM1, mu2', description='adaptor related protein complex 2 mu 1 subunit', other_designations='AP-2 mu 2 chain|HA2 50 kDA subunit|adaptin-mu2|adaptor protein complex AP-2 subunit mu|adaptor related protein complex 2, mu 1 subunit|adaptor-related protein complex 2 subunit mu|adaptor-related protein complex 2, mu 1 subunit|clathrin adaptor complex AP2, mu subunit|clathrin assembly protein complex 2 medium chain|clathrin assembly protein complex 2 mu medium chain|clathrin coat adaptor protein AP50|clathrin coat assembly protein AP50|clathrin coat-associated protein AP50|clathrin-associated/assembly/adaptor protein, medium 1|plasma membrane adaptor AP-2 50 kDa protein|plasma membrane adaptor AP-2 50kDA protein', map_location='3q28', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184174846, end_position_on_the_genomic_accession=184184091, orientation='plus', exon_count=12, OMIM=601024, no_hdr0=''),
  1174 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1174, CurrentID=0, Status='live', Symbol='AP1S1', Aliases='AP19, CLAPS1, EKV3, MEDNIK, SIGMA1A', description='adaptor related protein complex 1 sigma 1 subunit', other_designations='HA1 19 kDa subunit|adapter-related protein complex 1 sigma-1A subunit|adaptor protein complex AP-1 subunit sigma-1A|adaptor-related protein complex 1 sigma 1 subunit|adaptor-related protein complex 1 subunit sigma-1A|adaptor-related protein complex 1, sigma 1 subunit|clathrin assembly protein complex 1 sigma-1A small chain|clathrin coat assembly protein AP19|clathrin-associated/assembly/adaptor protein, small 1 (19kD)|golgi adaptor HA1/AP1 adaptin sigma-1A subunit|sigma1A subunit of AP-1 clathrin adaptor complex|sigma1A-adaptin', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=101154405, end_position_on_the_genomic_accession=101161276, orientation='plus', exon_count=5, OMIM=603531, no_hdr0=''),
  1175 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1175, CurrentID=0, Status='live', Symbol='AP2S1', Aliases='AP17, CLAPS2, FBH3, FBHOk, HHC3', description='adaptor related protein complex 2 sigma 1 subunit', other_designations='HA2 17 kDa subunit|adaptor protein complex AP-2 subunit sigma|adaptor-related protein complex 2 sigma 1 subunit|adaptor-related protein complex 2, sigma 1 subunit|clathrin assembly protein 2 sigma small chain|clathrin coat assembly protein AP17|clathrin coat-associated protein AP17|clathrin-associated/assembly/adaptor protein, small 2 (17kD)|plasma membrane adaptor AP-2 17 kDa protein|sigma2-adaptin', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=46838158, end_position_on_the_genomic_accession=46850995, orientation='minus', exon_count=7, OMIM=602242, no_hdr0=''),
  1176 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1176, CurrentID=0, Status='live', Symbol='AP3S1', Aliases='CLAPS3, Sigma3A', description='adaptor related protein complex 3 sigma 1 subunit', other_designations='adapter-related protein complex 3 subunit sigma-1|adaptor related protein complex 3, sigma 1 subunit|adaptor-related protein complex 3 subunit sigma-1|clathrin adaptor complex AP3, sigma-3A subunit|clathrin-associated/assembly/adapter protein, small 3|clathrin-associated/assembly/adaptor protein, small 3 (22kD)|sigma-adaptin 3a', map_location='5q22', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=115841922, end_position_on_the_genomic_accession=115914081, orientation='plus', exon_count=8, OMIM=601507, no_hdr0=''),
  1178 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1178, CurrentID=0, Status='live', Symbol='CLC', Aliases='GAL10, Gal-10, LGALS10, LGALS10A, LPPL_HUMAN', description='Charcot-Leyden crystal galectin', other_designations='Charcot-Leyden crystal protein|eosinophil lysophospholipase|galectin 10|lectin, galactoside-binding, soluble, 10|lysolecithin acylhydrolase', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=39731253, end_position_on_the_genomic_accession=39738029, orientation='minus', exon_count=4, OMIM=153310, no_hdr0=''),
  1179 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1179, CurrentID=0, Status='live', Symbol='CLCA1', Aliases='CACC, CACC1, CLCRG1, CaCC-1, GOB5, hCLCA1, hCaCC-1', description='chloride channel accessory 1', other_designations='CLCA family member 1, chloride channel regulator|calcium-activated chloride channel family member 1|calcium-activated chloride channel protein 1|calcium-dependent chloride channel-1|chloride channel regulator 1|chloride channel, calcium activated, family member 1', map_location='1p22.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=86468843, end_position_on_the_genomic_accession=86500294, orientation='plus', exon_count=14, OMIM=603906, no_hdr0=''),
  1180 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1180, CurrentID=0, Status='live', Symbol='CLCN1', Aliases='CLC1', description='chloride voltage-gated channel 1', other_designations='chloride channel 1, skeletal muscle|chloride channel protein, skeletal muscle|chloride channel, voltage-sensitive 1|clC-1', map_location='7q35', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=143316126, end_position_on_the_genomic_accession=143353862, orientation='plus', exon_count=24, OMIM=118425, no_hdr0=''),
  1181 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1181, CurrentID=0, Status='live', Symbol='CLCN2', Aliases='CIC-2, CLC2, ECA2, ECA3, EGI11, EGI3, EGMA, EJM6, EJM8, LKPAT, clC-2', description='chloride voltage-gated channel 2', other_designations='chloride channel 2|chloride channel, voltage-sensitive 2', map_location='3q27.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184346185, end_position_on_the_genomic_accession=184361651, orientation='minus', exon_count=25, OMIM=600570, no_hdr0=''),
  1182 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1182, CurrentID=0, Status='live', Symbol='CLCN3', Aliases='CLC3, ClC-3', description='chloride voltage-gated channel 3', other_designations='chloride channel 3|chloride channel protein 3|chloride channel, voltage-sensitive 3|chloride transporter ClC-3', map_location='4q33', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=169620521, end_position_on_the_genomic_accession=169723187, orientation='plus', exon_count=16, OMIM=600580, no_hdr0=''),
  1183 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1183, CurrentID=0, Status='live', Symbol='CLCN4', Aliases='CLC4, ClC-4, ClC-4A', description='chloride voltage-gated channel 4', other_designations='chloride channel 4|chloride channel protein 4|chloride channel, voltage-sensitive 4|chloride transporter ClC-4', map_location='Xp22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=10156945, end_position_on_the_genomic_accession=10237660, orientation='plus', exon_count=13, OMIM=302910, no_hdr0=''),
  1184 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1184, CurrentID=0, Status='live', Symbol='CLCN5', Aliases='CLC5, CLCK2, ClC-5, DENTS, NPHL1, NPHL2, XLRH, XRN, hCIC-K2', description='chloride voltage-gated channel 5', other_designations='chloride channel, voltage-sensitive 5|chloride transporter ClC-5|voltage-gated chloride ion channel CLCN5', map_location='Xp11.23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=49922615, end_position_on_the_genomic_accession=50099235, orientation='plus', exon_count=18, OMIM=300008, no_hdr0=''),
  1185 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1185, CurrentID=0, Status='live', Symbol='CLCN6', Aliases='CLC-6', description='chloride voltage-gated channel 6', other_designations='chloride channel, voltage-sensitive 6', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=11806096, end_position_on_the_genomic_accession=11843144, orientation='plus', exon_count=23, OMIM=602726, no_hdr0=''),
  1186 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1186, CurrentID=0, Status='live', Symbol='CLCN7', Aliases='CLC-7, CLC7, OPTA2, OPTB4, PPP1R63', description='chloride voltage-gated channel 7', other_designations='chloride channel 7 alpha subunit|chloride channel protein 7|chloride channel, voltage-sensitive 7|protein phosphatase 1, regulatory subunit 63', map_location='16p13', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=1444933, end_position_on_the_genomic_accession=1475084, orientation='minus', exon_count=26, OMIM=602727, no_hdr0=''),
  1187 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1187, CurrentID=0, Status='live', Symbol='CLCNKA', Aliases='CLCK1, ClC-K1, hClC-Ka', description='chloride voltage-gated channel Ka', other_designations='chloride channel Ka|chloride channel, kidney, A|chloride channel, voltage-sensitive Ka', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=16021991, end_position_on_the_genomic_accession=16034050, orientation='plus', exon_count=20, OMIM=602024, no_hdr0=''),
  1188 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1188, CurrentID=0, Status='live', Symbol='CLCNKB', Aliases='CLCKB, ClC-K2, ClC-Kb', description='chloride voltage-gated channel Kb', other_designations='chloride channel, kidney, B|chloride channel, voltage-sensitive Kb', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=16043736, end_position_on_the_genomic_accession=16057326, orientation='plus', exon_count=23, OMIM=602023, no_hdr0=''),
  1191 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1191, CurrentID=0, Status='live', Symbol='CLU', Aliases='AAG4, APO-J, APOJ, CLI1, CLU2, KUB1, NA1/NA2, SGP-2, SGP2, SP-40, TRPM-2, TRPM2, CLU', description='clusterin', other_designations='aging-associated protein 4|apolipoprotein J|complement cytolysis inhibitor|complement lysis inhibitor|complement-associated protein SP-40,40|ku70-binding protein 1|sulfated glycoprotein 2|testosterone-repressed prostate message 2', map_location='8p21-p12', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=27596917, end_position_on_the_genomic_accession=27615031, orientation='minus', exon_count=11, OMIM=185430, no_hdr0=''),
  1192 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1192, CurrentID=0, Status='live', Symbol='CLIC1', Aliases='G6, NCC27', description='chloride intracellular channel 1', other_designations='RNCC protein|chloride channel ABP|hRNCC|nuclear chloride ion channel 27|nuclear chloride ion channel protein|p64CLCP|regulatory nuclear chloride ion channel protein', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31730581, end_position_on_the_genomic_accession=31737318, orientation='minus', exon_count=7, OMIM=602872, no_hdr0=''),
  1193 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1193, CurrentID=0, Status='live', Symbol='CLIC2', Aliases='CLIC2b, MRXS32, XAP121', description='chloride intracellular channel 2', other_designations='', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=155276207, end_position_on_the_genomic_accession=155334681, orientation='minus', exon_count=6, OMIM=300138, no_hdr0=''),
  1195 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1195, CurrentID=0, Status='live', Symbol='CLK1', Aliases='CLK, CLK/STY, STY', description='CDC like kinase 1', other_designations='CDC-like kinase 1|CDC28/CDC2-like kinase|protein tyrosine kinase STY', map_location='2q33', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=200853009, end_position_on_the_genomic_accession=200864744, orientation='minus', exon_count=14, OMIM=601951, no_hdr0=''),
  1196 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1196, CurrentID=0, Status='live', Symbol='CLK2', Aliases='', description='CDC like kinase 2', other_designations='CDC-like kinase 2|CLK kinase', map_location='1q21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=155262868, end_position_on_the_genomic_accession=155273529, orientation='minus', exon_count=14, OMIM=602989, no_hdr0=''),
  1198 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1198, CurrentID=0, Status='live', Symbol='CLK3', Aliases='PHCLK3, PHCLK3/152', description='CDC like kinase 3', other_designations='CDC-like kinase 3', map_location='15q24', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74598476, end_position_on_the_genomic_accession=74645418, orientation='plus', exon_count=21, OMIM=602990, no_hdr0=''),
  5661 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=5661, CurrentID=0, Status='live', Symbol='PSBP1', Aliases='', description='prostatic steroid binding protein 1', other_designations='prostatic steroid-binding protein 1', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  1200 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1200, CurrentID=0, Status='live', Symbol='TPP1', Aliases='CLN2, GIG1, LPIC, SCAR7, TPP-1', description='tripeptidyl peptidase I', other_designations='cell growth-inhibiting gene 1 protein|growth-inhibiting protein 1|lysosomal pepstatin insensitive protease|tripeptidyl aminopeptidase', map_location='11p15', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=6612766, end_position_on_the_genomic_accession=6619461, orientation='minus', exon_count=13, OMIM=607998, no_hdr0=''),
  1201 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1201, CurrentID=0, Status='live', Symbol='CLN3', Aliases='BTS, JNCL', description='ceroid-lipofuscinosis, neuronal 3', other_designations='batten disease protein', map_location='16p12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=28466653, end_position_on_the_genomic_accession=28492302, orientation='minus', exon_count=16, OMIM=607042, no_hdr0=''),
  1203 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1203, CurrentID=0, Status='live', Symbol='CLN5', Aliases='NCL', description='ceroid-lipofuscinosis, neuronal 5', other_designations='', map_location='13q21.1-q32', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=76991924, end_position_on_the_genomic_accession=77002517, orientation='plus', exon_count=5, OMIM=608102, no_hdr0=''),
  80745 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=80745, CurrentID=0, Status='live', Symbol='THUMPD2', Aliases='C2orf8', description='THUMP domain containing 2', other_designations='SAM-dependent methyltransferase', map_location='2p22-p21', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=39736060, end_position_on_the_genomic_accession=39779276, orientation='minus', exon_count=13, OMIM=611751, no_hdr0=''),
  1207 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1207, CurrentID=0, Status='live', Symbol='CLNS1A', Aliases='CLCI, CLNS1B, ICln', description='chloride nucleotide-sensitive channel 1A', other_designations='chloride channel regulatory protein|chloride channel, nucleotide sensitive 1A|chloride channel, nucleotide-sensitive, 1A|chloride conductance regulatory protein ICln|chloride ion current inducer protein|i(Cln)|reticulocyte pICln|reticulocyte protein ICln', map_location='11q14.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=77616151, end_position_on_the_genomic_accession=77637806, orientation='minus', exon_count=7, OMIM=602158, no_hdr0=''),
  1208 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1208, CurrentID=0, Status='live', Symbol='CLPS', Aliases='', description='colipase', other_designations='colipase, pancreatic|pancreatic colipase preproprotein', map_location='6p21.31', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=35794982, end_position_on_the_genomic_accession=35797344, orientation='minus', exon_count=4, OMIM=120105, no_hdr0=''),
  1209 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1209, CurrentID=0, Status='live', Symbol='CLPTM1', Aliases='', description='cleft lip and palate associated transmembrane protein 1', other_designations='', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44954585, end_position_on_the_genomic_accession=44993346, orientation='plus', exon_count=16, OMIM=604783, no_hdr0=''),
  1211 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1211, CurrentID=0, Status='live', Symbol='CLTA', Aliases='LCA', description='clathrin light chain A', other_designations='clathrin, light chain A|clathrin, light polypeptide (Lca)', map_location='9p13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=36190856, end_position_on_the_genomic_accession=36212062, orientation='plus', exon_count=7, OMIM=118960, no_hdr0=''),
  1212 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1212, CurrentID=0, Status='live', Symbol='CLTB', Aliases='LCB', description='clathrin light chain B', other_designations='clathrin, light chain (Lcb)|clathrin, light chain B|clathrin, light polypeptide (Lcb)', map_location='5q35', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=176392455, end_position_on_the_genomic_accession=176416569, orientation='minus', exon_count=8, OMIM=118970, no_hdr0=''),
  1213 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1213, CurrentID=0, Status='live', Symbol='CLTC', Aliases='CHC, CHC17, CLH-17L2, Hc, CLTC', description='clathrin heavy chain', other_designations='clathrin heavy chain on chromosome 17|clathrin, heavy chain (Hc)|clathrin, heavy polypeptide (Hc)|clathrin, heavy polypeptide-like 2', map_location='17q23.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=59619689, end_position_on_the_genomic_accession=59696956, orientation='plus', exon_count=36, OMIM=118955, no_hdr0=''),
  1215 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1215, CurrentID=0, Status='live', Symbol='CMA1', Aliases='CYH, MCT1, chymase', description='chymase 1, mast cell', other_designations='alpha-chymase|chymase 1 preproprotein transcript E|chymase 1 preproprotein transcript I|chymase, heart|chymase, mast cell|mast cell protease I', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=24505346, end_position_on_the_genomic_accession=24508690, orientation='minus', exon_count=5, OMIM=118938, no_hdr0=''),
  105371936 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105371936, CurrentID=0, Status='live', Symbol='LOC105371936', Aliases='', description='uncharacterized LOC105371936', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=62344040, end_position_on_the_genomic_accession=62353998, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  100130865 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100130865, CurrentID=0, Status='live', Symbol='LOC100130865', Aliases='', description='uncharacterized LOC100130865', other_designations='', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.10', start_position_on_the_genomic_accession=2235350, end_position_on_the_genomic_accession=2235778, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  100113407 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100113407, CurrentID=0, Status='live', Symbol='TMEM170B', Aliases='', description='transmembrane protein 170B', other_designations='', map_location='6p24.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=11538196, end_position_on_the_genomic_accession=11583524, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  132299 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132299, CurrentID=0, Status='live', Symbol='OCIAD2', Aliases='', description='OCIA domain containing 2', other_designations='ovarian carcinoma immunoreactive antigen-like protein', map_location='4p11', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=48885380, end_position_on_the_genomic_accession=48906828, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  120065 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=120065, CurrentID=0, Status='live', Symbol='OR5P2', Aliases='JCG3, JCG4', description='olfactory receptor family 5 subfamily P member 2', other_designations='olfactory receptor OR11-93|olfactory receptor, family 5, subfamily P, member 2|olfactory receptor-like protein JCG3', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=7795974, end_position_on_the_genomic_accession=7796942, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  1230 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1230, CurrentID=0, Status='live', Symbol='CCR1', Aliases='CD191, CKR-1, CKR1, CMKBR1, HM145, MIP1aR, SCYAR1', description='chemokine (C-C motif) receptor 1', other_designations='C-C CKR-1|CC-CKR-1|CCR-1|LD78 receptor|MIP-1alpha-R|RANTES receptor|RANTES-R|macrophage inflammatory protein 1-alpha receptor', map_location='3p21', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=46201709, end_position_on_the_genomic_accession=46208341, orientation='minus', exon_count=2, OMIM=601159, no_hdr0=''),
  164045 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=164045, CurrentID=0, Status='live', Symbol='HFM1', Aliases='MER3, POF9, SEC63D1, Si-11, Si-11-6, helicase', description='HFM1, ATP-dependent DNA helicase homolog', other_designations='SEC63 domain-containing protein 1|helicase-like protein HFM1', map_location='1p22.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=91260766, end_position_on_the_genomic_accession=91408007, orientation='minus', exon_count=43, OMIM=615684, no_hdr0=''),
  1232 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1232, CurrentID=0, Status='live', Symbol='CCR3', Aliases='CC-CKR-3, CD193, CKR3, CMKBR3', description='chemokine (C-C motif) receptor 3', other_designations='C-C CKR-3|CC chemokine receptor 3|CCR-3|b-chemokine receptor|eosinophil CC chemokine receptor 3|eosinophil eotaxin receptor', map_location='3p21.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=46210695, end_position_on_the_genomic_accession=46266706, orientation='plus', exon_count=5, OMIM=601268, no_hdr0=''),
  1233 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1233, CurrentID=0, Status='live', Symbol='CCR4', Aliases='CC-CKR-4, CD194, CKR4, CMKBR4, ChemR13, HGCN:14099, K5-5', description='chemokine (C-C motif) receptor 4', other_designations='C-C CKR-4|CCR-4|chemokine (C-C) receptor 4', map_location='3p24', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=32951574, end_position_on_the_genomic_accession=32954911, orientation='plus', exon_count=2, OMIM=604836, no_hdr0=''),
  1234 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1234, CurrentID=0, Status='live', Symbol='CCR5', Aliases='CC-CKR-5, CCCKR5, CCR-5, CD195, CKR-5, CKR5, CMKBR5, IDDM22', description='chemokine (C-C motif) receptor 5 (gene/pseudogene)', other_designations='C-C motif chemokine receptor 5 A159A|HIV-1 fusion coreceptor|chemokine receptor CCR5|chemr13', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=46370142, end_position_on_the_genomic_accession=46376206, orientation='plus', exon_count=3, OMIM=601373, no_hdr0=''),
  1235 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1235, CurrentID=0, Status='live', Symbol='CCR6', Aliases='BN-1, C-C CKR-6, CC-CKR-6, CCR-6, CD196, CKR-L3, CKRL3, CMKBR6, DCR2, DRY6, GPR29, GPRCY4, STRL22', description='chemokine (C-C motif) receptor 6', other_designations='G protein-coupled receptor 29|G-protein coupled receptor 29|LARC receptor|chemokine (C-C) receptor 6|chemokine receptor-like 3|seven-transmembrane receptor, lymphocyte, 22', map_location='6q27', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=167111807, end_position_on_the_genomic_accession=167139141, orientation='plus', exon_count=4, OMIM=601835, no_hdr0=''),
  1236 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1236, CurrentID=0, Status='live', Symbol='CCR7', Aliases='BLR2, CC-CKR-7, CCR-7, CD197, CDw197, CMKBR7, EBI1', description='chemokine (C-C motif) receptor 7', other_designations="Bukitt's lymphoma receptor 2|CC chemokine receptor 7|EBV-induced G protein-coupled receptor 1|Epstein-Barr virus induced gene 1|Epstein-Barr virus-induced G-protein coupled receptor 1|MIP-3 beta receptor|lymphocyte-specific G protein-coupled peptide receptor", map_location='17q12-q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=40553769, end_position_on_the_genomic_accession=40565484, orientation='minus', exon_count=5, OMIM=600242, no_hdr0=''),
  1237 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1237, CurrentID=0, Status='live', Symbol='CCR8', Aliases='CC-CKR-8, CCR-8, CDw198, CKRL1, CMKBR8, CMKBRL2, CY6, GPRCY6, TER1', description='chemokine (C-C motif) receptor 8', other_designations='CC chemokine receptor 8|CC chemokine receptor CHEMR1|CC-chemokine receptor chemr1|chemokine (C-C) receptor 8|chemokine (C-C) receptor-like 2|chemokine receptor-like 1', map_location='3p22', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=39329706, end_position_on_the_genomic_accession=39333680, orientation='plus', exon_count=2, OMIM=601834, no_hdr0=''),
  1238 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1238, CurrentID=0, Status='live', Symbol='ACKR2', Aliases='CCBP2, CCR10, CCR9, CMKBR9, D6, hD6', description='atypical chemokine receptor 2', other_designations='C-C chemokine receptor D6|CC-chemokine-binding receptor JAB61|chemokine (C-C motif) receptor 9|chemokine (C-C) receptor 9|chemokine binding protein 2|chemokine receptor CCR-10|chemokine receptor CCR-9|chemokine receptor D6|chemokine-binding protein 2|chemokine-binding protein D6', map_location='3p21.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=42809472, end_position_on_the_genomic_accession=42867283, orientation='plus', exon_count=3, OMIM=602648, no_hdr0=''),
  338809 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=338809, CurrentID=0, Status='live', Symbol='C12orf74', Aliases='', description='chromosome 12 open reading frame 74', other_designations='', map_location='12q22', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=92702843, end_position_on_the_genomic_accession=92708549, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  1240 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1240, CurrentID=0, Status='live', Symbol='CMKLR1', Aliases='CHEMERINR, ChemR23, DEZ, RVER1', description='chemerin chemokine-like receptor 1', other_designations='G-protein coupled receptor ChemR23|G-protein coupled receptor DEZ|chemerin receptor|chemokine receptor-like 1|orphan G-protein coupled receptor, Dez|resolvin E1 receptor', map_location='12q24.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=108288044, end_position_on_the_genomic_accession=108339317, orientation='minus', exon_count=5, OMIM=602351, no_hdr0=''),
  1241 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1241, CurrentID=0, Status='live', Symbol='LTB4R', Aliases='BLT1, BLTR, CMKRL1, GPR161, LTBR1, P2RY7, P2Y7, LTB4R', description='leukotriene B4 receptor', other_designations='G protein-coupled receptor 16|G-protein coupled receptor 16|LTB4-R 1|LTB4-R1|P2Y purinoceptor 7|chemoattractant receptor-like 1|chemokine receptor-like 1|purinergic receptor P2Y, G-protein coupled, 7', map_location='14q11.2-q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=24311499, end_position_on_the_genomic_accession=24318036, orientation='plus', exon_count=3, OMIM=601531, no_hdr0=''),
  165082 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=165082, CurrentID=0, Status='live', Symbol='ADGRF3', Aliases='GPR113, PGR23, hGPCR37', description='adhesion G protein-coupled receptor F3', other_designations='G protein-coupled receptor 113|G protein-coupled receptor PGR23|G-protein coupled receptor 113|G-protein coupled receptor PGR23|probable G-protein coupled receptor 113|seven transmembrane helix receptor', map_location='2p23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=26308173, end_position_on_the_genomic_accession=26346817, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  100533467 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100533467, CurrentID=0, Status='live', Symbol='BIVM-ERCC5', Aliases='ERCC5-202', description='BIVM-ERCC5 readthrough', other_designations='', map_location='13q', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=102807146, end_position_on_the_genomic_accession=102876001, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  1244 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1244, CurrentID=0, Status='live', Symbol='ABCC2', Aliases='ABC30, CMOAT, DJS, MRP2, cMRP', description='ATP binding cassette subfamily C member 2', other_designations='ATP-binding cassette, sub-family C (CFTR/MRP), member 2|canalicular multidrug resistance protein|multidrug resistance-associated protein 2', map_location='10q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=99782598, end_position_on_the_genomic_accession=99852576, orientation='plus', exon_count=34, OMIM=601107, no_hdr0=''),
  22955 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=22955, CurrentID=0, Status='live', Symbol='SCMH1', Aliases='Scml3', description='sex comb on midleg homolog 1 (Drosophila)', other_designations='', map_location='1p34', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=41027199, end_position_on_the_genomic_accession=41242159, orientation='minus', exon_count=24, OMIM=616396, no_hdr0=''),
  497189 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=497189, CurrentID=0, Status='live', Symbol='TIFAB', Aliases='', description='TIFA inhibitor', other_designations='TIFA-like protein|TIFA-related protein TIFAB|TRAF-interacting protein with forkhead-associated domain, family member B', map_location='5q31.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=135448868, end_position_on_the_genomic_accession=135452399, orientation='minus', exon_count=2, OMIM=612663, no_hdr0=''),
  132320 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132320, CurrentID=0, Status='live', Symbol='SCLT1', Aliases='CAP-1A, CAP1A', description='sodium channel and clathrin linker 1', other_designations='sodium channel-associated protein 1', map_location='4q28.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=128874418, end_position_on_the_genomic_accession=129093607, orientation='minus', exon_count=27, OMIM=611399, no_hdr0=''),
  132321 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132321, CurrentID=0, Status='live', Symbol='C4orf33', Aliases='', description='chromosome 4 open reading frame 33', other_designations='', map_location='4q28.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=129093674, end_position_on_the_genomic_accession=129112688, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  338811 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=338811, CurrentID=0, Status='live', Symbol='FAM19A2', Aliases='TAFA-2, TAFA2', description='family with sequence similarity 19 (chemokine (C-C motif)-like), member A2', other_designations='chemokine-like protein TAFA-2', map_location='12q14.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=61708248, end_position_on_the_genomic_accession=62260064, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  497190 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=497190, CurrentID=0, Status='live', Symbol='CLEC18B', Aliases='MRCL2', description='C-type lectin domain family 18 member B', other_designations='C-type lectin domain family 18, member B|mannose receptor-like 2|mannose receptor-like protein 1|secretory protein LOC497190', map_location='16q22.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=74408631, end_position_on_the_genomic_accession=74422248, orientation='minus', exon_count=15, OMIM=616572, no_hdr0=''),
  100129775 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100129775, CurrentID=0, Status='live', Symbol='LOC100129775', Aliases='', description='uncharacterized LOC100129775', other_designations='', map_location='11q13.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.8', start_position_on_the_genomic_accession=74990231, end_position_on_the_genomic_accession=74990629, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  1258 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1258, CurrentID=0, Status='live', Symbol='CNGB1', Aliases='CNCG2, CNCG3L, CNCG4, CNG4B, GAR1, GARP, GARP2, RCNC2, RCNCb, RCNCbeta, RP45, CNGB1', description='cyclic nucleotide gated channel beta 1', other_designations='CNG channel beta-1|CNG-4|cyclic nucleotide-gated cation channel 4|cyclic nucleotide-gated cation channel gamma|cyclic nucleotide-gated cation channel modulatory subunit|cyclic nucleotide-gated channel beta-1|glutamic acid-rich protein|glutamic-acid-rich protein', map_location='16q13', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=57882340, end_position_on_the_genomic_accession=57979295, orientation='minus', exon_count=37, OMIM=600724, no_hdr0=''),
  1259 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1259, CurrentID=0, Status='live', Symbol='CNGA1', Aliases='CNCG, CNCG1, CNG-1, CNG1, RCNC1, RCNCa, RCNCalpha, RP49', description='cyclic nucleotide gated channel alpha 1', other_designations='CNG channel alpha-1|cyclic nucleotide-gated cation channel 1|cyclic nucleotide-gated channel alpha-1|cyclic nucleotide-gated channel, photoreceptor|interleukin-1 homologue|rod photoreceptor cGMP-gated channel subunit alpha', map_location='4p12', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=47935015, end_position_on_the_genomic_accession=48016679, orientation='minus', exon_count=13, OMIM=123825, no_hdr0=''),
  1260 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1260, CurrentID=0, Status='live', Symbol='CNGA2', Aliases='CNCA, CNCA1, CNG2, OCNC1, OCNCALPHA, OCNCa', description='cyclic nucleotide gated channel alpha 2', other_designations='CNG channel alpha-2|cyclic-nucleotide-gated cation channel 2', map_location='Xq27', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=151734746, end_position_on_the_genomic_accession=151745564, orientation='plus', exon_count=7, OMIM=300338, no_hdr0=''),
  1261 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1261, CurrentID=0, Status='live', Symbol='CNGA3', Aliases='ACHM2, CCNC1, CCNCa, CCNCalpha, CNCG3, CNG3', description='cyclic nucleotide gated channel alpha 3', other_designations='CNG channel alpha-3|CNG-3|cone photoreceptor cGMP-gated channel alpha subunit|cone photoreceptor cGMP-gated channel subunit alpha|cyclic nucleotide-gated channel alpha-3', map_location='2q11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=98346155, end_position_on_the_genomic_accession=98399154, orientation='plus', exon_count=9, OMIM=600053, no_hdr0=''),
  1262 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1262, CurrentID=0, Status='live', Symbol='CNGA4', Aliases='CNCA2, CNG-4, CNG4, CNG5, CNGB2, OCNC2, OCNCBETA, OCNCb', description='cyclic nucleotide gated channel alpha 4', other_designations='CNG channel alpha-4|cyclic nucleotide gated channel beta 2', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=6234774, end_position_on_the_genomic_accession=6245924, orientation='plus', exon_count=7, OMIM=609472, no_hdr0=''),
  1263 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1263, CurrentID=0, Status='live', Symbol='PLK3', Aliases='CNK, FNK, PLK-3, PRK', description='polo like kinase 3', other_designations='FGF-inducible kinase|cytokine-inducible serine/threonine-protein kinase|polo-like kinase 3|proliferation-related kinase', map_location='1p34.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=44799952, end_position_on_the_genomic_accession=44805995, orientation='plus', exon_count=15, OMIM=602913, no_hdr0=''),
  1264 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1264, CurrentID=0, Status='live', Symbol='CNN1', Aliases='HEL-S-14, SMCC, Sm-Calp', description='calponin 1', other_designations='basic calponin|calponin 1, basic, smooth muscle|calponin H1, smooth muscle|calponins, basic|epididymis secretory protein Li 14', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=11538764, end_position_on_the_genomic_accession=11550323, orientation='plus', exon_count=11, OMIM=600806, no_hdr0=''),
  1265 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1265, CurrentID=0, Status='live', Symbol='CNN2', Aliases='', description='calponin 2', other_designations='calponin H2, smooth muscle|neutral calponin', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1026275, end_position_on_the_genomic_accession=1039068, orientation='plus', exon_count=7, OMIM=602373, no_hdr0=''),
  1266 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1266, CurrentID=0, Status='live', Symbol='CNN3', Aliases='', description='calponin 3', other_designations='calponin 3, acidic|calponin, acidic isoform|dJ639P13.2.2 (acidic calponin 3)', map_location='1p22-p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=94896949, end_position_on_the_genomic_accession=94927223, orientation='minus', exon_count=8, OMIM=602374, no_hdr0=''),
  1267 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1267, CurrentID=0, Status='live', Symbol='CNP', Aliases='CNP1', description="2',3'-cyclic nucleotide 3' phosphodiesterase", other_designations="2', 3' cyclic nucleotide 3' phosphohydrolase|CNPase", map_location='17q21', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=41966741, end_position_on_the_genomic_accession=41977736, orientation='plus', exon_count=5, OMIM=123830, no_hdr0=''),
  1268 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1268, CurrentID=0, Status='live', Symbol='CNR1', Aliases='CANN6, CB-R, CB1, CB1A, CB1K5, CB1R, CNR', description='cannabinoid receptor 1 (brain)', other_designations='central cannabinoid receptor', map_location='6q14-q15', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=88139864, end_position_on_the_genomic_accession=88166745, orientation='minus', exon_count=6, OMIM=114610, no_hdr0=''),
  1269 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1269, CurrentID=0, Status='live', Symbol='CNR2', Aliases='CB-2, CB2, CX5', description='cannabinoid receptor 2', other_designations='cannabinoid receptor 2 (macrophage)|testis-dominant CNR2 isoform CB2', map_location='1p36.11', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=23873463, end_position_on_the_genomic_accession=23913327, orientation='minus', exon_count=5, OMIM=605051, no_hdr0=''),
  1270 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1270, CurrentID=0, Status='live', Symbol='CNTF', Aliases='HCNTF', description='ciliary neurotrophic factor', other_designations='', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=58622673, end_position_on_the_genomic_accession=58625733, orientation='plus', exon_count=2, OMIM=118945, no_hdr0=''),
  1271 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1271, CurrentID=0, Status='live', Symbol='CNTFR', Aliases='', description='ciliary neurotrophic factor receptor', other_designations='CNTF receptor subunit alpha|CNTFR-alpha', map_location='9p13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=34551432, end_position_on_the_genomic_accession=34590140, orientation='minus', exon_count=12, OMIM=118946, no_hdr0=''),
  1272 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1272, CurrentID=0, Status='live', Symbol='CNTN1', Aliases='F3, GP135, MYPCN', description='contactin 1', other_designations='glycoprotein gP135|neural cell surface protein F3', map_location='12q12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=40692442, end_position_on_the_genomic_accession=41072412, orientation='plus', exon_count=28, OMIM=600016, no_hdr0=''),
  114900 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=114900, CurrentID=0, Status='live', Symbol='C1QTNF4', Aliases='CTRP4, ZACRP4', description='C1q and tumor necrosis factor related protein 4', other_designations='complement-c1q tumor necrosis factor-related protein 4', map_location='11q11', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=47589664, end_position_on_the_genomic_accession=47594409, orientation='minus', exon_count=3, OMIM=614911, no_hdr0=''),
  84243 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=84243, CurrentID=0, Status='live', Symbol='ZDHHC18', Aliases='DHHC-18, DHHC18', description='zinc finger DHHC-type containing 18', other_designations='zinc finger DHHC domain-containing protein 18|zinc finger, DHHC domain containing 18|zinc finger, DHHC-type containing 18', map_location='1p36.11', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=26826710, end_position_on_the_genomic_accession=26855720, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  1277 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1277, CurrentID=0, Status='live', Symbol='COL1A1', Aliases='EDSC, OI1, OI2, OI3, OI4', description='collagen type I alpha 1', other_designations='alpha-1 type I collagen|alpha1(I) procollagen|collagen alpha 1 chain type I|collagen alpha-1(I) chain preproprotein|collagen of skin, tendon and bone, alpha-1 chain|collagen, type I, alpha 1|pro-alpha-1 collagen type 1|type I proalpha 1|type I procollagen alpha 1 chain', map_location='17q21.33', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=50184096, end_position_on_the_genomic_accession=50201648, orientation='minus', exon_count=51, OMIM=120150, no_hdr0=''),
  1278 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1278, CurrentID=0, Status='live', Symbol='COL1A2', Aliases='OI4', description='collagen type I alpha 2', other_designations='alpha 2 type I procollagen|alpha 2(I) procollagen|alpha 2(I)-collagen|alpha-2 type I collagen|collagen I, alpha-2 polypeptide|collagen of skin, tendon and bone, alpha-2 chain|collagen, type I, alpha 2|type I procollagen', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=94394561, end_position_on_the_genomic_accession=94431232, orientation='plus', exon_count=52, OMIM=120160, no_hdr0=''),
  1280 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1280, CurrentID=0, Status='live', Symbol='COL2A1', Aliases='ANFH, AOM, COL11A3, SEDC, STL1', description='collagen type II alpha 1', other_designations='alpha-1 type II collagen|arthroophthalmopathy, progressive (Stickler syndrome)|cartilage collagen|chondrocalcin|collagen II, alpha-1 polypeptide', map_location='12q13.11', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=47972965, end_position_on_the_genomic_accession=48025286, orientation='minus', exon_count=67, OMIM=120140, no_hdr0=''),
  1281 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1281, CurrentID=0, Status='live', Symbol='COL3A1', Aliases='EDS4A', description='collagen type III alpha 1', other_designations='Ehlers-Danlos syndrome type IV, autosomal dominant|alpha1 (III) collagen|collagen, fetal|collagen, type III, alpha 1', map_location='2q31', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=188974373, end_position_on_the_genomic_accession=189012746, orientation='plus', exon_count=51, OMIM=120180, no_hdr0=''),
  1282 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1282, CurrentID=0, Status='live', Symbol='COL4A1', Aliases='BSVD, RATOR', description='collagen type IV alpha 1', other_designations='COL4A1 NC1 domain|arresten|collagen IV, alpha-1 polypeptide|collagen of basement membrane, alpha-1 chain|collagen, type IV, alpha 1', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=110148958, end_position_on_the_genomic_accession=110307157, orientation='minus', exon_count=54, OMIM=120130, no_hdr0=''),
  105371179 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105371179, CurrentID=0, Status='live', Symbol='LOC105371179', Aliases='', description='proline-rich receptor-like protein kinase PERK2', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=32636694, end_position_on_the_genomic_accession=32650869, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  1284 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1284, CurrentID=0, Status='live', Symbol='COL4A2', Aliases='ICH, POREN2', description='collagen type IV alpha 2', other_designations='canstatin|collagen, type IV, alpha 2', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=110307284, end_position_on_the_genomic_accession=110513027, orientation='plus', exon_count=48, OMIM=120090, no_hdr0=''),
  1285 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1285, CurrentID=0, Status='live', Symbol='COL4A3', Aliases='', description='collagen type IV alpha 3', other_designations='collagen IV, alpha-3 polypeptide|collagen, type IV, alpha 3 (Goodpasture antigen)|tumstatin', map_location='2q36-q37', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=227164565, end_position_on_the_genomic_accession=227314792, orientation='plus', exon_count=53, OMIM=120070, no_hdr0=''),
  1286 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1286, CurrentID=0, Status='live', Symbol='COL4A4', Aliases='CA44', description='collagen type IV alpha 4', other_designations='Collagen IV, alpha-4 polypeptide|collagen of basement membrane, alpha-4 chain|collagen, type IV, alpha 4', map_location='2q35-q37', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=226967532, end_position_on_the_genomic_accession=227164559, orientation='minus', exon_count=58, OMIM=120131, no_hdr0=''),
  1287 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1287, CurrentID=0, Status='live', Symbol='COL4A5', Aliases='ASLN, ATS, CA54', description='collagen type IV alpha 5', other_designations='collagen IV, alpha-5 polypeptide|collagen of basement membrane, alpha-5 chain|collagen, type IV, alpha 5|dA149D17.3|dA24A23.1', map_location='Xq22', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=108439736, end_position_on_the_genomic_accession=108697545, orientation='plus', exon_count=57, OMIM=303630, no_hdr0=''),
  1288 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1288, CurrentID=0, Status='live', Symbol='COL4A6', Aliases='CXDELq22.3, DELXq22.3, DFNX6', description='collagen type IV alpha 6', other_designations='collagen IV, alpha-6 polypeptide|collagen of basement membrane, alpha-6|collagen, type IV, alpha 6|dJ889N15.4 (Collagen Alpha 6(IV))', map_location='Xq22', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=108155607, end_position_on_the_genomic_accession=108439497, orientation='minus', exon_count=49, OMIM=303631, no_hdr0=''),
  1289 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1289, CurrentID=0, Status='live', Symbol='COL5A1', Aliases='EDSC', description='collagen type V alpha 1', other_designations='collagen, type V, alpha 1', map_location='9q34.2-q34.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=134641786, end_position_on_the_genomic_accession=134844843, orientation='plus', exon_count=67, OMIM=120215, no_hdr0=''),
  1290 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1290, CurrentID=0, Status='live', Symbol='COL5A2', Aliases='EDSC', description='collagen type V alpha 2', other_designations='AB collagen|collagen, fetal membrane, A polypeptide|collagen, type V, alpha 2|type V preprocollagen alpha 2 chain', map_location='2q14-q32', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=189031915, end_position_on_the_genomic_accession=189225314, orientation='minus', exon_count=55, OMIM=120190, no_hdr0=''),
  1291 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1291, CurrentID=0, Status='live', Symbol='COL6A1', Aliases='OPLL', description='collagen type VI alpha 1', other_designations='alpha 1 (VI) chain (61 AA)|collagen VI, alpha-1 polypeptide|collagen, type VI, alpha 1', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=45981749, end_position_on_the_genomic_accession=46005049, orientation='plus', exon_count=35, OMIM=120220, no_hdr0=''),
  1292 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1292, CurrentID=0, Status='live', Symbol='COL6A2', Aliases='PP3610', description='collagen type VI alpha 2', other_designations='collagen VI, alpha-2 polypeptide|collagen, type VI, alpha 2|human mRNA for collagen VI alpha-2 C-terminal globular domain', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=46097606, end_position_on_the_genomic_accession=46132849, orientation='plus', exon_count=31, OMIM=120240, no_hdr0=''),
  1293 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1293, CurrentID=0, Status='live', Symbol='COL6A3', Aliases='DYT27', description='collagen type VI alpha 3', other_designations='collagen VI, alpha-3 polypeptide|collagen, type VI, alpha 3', map_location='2q37', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=237324012, end_position_on_the_genomic_accession=237414370, orientation='minus', exon_count=44, OMIM=120250, no_hdr0=''),
  1294 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1294, CurrentID=0, Status='live', Symbol='COL7A1', Aliases='EBD1, EBDCT, EBR1, NDNC8', description='collagen type VII alpha 1', other_designations='LC collagen|collagen VII, alpha-1 polypeptide|long-chain collagen', map_location='3p21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48564073, end_position_on_the_genomic_accession=48595302, orientation='minus', exon_count=120, OMIM=120120, no_hdr0=''),
  1295 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1295, CurrentID=0, Status='live', Symbol='COL8A1', Aliases='C3orf7', description='collagen type VIII alpha 1', other_designations='cell proliferation-inducing protein 41|collagen VIII, alpha-1 polypeptide|collagen, type VIII, alpha 1|endothelial collagen|smag-64|smooth muscle cell-expressed and macrophage conditioned medium-induced protein smag-64', map_location='3q12.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=99638596, end_position_on_the_genomic_accession=99796733, orientation='plus', exon_count=5, OMIM=120251, no_hdr0=''),
  1296 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1296, CurrentID=0, Status='live', Symbol='COL8A2', Aliases='FECD, FECD1, PPCD, PPCD2', description='collagen type VIII alpha 2', other_designations='collagen VIII, alpha-2 polypeptide|collagen, type VIII, alpha 2|endothelial collagen', map_location='1p34.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=36095236, end_position_on_the_genomic_accession=36125770, orientation='minus', exon_count=5, OMIM=120252, no_hdr0=''),
  1297 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1297, CurrentID=0, Status='live', Symbol='COL9A1', Aliases='DJ149L1.1.2, EDM6, MED, STL4', description='collagen type IX alpha 1', other_designations='alpha-1(IX) collagen chain|cartilage-specific short collagen|collagen IX, alpha-1 polypeptide|collagen, type IX, alpha 1', map_location='6q13', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=70215061, end_position_on_the_genomic_accession=70303083, orientation='minus', exon_count=41, OMIM=120210, no_hdr0=''),
  1298 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1298, CurrentID=0, Status='live', Symbol='COL9A2', Aliases='DJ39G22.4, EDM2, MED, STL5', description='collagen type IX alpha 2', other_designations='alpha 2 type IX collagen|collagen IX, alpha-2 polypeptide|collagen, type IX, alpha 2', map_location='1p33-p32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=40300487, end_position_on_the_genomic_accession=40317690, orientation='minus', exon_count=36, OMIM=120260, no_hdr0=''),
  1299 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1299, CurrentID=0, Status='live', Symbol='COL9A3', Aliases='DJ885L7.4.1, EDM3, IDD, MED', description='collagen type IX alpha 3', other_designations='collagen IX, alpha-3 polypeptide|collagen type IX proteoglycan|collagen, type IX, alpha 3', map_location='20q13.3', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=62817062, end_position_on_the_genomic_accession=62841159, orientation='plus', exon_count=35, OMIM=120270, no_hdr0=''),
  1300 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1300, CurrentID=0, Status='live', Symbol='COL10A1', Aliases='', description='collagen type X alpha 1', other_designations='Schmid metaphyseal chondrodysplasia|collagen X, alpha-1 polypeptide', map_location='6q21-q22', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=116118909, end_position_on_the_genomic_accession=116218169, orientation='minus', exon_count=6, OMIM=120110, no_hdr0=''),
  1301 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1301, CurrentID=0, Status='live', Symbol='COL11A1', Aliases='CO11A1, COLL6, STL2', description='collagen type XI alpha 1', other_designations='collagen XI, alpha-1 polypeptide|collagen, type XI, alpha 1', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=102876467, end_position_on_the_genomic_accession=103108576, orientation='minus', exon_count=71, OMIM=120280, no_hdr0=''),
  1302 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1302, CurrentID=0, Status='live', Symbol='COL11A2', Aliases='DFNA13, DFNB53, FBCG2, HKE5, PARP, STL3', description='collagen type XI alpha 2', other_designations='collagen, type XI, alpha 2|pro-a2 chain of collagen type XI', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=33162692, end_position_on_the_genomic_accession=33193152, orientation='minus', exon_count=69, OMIM=120290, no_hdr0=''),
  1303 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1303, CurrentID=0, Status='live', Symbol='COL12A1', Aliases='BA209D8.1L, DJ234P15.1, COL12A1', description='collagen type XII alpha 1', other_designations='collagen type XII proteoglycan|collagen, type XII, alpha 1', map_location='6q12-q13', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=75084326, end_position_on_the_genomic_accession=75206202, orientation='minus', exon_count=66, OMIM=120320, no_hdr0=''),
  1305 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1305, CurrentID=0, Status='live', Symbol='COL13A1', Aliases='COLXIIIA1', description='collagen type XIII alpha 1', other_designations='collagen, type XIII, alpha 1', map_location='10q22', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=69801863, end_position_on_the_genomic_accession=69959148, orientation='plus', exon_count=42, OMIM=120350, no_hdr0=''),
  1306 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1306, CurrentID=0, Status='live', Symbol='COL15A1', Aliases='', description='collagen type XV alpha 1', other_designations='collagen XV, alpha-1 polypeptide|collagen type XV proteoglycan|collagen, type XV, alpha 1|endostatin-XV|restin', map_location='9q21-q22', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=98943348, end_position_on_the_genomic_accession=99070792, orientation='plus', exon_count=43, OMIM=120325, no_hdr0=''),
  1307 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1307, CurrentID=0, Status='live', Symbol='COL16A1', Aliases='447AA, FP1572', description='collagen type XVI alpha 1', other_designations='alpha 1 type XVI collagen|collagen XVI, alpha-1 polypeptide|collagen, type XVI, alpha 1', map_location='1p35-p34', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=31652247, end_position_on_the_genomic_accession=31704167, orientation='minus', exon_count=74, OMIM=120326, no_hdr0=''),
  1308 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1308, CurrentID=0, Status='live', Symbol='COL17A1', Aliases='BA16H23.2, BP180, BPA-2, BPAG2, ERED, LAD-1', description='collagen type XVII alpha 1', other_designations='180 kDa bullous pemphigoid antigen 2|alpha 1 type XVII collagen|bA16H23.2 (collagen, type XVII, alpha 1 (BP180))|bullous pemphigoid antigen 2 (180kD)|collagen XVII, alpha-1 polypeptide|collagen, type XVII, alpha 1|type XVII collagen alpha-1', map_location='10q24.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=104031288, end_position_on_the_genomic_accession=104085880, orientation='minus', exon_count=56, OMIM=113811, no_hdr0=''),
  1310 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1310, CurrentID=0, Status='live', Symbol='COL19A1', Aliases='COL9A1L, D6S228E', description='collagen type XIX alpha 1', other_designations='a1 chain of type XIX collagen|collagen XIX, alpha-1 polypeptide|collagen alpha 1 (Y) chain|collagen alpha-1(Y) chain|collagen, type XIX, alpha 1', map_location='6q12-q13', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=69866556, end_position_on_the_genomic_accession=70212454, orientation='plus', exon_count=53, OMIM=120165, no_hdr0=''),
  1311 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1311, CurrentID=0, Status='live', Symbol='COMP', Aliases='EDM1, EPD1, MED, PSACH, THBS5', description='cartilage oligomeric matrix protein', other_designations='TSP5|cartilage oligomeric matrix protein (pseudoachondroplasia, epiphyseal dysplasia 1, multiple)|cartilage oligomeric matrix protein(pseudoachondroplasia, epiphyseal dysplasia 1, multiple)|pseudoachondroplasia (epiphyseal dysplasia 1, multiple)|thrombospondin-5', map_location='19p13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=18782773, end_position_on_the_genomic_accession=18791305, orientation='minus', exon_count=19, OMIM=600310, no_hdr0=''),
  1312 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1312, CurrentID=0, Status='live', Symbol='COMT', Aliases='HEL-S-98n', description='catechol-O-methyltransferase', other_designations='catechol-O-methyltransferase isoform|epididymis secretory sperm binding protein Li 98n', map_location='22q11.21', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=19941740, end_position_on_the_genomic_accession=19969975, orientation='plus', exon_count=11, OMIM=116790, no_hdr0=''),
  105371184 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105371184, CurrentID=0, Status='live', Symbol='LOC105371184', Aliases='', description='collagen alpha-1(I) chain-like', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=678507, end_position_on_the_genomic_accession=680527, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  1314 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1314, CurrentID=0, Status='live', Symbol='COPA', Aliases='AILJK, HEP-COP', description='coatomer protein complex subunit alpha', other_designations='HEPCOP|alpha coat protein|alpha-COP|alpha-coat protein|coatomer protein complex, subunit alpha|proxenin|xenin', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160288587, end_position_on_the_genomic_accession=160343564, orientation='minus', exon_count=33, OMIM=601924, no_hdr0=''),
  1315 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1315, CurrentID=0, Status='live', Symbol='COPB1', Aliases='COPB', description='coatomer protein complex subunit beta 1', other_designations='beta coat protein|beta-coat protein|beta-cop|coatomer protein complex, subunit beta 1', map_location='11p15.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=14457503, end_position_on_the_genomic_accession=14499895, orientation='minus', exon_count=22, OMIM=600959, no_hdr0=''),
  1316 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1316, CurrentID=0, Status='live', Symbol='KLF6', Aliases='BCD1, CBA1, COPEB, CPBP, GBF, PAC1, ST12, ZF9', description='Kruppel-like factor 6', other_designations='B-cell-derived protein 1|GC-rich binding factor|GC-rich sites-binding factor GBF|Kruppel-like zinc finger protein Zf9|core promoter element binding protein|core promoter element-binding protein|proto-oncogene BCD1|protooncogene B-cell derived 1|suppression of tumorigenicity 12 (prostate)|suppressor of tumorigenicity 12 protein|transcription factor Zf9', map_location='10p15', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=3775996, end_position_on_the_genomic_accession=3785281, orientation='minus', exon_count=4, OMIM=602053, no_hdr0=''),
  1317 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1317, CurrentID=0, Status='live', Symbol='SLC31A1', Aliases='COPT1, CTR1', description='solute carrier family 31 member 1', other_designations='copper transport 1 homolog|copper transporter 1|solute carrier family 31 (copper transporter), member 1|solute carrier family 31 (copper transporters), member 1', map_location='9q32', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=113221528, end_position_on_the_genomic_accession=113264492, orientation='plus', exon_count=5, OMIM=603085, no_hdr0=''),
  1318 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1318, CurrentID=0, Status='live', Symbol='SLC31A2', Aliases='COPT2, CTR2, hCTR2', description='solute carrier family 31 member 2', other_designations='copper transporter 2|solute carrier family 31 (copper transporter), member 2|solute carrier family 31 (copper transporters), member 2', map_location='9q32', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=113150958, end_position_on_the_genomic_accession=113164142, orientation='plus', exon_count=6, OMIM=603088, no_hdr0=''),
  105371566 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105371566, CurrentID=0, Status='live', Symbol='LOC105371566', Aliases='', description='uncharacterized LOC105371566', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=18102005, end_position_on_the_genomic_accession=18117789, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  5682 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=5682, CurrentID=0, Status='live', Symbol='PSMA1', Aliases='HC2, HEL-S-275, NU, PROS30', description='proteasome subunit alpha 1', other_designations='30 kDa prosomal protein|PROS-30|epididymis secretory protein Li 275|macropain subunit C2|macropain subunit nu|multicatalytic endopeptidase complex subunit C2|proteasome (prosome, macropain) subunit, alpha type, 1|proteasome component C2|proteasome nu chain|proteasome subunit nu|proteasome subunit, alpha-type, 1|protein P30-33K', map_location='11p15.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=14504876, end_position_on_the_genomic_accession=14643634, orientation='minus', exon_count=12, OMIM=602854, no_hdr0=''),
  1326 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1326, CurrentID=0, Status='live', Symbol='MAP3K8', Aliases='AURA2, COT, EST, ESTF, MEKK8, TPL2, Tpl-2, c-COT', description='mitogen-activated protein kinase kinase kinase 8', other_designations='Ewing sarcoma transformant|augmented in rheumatoid arthritis 2|cot (cancer Osaka thyroid) oncogene|proto-oncogene c-Cot|proto-oncogene serine/threoine protein kinase|tumor progression locus 2', map_location='10p11.23', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=30434003, end_position_on_the_genomic_accession=30461833, orientation='plus', exon_count=13, OMIM=191195, no_hdr0=''),
  1327 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1327, CurrentID=0, Status='live', Symbol='COX4I1', Aliases='COX IV-1, COX4, COX4-1, COXIV, COXIV-1', description='cytochrome c oxidase subunit 4I1', other_designations='cytochrome c oxidase polypeptide IV|cytochrome c oxidase subunit IV', map_location='16q24.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=85799567, end_position_on_the_genomic_accession=85807002, orientation='plus', exon_count=6, OMIM=123864, no_hdr0=''),
  1329 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1329, CurrentID=0, Status='live', Symbol='COX5B', Aliases='COXVB', description='cytochrome c oxidase subunit 5B', other_designations='cytochrome c oxidase polypeptide VB, mitochondrial|cytochrome c oxidase subunit Vb', map_location='2q11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=97646058, end_position_on_the_genomic_accession=97648194, orientation='plus', exon_count=4, OMIM=123866, no_hdr0=''),
  163059 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=163059, CurrentID=0, Status='live', Symbol='ZNF433', Aliases='', description='zinc finger protein 433', other_designations='', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12014717, end_position_on_the_genomic_accession=12035710, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  1337 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1337, CurrentID=0, Status='live', Symbol='COX6A1', Aliases='CMTRID, COX6A, COX6AL', description='cytochrome c oxidase subunit 6A1', other_designations='COX VIa-L|cytochrome C oxidase subunit VIa homolog|cytochrome c oxidase polypeptide VIa-liver|cytochrome c oxidase subunit VIA-liver|cytochrome c oxidase subunit VIa polypeptide 1', map_location='12q24.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=120438090, end_position_on_the_genomic_accession=120440742, orientation='plus', exon_count=3, OMIM=602072, no_hdr0=''),
  55692 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=55692, CurrentID=0, Status='live', Symbol='LUC7L', Aliases='LUC7B1, Luc7, SR+89, hLuc7B1', description='LUC7-like', other_designations='putative SR protein LUC7B1|sarcoplasmic reticulum protein LUC7B1', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=188971, end_position_on_the_genomic_accession=229450, orientation='minus', exon_count=12, OMIM=607782, no_hdr0=''),
  1339 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1339, CurrentID=0, Status='live', Symbol='COX6A2', Aliases='COX6AH, COXVIAH', description='cytochrome c oxidase subunit 6A2', other_designations='COX VIa-M|cytochrome c oxidase polypeptide VIa-heart|cytochrome c oxidase subunit VIA-muscle|cytochrome c oxidase subunit VIa polypeptide 2', map_location='16p11.12', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=31427731, end_position_on_the_genomic_accession=31428428, orientation='minus', exon_count=3, OMIM=602009, no_hdr0=''),
  1340 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1340, CurrentID=0, Status='live', Symbol='COX6B1', Aliases='COX6B, COXG, COXVIb1', description='cytochrome c oxidase subunit 6B1', other_designations='COX VIb-1|cytochrome c oxidase subunit VIb polypeptide 1 (ubiquitous)', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=35648223, end_position_on_the_genomic_accession=35658784, orientation='plus', exon_count=4, OMIM=124089, no_hdr0=''),
  100533496 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100533496, CurrentID=0, Status='live', Symbol='TVP23C-CDRT4', Aliases='FAM18B2-CDRT4', description='TVP23C-CDRT4 readthrough', other_designations='FAM18B2-CDRT4 readthrough', map_location='17p', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=15436015, end_position_on_the_genomic_accession=15563631, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  105371189 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105371189, CurrentID=0, Status='live', Symbol='LOC105371189', Aliases='', description='nuclear pore complex-interacting protein family member B9-like', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  1345 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1345, CurrentID=0, Status='live', Symbol='COX6C', Aliases='', description='cytochrome c oxidase subunit 6C', other_designations='cytochrome c oxidase polypeptide VIc|cytochrome c oxidase subunit VIc preprotein', map_location='8q22.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=99877995, end_position_on_the_genomic_accession=99894014, orientation='minus', exon_count=4, OMIM=124090, no_hdr0=''),
  1346 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1346, CurrentID=0, Status='live', Symbol='COX7A1', Aliases='COX7A, COX7AH, COX7AM', description='cytochrome c oxidase subunit 7A1', other_designations='cytochrome c oxidase subunit VIIa heart/muscle isoform|cytochrome c oxidase subunit VIIa polypeptide 1 (muscle)|cytochrome c oxidase subunit VIIa-H|cytochrome c oxidase subunit VIIa-M|cytochrome c oxidase subunit VIIa-heart|cytochrome c oxidase subunit VIIa-muscle', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=36150922, end_position_on_the_genomic_accession=36152869, orientation='minus', exon_count=4, OMIM=123995, no_hdr0=''),
  1347 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1347, CurrentID=0, Status='live', Symbol='COX7A2', Aliases='COX7AL, COX7AL1, COXVIIAL, COXVIIa-L, VIIAL', description='cytochrome c oxidase subunit 7A2', other_designations='cytochrome c oxidase polypeptide 7A2, mitochondrial|cytochrome c oxidase polypeptide VIIa-liver/heart|cytochrome c oxidase subunit VIIa polypeptide 2 (liver)|cytochrome c oxidase subunit VIIa-L|cytochrome c oxidase subunit VIIa-liver/heart|cytochrome c oxidase subunit VIIaL|hepatic cytochrome-c oxidase chain VIIa', map_location='6q12', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=75237675, end_position_on_the_genomic_accession=75254885, orientation='minus', exon_count=5, OMIM=123996, no_hdr0=''),
  1349 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1349, CurrentID=0, Status='live', Symbol='COX7B', Aliases='APLCC, LSDMCA2', description='cytochrome c oxidase subunit 7B', other_designations='cytochrome c oxidase polypeptide VIIb|cytochrome c oxidase subunit VIIb|cytochrome-c oxidase chain VIIb', map_location='Xq21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=77899464, end_position_on_the_genomic_accession=77905384, orientation='plus', exon_count=3, OMIM=300885, no_hdr0=''),
  1350 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1350, CurrentID=0, Status='live', Symbol='COX7C', Aliases='', description='cytochrome c oxidase subunit 7C', other_designations='cytochrome c oxidase polypeptide VIIc|cytochrome c oxidase subunit VIIc|cytochrome-c oxidase chain VIIc', map_location='5q14', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=86617967, end_position_on_the_genomic_accession=86620766, orientation='plus', exon_count=3, OMIM=603774, no_hdr0=''),
  1351 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1351, CurrentID=0, Status='live', Symbol='COX8A', Aliases='COX, COX8, COX8-2, COX8L, VIII, VIII-L', description='cytochrome c oxidase subunit 8A', other_designations='cytochrome c oxidase polypeptide VIII-liver/heart|cytochrome c oxidase subunit 8-2|cytochrome c oxidase subunit 8A (ubiquitous)|cytochrome c oxidase subunit VIII|cytochrome c oxidase subunit VIIIA (ubiquitous)', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=63974607, end_position_on_the_genomic_accession=63976543, orientation='plus', exon_count=2, OMIM=123870, no_hdr0=''),
  1352 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1352, CurrentID=0, Status='live', Symbol='COX10', Aliases='', description='COX10 heme A:farnesyltransferase cytochrome c oxidase assembly factor', other_designations='COX10 homolog, cytochrome c oxidase assembly protein, heme A: farnesyltransferase|cytochrome c oxidase assembly homolog 10|cytochrome c oxidase assembly protein|cytochrome c oxidase subunit X|heme A: farnesyltransferase|heme O synthase', map_location='17p12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=14069402, end_position_on_the_genomic_accession=14217922, orientation='plus', exon_count=12, OMIM=602125, no_hdr0=''),
  1353 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1353, CurrentID=0, Status='live', Symbol='COX11', Aliases='COX11P', description='COX11 cytochrome c oxidase copper chaperone', other_designations='COX11 cytochrome c oxidase assembly homolog|COX11 homolog, cytochrome c oxidase assembly protein|cytochrome c oxidase assembly homolog 11|cytochrome c oxidase subunit 11', map_location='17q22', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=54951898, end_position_on_the_genomic_accession=54968780, orientation='minus', exon_count=7, OMIM=603648, no_hdr0=''),
  1355 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1355, CurrentID=0, Status='live', Symbol='COX15', Aliases='CEMCOX2', description='COX15 cytochrome c oxidase assembly homolog', other_designations='COX15 homolog, cytochrome c oxidase assembly protein|cytochrome c oxidase assembly homolog 15|cytochrome c oxidase subunit 15', map_location='10q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=99696129, end_position_on_the_genomic_accession=99732666, orientation='minus', exon_count=10, OMIM=603646, no_hdr0=''),
  1356 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1356, CurrentID=0, Status='live', Symbol='CP', Aliases='CP-2', description='ceruloplasmin (ferroxidase)', other_designations='', map_location='3q23-q25', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=149162410, end_position_on_the_genomic_accession=149222050, orientation='minus', exon_count=23, OMIM=117700, no_hdr0=''),
  1357 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1357, CurrentID=0, Status='live', Symbol='CPA1', Aliases='CPA', description='carboxypeptidase A1', other_designations='carboxypeptidase A1 (pancreatic)|pancreatic carboxypeptidase A', map_location='7q32', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=130380371, end_position_on_the_genomic_accession=130388108, orientation='plus', exon_count=10, OMIM=114850, no_hdr0=''),
  1358 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1358, CurrentID=0, Status='live', Symbol='CPA2', Aliases='', description='carboxypeptidase A2', other_designations='carboxypeptidase A2 (pancreatic)', map_location='7q32', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=130266863, end_position_on_the_genomic_accession=130289798, orientation='plus', exon_count=11, OMIM=600688, no_hdr0=''),
  1359 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1359, CurrentID=0, Status='live', Symbol='CPA3', Aliases='MC-CPA', description='carboxypeptidase A3', other_designations='carboxypeptidase A3 (mast cell)|tissue carboxypeptidase A', map_location='3q24', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=148865256, end_position_on_the_genomic_accession=148897087, orientation='plus', exon_count=11, OMIM=114851, no_hdr0=''),
  1360 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1360, CurrentID=0, Status='live', Symbol='CPB1', Aliases='CPB, PASP, PCPB', description='carboxypeptidase B1', other_designations='carboxypeptidase B1 (tissue)|pancreas-specific protein|pancreatic carboxypeptidase B|procarboxypeptidase B|protaminase|tissue carboxypeptidase B', map_location='3q24', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=148791180, end_position_on_the_genomic_accession=148860192, orientation='plus', exon_count=13, OMIM=114852, no_hdr0=''),
  1361 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1361, CurrentID=0, Status='live', Symbol='CPB2', Aliases='CPU, PCPB, TAFI', description='carboxypeptidase B2', other_designations='carboxypeptidase B-like protein|carboxypeptidase B2 (plasma)|carboxypeptidase B2 (plasma, carboxypeptidase U)|carboxypeptidase R|thrombin-activable fibrinolysis inhibitor|thrombin-activatable fibrinolysis inhibitor', map_location='13q14.11', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=46053187, end_position_on_the_genomic_accession=46105076, orientation='minus', exon_count=11, OMIM=603101, no_hdr0=''),
  1362 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1362, CurrentID=0, Status='live', Symbol='CPD', Aliases='GP180', description='carboxypeptidase D', other_designations='metallocarboxypeptidase D', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=30378910, end_position_on_the_genomic_accession=30469657, orientation='plus', exon_count=22, OMIM=603102, no_hdr0=''),
  1363 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1363, CurrentID=0, Status='live', Symbol='CPE', Aliases='CPH', description='carboxypeptidase E', other_designations='carboxypeptidase H|cobalt-stimulated chromaffin granule carboxypeptidase|enkephalin convertase|insulin granule-associated carboxypeptidase|prohormone-processing carboxypeptidase', map_location='4q32.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=165378945, end_position_on_the_genomic_accession=165498330, orientation='plus', exon_count=9, OMIM=114855, no_hdr0=''),
  1364 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1364, CurrentID=0, Status='live', Symbol='CLDN4', Aliases='CPE-R, CPER, CPETR, CPETR1, WBSCR8, hCPE-R', description='claudin 4', other_designations='CPE-receptor|Clostridium perfringens enterotoxin receptor 1|Williams-Beuren syndrome chromosomal region 8 protein', map_location='7q11.23', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=73830863, end_position_on_the_genomic_accession=73832693, orientation='plus', exon_count=1, OMIM=602909, no_hdr0=''),
  1365 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1365, CurrentID=0, Status='live', Symbol='CLDN3', Aliases='C7orf1, CPE-R2, CPETR2, HRVP1, RVP1', description='claudin 3', other_designations='CPE-R 2|CPE-receptor 2|Clostridium perfringens enterotoxin receptor 2|ventral prostate.1 protein homolog|ventral prostate.1-like protein', map_location='7q11.23', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=73768997, end_position_on_the_genomic_accession=73770270, orientation='minus', exon_count=1, OMIM=602910, no_hdr0=''),
  1366 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1366, CurrentID=0, Status='live', Symbol='CLDN7', Aliases='CEPTRL2, CLDN-7, CPETRL2, Hs.84359, claudin-1', description='claudin 7', other_designations='clostridium perfringens enterotoxin receptor-like 2', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7259903, end_position_on_the_genomic_accession=7263193, orientation='minus', exon_count=5, OMIM=609131, no_hdr0=''),
  54841 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=54841, CurrentID=0, Status='live', Symbol='BIVM', Aliases='', description='basic, immunoglobulin-like variable motif containing', other_designations='', map_location='13q33.1', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=102799049, end_position_on_the_genomic_accession=102841538, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  1368 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1368, CurrentID=0, Status='live', Symbol='CPM', Aliases='', description='carboxypeptidase M', other_designations='renal carboxypeptidase|urinary carboxypeptidase B', map_location='12q14.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=68851175, end_position_on_the_genomic_accession=68963240, orientation='minus', exon_count=10, OMIM=114860, no_hdr0=''),
  1369 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1369, CurrentID=0, Status='live', Symbol='CPN1', Aliases='CPN, SCPN', description='carboxypeptidase N subunit 1', other_designations='anaphylatoxin inactivator|arginine carboxypeptidase|carboxypeptidase K|carboxypeptidase N catalytic subunit|carboxypeptidase N polypeptide 1 50 kD|carboxypeptidase N small subunit|carboxypeptidase N, polypeptide 1|kininase I|kininase-1|lysine carboxypeptidase|plasma carboxypeptidase B|serum carboxypeptidase N', map_location='10q24.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=100042308, end_position_on_the_genomic_accession=100081901, orientation='minus', exon_count=9, OMIM=603103, no_hdr0=''),
  1370 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1370, CurrentID=0, Status='live', Symbol='CPN2', Aliases='ACBP', description='carboxypeptidase N subunit 2', other_designations='arginine carboxypeptidase|carboxypeptidase N 83 kDa chain|carboxypeptidase N large subunit|carboxypeptidase N regulatory subunit|carboxypeptidase N, polypeptide 2|carboxypeptidase N, polypeptide 2, 83kD', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=194339765, end_position_on_the_genomic_accession=194351345, orientation='minus', exon_count=3, OMIM=603104, no_hdr0=''),
  1371 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1371, CurrentID=0, Status='live', Symbol='CPOX', Aliases='CPO, CPX, HCP', description='coproporphyrinogen oxidase', other_designations='COX|coprogen oxidase|coproporphyrinogen-III oxidase, mitochondrial|coproporphyrinogenase', map_location='3q12', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=98576414, end_position_on_the_genomic_accession=98593668, orientation='minus', exon_count=9, OMIM=612732, no_hdr0=''),
  1373 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1373, CurrentID=0, Status='live', Symbol='CPS1', Aliases='CPSASE1, PHN', description='carbamoyl-phosphate synthase 1', other_designations='carbamoyl-phosphate synthase (ammonia)|carbamoyl-phosphate synthase 1, mitochondrial|carbamoylphosphate synthetase I', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=210477682, end_position_on_the_genomic_accession=210679107, orientation='plus', exon_count=43, OMIM=608307, no_hdr0=''),
  1374 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1374, CurrentID=0, Status='live', Symbol='CPT1A', Aliases='CPT1, CPT1-L, L-CPT1', description='carnitine palmitoyltransferase 1A (liver)', other_designations='CPT I|CPTI-L|carnitine O-palmitoyltransferase I, liver isoform|carnitine palmitoyltransferase I, liver', map_location='11q13.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=68754620, end_position_on_the_genomic_accession=68841931, orientation='minus', exon_count=21, OMIM=600528, no_hdr0=''),
  1375 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1375, CurrentID=0, Status='live', Symbol='CPT1B', Aliases='CPT1-M, CPT1M, CPTI, CPTI-M, M-CPT1, MCCPT1, MCPT1', description='carnitine palmitoyltransferase 1B', other_designations='carnitine O-palmitoyltransferase I, mitochondrial muscle isoform|carnitine palmitoyltransferase 1B (muscle)|carnitine palmitoyltransferase I-like protein', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50568861, end_position_on_the_genomic_accession=50578667, orientation='minus', exon_count=21, OMIM=601987, no_hdr0=''),
  1376 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1376, CurrentID=0, Status='live', Symbol='CPT2', Aliases='CPT1, CPTASE, IIAE4', description='carnitine palmitoyltransferase 2', other_designations='CPT II|carnitine palmitoyltransferase II', map_location='1p32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=53196429, end_position_on_the_genomic_accession=53214197, orientation='plus', exon_count=5, OMIM=600650, no_hdr0=''),
  105377624 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105377624, CurrentID=0, Status='live', Symbol='LOC105377624', Aliases='', description='uncharacterized LOC105377624', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=185570102, end_position_on_the_genomic_accession=185580930, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  1378 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1378, CurrentID=0, Status='live', Symbol='CR1', Aliases='C3BR, C4BR, CD35, KN', description='complement component 3b/4b receptor 1 (Knops blood group)', other_designations='C3-binding protein|C3b/C4b receptor|CD35 antigen|Knops blood group antigen|complement component (3b/4b) receptor 1 (Knops blood group)', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207496128, end_position_on_the_genomic_accession=207641765, orientation='plus', exon_count=48, OMIM=120620, no_hdr0=''),
  1379 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1379, CurrentID=0, Status='live', Symbol='CR1L', Aliases='', description='complement component 3b/4b receptor 1-like', other_designations='complement C4b-binding protein CR-1-like protein|complement component (3b/4b) receptor 1-like', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207645113, end_position_on_the_genomic_accession=207723691, orientation='plus', exon_count=12, OMIM=605886, no_hdr0=''),
  1380 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1380, CurrentID=0, Status='live', Symbol='CR2', Aliases='C3DR, CD21, CR, CVID7, SLEB9', description='complement component 3d receptor 2', other_designations='EBV receptor|complement C3d receptor|complement component (3d/Epstein Barr virus) receptor 2', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207454300, end_position_on_the_genomic_accession=207489897, orientation='plus', exon_count=21, OMIM=120650, no_hdr0=''),
  1381 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1381, CurrentID=0, Status='live', Symbol='CRABP1', Aliases='CRABP, CRABP-I, CRABPI, RBP5', description='cellular retinoic acid binding protein 1', other_designations='cellular retinoic acid-binding protein I', map_location='15q24', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78340324, end_position_on_the_genomic_accession=78348230, orientation='plus', exon_count=4, OMIM=180230, no_hdr0=''),
  1382 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1382, CurrentID=0, Status='live', Symbol='CRABP2', Aliases='CRABP-II, RBP6', description='cellular retinoic acid binding protein 2', other_designations='cellular retinoic acid-binding protein II', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=156699606, end_position_on_the_genomic_accession=156705816, orientation='minus', exon_count=5, OMIM=180231, no_hdr0=''),
  11153 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=11153, CurrentID=0, Status='live', Symbol='FICD', Aliases='HIP13, HYPE, UNQ3041', description='FIC domain containing', other_designations='AMPylator FICD|FIC domain-containing protein|HIP-13|Huntingtin interacting protein E|fic S-phase protein cell division homolog|huntingtin interacting protein 13|huntingtin interactor protein E|huntingtin yeast partner E|huntingtin-interacting protein 13|huntingtin-interacting protein E', map_location='12q24.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=108515211, end_position_on_the_genomic_accession=108521210, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  1384 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1384, CurrentID=0, Status='live', Symbol='CRAT', Aliases='CAT1', description='carnitine O-acetyltransferase', other_designations='CAT|carnitine acetylase|carnitine acetyltransferase', map_location='9q34.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=129094794, end_position_on_the_genomic_accession=129110791, orientation='minus', exon_count=17, OMIM=600184, no_hdr0=''),
  1385 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1385, CurrentID=0, Status='live', Symbol='CREB1', Aliases='CREB', description='cAMP responsive element binding protein 1', other_designations='CREB-1|active transcription factor CREB|cAMP-response element-binding protein-1|cAMP-responsive element-binding protein 1|transactivator protein', map_location='2q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=207529892, end_position_on_the_genomic_accession=207605560, orientation='plus', exon_count=15, OMIM=123810, no_hdr0=''),
  1386 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1386, CurrentID=0, Status='live', Symbol='ATF2', Aliases='CRE-BP1, CREB-2, CREB2, HB16, TREB7', description='activating transcription factor 2', other_designations='activating transcription factor 2 splice variant ATF2-var2|cAMP response element-binding protein CRE-BP1|cAMP responsive element binding protein 2, formerly|cAMP-dependent transcription factor ATF-2|cAMP-responsive element-binding protein 2|cyclic AMP-responsive element-binding protein 2|histone acetyltransferase ATF2', map_location='2q32', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=175072250, end_position_on_the_genomic_accession=175168206, orientation='minus', exon_count=17, OMIM=123811, no_hdr0=''),
  1387 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1387, CurrentID=0, Status='live', Symbol='CREBBP', Aliases='CBP, KAT3A, RSTS', description='CREB binding protein', other_designations='', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=3725054, end_position_on_the_genomic_accession=3880120, orientation='minus', exon_count=34, OMIM=600140, no_hdr0=''),
  1388 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1388, CurrentID=0, Status='live', Symbol='ATF6B', Aliases='CREB-RP, CREBL1, G13', description='activating transcription factor 6 beta', other_designations='Creb-related protein|cAMP response element-binding protein-related protein|cAMP responsive element binding protein-like 1|cAMP-dependent transcription factor ATF-6 beta|cAMP-responsive element-binding protein-like 1|protein G13', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=32115268, end_position_on_the_genomic_accession=32128240, orientation='minus', exon_count=18, OMIM=600984, no_hdr0=''),
  1389 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1389, CurrentID=0, Status='live', Symbol='CREBL2', Aliases='', description='cAMP responsive element binding protein-like 2', other_designations='MHBs-binding protein 1', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=12611833, end_position_on_the_genomic_accession=12645108, orientation='plus', exon_count=4, OMIM=603476, no_hdr0=''),
  1390 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1390, CurrentID=0, Status='live', Symbol='CREM', Aliases='CREM-2, ICER, hCREM-2', description='cAMP responsive element modulator', other_designations='CREM 2alpha-b protein|CREM 2beta-a protein|cAMP response element modulator|inducible cAMP early repressor ICER', map_location='10p11.21', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=35126841, end_position_on_the_genomic_accession=35212958, orientation='plus', exon_count=18, OMIM=123812, no_hdr0=''),
  1392 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1392, CurrentID=0, Status='live', Symbol='CRH', Aliases='CRF1, CRH', description='corticotropin releasing hormone', other_designations='corticotropin-releasing factor', map_location='8q13', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=66176377, end_position_on_the_genomic_accession=66178611, orientation='minus', exon_count=2, OMIM=122560, no_hdr0=''),
  1393 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1393, CurrentID=0, Status='live', Symbol='CRHBP', Aliases='CRF-BP, CRFBP', description='corticotropin releasing hormone binding protein', other_designations='CRF-binding protein|CRH-BP|corticotropin releasing hormone-binding protein|corticotropin-releasing hormone-binding protein', map_location='5q13.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=76952835, end_position_on_the_genomic_accession=76981147, orientation='plus', exon_count=9, OMIM=122559, no_hdr0=''),
  1394 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1394, CurrentID=0, Status='live', Symbol='CRHR1', Aliases='CRF-R, CRF-R-1, CRF-R1, CRF1, CRFR-1, CRFR1, CRH-R-1, CRH-R1, CRHRL, CRHR1', description='corticotropin releasing hormone receptor 1', other_designations='CRH receptor 1|corticotropin-releasing factor type 1 receptor|seven transmembrane helix receptor', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=45784280, end_position_on_the_genomic_accession=45835828, orientation='plus', exon_count=14, OMIM=122561, no_hdr0=''),
  1395 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1395, CurrentID=0, Status='live', Symbol='CRHR2', Aliases='CRF-RB, CRF2, CRFR2, HM-CRF', description='corticotropin releasing hormone receptor 2', other_designations='CRF2 receptor, beta isoform|CRH receptor 2 variant B|CRH-R2', map_location='7p14.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=30651843, end_position_on_the_genomic_accession=30700103, orientation='minus', exon_count=16, OMIM=602034, no_hdr0=''),
  1396 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1396, CurrentID=0, Status='live', Symbol='CRIP1', Aliases='CRHP, CRIP, CRP-1, CRP1', description='cysteine rich protein 1', other_designations='cysteine-rich heart protein|cysteine-rich intestinal protein|cysteine-rich protein 1 (intestinal)', map_location='14q32.33', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=105486920, end_position_on_the_genomic_accession=105488789, orientation='plus', exon_count=6, OMIM=123875, no_hdr0=''),
  1397 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1397, CurrentID=0, Status='live', Symbol='CRIP2', Aliases='CRIP, CRP2, ESP1', description='cysteine rich protein 2', other_designations='Cysteine-rich intestinal protein|LIM domain protein ESP1/CRP2', map_location='14q32.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=105472938, end_position_on_the_genomic_accession=105480170, orientation='plus', exon_count=11, OMIM=601183, no_hdr0=''),
  1398 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1398, CurrentID=0, Status='live', Symbol='CRK', Aliases='CRKII, p38', description='v-crk avian sarcoma virus CT10 oncogene homolog', other_designations='proto-oncogene c-Crk|v-crk sarcoma virus CT10 oncogene-like protein', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=1421353, end_position_on_the_genomic_accession=1456267, orientation='minus', exon_count=3, OMIM=164762, no_hdr0=''),
  1399 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1399, CurrentID=0, Status='live', Symbol='CRKL', Aliases='', description='v-crk avian sarcoma virus CT10 oncogene homolog-like', other_designations='', map_location='22q11.21', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=20917398, end_position_on_the_genomic_accession=20953749, orientation='plus', exon_count=4, OMIM=602007, no_hdr0=''),
  1400 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1400, CurrentID=0, Status='live', Symbol='CRMP1', Aliases='CRMP-1, DPYSL1, DRP-1, DRP1, ULIP-3', description='collapsin response mediator protein 1', other_designations='dihydropyrimidinase-like 1|unc-33-like phosphoprotein 3', map_location='4p16.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=5820764, end_position_on_the_genomic_accession=5893083, orientation='minus', exon_count=17, OMIM=602462, no_hdr0=''),
  1401 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1401, CurrentID=0, Status='live', Symbol='CRP', Aliases='PTX1', description='C-reactive protein, pentraxin-related', other_designations='pentraxin 1', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=159712289, end_position_on_the_genomic_accession=159714609, orientation='minus', exon_count=3, OMIM=123260, no_hdr0=''),
  1404 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1404, CurrentID=0, Status='live', Symbol='HAPLN1', Aliases='CRT1, CRTL1', description='hyaluronan and proteoglycan link protein 1', other_designations='Cartilage link protein|cartilage linking protein 1|cartilage-link protein|cartilage-linking protein 1|proteoglycan link protein', map_location='5q14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=83638198, end_position_on_the_genomic_accession=83721077, orientation='minus', exon_count=7, OMIM=115435, no_hdr0=''),
  1406 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1406, CurrentID=0, Status='live', Symbol='CRX', Aliases='CORD2, CRD, LCA7, OTX3', description='cone-rod homeobox', other_designations='orthodenticle homeobox 3', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=47821842, end_position_on_the_genomic_accession=47843330, orientation='plus', exon_count=4, OMIM=602225, no_hdr0=''),
  1407 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1407, CurrentID=0, Status='live', Symbol='CRY1', Aliases='PHLL1', description='cryptochrome circadian clock 1', other_designations='cryptochrome 1 (photolyase-like)', map_location='12q23-q24.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=106991364, end_position_on_the_genomic_accession=107093857, orientation='minus', exon_count=14, OMIM=601933, no_hdr0=''),
  1408 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1408, CurrentID=0, Status='live', Symbol='CRY2', Aliases='HCRY2, PHLL2', description='cryptochrome circadian clock 2', other_designations='cryptochrome 2 (photolyase-like)|growth-inhibiting protein 37', map_location='11p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=45847118, end_position_on_the_genomic_accession=45883248, orientation='plus', exon_count=13, OMIM=603732, no_hdr0=''),
  1409 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1409, CurrentID=0, Status='live', Symbol='CRYAA', Aliases='CRYA1, CTRCT9, HSPB4', description='crystallin alpha A', other_designations='crystallin, alpha A|crystallin, alpha-1|heat shock protein beta-4|human alphaA-crystallin (CRYA1)', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=43169008, end_position_on_the_genomic_accession=43172810, orientation='plus', exon_count=4, OMIM=123580, no_hdr0=''),
  1410 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1410, CurrentID=0, Status='live', Symbol='CRYAB', Aliases='CMD1II, CRYA2, CTPP2, CTRCT16, HEL-S-101, HSPB5, MFM2', description='crystallin alpha B', other_designations='crystallin, alpha B|epididymis secretory protein Li 101|heat shock protein beta-5|heat-shock 20 kD like-protein|renal carcinoma antigen NY-REN-27|rosenthal fiber component', map_location='11q23.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=111908620, end_position_on_the_genomic_accession=111913213, orientation='minus', exon_count=6, OMIM=123590, no_hdr0=''),
  1411 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1411, CurrentID=0, Status='live', Symbol='CRYBA1', Aliases='CRYB1, CTRCT10', description='crystallin beta A1', other_designations='beta crystallin A3 chain transcript CN|beta crystallin A3 chain transcript LAM|beta crystallin A3 chain transcript PS|beta crystallin A3 chain transcript TC|crystallin beta A3|crystallin beta A3/A1|crystallin, beta A1|crystallin, beta A3|eye lens structural protein|truncated beta-crystallin A3', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=29246857, end_position_on_the_genomic_accession=29254494, orientation='plus', exon_count=6, OMIM=123610, no_hdr0=''),
  1412 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1412, CurrentID=0, Status='live', Symbol='CRYBA2', Aliases='CTRCT42', description='crystallin beta A2', other_designations='crystallin, beta A2|eye lens structural protein', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=218990190, end_position_on_the_genomic_accession=218993556, orientation='minus', exon_count=6, OMIM=600836, no_hdr0=''),
  1413 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1413, CurrentID=0, Status='live', Symbol='CRYBA4', Aliases='CTRCT23, MCOPCT4', description='crystallin beta A4', other_designations='beta crystallin A4 chain transcript PS|beta-A4 crystallin|crystallin, beta A4|crystallin, beta polypeptide A4|eye lens structural protein', map_location='22q12.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=26607987, end_position_on_the_genomic_accession=26630672, orientation='plus', exon_count=7, OMIM=123631, no_hdr0=''),
  1414 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1414, CurrentID=0, Status='live', Symbol='CRYBB1', Aliases='CATCN3, CTRCT17', description='crystallin beta B1', other_designations='beta-B1 crystallin|crystallin, beta B1|eye lens structural protein', map_location='22q12.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=26599278, end_position_on_the_genomic_accession=26618087, orientation='minus', exon_count=6, OMIM=600929, no_hdr0=''),
  1415 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1415, CurrentID=0, Status='live', Symbol='CRYBB2', Aliases='CCA2, CRYB2, CRYB2A, CTRCT3, D22S665', description='crystallin beta B2', other_designations='CTA-221G9.7|beta-B2 crystallin|beta-crystallin Bp|crystallin, beta B2|eye lens structural protein', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=25211670, end_position_on_the_genomic_accession=25231869, orientation='plus', exon_count=7, OMIM=123620, no_hdr0=''),
  1417 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1417, CurrentID=0, Status='live', Symbol='CRYBB3', Aliases='CATCN2, CRYB3, CTRCT22', description='crystallin beta B3', other_designations='crystallin, beta B3|eye lens structural protein', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=25198686, end_position_on_the_genomic_accession=25207363, orientation='plus', exon_count=6, OMIM=123630, no_hdr0=''),
  1418 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1418, CurrentID=0, Status='live', Symbol='CRYGA', Aliases='CRY-g-A, CRYG1, CRYG5', description='crystallin gamma A', other_designations='crystallin, gamma 1|crystallin, gamma A|gamma-crystallin 5', map_location='2q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=208160740, end_position_on_the_genomic_accession=208163573, orientation='minus', exon_count=3, OMIM=123660, no_hdr0=''),
  1419 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1419, CurrentID=0, Status='live', Symbol='CRYGB', Aliases='CRYG2, CTRCT39', description='crystallin gamma B', other_designations='crystallin, gamma 1-2|crystallin, gamma B', map_location='2q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=208142573, end_position_on_the_genomic_accession=208146153, orientation='minus', exon_count=3, OMIM=123670, no_hdr0=''),
  1420 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1420, CurrentID=0, Status='live', Symbol='CRYGC', Aliases='CCL, CRYG3, CTRCT2', description='crystallin gamma C', other_designations='crystallin, gamma C|gamma-crystallin 2-1|gamma-crystallin 3', map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=208128137, end_position_on_the_genomic_accession=208139738, orientation='minus', exon_count=5, OMIM=123680, no_hdr0=''),
  1421 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1421, CurrentID=0, Status='live', Symbol='CRYGD', Aliases='CACA, CCA3, CCP, CRYG4, CTRCT4, PCC, cry-g-D', description='crystallin gamma D', other_designations='crystallin, gamma D|gamma crystallin 4|gamma-D-crystallin|gamma-crystallin 4', map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=208121607, end_position_on_the_genomic_accession=208124589, orientation='minus', exon_count=3, OMIM=123690, no_hdr0=''),
  56260 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=56260, CurrentID=0, Status='live', Symbol='C8orf44', Aliases='', description='chromosome 8 open reading frame 44', other_designations='', map_location='8q13.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=66667552, end_position_on_the_genomic_accession=66681149, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  1427 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1427, CurrentID=0, Status='live', Symbol='CRYGS', Aliases='CRYG8, CTRCT20', description='crystallin gamma S', other_designations='crystallin, gamma 8|crystallin, gamma S|gamma-S-crystallin|gamma-crystallin S', map_location='3q27.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186538443, end_position_on_the_genomic_accession=186544378, orientation='minus', exon_count=3, OMIM=123730, no_hdr0=''),
  1428 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1428, CurrentID=0, Status='live', Symbol='CRYM', Aliases='DFNA40, THBP', description='crystallin mu', other_designations='NADP-regulated thyroid-hormone binding protein|crystallin, mu|mu-crystallin homolog|thiomorpholine-carboxylate dehydrogenase', map_location='16p12.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=21258518, end_position_on_the_genomic_accession=21303136, orientation='minus', exon_count=10, OMIM=123740, no_hdr0=''),
  1429 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1429, CurrentID=0, Status='live', Symbol='CRYZ', Aliases='', description='crystallin zeta', other_designations='NADPH:quinone reductase|crystallin, zeta (quinone reductase)', map_location='1p31.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=74705482, end_position_on_the_genomic_accession=74733408, orientation='minus', exon_count=11, OMIM=123691, no_hdr0=''),
  1431 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1431, CurrentID=0, Status='live', Symbol='CS', Aliases='', description='citrate synthase', other_designations='citrate (Si)-synthase', map_location='12q13.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=56271699, end_position_on_the_genomic_accession=56300391, orientation='minus', exon_count=11, OMIM=118950, no_hdr0=''),
  1432 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1432, CurrentID=0, Status='live', Symbol='MAPK14', Aliases='CSBP, CSBP1, CSBP2, CSPB1, EXIP, Mxi2, PRKM14, PRKM15, RK, SAPK2A, p38, p38ALPHA', description='mitogen-activated protein kinase 14', other_designations='CSAID-binding protein|Csaids binding protein|MAP kinase 14|MAP kinase Mxi2|MAP kinase p38 alpha|MAX-interacting protein 2|cytokine suppressive anti-inflammatory drug binding protein|cytokine suppressive anti-inflammatory drug-binding protein|mitogen-activated protein kinase p38 alpha|p38 MAP kinase|p38 mitogen activated protein kinase|p38alpha Exip|stress-activated protein kinase 2A', map_location='6p21.3-p21.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=36027635, end_position_on_the_genomic_accession=36111236, orientation='plus', exon_count=19, OMIM=600289, no_hdr0=''),
  105373984 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105373984, CurrentID=0, Status='live', Symbol='LOC105373984', Aliases='', description='anther-specific proline-rich protein APG-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=105142926, end_position_on_the_genomic_accession=105145520, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  1434 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1434, CurrentID=0, Status='live', Symbol='CSE1L', Aliases='CAS, CSE1, XPO2', description='CSE1 chromosome segregation 1-like (yeast)', other_designations='cellular apoptosis susceptibility protein|chromosome segregation 1-like protein|exp2|importin-alpha re-exporter', map_location='20q13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=49046246, end_position_on_the_genomic_accession=49096960, orientation='plus', exon_count=25, OMIM=601342, no_hdr0=''),
  1435 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1435, CurrentID=0, Status='live', Symbol='CSF1', Aliases='CSF-1, MCSF', description='colony stimulating factor 1', other_designations='colony stimulating factor 1 (macrophage)|lanimostim', map_location='1p13.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=109910611, end_position_on_the_genomic_accession=109930994, orientation='plus', exon_count=10, OMIM=120420, no_hdr0=''),
  1436 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1436, CurrentID=0, Status='live', Symbol='CSF1R', Aliases='C-FMS, CD115, CSF-1R, CSFR, FIM2, FMS, HDLS, M-CSF-R', description='colony stimulating factor 1 receptor', other_designations='CD115 antigen|CSF-1 receptor|FMS proto-oncogene|McDonough feline sarcoma viral (v-fms) oncogene homolog|macrophage colony stimulating factor I receptor|proto-oncogene c-Fms', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=150053291, end_position_on_the_genomic_accession=150113372, orientation='minus', exon_count=22, OMIM=164770, no_hdr0=''),
  1437 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1437, CurrentID=0, Status='live', Symbol='CSF2', Aliases='GMCSF', description='colony stimulating factor 2', other_designations='CSF|colony stimulating factor 2 (granulocyte-macrophage)|granulocyte macrophage-colony stimulating factor|molgramostin|sargramostim', map_location='5q31.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=132073792, end_position_on_the_genomic_accession=132076170, orientation='plus', exon_count=4, OMIM=138960, no_hdr0=''),
  1438 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1438, CurrentID=0, Status='live', Symbol='CSF2RA', Aliases='CD116, CDw116, CSF2RX, CSF2RAY, CSF2RX, CSF2RY, GM-CSF-R-alpha, GMCSFR, GMR, SMDP4, CSF2RA', description='colony stimulating factor 2 receptor alpha subunit', other_designations='CD116 antigen|GM-CSF receptor alpha subunit|GMCSFR-alpha|GMR-alpha|colony stimulating factor 2 receptor, alpha, low-affinity (granulocyte-macrophage)|granulocyte-macrophage colony-stimulating factor receptor alpha chain', map_location='Xp22.32 and Yp11.3', chromosome='Y', genomic_nucleotide_accession_version='NC_000024.10', start_position_on_the_genomic_accession=1268800, end_position_on_the_genomic_accession=1325078, orientation='plus', exon_count=19, OMIM='306250,425000', no_hdr0=''),
  1439 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1439, CurrentID=0, Status='live', Symbol='CSF2RB', Aliases='CD131, CDw131, IL3RB, IL5RB, SMDP5', description='colony stimulating factor 2 receptor beta common subunit', other_designations='GM-CSF/IL-3/IL-5 receptor common beta subunit|GM-CSF/IL-3/IL-5 receptor common beta-chain|beta common cytokine receptor|colony stimulating factor 2 receptor, beta, low-affinity (granulocyte-macrophage)|colony-stimulating factor-2 receptor, beta, low-affinity|interleukin 3 receptor/granulocyte-macrophage colony stimulating factor 3 receptor, beta (high affinity)', map_location='22q13.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=36913575, end_position_on_the_genomic_accession=36940449, orientation='plus', exon_count=14, OMIM=138981, no_hdr0=''),
  1440 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1440, CurrentID=0, Status='live', Symbol='CSF3', Aliases='C17orf33OS, GCSF, CSF3', description='colony stimulating factor 3', other_designations='colony stimulating factor 3 (granulocyte)|filgrastim|granulocyte-colony stimulating factor|lenograstim|pluripoietin', map_location='17q11.2-q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=40015361, end_position_on_the_genomic_accession=40017813, orientation='plus', exon_count=5, OMIM=138970, no_hdr0=''),
  1441 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1441, CurrentID=0, Status='live', Symbol='CSF3R', Aliases='CD114, GCSFR', description='colony stimulating factor 3 receptor', other_designations='CD114 antigen|G-CSF receptor|G-CSF-R|colony stimulating factor 3 receptor (granulocyte)', map_location='1p35-p34.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=36466043, end_position_on_the_genomic_accession=36483314, orientation='minus', exon_count=18, OMIM=138971, no_hdr0=''),
  1442 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1442, CurrentID=0, Status='live', Symbol='CSH1', Aliases='CS-1, CSA, CSMT, GHB3, PL, hCS-1, hCS-A', description='chorionic somatomammotropin hormone 1', other_designations='choriomammotropin|chorionic somatomammotropin A|chorionic somatomammotropin hormone 1 (placental lactogen)|chorionic somatomammotropin-1|growth hormone B3|placental lactogen', map_location='17q24.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63894908, end_position_on_the_genomic_accession=63896661, orientation='minus', exon_count=5, OMIM=150200, no_hdr0=''),
  1443 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1443, CurrentID=0, Status='live', Symbol='CSH2', Aliases='CS-2, CSB, GHB1, PL, hCS-B', description='chorionic somatomammotropin hormone 2', other_designations='choriomammotropin|chorionic somatomammotropin B|growth hormone B1|lactogen|placental lactogen', map_location='17q24.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63872012, end_position_on_the_genomic_accession=63873729, orientation='minus', exon_count=5, OMIM=118820, no_hdr0=''),
  1444 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1444, CurrentID=0, Status='live', Symbol='CSHL1', Aliases='CS-5, CSHP1, CSL, GHB4, hCS-L', description='chorionic somatomammotropin hormone like 1', other_designations='chorionic somatomammotropin CS-5|growth hormone B4|growth hormone cluster', map_location='17q24.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63909602, end_position_on_the_genomic_accession=63911323, orientation='minus', exon_count=4, OMIM=603515, no_hdr0=''),
  1445 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1445, CurrentID=0, Status='live', Symbol='CSK', Aliases='', description='c-src tyrosine kinase', other_designations='C-Src kinase|protein-tyrosine kinase CYL', map_location='15q24.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74782084, end_position_on_the_genomic_accession=74803198, orientation='plus', exon_count=15, OMIM=124095, no_hdr0=''),
  1446 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1446, CurrentID=0, Status='live', Symbol='CSN1S1', Aliases='CASA, CSN1', description='casein alpha s1', other_designations='casein, alpha', map_location='4q21.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=69931062, end_position_on_the_genomic_accession=69946570, orientation='plus', exon_count=16, OMIM=115450, no_hdr0=''),
  1447 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1447, CurrentID=0, Status='live', Symbol='CSN2', Aliases='CASB', description='casein beta', other_designations='', map_location='4q21.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=69955256, end_position_on_the_genomic_accession=69993629, orientation='minus', exon_count=8, OMIM=115460, no_hdr0=''),
  1448 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1448, CurrentID=0, Status='live', Symbol='CSN3', Aliases='CNS10, CSN10, CSNK, KCA', description='casein kappa', other_designations='', map_location='4q21.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=70238306, end_position_on_the_genomic_accession=70251432, orientation='plus', exon_count=8, OMIM=601695, no_hdr0=''),
  100128327 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100128327, CurrentID=0, Status='live', Symbol='TRAPPC3L', Aliases='BET3L, bA259P20.2', description='trafficking protein particle complex 3-like', other_designations='BET3-like protein|TRAPPC3-like protein', map_location='6q22.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=116496483, end_position_on_the_genomic_accession=116545610, orientation='minus', exon_count=6, OMIM=614137, no_hdr0=''),
  1452 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1452, CurrentID=0, Status='live', Symbol='CSNK1A1', Aliases='CK1, CK1a, CKIa, HEL-S-77p, HLCDGP1, PRO2975', description='casein kinase 1 alpha 1', other_designations='CKI-alpha|casein kinase 1, alpha 1|clock regulator kinase|down-regulated in lung cancer|epididymis secretory sperm binding protein Li 77p', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=149495894, end_position_on_the_genomic_accession=149551552, orientation='minus', exon_count=11, OMIM=600505, no_hdr0=''),
  1453 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1453, CurrentID=0, Status='live', Symbol='CSNK1D', Aliases='ASPS, CKIdelta, FASPS2, HCKID', description='casein kinase 1 delta', other_designations='CKI-delta|CKId|casein kinase 1, delta|tau-protein kinase CSNK1D', map_location='17q25', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=82239725, end_position_on_the_genomic_accession=82273742, orientation='minus', exon_count=13, OMIM=600864, no_hdr0=''),
  1454 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1454, CurrentID=0, Status='live', Symbol='CSNK1E', Aliases='CKIepsilon, HCKIE', description='casein kinase 1 epsilon', other_designations='CKI-epsilon|CKIe|casein kinase 1, epsilon', map_location='22q13.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=38290691, end_position_on_the_genomic_accession=38318084, orientation='minus', exon_count=12, OMIM=600863, no_hdr0=''),
  1455 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1455, CurrentID=0, Status='live', Symbol='CSNK1G2', Aliases='CK1g2', description='casein kinase 1 gamma 2', other_designations='CKI-gamma 2|casein kinase 1 isoform gamma-2|casein kinase 1, gamma 2', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1941149, end_position_on_the_genomic_accession=1981338, orientation='plus', exon_count=13, OMIM=602214, no_hdr0=''),
  1456 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1456, CurrentID=0, Status='live', Symbol='CSNK1G3', Aliases='CKI-gamma 3L, CSNK1G3', description='casein kinase 1 gamma 3', other_designations='casein kinase 1, gamma 3', map_location='5q23', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=123512099, end_position_on_the_genomic_accession=123617045, orientation='plus', exon_count=14, OMIM=604253, no_hdr0=''),
  1457 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1457, CurrentID=0, Status='live', Symbol='CSNK2A1', Aliases='CK2A1, CKII, CSNK2A3', description='casein kinase 2, alpha 1 polypeptide', other_designations='CK II alpha 3|CK2 catalytic subunit alpha|casein kinase II alpha 1 polypeptide pseudogene|casein kinase II alpha 1 subunit|protein kinase CK2', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=472969, end_position_on_the_genomic_accession=543838, orientation='minus', exon_count=16, OMIM=115440, no_hdr0=''),
  641371 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=641371, CurrentID=0, Status='live', Symbol='ACOT1', Aliases='ACH2, CTE-1, LACH2', description='acyl-CoA thioesterase 1', other_designations='CTE-I|CTE-Ib|inducible cytosolic acyl-coenzyme A thioester hydrolase|long chain acyl-CoA hydrolase|long chain acyl-CoA thioester hydrolase', map_location='14q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=73493234, end_position_on_the_genomic_accession=73543799, orientation='plus', exon_count=7, OMIM=614313, no_hdr0=''),
  1459 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1459, CurrentID=0, Status='live', Symbol='CSNK2A2', Aliases='CK2A2, CSNK2A1', description='casein kinase 2 alpha 2', other_designations="CK II alpha'|casein kinase 2, alpha prime polypeptide", map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=58157907, end_position_on_the_genomic_accession=58197878, orientation='minus', exon_count=12, OMIM=115442, no_hdr0=''),
  1460 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1460, CurrentID=0, Status='live', Symbol='CSNK2B', Aliases='CK2B, CK2N, CSK2B, G5A', description='casein kinase 2 beta', other_designations='CK II beta|CSNK2B-LY6G5B-1072|CSNK2B-LY6G5B-1103|CSNK2B-LY6G5B-532|CSNK2B-LY6G5B-560|CSNK2B-LY6G5B-562|Casein kinase II beta subunit|alternative name: G5a, phosvitin|casein kinase 2, beta polypeptide|casein kinase II b subunit splicing isoform 132|casein kinase II b subunit splicing isoform 247|casein kinase II b subunit splicing isoform 318|casein kinase II b subunit splicing isoform 660|casein kinase II b subunit splicing isoform 806|chimera CSNK2B-LY6G5B splicing isoform 1072|chimera CSNK2B-LY6G5B splicing isoform 1103|chimera CSNK2B-LY6G5B splicing isoform 532|chimera CSNK2B-LY6G5B splicing isoform 560|chimera CSNK2B-LY6G5B splicing isoform 562|phosvitin|protein G5a', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31665880, end_position_on_the_genomic_accession=31670070, orientation='plus', exon_count=7, OMIM=115441, no_hdr0=''),
  1462 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1462, CurrentID=0, Status='live', Symbol='VCAN', Aliases='CSPG2, ERVR, GHAP, PG-M, WGN, WGN1', description='versican', other_designations='chondroitin sulfate proteoglycan 2|chondroitin sulfate proteoglycan core protein 2|glial hyaluronate-binding protein|large fibroblast proteoglycan|versican proteoglycan', map_location='5q14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=83471674, end_position_on_the_genomic_accession=83582303, orientation='plus', exon_count=15, OMIM=118661, no_hdr0=''),
  1463 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1463, CurrentID=0, Status='live', Symbol='NCAN', Aliases='CSPG3', description='neurocan', other_designations='chondroitin sulfate proteoglycan 3 (neurocan)|neurocan proteoglycan', map_location='19p12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=19211964, end_position_on_the_genomic_accession=19252252, orientation='plus', exon_count=15, OMIM=600826, no_hdr0=''),
  1464 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1464, CurrentID=0, Status='live', Symbol='CSPG4', Aliases='HMW-MAA, MCSP, MCSPG, MEL-CSPG, MSK16, NG2', description='chondroitin sulfate proteoglycan 4', other_designations='chondroitin sulfate proteoglycan 4 (melanoma-associated)|chondroitin sulfate proteoglycan NG2|melanoma chondroitin sulfate proteoglycan|melanoma-associated chondroitin sulfate proteoglycan', map_location='15q24.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=75674322, end_position_on_the_genomic_accession=75712848, orientation='minus', exon_count=10, OMIM=601172, no_hdr0=''),
  1465 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1465, CurrentID=0, Status='live', Symbol='CSRP1', Aliases='CRP, CRP1, CSRP, CYRP, D1S181E, HEL-141, HEL-S-286', description='cysteine and glycine rich protein 1', other_designations='LIM-domain protein|cysteine-rich protein 1|epididymis luminal protein 141|epididymis secretory protein Li 286', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=201483530, end_position_on_the_genomic_accession=201507259, orientation='minus', exon_count=8, OMIM=123876, no_hdr0=''),
  1466 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1466, CurrentID=0, Status='live', Symbol='CSRP2', Aliases='CRP2, LMO5, SmLIM', description='cysteine and glycine rich protein 2', other_designations='LIM domain only 5, smooth muscle|LIM domain only protein 5|LMO-5|cysteine-rich protein 2|smooth muscle cell LIM protein', map_location='12q21.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=76858715, end_position_on_the_genomic_accession=76879046, orientation='minus', exon_count=7, OMIM=601871, no_hdr0=''),
  1468 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1468, CurrentID=0, Status='live', Symbol='SLC25A10', Aliases='DIC', description='solute carrier family 25 (mitochondrial carrier; dicarboxylate transporter), member 10', other_designations='dicarboxylate ion carrier', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=81712236, end_position_on_the_genomic_accession=81721016, orientation='plus', exon_count=12, OMIM=606794, no_hdr0=''),
  1469 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1469, CurrentID=0, Status='live', Symbol='CST1', Aliases='', description='cystatin SN', other_designations='cystain-SA-I|cystatin 1|cystatin SA-I|cystatin-1|cysteine proteinase inhibitor, type 2 family|salivary cystatin-SA-1', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23747553, end_position_on_the_genomic_accession=23750937, orientation='minus', exon_count=3, OMIM=123855, no_hdr0=''),
  1470 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1470, CurrentID=0, Status='live', Symbol='CST2', Aliases='', description='cystatin SA', other_designations='cystatin 2|cystatin S5|cystatin-2|cystatin-S5|cysteine-proteinase inhibitor|salivary cysteine (thiol) protease inhibitor', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23823767, end_position_on_the_genomic_accession=23826675, orientation='minus', exon_count=3, OMIM=123856, no_hdr0=''),
  1471 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1471, CurrentID=0, Status='live', Symbol='CST3', Aliases='ARMD11, HEL-S-2', description='cystatin C', other_designations='bA218C14.4 (cystatin C)|cystatin 3|cystatin-3|epididymis secretory protein Li 2|gamma-trace|neuroendocrine basic polypeptide|post-gamma-globulin', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23627897, end_position_on_the_genomic_accession=23638048, orientation='minus', exon_count=4, OMIM=604312, no_hdr0=''),
  1472 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1472, CurrentID=0, Status='live', Symbol='CST4', Aliases='', description='cystatin S', other_designations='cystatin 4|cystatin-4|cystatin-SA-III|salivary acidic protein 1', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23685640, end_position_on_the_genomic_accession=23689025, orientation='minus', exon_count=3, OMIM=123857, no_hdr0=''),
  1473 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1473, CurrentID=0, Status='live', Symbol='CST5', Aliases='', description='cystatin D', other_designations='cystatin 5|cystatin-5|cysteine-proteinase inhibitor', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23875935, end_position_on_the_genomic_accession=23879743, orientation='minus', exon_count=3, OMIM=123858, no_hdr0=''),
  1474 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1474, CurrentID=0, Status='live', Symbol='CST6', Aliases='', description='cystatin E/M', other_designations='cystatin 6|cystatin M|cystatin M/E|cystatin-6|cystatin-E|cysteine proteinase inhibitor', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=66011991, end_position_on_the_genomic_accession=66013505, orientation='plus', exon_count=3, OMIM=601891, no_hdr0=''),
  1475 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1475, CurrentID=0, Status='live', Symbol='CSTA', Aliases='AREI, STF1, STFA', description='cystatin A', other_designations='cystatin A (stefin A)|cystatin AS', map_location='3q21', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=122325164, end_position_on_the_genomic_accession=122341969, orientation='plus', exon_count=3, OMIM=184600, no_hdr0=''),
  1476 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1476, CurrentID=0, Status='live', Symbol='CSTB', Aliases='CST6, EPM1, EPM1A, PME, STFB, ULD', description='cystatin B', other_designations='CPI-B|cystatin B (stefin B)|liver thiol proteinase inhibitor', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=43773665, end_position_on_the_genomic_accession=43776375, orientation='minus', exon_count=3, OMIM=601145, no_hdr0=''),
  1477 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1477, CurrentID=0, Status='live', Symbol='CSTF1', Aliases='CstF-50, CstFp50', description="cleavage stimulation factor, 3' pre-RNA, subunit 1", other_designations="CF-1 50 kDa subunit|CSTF 50 kDa subunit|cleavage stimulation factor 50 kDa subunit|cleavage stimulation factor, 3' pre-RNA, subunit 1, 50kD|cleavage stimulation factor, 3' pre-RNA, subunit 1, 50kDa", map_location='20q13.2', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=56392371, end_position_on_the_genomic_accession=56404526, orientation='plus', exon_count=6, OMIM=600369, no_hdr0=''),
  1478 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1478, CurrentID=0, Status='live', Symbol='CSTF2', Aliases='CstF-64', description="cleavage stimulation factor, 3' pre-RNA, subunit 2", other_designations="CF-1 64 kDa subunit|CSTF 64 kDa subunit|betaCstF-64 variant 2|cleavage stimulation factor 64 kDa subunit|cleavage stimulation factor, 3' pre-RNA, subunit 2, 64kD|cleavage stimulation factor, 3' pre-RNA, subunit 2, 64kDa", map_location='Xq22.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=100820359, end_position_on_the_genomic_accession=100841520, orientation='plus', exon_count=16, OMIM=300907, no_hdr0=''),
  1479 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1479, CurrentID=0, Status='live', Symbol='CSTF3', Aliases='CSTF-77', description="cleavage stimulation factor, 3' pre-RNA, subunit 3", other_designations="CF-1 77 kDa subunit|CSTF 77 kDa subunit|cleavage stimulation factor 77 kDa subunit|cleavage stimulation factor subunit 3|cleavage stimulation factor, 3' pre-RNA, subunit 3, 77kD|cleavage stimulation factor, 3' pre-RNA, subunit 3, 77kDa", map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=33084584, end_position_on_the_genomic_accession=33161491, orientation='minus', exon_count=22, OMIM=600367, no_hdr0=''),
  1482 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1482, CurrentID=0, Status='live', Symbol='NKX2-5', Aliases='CHNG5, CSX, CSX1, HLHS2, NKX2.5, NKX2E, NKX4-1, VSD3', description='NK2 homeobox 5', other_designations='NK2 transcription factor related locus 5|NK2 transcription factor related, locus 5|cardiac-specific homeobox 1|homeobox protein CSX|homeobox protein NK-2 homolog E|tinman paralog', map_location='5q34', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=173232104, end_position_on_the_genomic_accession=173235312, orientation='minus', exon_count=2, OMIM=600584, no_hdr0=''),
  165324 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=165324, CurrentID=0, Status='live', Symbol='UBXN2A', Aliases='UBXD4', description='UBX domain protein 2A', other_designations='UBX domain containing 4|UBX domain-containing protein 4', map_location='2p23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=23927271, end_position_on_the_genomic_accession=24001000, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  1485 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1485, CurrentID=0, Status='live', Symbol='CTAG1B', Aliases='CT6.1, CTAG, CTAG1, ESO1, LAGE-2, LAGE2B, NY-ESO-1', description='cancer/testis antigen 1B', other_designations='New York esophageal squamous cell carcinoma 1|autoimmunogenic cancer/testis antigen NY-ESO-1|cancer antigen 3|cancer/testis antigen 6.1|l antigen family member 2', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154617609, end_position_on_the_genomic_accession=154619271, orientation='minus', exon_count=3, OMIM=300156, no_hdr0=''),
  1486 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1486, CurrentID=0, Status='live', Symbol='CTBS', Aliases='CTB', description='chitobiase, di-N-acetyl-', other_designations='', map_location='1p22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=84553121, end_position_on_the_genomic_accession=84574480, orientation='minus', exon_count=7, OMIM=600873, no_hdr0=''),
  1487 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1487, CurrentID=0, Status='live', Symbol='CTBP1', Aliases='BARS', description='C-terminal binding protein 1', other_designations='brefeldin A-ribosylated substrate', map_location='4p16', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=1211440, end_position_on_the_genomic_accession=1250248, orientation='minus', exon_count=14, OMIM=602618, no_hdr0=''),
  1488 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1488, CurrentID=0, Status='live', Symbol='CTBP2', Aliases='', description='C-terminal binding protein 2', other_designations='ribeye', map_location='10q26.13', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=124987849, end_position_on_the_genomic_accession=125161055, orientation='minus', exon_count=21, OMIM=602619, no_hdr0=''),
  1489 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1489, CurrentID=0, Status='live', Symbol='CTF1', Aliases='CT-1, CT1', description='cardiotrophin 1', other_designations='cardiophin 1', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=30895828, end_position_on_the_genomic_accession=30903560, orientation='plus', exon_count=4, OMIM=600435, no_hdr0=''),
  1490 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1490, CurrentID=0, Status='live', Symbol='CTGF', Aliases='CCN2, HCS24, IGFBP8, NOV2', description='connective tissue growth factor', other_designations='CCN family member 2|IBP-8|IGF-binding protein 8|IGFBP-8|hypertrophic chondrocyte-specific protein 24|insulin-like growth factor-binding protein 8', map_location='6q23.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=131948176, end_position_on_the_genomic_accession=131951378, orientation='minus', exon_count=5, OMIM=121009, no_hdr0=''),
  1491 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1491, CurrentID=0, Status='live', Symbol='CTH', Aliases='', description='cystathionine gamma-lyase', other_designations='cystathionase (cystathionine gamma-lyase)|cysteine desulfhydrase|cysteine-protein sulfhydrase|gamma-cystathionase|homoserine deaminase|homoserine dehydratase', map_location='1p31.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=70411218, end_position_on_the_genomic_accession=70440114, orientation='plus', exon_count=13, OMIM=607657, no_hdr0=''),
  1493 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1493, CurrentID=0, Status='live', Symbol='CTLA4', Aliases='ALPS5, CD, CD152, CELIAC3, CTLA-4, GRD4, GSE, IDDM12', description='cytotoxic T-lymphocyte associated protein 4', other_designations='CD152 isoform|celiac disease 3|cytotoxic T lymphocyte associated antigen 4 short spliced form|cytotoxic T-lymphocyte-associated protein 4|cytotoxic T-lymphocyte-associated serine esterase-4|insulin-dependent diabetes mellitus 12|ligand and transmembrane spliced cytotoxic T lymphocyte associated antigen 4', map_location='2q33', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=203867788, end_position_on_the_genomic_accession=203873960, orientation='plus', exon_count=4, OMIM=123890, no_hdr0=''),
  388886 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=388886, CurrentID=0, Status='live', Symbol='LRRC75B', Aliases='C22orf36, FAM211B', description='leucine rich repeat containing 75B', other_designations='family with sequence similarity 211, member B|leucine-rich repeat-containing protein C22orf36|leucine-rich repeat-containing protein FAM211B', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=24585623, end_position_on_the_genomic_accession=24593104, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  1495 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1495, CurrentID=0, Status='live', Symbol='CTNNA1', Aliases='CAP102', description='catenin alpha 1', other_designations='alpha E-catenin|alpha-E-catenin|alpha-catenin|alphaE-catenin|cadherin-associated protein,102kDa|catenin (cadherin-associated protein), alpha 1, 102kDa|renal carcinoma antigen NY-REN-13', map_location='5q31.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=138753396, end_position_on_the_genomic_accession=138935034, orientation='plus', exon_count=22, OMIM=116805, no_hdr0=''),
  1496 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1496, CurrentID=0, Status='live', Symbol='CTNNA2', Aliases='CAP-R, CAPR, CT114, CTNR', description='catenin alpha 2', other_designations='alpha N-catenin|alpha-N-catenin|alpha-catenin-related protein|cadherin-associated protein, related|cancer/testis antigen 114|catenin (cadherin-associated protein), alpha 2', map_location='2p12-p11.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=79512934, end_position_on_the_genomic_accession=80648868, orientation='plus', exon_count=25, OMIM=114025, no_hdr0=''),
  1497 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1497, CurrentID=0, Status='live', Symbol='CTNS', Aliases='CTNS-LSB, PQLC4', description='cystinosin, lysosomal cystine transporter', other_designations='cystinosis nephropathic', map_location='17p13', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=3636468, end_position_on_the_genomic_accession=3663103, orientation='plus', exon_count=12, OMIM=606272, no_hdr0=''),
  1499 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1499, CurrentID=0, Status='live', Symbol='CTNNB1', Aliases='CTNNB, MRD19, armadillo', description='catenin beta 1', other_designations='catenin (cadherin-associated protein), beta 1, 88kDa', map_location='3p21', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=41199451, end_position_on_the_genomic_accession=41240448, orientation='plus', exon_count=17, OMIM=116806, no_hdr0=''),
  1500 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1500, CurrentID=0, Status='live', Symbol='CTNND1', Aliases='CAS, CTNND, P120CAS, P120CTN, p120, p120(CAS), p120(CTN)', description='catenin delta 1', other_designations='cadherin-associated Src substrate|catenin (cadherin-associated protein), delta 1|p120 catenin', map_location='11q11', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=57761762, end_position_on_the_genomic_accession=57819180, orientation='plus', exon_count=21, OMIM=601045, no_hdr0=''),
  1501 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1501, CurrentID=0, Status='live', Symbol='CTNND2', Aliases='GT24, NPRAP', description='catenin delta 2', other_designations='T-cell delta-catenin|catenin (cadherin-associated protein), delta 2 (neural plakophilin-related arm-repeat protein)|neurojungin', map_location='5p15.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=10971840, end_position_on_the_genomic_accession=11904043, orientation='minus', exon_count=26, OMIM=604275, no_hdr0=''),
  1503 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1503, CurrentID=0, Status='live', Symbol='CTPS1', Aliases='CTPS, IMD24', description='CTP synthase 1', other_designations="CTP synthetase 1|UTP--ammonia ligase 1|cytidine 5'-triphosphate synthetase|cytidine 5-prime triphosphate synthetase", map_location='1p34.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=40979299, end_position_on_the_genomic_accession=41012565, orientation='plus', exon_count=23, OMIM=123860, no_hdr0=''),
  1504 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1504, CurrentID=0, Status='live', Symbol='CTRB1', Aliases='CTRB', description='chymotrypsinogen B1', other_designations='', map_location='16q23.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=75218986, end_position_on_the_genomic_accession=75224924, orientation='plus', exon_count=7, OMIM=118890, no_hdr0=''),
  1506 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1506, CurrentID=0, Status='live', Symbol='CTRL', Aliases='CTRL1', description='chymotrypsin-like', other_designations='', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=67929570, end_position_on_the_genomic_accession=67931875, orientation='minus', exon_count=7, OMIM=118888, no_hdr0=''),
  164091 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=164091, CurrentID=0, Status='live', Symbol='PAQR7', Aliases='MPRA, PGLP, mSR', description='progestin and adipoQ receptor family member VII', other_designations='2310021M12Rik|mPR alpha|progestin and adipoQ receptor family member 7', map_location='1p36.11', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=25861484, end_position_on_the_genomic_accession=25876707, orientation='minus', exon_count=5, OMIM=607779, no_hdr0=''),
  1508 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1508, CurrentID=0, Status='live', Symbol='CTSB', Aliases='APPS, CPSB', description='cathepsin B', other_designations='APP secretase|amyloid precursor protein secretase|cathepsin B1|cysteine protease', map_location='8p22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=11842524, end_position_on_the_genomic_accession=11868137, orientation='minus', exon_count=15, OMIM=116810, no_hdr0=''),
  1509 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1509, CurrentID=0, Status='live', Symbol='CTSD', Aliases='CLN10, CPSD, HEL-S-130P', description='cathepsin D', other_designations='ceroid-lipofuscinosis, neuronal 10|epididymis secretory sperm binding protein Li 130P|lysosomal aspartyl peptidase|lysosomal aspartyl protease', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=1752752, end_position_on_the_genomic_accession=1763992, orientation='minus', exon_count=9, OMIM=116840, no_hdr0=''),
  1510 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1510, CurrentID=0, Status='live', Symbol='CTSE', Aliases='CATE', description='cathepsin E', other_designations='erythrocyte membrane aspartic proteinase|slow-moving proteinase', map_location='1q31', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=206009264, end_position_on_the_genomic_accession=206023909, orientation='minus', exon_count=9, OMIM=116890, no_hdr0=''),
  1511 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1511, CurrentID=0, Status='live', Symbol='CTSG', Aliases='CATG, CG', description='cathepsin G', other_designations='', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=24573518, end_position_on_the_genomic_accession=24576260, orientation='minus', exon_count=5, OMIM=116830, no_hdr0=''),
  1512 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1512, CurrentID=0, Status='live', Symbol='CTSH', Aliases='ACC-4, ACC-5, ACC4, ACC5, CPSB', description='cathepsin H', other_designations='N-benzoylarginine-beta-naphthylamide hydrolase|aleurain|cathepsin B3|cathepsin BA', map_location='15q25.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78921750, end_position_on_the_genomic_accession=78945089, orientation='minus', exon_count=13, OMIM=116820, no_hdr0=''),
  1513 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1513, CurrentID=0, Status='live', Symbol='CTSK', Aliases='CTS02, CTSO, CTSO1, CTSO2, PKND, PYCD', description='cathepsin K', other_designations='cathepsin O|cathepsin O1|cathepsin O2|cathepsin X', map_location='1q21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150796208, end_position_on_the_genomic_accession=150808441, orientation='minus', exon_count=8, OMIM=601105, no_hdr0=''),
  1514 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1514, CurrentID=0, Status='live', Symbol='CTSL', Aliases='CATL1, MEP, CTSL', description='cathepsin L', other_designations='major excreted protein', map_location='9q21.33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=87725519, end_position_on_the_genomic_accession=87731469, orientation='plus', exon_count=9, OMIM=116880, no_hdr0=''),
  1515 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1515, CurrentID=0, Status='live', Symbol='CTSV', Aliases='CATL2, CTSL2, CTSU', description='cathepsin V', other_designations='cathepsin L2, preproprotein|cathepsin U', map_location='9q22.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=97029677, end_position_on_the_genomic_accession=97039643, orientation='minus', exon_count=9, OMIM=603308, no_hdr0=''),
  64427 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=64427, CurrentID=0, Status='live', Symbol='TTC31', Aliases='', description='tetratricopeptide repeat domain 31', other_designations='TPR repeat protein 31', map_location='2p13.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=74483032, end_position_on_the_genomic_accession=74494564, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  55698 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=55698, CurrentID=0, Status='live', Symbol='RADIL', Aliases='RASIP2', description='Ras association and DIL domains', other_designations='Rap GTPase interactor', map_location='7p22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=4799109, end_position_on_the_genomic_accession=4883704, orientation='minus', exon_count=15, OMIM=611491, no_hdr0=''),
  1519 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1519, CurrentID=0, Status='live', Symbol='CTSO', Aliases='CTSO1', description='cathepsin O', other_designations='', map_location='4q32.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=155924118, end_position_on_the_genomic_accession=155953896, orientation='minus', exon_count=8, OMIM=600550, no_hdr0=''),
  1520 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1520, CurrentID=0, Status='live', Symbol='CTSS', Aliases='', description='cathepsin S', other_designations='', map_location='1q21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150730196, end_position_on_the_genomic_accession=150765957, orientation='minus', exon_count=8, OMIM=116845, no_hdr0=''),
  1521 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1521, CurrentID=0, Status='live', Symbol='CTSW', Aliases='LYPN', description='cathepsin W', other_designations='lymphopain', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65879813, end_position_on_the_genomic_accession=65883741, orientation='plus', exon_count=10, OMIM=602364, no_hdr0=''),
  1522 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1522, CurrentID=0, Status='live', Symbol='CTSZ', Aliases='CTSX', description='cathepsin Z', other_designations='carboxypeptidase LB|cathepsin B2|cathepsin IV|cathepsin P|cathepsin X|cathepsin Y|cathepsin Z1|cysteine-type carboxypeptidase|lysosomal carboxypeptidase B|preprocathepsin P', map_location='20q13.32', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=58995187, end_position_on_the_genomic_accession=59007254, orientation='minus', exon_count=6, OMIM=603169, no_hdr0=''),
  1523 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1523, CurrentID=0, Status='live', Symbol='CUX1', Aliases='CASP, CDP, CDP/Cut, CDP1, COY1, CUTL1, CUX, Clox, Cux/CDP, GOLIM6, Nbla10317, p100, p110, p200, p75', description='cut-like homeobox 1', other_designations='CCAAT displacement protein|cut homolog|golgi integral membrane protein 6|homeobox protein cux-1|putative protein product of Nbla10317', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=101815904, end_position_on_the_genomic_accession=102283958, orientation='plus', exon_count=34, OMIM=116896, no_hdr0=''),
  1524 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1524, CurrentID=0, Status='live', Symbol='CX3CR1', Aliases='CCRL1, CMKBRL1, CMKDR1, GPR13, GPRV28, V28', description='chemokine (C-X3-C motif) receptor 1', other_designations='C-X3-C CKR-1|CMK-BRL-1|CMK-BRL1|G protein-coupled receptor 13|G-protein coupled receptor 13|beta chemokine receptor-like 1|chemokine (C-C) receptor-like 1|chemokine (C-X3-C) receptor 1|fractalkine receptor', map_location='3p21.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=39263494, end_position_on_the_genomic_accession=39281735, orientation='minus', exon_count=5, OMIM=601470, no_hdr0=''),
  1525 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1525, CurrentID=0, Status='live', Symbol='CXADR', Aliases='CAR, CAR4/6, HCAR', description='coxsackie virus and adenovirus receptor', other_designations='46 kD coxsackievirus and adenovirus receptor (CAR) protein|CVB3-binding protein|HCVADR|coxsackievirus B-adenovirus receptor', map_location='21q21.1', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=17512906, end_position_on_the_genomic_accession=17633323, orientation='plus', exon_count=10, OMIM=602621, no_hdr0=''),
  1527 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1527, CurrentID=0, Status='live', Symbol='TEX28', Aliases='CXorf2, MRX99P1, TEX28P2, fTEX, TEX28', description='testis expressed 28', other_designations='', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154271265, end_position_on_the_genomic_accession=154295351, orientation='minus', exon_count=9, OMIM=300092, no_hdr0=''),
  1528 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1528, CurrentID=0, Status='live', Symbol='CYB5A', Aliases='CYB5, MCB5', description='cytochrome b5 type A (microsomal)', other_designations='type 1 cyt-b5', map_location='18q23', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=74253292, end_position_on_the_genomic_accession=74292016, orientation='minus', exon_count=6, OMIM=613218, no_hdr0=''),
  105372811 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105372811, CurrentID=0, Status='live', Symbol='LOC105372811', Aliases='', description='uncharacterized LOC105372811', other_designations='', map_location='', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=26395033, end_position_on_the_genomic_accession=26413109, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  100861437 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100861437, CurrentID=0, Status='live', Symbol='NARR', Aliases='', description='nine-amino acid residue-repeats', other_designations='nine amino-acid residue-repeats', map_location='17q', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=28715993, end_position_on_the_genomic_accession=28717890, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  1534 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1534, CurrentID=0, Status='live', Symbol='CYB561', Aliases='CYB561A1, FRRS2', description='cytochrome b561', other_designations='cytochrome b-561|cytochrome b561 family, member A1|ferric-chelate reductase 2', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63432304, end_position_on_the_genomic_accession=63446361, orientation='minus', exon_count=8, OMIM=600019, no_hdr0=''),
  1535 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1535, CurrentID=0, Status='live', Symbol='CYBA', Aliases='p22-PHOX', description='cytochrome b-245, alpha polypeptide', other_designations='cytochrome b light chain|cytochrome b(558) alpha chain|cytochrome b(558) alpha-subunit|cytochrome b, alpha polypeptide|cytochrome b558 subunit alpha|flavocytochrome b-558 alpha polypeptide|neutrophil cytochrome b 22 kDa polypeptide|p22 phagocyte B-cytochrome|p22phox|superoxide-generating NADPH oxidase light chain subunit', map_location='16q24', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=88643289, end_position_on_the_genomic_accession=88651085, orientation='minus', exon_count=7, OMIM=608508, no_hdr0=''),
  1536 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1536, CurrentID=0, Status='live', Symbol='CYBB', Aliases='AMCBX2, CGD, GP91-1, GP91-PHOX, GP91PHOX, IMD34, NOX2, p91-PHOX', description='cytochrome b-245, beta polypeptide', other_designations='CGD91-phox|NADPH oxidase 2|cytochrome b(558) subunit beta|cytochrome b-245 beta polypeptide|cytochrome b558 subunit beta|heme-binding membrane glycoprotein gp91phox|neutrophil cytochrome b 91 kDa polypeptide|p22 phagocyte B-cytochrome|superoxide-generating NADPH oxidase heavy chain subunit', map_location='Xp21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=37780017, end_position_on_the_genomic_accession=37813465, orientation='plus', exon_count=14, OMIM=300481, no_hdr0=''),
  1537 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1537, CurrentID=0, Status='live', Symbol='CYC1', Aliases='MC3DN6, UQCR4', description='cytochrome c1', other_designations='complex III subunit 4|complex III subunit IV|cytochrome b-c1 complex subunit 4|cytochrome c-1|ubiquinol-cytochrome-c reductase complex cytochrome c1 subunit', map_location='8q24.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=144095035, end_position_on_the_genomic_accession=144097527, orientation='plus', exon_count=7, OMIM=123980, no_hdr0=''),
  1538 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1538, CurrentID=0, Status='live', Symbol='CYLC1', Aliases='CYCL1', description='cylicin, basic protein of sperm head cytoskeleton 1', other_designations='cylicin I|multiple-band polypeptide I', map_location='Xq21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=83861126, end_position_on_the_genomic_accession=83886700, orientation='plus', exon_count=5, OMIM=300768, no_hdr0=''),
  1539 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1539, CurrentID=0, Status='live', Symbol='CYLC2', Aliases='', description='cylicin, basic protein of sperm head cytoskeleton 2', other_designations='cylicin II|multiple-band polypeptide II', map_location='9q31.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=102995311, end_position_on_the_genomic_accession=103018488, orientation='plus', exon_count=8, OMIM=604035, no_hdr0=''),
  1540 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1540, CurrentID=0, Status='live', Symbol='CYLD', Aliases='BRSS, CDMT1, CYLDI, EAC, MFT, MFT1, SBS, TEM, USPL2, CYLD', description='CYLD lysine 63 deubiquitinase', other_designations='cylindromatosis (turban tumor syndrome)|deubiquitinating enzyme CYLD|probable ubiquitin carboxyl-terminal hydrolase CYLD|ubiquitin specific peptidase like 2|ubiquitin thioesterase CYLD|ubiquitin thiolesterase CYLD|ubiquitin-specific-processing protease CYLD', map_location='16q12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=50742050, end_position_on_the_genomic_accession=50801936, orientation='plus', exon_count=21, OMIM=605018, no_hdr0=''),
  120406 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=120406, CurrentID=0, Status='live', Symbol='NXPE2', Aliases='FAM55B', description='neurexophilin and PC-esterase domain family member 2', other_designations='family with sequence similarity 55, member B|neurexophilin and PC-esterase domain family, member 2|protein FAM55B', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=114648490, end_position_on_the_genomic_accession=114707117, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  1543 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1543, CurrentID=0, Status='live', Symbol='CYP1A1', Aliases='AHH, AHRR, CP11, CYP1, CYPIA1, P1-450, P450-C, P450DX', description='cytochrome P450 family 1 subfamily A member 1', other_designations='aryl hydrocarbon hydroxylase|cytochrome P1-450, dioxin-inducible|cytochrome P450 form 6|cytochrome P450, family 1, subfamily A, polypeptide 1|cytochrome P450, subfamily I (aromatic compound-inducible), polypeptide 1|cytochrome P450-C|cytochrome P450-P1|flavoprotein-linked monooxygenase|xenobiotic monooxygenase', map_location='15q24.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74719542, end_position_on_the_genomic_accession=74725610, orientation='minus', exon_count=7, OMIM=108330, no_hdr0=''),
  1544 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1544, CurrentID=0, Status='live', Symbol='CYP1A2', Aliases='CP12, P3-450, P450(PA)', description='cytochrome P450 family 1 subfamily A member 2', other_designations='CYPIA2|P450 form 4|aryl hydrocarbon hydroxylase|cholesterol 25-hydroxylase|cytochrome P(3)450|cytochrome P450 4|cytochrome P450, family 1, subfamily A, polypeptide 2|cytochrome P450, subfamily I (aromatic compound-inducible), polypeptide 2|cytochrome P450-P3|dioxin-inducible P3-450|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='15q24.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74748843, end_position_on_the_genomic_accession=74756600, orientation='plus', exon_count=7, OMIM=124060, no_hdr0=''),
  1545 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1545, CurrentID=0, Status='live', Symbol='CYP1B1', Aliases='CP1B, CYPIB1, GLC3A, P4501B1', description='cytochrome P450 family 1 subfamily B member 1', other_designations='aryl hydrocarbon hydroxylase|cytochrome P450, family 1, subfamily B, polypeptide 1|cytochrome P450, subfamily I (dioxin-inducible), polypeptide 1 (glaucoma 3, primary infantile)|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='2p22.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=38067603, end_position_on_the_genomic_accession=38076181, orientation='minus', exon_count=3, OMIM=601771, no_hdr0=''),
  1548 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1548, CurrentID=0, Status='live', Symbol='CYP2A6', Aliases='CPA6, CYP2A, CYP2A3, CYPIIA6, P450C2A, P450PB', description='cytochrome P450 family 2 subfamily A member 6', other_designations='1,4-cineole 2-exo-monooxygenase|coumarin 7-hydroxylase|cytochrome P450 IIA3|cytochrome P450(I)|cytochrome P450, family 2, subfamily A, polypeptide 6|cytochrome P450, subfamily IIA (phenobarbital-inducible), polypeptide 6|flavoprotein-linked monooxygenase|xenobiotic monooxygenase', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40843538, end_position_on_the_genomic_accession=40850447, orientation='minus', exon_count=9, OMIM=122720, no_hdr0=''),
  1549 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1549, CurrentID=0, Status='live', Symbol='CYP2A7', Aliases='CPA7, CPAD, CYP2A, CYPIIA7, P450-IIA4', description='cytochrome P450 family 2 subfamily A member 7', other_designations='cytochrome P450 IIA4|cytochrome P450, family 2, subfamily A, polypeptide 7|cytochrome P450, subfamily IIA (phenobarbital-inducible), polypeptide 7|cytochrome P450IIA4', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40875439, end_position_on_the_genomic_accession=40882752, orientation='minus', exon_count=9, OMIM=608054, no_hdr0=''),
  1551 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1551, CurrentID=0, Status='live', Symbol='CYP3A7', Aliases='CP37, CYPIIIA7, P-450(HFL33), P-450111A7, P450-HFLA', description='cytochrome P450 family 3 subfamily A member 7', other_designations='aryl hydrocarbon hydroxylase|cytochrome P450, family 3, subfamily A, polypeptide 7|cytochrome P450, subfamily IIIA, polypeptide 7|cytochrome P450-HFLA|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=99705037, end_position_on_the_genomic_accession=99735200, orientation='minus', exon_count=13, OMIM=605340, no_hdr0=''),
  1553 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1553, CurrentID=0, Status='live', Symbol='CYP2A13', Aliases='CPAD, CYP2A, CYPIIA13', description='cytochrome P450 family 2 subfamily A member 13', other_designations='cytochrome P450, family 2, subfamily A, polypeptide 13|cytochrome P450, subfamily IIA (phenobarbital-inducible), polypeptide 13', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41088451, end_position_on_the_genomic_accession=41096195, orientation='plus', exon_count=9, OMIM=608055, no_hdr0=''),
  1555 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1555, CurrentID=0, Status='live', Symbol='CYP2B6', Aliases='CPB6, CYP2B, CYP2B7, CYP2B7P, CYPIIB6, EFVM, IIB1, P450', description='cytochrome P450 family 2 subfamily B member 6', other_designations='1,4-cineole 2-exo-monooxygenase|cytochrome P450 IIB1|cytochrome P450, family 2, subfamily B, polypeptide 6|cytochrome P450, subfamily IIB (phenobarbital-inducible), polypeptide 6', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40991229, end_position_on_the_genomic_accession=41018398, orientation='plus', exon_count=11, OMIM=123930, no_hdr0=''),
  1557 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1557, CurrentID=0, Status='live', Symbol='CYP2C19', Aliases='CPCJ, CYP2C, CYPIIC17, CYPIIC19, P450C2C, P450IIC19', description='cytochrome P450 family 2 subfamily C member 19', other_designations="(R)-limonene 6-monooxygenase|(S)-limonene 6-monooxygenase|(S)-limonene 7-monooxygenase|S-mephenytoin 4-hydroxylase|cytochrome P-450 II C|cytochrome P450, family 2, subfamily C, polypeptide 19|cytochrome P450, subfamily IIC (mephenytoin 4-hydroxylase), polypeptide 19|cytochrome P450-11A|cytochrome P450-254C|flavoprotein-linked monooxygenase|mephenytoin 4'-hydroxylase|mephenytoin 4-hydroxylase|microsomal monooxygenase|xenobiotic monooxygenase", map_location='10q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=94762681, end_position_on_the_genomic_accession=94853205, orientation='plus', exon_count=9, OMIM=124020, no_hdr0=''),
  1558 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1558, CurrentID=0, Status='live', Symbol='CYP2C8', Aliases='CPC8, CYPIIC8, MP-12/MP-20', description='cytochrome P450 family 2 subfamily C member 8', other_designations='P450 form 1|cytochrome P450 IIC2|cytochrome P450 MP-12|cytochrome P450 MP-20|cytochrome P450 form 1|cytochrome P450, family 2, subfamily C, polypeptide 8|cytochrome P450, subfamily IIC (mephenytoin 4-hydroxylase), polypeptide 8|flavoprotein-linked monooxygenase|microsomal monooxygenase|s-mephenytoin 4-hydroxylase|xenobiotic monooxygenase', map_location='10q23.33', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=95036772, end_position_on_the_genomic_accession=95069498, orientation='minus', exon_count=11, OMIM=601129, no_hdr0=''),
  1559 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1559, CurrentID=0, Status='live', Symbol='CYP2C9', Aliases='CPC9, CYP2C, CYP2C10, CYPIIC9, P450IIC9', description='cytochrome P450 family 2 subfamily C member 9', other_designations='cholesterol 25-hydroxylase|cytochrome P-450 S-mephenytoin 4-hydroxylase|cytochrome P-450MP|cytochrome P450 PB-1|cytochrome P450, family 2, subfamily C, polypeptide 9|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='10q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=94938658, end_position_on_the_genomic_accession=94989391, orientation='plus', exon_count=9, OMIM=601130, no_hdr0=''),
  105373237 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105373237, CurrentID=0, Status='live', Symbol='LOC105373237', Aliases='', description='uncharacterized LOC105373237', other_designations='', map_location='', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=64205970, end_position_on_the_genomic_accession=64308111, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  1562 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1562, CurrentID=0, Status='live', Symbol='CYP2C18', Aliases='CPCI, CYP2C, CYP2C17, P450-6B/29C, P450IIC17', description='cytochrome P450 family 2 subfamily C member 18', other_designations='(S)-mephenytoin hydroxylase associated cytochrome P450|CYPIIC18|cytochrome P450, family 2, subfamily C, polypeptide 18|cytochrome P450, subfamily IIC (mephenytoin 4-hydroxylase), polypeptide 17|cytochrome P450, subfamily IIC (mephenytoin 4-hydroxylase), polypeptide 18|cytochrome P450-6B/29C|flavoprotein-linked monooxygenase|microsomal monooxygenase|unspecific monooxygenase', map_location='10q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=94683494, end_position_on_the_genomic_accession=94736190, orientation='plus', exon_count=9, OMIM=601131, no_hdr0=''),
  1565 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1565, CurrentID=0, Status='live', Symbol='CYP2D6', Aliases='CPD6, CYP2D, CYP2D7AP, CYP2D7BP, CYP2D7P2, CYP2D8P2, CYP2DL1, CYPIID6, P450-DB1, P450C2D, P450DB1', description='cytochrome P450 family 2 subfamily D member 6', other_designations='cholesterol 25-hydroxylase|cytochrome P450, family 2, subfamily D, polypeptide 6|cytochrome P450, family 2, subfamily D, polypeptide 7 pseudogene 2|cytochrome P450, family 2, subfamily D, polypeptide 8 pseudogene 2|cytochrome P450, subfamily II (debrisoquine, sparteine, etc., -metabolising), polypeptide 7 pseudogene 2|cytochrome P450, subfamily IID (debrisoquine, sparteine, etc., -metabolising), polypeptide 8 pseudogene 2|cytochrome P450, subfamily IID (debrisoquine, sparteine, etc., -metabolizing), polypeptide 6|cytochrome P450, subfamily IID (debrisoquine, sparteine, etc., -metabolizing)-like 1|cytochrome P450-DB1|debrisoquine 4-hydroxylase|flavoprotein-linked monooxygenase|microsomal monooxygenase|nonfunctional cytochrome P450 2D6|xenobiotic monooxygenase', map_location='22q13.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=42125656, end_position_on_the_genomic_accession=42135378, orientation='minus', exon_count=12, OMIM=124030, no_hdr0=''),
  100130433 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100130433, CurrentID=0, Status='live', Symbol='LOC100130433', Aliases='', description='uncharacterized LOC100130433', other_designations='', map_location='9q21.33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.10', start_position_on_the_genomic_accession=87990841, end_position_on_the_genomic_accession=87991566, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  728927 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=728927, CurrentID=0, Status='live', Symbol='ZNF736', Aliases='', description='zinc finger protein 736', other_designations='KRAB-containing zinc-finger repressor protein', map_location='7q11.21', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=64313873, end_position_on_the_genomic_accession=64356634, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  1571 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1571, CurrentID=0, Status='live', Symbol='CYP2E1', Aliases='CPE1, CYP2E, P450-J, P450C2E', description='cytochrome P450 family 2 subfamily E member 1', other_designations='4-nitrophenol 2-hydroxylase|CYPIIE1|cytochrome P450, family 2, subfamily E, polypeptide 1|cytochrome P450, subfamily IIE (ethanol-inducible), polypeptide 1|cytochrome P450-J|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='10q26.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=133527363, end_position_on_the_genomic_accession=133539116, orientation='plus', exon_count=9, OMIM=124040, no_hdr0=''),
  1572 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1572, CurrentID=0, Status='live', Symbol='CYP2F1', Aliases='C2F1, CYP2F', description='cytochrome P450 family 2 subfamily F member 1', other_designations='CYPIIF1|cytochrome P450, family 2, subfamily F, polypeptide 1|cytochrome P450, subfamily IIF, polypeptide 1|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41114292, end_position_on_the_genomic_accession=41128381, orientation='plus', exon_count=11, OMIM=124070, no_hdr0=''),
  1573 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1573, CurrentID=0, Status='live', Symbol='CYP2J2', Aliases='CPJ2, CYPIIJ2', description='cytochrome P450 family 2 subfamily J member 2', other_designations='arachidonic acid epoxygenase|cytochrome P450, family 2, subfamily J, polypeptide 2|cytochrome P450, subfamily IIJ (arachidonic acid epoxygenase) polypeptide 2|flavoprotein-linked monooxygenase|microsomal monooxygenase', map_location='1p31.3-p31.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=59893308, end_position_on_the_genomic_accession=59926773, orientation='minus', exon_count=10, OMIM=601258, no_hdr0=''),
  84245 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=84245, CurrentID=0, Status='live', Symbol='MRI1', Aliases='MRDI, MTNA, Ypr118w', description='methylthioribose-1-phosphate isomerase 1', other_designations='M1Pi|MTR-1-P isomerase|S-methyl-5-thioribose-1-phosphate isomerase 1|mediator of RhoA-dependent invasion|methylthioribose-1-phosphate isomerase homolog|translation initiation factor eIF-2B subunit alpha/beta/delta-like protein', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=13764492, end_position_on_the_genomic_accession=13774282, orientation='plus', exon_count=7, OMIM=615105, no_hdr0=''),
  1576 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1576, CurrentID=0, Status='live', Symbol='CYP3A4', Aliases='CP33, CP34, CYP3A, CYP3A3, CYPIIIA3, CYPIIIA4, HLP, NF-25, P450C3, P450PCN1', description='cytochrome P450 family 3 subfamily A member 4', other_designations='1,8-cineole 2-exo-monooxygenase|P450-III, steroid inducible|albendazole monooxygenase|albendazole sulfoxidase|cholesterol 25-hydroxylase|cytochrome P450 3A3|cytochrome P450 HLp|cytochrome P450 NF-25|cytochrome P450, family 3, subfamily A, polypeptide 4|cytochrome P450, subfamily IIIA (niphedipine oxidase), polypeptide 3|cytochrome P450, subfamily IIIA (niphedipine oxidase), polypeptide 4|cytochrome P450-PCN1|glucocorticoid-inducible P450|nifedipine oxidase|quinine 3-monooxygenase|taurochenodeoxycholate 6-alpha-hydroxylase', map_location='7q21.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=99756960, end_position_on_the_genomic_accession=99784188, orientation='minus', exon_count=14, OMIM=124010, no_hdr0=''),
  1577 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1577, CurrentID=0, Status='live', Symbol='CYP3A5', Aliases='CP35, CYPIIIA5, P450PCN3, PCN3', description='cytochrome P450 family 3 subfamily A member 5', other_designations='aryl hydrocarbon hydroxylase|cytochrome P450 HLp2|cytochrome P450, family 3, subfamily A, polypeptide 5|cytochrome P450, subfamily IIIA (niphedipine oxidase), polypeptide 5|cytochrome P450-PCN3|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='7q21.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=99648189, end_position_on_the_genomic_accession=99680026, orientation='minus', exon_count=18, OMIM=605325, no_hdr0=''),
  1579 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1579, CurrentID=0, Status='live', Symbol='CYP4A11', Aliases='CP4Y, CYP4A2, CYP4AII', description='cytochrome P450 family 4 subfamily A member 11', other_designations='20-HETE synthase|20-hydroxyeicosatetraenoic acid synthase|CYPIVA11|P450HL-omega|alkane-1 monooxygenase|cytochrome P-450HK-omega|cytochrome P450, family 4, subfamily A, polypeptide 11|cytochrome P450, subfamily IVA, polypeptide 11|cytochrome P450HL-omega|fatty acid omega-hydroxylase|lauric acid omega-hydroxylase|long-chain fatty acid omega-monooxygenase', map_location='1p33', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=46929174, end_position_on_the_genomic_accession=46941499, orientation='minus', exon_count=13, OMIM=601310, no_hdr0=''),
  1580 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1580, CurrentID=0, Status='live', Symbol='CYP4B1', Aliases='CYPIVB1, P-450HP', description='cytochrome P450 family 4 subfamily B member 1', other_designations='cytochrome P450, family 4, subfamily B, polypeptide 1|cytochrome P450, subfamily IVB, polypeptide 1|cytochrome P450-HP|microsomal monooxygenase', map_location='1p33', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=46798995, end_position_on_the_genomic_accession=46819349, orientation='plus', exon_count=12, OMIM=124075, no_hdr0=''),
  1581 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1581, CurrentID=0, Status='live', Symbol='CYP7A1', Aliases='CP7A, CYP7, CYPVII', description='cytochrome P450 family 7 subfamily A member 1', other_designations='cholesterol 7-alpha-hydroxylase|cytochrome P450 7A1|cytochrome P450, family 7, subfamily A, polypeptide 1|cytochrome P450, subfamily VIIA polypeptide 1', map_location='8q11-q12', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=58490178, end_position_on_the_genomic_accession=58500959, orientation='minus', exon_count=7, OMIM=118455, no_hdr0=''),
  1582 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1582, CurrentID=0, Status='live', Symbol='CYP8B1', Aliases='CP8B, CYP12', description='cytochrome P450 family 8 subfamily B member 1', other_designations='7 alpha-hydroxy-4-cholesten-3-one 12-alpha-hydroxylase|7-alpha-hydroxy-4-cholesten-3-one 12-alpha-hydroxylase|CYPVIIIB1|cytochrome P450 8B1|cytochrome P450, family 8, subfamily B, polypeptide 1|cytochrome P450, subfamily VIIIB (sterol 12-alpha-hydroxylase), polypeptide 1|sterol 12-alpha-hydroxylase', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=42872192, end_position_on_the_genomic_accession=42876141, orientation='minus', exon_count=1, OMIM=602172, no_hdr0=''),
  1583 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1583, CurrentID=0, Status='live', Symbol='CYP11A1', Aliases='CYP11A, CYPXIA1, P450SCC', description='cytochrome P450 family 11 subfamily A member 1', other_designations='cholesterol 20-22 desmolase|cholesterol monooxygenase (side-chain cleaving)|cytochrome P450 11A1|cytochrome P450 family 11 subfamily A polypeptide 1|cytochrome P450(scc)|cytochrome P450, family 11, subfamily A, polypeptide 1|cytochrome P450, subfamily XIA (cholesterol side chain cleavage)|cytochrome P450C11A1|steroid 20-22-lyase', map_location='15q23-q24', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74337762, end_position_on_the_genomic_accession=74367740, orientation='minus', exon_count=10, OMIM=118485, no_hdr0=''),
  1584 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1584, CurrentID=0, Status='live', Symbol='CYP11B1', Aliases='CPN1, CYP11B, FHI, P450C11', description='cytochrome P450 family 11 subfamily B member 1', other_designations='CYPXIB1|cytochrome P-450c11|cytochrome P450, family 11, subfamily B, polypeptide 1|cytochrome P450, subfamily XIB (steroid 11-beta-hydroxylase), polypeptide 1|cytochrome P450C11|cytochrome p450 XIB1|steroid 11-beta-hydroxylase|steroid 11-beta-monooxygenase', map_location='8q21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=142872354, end_position_on_the_genomic_accession=142879846, orientation='minus', exon_count=11, OMIM=610613, no_hdr0=''),
  1585 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1585, CurrentID=0, Status='live', Symbol='CYP11B2', Aliases='ALDOS, CPN2, CYP11B, CYP11BL, CYPXIB2, P-450C18, P450C18, P450aldo', description='cytochrome P450 family 11 subfamily B member 2', other_designations='aldosterone synthase|aldosterone-synthesizing enzyme|cytochrome P-450Aldo|cytochrome P-450C18|cytochrome P450, family 11, subfamily B, polypeptide 2|cytochrome P450, subfamily XIB (steroid 11-beta-hydroxylase), polypeptide 2|mitochondrial cytochrome P450, family 11, subfamily B, polypeptide 2|steroid 11-beta-monooxygenase|steroid 11-beta/18-hydroxylase|steroid 18-hydroxylase, aldosterone synthase, P450C18, P450aldo', map_location='8q21-q22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=142910558, end_position_on_the_genomic_accession=142917862, orientation='minus', exon_count=10, OMIM=124080, no_hdr0=''),
  1586 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1586, CurrentID=0, Status='live', Symbol='CYP17A1', Aliases='CPT7, CYP17, P450C17, S17AH', description='cytochrome P450 family 17 subfamily A member 1', other_designations='17-alpha-hydroxyprogesterone aldolase|CYPXVII|cytochrome P450 17A1|cytochrome P450, family 17, subfamily A, polypeptide 1|cytochrome P450, subfamily XVII (steroid 17-alpha-hydroxylase), adrenal hyperplasia|cytochrome P450-C17|cytochrome P450c17|cytochrome p450 XVIIA1|steroid 17-alpha-monooxygenase', map_location='10q24.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=102830531, end_position_on_the_genomic_accession=102837533, orientation='minus', exon_count=8, OMIM=609300, no_hdr0=''),
  125875 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=125875, CurrentID=0, Status='live', Symbol='CLDND2', Aliases='', description='claudin domain containing 2', other_designations='', map_location='19q13.41', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=51366957, end_position_on_the_genomic_accession=51369241, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  1588 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1588, CurrentID=0, Status='live', Symbol='CYP19A1', Aliases='ARO, ARO1, CPV1, CYAR, CYP19, CYPXIX, P-450AROM', description='cytochrome P450 family 19 subfamily A member 1', other_designations='cytochrome P-450AROM|cytochrome P450 19A1|cytochrome P450, family 19, subfamily A, polypeptide 1|cytochrome P450, subfamily XIX (aromatization of androgens)|estrogen synthase|estrogen synthetase|flavoprotein-linked monooxygenase|microsomal monooxygenase', map_location='15q21.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=51208057, end_position_on_the_genomic_accession=51338598, orientation='minus', exon_count=13, OMIM=107910, no_hdr0=''),
  1589 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1589, CurrentID=0, Status='live', Symbol='CYP21A2', Aliases='CA21H, CAH1, CPS1, CYP21, CYP21B, P450c21B', description='cytochrome P450 family 21 subfamily A member 2', other_designations='21-OHase|cytochrome P450 XXI|cytochrome P450, family 21, subfamily A, polypeptide 2|cytochrome P450, subfamily XXIA (steroid 21-hydroxylase, congenital adrenal hyperplasia), polypeptide 2|cytochrome P450-C21B|steroid 21 hydroxylase|steroid 21-monooxygenase', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=32038316, end_position_on_the_genomic_accession=32041670, orientation='plus', exon_count=10, OMIM=613815, no_hdr0=''),
  1591 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1591, CurrentID=0, Status='live', Symbol='CYP24A1', Aliases='CP24, CYP24, HCAI, P450-CC24', description='cytochrome P450 family 24 subfamily A member 1', other_designations='1,25-@dihydroxyvitamin D3 24-hydroxylase|24-OHase|cytochrome P450 24A1|cytochrome P450, family 24, subfamily A, polypeptide 1|cytochrome P450, subfamily XXIV (vitamin D 24-hydroxylase)|cytochrome P450-CC24|exo-mitochondrial protein|vitamin D 24-hydroxylase|vitamin D(3) 24-hydroxylase', map_location='20q13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=54153449, end_position_on_the_genomic_accession=54173985, orientation='minus', exon_count=12, OMIM=126065, no_hdr0=''),
  1592 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1592, CurrentID=0, Status='live', Symbol='CYP26A1', Aliases='CP26, CYP26, P450RAI, P450RAI1', description='cytochrome P450 family 26 subfamily A member 1', other_designations='P450, retinoic acid-inactivating, 1|cytochrome P450 retinoic acid-inactivating 1|cytochrome P450, family 26, subfamily A, polypeptide 1|cytochrome P450, subfamily XXVIA, polypeptide 1|cytochrome P450RAI|hP450RAI|retinoic acid 4-hydroxylase|retinoic acid-metabolizing cytochrome', map_location='10q23-q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=93073475, end_position_on_the_genomic_accession=93077884, orientation='plus', exon_count=8, OMIM=602239, no_hdr0=''),
  1593 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1593, CurrentID=0, Status='live', Symbol='CYP27A1', Aliases='CP27, CTX, CYP27', description='cytochrome P450 family 27 subfamily A member 1', other_designations='5-beta-cholestane-3-alpha, 7-alpha, 12-alpha-triol 26-hydroxylase|5-beta-cholestane-3-alpha, 7-alpha, 12-alpha-triol 27-hydroxylase|5-beta-cholestane-3-alpha,7-alpha,12-alpha-triol 27-hydroxylase|cholestanetriol 26-monooxygenase|cytochrome P-450C27/25|cytochrome P450 27|cytochrome P450, family 27, subfamily A, polypeptide 1|cytochrome P450, subfamily XXVIIA (steroid 27-hydroxylase, cerebrotendinous xanthomatosis), polypeptide 1|sterol 27-hydroxylase|vitamin D(3) 25-hydroxylase', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=218781749, end_position_on_the_genomic_accession=218815293, orientation='plus', exon_count=9, OMIM=606530, no_hdr0=''),
  1594 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1594, CurrentID=0, Status='live', Symbol='CYP27B1', Aliases='CP2B, CYP1, CYP1alpha, CYP27B, P450c1, PDDR, VDD1, VDDR, VDDRI, VDR', description='cytochrome P450 family 27 subfamily B member 1', other_designations='1alpha(OH)ase|25 hydroxyvitamin D3-1-alpha hydroxylase|25-OHD-1 alpha-hydroxylase|VD3 1A hydroxylase|calcidiol 1-monooxygenase|cytochrome P450 subfamily XXVIIB polypeptide 1|cytochrome P450, family 27, subfamily B, polypeptide 1|cytochrome P450C1 alpha|cytochrome P450VD1-alpha|cytochrome p450 27B1', map_location='12q14.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=57762334, end_position_on_the_genomic_accession=57767193, orientation='minus', exon_count=9, OMIM=609506, no_hdr0=''),
  1595 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1595, CurrentID=0, Status='live', Symbol='CYP51A1', Aliases='CP51, CYP51, CYPL1, LDM, P450-14DM, P450L1', description='cytochrome P450 family 51 subfamily A member 1', other_designations='CYPLI|cytochrome P450 51A1|cytochrome P450, 51 (lanosterol 14-alpha-demethylase)|cytochrome P450, family 51, subfamily A, polypeptide 1|cytochrome P450-14DM|cytochrome P45014DM|cytochrome P450LI|lanosterol 14-alpha-demethylase|sterol 14-alpha demethylase', map_location='7q21.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=92112149, end_position_on_the_genomic_accession=92134745, orientation='minus', exon_count=11, OMIM=601637, no_hdr0=''),
  11189 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=11189, CurrentID=0, Status='live', Symbol='CELF3', Aliases='BRUNOL1, CAGH4, ERDA4, ETR-1, TNRC4', description='CUGBP, Elav-like family member 3', other_designations='CAG repeat domain|CAG repeat protein 4|CUG-BP and ETR-3 like factor 3|CUG-BP- and ETR-3-like factor 3|ELAV-type RNA-binding protein 1|RNA-binding protein BRUNOL-1|bruno-like protein 1|expanded repeat domain protein CAG/CTG 4|expanded repeat domain, CAG/CTG 4|trinucleotide repeat containing 4|trinucleotide repeat-containing gene 4 protein', map_location='1q21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=151700052, end_position_on_the_genomic_accession=151716821, orientation='minus', exon_count=16, OMIM=612678, no_hdr0=''),
  1600 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1600, CurrentID=0, Status='live', Symbol='DAB1', Aliases='', description='Dab, reelin signal transducer, homolog 1 (Drosophila)', other_designations='Dab reelin signal transducer 1', map_location='1p32-p31', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=56997906, end_position_on_the_genomic_accession=58250539, orientation='minus', exon_count=17, OMIM=603448, no_hdr0=''),
  1601 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1601, CurrentID=0, Status='live', Symbol='DAB2', Aliases='DOC-2, DOC2', description='Dab, mitogen-responsive phosphoprotein, homolog 2 (Drosophila)', other_designations='adaptor molecule disabled-2|differentially expressed in ovarian carcinoma 2|differentially-expressed protein 2|disabled homolog 2, mitogen-responsive phosphoprotein', map_location='5p13.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=39371674, end_position_on_the_genomic_accession=39425233, orientation='minus', exon_count=15, OMIM=601236, no_hdr0=''),
  1602 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1602, CurrentID=0, Status='live', Symbol='DACH1', Aliases='DACH', description='dachshund family transcription factor 1', other_designations='dac homolog', map_location='13q22', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=71437966, end_position_on_the_genomic_accession=71869113, orientation='minus', exon_count=15, OMIM=603803, no_hdr0=''),
  1603 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1603, CurrentID=0, Status='live', Symbol='DAD1', Aliases='OST2', description='defender against cell death 1', other_designations='DAD-1|oligosaccharyl transferase subunit DAD1|oligosaccharyltransferase 2 homolog|oligosaccharyltransferase subunit 2 (non-catalytic)', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=22564907, end_position_on_the_genomic_accession=22589237, orientation='minus', exon_count=3, OMIM=600243, no_hdr0=''),
  1604 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1604, CurrentID=0, Status='live', Symbol='CD55', Aliases='CR, CROM, DAF, TC', description='CD55 molecule (Cromer blood group)', other_designations='CD55 antigen|CD55 molecule, decay accelerating factor for complement (Cromer blood group)', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207321472, end_position_on_the_genomic_accession=207360966, orientation='plus', exon_count=14, OMIM=125240, no_hdr0=''),
  1605 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1605, CurrentID=0, Status='live', Symbol='DAG1', Aliases='156DAG, A3a, AGRNR, DAG, MDDGC7, MDDGC9', description='dystroglycan 1', other_designations='dystroglycan 1 (dystrophin-associated glycoprotein 1)', map_location='3p21', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=49468703, end_position_on_the_genomic_accession=49535618, orientation='plus', exon_count=9, OMIM=128239, no_hdr0=''),
  1606 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1606, CurrentID=0, Status='live', Symbol='DGKA', Aliases='DAGK, DAGK1, DGK-alpha', description='diacylglycerol kinase alpha', other_designations='80 kDa diacylglycerol kinase|DAG kinase alpha|diacylglycerol kinase, alpha 80kDa|diglyceride kinase alpha', map_location='12q13.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=55931162, end_position_on_the_genomic_accession=55954027, orientation='plus', exon_count=30, OMIM=125855, no_hdr0=''),
  1607 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1607, CurrentID=0, Status='live', Symbol='DGKB', Aliases='DAGK2, DGK, DGK-BETA', description='diacylglycerol kinase beta', other_designations='90 kDa diacylglycerol kinase|DAG kinase beta|diacylglycerol kinase, beta 90kDa|diglyceride kinase beta', map_location='7p21.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=14145049, end_position_on_the_genomic_accession=14974777, orientation='minus', exon_count=31, OMIM=604070, no_hdr0=''),
  1608 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1608, CurrentID=0, Status='live', Symbol='DGKG', Aliases='DAGK3, DGK-GAMMA', description='diacylglycerol kinase gamma', other_designations='DAG kinase gamma|diacylglycerol kinase, gamma 90kDa|diacylglyerol kinase gamma|diglyceride kinase gamma', map_location='3q27.2-q27.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186147201, end_position_on_the_genomic_accession=186362234, orientation='minus', exon_count=25, OMIM=601854, no_hdr0=''),
  1609 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1609, CurrentID=0, Status='live', Symbol='DGKQ', Aliases='DAGK, DAGK4, DAGK7', description='diacylglycerol kinase theta', other_designations='DAG kinase theta|DGK-theta|diacylglycerol kinase, theta 110kDa|diglyceride kinase theta', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=958884, end_position_on_the_genomic_accession=973560, orientation='minus', exon_count=25, OMIM=601207, no_hdr0=''),
  1610 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1610, CurrentID=0, Status='live', Symbol='DAO', Aliases='DAAO, DAMOX, OXDA', description='D-amino-acid oxidase', other_designations='D-amino acid oxidase', map_location='12q24', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=108880030, end_position_on_the_genomic_accession=108901043, orientation='plus', exon_count=12, OMIM=124050, no_hdr0=''),
  1611 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1611, CurrentID=0, Status='live', Symbol='DAP', Aliases='', description='death-associated protein', other_designations='DAP-1', map_location='5p15.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=10679230, end_position_on_the_genomic_accession=10761275, orientation='minus', exon_count=4, OMIM=600954, no_hdr0=''),
  1612 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1612, CurrentID=0, Status='live', Symbol='DAPK1', Aliases='DAPK', description='death-associated protein kinase 1', other_designations='DAP kinase 1', map_location='9q21.33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=87497228, end_position_on_the_genomic_accession=87708634, orientation='plus', exon_count=29, OMIM=600831, no_hdr0=''),
  1613 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1613, CurrentID=0, Status='live', Symbol='DAPK3', Aliases='DLK, ZIP, ZIPK', description='death-associated protein kinase 3', other_designations='DAP kinase 3|DAP-like kinase|MYPT1 kinase|ZIP-kinase|zipper-interacting protein kinase', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=3958453, end_position_on_the_genomic_accession=3971123, orientation='minus', exon_count=9, OMIM=603289, no_hdr0=''),
  1615 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1615, CurrentID=0, Status='live', Symbol='DARS', Aliases='HBSL, aspRS', description='aspartyl-tRNA synthetase', other_designations='aspartate tRNA ligase 1, cytoplasmic|aspartyl-tRNA synthetase, cytoplasmic|cell proliferation-inducing gene 40 protein', map_location='2q21.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=135905881, end_position_on_the_genomic_accession=135985684, orientation='minus', exon_count=16, OMIM=603084, no_hdr0=''),
  1616 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1616, CurrentID=0, Status='live', Symbol='DAXX', Aliases='BING2, DAP6, EAP1', description='death-domain associated protein', other_designations='CENP-C binding protein|ETS1-associated protein 1|Fas-binding protein|death-associated protein 6|fas death domain-associated protein', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=33318558, end_position_on_the_genomic_accession=33323016, orientation='minus', exon_count=8, OMIM=603186, no_hdr0=''),
  1617 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1617, CurrentID=0, Status='live', Symbol='DAZ1', Aliases='DAZ, SPGY', description='deleted in azoospermia 1', other_designations='', map_location='Yq11.223', chromosome='Y', genomic_nucleotide_accession_version='NC_000024.10', start_position_on_the_genomic_accession=23129355, end_position_on_the_genomic_accession=23199123, orientation='minus', exon_count=28, OMIM=400003, no_hdr0=''),
  1618 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1618, CurrentID=0, Status='live', Symbol='DAZL', Aliases='DAZH1, DAZLA, SPGYLA, DAZL', description='deleted in azoospermia like', other_designations='DAZ homolog|DAZ-like autosomal|SPGY-like-autosomal|deleted in azoospermia-like 1|germline specific RNA binding protein|spermatogenesis gene on the Y-like autosomal', map_location='3p24.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=16586792, end_position_on_the_genomic_accession=16605499, orientation='minus', exon_count=12, OMIM=601486, no_hdr0=''),
  1620 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1620, CurrentID=0, Status='live', Symbol='BRINP1', Aliases='DBC1, DBCCR1, FAM5A', description='bone morphogenetic protein/retinoic acid inducible neural-specific 1', other_designations='bA574M5.1 (deleted in bladder cancer chromosome region candidate 1 (IB3089A))|bone morphogenic protein/retinoic acid inducible neural-specific 1|deleted in bladder cancer 1|deleted in bladder cancer chromosome region candidate 1|deleted in bladder cancer protein 1', map_location='9q32-q33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=119166630, end_position_on_the_genomic_accession=119369461, orientation='minus', exon_count=8, OMIM=602865, no_hdr0=''),
  1621 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1621, CurrentID=0, Status='live', Symbol='DBH', Aliases='DBM', description='dopamine beta-hydroxylase (dopamine beta-monooxygenase)', other_designations='', map_location='9q34', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=133636363, end_position_on_the_genomic_accession=133659344, orientation='plus', exon_count=12, OMIM=609312, no_hdr0=''),
  1622 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1622, CurrentID=0, Status='live', Symbol='DBI', Aliases='ACBD1, ACBP, CCK-RP, EP', description='diazepam binding inhibitor (GABA receptor modulator, acyl-CoA binding protein)', other_designations='GABA receptor modulator|acyl coenzyme A binding protein|acyl-Coenzyme A binding domain containing 1|cholecystokinin-releasing peptide, trypsin-sensitive|diazepam binding inhibitor (GABA receptor modulator, acyl-Coenzyme A binding protein)|diazepam-binding inhibitor|endozepine', map_location='2q12-q21', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=119366924, end_position_on_the_genomic_accession=119372551, orientation='plus', exon_count=7, OMIM=125950, no_hdr0=''),
  54785 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=54785, CurrentID=0, Status='live', Symbol='BORCS6', Aliases='C17orf59, PRO2472', description='BLOC-1 related complex subunit 6', other_designations='lyspersin', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=8188333, end_position_on_the_genomic_accession=8190246, orientation='minus', exon_count=1, OMIM=616599, no_hdr0=''),
  1627 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1627, CurrentID=0, Status='live', Symbol='DBN1', Aliases='D0S117E', description='drebrin 1', other_designations='developmentally-regulated brain protein|drebrin E|drebrin E2|drebrin-1', map_location='5q35.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=177456613, end_position_on_the_genomic_accession=177480336, orientation='minus', exon_count=19, OMIM=126660, no_hdr0=''),
  1628 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1628, CurrentID=0, Status='live', Symbol='DBP', Aliases='DABP', description='D site of albumin promoter (albumin D-box) binding protein', other_designations='albumin D box-binding protein|albumin D-element-binding protein|tax-responsive enhancer element-binding protein 302|taxREB302', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48630560, end_position_on_the_genomic_accession=48637550, orientation='minus', exon_count=4, OMIM=124097, no_hdr0=''),
  1629 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1629, CurrentID=0, Status='live', Symbol='DBT', Aliases='BCATE2, BCKAD-E2, BCKADE2, BCOADC-E2, E2, E2B', description='dihydrolipoamide branched chain transacylase E2', other_designations='52 kDa mitochondrial autoantigen of primary biliary cirrhosis|BCKAD E2 subunit|E2 component of branched chain alpha-keto acid dehydrogenase complex|branched chain 2-oxo-acid dehydrogenase complex component E2|branched chain acyltransferase, E2 component|branched-chain alpha-keto acid dehydrogenase complex component E2|dihydrolipoamide acetyltransferase component of branched-chain alpha-keto acid dehydrogenase complex|dihydrolipoyl transacylase|dihydrolipoyllysine-residue (2-methylpropanoyl)transferase|lipoamide acyltransferase component of mitochondrial branched-chain alpha-keto acid dehydrogenase complex|mitochondrial branched chain alpha-keto acid dehydrogenase transacylase subunit (E2b)', map_location='1p31', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=100186922, end_position_on_the_genomic_accession=100249863, orientation='minus', exon_count=13, OMIM=248610, no_hdr0=''),
  1630 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1630, CurrentID=0, Status='live', Symbol='DCC', Aliases='CRC18, CRCR1, IGDCC1, MRMV1, NTN1R1', description='DCC netrin 1 receptor', other_designations='colorectal cancer suppressor|colorectal tumor suppressor|deleted in colorectal cancer protein|deleted in colorectal carcinoma|immunoglobulin superfamily DCC subclass member 1|immunoglobulin superfamily, DCC subclass, member 1|tumor suppressor protein DCC', map_location='18q21.3', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=52340172, end_position_on_the_genomic_accession=53535903, orientation='plus', exon_count=33, OMIM=120470, no_hdr0=''),
  728929 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=728929, CurrentID=0, Status='live', Symbol='TCEB3CL', Aliases='HsT828, eloA3-like-1', description='transcription elongation factor B polypeptide 3C-like', other_designations='elongin-A3-like-1|transcription elongation factor B polypeptide 3C-like-1', map_location='18q21.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=46968695, end_position_on_the_genomic_accession=46969912, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  1632 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1632, CurrentID=0, Status='live', Symbol='ECI1', Aliases='DCI', description='enoyl-CoA delta isomerase 1', other_designations='3,2 trans-enoyl-CoA isomerase|3,2 trans-enoyl-Coenzyme A isomerase|3,2-trans-enoyl-CoA isomerase, mitochondrial|D3,D2-enoyl-CoA isomerase|acetylene-allene isomerase|delta(3),Delta(2)-enoyl-CoA isomerase|delta3, delta2-enoyl-CoA isomerase|dodecenoyl-CoA delta isomerase (3,2 trans-enoyl-CoA isomerase)|dodecenoyl-CoA isomerase|dodecenoyl-Coenzyme A delta isomerase (3,2 trans-enoyl-Coenzyme A isomerase)', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2239872, end_position_on_the_genomic_accession=2251601, orientation='minus', exon_count=7, OMIM=600305, no_hdr0=''),
  1633 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1633, CurrentID=0, Status='live', Symbol='DCK', Aliases='', description='deoxycytidine kinase', other_designations='deoxynucleoside kinase', map_location='4q13.3-q21.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=70993548, end_position_on_the_genomic_accession=71030914, orientation='plus', exon_count=7, OMIM=125450, no_hdr0=''),
  1634 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1634, CurrentID=0, Status='live', Symbol='DCN', Aliases='CSCD, DSPG2, PG40, PGII, PGS2, SLRR1B', description='decorin', other_designations='bone proteoglycan II|dermatan sulphate proteoglycans II|proteoglycan core protein|small leucine-rich protein 1B', map_location='12q21.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=91145258, end_position_on_the_genomic_accession=91183029, orientation='minus', exon_count=11, OMIM=125255, no_hdr0=''),
  1635 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1635, CurrentID=0, Status='live', Symbol='DCTD', Aliases='', description='dCMP deaminase', other_designations='', map_location='4q35.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=182890087, end_position_on_the_genomic_accession=182917477, orientation='minus', exon_count=9, OMIM=607638, no_hdr0=''),
  1636 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1636, CurrentID=0, Status='live', Symbol='ACE', Aliases='ACE1, CD143, DCP, DCP1, ICH, MVCD3', description='angiotensin I converting enzyme', other_designations='CD143 antigen|angiotensin I converting enzyme (peptidyl-dipeptidase A) 1|angiotensin I converting enzyme peptidyl-dipeptidase A 1 transcript|angiotensin converting enzyme, somatic isoform|carboxycathepsin|dipeptidyl carboxypeptidase 1|dipeptidyl carboxypeptidase I|kininase II|peptidase P|testicular ECA', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63477061, end_position_on_the_genomic_accession=63498380, orientation='plus', exon_count=26, OMIM=106180, no_hdr0=''),
  1638 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1638, CurrentID=0, Status='live', Symbol='DCT', Aliases='TRP-2, TYRP2', description='dopachrome tautomerase', other_designations='DT|L-dopachrome Delta-isomerase|L-dopachrome isomerase|TRP2|dopachrome delta-isomerase|dopachrome tautomerase (dopachrome delta-isomerase, tyrosine-related protein 2)|tyrosinase related protein-2|tyrosinase-related protein 2|tyrosine-related protein 2', map_location='13q32', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=94437304, end_position_on_the_genomic_accession=94550265, orientation='minus', exon_count=13, OMIM=191275, no_hdr0=''),
  1639 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1639, CurrentID=0, Status='live', Symbol='DCTN1', Aliases='DAP-150, DP-150, P135', description='dynactin subunit 1', other_designations='150 kDa dynein-associated polypeptide|dynactin 1 (p150, glued homolog, Drosophila)', map_location='2p13', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=74361154, end_position_on_the_genomic_accession=74392087, orientation='minus', exon_count=33, OMIM=601143, no_hdr0=''),
  1641 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1641, CurrentID=0, Status='live', Symbol='DCX', Aliases='DBCN, DC, LISX, SCLH, XLIS', description='doublecortin', other_designations='doublecortex|doublin|lis-X|lissencephalin-X', map_location='Xq22.3-q23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=111293779, end_position_on_the_genomic_accession=111412232, orientation='minus', exon_count=8, OMIM=300121, no_hdr0=''),
  1642 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1642, CurrentID=0, Status='live', Symbol='DDB1', Aliases='DDBA, UV-DDB1, XAP1, XPCE, XPE, XPE-BF', description='damage specific DNA binding protein 1', other_designations='DDB p127 subunit|DNA damage-binding protein a|HBV X-associated protein 1|UV-DDB 1|UV-damaged DNA-binding factor|UV-damaged DNA-binding protein 1|XAP-1|XPE-binding factor|damage-specific DNA binding protein 1, 127kDa|xeroderma pigmentosum group E-complementing protein', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61299447, end_position_on_the_genomic_accession=61333212, orientation='minus', exon_count=27, OMIM=600045, no_hdr0=''),
  1643 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1643, CurrentID=0, Status='live', Symbol='DDB2', Aliases='DDBB, UV-DDB2, XPE', description='damage specific DNA binding protein 2', other_designations='DDB p48 subunit|UV-DDB 2|UV-damaged DNA-binding protein 2|damage-specific DNA binding protein 2, 48kDa|damage-specific DNA-binding protein 2|xeroderma pigmentosum group E protein', map_location='11p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=47214942, end_position_on_the_genomic_accession=47239218, orientation='plus', exon_count=10, OMIM=600811, no_hdr0=''),
  1644 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1644, CurrentID=0, Status='live', Symbol='DDC', Aliases='AADC', description='dopa decarboxylase', other_designations='aromatic L-amino acid decarboxylase|dopa decarboxylase (aromatic L-amino acid decarboxylase)', map_location='7p12.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=50458436, end_position_on_the_genomic_accession=50565457, orientation='minus', exon_count=18, OMIM=107930, no_hdr0=''),
  1645 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1645, CurrentID=0, Status='live', Symbol='AKR1C1', Aliases='2-ALPHA-HSD, 20-ALPHA-HSD, C9, DD1, DD1/DD2, DDH, DDH1, H-37, HAKRC, HBAB, MBAB', description='aldo-keto reductase family 1, member C1', other_designations='20 alpha-hydroxysteroid dehydrogenase|20-alpha-hydroxysteroid dehydrogenase|aldo-keto reductase C|chlordecone reductase homolog HAKRC|dihydrodiol dehydrogenase 1|dihydrodiol dehydrogenase 1/2|dihydrodiol dehydrogenase 1; 20-alpha (3-alpha)-hydroxysteroid dehydrogenase|dihydrodiol dehydrogenase isoform DD1|hepatic dihydrodiol dehydrogenase|high-affinity hepatic bile acid-binding protein|indanol dehydrogenase|trans-1,2-dihydrobenzene-1,2-diol dehydrogenase|type II 3-alpha-hydroxysteroid dehydrogenase', map_location='10p15-p14', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=4963262, end_position_on_the_genomic_accession=4977966, orientation='plus', exon_count=9, OMIM=600449, no_hdr0=''),
  1646 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1646, CurrentID=0, Status='live', Symbol='AKR1C2', Aliases='AKR1C-pseudo, BABP, DD, DD-2, DD/BABP, DD2, DDH2, HAKRD, HBAB, MCDR2, SRXY8, TDD', description='aldo-keto reductase family 1, member C2', other_designations='3-alpha-HSD3|chlordecone reductase homolog HAKRD|dihydrodiol dehydrogenase 2; bile acid binding protein; 3-alpha hydroxysteroid dehydrogenase, type III|pseudo-chlordecone reductase|testicular 17,20-desmolase deficiency|trans-1,2-dihydrobenzene-1,2-diol dehydrogenase|type II dihydrodiol dehydrogenase', map_location='10p15-p14', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=4987775, end_position_on_the_genomic_accession=5018033, orientation='minus', exon_count=12, OMIM=600450, no_hdr0=''),
  1647 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1647, CurrentID=0, Status='live', Symbol='GADD45A', Aliases='DDIT1, GADD45', description='growth arrest and DNA damage inducible alpha', other_designations='DDIT-1|DNA damage-inducible transcript 1 protein|DNA damage-inducible transcript-1|DNA-damage-inducible transcript 1|growth arrest and DNA-damage-inducible 45 alpha|growth arrest and DNA-damage-inducible, alpha', map_location='1p31.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=67685177, end_position_on_the_genomic_accession=67688338, orientation='plus', exon_count=4, OMIM=126335, no_hdr0=''),
  132720 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132720, CurrentID=0, Status='live', Symbol='C4orf32', Aliases='', description='chromosome 4 open reading frame 32', other_designations='', map_location='4q25', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=112145397, end_position_on_the_genomic_accession=112189081, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  1649 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1649, CurrentID=0, Status='live', Symbol='DDIT3', Aliases='CEBPZ, CHOP, CHOP-10, CHOP10, GADD153', description='DNA damage inducible transcript 3', other_designations='C/EBP zeta|CCAAT/enhancer-binding protein homologous protein|DDIT-3|DNA-damage-inducible transcript 3|c/EBP-homologous protein 10|growth arrest and DNA damage-inducible protein GADD153', map_location='12q13.1-q13.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=57516588, end_position_on_the_genomic_accession=57521698, orientation='minus', exon_count=5, OMIM=126337, no_hdr0=''),
  1650 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1650, CurrentID=0, Status='live', Symbol='DDOST', Aliases='AGER1, CDG1R, OKSWcl45, OST, OST48, WBP1', description='dolichyl-diphosphooligosaccharide--protein glycosyltransferase subunit (non-catalytic)', other_designations='advanced glycation endproduct receptor 1|dolichyl-diphosphooligosaccharide-protein glycotransferase|oligosaccharyl transferase 48 kDa subunit|oligosaccharyltransferase 48 kDa subunit|oligosaccharyltransferase subunit 48', map_location='1p36.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=20651767, end_position_on_the_genomic_accession=20661544, orientation='minus', exon_count=11, OMIM=602202, no_hdr0=''),
  196883 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=196883, CurrentID=0, Status='live', Symbol='ADCY4', Aliases='AC4', description='adenylate cyclase 4', other_designations='ATP pyrophosphate-lyase 4|adenylate cyclase type IV|adenylyl cyclase 4', map_location='14q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=24318349, end_position_on_the_genomic_accession=24335071, orientation='minus', exon_count=26, OMIM=600292, no_hdr0=''),
  1652 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1652, CurrentID=0, Status='live', Symbol='DDT', Aliases='DDCT', description='D-dopachrome tautomerase', other_designations='phenylpyruvate tautomerase II', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=23971365, end_position_on_the_genomic_accession=23979828, orientation='minus', exon_count=4, OMIM=602750, no_hdr0=''),
  1653 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1653, CurrentID=0, Status='live', Symbol='DDX1', Aliases='DBP-RB, UKVH5d', description='DEAD/H-box helicase 1', other_designations='DEAD (Asp-Glu-Ala-Asp) box helicase 1|DEAD (Asp-Glu-Ala-Asp) box polypeptide 1|DEAD box polypeptide 1|DEAD box protein 1|DEAD box protein retinoblastoma|DEAD box-1|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 1', map_location='2p24', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=15591621, end_position_on_the_genomic_accession=15631111, orientation='plus', exon_count=26, OMIM=601257, no_hdr0=''),
  1654 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1654, CurrentID=0, Status='live', Symbol='DDX3X', Aliases='CAP-Rf, DBX, DDX14, DDX3, HLP2', description='DEAD-box helicase 3, X-linked', other_designations='DEAD (Asp-Glu-Ala-Asp) box helicase 3, X-linked|DEAD (Asp-Glu-Ala-Asp) box polypeptide 3, X-linked|DEAD box protein 3, X-chromosomal|DEAD box, X isoform|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 3|DEAD/H box-3|helicase-like protein 2', map_location='Xp11.3-p11.23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=41333308, end_position_on_the_genomic_accession=41364472, orientation='plus', exon_count=20, OMIM=300160, no_hdr0=''),
  1655 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1655, CurrentID=0, Status='live', Symbol='DDX5', Aliases='G17P1, HLR1, HUMP68, p68', description='DEAD-box helicase 5', other_designations='ATP-dependent RNA helicase DDX5|DEAD (Asp-Glu-Ala-Asp) box helicase 5|DEAD (Asp-Glu-Ala-Asp) box polypeptide 5|DEAD box protein 5|DEAD box-5|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 5 (RNA helicase, 68kD)|RNA helicase p68', map_location='17q21', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=64498256, end_position_on_the_genomic_accession=64506924, orientation='minus', exon_count=16, OMIM=180630, no_hdr0=''),
  1656 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1656, CurrentID=0, Status='live', Symbol='DDX6', Aliases='HLR2, P54, RCK', description='DEAD-box helicase 6', other_designations='ATP-dependent RNA helicase p54|DEAD (Asp-Glu-Ala-Asp) box helicase 6|DEAD (Asp-Glu-Ala-Asp) box polypeptide 6|DEAD box protein 6|DEAD box-6|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 6 (RNA helicase, 54kD)|oncogene RCK', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118747763, end_position_on_the_genomic_accession=118791263, orientation='minus', exon_count=15, OMIM=600326, no_hdr0=''),
  1657 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1657, CurrentID=0, Status='live', Symbol='DMXL1', Aliases='', description='Dmx like 1', other_designations='Dmx-like 1', map_location='5q22', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=119071014, end_position_on_the_genomic_accession=119249129, orientation='plus', exon_count=46, OMIM=605671, no_hdr0=''),
  1659 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1659, CurrentID=0, Status='live', Symbol='DHX8', Aliases='DDX8, HRH1, PRP22, PRPF22', description='DEAH-box helicase 8', other_designations='DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 8 (RNA helicase)|DEAH (Asp-Glu-Ala-His) box polypeptide 8|DEAH box protein 8|RNA helicase HRH1', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43483917, end_position_on_the_genomic_accession=43526796, orientation='plus', exon_count=24, OMIM=600396, no_hdr0=''),
  1660 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1660, CurrentID=0, Status='live', Symbol='DHX9', Aliases='DDX9, LKP, NDH2, NDHII, RHA', description='DEAH-box helicase 9', other_designations='DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 9|DEAH (Asp-Glu-Ala-His) box helicase 9|DEAH (Asp-Glu-Ala-His) box polypeptide 9|DEAH box protein 9|RNA helicase A|leukophysin|nuclear DNA helicase II', map_location='1q25', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=182839304, end_position_on_the_genomic_accession=182887982, orientation='plus', exon_count=29, OMIM=603115, no_hdr0=''),
  284266 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284266, CurrentID=0, Status='live', Symbol='SIGLEC15', Aliases='CD33L3, HsT1361, SIGLEC-15', description='sialic acid binding Ig like lectin 15', other_designations='CD33 antigen-like 3|CD33 molecule-like 3|sialic acid binding Ig-like lectin 15', map_location='18q12.3', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=45825580, end_position_on_the_genomic_accession=45842556, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  1662 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1662, CurrentID=0, Status='live', Symbol='DDX10', Aliases='HRH-J8', description='DEAD-box helicase 10', other_designations='DDX10-NUP98 fusion protein type 2|DEAD (Asp-Glu-Ala-Asp) box polypeptide 10|DEAD box protein 10|DEAD box-10|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 10 (RNA helicase)', map_location='11q22-q23', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=108665025, end_position_on_the_genomic_accession=108940930, orientation='plus', exon_count=19, OMIM=601235, no_hdr0=''),
  1663 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1663, CurrentID=0, Status='live', Symbol='DDX11', Aliases='CHL1, CHLR1, KRG2, WABS', description='DEAD/H-box helicase 11', other_designations='CHL1-like helicase homolog|CHL1-related helicase gene-1|CHL1-related protein 1|DEAD/H (Asp-Glu-Ala-Asp/His) box helicase 11|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 11 (CHL1-like helicase homolog, S. cerevisiae)|DEAD/H box protein 11|KRG-2|hCHLR1|keratinocyte growth factor-regulated gene 2 protein|probable ATP-dependent RNA helicase DDX11', map_location='12p11', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=31073581, end_position_on_the_genomic_accession=31104799, orientation='plus', exon_count=29, OMIM=601150, no_hdr0=''),
  1665 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1665, CurrentID=0, Status='live', Symbol='DHX15', Aliases='DBP1, DDX15, HRH2, PRP43, PRPF43, PrPp43p', description='DEAH-box helicase 15', other_designations='ATP-dependent RNA helicase #46|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 15|DEAD/H box-15|DEAH (Asp-Glu-Ala-His) box helicase 15|DEAH (Asp-Glu-Ala-His) box polypeptide 15|DEAH box protein 15|RNA helicase 2|putative pre-mRNA-splicing factor ATP-dependent RNA helicase DHX15', map_location='4p15.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=24527464, end_position_on_the_genomic_accession=24584603, orientation='minus', exon_count=14, OMIM=603403, no_hdr0=''),
  1666 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1666, CurrentID=0, Status='live', Symbol='DECR1', Aliases='DECR, NADPH, SDR18C1', description='2,4-dienoyl-CoA reductase 1, mitochondrial', other_designations='2,4-dienoyl CoA reductase 1, mitochondrial|4-enoyl-CoA reductase|short chain dehydrogenase/reductase family 18C member 1|short chain dehydrogenase/reductase family 18C, member 1', map_location='8q21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=90001352, end_position_on_the_genomic_accession=90052004, orientation='plus', exon_count=11, OMIM=222745, no_hdr0=''),
  1667 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1667, CurrentID=0, Status='live', Symbol='DEFA1', Aliases='DEF1, DEFA2, HNP-1, HP-1, HP1, MRS', description='defensin alpha 1', other_designations='defensin, alpha 1, myeloid-related sequence|defensin, alpha 2|myeloid-related sequence', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6977649, end_position_on_the_genomic_accession=6980122, orientation='minus', exon_count=4, OMIM=125220, no_hdr0=''),
  1668 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1668, CurrentID=0, Status='live', Symbol='DEFA3', Aliases='DEF3, HNP-3, HNP3, HP-3, HP3', description='defensin alpha 3', other_designations='defensin 3, neutrophil-specific|defensin, alpha 3, neutrophil-specific|neutrophil peptide 3', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=7015869, end_position_on_the_genomic_accession=7018339, orientation='minus', exon_count=4, OMIM=604522, no_hdr0=''),
  1669 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1669, CurrentID=0, Status='live', Symbol='DEFA4', Aliases='DEF4, HNP-4, HP-4, HP4', description='defensin alpha 4', other_designations='corticostatin|defensin, alpha 4, corticostatin|defensin, alpha 4, preproprotein', map_location='8p23', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6935820, end_position_on_the_genomic_accession=6938338, orientation='minus', exon_count=3, OMIM=601157, no_hdr0=''),
  1670 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1670, CurrentID=0, Status='live', Symbol='DEFA5', Aliases='DEF5, HD-5', description='defensin alpha 5', other_designations='HD5(20-94)|defensin 5|defensin, alpha 5, Paneth cell-specific|defensin, alpha 5, preproprotein', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=7055300, end_position_on_the_genomic_accession=7056739, orientation='minus', exon_count=2, OMIM=600472, no_hdr0=''),
  1671 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1671, CurrentID=0, Status='live', Symbol='DEFA6', Aliases='DEF6, HD-6', description='defensin alpha 6', other_designations='defensin 6|defensin, alpha 6, Paneth cell-specific', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6924694, end_position_on_the_genomic_accession=6926076, orientation='minus', exon_count=2, OMIM=600471, no_hdr0=''),
  1672 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1672, CurrentID=0, Status='live', Symbol='DEFB1', Aliases='BD1, DEFB-101, HBD1, DEFB1', description='defensin beta 1', other_designations='BD-1|beta defensin 1|beta-defensin-1|defensin, beta 1', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6870575, end_position_on_the_genomic_accession=6878007, orientation='minus', exon_count=2, OMIM=602056, no_hdr0=''),
  1673 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1673, CurrentID=0, Status='live', Symbol='DEFB4A', Aliases='BD-2, DEFB-2, DEFB102, DEFB2, DEFB4, HBD-2, SAP1', description='defensin beta 4A', other_designations='beta defensin 2|beta defensin-2|defensin, beta 2|defensin, beta 4|defensin, beta 4A|skin-antimicrobial peptide 1', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=7894565, end_position_on_the_genomic_accession=7896716, orientation='plus', exon_count=2, OMIM=602215, no_hdr0=''),
  1674 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1674, CurrentID=0, Status='live', Symbol='DES', Aliases='CSM1, CSM2, LGMD2R', description='desmin', other_designations='intermediate filament protein|mutant desmin p.K241E', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=219418377, end_position_on_the_genomic_accession=219426739, orientation='plus', exon_count=9, OMIM=125660, no_hdr0=''),
  1675 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1675, CurrentID=0, Status='live', Symbol='CFD', Aliases='ADIPSIN, ADN, DF, PFD', description='complement factor D (adipsin)', other_designations='C3 convertase activator|D component of complement (adipsin)|complement factor D preproprotein|properdin factor D', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=859665, end_position_on_the_genomic_accession=863624, orientation='plus', exon_count=5, OMIM=134350, no_hdr0=''),
  1676 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1676, CurrentID=0, Status='live', Symbol='DFFA', Aliases='DFF-45, DFF1, ICAD', description='DNA fragmentation factor subunit alpha', other_designations='DFF45|DNA fragmentation factor 45 kDa subunit|DNA fragmentation factor, 45kDa, alpha polypeptide|inhibitor of CAD', map_location='1p36.3-p36.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=10460531, end_position_on_the_genomic_accession=10472556, orientation='minus', exon_count=6, OMIM=601882, no_hdr0=''),
  1677 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1677, CurrentID=0, Status='live', Symbol='DFFB', Aliases='CAD, CPAN, DFF-40, DFF2, DFF40', description='DNA fragmentation factor subunit beta', other_designations='DNA fragmentation factor 40 kDa subunit|DNA fragmentation factor, 40kDa, beta polypeptide (caspase-activated DNase)|caspase-activated DNase|caspase-activated deoxyribonuclease|caspase-activated nuclease', map_location='1p36.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=3857143, end_position_on_the_genomic_accession=3885429, orientation='plus', exon_count=10, OMIM=601883, no_hdr0=''),
  1678 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1678, CurrentID=0, Status='live', Symbol='TIMM8A', Aliases='DDP, DDP1, DFN1, MTS, TIM8', description='translocase of inner mitochondrial membrane 8 homolog A (yeast)', other_designations='X-linked deafness dystonia protein|deafness dystonia protein 1|deafness/dystonia peptide', map_location='Xq22.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=101345656, end_position_on_the_genomic_accession=101348969, orientation='minus', exon_count=3, OMIM=300356, no_hdr0=''),
  644717 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=644717, CurrentID=0, Status='live', Symbol='SAGE2P', Aliases='', description='sarcoma antigen 2, pseudogene', other_designations='putative SAGE1-like protein', map_location='Xq26.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=135638042, end_position_on_the_genomic_accession=135688495, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  168090 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=168090, CurrentID=0, Status='live', Symbol='C6orf118', Aliases='bA85G2.1, dJ416F21.2', description='chromosome 6 open reading frame 118', other_designations='dJ416F21.2 (novel protein)', map_location='6q27', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=165279664, end_position_on_the_genomic_accession=165309647, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  1687 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1687, CurrentID=0, Status='live', Symbol='DFNA5', Aliases='ICERE-1', description='deafness, autosomal dominant 5', other_designations='inversely correlated with estrogen receptor expression 1|nonsyndromic hearing impairment protein', map_location='7p15', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=24698355, end_position_on_the_genomic_accession=24758020, orientation='minus', exon_count=11, OMIM=608798, no_hdr0=''),
  1690 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1690, CurrentID=0, Status='live', Symbol='COCH', Aliases='COCH-5B25B2, DFNA9, COCH', description='cochlin', other_designations='coagulation factor C homolog, cochlin (Limulus polyphemus)', map_location='14q11.2-q13', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=30874535, end_position_on_the_genomic_accession=30895079, orientation='plus', exon_count=12, OMIM=603196, no_hdr0=''),
  100996720 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100996720, CurrentID=0, Status='live', Symbol='LOC100996720', Aliases='', description='uncharacterized LOC100996720', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  151195 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=151195, CurrentID=0, Status='live', Symbol='CCNYL1', Aliases='', description='cyclin Y like 1', other_designations='cyclin Y-like 1', map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=207711540, end_position_on_the_genomic_accession=207756174, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  153201 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=153201, CurrentID=0, Status='live', Symbol='SLC36A2', Aliases='PAT2, TRAMD1', description='solute carrier family 36 (proton/amino acid symporter), member 2', other_designations='tramdorin-1', map_location='5q33.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=151314978, end_position_on_the_genomic_accession=151347590, orientation='minus', exon_count=12, OMIM=608331, no_hdr0=''),
  165545 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=165545, CurrentID=0, Status='live', Symbol='DQX1', Aliases='', description='DEAQ-box RNA dependent ATPase 1', other_designations='DEAQ RNA-dependent ATPase DQX1|DEAQ box RNA-dependent ATPase 1|DEAQ box polypeptide 1 (RNA-dependent ATPase)', map_location='2p13.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=74518131, end_position_on_the_genomic_accession=74526281, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  284274 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284274, CurrentID=0, Status='live', Symbol='SMIM21', Aliases='C18orf62', description='small integral membrane protein 21', other_designations='', map_location='18q23', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=75409476, end_position_on_the_genomic_accession=75455653, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  51294 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=51294, CurrentID=0, Status='live', Symbol='PCDH12', Aliases='VE-cadherin-2, VECAD2', description='protocadherin 12', other_designations='VE-cad-2|VE-cadherin 2|vascular cadherin-2|vascular endothelial cadherin 2|vascular endothelial cadherin-2', map_location='5q31', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=141943585, end_position_on_the_genomic_accession=141959062, orientation='minus', exon_count=4, OMIM=605622, no_hdr0=''),
  1716 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1716, CurrentID=0, Status='live', Symbol='DGUOK', Aliases='MTDPS3, dGK', description='deoxyguanosine kinase', other_designations='', map_location='2p13', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=73926826, end_position_on_the_genomic_accession=73958961, orientation='plus', exon_count=8, OMIM=601465, no_hdr0=''),
  1717 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1717, CurrentID=0, Status='live', Symbol='DHCR7', Aliases='SLOS', description='7-dehydrocholesterol reductase', other_designations='7-DHC reductase|delta-7-dehydrocholesterol reductase|putative sterol reductase SR-2|sterol delta-7-reductase', map_location='11q13.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=71434411, end_position_on_the_genomic_accession=71448431, orientation='minus', exon_count=9, OMIM=602858, no_hdr0=''),
  1718 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1718, CurrentID=0, Status='live', Symbol='DHCR24', Aliases='DCE, Nbla03646, SELADIN1, seladin-1', description='24-dehydrocholesterol reductase', other_designations='3 beta-hydroxysterol delta 24-reductase|3-beta-hydroxysterol delta-24-reductase|desmosterol-to-cholesterol enzyme|diminuto/dwarf1 homolog|seladin 1|selective AD indicator 1', map_location='1p32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=54849627, end_position_on_the_genomic_accession=54887248, orientation='minus', exon_count=9, OMIM=606418, no_hdr0=''),
  1719 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1719, CurrentID=0, Status='live', Symbol='DHFR', Aliases='DHFRP1, DYR', description='dihydrofolate reductase', other_designations='', map_location='5q14.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=80626226, end_position_on_the_genomic_accession=80654981, orientation='minus', exon_count=6, OMIM=126060, no_hdr0=''),
  1723 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1723, CurrentID=0, Status='live', Symbol='DHODH', Aliases='DHOdehase, POADS, URA1', description='dihydroorotate dehydrogenase (quinone)', other_designations='dihydroorotate oxidase|human complement of yeast URA1', map_location='16q22', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=72008744, end_position_on_the_genomic_accession=72025417, orientation='plus', exon_count=11, OMIM=126064, no_hdr0=''),
  1725 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1725, CurrentID=0, Status='live', Symbol='DHPS', Aliases='DHS, DS, MIG13', description='deoxyhypusine synthase', other_designations='migration-inducing gene 13', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12672858, end_position_on_the_genomic_accession=12681887, orientation='minus', exon_count=13, OMIM=600944, no_hdr0=''),
  123355 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=123355, CurrentID=0, Status='live', Symbol='LRRC28', Aliases='', description='leucine rich repeat containing 28', other_designations='', map_location='15q26.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=99251362, end_position_on_the_genomic_accession=99386309, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  1727 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1727, CurrentID=0, Status='live', Symbol='CYB5R3', Aliases='B5R, DIA1', description='cytochrome b5 reductase 3', other_designations='NADH-cytochrome b5 reductase 3 membrane-bound form|NADH-cytochrome b5 reductase 3 soluble form|diaphorase-1|mutant NADH-cytochrome b5 reductase', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=42617840, end_position_on_the_genomic_accession=42649399, orientation='minus', exon_count=12, OMIM=613213, no_hdr0=''),
  1728 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1728, CurrentID=0, Status='live', Symbol='NQO1', Aliases='DHQU, DIA4, DTD, NMOR1, NMORI, QR1', description='NAD(P)H dehydrogenase, quinone 1', other_designations='DT-diaphorase|NAD(P)H:Quinone acceptor oxidoreductase type 1|NAD(P)H:menadione oxidoreductase 1|NAD(P)H:quinone oxidoreductase 1|NAD(P)H:quinone oxireductase|azoreductase|diaphorase (NADH/NADPH) (cytochrome b-5 reductase)|diaphorase-4|dioxin-inducible 1|menadione reductase|phylloquinone reductase|quinone reductase 1', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=69709401, end_position_on_the_genomic_accession=69726668, orientation='minus', exon_count=6, OMIM=125860, no_hdr0=''),
  1729 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1729, CurrentID=0, Status='live', Symbol='DIAPH1', Aliases='DFNA1, DIA1, DRF1, LFHL1, SCBMS, hDIA1', description='diaphanous related formin 1', other_designations='diaphanous-related formin 1', map_location='5q31', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=141515016, end_position_on_the_genomic_accession=141619055, orientation='minus', exon_count=31, OMIM=602121, no_hdr0=''),
  1730 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1730, CurrentID=0, Status='live', Symbol='DIAPH2', Aliases='DIA, DIA2, DRF2, POF, POF2', description='diaphanous related formin 2', other_designations='diaphanous homolog 2|diaphanous-related formin 2|diaphanous-related formin-2|diaphorase-2', map_location='Xq21.33', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=96684663, end_position_on_the_genomic_accession=97600598, orientation='plus', exon_count=28, OMIM=300108, no_hdr0=''),
  1731 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1731, CurrentID=0, Status='live', Symbol='SEPT1', Aliases='DIFF6, LARP, PNUTL3, SEP1', description='septin 1', other_designations='differentiation 6 (deoxyguanosine triphosphate triphosphohydrolase)|peanut-like protein 3|serologically defined breast cancer antigen NY-BR-24', map_location='16p11.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=30378133, end_position_on_the_genomic_accession=30382850, orientation='minus', exon_count=12, OMIM=612897, no_hdr0=''),
  105375112 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105375112, CurrentID=0, Status='live', Symbol='LOC105375112', Aliases='', description='putative protein FAM157B', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=31567, end_position_on_the_genomic_accession=37465, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  1733 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1733, CurrentID=0, Status='live', Symbol='DIO1', Aliases='5DI, TXDI1', description='deiodinase, iodothyronine, type I', other_designations="DIOI|iodothyronine deiodinase type 1|thyroxine deiodinase type I (selenoprotein)|type 1 DI|type-I 5'-deiodinase", map_location='1p33-p32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=53894188, end_position_on_the_genomic_accession=53911086, orientation='plus', exon_count=4, OMIM=147892, no_hdr0=''),
  1734 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1734, CurrentID=0, Status='live', Symbol='DIO2', Aliases='5DII, D2, DIOII, SelY, TXDI2', description='deiodinase, iodothyronine, type II', other_designations="deiodinase-2|deiodonase-2|thyroxine deiodinase, type II|type 2 DI|type 2 iodothyronine deiodinase|type-II 5'-deiodinase|type-II 5'deiodinase", map_location='14q24.2-q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=80197525, end_position_on_the_genomic_accession=80231054, orientation='minus', exon_count=6, OMIM=601413, no_hdr0=''),
  1735 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1735, CurrentID=0, Status='live', Symbol='DIO3', Aliases='5DIII, D3, DIOIII, TXDI3', description='deiodinase, iodothyronine, type III', other_designations="iodothyronine deiodinase, placental type|thyroxine deiodinase type III (selenoprotein)|type 3 DI|type 3 iodothyronine selenodeiodinase|type-III 5' deiodinase|type-III 5'-deiodinase", map_location='14q32', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=101561351, end_position_on_the_genomic_accession=101563452, orientation='plus', exon_count=1, OMIM=601038, no_hdr0=''),
  1736 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1736, CurrentID=0, Status='live', Symbol='DKC1', Aliases='CBF5, DKC, DKCX, NAP57, NOLA4, XAP101', description='dyskerin pseudouridine synthase 1', other_designations='CBF5 homolog|dyskeratosis congenita 1, dyskerin|nopp140-associated protein of 57 kDa|nucleolar protein NAP57|nucleolar protein family A member 4|snoRNP protein DKC1', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154762742, end_position_on_the_genomic_accession=154777689, orientation='plus', exon_count=14, OMIM=300126, no_hdr0=''),
  1737 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1737, CurrentID=0, Status='live', Symbol='DLAT', Aliases='DLTA, PDC-E2, PDCE2', description='dihydrolipoamide S-acetyltransferase', other_designations='70 kDa mitochondrial autoantigen of primary biliary cirrhosis|E2 component of pyruvate dehydrogenase complex|M2 antigen complex 70 kDa subunit|PBC|dihydrolipoamide acetyltransferase component of pyruvate dehydrogenase complex|dihydrolipoyllysine-residue acetyltransferase component of pyruvate dehydrogenase complex mitochondrial|pyruvate dehydrogenase complex component E2', map_location='11q23.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=112024814, end_position_on_the_genomic_accession=112064278, orientation='plus', exon_count=14, OMIM=608770, no_hdr0=''),
  1738 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1738, CurrentID=0, Status='live', Symbol='DLD', Aliases='DLDDH, E3, GCSL, LAD, PHE3, DLD', description='dihydrolipoamide dehydrogenase', other_designations='E3 component of pyruvate dehydrogenase complex, 2-oxo-glutarate complex, branched chain keto acid dehydrogenase complex|diaphorase|glycine cleavage system L protein|glycine cleavage system protein L|lipoamide dehydrogenase|lipoamide reductase|lipoyl dehydrogenase', map_location='7q31-q32', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=107891107, end_position_on_the_genomic_accession=107921198, orientation='plus', exon_count=14, OMIM=238331, no_hdr0=''),
  1739 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1739, CurrentID=0, Status='live', Symbol='DLG1', Aliases='DLGH1, SAP-97, SAP97, dJ1061C18.1.1, hdlg', description='discs large homolog 1', other_designations='discs, large homolog 1|presynaptic protein SAP97|synapse-associated protein 97', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=197042560, end_position_on_the_genomic_accession=197299272, orientation='minus', exon_count=34, OMIM=601014, no_hdr0=''),
  1740 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1740, CurrentID=0, Status='live', Symbol='DLG2', Aliases='PPP1R58, PSD-93, PSD93, chapsyn-110', description='discs large homolog 2', other_designations='channel-associated protein of synapse-110|channel-associated protein of synapses, 110kDa|discs large 2|discs, large homolog 2|discs, large homolog 2, chapsyn-110|postsynaptic density protein PSD-93|protein phosphatase 1, regulatory subunit 58', map_location='11q14.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=83455012, end_position_on_the_genomic_accession=85628534, orientation='minus', exon_count=39, OMIM=603583, no_hdr0=''),
  1741 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1741, CurrentID=0, Status='live', Symbol='DLG3', Aliases='MRX, MRX90, NEDLG, PPP1R82, SAP102, XLMR', description='discs large homolog 3', other_designations='discs, large homolog 3|neuroendocrine-DLG|protein phosphatase 1, regulatory subunit 82|synapse-associated protein 102', map_location='Xq13.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=70444850, end_position_on_the_genomic_accession=70505490, orientation='plus', exon_count=23, OMIM=300189, no_hdr0=''),
  1742 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1742, CurrentID=0, Status='live', Symbol='DLG4', Aliases='PSD95, SAP-90, SAP90', description='discs large homolog 4', other_designations='Tax interaction protein 15|discs, large homolog 4|post-synaptic density protein 95|postsynaptic density protein 95|synapse-associated protein 90', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7189890, end_position_on_the_genomic_accession=7220050, orientation='minus', exon_count=26, OMIM=602887, no_hdr0=''),
  1743 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1743, CurrentID=0, Status='live', Symbol='DLST', Aliases='DLTS', description='dihydrolipoamide S-succinyltransferase (E2 component of 2-oxo-glutarate complex)', other_designations='E2K|OGDC-E2', map_location='14q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=74881891, end_position_on_the_genomic_accession=74903747, orientation='plus', exon_count=15, OMIM=126063, no_hdr0=''),
  1745 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1745, CurrentID=0, Status='live', Symbol='DLX1', Aliases='', description='distal-less homeobox 1', other_designations='distal-less homeo box 1', map_location='2q32', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=172085480, end_position_on_the_genomic_accession=172089674, orientation='plus', exon_count=3, OMIM=600029, no_hdr0=''),
  1746 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1746, CurrentID=0, Status='live', Symbol='DLX2', Aliases='TES-1, TES1', description='distal-less homeobox 2', other_designations='distal-less homeo box 2', map_location='2q32', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=172099438, end_position_on_the_genomic_accession=172102750, orientation='minus', exon_count=3, OMIM=126255, no_hdr0=''),
  1747 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1747, CurrentID=0, Status='live', Symbol='DLX3', Aliases='AI4, TDO', description='distal-less homeobox 3', other_designations='', map_location='17q21', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=49977079, end_position_on_the_genomic_accession=49995224, orientation='minus', exon_count=4, OMIM=600525, no_hdr0=''),
  1748 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1748, CurrentID=0, Status='live', Symbol='DLX4', Aliases='BP1, DLX7, DLX8, DLX9', description='distal-less homeobox 4', other_designations='beta protein 1|distal-less homeo box 7|distal-less homeo box 9|homeobox protein DLX-7|homeobox protein DLX-8', map_location='17q21.33', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=49969198, end_position_on_the_genomic_accession=49974959, orientation='plus', exon_count=3, OMIM=601911, no_hdr0=''),
  1749 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1749, CurrentID=0, Status='live', Symbol='DLX5', Aliases='SHFM1D', description='distal-less homeobox 5', other_designations='distal-less homeo box 5|split hand/foot malformation type 1 with sensorineural hearing loss', map_location='7q22', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=97020390, end_position_on_the_genomic_accession=97024831, orientation='minus', exon_count=4, OMIM=600028, no_hdr0=''),
  1750 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1750, CurrentID=0, Status='live', Symbol='DLX6', Aliases='', description='distal-less homeobox 6', other_designations='distal-less homeo box 6', map_location='7q22', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=97005978, end_position_on_the_genomic_accession=97011040, orientation='plus', exon_count=3, OMIM=600030, no_hdr0=''),
  105377207 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105377207, CurrentID=0, Status='live', Symbol='LOC105377207', Aliases='', description='uncharacterized LOC105377207', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=75281933, end_position_on_the_genomic_accession=75342180, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  60494 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=60494, CurrentID=0, Status='live', Symbol='CCDC81', Aliases='', description='coiled-coil domain containing 81', other_designations='', map_location='11q14.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=86374736, end_position_on_the_genomic_accession=86423109, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  1755 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1755, CurrentID=0, Status='live', Symbol='DMBT1', Aliases='GP340, muclin', description='deleted in malignant brain tumors 1', other_designations='SAG|glycoprotein 340|gp-340|hensin|salivary agglutinin|surfactant pulmonary-associated D-binding protein', map_location='10q26.13', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=122560665, end_position_on_the_genomic_accession=122643736, orientation='plus', exon_count=56, OMIM=601969, no_hdr0=''),
  1756 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1756, CurrentID=0, Status='live', Symbol='DMD', Aliases='BMD, CMD3B, DXS142, DXS164, DXS206, DXS230, DXS239, DXS268, DXS269, DXS270, DXS272, MRX85', description='dystrophin', other_designations='', map_location='Xp21.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=31119219, end_position_on_the_genomic_accession=33339609, orientation='minus', exon_count=87, OMIM=300377, no_hdr0=''),
  1757 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1757, CurrentID=0, Status='live', Symbol='SARDH', Aliases='BPR-2, DMGDHL1, SAR, SARD, SDH', description='sarcosine dehydrogenase', other_designations='dimethylglycine dehydrogenase-like 1', map_location='9q33-q34', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=133661740, end_position_on_the_genomic_accession=133739955, orientation='minus', exon_count=24, OMIM=604455, no_hdr0=''),
  1758 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1758, CurrentID=0, Status='live', Symbol='DMP1', Aliases='ARHP, ARHR, DMP-1', description='dentin matrix acidic phosphoprotein 1', other_designations='dentin matrix protein 1', map_location='4q21', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=87650302, end_position_on_the_genomic_accession=87664361, orientation='plus', exon_count=7, OMIM=600980, no_hdr0=''),
  1759 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1759, CurrentID=0, Status='live', Symbol='DNM1', Aliases='DNM, EIEE31', description='dynamin 1', other_designations='', map_location='9q34', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=128203355, end_position_on_the_genomic_accession=128255249, orientation='plus', exon_count=26, OMIM=602377, no_hdr0=''),
  1760 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1760, CurrentID=0, Status='live', Symbol='DMPK', Aliases='DM, DM1, DM1PK, DMK, MDPK, MT-PK', description='dystrophia myotonica protein kinase', other_designations='DM protein kinase|DM1 protein kinase|dystrophia myotonica-protein kinase|myotonic dystrophy associated protein kinase|myotonin protein kinase A|thymopoietin homolog', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45769709, end_position_on_the_genomic_accession=45782557, orientation='minus', exon_count=16, OMIM=605377, no_hdr0=''),
  1761 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1761, CurrentID=0, Status='live', Symbol='DMRT1', Aliases='CT154, DMT1', description='doublesex and mab-3 related transcription factor 1', other_designations='DM domain expressed in testis 1|DM domain expressed in testis protein 1', map_location='9p24.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=841647, end_position_on_the_genomic_accession=969090, orientation='plus', exon_count=7, OMIM=602424, no_hdr0=''),
  1762 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1762, CurrentID=0, Status='live', Symbol='DMWD', Aliases='D19S593E, DMR-N9, DMRN9, gene59', description='dystrophia myotonica, WD repeat containing', other_designations='dystrophia myotonica-containing WD repeat motif protein|protein 59', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45783006, end_position_on_the_genomic_accession=45792802, orientation='minus', exon_count=5, OMIM=609857, no_hdr0=''),
  1763 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1763, CurrentID=0, Status='live', Symbol='DNA2', Aliases='DNA2L, hDNA2', description='DNA replication helicase/nuclease 2', other_designations='DNA replication ATP-dependent helicase-like homolog|DNA replication helicase 2 homolog|DNA2-like helicase', map_location='10q21.3-q22.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=68414064, end_position_on_the_genomic_accession=68472516, orientation='minus', exon_count=23, OMIM=601810, no_hdr0=''),
  100271846 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100271846, CurrentID=0, Status='live', Symbol='ERVV-2', Aliases='ENVV2, HERV-V2', description='endogenous retrovirus group V member 2', other_designations='HERV-V_19q13.41 provirus ancestral Env polyprotein 2|endogenous retrovirus HSV2|endogenous retrovirus group V, member 2|envelope glycoprotein ENVV2|envelope protein ENVV2', map_location='', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=53044738, end_position_on_the_genomic_accession=53051127, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  1767 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1767, CurrentID=0, Status='live', Symbol='DNAH5', Aliases='CILD3, DNAHC5, HL1, KTGNR, PCD', description='dynein, axonemal, heavy chain 5', other_designations='axonemal beta dynein heavy chain 5|ciliary dynein heavy chain 5|dynein, axonemal, heavy polypeptide 5', map_location='5p15.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=13690328, end_position_on_the_genomic_accession=14011759, orientation='minus', exon_count=80, OMIM=603335, no_hdr0=''),
  1768 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1768, CurrentID=0, Status='live', Symbol='DNAH6', Aliases='DNHL1, Dnahc6, HL-2, HL2', description='dynein, axonemal, heavy chain 6', other_designations='axonemal beta dynein heavy chain 6|ciliary dynein heavy chain 6|dynein heavy chain-like 1|dynein, axonemal, heavy polypeptide 6', map_location='2p11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=84459540, end_position_on_the_genomic_accession=84819589, orientation='plus', exon_count=83, OMIM=603336, no_hdr0=''),
  100271849 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100271849, CurrentID=0, Status='live', Symbol='MEF2B', Aliases='RSRFR2', description='myocyte enhancer factor 2B', other_designations='MADS box transcription enhancer factor 2, polypeptide B (myocyte enhancer factor 2B)|serum response factor-like protein 2', map_location='19p13.11', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=19145567, end_position_on_the_genomic_accession=19170289, orientation='minus', exon_count=9, OMIM=600661, no_hdr0=''),
  1770 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1770, CurrentID=0, Status='live', Symbol='DNAH9', Aliases='DNAH17L, DNEL1, DYH9, Dnahc9, HL-20, HL20', description='dynein, axonemal, heavy chain 9', other_designations='DNAH9 variant protein|axonemal beta dynein heavy chain 9|ciliary dynein heavy chain 9|dynein, axonemal, heavy polypeptide 9', map_location='17p12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=11598431, end_position_on_the_genomic_accession=11970168, orientation='plus', exon_count=71, OMIM=603330, no_hdr0=''),
  219982 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=219982, CurrentID=0, Status='live', Symbol='OR5A1', Aliases='OR11-249P, OST181, OR5A1', description='olfactory receptor family 5 subfamily A member 1', other_designations='olfactory receptor OR11-249|olfactory receptor, family 5, subfamily A, member 1 pseudogene', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=59438057, end_position_on_the_genomic_accession=59444188, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  1773 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1773, CurrentID=0, Status='live', Symbol='DNASE1', Aliases='DNL1, DRNI', description='deoxyribonuclease I', other_designations='DNase I, lysosomal|Dornase alfa|human urine deoxyribonuclease I', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=3611745, end_position_on_the_genomic_accession=3662875, orientation='plus', exon_count=15, OMIM=125505, no_hdr0=''),
  1774 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1774, CurrentID=0, Status='live', Symbol='DNASE1L1', Aliases='DNAS1L1, DNASEX, DNL1L, G4.8, XIB', description='deoxyribonuclease I-like 1', other_designations='DNase I, lysosomal-like|DNase I-like 1|DNase I-like, muscle-specific', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154401236, end_position_on_the_genomic_accession=154412091, orientation='minus', exon_count=10, OMIM=300081, no_hdr0=''),
  1775 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1775, CurrentID=0, Status='live', Symbol='DNASE1L2', Aliases='DNAS1L2', description='deoxyribonuclease I-like 2', other_designations='DNase I homolog protein DHP1|DNase I-like 2', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2236252, end_position_on_the_genomic_accession=2238711, orientation='plus', exon_count=7, OMIM=602622, no_hdr0=''),
  1776 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1776, CurrentID=0, Status='live', Symbol='DNASE1L3', Aliases='DHP2, DNAS1L3, LSD, SLEB16', description='deoxyribonuclease I-like 3', other_designations='DNase I homolog protein 2|DNase I homolog protein DHP2|DNase I-like 3|DNase gamma|LS-DNase|Liver and spleen DNase|deoxyribonuclease I-like III', map_location='3p14.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=58192626, end_position_on_the_genomic_accession=58211003, orientation='minus', exon_count=8, OMIM=602244, no_hdr0=''),
  1777 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1777, CurrentID=0, Status='live', Symbol='DNASE2', Aliases='DNASE2A, DNL, DNL2', description='deoxyribonuclease II, lysosomal', other_designations='DNase II alpha|DNase II, lysosomal|R31240_2|acid DNase|deoxyribonuclease II alpha|lysosomal DNase II', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12875211, end_position_on_the_genomic_accession=12881521, orientation='minus', exon_count=6, OMIM=126350, no_hdr0=''),
  1778 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1778, CurrentID=0, Status='live', Symbol='DYNC1H1', Aliases='CMT2O, DHC1, DHC1a, DNCH1, DNCL, DNECL, DYHC, Dnchc1, HL-3, SMALED1, p22', description='dynein, cytoplasmic 1, heavy chain 1', other_designations='dynein heavy chain, cytosolic|dynein, cytoplasmic, heavy polypeptide 1', map_location='14q32', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=101964528, end_position_on_the_genomic_accession=102050798, orientation='plus', exon_count=78, OMIM=600112, no_hdr0=''),
  132851 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132851, CurrentID=0, Status='live', Symbol='SPATA4', Aliases='SPEF1B, TSARG2', description='spermatogenesis associated 4', other_designations='testis and spermatogenesis cell related protein 2|testis and spermatogenesis cell-related protein 2|testis spermatocyte apoptosis-related gene 2 protein', map_location='4q34.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=176184574, end_position_on_the_genomic_accession=176195671, orientation='minus', exon_count=6, OMIM=609879, no_hdr0=''),
  1780 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1780, CurrentID=0, Status='live', Symbol='DYNC1I1', Aliases='DNCI1, DNCIC1', description='dynein, cytoplasmic 1, intermediate chain 1', other_designations='DH IC-1|cytoplasmic dynein intermediate chain 1|dynein intermediate chain 1, cytosolic|dynein, cytoplasmic, intermediate polypeptide 1', map_location='7q21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=95772506, end_position_on_the_genomic_accession=96110322, orientation='plus', exon_count=21, OMIM=603772, no_hdr0=''),
  1781 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1781, CurrentID=0, Status='live', Symbol='DYNC1I2', Aliases='DNCI2, IC2', description='dynein, cytoplasmic 1, intermediate chain 2', other_designations='DH IC-2|dynein intermediate chain 2, cytosolic|dynein, cytoplasmic, intermediate polypeptide 2', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=171687409, end_position_on_the_genomic_accession=171750158, orientation='plus', exon_count=19, OMIM=603331, no_hdr0=''),
  1783 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1783, CurrentID=0, Status='live', Symbol='DYNC1LI2', Aliases='DNCLI2, LIC2', description='dynein, cytoplasmic 1, light intermediate chain 2', other_designations='LIC-2|LIC53/55|dynein light intermediate chain 2, cytosolic|dynein, cytoplasmic, light intermediate polypeptide 2', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=66720893, end_position_on_the_genomic_accession=66751622, orientation='minus', exon_count=14, OMIM=611406, no_hdr0=''),
  1785 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1785, CurrentID=0, Status='live', Symbol='DNM2', Aliases='CMT2M, CMTDI1, CMTDIB, DI-CMTB, DYN2, DYNII, LCCS5', description='dynamin 2', other_designations='dynamin II', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=10718053, end_position_on_the_genomic_accession=10831910, orientation='plus', exon_count=22, OMIM=602378, no_hdr0=''),
  1786 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1786, CurrentID=0, Status='live', Symbol='DNMT1', Aliases='ADCADN, AIM, CXXC9, DNMT, HSN1E, MCMT, m.HsaI', description='DNA (cytosine-5-)-methyltransferase 1', other_designations='CXXC-type zinc finger protein 9|DNA MTase HsaI|DNA methyltransferase HsaI', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=10133345, end_position_on_the_genomic_accession=10195079, orientation='minus', exon_count=42, OMIM=126375, no_hdr0=''),
  1787 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1787, CurrentID=0, Status='live', Symbol='TRDMT1', Aliases='DMNT2, DNMT2, MHSAIIP, PUMET, RNMT1', description='tRNA aspartic acid methyltransferase 1', other_designations='DNA (cytosine-5)-methyltransferase-like protein 2|DNA MTase homolog HsaIIP|DNA cytosine-5 methyltransferase 2|DNA methyltransferase-2|tRNA (cytosine-5-)-methyltransferase|tRNA aspartic acid methyltransferase 1 variant 6|tRNA aspartic acid methyltransferase 1 variant 7', map_location='10p15.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=17137802, end_position_on_the_genomic_accession=17202071, orientation='minus', exon_count=16, OMIM=602478, no_hdr0=''),
  1788 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1788, CurrentID=0, Status='live', Symbol='DNMT3A', Aliases='DNMT3A2, M.HsaIIIA, TBRS', description='DNA (cytosine-5-)-methyltransferase 3 alpha', other_designations='DNA MTase HsaIIIA|DNA cytosine methyltransferase 3A2', map_location='2p23', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=25232961, end_position_on_the_genomic_accession=25342590, orientation='minus', exon_count=33, OMIM=602769, no_hdr0=''),
  1789 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1789, CurrentID=0, Status='live', Symbol='DNMT3B', Aliases='ICF, ICF1, M.HsaIIIB', description='DNA (cytosine-5-)-methyltransferase 3 beta', other_designations='DNA MTase HsaIIIB|DNA methyltransferase HsaIIIB', map_location='20q11.2', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=32762385, end_position_on_the_genomic_accession=32809356, orientation='plus', exon_count=24, OMIM=602900, no_hdr0=''),
  55659 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=55659, CurrentID=0, Status='live', Symbol='ZNF416', Aliases='', description='zinc finger protein 416', other_designations='', map_location='19q13.4', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=57571010, end_position_on_the_genomic_accession=57579180, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  1791 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1791, CurrentID=0, Status='live', Symbol='DNTT', Aliases='TDT', description='DNA nucleotidylexotransferase', other_designations='deoxynucleotidyltransferase, terminal|nucleosidetriphosphate:DNA deoxynucleotidylexotransferase|terminal addition enzyme|terminal deoxynucleotidyltransferase|terminal deoxyribonucleotidyltransferase|terminal transferase', map_location='10q23-q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=96304328, end_position_on_the_genomic_accession=96338564, orientation='plus', exon_count=11, OMIM=187410, no_hdr0=''),
  132864 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132864, CurrentID=0, Status='live', Symbol='CPEB2', Aliases='CPE-BP2, CPEB-2, hCPEB-2', description='cytoplasmic polyadenylation element binding protein 2', other_designations='CPE-binding protein 2', map_location='4p15.33', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=15002451, end_position_on_the_genomic_accession=15070153, orientation='plus', exon_count=14, OMIM=610605, no_hdr0=''),
  1793 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1793, CurrentID=0, Status='live', Symbol='DOCK1', Aliases='DOCK180, ced5', description='dedicator of cytokinesis 1', other_designations='180 kDa protein downstream of CRK|DOwnstream of CrK', map_location='10q26.13-q26.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=126905409, end_position_on_the_genomic_accession=127452517, orientation='plus', exon_count=57, OMIM=601403, no_hdr0=''),
  1794 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1794, CurrentID=0, Status='live', Symbol='DOCK2', Aliases='IMD40', description='dedicator of cytokinesis 2', other_designations='dedicator of cyto-kinesis 2', map_location='5q35.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=169637247, end_position_on_the_genomic_accession=170083382, orientation='plus', exon_count=58, OMIM=603122, no_hdr0=''),
  1795 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1795, CurrentID=0, Status='live', Symbol='DOCK3', Aliases='MOCA, PBP', description='dedicator of cytokinesis 3', other_designations='modifier of cell adhesion|presenilin-binding protein', map_location='3p21.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=50674969, end_position_on_the_genomic_accession=51384198, orientation='plus', exon_count=59, OMIM=603123, no_hdr0=''),
  1796 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1796, CurrentID=0, Status='live', Symbol='DOK1', Aliases='P62DOK, pp62', description='docking protein 1', other_designations='Downstream of tyrosine kinase 1|docking protein 1 (downstream of tyrosine kinase 1)|docking protein 1, 62kDa (downstream of tyrosine kinase 1)', map_location='2p13', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=74548205, end_position_on_the_genomic_accession=74557551, orientation='plus', exon_count=6, OMIM=602919, no_hdr0=''),
  1797 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1797, CurrentID=0, Status='live', Symbol='DXO', Aliases='DOM3L, DOM3Z, NG6, RAI1', description='decapping exoribonuclease', other_designations='protein Dom3Z', map_location='6p21.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31969811, end_position_on_the_genomic_accession=31972290, orientation='minus', exon_count=7, OMIM=605996, no_hdr0=''),
  1798 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1798, CurrentID=0, Status='live', Symbol='DPAGT1', Aliases='ALG7, CDG-Ij, CDG1J, CMS13, CMSTA2, D11S366, DGPT, DPAGT, DPAGT2, G1PT, GPT, UAGT, UGAT', description='dolichyl-phosphate N-acetylglucosaminephosphotransferase 1', other_designations='GlcNAc-1-P transferase|N-acetylglucosamine-1-phosphate transferase|UDP-GlcNAc:dolichyl-phosphate N-acetylglucosaminephosphotransferase|dolichyl-phosphate (UDP-N-acetylglucosamine) N-acetylglucosaminephosphotransferase 1 (GlcNAc-1-P tra|dolichyl-phosphate (UDP-N-acetylglucosamine) N-acetylglucosaminephosphotransferase 1 (GlcNAc-1-P transferase)|dolichyl-phosphate alpha-N-acetylglucosaminyltransferase', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=119096503, end_position_on_the_genomic_accession=119102414, orientation='minus', exon_count=9, OMIM=191350, no_hdr0=''),
  1800 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1800, CurrentID=0, Status='live', Symbol='DPEP1', Aliases='MBD1, MDP, RDP', description='dipeptidase 1 (renal)', other_designations='dehydropeptidase-I|hRDP|microsomal dipeptidase|renal dipeptidase', map_location='16q24.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=89613308, end_position_on_the_genomic_accession=89640862, orientation='plus', exon_count=16, OMIM=179780, no_hdr0=''),
  1801 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1801, CurrentID=0, Status='live', Symbol='DPH1', Aliases='DPH2L, DPH2L1, OVCA1', description='diphthamide biosynthesis 1', other_designations='DPH-like 1|DPH1 homolog|DPH2-like 1|candidate tumor suppressor in ovarian cancer 1|diphthamide biosynthesis protein 2 homolog-like 1|diptheria toxin resistance protein required for diphthamide biosynthesis (Saccharomyces)-like 1|diptheria toxin resistance protein required for diphthamide biosynthesis-like 1|ovarian cancer-associated gene 1 protein|ovarian tumor suppressor candidate 1', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=2030137, end_position_on_the_genomic_accession=2043431, orientation='plus', exon_count=13, OMIM=603527, no_hdr0=''),
  1802 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1802, CurrentID=0, Status='live', Symbol='DPH2', Aliases='DPH2L2', description='DPH2 homolog', other_designations='DPH2-like 2|diphthamide biosynthesis protein 2 homolog-like 2|diphthamide biosynthesis-like protein 2|diptheria toxin resistance protein required for diphthamide biosynthesis-like 2', map_location='1p34', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=43969981, end_position_on_the_genomic_accession=43973371, orientation='plus', exon_count=6, OMIM=603456, no_hdr0=''),
  1803 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1803, CurrentID=0, Status='live', Symbol='DPP4', Aliases='ADABP, ADCP2, CD26, DPPIV, TP103', description='dipeptidyl peptidase 4', other_designations='ADCP-2|DPP IV|T-cell activation antigen CD26|adenosine deaminase complexing protein 2|dipeptidyl peptidase IV|dipeptidylpeptidase 4|dipeptidylpeptidase IV (CD26, adenosine deaminase complexing protein 2)', map_location='2q24.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=161992241, end_position_on_the_genomic_accession=162074542, orientation='minus', exon_count=26, OMIM=102720, no_hdr0=''),
  1804 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1804, CurrentID=0, Status='live', Symbol='DPP6', Aliases='DPPX, MRD33, VF2', description='dipeptidyl peptidase like 6', other_designations='DPP VI|dipeptidyl aminopeptidase IV-related protein|dipeptidyl peptidase IV-related protein|dipeptidyl peptidase VI|dipeptidyl-peptidase 6', map_location='7q36.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=153887097, end_position_on_the_genomic_accession=154894290, orientation='plus', exon_count=30, OMIM=126141, no_hdr0=''),
  1805 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1805, CurrentID=0, Status='live', Symbol='DPT', Aliases='TRAMP', description='dermatopontin', other_designations='tyrosine-rich acidic matrix protein', map_location='1q12-q23', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=168695457, end_position_on_the_genomic_accession=168729204, orientation='minus', exon_count=4, OMIM=125597, no_hdr0=''),
  1806 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1806, CurrentID=0, Status='live', Symbol='DPYD', Aliases='DHP, DHPDHASE, DPD', description='dihydropyrimidine dehydrogenase', other_designations='dihydrothymine dehydrogenase|dihydrouracil dehydrogenase', map_location='1p22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=97077743, end_position_on_the_genomic_accession=97921059, orientation='minus', exon_count=25, OMIM=612779, no_hdr0=''),
  1807 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1807, CurrentID=0, Status='live', Symbol='DPYS', Aliases='DHP, DHPase', description='dihydropyrimidinase', other_designations='dihydropyrimidine amidohydrolase|hydantoinase', map_location='8q22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=104379424, end_position_on_the_genomic_accession=104467049, orientation='minus', exon_count=13, OMIM=613326, no_hdr0=''),
  1808 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1808, CurrentID=0, Status='live', Symbol='DPYSL2', Aliases='CRMP-2, CRMP2, DHPRP2, DRP-2, DRP2, N2A3, ULIP-2, ULIP2', description='dihydropyrimidinase like 2', other_designations='collapsin response mediator protein hCRMP-2|unc-33-like phosphoprotein 2', map_location='8p22-p21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=26514193, end_position_on_the_genomic_accession=26658177, orientation='plus', exon_count=16, OMIM=602463, no_hdr0=''),
  1809 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1809, CurrentID=0, Status='live', Symbol='DPYSL3', Aliases='CRMP-4, CRMP4, DRP-3, DRP3, LCRMP, ULIP, ULIP-1', description='dihydropyrimidinase like 3', other_designations='collapsin response mediator protein 4 long|dihydropyrimidinase-like 3|unc-33-like phosphoprotein 1', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=147390808, end_position_on_the_genomic_accession=147510260, orientation='minus', exon_count=16, OMIM=601168, no_hdr0=''),
  1810 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1810, CurrentID=0, Status='live', Symbol='DR1', Aliases='NC2, NC2-BETA', description='down-regulator of transcription 1', other_designations='TATA-binding protein-associated phosphoprotein|down-regulator of transcription 1, TBP-binding (negative cofactor 2)|negative cofactor 2-beta', map_location='1p22.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=93345921, end_position_on_the_genomic_accession=93362592, orientation='plus', exon_count=3, OMIM=601482, no_hdr0=''),
  1811 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1811, CurrentID=0, Status='live', Symbol='SLC26A3', Aliases='CLD, DRA', description='solute carrier family 26 member 3', other_designations='down-regulated in adenoma protein|solute carrier family 26 (anion exchanger), member 3|solute carrier family 26, member 3', map_location='7q31', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=107765467, end_position_on_the_genomic_accession=107803233, orientation='minus', exon_count=21, OMIM=126650, no_hdr0=''),
  1812 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1812, CurrentID=0, Status='live', Symbol='DRD1', Aliases='DADRA, DRD1', description='dopamine receptor D1', other_designations='dopamine D1 receptor', map_location='5q35.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=175440672, end_position_on_the_genomic_accession=175444160, orientation='minus', exon_count=2, OMIM=126449, no_hdr0=''),
  1813 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1813, CurrentID=0, Status='live', Symbol='DRD2', Aliases='D2DR, D2R', description='dopamine receptor D2', other_designations='dopamine D2 receptor|dopamine receptor D2 isoform|seven transmembrane helix receptor', map_location='11q23', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=113409595, end_position_on_the_genomic_accession=113475279, orientation='minus', exon_count=8, OMIM=126450, no_hdr0=''),
  1814 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1814, CurrentID=0, Status='live', Symbol='DRD3', Aliases='D3DR, ETM1, FET1', description='dopamine receptor D3', other_designations='essential tremor 1', map_location='3q13.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=114127797, end_position_on_the_genomic_accession=114199407, orientation='minus', exon_count=12, OMIM=126451, no_hdr0=''),
  1815 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1815, CurrentID=0, Status='live', Symbol='DRD4', Aliases='D4DR', description='dopamine receptor D4', other_designations='D(2C) dopamine receptor|dopamine D4 receptor|seven transmembrane helix receptor', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=637305, end_position_on_the_genomic_accession=640706, orientation='plus', exon_count=4, OMIM=126452, no_hdr0=''),
  1816 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1816, CurrentID=0, Status='live', Symbol='DRD5', Aliases='DBDR, DRD1B, DRD1L2', description='dopamine receptor D5', other_designations='D1beta dopamine receptor|d(5) dopamine receptor|dopamine D5 receptor|dopamine receptor D1B', map_location='4p16.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=9781634, end_position_on_the_genomic_accession=9784009, orientation='plus', exon_count=1, OMIM=126453, no_hdr0=''),
  1819 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1819, CurrentID=0, Status='live', Symbol='DRG2', Aliases='', description='developmentally regulated GTP binding protein 2', other_designations='', map_location='17p11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=18087867, end_position_on_the_genomic_accession=18107985, orientation='plus', exon_count=13, OMIM=602986, no_hdr0=''),
  1820 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1820, CurrentID=0, Status='live', Symbol='ARID3A', Aliases='BRIGHT, DRIL1, DRIL3, E2FBP1', description='AT-rich interaction domain 3A', other_designations='ARID domain-containing 3A|ARID domain-containing protein 3A|AT rich interactive domain 3A (BRIGHT- like) protein|AT rich interactive domain 3A (BRIGHT-like)|B-cell regulator of IgH transcription|E2F-binding protein 1|dead ringer-like 1|dead ringer-like protein 1', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=926037, end_position_on_the_genomic_accession=972816, orientation='plus', exon_count=11, OMIM=603265, no_hdr0=''),
  1821 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1821, CurrentID=0, Status='live', Symbol='DRP2', Aliases='DRP-2', description='dystrophin related protein 2', other_designations='', map_location='Xq22', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=101219944, end_position_on_the_genomic_accession=101264496, orientation='plus', exon_count=24, OMIM=300052, no_hdr0=''),
  1822 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1822, CurrentID=0, Status='live', Symbol='ATN1', Aliases='B37, D12S755E, DRPLA, HRS, NOD', description='atrophin 1', other_designations='dentatorubral-pallidoluysian atrophy protein', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6924463, end_position_on_the_genomic_accession=6942321, orientation='plus', exon_count=11, OMIM=607462, no_hdr0=''),
  1823 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1823, CurrentID=0, Status='live', Symbol='DSC1', Aliases='CDHF1, DG2/DG3', description='desmocollin 1', other_designations='cadherin family member 1|desmosomal glycoprotein 2/3', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31129236, end_position_on_the_genomic_accession=31162856, orientation='minus', exon_count=17, OMIM=125643, no_hdr0=''),
  1824 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1824, CurrentID=0, Status='live', Symbol='DSC2', Aliases='ARVD11, CDHF2, DG2, DGII/III, DSC3', description='desmocollin 2', other_designations='cadherin family member 2|desmosomal glycoprotein II/III', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31065974, end_position_on_the_genomic_accession=31102432, orientation='minus', exon_count=18, OMIM=125645, no_hdr0=''),
  1825 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1825, CurrentID=0, Status='live', Symbol='DSC3', Aliases='CDHF3, DSC, DSC1, DSC2, DSC4, HT-CP', description='desmocollin 3', other_designations='cadherin family member 3|desmocollin-4', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=30989365, end_position_on_the_genomic_accession=31042815, orientation='minus', exon_count=17, OMIM=600271, no_hdr0=''),
  1826 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1826, CurrentID=0, Status='live', Symbol='DSCAM', Aliases='CHD2, CHD2-42, CHD2-52', description='Down syndrome cell adhesion molecule', other_designations='', map_location='21q22.2', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=40010999, end_position_on_the_genomic_accession=40847113, orientation='minus', exon_count=33, OMIM=602523, no_hdr0=''),
  1827 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1827, CurrentID=0, Status='live', Symbol='RCAN1', Aliases='ADAPT78, CSP1, DSC1, DSCR1, MCIP1, RCN1', description='regulator of calcineurin 1', other_designations='Down syndrome candidate region 1|Down syndrome critical region gene 1|calcium and oxidant-inducible mRNA|modulatory calcineurin-interacting protein 1|myocyte-enriched calcineurin-interacting protein 1|near DSCR proline-rich protein', map_location='21q22.12', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=34516442, end_position_on_the_genomic_accession=34615142, orientation='minus', exon_count=9, OMIM=602917, no_hdr0=''),
  1828 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1828, CurrentID=0, Status='live', Symbol='DSG1', Aliases='CDHF4, DG1, DSG, EPKHE, EPKHIA, PPKS1, SPPK1', description='desmoglein 1', other_designations='cadherin family member 4|desmosomal glycoprotein 1|pemphigus foliaceus antigen', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31318089, end_position_on_the_genomic_accession=31359246, orientation='plus', exon_count=15, OMIM=125670, no_hdr0=''),
  1829 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1829, CurrentID=0, Status='live', Symbol='DSG2', Aliases='CDHF5, HDGC', description='desmoglein 2', other_designations='cadherin family member 5', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31498064, end_position_on_the_genomic_accession=31548851, orientation='plus', exon_count=15, OMIM=125671, no_hdr0=''),
  1830 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1830, CurrentID=0, Status='live', Symbol='DSG3', Aliases='CDHF6, PVA', description='desmoglein 3', other_designations='130 kDa pemphigus vulgaris antigen|cadherin family member 6', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31447769, end_position_on_the_genomic_accession=31478702, orientation='plus', exon_count=16, OMIM=169615, no_hdr0=''),
  1831 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1831, CurrentID=0, Status='live', Symbol='TSC22D3', Aliases='DIP, DSIPI, GILZ, TSC-22R', description='TSC22 domain family member 3', other_designations='DSIP-immunoreactive leucine zipper protein|DSIP-immunoreactive peptide|TSC-22 related protein|TSC-22-like protein|TSC-22-related protein|TSC22 domain family, member 3|delta sleep inducing peptide, immunoreactor|delta sleep-inducing peptide immunoreactor|glucocorticoid-induced leucine zipper protein', map_location='Xq22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=107713221, end_position_on_the_genomic_accession=107777329, orientation='minus', exon_count=9, OMIM=300506, no_hdr0=''),
  1832 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1832, CurrentID=0, Status='live', Symbol='DSP', Aliases='DCWHKTA, DP', description='desmoplakin', other_designations='250/210 kDa paraneoplastic pemphigus antigen', map_location='6p24', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=7541575, end_position_on_the_genomic_accession=7586713, orientation='plus', exon_count=24, OMIM=125647, no_hdr0=''),
  1833 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1833, CurrentID=0, Status='live', Symbol='EPYC', Aliases='DSPG3, PGLB, Pg-Lb, SLRR3B', description='epiphycan', other_designations='dermatan sulfate proteoglycan 3|epiphycan proteoglycan|proteoglycan-lb|small chondroitin/dermatan sulfate proteoglycan', map_location='12q21', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=90963679, end_position_on_the_genomic_accession=91007906, orientation='minus', exon_count=9, OMIM=601657, no_hdr0=''),
  1834 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1834, CurrentID=0, Status='live', Symbol='DSPP', Aliases='DFNA39, DGI1, DMP3, DPP, DSP', description='dentin sialophosphoprotein', other_designations='dentin phosphophoryn|dentin phosphoprotein|dentin phosphoryn|dentin sialoprotein', map_location='4q21.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=87608529, end_position_on_the_genomic_accession=87616873, orientation='plus', exon_count=5, OMIM=125485, no_hdr0=''),
  1836 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1836, CurrentID=0, Status='live', Symbol='SLC26A2', Aliases='D5S1708, DTD, DTDST, EDM4, MST153, MSTP157', description='solute carrier family 26 (anion exchanger), member 2', other_designations='diastrophic dysplasia protein|solute carrier family 26 (sulfate transporter), member 2|sulfate anion transporter 1', map_location='5q31-q34', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=149960737, end_position_on_the_genomic_accession=149987400, orientation='plus', exon_count=3, OMIM=606718, no_hdr0=''),
  1837 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1837, CurrentID=0, Status='live', Symbol='DTNA', Aliases='D18S892E, DRP3, DTN, DTN-A, LVNC1', description='dystrobrevin alpha', other_designations='dystrobrevin, alpha|dystrophin-related protein 3', map_location='18q12', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=34493290, end_position_on_the_genomic_accession=34891844, orientation='plus', exon_count=32, OMIM=601239, no_hdr0=''),
  1838 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1838, CurrentID=0, Status='live', Symbol='DTNB', Aliases='', description='dystrobrevin beta', other_designations='DTN-B|beta-dystrobrevin|dystrobrevin, beta', map_location='2p24', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=25377198, end_position_on_the_genomic_accession=25673647, orientation='minus', exon_count=27, OMIM=602415, no_hdr0=''),
  1839 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1839, CurrentID=0, Status='live', Symbol='HBEGF', Aliases='DTR, DTS, DTSF, HEGFL', description='heparin binding EGF like growth factor', other_designations='diphtheria toxin receptor (heparin-binding EGF-like growth factor)|diphtheria toxin receptor (heparin-binding epidermal growth factor-like growth factor)|heparin-binding EGF-like growth factor|heparin-binding epidermal growth factor', map_location='5q23', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=140332843, end_position_on_the_genomic_accession=140346603, orientation='minus', exon_count=6, OMIM=126150, no_hdr0=''),
  1840 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1840, CurrentID=0, Status='live', Symbol='DTX1', Aliases='hDx-1', description='deltex 1, E3 ubiquitin ligase', other_designations='deltex homolog 1|deltex1|hDTX1|protein deltex-1', map_location='12q24.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=113056714, end_position_on_the_genomic_accession=113098028, orientation='plus', exon_count=10, OMIM=602582, no_hdr0=''),
  1841 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1841, CurrentID=0, Status='live', Symbol='DTYMK', Aliases='CDC8, PP3731, TMPK, TYMK', description='deoxythymidylate kinase', other_designations='dTMP kinase|deoxythymidylate kinase (thymidylate kinase)', map_location='2q37.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=241675742, end_position_on_the_genomic_accession=241686968, orientation='minus', exon_count=5, OMIM=188345, no_hdr0=''),
  1842 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1842, CurrentID=0, Status='live', Symbol='ECM2', Aliases='', description='extracellular matrix protein 2, female organ and adipocyte specific', other_designations='matrix glycoprotein SC1/ECM2', map_location='9q22.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=92493547, end_position_on_the_genomic_accession=92536092, orientation='minus', exon_count=11, OMIM=603479, no_hdr0=''),
  1843 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1843, CurrentID=0, Status='live', Symbol='DUSP1', Aliases='CL100, HVH1, MKP-1, MKP1, PTPN10', description='dual specificity phosphatase 1', other_designations='CL 100|MAP kinase phosphatase 1|dual specificity protein phosphatase hVH1|mitogen-activated protein kinase phosphatase 1|protein-tyrosine phosphatase CL100|serine/threonine specific protein phosphatase', map_location='5q34', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=172768090, end_position_on_the_genomic_accession=172771200, orientation='minus', exon_count=4, OMIM=600714, no_hdr0=''),
  1844 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1844, CurrentID=0, Status='live', Symbol='DUSP2', Aliases='PAC-1, PAC1', description='dual specificity phosphatase 2', other_designations='dual specificity protein phosphatase PAC-1|dual-specificity phosphatase 2|serine/threonine specific protein phosphatase', map_location='2q11', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=96143169, end_position_on_the_genomic_accession=96145440, orientation='minus', exon_count=4, OMIM=603068, no_hdr0=''),
  1845 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1845, CurrentID=0, Status='live', Symbol='DUSP3', Aliases='VHR', description='dual specificity phosphatase 3', other_designations='dual specificity protein phosphatase VHR|serine/threonine specific protein phosphatase|vaccinia H1-related phosphatase|vaccinia virus phosphatase VH1-related', map_location='17q21', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43766121, end_position_on_the_genomic_accession=43779000, orientation='minus', exon_count=3, OMIM=600183, no_hdr0=''),
  1846 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1846, CurrentID=0, Status='live', Symbol='DUSP4', Aliases='HVH2, MKP-2, MKP2, TYP', description='dual specificity phosphatase 4', other_designations='MAP kinase phosphatase 2|VH1 homologous phosphatase 2|dual specificity protein phosphatase hVH2|mitogen-activated protein kinase phosphatase 2|serine/threonine specific protein phosphatase', map_location='8p12-p11', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=29333062, end_position_on_the_genomic_accession=29350750, orientation='minus', exon_count=6, OMIM=602747, no_hdr0=''),
  1847 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1847, CurrentID=0, Status='live', Symbol='DUSP5', Aliases='DUSP, HVH3', description='dual specificity phosphatase 5', other_designations='VH1-like phosphatase 3|dual specificity protein phosphatase hVH3|serine/threonine specific protein phosphatase', map_location='10q25', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=110497867, end_position_on_the_genomic_accession=110511544, orientation='plus', exon_count=4, OMIM=603069, no_hdr0=''),
  1848 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1848, CurrentID=0, Status='live', Symbol='DUSP6', Aliases='HH19, MKP3, PYST1', description='dual specificity phosphatase 6', other_designations='MAP kinase phosphatase 3|dual specificity protein phosphatase PYST1|mitogen-activated protein kinase phosphatase 3|serine/threonine specific protein phosphatase', map_location='12q21.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=89347825, end_position_on_the_genomic_accession=89352859, orientation='minus', exon_count=3, OMIM=602748, no_hdr0=''),
  1849 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1849, CurrentID=0, Status='live', Symbol='DUSP7', Aliases='MKPX, PYST2', description='dual specificity phosphatase 7', other_designations='dual specificity protein phosphatase PYST2|dual-specificity phosphatase-7', map_location='3p21', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=52048919, end_position_on_the_genomic_accession=52056445, orientation='minus', exon_count=3, OMIM=602749, no_hdr0=''),
  1850 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1850, CurrentID=0, Status='live', Symbol='DUSP8', Aliases='C11orf81, HB5, HVH-5, HVH8', description='dual specificity phosphatase 8', other_designations='H1 phosphatase, vaccinia virus homolog|dual specificity protein phosphatase hVH-5|serine/threonine specific protein phosphatase', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=1554051, end_position_on_the_genomic_accession=1572831, orientation='minus', exon_count=9, OMIM=602038, no_hdr0=''),
  1852 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1852, CurrentID=0, Status='live', Symbol='DUSP9', Aliases='MKP-4, MKP4', description='dual specificity phosphatase 9', other_designations='map kinase phosphatase 4|mitogen-activated protein kinase phosphatase 4|serine/threonine specific protein phosphatase', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153642443, end_position_on_the_genomic_accession=153651326, orientation='plus', exon_count=7, OMIM=300134, no_hdr0=''),
  100996746 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100996746, CurrentID=0, Status='live', Symbol='SPDYE11', Aliases='', description='speedy/RINGO cell cycle regulator family member E11', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=73049244, end_position_on_the_genomic_accession=73057172, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  1854 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1854, CurrentID=0, Status='live', Symbol='DUT', Aliases='dUTPase', description='deoxyuridine triphosphatase', other_designations='dUTP diphosphatase|dUTP nucleotidohydrolase|dUTP pyrophosphatase', map_location='15q21.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=48331100, end_position_on_the_genomic_accession=48343373, orientation='plus', exon_count=8, OMIM=601266, no_hdr0=''),
  1855 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1855, CurrentID=0, Status='live', Symbol='DVL1', Aliases='DRS2, DVLL1, DVL1P1, DVL1', description='dishevelled segment polarity protein 1', other_designations='DSH homolog 1|dishevelled 1 (homologous to Drosophila dsh)|dishevelled, dsh homolog 1|dishevelled-1', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=1335278, end_position_on_the_genomic_accession=1349158, orientation='minus', exon_count=16, OMIM=601365, no_hdr0=''),
  1856 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1856, CurrentID=0, Status='live', Symbol='DVL2', Aliases='', description='dishevelled segment polarity protein 2', other_designations='dishevelled 2 (homologous to Drosophila dsh)|dishevelled, dsh homolog 2', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7225342, end_position_on_the_genomic_accession=7234548, orientation='minus', exon_count=16, OMIM=602151, no_hdr0=''),
  1857 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1857, CurrentID=0, Status='live', Symbol='DVL3', Aliases='', description='dishevelled segment polarity protein 3', other_designations='DSH homolog 3|dishevelled 3 (homologous to Drosophila dsh)|dishevelled, dsh homolog 3|dishevelled-3', map_location='3q27', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184155311, end_position_on_the_genomic_accession=184173526, orientation='plus', exon_count=15, OMIM=601368, no_hdr0=''),
  1859 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1859, CurrentID=0, Status='live', Symbol='DYRK1A', Aliases='DYRK, DYRK1, HP86, MNB, MNBH, MRD7', description='dual specificity tyrosine phosphorylation regulated kinase 1A', other_designations='MNB/DYRK protein kinase|dual specificity YAK1-related kinase|dual specificity tyrosine-(Y)-phosphorylation regulated kinase 1A|hMNB|mnb protein kinase homolog hp86|protein kinase minibrain homolog|serine/threonine kinase MNB|serine/threonine-specific protein kinase', map_location='21q22.13', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=37365790, end_position_on_the_genomic_accession=37515376, orientation='plus', exon_count=18, OMIM=600855, no_hdr0=''),
  1861 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1861, CurrentID=0, Status='live', Symbol='TOR1A', Aliases='DQ2, DYT1', description='torsin family 1 member A', other_designations='dystonia 1 protein|dystonia 1, torsion (autosomal dominant; torsin A)|torsin A|torsin ATPase 1|torsin ATPase-1A|torsin family 1, member A (torsin A)', map_location='9q34', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=129812942, end_position_on_the_genomic_accession=129824245, orientation='minus', exon_count=5, OMIM=605204, no_hdr0=''),
  100873985 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100873985, CurrentID=0, Status='live', Symbol='MED14OS', Aliases='MED14-AS1', description='MED14 opposite strand', other_designations='MED14 antisense RNA 1', map_location='Xp11.4', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=40735396, end_position_on_the_genomic_accession=40738701, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  1869 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1869, CurrentID=0, Status='live', Symbol='E2F1', Aliases='E2F-1, RBAP1, RBBP3, RBP3', description='E2F transcription factor 1', other_designations='PBR3|PRB-binding protein E2F-1|RBAP-1|RBBP-3|retinoblastoma-associated protein 1|retinoblastoma-binding protein 3', map_location='20q11.2', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=33675486, end_position_on_the_genomic_accession=33686404, orientation='minus', exon_count=7, OMIM=189971, no_hdr0=''),
  1870 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1870, CurrentID=0, Status='live', Symbol='E2F2', Aliases='E2F-2', description='E2F transcription factor 2', other_designations='', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=23505974, end_position_on_the_genomic_accession=23531250, orientation='minus', exon_count=10, OMIM=600426, no_hdr0=''),
  1871 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1871, CurrentID=0, Status='live', Symbol='E2F3', Aliases='E2F-3', description='E2F transcription factor 3', other_designations='', map_location='6p22', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=20401906, end_position_on_the_genomic_accession=20493714, orientation='plus', exon_count=11, OMIM=600427, no_hdr0=''),
  1874 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1874, CurrentID=0, Status='live', Symbol='E2F4', Aliases='E2F-4', description='E2F transcription factor 4', other_designations='E2F transcription factor 4, p107/p130-binding|p107/p130-binding protein', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=67192165, end_position_on_the_genomic_accession=67198918, orientation='plus', exon_count=10, OMIM=600659, no_hdr0=''),
  1875 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1875, CurrentID=0, Status='live', Symbol='E2F5', Aliases='E2F-5', description='E2F transcription factor 5', other_designations='E2F transcription factor 5, p130-binding', map_location='8q21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=85177056, end_position_on_the_genomic_accession=85214518, orientation='plus', exon_count=10, OMIM=600967, no_hdr0=''),
  1876 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1876, CurrentID=0, Status='live', Symbol='E2F6', Aliases='E2F-6', description='E2F transcription factor 6', other_designations='', map_location='2p25.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=11444375, end_position_on_the_genomic_accession=11466177, orientation='minus', exon_count=9, OMIM=602944, no_hdr0=''),
  1877 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1877, CurrentID=0, Status='live', Symbol='E4F1', Aliases='E4F', description='E4F transcription factor 1', other_designations='p120E4F|p50E4F|putative E3 ubiquitin-protein ligase E4F1|transcription factor E4F', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2223488, end_position_on_the_genomic_accession=2235742, orientation='plus', exon_count=14, OMIM=603022, no_hdr0=''),
  1879 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1879, CurrentID=0, Status='live', Symbol='EBF1', Aliases='COE1, EBF, O/E-1, OLF1', description='early B-cell factor 1', other_designations='Collier, Olf and EBF transcription factor 1|OE-1|olfactory neuronal transcription factor 1', map_location='5q34', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=158695908, end_position_on_the_genomic_accession=159099780, orientation='minus', exon_count=21, OMIM=164343, no_hdr0=''),
  1880 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1880, CurrentID=0, Status='live', Symbol='GPR183', Aliases='EBI2', description='G protein-coupled receptor 183', other_designations='EBV-induced G-protein coupled receptor 2|Epstein-Barr virus induced gene 2 (lymphocyte-specific G protein-coupled receptor)|epstein-Barr virus-induced G-protein coupled receptor 2', map_location='13q32.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=99294535, end_position_on_the_genomic_accession=99307495, orientation='minus', exon_count=2, OMIM=605741, no_hdr0=''),
  165721 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=165721, CurrentID=0, Status='live', Symbol='DNAJB8', Aliases='CT156, DJ6', description='DnaJ heat shock protein family (Hsp40) member B8', other_designations='DnaJ (Hsp40) homolog, subfamily B, member 8', map_location='3q21.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=128462432, end_position_on_the_genomic_accession=128467248, orientation='minus', exon_count=3, OMIM=611337, no_hdr0=''),
  132954 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=132954, CurrentID=0, Status='live', Symbol='PDCL2', Aliases='GCPHLP', description='phosducin like 2', other_designations='phosducin-like 2', map_location='4q12', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=55556523, end_position_on_the_genomic_accession=55592268, orientation='minus', exon_count=7, OMIM=611676, no_hdr0=''),
  11237 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=11237, CurrentID=0, Status='live', Symbol='RNF24', Aliases='G1L', description='ring finger protein 24', other_designations='goliath-like protein (C3HC4 type)', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=3929918, end_position_on_the_genomic_accession=4015569, orientation='minus', exon_count=10, OMIM=612489, no_hdr0=''),
  1889 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1889, CurrentID=0, Status='live', Symbol='ECE1', Aliases='ECE', description='endothelin converting enzyme 1', other_designations='ECE-1', map_location='1p36.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=21217247, end_position_on_the_genomic_accession=21345541, orientation='minus', exon_count=23, OMIM=600423, no_hdr0=''),
  1890 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1890, CurrentID=0, Status='live', Symbol='TYMP', Aliases='ECGF, ECGF1, MEDPS1, MNGIE, MTDPS1, PDECGF, TP, hPD-ECGF', description='thymidine phosphorylase', other_designations='gliostatin|tdRPase', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50525752, end_position_on_the_genomic_accession=50530085, orientation='minus', exon_count=10, OMIM=131222, no_hdr0=''),
  1891 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1891, CurrentID=0, Status='live', Symbol='ECH1', Aliases='HPXEL', description='enoyl-CoA hydratase 1, peroxisomal', other_designations='delta3,5-delta2,4-dienoyl-CoA isomerase|dienoyl-CoA isomerase|enoyl CoA hydratase 1, peroxisomal|enoyl Coenzyme A hydratase 1, peroxisomal|peroxisomal enoyl-CoA hydratase 1', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=38815422, end_position_on_the_genomic_accession=38831857, orientation='minus', exon_count=10, OMIM=600696, no_hdr0=''),
  1892 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1892, CurrentID=0, Status='live', Symbol='ECHS1', Aliases='ECHS1D, SCEH', description='enoyl-CoA hydratase, short chain, 1, mitochondrial', other_designations='enoyl CoA hydratase, short chain, 1, mitochondrial|enoyl Coenzyme A hydratase, short chain, 1, mitochondrial', map_location='10q26.2-q26.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=133362483, end_position_on_the_genomic_accession=133373404, orientation='minus', exon_count=8, OMIM=602292, no_hdr0=''),
  1893 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1893, CurrentID=0, Status='live', Symbol='ECM1', Aliases='URBWD', description='extracellular matrix protein 1', other_designations='secretory component p85', map_location='1q21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150508011, end_position_on_the_genomic_accession=150513789, orientation='plus', exon_count=10, OMIM=602201, no_hdr0=''),
  1894 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1894, CurrentID=0, Status='live', Symbol='ECT2', Aliases='ARHGEF31', description='epithelial cell transforming 2', other_designations='epithelial cell transforming sequence 2 oncogene|epithelial cell-transforming sequence 2 oncogene', map_location='3q26.1-q26.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=172750682, end_position_on_the_genomic_accession=172829265, orientation='plus', exon_count=29, OMIM=600586, no_hdr0=''),
  1896 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1896, CurrentID=0, Status='live', Symbol='EDA', Aliases='ECTD1, ED1, ED1-A1, ED1-A2-A1, EDA-A2, EDA1, EDA2, HED, HED1, ODT1, STHAGX1, TNLG7C, XHED, XLHED, EDA', description='ectodysplasin A', other_designations='X-linked anhidroitic ectodermal dysplasia protein|oligodontia 1|tumor necrosis factor ligand 7C', map_location='Xq12-q13.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=69616067, end_position_on_the_genomic_accession=70039472, orientation='plus', exon_count=11, OMIM=300451, no_hdr0=''),
  100132474 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100132474, CurrentID=0, Status='live', Symbol='LOC100132474', Aliases='', description='uncharacterized LOC100132474', other_designations='', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.8', start_position_on_the_genomic_accession=9812452, end_position_on_the_genomic_accession=9813718, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  1901 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1901, CurrentID=0, Status='live', Symbol='S1PR1', Aliases='CD363, CHEDG1, D1S3362, ECGF1, EDG-1, EDG1, S1P1', description='sphingosine-1-phosphate receptor 1', other_designations='S1P receptor 1|S1P receptor Edg-1|endothelial differentiation G-protein coupled receptor 1|endothelial differentiation, sphingolipid G-protein-coupled receptor, 1|sphingosine 1-phosphate receptor EDG1|sphingosine 1-phosphate receptor Edg-1', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=101236749, end_position_on_the_genomic_accession=101241520, orientation='plus', exon_count=2, OMIM=601974, no_hdr0=''),
  1902 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1902, CurrentID=0, Status='live', Symbol='LPAR1', Aliases='EDG2, GPR26, Gpcr26, LPA1, Mrec1.3, VZG1, edg-2, rec.1.3, vzg-1', description='lysophosphatidic acid receptor 1', other_designations='LPA receptor 1|LPA-1|endothelial differentiation, lysophosphatidic acid G-protein-coupled receptor, 2|lysophosphatidic acid receptor Edg-2|ventricular zone gene 1', map_location='9q31.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=110873261, end_position_on_the_genomic_accession=111039243, orientation='minus', exon_count=7, OMIM=602282, no_hdr0=''),
  1903 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1903, CurrentID=0, Status='live', Symbol='S1PR3', Aliases='EDG-3, EDG3, LPB3, S1P3', description='sphingosine-1-phosphate receptor 3', other_designations='G protein-coupled receptor, endothelial differentiation gene-3|S1P receptor 3|S1P receptor EDG3|S1P receptor Edg-3|endothelial differentiation G-protein coupled receptor 3|endothelial differentiation, sphingolipid G-protein-coupled receptor, 3|sphingosine 1-phosphate receptor Edg-3', map_location='9q22.1-q22.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=88991409, end_position_on_the_genomic_accession=89005155, orientation='plus', exon_count=2, OMIM=601965, no_hdr0=''),
  284349 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284349, CurrentID=0, Status='live', Symbol='ZNF283', Aliases='HZF19, HZF41', description='zinc finger protein 283', other_designations='zinc finger protein 41|zinc finger protein HZF19', map_location='19q13.31', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=43827292, end_position_on_the_genomic_accession=43848898, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  1906 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1906, CurrentID=0, Status='live', Symbol='EDN1', Aliases='ARCND3, ET1, HDLCQ7, PPET1, QME', description='endothelin 1', other_designations='preproendothelin-1', map_location='6p24.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=12261214, end_position_on_the_genomic_accession=12297194, orientation='plus', exon_count=7, OMIM=131240, no_hdr0=''),
  1907 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1907, CurrentID=0, Status='live', Symbol='EDN2', Aliases='ET-2, ET2, PPET2', description='endothelin 2', other_designations='preproendothelin 2', map_location='1p34', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=41478775, end_position_on_the_genomic_accession=41484683, orientation='minus', exon_count=5, OMIM=131241, no_hdr0=''),
  1908 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1908, CurrentID=0, Status='live', Symbol='EDN3', Aliases='ET-3, ET3, HSCR4, PPET3, WS4B', description='endothelin 3', other_designations='preproendothelin-3', map_location='20q13.2-q13.3', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=59300424, end_position_on_the_genomic_accession=59325992, orientation='plus', exon_count=6, OMIM=131242, no_hdr0=''),
  1909 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1909, CurrentID=0, Status='live', Symbol='EDNRA', Aliases='ET-A, ETA, ETA-R, ETAR, ETRA, MFDA, hET-AR', description='endothelin receptor type A', other_designations='G protein-coupled receptor|endothelin receptor subtype A|endothelin-1-specific receptor', map_location='4q31.22', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=147480917, end_position_on_the_genomic_accession=147544954, orientation='plus', exon_count=8, OMIM=131243, no_hdr0=''),
  1910 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1910, CurrentID=0, Status='live', Symbol='EDNRB', Aliases='ABCDS, ET-B, ET-BR, ETB, ETB1, ETBR, ETRB, HSCR, HSCR2, WS4A', description='endothelin receptor type B', other_designations='endothelin receptor non-selective type|endothelin receptor subtype B1', map_location='13q22', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=77895481, end_position_on_the_genomic_accession=77975529, orientation='minus', exon_count=10, OMIM=131244, no_hdr0=''),
  1911 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1911, CurrentID=0, Status='live', Symbol='PHC1', Aliases='EDR1, HPH1, MCPH11, RAE28', description='polyhomeotic homolog 1', other_designations='early development regulator 1 (homolog of polyhomeotic 1)|early development regulatory protein 1|polyhomeotic-like 1', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=8914684, end_position_on_the_genomic_accession=8941467, orientation='plus', exon_count=16, OMIM=602978, no_hdr0=''),
  1912 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1912, CurrentID=0, Status='live', Symbol='PHC2', Aliases='EDR2, HPH2, PH2', description='polyhomeotic homolog 2', other_designations='early development regulator 2 (homolog of polyhomeotic 2)|early development regulatory protein 2|polyhomeotic 2|polyhomeotic-like 2', map_location='1p34.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=33323623, end_position_on_the_genomic_accession=33430610, orientation='minus', exon_count=24, OMIM=602979, no_hdr0=''),
  1915 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1915, CurrentID=0, Status='live', Symbol='EEF1A1', Aliases='CCS-3, CCS3, EE1A1, EEF-1, EEF1A, EF-Tu, EF1A, GRAF-1EF, HNGC:16303, LENG7, PTI1, eEF1A-1', description='eukaryotic translation elongation factor 1 alpha 1', other_designations='CTCL tumor antigen|EF-1-alpha-1|EF1a-like protein|cervical cancer suppressor 3|elongation factor 1 alpha subunit|elongation factor Tu|eukaryotic elongation factor 1 A-1|eukaryotic translation elongation factor 1 alpha 1-like 14|glucocorticoid receptor AF-1 specific elongation factor|leukocyte receptor cluster (LRC) member 7|leukocyte receptor cluster member 7|prostate tumor-inducing protein 1|translation elongation factor 1 alpha 1-like 14', map_location='6q14.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=73515750, end_position_on_the_genomic_accession=73521032, orientation='minus', exon_count=9, OMIM=130590, no_hdr0=''),
  1917 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1917, CurrentID=0, Status='live', Symbol='EEF1A2', Aliases='EEF1AL, EF-1-alpha-2, EF1A, EIEE33, HS1, MRD38, STN, STNL', description='eukaryotic translation elongation factor 1 alpha 2', other_designations='eukaryotic elongation factor 1 A-2|statin-S1', map_location='20q13.3', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=63488012, end_position_on_the_genomic_accession=63499315, orientation='minus', exon_count=8, OMIM=602959, no_hdr0=''),
  136853 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=136853, CurrentID=0, Status='live', Symbol='SSC4D', Aliases='S4D-SRCRB, SRCRB-S4D, SRCRB4D', description='scavenger receptor cysteine rich family, 4 domains', other_designations='S4-SRCRB|SRCRB4D|four scavenger receptor cysteine-rich domains-containing protein|scavenger receptor cysteine rich domain containing, group B (4 domains)|scavenger receptor cysteine-rich protein SRCRB-S4D', map_location='7q11.23', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=76389329, end_position_on_the_genomic_accession=76409695, orientation='minus', exon_count=11, OMIM=607639, no_hdr0=''),
  105376747 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=105376747, CurrentID=0, Status='live', Symbol='LOC105376747', Aliases='', description='collagen alpha-3(IX) chain-like', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=14734887, end_position_on_the_genomic_accession=14742760, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  100996758 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100996758, CurrentID=0, Status='live', Symbol='CH17-360D5.1', Aliases='', description='neuropeptide Y receptor type 4-like', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=47914012, end_position_on_the_genomic_accession=47926069, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  1933 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1933, CurrentID=0, Status='live', Symbol='EEF1B2', Aliases='EEF1B, EEF1B1, EF1B', description='eukaryotic translation elongation factor 1 beta 2', other_designations='EF-1-beta|eukaryotic translation elongation factor 1 beta 1', map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=206159594, end_position_on_the_genomic_accession=206162929, orientation='plus', exon_count=7, OMIM=600655, no_hdr0=''),
  1936 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1936, CurrentID=0, Status='live', Symbol='EEF1D', Aliases='EF-1D, EF1D, FP1047', description='eukaryotic translation elongation factor 1 delta', other_designations='EF-1-delta|antigen NY-CO-4|eukaryotic translation elongation factor 1 delta (guanine nucleotide exchange protein)|guanine nucleotide exchange protein', map_location='8q24.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=143579697, end_position_on_the_genomic_accession=143597675, orientation='minus', exon_count=15, OMIM=130592, no_hdr0=''),
  1937 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1937, CurrentID=0, Status='live', Symbol='EEF1G', Aliases='EF1G, GIG35', description='eukaryotic translation elongation factor 1 gamma', other_designations='EF-1-gamma|PRO1608|eEF-1B gamma|pancreatic tumor-related protein|translation elongation factor eEF-1 gamma chain', map_location='11q12.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=62559601, end_position_on_the_genomic_accession=62573988, orientation='minus', exon_count=10, OMIM=130593, no_hdr0=''),
  1938 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1938, CurrentID=0, Status='live', Symbol='EEF2', Aliases='EEF-2, EF-2, EF2, SCA26', description='eukaryotic translation elongation factor 2', other_designations='polypeptidyl-tRNA translocase', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=3976056, end_position_on_the_genomic_accession=3985463, orientation='minus', exon_count=15, OMIM=130610, no_hdr0=''),
  323 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=323, CurrentID=0, Status='live', Symbol='APBB2', Aliases='FE65L, FE65L1', description='amyloid beta precursor protein binding family B member 2', other_designations='Fe65-like 1|amyloid beta precursor protein-binding family B member 2|protein Fe65-like 1', map_location='4p13', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=40810027, end_position_on_the_genomic_accession=41216714, orientation='minus', exon_count=25, OMIM=602710, no_hdr0=''),
  1942 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1942, CurrentID=0, Status='live', Symbol='EFNA1', Aliases='B61, ECKLG, EFL1, EPLG1, LERK-1, LERK1, TNFAIP4', description='ephrin-A1', other_designations='TNF alpha-induced protein 4|eph-related receptor tyrosine kinase ligand 1|immediate early response protein B61|ligand of eph-related kinase 1|tumor necrosis factor alpha-induced protein 4|tumor necrosis factor, alpha-induced protein 4', map_location='1q21-q22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=155127873, end_position_on_the_genomic_accession=155134910, orientation='plus', exon_count=6, OMIM=191164, no_hdr0=''),
  1943 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1943, CurrentID=0, Status='live', Symbol='EFNA2', Aliases='ELF-1, EPLG6, HEK7-L, LERK-6, LERK6', description='ephrin-A2', other_designations='HEK7 ligand|eph-related receptor tyrosine kinase ligand 6', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1286154, end_position_on_the_genomic_accession=1301431, orientation='plus', exon_count=4, OMIM=602756, no_hdr0=''),
  1944 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1944, CurrentID=0, Status='live', Symbol='EFNA3', Aliases='EFL2, EPLG3, Ehk1-L, LERK3', description='ephrin-A3', other_designations='EFL-2|EHK1 ligand|LERK-3|eph-related receptor tyrosine kinase ligand 3|ligand of eph-related kinase 3', map_location='1q21-q22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=155078872, end_position_on_the_genomic_accession=155087538, orientation='plus', exon_count=5, OMIM=601381, no_hdr0=''),
  1945 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1945, CurrentID=0, Status='live', Symbol='EFNA4', Aliases='EFL4, EPLG4, LERK4', description='ephrin-A4', other_designations='LERK-4|eph-related receptor tyrosine kinase ligand 4|ligand of eph-related kinase 4', map_location='1q21-q22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=155063737, end_position_on_the_genomic_accession=155069553, orientation='plus', exon_count=4, OMIM=601380, no_hdr0=''),
  1946 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1946, CurrentID=0, Status='live', Symbol='EFNA5', Aliases='AF1, EFL5, EPLG7, GLC1M, LERK7, RAGS', description='ephrin-A5', other_designations='AL-1|LERK-7|eph-related receptor tyrosine kinase ligand 7', map_location='5q21', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=107376889, end_position_on_the_genomic_accession=107670895, orientation='minus', exon_count=7, OMIM=601535, no_hdr0=''),
  1947 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1947, CurrentID=0, Status='live', Symbol='EFNB1', Aliases='CFND, CFNS, EFB1, EFL3, EPLG2, Elk-L, LERK2', description='ephrin-B1', other_designations='ELK ligand|eph-related receptor tyrosine kinase ligand 2', map_location='Xq12', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=68828997, end_position_on_the_genomic_accession=68842164, orientation='plus', exon_count=5, OMIM=300035, no_hdr0=''),
  1948 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1948, CurrentID=0, Status='live', Symbol='EFNB2', Aliases='EPLG5, HTKL, Htk-L, LERK5', description='ephrin-B2', other_designations='HTK ligand|LERK-5|eph-related receptor tyrosine kinase ligand 5|ligand of eph-related kinase 5', map_location='13q33', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=106489731, end_position_on_the_genomic_accession=106535040, orientation='minus', exon_count=5, OMIM=600527, no_hdr0=''),
  1949 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1949, CurrentID=0, Status='live', Symbol='EFNB3', Aliases='EFL6, EPLG8, LERK8', description='ephrin-B3', other_designations='EPH-related receptor transmembrane ligand ELK-L3|Ephrin B3|eph-related receptor tyrosine kinase ligand 8', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7705202, end_position_on_the_genomic_accession=7711375, orientation='plus', exon_count=5, OMIM=602297, no_hdr0=''),
  1950 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1950, CurrentID=0, Status='live', Symbol='EGF', Aliases='HOMG4, URG', description='epidermal growth factor', other_designations='beta-urogastrone', map_location='4q25', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=109912883, end_position_on_the_genomic_accession=110012962, orientation='plus', exon_count=26, OMIM=131530, no_hdr0=''),
  1951 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1951, CurrentID=0, Status='live', Symbol='CELSR3', Aliases='ADGRC3, CDHF11, EGFL1, FMI1, HFMI1, MEGF2, RESDA1', description='cadherin EGF LAG seven-pass G-type receptor 3', other_designations='EGF-like protein 1|EGF-like-domain, multiple 1|adhesion G protein-coupled receptor C3|anchor protein|cadherin family member 11|cadherin, EGF LAG seven-pass G-type receptor 3 (flamingo homolog, Drosophila)|epidermal growth factor-like protein 1|flamingo homolog 1|multiple EGF-like domains protein 2|multiple epidermal growth factor-like domains protein 2', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48636463, end_position_on_the_genomic_accession=48662915, orientation='minus', exon_count=35, OMIM=604264, no_hdr0=''),
  1952 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1952, CurrentID=0, Status='live', Symbol='CELSR2', Aliases='ADGRC2, CDHF10, EGFL2, Flamingo1, MEGF3', description='cadherin EGF LAG seven-pass G-type receptor 2', other_designations='EGF-like protein 2|EGF-like-domain, multiple 2|adhesion G protein-coupled receptor C2|cadherin family member 10|cadherin, EGF LAG seven-pass G-type receptor 2 (flamingo homolog, Drosophila)|epidermal growth factor-like 2|epidermal growth factor-like protein 2|flamingo homolog 3|multiple EGF-like domains protein 3|multiple epidermal growth factor-like domains 3|multiple epidermal growth factor-like domains protein 3', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=109249715, end_position_on_the_genomic_accession=109275756, orientation='plus', exon_count=34, OMIM=604265, no_hdr0=''),
  1953 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1953, CurrentID=0, Status='live', Symbol='MEGF6', Aliases='EGFL3', description='multiple EGF like domains 6', other_designations='EGF-like protein 3|EGF-like-domain, multiple 3|epidermal growth factor-like protein 3|multiple EGF-like domains protein 6|multiple EGF-like-domains 6', map_location='1p36.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=3487942, end_position_on_the_genomic_accession=3624757, orientation='minus', exon_count=41, OMIM=604266, no_hdr0=''),
  1954 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1954, CurrentID=0, Status='live', Symbol='MEGF8', Aliases='C19orf49, CRPT2, EGFL4, SBP1', description='multiple EGF like domains 8', other_designations='EGF-like domain-containing protein 4|EGF-like-domain, multiple 4|HBV pre-S2-binding protein 1|HBV pre-s2 binding protein 1|epidermal growth factor-like protein 4|hepatitis B virus pre-S2-binding protein 1|multiple EGF-like-domains 8', map_location='19q12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=42325609, end_position_on_the_genomic_accession=42378769, orientation='plus', exon_count=42, OMIM=604267, no_hdr0=''),
  1955 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1955, CurrentID=0, Status='live', Symbol='MEGF9', Aliases='EGFL5', description='multiple EGF like domains 9', other_designations='EGF-like-domain, multiple 5|epidermal growth factor-like protein 5|multiple EGF-like-domains 9', map_location='9q32-q33.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=120600918, end_position_on_the_genomic_accession=120714487, orientation='minus', exon_count=6, OMIM=604268, no_hdr0=''),
  1956 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1956, CurrentID=0, Status='live', Symbol='EGFR', Aliases='ERBB, ERBB1, HER1, NISBD2, PIG61, mENA', description='epidermal growth factor receptor', other_designations='avian erythroblastic leukemia viral (v-erb-b) oncogene homolog|cell growth inhibiting protein 40|cell proliferation-inducing protein 61|erb-b2 receptor tyrosine kinase 1|proto-oncogene c-ErbB-1|receptor tyrosine-protein kinase erbB-1', map_location='7p12', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=55019032, end_position_on_the_genomic_accession=55207338, orientation='plus', exon_count=30, OMIM=131550, no_hdr0=''),
  1958 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1958, CurrentID=0, Status='live', Symbol='EGR1', Aliases='AT225, G0S30, KROX-24, NGFI-A, TIS8, ZIF-268, ZNF225', description='early growth response 1', other_designations='EGR-1|nerve growth factor-induced protein A|transcription factor ETR103|transcription factor Zif268|zinc finger protein 225|zinc finger protein Krox-24', map_location='5q31.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=138465492, end_position_on_the_genomic_accession=138469315, orientation='plus', exon_count=2, OMIM=128990, no_hdr0=''),
  1959 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1959, CurrentID=0, Status='live', Symbol='EGR2', Aliases='AT591, CMT1D, CMT4E, KROX20', description='early growth response 2', other_designations='KROX-20, Drosophila, homolog (early growth response-2)|early growth response protein 2|zinc finger protein Krox-20', map_location='10q21.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=62811996, end_position_on_the_genomic_accession=62919895, orientation='minus', exon_count=11, OMIM=129010, no_hdr0=''),
  1960 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1960, CurrentID=0, Status='live', Symbol='EGR3', Aliases='EGR-3, PILOT', description='early growth response 3', other_designations='zinc finger protein pilot', map_location='8p23-p21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=22687659, end_position_on_the_genomic_accession=22693302, orientation='minus', exon_count=5, OMIM=602419, no_hdr0=''),
  1961 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1961, CurrentID=0, Status='live', Symbol='EGR4', Aliases='NGFI-C, NGFIC, PAT133', description='early growth response 4', other_designations='AT133|EGR-4', map_location='2p13', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=73290929, end_position_on_the_genomic_accession=73293701, orientation='minus', exon_count=2, OMIM=128992, no_hdr0=''),
  1962 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1962, CurrentID=0, Status='live', Symbol='EHHADH', Aliases='ECHD, FRTS3, L-PBE, LBFP, LBP, PBFE', description='enoyl-CoA, hydratase/3-hydroxyacyl CoA dehydrogenase', other_designations='3,2-trans-enoyl-CoA isomerase|L-3-hydroxyacyl-CoA dehydrogenase|L-bifunctional protein, peroxisomal|PBE|enoyl-Coenzyme A, hydratase/3-hydroxyacyl Coenzyme A dehydrogenase|peroxisomal enoyl-CoA hydratase', map_location='3q26.3-q28', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=185190624, end_position_on_the_genomic_accession=185282886, orientation='minus', exon_count=9, OMIM=607037, no_hdr0=''),
  1964 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1964, CurrentID=0, Status='live', Symbol='EIF1AX', Aliases='EIF1A, EIF1AP1, EIF4C, eIF-1A, eIF-4C', description='eukaryotic translation initiation factor 1A, X-linked', other_designations='Putative eukaryotic translation initiation factor 1A|eIF-1A X isoform|eukaryotic translation initiation factor 1A, X chromosome|eukaryotic translation initiation factor 4C', map_location='Xp22.12', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=20124518, end_position_on_the_genomic_accession=20141848, orientation='minus', exon_count=7, OMIM=300186, no_hdr0=''),
  1965 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1965, CurrentID=0, Status='live', Symbol='EIF2S1', Aliases='EIF-2, EIF-2A, EIF-2alpha, EIF2, EIF2A', description='eukaryotic translation initiation factor 2 subunit alpha', other_designations='eIF-2-alpha|eukaryotic translation initiation factor 2, subunit 1 alpha, 35kDa', map_location='14q23.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=67360317, end_position_on_the_genomic_accession=67386516, orientation='plus', exon_count=8, OMIM=603907, no_hdr0=''),
  1967 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1967, CurrentID=0, Status='live', Symbol='EIF2B1', Aliases='EIF2B, EIF2BA', description='eukaryotic translation initiation factor 2B subunit alpha', other_designations='eIF-2B GDP-GTP exchange factor subunit alpha|eukaryotic translation initiation factor 2B, subunit 1 alpha, 26kDa', map_location='12q24.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=123621023, end_position_on_the_genomic_accession=123633776, orientation='minus', exon_count=9, OMIM=606686, no_hdr0=''),
  1968 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1968, CurrentID=0, Status='live', Symbol='EIF2S3', Aliases='EIF2, EIF2G, EIF2gamma, eIF-2gA', description='eukaryotic translation initiation factor 2 subunit gamma', other_designations='eIF-2-gamma X|eIF-2gX|eukaryotic translation initiation factor 2 subunit gamma X|eukaryotic translation initiation factor 2, subunit 3 gamma, 52kDa|eukaryotic translation initiation factor 2G', map_location='Xp22.2-p22.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=24054948, end_position_on_the_genomic_accession=24078810, orientation='plus', exon_count=12, OMIM=300161, no_hdr0=''),
  1969 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1969, CurrentID=0, Status='live', Symbol='EPHA2', Aliases='ARCC2, CTPA, CTPP1, CTRCT6, ECK', description='EPH receptor A2', other_designations='epithelial cell receptor protein tyrosine kinase|soluble EPHA2 variant 1|tyrosine-protein kinase receptor ECK', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=16124337, end_position_on_the_genomic_accession=16156087, orientation='minus', exon_count=17, OMIM=176946, no_hdr0=''),
  102723415 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=102723415, CurrentID=0, Status='live', Symbol='LOC102723415', Aliases='', description='uncharacterized LOC102723415', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=38594516, end_position_on_the_genomic_accession=38610466, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  100510707 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100510707, CurrentID=0, Status='live', Symbol='TBC1D3J', Aliases='', description='TBC1 domain family member 3J', other_designations='TBC1 domain family, member 3J', map_location='', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=36449777, end_position_on_the_genomic_accession=36456035, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  54622 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=54622, CurrentID=0, Status='live', Symbol='ARL15', Aliases='ARFRP2', description='ADP ribosylation factor like GTPase 15', other_designations='ADP-ribosylation factor like GTPase 15|ADP-ribosylation factor related protein 2|ADP-ribosylation factor-like 15|ADP-ribosylation factor-related protein 2|ARF-related protein 2', map_location='5p15.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=53884748, end_position_on_the_genomic_accession=54310586, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  1973 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1973, CurrentID=0, Status='live', Symbol='EIF4A1', Aliases='DDX2A, EIF-4A, EIF4A, eIF-4A-I, eIF4A-I', description='eukaryotic translation initiation factor 4A1', other_designations='ATP-dependent RNA helicase eIF4A-1|eukaryotic initiation factor 4AI|eukaryotic translation initiation factor 4A', map_location='17p13', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7572706, end_position_on_the_genomic_accession=7579006, orientation='plus', exon_count=11, OMIM=602641, no_hdr0=''),
  1974 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1974, CurrentID=0, Status='live', Symbol='EIF4A2', Aliases='BM-010, DDX2B, EIF4A, EIF4F, eIF-4A-II, eIF4A-II', description='eukaryotic translation initiation factor 4A2', other_designations='ATP-dependent RNA helicase eIF4A-2', map_location='3q28', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186783572, end_position_on_the_genomic_accession=186789897, orientation='plus', exon_count=11, OMIM=601102, no_hdr0=''),
  1975 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1975, CurrentID=0, Status='live', Symbol='EIF4B', Aliases='EIF-4B, PRO1843', description='eukaryotic translation initiation factor 4B', other_designations='', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=53006258, end_position_on_the_genomic_accession=53042209, orientation='plus', exon_count=16, OMIM=603928, no_hdr0=''),
  1977 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1977, CurrentID=0, Status='live', Symbol='EIF4E', Aliases='AUTS19, CBP1, EIF4EL1, EIF4F, eIF-4E, EIF4E', description='eukaryotic translation initiation factor 4E', other_designations='eIF-4F 25 kDa subunit|eukaryotic translation initiation factor 4E-like 1|mRNA cap-binding protein', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=98878456, end_position_on_the_genomic_accession=98930635, orientation='minus', exon_count=10, OMIM=133440, no_hdr0=''),
  1978 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1978, CurrentID=0, Status='live', Symbol='EIF4EBP1', Aliases='4E-BP1, 4EBP1, BP-1, PHAS-I', description='eukaryotic translation initiation factor 4E binding protein 1', other_designations='eIF4E-binding protein 1|phosphorylated heat- and acid-stable protein regulated by insulin 1', map_location='8p12', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=38030502, end_position_on_the_genomic_accession=38060365, orientation='plus', exon_count=3, OMIM=602223, no_hdr0=''),
  1979 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1979, CurrentID=0, Status='live', Symbol='EIF4EBP2', Aliases='4EBP2, PHASII', description='eukaryotic translation initiation factor 4E binding protein 2', other_designations='4E-BP2|eIF4E-binding protein 2|phosphorylated, heat and acid stable regulated by insulin protein II', map_location='10q21-q22', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=70404105, end_position_on_the_genomic_accession=70428618, orientation='plus', exon_count=3, OMIM=602224, no_hdr0=''),
  1981 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1981, CurrentID=0, Status='live', Symbol='EIF4G1', Aliases='EIF-4G1, EIF4F, EIF4G, EIF4GI, P220, PARK18', description='eukaryotic translation initiation factor 4 gamma 1', other_designations='EIF4-gamma|eIF-4-gamma 1|eucaryotic translation initiation factor 4G|eukaryotic translation initiation factor 4 gamma, 1', map_location='3q27.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184314495, end_position_on_the_genomic_accession=184335358, orientation='plus', exon_count=34, OMIM=600495, no_hdr0=''),
  1982 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1982, CurrentID=0, Status='live', Symbol='EIF4G2', Aliases='AAG1, DAP5, NAT1, P97', description='eukaryotic translation initiation factor 4 gamma 2', other_designations='DAP-5|aging-associated protein 1|death-associated protein 5|eIF-4-gamma 2|eIF-4G 2|eIF4G 2|eukaryotic translation initiation factor 4 gamma, 2|eukaryotic translation initiation factor 4G-like 1', map_location='11p15', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=10797046, end_position_on_the_genomic_accession=10809035, orientation='minus', exon_count=23, OMIM=602325, no_hdr0=''),
  1983 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1983, CurrentID=0, Status='live', Symbol='EIF5', Aliases='EIF-5, EIF-5A', description='eukaryotic translation initiation factor 5', other_designations='', map_location='14q32.32', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=103334002, end_position_on_the_genomic_accession=103345025, orientation='plus', exon_count=13, OMIM=601710, no_hdr0=''),
  1984 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1984, CurrentID=0, Status='live', Symbol='EIF5A', Aliases='EIF-5A1, eIF5AI, EIF5A', description='eukaryotic translation initiation factor 5A', other_designations='eIF-4D|eIF-5A-1|eIF-5A1|eukaryotic initiation factor 5A|rev-binding factor', map_location='17p13-p12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7306999, end_position_on_the_genomic_accession=7312463, orientation='plus', exon_count=11, OMIM=600187, no_hdr0=''),
  133060 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=133060, CurrentID=0, Status='live', Symbol='OTOP1', Aliases='', description='otopetrin 1', other_designations='', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=4188803, end_position_on_the_genomic_accession=4226894, orientation='minus', exon_count=6, OMIM=607806, no_hdr0=''),
  165829 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=165829, CurrentID=0, Status='live', Symbol='GPR156', Aliases='GABABL, PGR28', description='G protein-coupled receptor 156', other_designations='G protein-coupled receptor PGR28|G-protein coupled receptor PGR28|GABAB-related G-protein coupled receptor', map_location='3q13.33', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=120165481, end_position_on_the_genomic_accession=120285124, orientation='minus', exon_count=15, OMIM=610464, no_hdr0=''),
  1990 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1990, CurrentID=0, Status='live', Symbol='CELA1', Aliases='ELA1', description='chymotrypsin like elastase family member 1', other_designations='chymotrypsin-like elastase family, member 1|elastase 1, pancreatic|elastase-1|pancreatic elastase 1', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=51328443, end_position_on_the_genomic_accession=51346679, orientation='minus', exon_count=8, OMIM=130120, no_hdr0=''),
  1991 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1991, CurrentID=0, Status='live', Symbol='ELANE', Aliases='ELA2, GE, HLE, HNE, NE, PMN-E, SCN1', description='elastase, neutrophil expressed', other_designations='PMN elastase|bone marrow serine protease|elastase 2, neutrophil|elastase-2|granulocyte-derived elastase|leukocyte elastase|medullasin|polymorphonuclear elastase', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=850997, end_position_on_the_genomic_accession=856250, orientation='plus', exon_count=6, OMIM=130130, no_hdr0=''),
  1992 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1992, CurrentID=0, Status='live', Symbol='SERPINB1', Aliases='EI, ELANH2, HEL-S-27, HEL57, LEI, M/NEI, MNEI, PI-2, PI2', description='serpin peptidase inhibitor, clade B (ovalbumin), member 1', other_designations='epididymis luminal protein 57|epididymis secretory protein Li 27|peptidase inhibitor 2|protease inhibitor 2 (anti-elastase), monocyte/neutrophil derived|serine (or cysteine) proteinase inhibitor, clade B (ovalbumin), member 1', map_location='6p25', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=2832332, end_position_on_the_genomic_accession=2842049, orientation='minus', exon_count=9, OMIM=130135, no_hdr0=''),
  1993 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1993, CurrentID=0, Status='live', Symbol='ELAVL2', Aliases='HEL-N1, HELN1, HUB', description='ELAV like neuron-specific RNA binding protein 2', other_designations='ELAV (embryonic lethal, abnormal vision, Drosophila)-like 2 (Hu antigen B)|ELAV-like neuronal protein 1 isoform Hel-N2|hu-antigen B|nervous system-specific RNA-binding protein Hel-N1', map_location='9p21', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=23690104, end_position_on_the_genomic_accession=23850706, orientation='minus', exon_count=17, OMIM=601673, no_hdr0=''),
  1994 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1994, CurrentID=0, Status='live', Symbol='ELAVL1', Aliases='ELAV1, HUR, Hua, MelG', description='ELAV like RNA binding protein 1', other_designations='ELAV (embryonic lethal, abnormal vision, Drosophila)-like 1 (Hu antigen R)|Hu antigen R|embryonic lethal, abnormal vision, drosophila, homolog-like 1|hu-antigen R', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=7958573, end_position_on_the_genomic_accession=8005645, orientation='minus', exon_count=7, OMIM=603466, no_hdr0=''),
  1995 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1995, CurrentID=0, Status='live', Symbol='ELAVL3', Aliases='HUC, HUCL, PLE21', description='ELAV like neuron-specific RNA binding protein 3', other_designations='ELAV (embryonic lethal, abnormal vision, Drosophila)-like 3 (Hu antigen C)|Hu antigen C|hu-antigen C|paraneoplastic cerebellar degeneration-associated antigen|paraneoplastic limbic encephalitis antigen 21', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=11451326, end_position_on_the_genomic_accession=11481046, orientation='minus', exon_count=7, OMIM=603458, no_hdr0=''),
  1996 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1996, CurrentID=0, Status='live', Symbol='ELAVL4', Aliases='HUD, PNEM', description='ELAV like neuron-specific RNA binding protein 4', other_designations='ELAV (embryonic lethal, abnormal vision, Drosophila)-like 4 (Hu antigen D)|Hu antigen D|paraneoplastic encephalomyelitis antigen HuD', map_location='1p34', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=50048014, end_position_on_the_genomic_accession=50203786, orientation='plus', exon_count=15, OMIM=168360, no_hdr0=''),
  1997 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1997, CurrentID=0, Status='live', Symbol='ELF1', Aliases='', description='E74-like factor 1 (ets domain transcription factor)', other_designations='', map_location='13q13', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=40931919, end_position_on_the_genomic_accession=41061378, orientation='minus', exon_count=14, OMIM=189973, no_hdr0=''),
  1998 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1998, CurrentID=0, Status='live', Symbol='ELF2', Aliases='EU32, NERF, NERF-1A, NERF-1B, NERF-1a,b, NERF-2', description='E74-like factor 2 (ets domain transcription factor)', other_designations='ets family transcription factor ELF2C|new Ets-related factor', map_location='4q28', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=139057717, end_position_on_the_genomic_accession=139177218, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  1999 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=1999, CurrentID=0, Status='live', Symbol='ELF3', Aliases='EPR-1, ERT, ESE-1, ESX', description='E74-like factor 3 (ets domain transcription factor, epithelial-specific )', other_designations='E74-like factor 3 (ETS domain transcription factor, serine box, epithelial-specific)|E74-like factor 3 (ets domain transcription factor)|epithelial-restricted with serine box|epithelium-restricted Ets protein ESX|epithelium-specific Ets transcription factor 1|ets domain transcription factor, serine box (epithelial-specific)', map_location='1q32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=202010519, end_position_on_the_genomic_accession=202017188, orientation='plus', exon_count=9, OMIM=602191, no_hdr0=''),
  2000 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2000, CurrentID=0, Status='live', Symbol='ELF4', Aliases='ELFR, MEF', description='E74-like factor 4 (ets domain transcription factor)', other_designations='myeloid Elf-1-like factor', map_location='Xq26', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=130064920, end_position_on_the_genomic_accession=130110713, orientation='minus', exon_count=11, OMIM=300775, no_hdr0=''),
  2001 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2001, CurrentID=0, Status='live', Symbol='ELF5', Aliases='ESE2', description='E74-like factor 5 (ets domain transcription factor)', other_designations='epithelium-restricted ESE-1-related Ets factor|epithelium-specific Ets transcription factor 2', map_location='11p13-p12', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=34478795, end_position_on_the_genomic_accession=34513800, orientation='minus', exon_count=8, OMIM=605169, no_hdr0=''),
  2002 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2002, CurrentID=0, Status='live', Symbol='ELK1', Aliases='', description='ELK1, member of ETS oncogene family', other_designations='ETS-like gene 1|tyrosine kinase (ELK1) oncogene', map_location='Xp11.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=47635520, end_position_on_the_genomic_accession=47650604, orientation='minus', exon_count=7, OMIM=311040, no_hdr0=''),
  138804 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=138804, CurrentID=0, Status='live', Symbol='OR13C4', Aliases='HSHTPCRX17, HTPCRX17, OR2K1, OR37F, OR9-7', description='olfactory receptor family 13 subfamily C member 4', other_designations='olfactory receptor OR9-7|olfactory receptor, family 13, subfamily C, member 4|olfactory receptor, family 2, subfamily K, member 1', map_location='9q31.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=104526253, end_position_on_the_genomic_accession=104527209, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  2004 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2004, CurrentID=0, Status='live', Symbol='ELK3', Aliases='ERP, NET, SAP-2, SAP2', description='ELK3, ETS-domain protein (SRF accessory protein 2)', other_designations='ETS-related protein ERP|ETS-related protein NET|SRF accessory protein 2|serum response factor accessory protein 2', map_location='12q23', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=96194382, end_position_on_the_genomic_accession=96269835, orientation='plus', exon_count=7, OMIM=600247, no_hdr0=''),
  2005 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2005, CurrentID=0, Status='live', Symbol='ELK4', Aliases='SAP1', description='ELK4, ETS-domain protein (SRF accessory protein 1)', other_designations='SAP-1|serum response factor accessory protein 1', map_location='1q32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=205593466, end_position_on_the_genomic_accession=205634085, orientation='minus', exon_count=12, OMIM=600246, no_hdr0=''),
  2006 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2006, CurrentID=0, Status='live', Symbol='ELN', Aliases='SVAS, WBS, WS', description='elastin', other_designations='tropoelastin', map_location='7q11.23', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=74027772, end_position_on_the_genomic_accession=74069907, orientation='plus', exon_count=34, OMIM=130160, no_hdr0=''),
  2009 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2009, CurrentID=0, Status='live', Symbol='EML1', Aliases='ELP79, EMAP, EMAPL, HuEMAP', description='echinoderm microtubule associated protein like 1', other_designations='EMAP-1|huEMAP-1', map_location='14q32', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=99737722, end_position_on_the_genomic_accession=99942060, orientation='plus', exon_count=27, OMIM=602033, no_hdr0=''),
  2010 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2010, CurrentID=0, Status='live', Symbol='EMD', Aliases='EDMD, LEMD5, STA', description='emerin', other_designations='LEM domain containing 5', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154379237, end_position_on_the_genomic_accession=154381523, orientation='plus', exon_count=6, OMIM=300384, no_hdr0=''),
  2011 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2011, CurrentID=0, Status='live', Symbol='MARK2', Aliases='EMK-1, EMK1, PAR-1, Par-1b, Par1b', description='microtubule affinity regulating kinase 2', other_designations='ELKL motif kinase 1|MAP/microtubule affinity-regulating kinase 2|PAR1 homolog b|Ser/Thr protein kinase PAR-1B|serine/threonine protein kinase EMK', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=63838928, end_position_on_the_genomic_accession=63911020, orientation='plus', exon_count=21, OMIM=600526, no_hdr0=''),
  2012 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2012, CurrentID=0, Status='live', Symbol='EMP1', Aliases='CL-20, EMP-1, TMP', description='epithelial membrane protein 1', other_designations='tumor-associated membrane protein', map_location='12p12.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=13196668, end_position_on_the_genomic_accession=13216774, orientation='plus', exon_count=5, OMIM=602333, no_hdr0=''),
  2013 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2013, CurrentID=0, Status='live', Symbol='EMP2', Aliases='XMP', description='epithelial membrane protein 2', other_designations='', map_location='16p13.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=10528422, end_position_on_the_genomic_accession=10580682, orientation='minus', exon_count=6, OMIM=602334, no_hdr0=''),
  2014 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2014, CurrentID=0, Status='live', Symbol='EMP3', Aliases='YMP', description='epithelial membrane protein 3', other_designations='EMP-3|HNMP-1|hematopoietic neural membrane protein 1', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48325370, end_position_on_the_genomic_accession=48330555, orientation='plus', exon_count=6, OMIM=602335, no_hdr0=''),
  2015 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2015, CurrentID=0, Status='live', Symbol='ADGRE1', Aliases='EMR1, TM7LN3', description='adhesion G protein-coupled receptor E1', other_designations='EGF-like module receptor 1|EGF-like module-containing mucin-like hormone receptor-like 1|EMR1 hormone receptor|egf-like module containing, mucin-like, hormone receptor-like 1|egf-like module containing, mucin-like, hormone receptor-like sequence 1', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=6887549, end_position_on_the_genomic_accession=6940453, orientation='plus', exon_count=23, OMIM=600493, no_hdr0=''),
  2016 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2016, CurrentID=0, Status='live', Symbol='EMX1', Aliases='', description='empty spiracles homeobox 1', other_designations='empty spiracles homolog 1|empty spiracles-like protein 1', map_location='2p13.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=72911148, end_position_on_the_genomic_accession=72934891, orientation='plus', exon_count=7, OMIM=600034, no_hdr0=''),
  2017 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2017, CurrentID=0, Status='live', Symbol='CTTN', Aliases='EMS1', description='cortactin', other_designations='1110020L01Rik|amplaxin|ems1 sequence (mammary tumor and squamous cell carcinoma-associated (p80/85 src substrate)|oncogene EMS1', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=70398506, end_position_on_the_genomic_accession=70436584, orientation='plus', exon_count=19, OMIM=164765, no_hdr0=''),
  2018 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2018, CurrentID=0, Status='live', Symbol='EMX2', Aliases='', description='empty spiracles homeobox 2', other_designations='empty spiracles homolog 2|empty spiracles-like protein 2', map_location='10q26.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=117542445, end_position_on_the_genomic_accession=117549546, orientation='plus', exon_count=3, OMIM=600035, no_hdr0=''),
  2019 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2019, CurrentID=0, Status='live', Symbol='EN1', Aliases='', description='engrailed homeobox 1', other_designations='engrailed homolog 1|homeobox protein en-1|hu-En-1', map_location='2q14.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=118842171, end_position_on_the_genomic_accession=118848183, orientation='minus', exon_count=2, OMIM=131290, no_hdr0=''),
  2020 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2020, CurrentID=0, Status='live', Symbol='EN2', Aliases='', description='engrailed homeobox 2', other_designations='engrailed homolog 2|engrailed-2|homeobox protein en-2|hu-En-2', map_location='7q36', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=155458129, end_position_on_the_genomic_accession=155464831, orientation='plus', exon_count=2, OMIM=131310, no_hdr0=''),
  2021 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2021, CurrentID=0, Status='live', Symbol='ENDOG', Aliases='', description='endonuclease G', other_designations='endo G|mitochondrial endonuclease G', map_location='9q34.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=128818411, end_position_on_the_genomic_accession=128822678, orientation='plus', exon_count=4, OMIM=600440, no_hdr0=''),
  2022 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2022, CurrentID=0, Status='live', Symbol='ENG', Aliases='END, HHT1, ORW1', description='endoglin', other_designations='CD105 antigen', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=127815012, end_position_on_the_genomic_accession=127854773, orientation='minus', exon_count=16, OMIM=131195, no_hdr0=''),
  2023 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2023, CurrentID=0, Status='live', Symbol='ENO1', Aliases='ENO1L1, HEL-S-17, MPB1, NNE, PPH', description='enolase 1, (alpha)', other_designations='2-phospho-D-glycerate hydro-lyase|MYC promoter-binding protein 1|alpha enolase like 1|enolase-alpha|epididymis secretory protein Li 17|non-neural enolase|phosphopyruvate hydratase|plasminogen-binding protein|tau-crystallin', map_location='1p36.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=8861000, end_position_on_the_genomic_accession=8879092, orientation='minus', exon_count=13, OMIM=172430, no_hdr0=''),
  727851 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=727851, CurrentID=0, Status='live', Symbol='RGPD8', Aliases='RANBP2L1, RGP8, RanBP2alpha', description='RANBP2-like and GRIP domain containing 8', other_designations='RAN binding protein 2-like 1|ran-binding protein 2-like 3|ranBP2-like 3|ranBP2L3', map_location='2q13', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=112368369, end_position_on_the_genomic_accession=112433645, orientation='minus', exon_count=25, OMIM=602752, no_hdr0=''),
  2026 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2026, CurrentID=0, Status='live', Symbol='ENO2', Aliases='HEL-S-279, NSE', description='enolase 2 (gamma, neuronal)', other_designations='2-phospho-D-glycerate hydro-lyase|2-phospho-D-glycerate hydrolyase|epididymis secretory protein Li 279|neural enolase|neuron specific gamma enolase|neuron-specific enolase|neurone-specific enolase', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6914450, end_position_on_the_genomic_accession=6923696, orientation='plus', exon_count=12, OMIM=131360, no_hdr0=''),
  2027 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2027, CurrentID=0, Status='live', Symbol='ENO3', Aliases='GSD13, MSE', description='enolase 3 (beta, muscle)', other_designations='2-phospho-D-glycerate hydrolyase|muscle-specific enolase|skeletal muscle enolase', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=4949182, end_position_on_the_genomic_accession=4957131, orientation='plus', exon_count=14, OMIM=131370, no_hdr0=''),
  2028 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2028, CurrentID=0, Status='live', Symbol='ENPEP', Aliases='APA, CD249, gp160', description='glutamyl aminopeptidase', other_designations='AP-A|EAP|aminopeptidase A|differentiation antigen gp160|glutamyl aminopeptidase (aminopeptidase A)', map_location='4q25', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=110476073, end_position_on_the_genomic_accession=110563337, orientation='plus', exon_count=20, OMIM=138297, no_hdr0=''),
  2029 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2029, CurrentID=0, Status='live', Symbol='ENSA', Aliases='ARPP-19e', description='endosulfine alpha', other_designations='', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150622123, end_position_on_the_genomic_accession=150629622, orientation='minus', exon_count=6, OMIM=603061, no_hdr0=''),
  2030 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2030, CurrentID=0, Status='live', Symbol='SLC29A1', Aliases='ENT1', description='solute carrier family 29 (equilibrative nucleoside transporter), member 1', other_designations='equilibrative nitrobenzylmercaptopurine riboside (NBMPR)-sensitive nucleoside transporter|equilibrative nucleoside transporter 1 variant ata|nucleoside transporter, es-type|solute carrier family 29 (nucleoside transporters), member 1', map_location='6p21.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=44219505, end_position_on_the_genomic_accession=44234151, orientation='plus', exon_count=18, OMIM=602193, no_hdr0=''),
  222658 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=222658, CurrentID=0, Status='live', Symbol='KCTD20', Aliases='C6orf69, dJ108K11.3', description='potassium channel tetramerization domain containing 20', other_designations='potassium channel tetramerisation domain containing 20', map_location='6p21.31', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=36442767, end_position_on_the_genomic_accession=36491143, orientation='plus', exon_count=11, OMIM=615932, no_hdr0=''),
  2033 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2033, CurrentID=0, Status='live', Symbol='EP300', Aliases='KAT3B, RSTS2, p300', description='E1A binding protein p300', other_designations='E1A-associated protein p300|E1A-binding protein, 300kD|p300 HAT', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=41092610, end_position_on_the_genomic_accession=41180077, orientation='plus', exon_count=31, OMIM=602700, no_hdr0=''),
  2034 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2034, CurrentID=0, Status='live', Symbol='EPAS1', Aliases='ECYT4, HIF2A, HLF, MOP2, PASD2, bHLHe73', description='endothelial PAS domain protein 1', other_designations='EPAS-1|HIF-1-alpha-like factor|HIF-1alpha-like factor|HIF-2-alpha|HIF2-alpha|PAS domain-containing protein 2|basic-helix-loop-helix-PAS protein MOP2|class E basic helix-loop-helix protein 73|hypoxia-inducible factor 2 alpha|hypoxia-inducible factor 2-alpha|member of PAS protein 2', map_location='2p21-p16', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=46297402, end_position_on_the_genomic_accession=46386703, orientation='plus', exon_count=17, OMIM=603349, no_hdr0=''),
  2035 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2035, CurrentID=0, Status='live', Symbol='EPB41', Aliases='4.1R, EL1, HE', description='erythrocyte membrane protein band 4.1', other_designations='EPB4.1|P4.1|band 4.1|elliptocytosis 1, RH-linked|erythrocyte surface protein band 4.1', map_location='1p33-p32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=28887091, end_position_on_the_genomic_accession=29120046, orientation='plus', exon_count=29, OMIM=130500, no_hdr0=''),
  2036 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2036, CurrentID=0, Status='live', Symbol='EPB41L1', Aliases='4.1N, MRD11', description='erythrocyte membrane protein band 4.1-like 1', other_designations='neuron-type nonerythroid protein 4.1|neuronal protein 4.1', map_location='20q11.2-q12', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=36064891, end_position_on_the_genomic_accession=36232799, orientation='plus', exon_count=37, OMIM=602879, no_hdr0=''),
  2037 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2037, CurrentID=0, Status='live', Symbol='EPB41L2', Aliases='4.1-G, 4.1G', description='erythrocyte membrane protein band 4.1-like 2', other_designations='erythrocyte membrane protein band 4.1 like-protein 2|generally expressed protein 4.1', map_location='6q23', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=130828173, end_position_on_the_genomic_accession=131063322, orientation='minus', exon_count=30, OMIM=603237, no_hdr0=''),
  2038 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2038, CurrentID=0, Status='live', Symbol='EPB42', Aliases='PA, SPH5', description='erythrocyte membrane protein band 4.2', other_designations='P4.2|erythrocyte protein 4.2|erythrocyte surface protein band 4.2', map_location='15q15-q21', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=43197227, end_position_on_the_genomic_accession=43225861, orientation='minus', exon_count=16, OMIM=177070, no_hdr0=''),
  2039 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2039, CurrentID=0, Status='live', Symbol='DMTN', Aliases='DMT, EPB49', description='dematin actin binding protein', other_designations='erythrocyte membrane protein band 4.9 (dematin)', map_location='8p21.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=22049149, end_position_on_the_genomic_accession=22082527, orientation='plus', exon_count=21, OMIM=125305, no_hdr0=''),
  2040 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2040, CurrentID=0, Status='live', Symbol='STOM', Aliases='BND7, EPB7, EPB72', description='stomatin', other_designations='erythrocyte membrane protein band 7.2 (stomatin)|erythrocyte surface protein band 7.2|protein 7.2b', map_location='9q34.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=121338988, end_position_on_the_genomic_accession=121370304, orientation='minus', exon_count=8, OMIM=133090, no_hdr0=''),
  2041 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2041, CurrentID=0, Status='live', Symbol='EPHA1', Aliases='EPH, EPHT, EPHT1', description='EPH receptor A1', other_designations='eph tyrosine kinase 1|erythropoietin-producing hepatoma amplified sequence|erythropoietin-producing hepatoma receptor|hEpha1|oncogene EPH|soluble EPHA1 variant 1|soluble EPHA1 variant 2|tyrosine-protein kinase receptor EPH', map_location='7q34', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=143390782, end_position_on_the_genomic_accession=143408892, orientation='minus', exon_count=20, OMIM=179610, no_hdr0=''),
  2042 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2042, CurrentID=0, Status='live', Symbol='EPHA3', Aliases='EK4, ETK, ETK1, HEK, HEK4, TYRO4', description='EPH receptor A3', other_designations='EPH-like kinase 4|TYRO4 protein tyrosine kinase|eph-like tyrosine kinase 1|human embryo kinase 1|tyrosine-protein kinase receptor ETK1', map_location='3p11.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=89107524, end_position_on_the_genomic_accession=89482134, orientation='plus', exon_count=17, OMIM=179611, no_hdr0=''),
  2043 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2043, CurrentID=0, Status='live', Symbol='EPHA4', Aliases='HEK8, SEK, TYRO1', description='EPH receptor A4', other_designations='EK8|EPH-like kinase 8|TYRO1 protein tyrosine kinase|receptor protein-tyrosine kinase HEK8|tyrosine-protein kinase TYRO1|tyrosine-protein kinase receptor SEK', map_location='2q36.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=221418027, end_position_on_the_genomic_accession=221574202, orientation='minus', exon_count=19, OMIM=602188, no_hdr0=''),
  2044 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2044, CurrentID=0, Status='live', Symbol='EPHA5', Aliases='CEK7, EHK-1, EHK1, EK7, HEK7, TYRO4', description='EPH receptor A5', other_designations='EPH homology kinase 1|EPH-like kinase 7|brain-specific kinase|receptor protein-tyrosine kinase HEK7|tyrosine-protein kinase receptor EHK-1', map_location='4q13.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=65319563, end_position_on_the_genomic_accession=65670495, orientation='minus', exon_count=21, OMIM=600004, no_hdr0=''),
  2045 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2045, CurrentID=0, Status='live', Symbol='EPHA7', Aliases='EHK-3, EHK3, EK11, HEK11', description='EPH receptor A7', other_designations='EPH homology kinase 3|EPH-like kinase 11|Eph homology kinase-3|receptor protein-tyrosine kinase HEK11|tyrosine-protein kinase receptor EHK-3', map_location='6q16.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=93240020, end_position_on_the_genomic_accession=93419584, orientation='minus', exon_count=18, OMIM=602190, no_hdr0=''),
  2046 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2046, CurrentID=0, Status='live', Symbol='EPHA8', Aliases='EEK, EK3, HEK3', description='EPH receptor A8', other_designations='EPH- and ELK-related kinase|EPH- and ELK-related tyrosine kinase|EPH-like kinase 3|hydroxyaryl-protein kinase|protein-tyrosine kinase|tyrosine-protein kinase receptor EEK|tyrosylprotein kinase', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22563508, end_position_on_the_genomic_accession=22603594, orientation='plus', exon_count=26, OMIM=176945, no_hdr0=''),
  2047 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2047, CurrentID=0, Status='live', Symbol='EPHB1', Aliases='ELK, EPHT2, Hek6, NET', description='EPH receptor B1', other_designations='EK6|EPH-like kinase 6|eph tyrosine kinase 2|neuronally-expressed EPH-related tyrosine kinase|soluble EPHB1 variant 1|tyrosine-protein kinase receptor EPH-2', map_location='3q22.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=134795257, end_position_on_the_genomic_accession=135260467, orientation='plus', exon_count=21, OMIM=600600, no_hdr0=''),
  2048 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2048, CurrentID=0, Status='live', Symbol='EPHB2', Aliases='CAPB, DRT, EK5, EPHT3, ERK, Hek5, PCBC, Tyro5', description='EPH receptor B2', other_designations='EPH-like kinase 5|developmentally-regulated Eph-related tyrosine kinase|elk-related tyrosine kinase|eph tyrosine kinase 3|protein-tyrosine kinase HEK5|renal carcinoma antigen NY-REN-47|tyrosine-protein kinase TYRO5|tyrosine-protein kinase receptor EPH-3', map_location='1p36.1-p35', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22710770, end_position_on_the_genomic_accession=22915330, orientation='plus', exon_count=17, OMIM=600997, no_hdr0=''),
  2049 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2049, CurrentID=0, Status='live', Symbol='EPHB3', Aliases='ETK2, HEK2, TYRO6', description='EPH receptor B3', other_designations='EK2|EPH-like kinase 2|EPH-like tyrosine kinase 2|EPH-like tyrosine kinase-2|embryonic kinase 2|human embryo kinase 2|tyrosine-protein kinase TYRO6', map_location='3q27.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184561799, end_position_on_the_genomic_accession=184582408, orientation='plus', exon_count=16, OMIM=601839, no_hdr0=''),
  2050 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2050, CurrentID=0, Status='live', Symbol='EPHB4', Aliases='HTK, MYK1, TYRO11', description='EPH receptor B4', other_designations='ephrin receptor EphB4|hepatoma transmembrane kinase|soluble EPHB4 variant 1|soluble EPHB4 variant 2|soluble EPHB4 variant 3|tyrosine-protein kinase TYRO11|tyrosine-protein kinase receptor HTK', map_location='7q22', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=100802565, end_position_on_the_genomic_accession=100827521, orientation='minus', exon_count=17, OMIM=600011, no_hdr0=''),
  2051 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2051, CurrentID=0, Status='live', Symbol='EPHB6', Aliases='HEP', description='EPH receptor B6', other_designations='human kinase-defective Eph-family receptor protein|tyrosine-protein kinase-defective receptor EPH-6', map_location='7q33-q35', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=142854643, end_position_on_the_genomic_accession=142871093, orientation='plus', exon_count=21, OMIM=602757, no_hdr0=''),
  2052 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2052, CurrentID=0, Status='live', Symbol='EPHX1', Aliases='EPHX, EPOX, HYL1, MEH', description='epoxide hydrolase 1', other_designations='epoxide hydratase|epoxide hydrolase 1 microsomal|epoxide hydrolase 1, microsomal (xenobiotic)', map_location='1q42.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=225810074, end_position_on_the_genomic_accession=225845563, orientation='plus', exon_count=10, OMIM=132810, no_hdr0=''),
  2053 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2053, CurrentID=0, Status='live', Symbol='EPHX2', Aliases='CEH, SEH', description='epoxide hydrolase 2', other_designations='epoxide hydratase|epoxide hydrolase 2, cytoplasmic|epoxide hydrolase 2, cytosolic|epoxide hydrolase, soluble', map_location='8p21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=27491002, end_position_on_the_genomic_accession=27544922, orientation='plus', exon_count=19, OMIM=132811, no_hdr0=''),
  2054 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2054, CurrentID=0, Status='live', Symbol='STX2', Aliases='EPIM, EPMA, STX2B, STX2C, STX2', description='syntaxin 2', other_designations='epimorphin', map_location='12q24.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=130774883, end_position_on_the_genomic_accession=130839274, orientation='minus', exon_count=14, OMIM=132350, no_hdr0=''),
  2055 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2055, CurrentID=0, Status='live', Symbol='CLN8', Aliases='C8orf61, EPMR', description='ceroid-lipofuscinosis, neuronal 8', other_designations='ceroid-lipofuscinosis, neuronal 8 (epilepsy, progressive with mental retardation)', map_location='8p23', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=1755778, end_position_on_the_genomic_accession=1786570, orientation='plus', exon_count=6, OMIM=607837, no_hdr0=''),
  2056 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2056, CurrentID=0, Status='live', Symbol='EPO', Aliases='EP, MVCD2', description='erythropoietin', other_designations='epoetin', map_location='7q22', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=100720800, end_position_on_the_genomic_accession=100723700, orientation='plus', exon_count=5, OMIM=133170, no_hdr0=''),
  2057 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2057, CurrentID=0, Status='live', Symbol='EPOR', Aliases='EPO-R', description='erythropoietin receptor', other_designations='', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=11377205, end_position_on_the_genomic_accession=11384342, orientation='minus', exon_count=8, OMIM=133171, no_hdr0=''),
  2058 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2058, CurrentID=0, Status='live', Symbol='EPRS', Aliases='EARS, GLUPRORS, PARS, PIG32, QARS, QPRS', description='glutamyl-prolyl-tRNA synthetase', other_designations='bifunctional aminoacyl-tRNA synthetase|cell proliferation-inducing gene 32 protein|glutamate tRNA ligase|glutamatyl-prolyl-tRNA synthetase|glutaminyl-tRNA synthetase|proliferation-inducing gene 32 protein|proliferation-inducing protein 32|proline tRNA ligase|proline-tRNA ligase|prolyl-tRNA synthetase', map_location='1q41', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=219968600, end_position_on_the_genomic_accession=220046658, orientation='minus', exon_count=32, OMIM=138295, no_hdr0=''),
  2059 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2059, CurrentID=0, Status='live', Symbol='EPS8', Aliases='DFNB102', description='epidermal growth factor receptor pathway substrate 8', other_designations='', map_location='12p12.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=15620141, end_position_on_the_genomic_accession=15789576, orientation='minus', exon_count=25, OMIM=600206, no_hdr0=''),
  2060 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2060, CurrentID=0, Status='live', Symbol='EPS15', Aliases='AF-1P, AF1P, MLLT5', description='epidermal growth factor receptor pathway substrate 15', other_designations='ALL1 fused gene from chromosome 1|protein AF-1p', map_location='1p32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=51354263, end_position_on_the_genomic_accession=51519354, orientation='minus', exon_count=27, OMIM=600051, no_hdr0=''),
  728229 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=728229, CurrentID=0, Status='live', Symbol='TMEM191B', Aliases='', description='transmembrane protein 191B', other_designations='', map_location='22q11.21', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=18527802, end_position_on_the_genomic_accession=18530794, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  222659 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=222659, CurrentID=0, Status='live', Symbol='PXT1', Aliases='STEPP', description='peroxisomal, testis specific 1', other_designations='small testis-specific peroxisomal protein', map_location='6p21.31', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=36390551, end_position_on_the_genomic_accession=36442889, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  2063 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2063, CurrentID=0, Status='live', Symbol='NR2F6', Aliases='EAR-2, EAR2, ERBAL2', description='nuclear receptor subfamily 2 group F member 6', other_designations='ERBA-related gene-2|V-erbA-related protein 2|nuclear receptor V-erbA-related|nuclear receptor subfamily 2, group F, member 6|v-erb-a avian erythroblastic leukemia viral oncogene homolog-like 2', map_location='19p13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=17231885, end_position_on_the_genomic_accession=17245342, orientation='minus', exon_count=4, OMIM=132880, no_hdr0=''),
  2064 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2064, CurrentID=0, Status='live', Symbol='ERBB2', Aliases='CD340, HER-2, HER-2/neu, HER2, MLN 19, NEU, NGL, TKR1', description='erb-b2 receptor tyrosine kinase 2', other_designations='c-erb B2/neu protein|herstatin|human epidermal growth factor receptor 2|metastatic lymph node gene 19 protein|neuro/glioblastoma derived oncogene homolog|neuroblastoma/glioblastoma derived oncogene homolog|p185erbB2|proto-oncogene Neu|proto-oncogene c-ErbB-2|tyrosine kinase-type cell surface receptor HER2|v-erb-b2 avian erythroblastic leukemia viral oncogene homolog 2|v-erb-b2 avian erythroblastic leukemia viral oncoprotein 2|v-erb-b2 erythroblastic leukemia viral oncogene homolog 2, neuro/glioblastoma derived oncogene homolog', map_location='17q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=39688084, end_position_on_the_genomic_accession=39728662, orientation='plus', exon_count=32, OMIM=164870, no_hdr0=''),
  2065 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2065, CurrentID=0, Status='live', Symbol='ERBB3', Aliases='ErbB-3, HER3, LCCS2, MDA-BF-1, c-erbB-3, c-erbB3, erbB3-S, p180-ErbB3, p45-sErbB3, p85-sErbB3', description='erb-b2 receptor tyrosine kinase 3', other_designations='human epidermal growth factor receptor 3|proto-oncogene-like protein c-ErbB-3|tyrosine kinase-type cell surface receptor HER3|v-erb-b2 avian erythroblastic leukemia viral oncogene homolog 3', map_location='12q13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=56080025, end_position_on_the_genomic_accession=56103507, orientation='plus', exon_count=28, OMIM=190151, no_hdr0=''),
  2066 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2066, CurrentID=0, Status='live', Symbol='ERBB4', Aliases='ALS19, HER4, p180erbB4', description='erb-b2 receptor tyrosine kinase 4', other_designations='ERBB4 transcript variant I12DEL|ERBB4 transcript variant I20DEL|avian erythroblastic leukemia viral (v-erb-b2) oncogene homolog 4|human epidermal growth factor receptor 4|proto-oncogene-like protein c-ErbB-4|tyrosine kinase-type cell surface receptor HER4|v-erb-a erythroblastic leukemia viral oncogene homolog 4|v-erb-b2 avian erythroblastic leukemia viral oncogene homolog 4', map_location='2q33.3-q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=211375717, end_position_on_the_genomic_accession=212539155, orientation='minus', exon_count=29, OMIM=600543, no_hdr0=''),
  2067 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2067, CurrentID=0, Status='live', Symbol='ERCC1', Aliases='COFS4, RAD10, UV20', description='excision repair cross-complementation group 1', other_designations='excision repair cross-complementing rodent repair deficiency, complementation group 1 (includes overlapping antisense sequence)', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45407333, end_position_on_the_genomic_accession=45478820, orientation='minus', exon_count=12, OMIM=126380, no_hdr0=''),
  2068 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2068, CurrentID=0, Status='live', Symbol='ERCC2', Aliases='COFS2, EM9, TFIIH, TTD, TTD1, XPD', description='excision repair cross-complementation group 2', other_designations='BTF2 p80|CXPD|DNA excision repair protein ERCC-2|DNA repair protein complementing XP-D cells|TFIIH 80 kDa subunit|TFIIH basal transcription factor complex 80 kDa subunit|TFIIH basal transcription factor complex helicase XPB subunit|TFIIH basal transcription factor complex helicase subunit|TFIIH p80|basic transcription factor 2 80 kDa subunit|excision repair cross-complementing rodent repair deficiency, complementation group 2|xeroderma pigmentosum complementary group D|xeroderma pigmentosum group D-complementing protein', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45351391, end_position_on_the_genomic_accession=45370646, orientation='minus', exon_count=24, OMIM=126340, no_hdr0=''),
  2069 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2069, CurrentID=0, Status='live', Symbol='EREG', Aliases='EPR, ER, Ep', description='epiregulin', other_designations='', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=74365143, end_position_on_the_genomic_accession=74388760, orientation='plus', exon_count=5, OMIM=602061, no_hdr0=''),
  2070 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2070, CurrentID=0, Status='live', Symbol='EYA4', Aliases='CMD1J, DFNA10', description='EYA transcriptional coactivator and phosphatase 4', other_designations='dJ78N10.1 (eyes absent)|eyes absent-like protein 4', map_location='6q23', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=133241335, end_position_on_the_genomic_accession=133532120, orientation='plus', exon_count=22, OMIM=603550, no_hdr0=''),
  2071 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2071, CurrentID=0, Status='live', Symbol='ERCC3', Aliases='BTF2, GTF2H, RAD25, TFIIH, TTD2, XPB', description='excision repair cross-complementation group 3', other_designations='BTF2 p89|DNA excision repair protein ERCC-3|DNA repair helicase|DNA repair protein complementing XP-B cells|TFIIH 89 kDa subunit|TFIIH basal transcription factor complex 89 kDa subunit|TFIIH p89|basic transcription factor 2 89 kDa subunit|excision repair cross-complementing rodent repair deficiency, complementation group 3|xeroderma pigmentosum group B-complementing protein|xeroderma pigmentosum, complementation group B', map_location='2q21', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=127257290, end_position_on_the_genomic_accession=127294176, orientation='minus', exon_count=15, OMIM=133510, no_hdr0=''),
  2072 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2072, CurrentID=0, Status='live', Symbol='ERCC4', Aliases='ERCC11, FANCQ, RAD1, XFEPS, XPF', description='excision repair cross-complementation group 4', other_designations='DNA excision repair protein ERCC-4|DNA repair protein complementing XP-F cells|excision repair cross-complementing rodent repair deficiency, complementation group 4|excision-repair, complementing defective, in Chinese hamster|xeroderma pigmentosum group F-complementing protein|xeroderma pigmentosum, complementation group F', map_location='16p13.12', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=13920145, end_position_on_the_genomic_accession=13952348, orientation='plus', exon_count=14, OMIM=133520, no_hdr0=''),
  2073 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2073, CurrentID=0, Status='live', Symbol='ERCC5', Aliases='COFS3-201, ERCM2, UVDR, XPG, XPGC, ERCC5', description='excision repair cross-complementation group 5', other_designations='DNA excision repair protein ERCC-5|XPG-complementing protein|excision repair cross-complementing rodent repair deficiency, complementation group 5|xeroderma pigmentosum, complementation group G', map_location='13q33', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=102845841, end_position_on_the_genomic_accession=102876001, orientation='plus', exon_count=15, OMIM=133530, no_hdr0=''),
  2074 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2074, CurrentID=0, Status='live', Symbol='ERCC6', Aliases='ARMD5, CKN2, COFS, COFS1, CSB, RAD26, UVSS1', description='excision repair cross-complementation group 6', other_designations='ATP-dependent helicase ERCC6|Cockayne syndrome group B protein|cockayne syndrome protein CSB|excision repair cross-complementing rodent repair deficiency, complementation group 6', map_location='10q11.23', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=49454480, end_position_on_the_genomic_accession=49539123, orientation='minus', exon_count=21, OMIM=609413, no_hdr0=''),
  2077 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2077, CurrentID=0, Status='live', Symbol='ERF', Aliases='CRS4, PE-2, PE2', description='Ets2 repressor factor', other_designations='', map_location='19q13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=42247561, end_position_on_the_genomic_accession=42255164, orientation='minus', exon_count=8, OMIM=611888, no_hdr0=''),
  165918 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=165918, CurrentID=0, Status='live', Symbol='RNF168', Aliases='hRNF168', description='ring finger protein 168, E3 ubiquitin protein ligase', other_designations='', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=196468783, end_position_on_the_genomic_accession=196503768, orientation='minus', exon_count=7, OMIM=612688, no_hdr0=''),
  2079 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2079, CurrentID=0, Status='live', Symbol='ERH', Aliases='DROER', description='enhancer of rudimentary homolog (Drosophila)', other_designations='', map_location='14q24.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=69380123, end_position_on_the_genomic_accession=69398304, orientation='minus', exon_count=4, OMIM=601191, no_hdr0=''),
  2081 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2081, CurrentID=0, Status='live', Symbol='ERN1', Aliases='IRE1, IRE1P, IRE1a, hIRE1p', description='endoplasmic reticulum to nucleus signaling 1', other_designations='ER to nucleus signalling 1|endoplasmic reticulum-to-nucleus signaling 1|inositol-requiring 1|inositol-requiring enzyme 1|inositol-requiring protein 1|ire1-alpha|protein kinase/endoribonuclease', map_location='17q24.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=64043030, end_position_on_the_genomic_accession=64130142, orientation='minus', exon_count=22, OMIM=604033, no_hdr0=''),
  93190 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=93190, CurrentID=0, Status='live', Symbol='C1orf158', Aliases='', description='chromosome 1 open reading frame 158', other_designations='', map_location='1p36.21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=12746186, end_position_on_the_genomic_accession=12761169, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  2086 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2086, CurrentID=0, Status='live', Symbol='ERV3-1', Aliases='ERV-R, ERV3, ERVR, HERV-R, HERVR, envR', description='endogenous retrovirus group 3 member 1', other_designations='ERV-3 envelope protein|ERV-R envelope protein|ERV3-1 envelope protein|HERV-R envelope protein|HERV-R_7q21.2 provirus ancestral Env polyprotein|endogenous retroviral sequence 3|endogenous retrovirus group 3, member 1', map_location='7q11.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=64990355, end_position_on_the_genomic_accession=65006746, orientation='minus', exon_count=2, OMIM=131170, no_hdr0=''),
  55717 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=55717, CurrentID=0, Status='live', Symbol='WDR11', Aliases='BRWD2, DR11, HH14, WDR15', description='WD repeat domain 11', other_designations='WD repeat domain 15|WD repeat-containing protein 15|bromodomain and WD repeat-containing protein 2', map_location='10q26', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=120851175, end_position_on_the_genomic_accession=120909526, orientation='plus', exon_count=30, OMIM=606417, no_hdr0=''),
  2090 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2090, CurrentID=0, Status='live', Symbol='ESA4', Aliases='', description='esterase A4', other_designations='', map_location='11q13-q22', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=133220, no_hdr0=''),
  2091 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2091, CurrentID=0, Status='live', Symbol='FBL', Aliases='FIB, FLRN, RNU3IP1', description='fibrillarin', other_designations='34 kDa nucleolar scleroderma antigen|34-kD nucleolar scleroderma antigen|RNA, U3 small nucleolar interacting protein 1|histone-glutamine methyltransferase', map_location='19q13.1', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=39834453, end_position_on_the_genomic_accession=39846414, orientation='minus', exon_count=9, OMIM=134795, no_hdr0=''),
  284338 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284338, CurrentID=0, Status='live', Symbol='PRR19', Aliases='', description='proline rich 19', other_designations='', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=42302132, end_position_on_the_genomic_accession=42310821, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  255394 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=255394, CurrentID=0, Status='live', Symbol='TCP11L2', Aliases='', description='t-complex 11, testis-specific-like 2', other_designations='', map_location='12q23.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=106302784, end_position_on_the_genomic_accession=106347587, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  2097 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2097, CurrentID=0, Status='live', Symbol='ESB3', Aliases='', description='esterase B3', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=133290, no_hdr0=''),
  2098 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2098, CurrentID=0, Status='live', Symbol='ESD', Aliases='FGH', description='esterase D', other_designations='esterase 10|esterase D/formylglutathione hydrolase|methylumbelliferyl-acetate deacetylase', map_location='13q14.1-q14.2', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=46771256, end_position_on_the_genomic_accession=46797681, orientation='minus', exon_count=14, OMIM=133280, no_hdr0=''),
  2099 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2099, CurrentID=0, Status='live', Symbol='ESR1', Aliases='ER, ESR, ESRA, ESTRR, Era, NR3A1', description='estrogen receptor 1', other_designations='ER-alpha|estradiol receptor|estrogen nuclear receptor alpha|estrogen receptor alpha E1-E2-1-2|estrogen receptor alpha E1-N2-E2-1-2|estrogen receptor alpha splice variant, CTERP-1|estrogen receptor alpha splice variant, ERalphaDup5|estrogen receptor alpha splice variant, ERalphai45a|estrogen receptor alpha splice variant, ERalphai45bL|estrogen receptor alpha splice variant, ERalphai45bS|estrogen receptor alpha splice variant, ERalphai45c|estrogen receptor alpha splice variant, ERalphai56|estrogen receptor alpha splice variant, ERalphai67|nuclear receptor subfamily 3 group A member 1', map_location='6q25.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=151690496, end_position_on_the_genomic_accession=152103274, orientation='plus', exon_count=18, OMIM=133430, no_hdr0=''),
  2100 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2100, CurrentID=0, Status='live', Symbol='ESR2', Aliases='ER-BETA, ESR-BETA, ESRB, ESTRB, Erb, NR3A2', description='estrogen receptor 2 (ER beta)', other_designations='estrogen receptor beta 4|nuclear receptor subfamily 3 group A member 2', map_location='14q23.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=64172925, end_position_on_the_genomic_accession=64338550, orientation='minus', exon_count=20, OMIM=601663, no_hdr0=''),
  2101 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2101, CurrentID=0, Status='live', Symbol='ESRRA', Aliases='ERR1, ERRa, ERRalpha, ESRL1, NR3B1', description='estrogen related receptor alpha', other_designations='ERR-alpha|estrogen receptor-like 1|estrogen-related nuclear receptor alpha|estrogen-related receptor alpha|nuclear receptor subfamily 3 group B member 1', map_location='11q13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=64305528, end_position_on_the_genomic_accession=64316743, orientation='plus', exon_count=8, OMIM=601998, no_hdr0=''),
  2103 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2103, CurrentID=0, Status='live', Symbol='ESRRB', Aliases='DFNB35, ERR2, ERRb, ESRL2, NR3B2', description='estrogen related receptor beta', other_designations='ERR beta-2|ERR-beta|ERRbeta-2|estrogen receptor-like 2|estrogen-related nuclear receptor beta|estrogen-related receptor beta|nuclear receptor ERRB2|nuclear receptor subfamily 3 group B member 2|orphan nuclear receptor', map_location='14q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=76371299, end_position_on_the_genomic_accession=76501839, orientation='plus', exon_count=17, OMIM=602167, no_hdr0=''),
  2104 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2104, CurrentID=0, Status='live', Symbol='ESRRG', Aliases='ERR3, ERRgamma, NR3B3', description='estrogen related receptor gamma', other_designations='ERR gamma-2|estrogen receptor-related protein 3|nuclear receptor subfamily 3 group B member 3', map_location='1q41', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=216503246, end_position_on_the_genomic_accession=217137755, orientation='minus', exon_count=26, OMIM=602969, no_hdr0=''),
  54964 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=54964, CurrentID=0, Status='live', Symbol='C1orf56', Aliases='MENT', description='chromosome 1 open reading frame 56', other_designations='methylated in normal thymocytes protein', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=151047783, end_position_on_the_genomic_accession=151051420, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  2107 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2107, CurrentID=0, Status='live', Symbol='ETF1', Aliases='D5S1995, ERF, ERF1, RF1, SUP45L1, TB3-1', description='eukaryotic translation termination factor 1', other_designations='polypeptide chain release factor 1|protein Cl1|sup45 (yeast omnipotent suppressor 45) homolog-like 1', map_location='5q31.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=138506093, end_position_on_the_genomic_accession=138543300, orientation='minus', exon_count=13, OMIM=600285, no_hdr0=''),
  2108 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2108, CurrentID=0, Status='live', Symbol='ETFA', Aliases='EMA, GA2, MADD', description='electron transfer flavoprotein alpha subunit', other_designations='alpha-ETF|electron transfer flavoprotein alpha-subunit|electron transfer flavoprotein, alpha polypeptide|electron-transfer-flavoprotein alpha polypeptide|glutaric aciduria II', map_location='15q23-q25', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=76216287, end_position_on_the_genomic_accession=76311469, orientation='minus', exon_count=13, OMIM=608053, no_hdr0=''),
  2109 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2109, CurrentID=0, Status='live', Symbol='ETFB', Aliases='FP585, MADD', description='electron transfer flavoprotein beta subunit', other_designations='beta-ETF|electron transfer flavoprotein beta-subunit|electron transfer flavoprotein, beta polypeptide|electron-transfer-flavoprotein, beta polypeptide|electron-transferring-flavoprotein, beta polypeptide', map_location='19q13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=51345155, end_position_on_the_genomic_accession=51366418, orientation='minus', exon_count=6, OMIM=130410, no_hdr0=''),
  2110 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2110, CurrentID=0, Status='live', Symbol='ETFDH', Aliases='ETFQO, MADD', description='electron transfer flavoprotein dehydrogenase', other_designations='ETF dehydrogenase|ETF-QO|ETF-ubiquinone oxidoreductase|electron-transferring-flavoprotein dehydrogenase', map_location='4q32-q35', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=158672101, end_position_on_the_genomic_accession=158708713, orientation='plus', exon_count=13, OMIM=231675, no_hdr0=''),
  728945 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=728945, CurrentID=0, Status='live', Symbol='PPIAL4F', Aliases='', description='peptidylprolyl isomerase A like 4F', other_designations='PPIase A-like 4F|cyclophilin-LC (COAS2) pseudogene|peptidylprolyl isomerase A (cyclophilin A)-like 4F', map_location='1q21.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=144592868, end_position_on_the_genomic_accession=144593652, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  2113 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2113, CurrentID=0, Status='live', Symbol='ETS1', Aliases='ETS-1, EWSR2, c-ets-1, p54', description='v-ets avian erythroblastosis virus E26 oncogene homolog 1', other_designations='Avian erythroblastosis virus E26 (v-ets) oncogene homolog-1|v-ets avian erythroblastosis virus E2 oncogene homolog 1', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=128458761, end_position_on_the_genomic_accession=128587584, orientation='minus', exon_count=12, OMIM=164720, no_hdr0=''),
  2114 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2114, CurrentID=0, Status='live', Symbol='ETS2', Aliases='ETS2IT1', description='v-ets avian erythroblastosis virus E26 oncogene homolog 2', other_designations='oncogene ETS-2|v-ets avian erythroblastosis virus E2 oncogene homolog 2|v-ets erythroblastosis virus E26 oncogene homolog 2', map_location='21q22.2', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=38805307, end_position_on_the_genomic_accession=38824955, orientation='plus', exon_count=12, OMIM=164740, no_hdr0=''),
  2115 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2115, CurrentID=0, Status='live', Symbol='ETV1', Aliases='ER81', description='ets variant 1', other_designations='ets variant gene 1|ets-related protein 81', map_location='7p21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=13891229, end_position_on_the_genomic_accession=13991425, orientation='minus', exon_count=21, OMIM=600541, no_hdr0=''),
  22984 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=22984, CurrentID=0, Status='live', Symbol='PDCD11', Aliases='ALG-4, ALG4, NFBP, RRP5', description='programmed cell death 11', other_designations='NF-kappa-B-binding protein|apoptosis-linked gene 4|programmed cell death protein 11', map_location='10q24.33', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=103396624, end_position_on_the_genomic_accession=103446295, orientation='plus', exon_count=37, OMIM=612333, no_hdr0=''),
  2117 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2117, CurrentID=0, Status='live', Symbol='ETV3', Aliases='METS, PE-1, PE1, bA110J1.4', description='ets variant 3', other_designations='ETS domain transcriptional repressor PE1|ets variant gene 3, ETS family transcriptional repressor|mitogenic Ets transcriptional suppressor', map_location='1q21-q23', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=157121191, end_position_on_the_genomic_accession=157138591, orientation='minus', exon_count=5, OMIM=164873, no_hdr0=''),
  2118 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2118, CurrentID=0, Status='live', Symbol='ETV4', Aliases='E1A-F, E1AF, PEA3, PEAS3', description='ets variant 4', other_designations='EWS protein/E1A enhancer binding protein chimera|adenovirus E1A enhancer-binding protein|ets variant gene 4 (E1A enhancer-binding protein, E1AF)|polyomavirus enhancer activator 3 homolog', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43527843, end_position_on_the_genomic_accession=43546432, orientation='minus', exon_count=14, OMIM=600711, no_hdr0=''),
  2119 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2119, CurrentID=0, Status='live', Symbol='ETV5', Aliases='ERM', description='ets variant 5', other_designations='ets-related molecule|ets-related protein ERM', map_location='3q28', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186046317, end_position_on_the_genomic_accession=186109112, orientation='minus', exon_count=13, OMIM=601600, no_hdr0=''),
  2120 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2120, CurrentID=0, Status='live', Symbol='ETV6', Aliases='TEL, TEL/ABL, THC5', description='ets variant 6', other_designations='ETS translocation variant 6|ETS-related protein Tel1|TEL1 oncogene|ets variant gene 6 (TEL oncogene)', map_location='12p13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=11649854, end_position_on_the_genomic_accession=11895402, orientation='plus', exon_count=13, OMIM=600618, no_hdr0=''),
  2121 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2121, CurrentID=0, Status='live', Symbol='EVC', Aliases='DWF-11, EVCL, EVC', description='EvC ciliary complex subunit 1', other_designations='Ellis van Creveld protein|Ellis van Creveld syndrome', map_location='4p16', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=5711189, end_position_on_the_genomic_accession=5829045, orientation='plus', exon_count=29, OMIM=604831, no_hdr0=''),
  2122 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2122, CurrentID=0, Status='live', Symbol='MECOM', Aliases='AML1-EVI-1, EVI1, MDS1, MDS1-EVI1, PRDM3', description='MDS1 and EVI1 complex locus', other_designations='AML1-EVI-1 fusion protein|MDS1 and EVI1 complex locus protein MDS1|ecotropic virus integration site 1 protein homolog|myelodysplasia syndrome-associated protein 1|oncogene EVI1|zinc finger protein Evi1', map_location='3q26.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=169083499, end_position_on_the_genomic_accession=169663786, orientation='minus', exon_count=22, OMIM=165215, no_hdr0=''),
  2123 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2123, CurrentID=0, Status='live', Symbol='EVI2A', Aliases='EVDA, EVI-2A, EVI2', description='ecotropic viral integration site 2A', other_designations='ecotropic viral integration site 2A protein homolog', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=31316410, end_position_on_the_genomic_accession=31321749, orientation='minus', exon_count=3, OMIM=158380, no_hdr0=''),
  2124 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2124, CurrentID=0, Status='live', Symbol='EVI2B', Aliases='CD361, D17S376, EVDB', description='ecotropic viral integration site 2B', other_designations='EVI-2B|ecotropic viral integration site 2B protein homolog', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=31302870, end_position_on_the_genomic_accession=31314389, orientation='minus', exon_count=4, OMIM=158381, no_hdr0=''),
  2125 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2125, CurrentID=0, Status='live', Symbol='EVPL', Aliases='EVPK', description='envoplakin', other_designations='210 kDa cornified envelope precursor protein|210 kDa paraneoplastic pemphigus antigen|p210', map_location='17q25.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=76006845, end_position_on_the_genomic_accession=76027452, orientation='minus', exon_count=22, OMIM=601590, no_hdr0=''),
  2128 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2128, CurrentID=0, Status='live', Symbol='EVX1', Aliases='EVX-1', description='even-skipped homeobox 1', other_designations='eve, even-skipped homeo box homolog 1|eve, even-skipped homeobox homolog 1|even-skipped homeo box 1 (homolog of Drosophila)', map_location='7p15.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=27242545, end_position_on_the_genomic_accession=27247819, orientation='plus', exon_count=5, OMIM=142996, no_hdr0=''),
  100996792 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=100996792, CurrentID=0, Status='live', Symbol='LOC100996792', Aliases='', description='dual specificity mitogen-activated protein kinase kinase 3', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=21773015, end_position_on_the_genomic_accession=21783473, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  2130 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2130, CurrentID=0, Status='live', Symbol='EWSR1', Aliases='EWS, EWS-FLI1, bK984G1.4', description='EWS RNA binding protein 1', other_designations='EWS RNA-binding protein 1|EWS RNA-binding protein variant 6|Ewing sarcoma breakpoint region 1|Ewings sarcoma EWS-Fli1 (type 1) oncogene', map_location='22q12.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=29268009, end_position_on_the_genomic_accession=29300525, orientation='plus', exon_count=19, OMIM=133450, no_hdr0=''),
  2131 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2131, CurrentID=0, Status='live', Symbol='EXT1', Aliases='EXT, LGCR, LGS, TRPS2, TTV', description='exostosin glycosyltransferase 1', other_designations='Glucuronosyl-N-acetylglucosaminyl-proteoglycan 4-alpha-N- acetylglucosaminyltransferase|Langer-Giedion syndrome chromosome region|N-acetylglucosaminyl-proteoglycan 4-beta-glucuronosyltransferase|exostoses (multiple) 1|exostosin 1|glucuronosyl-N-acetylglucosaminyl-proteoglycan/N-acetylglucosaminyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|multiple exostoses protein 1|putative tumor suppressor protein EXT1', map_location='8q24.11', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=117799363, end_position_on_the_genomic_accession=118111819, orientation='minus', exon_count=11, OMIM=608177, no_hdr0=''),
  2132 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2132, CurrentID=0, Status='live', Symbol='EXT2', Aliases='SOTV, SSMS', description='exostosin glycosyltransferase 2', other_designations='N-acetylglucosaminyl-proteoglycan 4-beta-glucuronosyltransferase|glucuronosyl-N-acetylglucosaminyl-proteoglycan/N-acetylglucosaminyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|multiple exostoses protein 2|putative tumor suppressor protein EXT2', map_location='11p12-p11', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=44095549, end_position_on_the_genomic_accession=44245430, orientation='plus', exon_count=17, OMIM=608210, no_hdr0=''),
  2134 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2134, CurrentID=0, Status='live', Symbol='EXTL1', Aliases='EXTL', description='exostosin-like glycosyltransferase 1', other_designations='alpha-N-acetylglucosaminyltransferase II|exostoses (multiple)-like 1|exostosin-L|glucuronosyl-N-acetylglucosaminyl-proteoglycan 4-alpha-N- acetylglucosaminyltransferase|glucuronosyl-N-acetylglucosaminyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|glucuronyl-N-acetylglucosaminylproteoglycan alpha-1,4-N- acetylglucosaminyltransferase|multiple exostosis-like protein', map_location='1p36.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=26021741, end_position_on_the_genomic_accession=26036464, orientation='plus', exon_count=12, OMIM=601738, no_hdr0=''),
  2135 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2135, CurrentID=0, Status='live', Symbol='EXTL2', Aliases='EXTR2', description='exostosin-like glycosyltransferase 2', other_designations='EXT-related protein 2|alpha-1,4-N-acetylhexosaminyltransferase EXTL2|alpha-GalNAcT EXTL2|exostoses (multiple)-like 2|glucuronyl-galactosyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|processed exostosin-like 2', map_location='1p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=100872372, end_position_on_the_genomic_accession=100895323, orientation='minus', exon_count=8, OMIM=602411, no_hdr0=''),
  2137 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2137, CurrentID=0, Status='live', Symbol='EXTL3', Aliases='BOTV, EXTL1L, EXTR1, REGR, RPR', description='exostosin like glycosyltransferase 3', other_designations='EXT-related 1|exostoses (multiple)-like 3|exostosin tumor-like 3|exostosin-like glycosyltransferase 3|glucuronyl-galactosyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|hereditary multiple exostoses gene isolog|putative tumor suppressor protein EXTL3|reg receptor', map_location='8p21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=28701473, end_position_on_the_genomic_accession=28753690, orientation='plus', exon_count=7, OMIM=605744, no_hdr0=''),
  2138 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2138, CurrentID=0, Status='live', Symbol='EYA1', Aliases='BOP, BOR, BOS1, OFC1', description='EYA transcriptional coactivator and phosphatase 1', other_designations='', map_location='8q13.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=71197433, end_position_on_the_genomic_accession=71548109, orientation='minus', exon_count=24, OMIM=601653, no_hdr0=''),
  2139 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2139, CurrentID=0, Status='live', Symbol='EYA2', Aliases='EAB1', description='EYA transcriptional coactivator and phosphatase 2', other_designations='', map_location='20q13.1', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=46894624, end_position_on_the_genomic_accession=47188844, orientation='plus', exon_count=17, OMIM=601654, no_hdr0=''),
  2140 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2140, CurrentID=0, Status='live', Symbol='EYA3', Aliases='', description='EYA transcriptional coactivator and phosphatase 3', other_designations='eyes absent 3', map_location='1p36', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=27970344, end_position_on_the_genomic_accession=28088675, orientation='minus', exon_count=22, OMIM=601655, no_hdr0=''),
  284346 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=284346, CurrentID=0, Status='live', Symbol='ZNF575', Aliases='', description='zinc finger protein 575', other_designations='', map_location='19q13.31', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=43531805, end_position_on_the_genomic_accession=43536138, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  124460 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=124460, CurrentID=0, Status='live', Symbol='SNX20', Aliases='SLIC1', description='sorting nexin 20', other_designations='selectin ligand interactor cytoplasmic 1|selectin ligand interactor cytoplasmic-1|selectin ligand-interactor cytoplasmic 1', map_location='16q12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=50666300, end_position_on_the_genomic_accession=50681353, orientation='minus', exon_count=5, OMIM=613281, no_hdr0=''),
  2145 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2145, CurrentID=0, Status='live', Symbol='EZH1', Aliases='KMT6B', description='enhancer of zeste 1 polycomb repressive complex 2 subunit', other_designations='ENX-2|enhancer of zeste homolog 1', map_location='17q21.1-q21.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=42700275, end_position_on_the_genomic_accession=42745078, orientation='minus', exon_count=21, OMIM=601674, no_hdr0=''),
  2146 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2146, CurrentID=0, Status='live', Symbol='EZH2', Aliases='ENX-1, ENX1, EZH1b, KMT6, KMT6A, WVS, WVS2, EZH2', description='enhancer of zeste 2 polycomb repressive complex 2 subunit', other_designations='enhancer of zeste homolog 2|lysine N-methyltransferase 6', map_location='7q35-q36', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=148807372, end_position_on_the_genomic_accession=148884349, orientation='minus', exon_count=25, OMIM=601573, no_hdr0=''),
  2147 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2147, CurrentID=0, Status='live', Symbol='F2', Aliases='PT, RPRGL2, THPH1', description='coagulation factor II, thrombin', other_designations='coagulation factor II (thrombin)|prepro-coagulation factor II|prothrombin B-chain|serine protease', map_location='11p11', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=46719192, end_position_on_the_genomic_accession=46739506, orientation='plus', exon_count=14, OMIM=176930, no_hdr0=''),
  2149 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2149, CurrentID=0, Status='live', Symbol='F2R', Aliases='CF2R, HTR, PAR-1, PAR1, TR', description='coagulation factor II thrombin receptor', other_designations='coagulation factor II (thrombin) receptor|protease-activated receptor 1', map_location='5q13', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=76716043, end_position_on_the_genomic_accession=76735770, orientation='plus', exon_count=2, OMIM=187930, no_hdr0=''),
  2150 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2150, CurrentID=0, Status='live', Symbol='F2RL1', Aliases='GPR11, PAR2', description='F2R like trypsin receptor 1', other_designations='G-protein coupled receptor 11|coagulation factor II (thrombin) receptor-like 1|coagulation factor II receptor-like 1|protease-activated receptor 2|thrombin receptor-like 1', map_location='5q13', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=76819008, end_position_on_the_genomic_accession=76835315, orientation='plus', exon_count=2, OMIM=600933, no_hdr0=''),
  2151 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2151, CurrentID=0, Status='live', Symbol='F2RL2', Aliases='PAR-3, PAR3', description='coagulation factor II thrombin receptor like 2', other_designations='Coagulation factor II receptor-like 2 (protease-actovated receptor 3)|coagulation factor II (thrombin) receptor-like 2|protease-activated receptor 3|proteinase-activated receptor-3|thrombin receptor-like 2', map_location='5q13', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=76615482, end_position_on_the_genomic_accession=76623434, orientation='minus', exon_count=2, OMIM=601919, no_hdr0=''),
  2152 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2152, CurrentID=0, Status='live', Symbol='F3', Aliases='CD142, TF, TFA', description='coagulation factor III, tissue factor', other_designations='coagulation factor III (thromboplastin, tissue factor)', map_location='1p22-p21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=94529176, end_position_on_the_genomic_accession=94541857, orientation='minus', exon_count=6, OMIM=134390, no_hdr0=''),
  2153 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2153, CurrentID=0, Status='live', Symbol='F5', Aliases='FVL, PCCF, RPRGL1, THPH2', description='coagulation factor V', other_designations='activated protein c cofactor|coagulation factor V (proaccelerin, labile factor)|coagulation factor V jinjiang A2 domain|factor V Leiden', map_location='1q23', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=169511954, end_position_on_the_genomic_accession=169586531, orientation='minus', exon_count=25, OMIM=612309, no_hdr0=''),
  440107 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=440107, CurrentID=0, Status='live', Symbol='PLEKHG7', Aliases='', description='pleckstrin homology and RhoGEF domain containing G7', other_designations='PH domain-containing family G member 7|pleckstrin homology domain containing, family G (with RhoGef domain) member 7', map_location='12q22', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=92736489, end_position_on_the_genomic_accession=92772745, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  2155 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2155, CurrentID=0, Status='live', Symbol='F7', Aliases='SPCA', description='coagulation factor VII', other_designations='FVII coagulation protein|coagulation factor VII (serum prothrombin conversion accelerator)|eptacog alfa|proconvertin', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=113105788, end_position_on_the_genomic_accession=113120681, orientation='plus', exon_count=11, OMIM=613878, no_hdr0=''),
  2157 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2157, CurrentID=0, Status='live', Symbol='F8', Aliases='AHF, DXS1253EB, F8C, FVIII, HEMA, F8', description='coagulation factor VIII', other_designations='antihemophilic factor|coagulation factor VIII, procoagulant component|coagulation factor VIIIc|factor VIII F8B', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154835788, end_position_on_the_genomic_accession=155026934, orientation='minus', exon_count=28, OMIM=300841, no_hdr0=''),
  2158 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2158, CurrentID=0, Status='live', Symbol='F9', Aliases='F9 p22, FIX, HEMB, P19, PTC, THPH8', description='coagulation factor IX', other_designations='Christmas factor|factor 9|factor IX F9|plasma thromboplastic component|plasma thromboplastin component', map_location='Xq27.1-q27.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=139530734, end_position_on_the_genomic_accession=139563464, orientation='plus', exon_count=8, OMIM=300746, no_hdr0=''),
  2159 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2159, CurrentID=0, Status='live', Symbol='F10', Aliases='FX, FXA', description='coagulation factor X', other_designations='Stuart-Prower factor|factor Xa|prothrombinase', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=113122799, end_position_on_the_genomic_accession=113149529, orientation='plus', exon_count=8, OMIM=613872, no_hdr0=''),
  2160 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2160, CurrentID=0, Status='live', Symbol='F11', Aliases='FXI', description='coagulation factor XI', other_designations='PTA|plasma thromboplastin antecedent', map_location='4q35', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=186265945, end_position_on_the_genomic_accession=186289681, orientation='plus', exon_count=17, OMIM=264900, no_hdr0=''),
  2161 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2161, CurrentID=0, Status='live', Symbol='F12', Aliases='HAE3, HAEX, HAF', description='coagulation factor XII', other_designations='Hageman factor|beta-factor XIIa part 1|beta-factor XIIa part 2|coagulation factor XII (Hageman factor)|coagulation factor XIIa heavy chain|coagulation factor XIIa light chain', map_location='5q35.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=177402138, end_position_on_the_genomic_accession=177416524, orientation='minus', exon_count=16, OMIM=610619, no_hdr0=''),
  2162 : NtData(tax_id=9606, Org_name='Homo sapiens', GeneID=2162, CurrentID=0, Status='live', Symbol='F13A1', Aliases='F13A