from django.db import models


class Question(models.Model):
    question_text = models.CharField(max_length=200)
    pub_date = models.DateTimeField("date published")
    opened = models.BooleanField(default=True)

    def __str__(self):
        return self.question_text

    class Meta:
        verbose_name = "Poll"
        verbose_name_plural = "Polls"


class Choice(models.Model):
    question = models.ForeignKey(Question, on_delete=models.CASCADE)
    choice_text = models.CharField(max_length=200)
    votes = models.IntegerField(default=0)

    def __str__(self):
        return self.choice_text
