import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpcComputeVnicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_vnic#id DataOpcComputeVnic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_vnic#name DataOpcComputeVnic#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/d/compute_vnic opc_compute_vnic}
*/
export declare class DataOpcComputeVnic extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opc_compute_vnic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/d/compute_vnic opc_compute_vnic} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpcComputeVnicConfig
    */
    constructor(scope: Construct, id: string, config: DataOpcComputeVnicConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get macAddress(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get tags(): string[];
    get transitFlag(): cdktf.IResolvable;
    get uri(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
