import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpcComputeNetworkInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_network_interface#id DataOpcComputeNetworkInterface#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_network_interface#instance_id DataOpcComputeNetworkInterface#instance_id}
    */
    readonly instanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_network_interface#instance_name DataOpcComputeNetworkInterface#instance_name}
    */
    readonly instanceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_network_interface#interface DataOpcComputeNetworkInterface#interface}
    */
    readonly interface: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/d/compute_network_interface opc_compute_network_interface}
*/
export declare class DataOpcComputeNetworkInterface extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opc_compute_network_interface";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/d/compute_network_interface opc_compute_network_interface} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpcComputeNetworkInterfaceConfig
    */
    constructor(scope: Construct, id: string, config: DataOpcComputeNetworkInterfaceConfig);
    get dns(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _instanceName?;
    get instanceName(): string;
    set instanceName(value: string);
    get instanceNameInput(): string | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    get interfaceInput(): string | undefined;
    get ipAddress(): string;
    get ipNetwork(): string;
    get isDefaultGateway(): cdktf.IResolvable;
    get macAddress(): string;
    get model(): string;
    get nameServers(): string[];
    get nat(): string[];
    get searchDomains(): string[];
    get secLists(): string[];
    get sharedNetwork(): cdktf.IResolvable;
    get vnic(): string;
    get vnicSets(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
