import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpcComputeIpReservationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_ip_reservation#id DataOpcComputeIpReservation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_ip_reservation#name DataOpcComputeIpReservation#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/d/compute_ip_reservation opc_compute_ip_reservation}
*/
export declare class DataOpcComputeIpReservation extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opc_compute_ip_reservation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/d/compute_ip_reservation opc_compute_ip_reservation} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpcComputeIpReservationConfig
    */
    constructor(scope: Construct, id: string, config: DataOpcComputeIpReservationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ip(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get parentPool(): string;
    get permanent(): cdktf.IResolvable;
    get tags(): string[];
    get used(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
