import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSecurityAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_association#id ComputeSecurityAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_association#name ComputeSecurityAssociation#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_association#seclist ComputeSecurityAssociation#seclist}
    */
    readonly seclist: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_association#vcable ComputeSecurityAssociation#vcable}
    */
    readonly vcable: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_security_association opc_compute_security_association}
*/
export declare class ComputeSecurityAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_security_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_security_association opc_compute_security_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSecurityAssociationConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSecurityAssociationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _seclist?;
    get seclist(): string;
    set seclist(value: string);
    get seclistInput(): string | undefined;
    private _vcable?;
    get vcable(): string;
    set vcable(value: string);
    get vcableInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
