import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeOrchestratedInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#description ComputeOrchestratedInstance#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#desired_state ComputeOrchestratedInstance#desired_state}
    */
    readonly desiredState: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#id ComputeOrchestratedInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#name ComputeOrchestratedInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#tags ComputeOrchestratedInstance#tags}
    */
    readonly tags?: string[];
    /**
    * instance block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#instance ComputeOrchestratedInstance#instance}
    */
    readonly instance: ComputeOrchestratedInstanceInstance[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#timeouts ComputeOrchestratedInstance#timeouts}
    */
    readonly timeouts?: ComputeOrchestratedInstanceTimeouts;
}
export interface ComputeOrchestratedInstanceInstanceNetworkingInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#dns ComputeOrchestratedInstance#dns}
    */
    readonly dns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#index ComputeOrchestratedInstance#index}
    */
    readonly index: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#ip_address ComputeOrchestratedInstance#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#ip_network ComputeOrchestratedInstance#ip_network}
    */
    readonly ipNetwork?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#is_default_gateway ComputeOrchestratedInstance#is_default_gateway}
    */
    readonly isDefaultGateway?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#mac_address ComputeOrchestratedInstance#mac_address}
    */
    readonly macAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#name_servers ComputeOrchestratedInstance#name_servers}
    */
    readonly nameServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#nat ComputeOrchestratedInstance#nat}
    */
    readonly nat?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#search_domains ComputeOrchestratedInstance#search_domains}
    */
    readonly searchDomains?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#sec_lists ComputeOrchestratedInstance#sec_lists}
    */
    readonly secLists?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#shared_network ComputeOrchestratedInstance#shared_network}
    */
    readonly sharedNetwork?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#vnic ComputeOrchestratedInstance#vnic}
    */
    readonly vnic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#vnic_sets ComputeOrchestratedInstance#vnic_sets}
    */
    readonly vnicSets?: string[];
}
export declare function computeOrchestratedInstanceInstanceNetworkingInfoToTerraform(struct?: ComputeOrchestratedInstanceInstanceNetworkingInfo | cdktf.IResolvable): any;
export declare class ComputeOrchestratedInstanceInstanceNetworkingInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeOrchestratedInstanceInstanceNetworkingInfo | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeOrchestratedInstanceInstanceNetworkingInfo | cdktf.IResolvable | undefined);
    private _dns?;
    get dns(): string[];
    set dns(value: string[]);
    resetDns(): void;
    get dnsInput(): string[] | undefined;
    private _index?;
    get index(): number;
    set index(value: number);
    get indexInput(): number | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _ipNetwork?;
    get ipNetwork(): string;
    set ipNetwork(value: string);
    resetIpNetwork(): void;
    get ipNetworkInput(): string | undefined;
    private _isDefaultGateway?;
    get isDefaultGateway(): boolean | cdktf.IResolvable;
    set isDefaultGateway(value: boolean | cdktf.IResolvable);
    resetIsDefaultGateway(): void;
    get isDefaultGatewayInput(): boolean | cdktf.IResolvable | undefined;
    private _macAddress?;
    get macAddress(): string;
    set macAddress(value: string);
    resetMacAddress(): void;
    get macAddressInput(): string | undefined;
    private _nameServers?;
    get nameServers(): string[];
    set nameServers(value: string[]);
    resetNameServers(): void;
    get nameServersInput(): string[] | undefined;
    private _nat?;
    get nat(): string[];
    set nat(value: string[]);
    resetNat(): void;
    get natInput(): string[] | undefined;
    private _searchDomains?;
    get searchDomains(): string[];
    set searchDomains(value: string[]);
    resetSearchDomains(): void;
    get searchDomainsInput(): string[] | undefined;
    private _secLists?;
    get secLists(): string[];
    set secLists(value: string[]);
    resetSecLists(): void;
    get secListsInput(): string[] | undefined;
    private _sharedNetwork?;
    get sharedNetwork(): boolean | cdktf.IResolvable;
    set sharedNetwork(value: boolean | cdktf.IResolvable);
    resetSharedNetwork(): void;
    get sharedNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _vnic?;
    get vnic(): string;
    set vnic(value: string);
    resetVnic(): void;
    get vnicInput(): string | undefined;
    private _vnicSets?;
    get vnicSets(): string[];
    set vnicSets(value: string[]);
    resetVnicSets(): void;
    get vnicSetsInput(): string[] | undefined;
}
export declare class ComputeOrchestratedInstanceInstanceNetworkingInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeOrchestratedInstanceInstanceNetworkingInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeOrchestratedInstanceInstanceNetworkingInfoOutputReference;
}
export interface ComputeOrchestratedInstanceInstanceStorage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#index ComputeOrchestratedInstance#index}
    */
    readonly index: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#volume ComputeOrchestratedInstance#volume}
    */
    readonly volume: string;
}
export declare function computeOrchestratedInstanceInstanceStorageToTerraform(struct?: ComputeOrchestratedInstanceInstanceStorage | cdktf.IResolvable): any;
export declare class ComputeOrchestratedInstanceInstanceStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeOrchestratedInstanceInstanceStorage | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeOrchestratedInstanceInstanceStorage | cdktf.IResolvable | undefined);
    private _index?;
    get index(): number;
    set index(value: number);
    get indexInput(): number | undefined;
    get name(): string;
    private _volume?;
    get volume(): string;
    set volume(value: string);
    get volumeInput(): string | undefined;
}
export declare class ComputeOrchestratedInstanceInstanceStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeOrchestratedInstanceInstanceStorage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeOrchestratedInstanceInstanceStorageOutputReference;
}
export interface ComputeOrchestratedInstanceInstance {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#boot_order ComputeOrchestratedInstance#boot_order}
    */
    readonly bootOrder?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#hostname ComputeOrchestratedInstance#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#image_list ComputeOrchestratedInstance#image_list}
    */
    readonly imageList?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#instance_attributes ComputeOrchestratedInstance#instance_attributes}
    */
    readonly instanceAttributes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#label ComputeOrchestratedInstance#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#name ComputeOrchestratedInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#persistent ComputeOrchestratedInstance#persistent}
    */
    readonly persistent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#reverse_dns ComputeOrchestratedInstance#reverse_dns}
    */
    readonly reverseDns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#shape ComputeOrchestratedInstance#shape}
    */
    readonly shape: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#ssh_keys ComputeOrchestratedInstance#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#tags ComputeOrchestratedInstance#tags}
    */
    readonly tags?: string[];
    /**
    * networking_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#networking_info ComputeOrchestratedInstance#networking_info}
    */
    readonly networkingInfo?: ComputeOrchestratedInstanceInstanceNetworkingInfo[] | cdktf.IResolvable;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#storage ComputeOrchestratedInstance#storage}
    */
    readonly storage?: ComputeOrchestratedInstanceInstanceStorage[] | cdktf.IResolvable;
}
export declare function computeOrchestratedInstanceInstanceToTerraform(struct?: ComputeOrchestratedInstanceInstance | cdktf.IResolvable): any;
export declare class ComputeOrchestratedInstanceInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeOrchestratedInstanceInstance | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeOrchestratedInstanceInstance | cdktf.IResolvable | undefined);
    get attributes(): string;
    get availabilityDomain(): string;
    private _bootOrder?;
    get bootOrder(): number[];
    set bootOrder(value: number[]);
    resetBootOrder(): void;
    get bootOrderInput(): number[] | undefined;
    get domain(): string;
    get entry(): number;
    get fingerprint(): string;
    get fqdn(): string;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    get id(): string;
    get imageFormat(): string;
    private _imageList?;
    get imageList(): string;
    set imageList(value: string);
    resetImageList(): void;
    get imageListInput(): string | undefined;
    private _instanceAttributes?;
    get instanceAttributes(): string;
    set instanceAttributes(value: string);
    resetInstanceAttributes(): void;
    get instanceAttributesInput(): string | undefined;
    get ipAddress(): string;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _persistent?;
    get persistent(): boolean | cdktf.IResolvable;
    set persistent(value: boolean | cdktf.IResolvable);
    resetPersistent(): void;
    get persistentInput(): boolean | cdktf.IResolvable | undefined;
    get placementRequirements(): string[];
    get platform(): string;
    get priority(): string;
    get quotaReservation(): string;
    get relationships(): string[];
    get resolvers(): string[];
    private _reverseDns?;
    get reverseDns(): boolean | cdktf.IResolvable;
    set reverseDns(value: boolean | cdktf.IResolvable);
    resetReverseDns(): void;
    get reverseDnsInput(): boolean | cdktf.IResolvable | undefined;
    private _shape?;
    get shape(): string;
    set shape(value: string);
    get shapeInput(): string | undefined;
    get site(): string;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    get startTime(): string;
    get state(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get vcable(): string;
    get virtio(): cdktf.IResolvable;
    get vncAddress(): string;
    private _networkingInfo;
    get networkingInfo(): ComputeOrchestratedInstanceInstanceNetworkingInfoList;
    putNetworkingInfo(value: ComputeOrchestratedInstanceInstanceNetworkingInfo[] | cdktf.IResolvable): void;
    resetNetworkingInfo(): void;
    get networkingInfoInput(): cdktf.IResolvable | ComputeOrchestratedInstanceInstanceNetworkingInfo[] | undefined;
    private _storage;
    get storage(): ComputeOrchestratedInstanceInstanceStorageList;
    putStorage(value: ComputeOrchestratedInstanceInstanceStorage[] | cdktf.IResolvable): void;
    resetStorage(): void;
    get storageInput(): cdktf.IResolvable | ComputeOrchestratedInstanceInstanceStorage[] | undefined;
}
export declare class ComputeOrchestratedInstanceInstanceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeOrchestratedInstanceInstance[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeOrchestratedInstanceInstanceOutputReference;
}
export interface ComputeOrchestratedInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#create ComputeOrchestratedInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#delete ComputeOrchestratedInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance#update ComputeOrchestratedInstance#update}
    */
    readonly update?: string;
}
export declare function computeOrchestratedInstanceTimeoutsToTerraform(struct?: ComputeOrchestratedInstanceTimeoutsOutputReference | ComputeOrchestratedInstanceTimeouts | cdktf.IResolvable): any;
export declare class ComputeOrchestratedInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeOrchestratedInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeOrchestratedInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance opc_compute_orchestrated_instance}
*/
export declare class ComputeOrchestratedInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_orchestrated_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_orchestrated_instance opc_compute_orchestrated_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeOrchestratedInstanceConfig
    */
    constructor(scope: Construct, id: string, config: ComputeOrchestratedInstanceConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    get desiredStateInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get version(): number;
    private _instance;
    get instance(): ComputeOrchestratedInstanceInstanceList;
    putInstance(value: ComputeOrchestratedInstanceInstance[] | cdktf.IResolvable): void;
    get instanceInput(): cdktf.IResolvable | ComputeOrchestratedInstanceInstance[] | undefined;
    private _timeouts;
    get timeouts(): ComputeOrchestratedInstanceTimeoutsOutputReference;
    putTimeouts(value: ComputeOrchestratedInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeOrchestratedInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
