import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeMachineImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_machine_image#account ComputeMachineImage#account}
    */
    readonly account: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_machine_image#attributes ComputeMachineImage#attributes}
    */
    readonly attributes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_machine_image#description ComputeMachineImage#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_machine_image#file ComputeMachineImage#file}
    */
    readonly file: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_machine_image#id ComputeMachineImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_machine_image#name ComputeMachineImage#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_machine_image opc_compute_machine_image}
*/
export declare class ComputeMachineImage extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_machine_image";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_machine_image opc_compute_machine_image} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeMachineImageConfig
    */
    constructor(scope: Construct, id: string, config: ComputeMachineImageConfig);
    private _account?;
    get account(): string;
    set account(value: string);
    get accountInput(): string | undefined;
    private _attributes?;
    get attributes(): string;
    set attributes(value: string);
    resetAttributes(): void;
    get attributesInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get errorReason(): string;
    private _file?;
    get file(): string;
    set file(value: string);
    get fileInput(): string | undefined;
    private _hypervisor;
    get hypervisor(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imageFormat(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get noUpload(): cdktf.IResolvable;
    get platform(): string;
    get state(): string;
    get uri(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
