TITLE Mod file for component: Component(id=gaba type=alphaCurrSynapse)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.8.0
         org.neuroml.model   v1.8.0
         jLEMS               v0.10.5

ENDCOMMENT

NEURON {
    POINT_PROCESS gaba
    RANGE tau_syn                           : parameter
    RANGE MSEC                              : parameter
    RANGE MVOLT                             : parameter
    RANGE NAMP                              : parameter
    
    RANGE i                                 : exposure
    
    
    NONSPECIFIC_CURRENT i 
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    tau_syn = 0.1 
    MSEC = 1 (ms)
    MVOLT = 1 (mV)
    NAMP = 1 (nA)
}

ASSIGNED {
    ? Standard Assigned variables with baseSynapse
    v (mV)
    celsius (degC)
    temperature (K)
    
    i (nA)                                 : derived variable
    rate_I (/ms)
    rate_A (/ms)
    
}

STATE {
    I  
    A  
    
}

INITIAL {
    temperature = celsius + 273.15
    
    rates()
    rates() ? To ensure correct initialisation.
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    
    
}

NET_RECEIVE(weight) {
    
    : paramMappings . : {gaba={I=I, A=A, tau_syn=tau_syn, MSEC=MSEC, MVOLT=MVOLT, NAMP=NAMP, i=i}}
    : state_discontinuity(A, A  + weight) : From gaba
    A = A  + weight : From gaba
    
}

DERIVATIVE states {
    rates()
    I' = rate_I 
    A' = rate_A 
    
}

PROCEDURE rates() {
    
    i = -1 * I  *  NAMP ? evaluable
    rate_I = (2.7182818*  A   -   I  )/(  tau_syn  *  MSEC  ) ? Note units of all quantities used here need to be consistent!
    rate_A = -  A   /(  tau_syn  *  MSEC  ) ? Note units of all quantities used here need to be consistent!
    
     
    
}

