SEANLAB Algorithms4
Pythonic Data Structures and Algorithms
=========================================
Minimal and clean example implementations of data structures and algorithms in Python 3.

## Contributing
Thanks for your interest in contributing! There are many ways to contribute to this project. [Get started here](CONTRIBUTING.md)

## Tests

### Use unittest
For running all tests write down:

    $ python3 -m unittest discover tests

For running some specific tests you can do this as following (Ex: sort):

    $ python3 -m unittest tests.test_sort

### Use pytest
For running all tests write down:

    $ python3 -m pytest tests

## Install
If you want to use the API algorithms in your code, it is as simple as:

    $ pip3 install seanalgorithms4

You can test by creating a python file: (Ex: use `merge_sort` in `sort`)

```python3
from seanalgorithms4.sort import merge_sort

if __name__ == "__main__":
    my_list = [1, 8, 3, 5, 6]
    my_list = merge_sort(my_list)
    print(my_list)
```

## Uninstall
If you want to uninstall seanalgorithms4, it is as simple as:

    $ pip3 uninstall -y seanalgorithms4

- [algorithms4_practice](algorithms4_practice)
    - [1.bisection](arithmetic_analysis/1.bisection.py)
    - [2.intersection](arithmetic_analysis/2.intersection.py)
    - [3.lu_decomposition](arithmetic_analysis/3.lu_decomposition.py)
    - [4.newton_method](arithmetic_analysis/4.newton_method.py)
    - [in_static_equilibrium](arithmetic_analysis/in_static_equilibrium.py)
    - [newton_raphson_method](arithmetic_analysis/newton_raphson_method.py)
    - [1.all_combinations](backtracking/1.all_combinations.py)
    - [2.all_permutations](backtracking/2.all_permutations.py)
    - [3.all_subsequences](backtracking/3.all_subsequences.py)
    - [4.minimax](backtracking/4.minimax.py)
    - [5.n_queens](backtracking/5.n_queens.py)
    - [6.sudoku](backtracking/6.sudoku.py)
    - [7.sum_of_subsets](backtracking/7.sum_of_subsets.py)
    - [quine_mc_cluskey_x](boolean_algebra_X/quine_mc_cluskey_x.py)
    - [affine_cipher](ciphers_X/affine_cipher.py)
    - [atbash](ciphers_X/atbash.py)
    - [base16](ciphers_X/base16.py)
    - [base32](ciphers_X/base32.py)
    - [base64_cipher](ciphers_X/base64_cipher.py)
    - [base85](ciphers_X/base85.py)
    - [brute_force_caesar_cipher](ciphers_X/brute_force_caesar_cipher.py)
    - [caesar_cipher](ciphers_X/caesar_cipher.py)
    - [cryptomath_module](ciphers_X/cryptomath_module.py)
    - [elgamal_key_generator](ciphers_X/elgamal_key_generator.py)
    - [hill_cipher](ciphers_X/hill_cipher.py)
    - [morse_code_implementation](ciphers_X/morse_code_implementation.py)
    - [onepad_cipher](ciphers_X/onepad_cipher.py)
    - [playfair_cipher](ciphers_X/playfair_cipher.py)
    - [rabin_miller](ciphers_X/rabin_miller.py)
    - [rot13](ciphers_X/rot13.py)
    - [rsa_cipher](ciphers_X/rsa_cipher.py)
    - [rsa_key_generator](ciphers_X/rsa_key_generator.py)
    - [simple_substitution_cipher](ciphers_X/simple_substitution_cipher.py)
    - [trafid_cipher](ciphers_X/trafid_cipher.py)
    - [transposition_cipher](ciphers_X/transposition_cipher.py)
    - [transposition_cipher_encrypt_decrypt_file](ciphers_X/transposition_cipher_encrypt_decrypt_file.py)
    - [vigenere_cipher](ciphers_X/vigenere_cipher.py)
    - [xor_cipher](ciphers_X/xor_cipher.py)
    - [burrows_wheeler](compression_X/burrows_wheeler.py)
    - [huffman](compression_X/huffman.py)
    - [peak_signal_to_noise_ratio](compression_X/peak_signal_to_noise_ratio.py)
    - [1.decimal_to_binary](conversions/1.decimal_to_binary.py)
    - [2.decimal_to_hexadecimal](conversions/2.decimal_to_hexadecimal.py)
    - [3.decimal_to_octal](conversions/3.decimal_to_octal.py)
    - [1.avl_tree](binary_tree/1.avl_tree.py)
    - [2.basic_binary_tree](binary_tree/2.basic_binary_tree.py)
    - [3.binary_search_tree](binary_tree/3.binary_search_tree.py)
    - [4.fenwick_tree](binary_tree/4.fenwick_tree.py)
    - [5.lazy_segment_tree](binary_tree/5.lazy_segment_tree.py)
    - [6.lca](binary_tree/6.lca.py)
    - [7.red_black_tree](binary_tree/7.red_black_tree.py)
    - [8.segment_tree](binary_tree/8.segment_tree.py)
    - [treap](binary_tree/treap.py)
    - [double_hash](hashing/double_hash.py)
    - [hash_table](hashing/hash_table.py)
    - [hash_table_with_linked_list](hashing/hash_table_with_linked_list.py)
    - [quadratic_probing](hashing/quadratic_probing.py)
    - [1.prime_numbers](number_theory/1.prime_numbers.py)
    - [binomial_heap](heap_X/binomial_heap.py)
    - [heap](heap_X/heap.py)
    - [doubly_linked_list](linked_list_X/doubly_linked_list.py)
    - [is_palindrome](linked_list_X/is_palindrome.py)
    - [singly_linked_list](linked_list_X/singly_linked_list.py)
    - [swap_nodes](linked_list_X/swap_nodes.py)
    - [1.double_ended_queue](queue/1.double_ended_queue.py)
    - [queue_on_list](queue/queue_on_list.py)
    - [queue_on_pseudo_stack](queue/queue_on_pseudo_stack.py)
    - [1.balanced_parentheses](stacks/1.balanced_parentheses.py)
    - [1.balanced_parentheses2](stacks/1.balanced_parentheses2.py)
    - [2.infix_to_postfix_conversion](stacks/2.infix_to_postfix_conversion.py)
    - [3.infix_to_prefix_conversion](stacks/3.infix_to_prefix_conversion.py)
    - [4.next_greater_element](stacks/4.next_greater_element.py)
    - [5.postfix_evaluation](stacks/5.postfix_evaluation.py)
    - [6.stock_span_problem](stacks/6.stock_span_problem.py)
    - [stack](stacks/stack.py)
    - [trie](trie/trie.py)
    - [change_contrast](digital_image_processing_X/change_contrast.py)
    - [test_digital_image_processing](digital_image_processing_X/test_digital_image_processing.py)
    - [canny](edge_detection/canny.py)
    - [convolve](filters/convolve.py)
    - [gaussian_filter](filters/gaussian_filter.py)
    - [median_filter](filters/median_filter.py)
    - [sobel_filter](filters/sobel_filter.py)
    - [1.closest_pair_of_points](divide_and_conquer/1.closest_pair_of_points.py)
    - [2.convex_hull](divide_and_conquer/2.convex_hull.py)
    - [3.inversions](divide_and_conquer/3.inversions.py)
    - [4.max_subarray_sum](divide_and_conquer/4.max_subarray_sum.py)
    - [1.abbreviation](dynamic_programming/1.abbreviation.py)
    - [10.k_means_clustering_tensorflow](dynamic_programming/10.k_means_clustering_tensorflow.py)
    - [11.knapsack](dynamic_programming/11.knapsack.py)
    - [12.longest_common_subsequence](dynamic_programming/12.longest_common_subsequence.py)
    - [13.longest_increasing_subsequence](dynamic_programming/13.longest_increasing_subsequence.py)
    - [14.longest_increasing_subsequence_o(nlogn)](dynamic_programming/14.longest_increasing_subsequence_o(nlogn).py)
    - [15.longest_sub_array](dynamic_programming/15.longest_sub_array.py)
    - [16.matrix_chain_order](dynamic_programming/16.matrix_chain_order.py)
    - [17.max_sub_array](dynamic_programming/17.max_sub_array.py)
    - [18.minimum_partition](dynamic_programming/18.minimum_partition.py)
    - [19.rod_cutting](dynamic_programming/19.rod_cutting.py)
    - [2.bitmask](dynamic_programming/2.bitmask.py)
    - [20.subset_generation](dynamic_programming/20.subset_generation.py)
    - [21.sum_of_subset](dynamic_programming/21.sum_of_subset.py)
    - [23.fibonacci](dynamic_programming/23.fibonacci.py)
    - [24.floyd_warshall](dynamic_programming/24.floyd_warshall.py)
    - [3.climbing_stairs](dynamic_programming/3.climbing_stairs.py)
    - [4.coin_change](dynamic_programming/4.coin_change.py)
    - [5.edit_distance](dynamic_programming/5.edit_distance.py)
    - [6.factorial](dynamic_programming/6.factorial.py)
    - [7.fast_fibonacci](dynamic_programming/7.fast_fibonacci.py)
    - [8.fractional_knapsack](dynamic_programming/8.fractional_knapsack.py)
    - [9.integer_partition](dynamic_programming/9.integer_partition.py)
    - [fibonacci](dynamic_programming/fibonacci.py)
    - [floyd_warshall](dynamic_programming/floyd_warshall.py)
    - [recieve_file](file_transfer_X/recieve_file.py)
    - [send_file](file_transfer_X/send_file.py)
    - [1.a_star](graphs/1.a_star.py)
    - [10.depth_first_search](graphs/10.depth_first_search.py)
    - [11.dfs](graphs/11.dfs.py)
    - [12.dijkstra](graphs/12.dijkstra.py)
    - [13.dijkstra_2](graphs/13.dijkstra_2.py)
    - [14.dijkstra_algorithm](graphs/14.dijkstra_algorithm.py)
    - [15.edmonds_karp_multiple_source_and_sink](graphs/15.edmonds_karp_multiple_source_and_sink.py)
    - [16.eulerian_path_and_circuit_for_undirected_graph](graphs/16.eulerian_path_and_circuit_for_undirected_graph.py)
    - [17.even_tree](graphs/17.even_tree.py)
    - [18.finding_bridges](graphs/18.finding_bridges.py)
    - [19.graph_list](graphs/19.graph_list.py)
    - [2.articulation_points](graphs/2.articulation_points.py)
    - [20.graph_matrix](graphs/20.graph_matrix.py)
    - [21.graphs_floyd_warshall](graphs/21.graphs_floyd_warshall.py)
    - [22.kahns_algorithm_long](graphs/22.kahns_algorithm_long.py)
    - [23.kahns_algorithm_topo](graphs/23.kahns_algorithm_topo.py)
    - [24.minimum_spanning_tree_prims](graphs/24.minimum_spanning_tree_prims.py)
    - [25.multi_hueristic_astar](graphs/25.multi_hueristic_astar.py)
    - [3.basic_graphs](graphs/3.basic_graphs.py)
    - [4.bellman_ford](graphs/4.bellman_ford.py)
    - [5.bfs](graphs/5.bfs.py)
    - [6.bfs_shortest_path](graphs/6.bfs_shortest_path.py)
    - [7.breadth_first_search](graphs/7.breadth_first_search.py)
    - [8.check_bipartite_graph_bfs](graphs/8.check_bipartite_graph_bfs.py)
    - [9.check_bipartite_graph_dfs](graphs/9.check_bipartite_graph_dfs.py)
    - [directed_and_undirected_(weighted)_graph_x](graphs/directed_and_undirected_(weighted)_graph_x.py)
    - [minimum_spanning_tree_kruskal_x](graphs/minimum_spanning_tree_kruskal_x.py)
    - [page_rank_x](graphs/page_rank_x.py)
    - [prim_x](graphs/prim_x.py)
    - [scc_kosaraju_x](graphs/scc_kosaraju_x.py)
    - [tarjans_scc_x](graphs/tarjans_scc_x.py)
    - [chaos_machine](hashes_x/chaos_machine.py)
    - [enigma_machine](hashes_x/enigma_machine.py)
    - [md5](hashes_x/md5.py)
    - [sha1](hashes_x/sha1.py)
    - [lib](src/lib.py)
    - [polynom-for-points](src/polynom-for-points.py)
    - [tests](src/tests.py)
    - [decision_tree](machine_learning_x/decision_tree.py)
    - [gradient_descent](machine_learning_x/gradient_descent.py)
    - [knn_sklearn](machine_learning_x/knn_sklearn.py)
    - [k_means_clust](machine_learning_x/k_means_clust.py)
    - [linear_regression](machine_learning_x/linear_regression.py)
    - [logistic_regression](machine_learning_x/logistic_regression.py)
    - [scoring_functions](machine_learning_x/scoring_functions.py)
    - [sorted_vector_machines](machine_learning_x/sorted_vector_machines.py)
    - [random_forest_classification](random_forest_classification/random_forest_classification.py)
    - [random_forest_regression](random_forest_regression/random_forest_regression.py)
    - [3n+1](maths/3n+1.py)
    - [abs](maths/abs.py)
    - [abs_max](maths/abs_max.py)
    - [abs_min](maths/abs_min.py)
    - [average_mean](maths/average_mean.py)
    - [average_median](maths/average_median.py)
    - [basic_maths](maths/basic_maths.py)
    - [binary_exponentiation](maths/binary_exponentiation.py)
    - [collatz_sequence](maths/collatz_sequence.py)
    - [extended_euclidean_algorithm](maths/extended_euclidean_algorithm.py)
    - [factorial_python](maths/factorial_python.py)
    - [factorial_recursive](maths/factorial_recursive.py)
    - [fermat_little_theorem](maths/fermat_little_theorem.py)
    - [fibonacci](maths/fibonacci.py)
    - [fibonacci_sequence_recursion](maths/fibonacci_sequence_recursion.py)
    - [find_lcm](maths/find_lcm.py)
    - [find_max](maths/find_max.py)
    - [find_min](maths/find_min.py)
    - [gaussian](maths/gaussian.py)
    - [greater_common_divisor](maths/greater_common_divisor.py)
    - [is_square_free](maths/is_square_free.py)
    - [largest_of_very_large_numbers](maths/largest_of_very_large_numbers.py)
    - [lucas_lehmer_primality_test](maths/lucas_lehmer_primality_test.py)
    - [lucas_series](maths/lucas_series.py)
    - [mobius_function](maths/mobius_function.py)
    - [modular_exponential](maths/modular_exponential.py)
    - [newton_raphson](maths/newton_raphson.py)
    - [prime_check](maths/prime_check.py)
    - [prime_factors](maths/prime_factors.py)
    - [quadratic_equations_complex_numbers](maths/quadratic_equations_complex_numbers.py)
    - [radix2_fft](maths/radix2_fft.py)
    - [segmented_sieve](maths/segmented_sieve.py)
    - [sieve_of_eratosthenes](maths/sieve_of_eratosthenes.py)
    - [simpson_rule](maths/simpson_rule.py)
    - [test](maths/test.py)
    - [test_prime_check](maths/test_prime_check.py)
    - [trapezoidal_rule](maths/trapezoidal_rule.py)
    - [volume](maths/volume.py)
    - [zellers_congruence](maths/zellers_congruence.py)
    - [1.matrix_operation](matrix/1.matrix_operation.py)
    - [2.nth_fibonacci_using_matrix_exponentiation](matrix/2.nth_fibonacci_using_matrix_exponentiation.py)
    - [3.rotate_matrix](matrix/3.rotate_matrix.py)
    - [4.searching_in_sorted_matrix](matrix/4.searching_in_sorted_matrix.py)
    - [5.spiral_print](matrix/5.spiral_print.py)
    - [sherman_morrison_x](matrix/sherman_morrison_x.py)
    - [test_matrix_operation](tests/test_matrix_operation.py)
    - [1.ford_fulkerson](networking_flow/1.ford_fulkerson.py)
    - [2.minimum_cut](networking_flow/2.minimum_cut.py)
    - [back_propagation_neural_network](neural_network_x/back_propagation_neural_network.py)
    - [convolution_neural_network](neural_network_x/convolution_neural_network.py)
    - [perceptron](neural_network_x/perceptron.py)
    - [anagrams](other_x/anagrams.py)
    - [binary_exponentiation](other_x/binary_exponentiation.py)
    - [binary_exponentiation_2](other_x/binary_exponentiation_2.py)
    - [detecting_english_programmatically](other_x/detecting_english_programmatically.py)
    - [euclidean_gcd](other_x/euclidean_gcd.py)
    - [fischer_yates_shuffle](other_x/fischer_yates_shuffle.py)
    - [frequency_finder](other_x/frequency_finder.py)
    - [game_of_life](other_x/game_of_life.py)
    - [linear_congruential_generator](other_x/linear_congruential_generator.py)
    - [nested_brackets](other_x/nested_brackets.py)
    - [palindrome](other_x/palindrome.py)
    - [password_generator](other_x/password_generator.py)
    - [primelib](other_x/primelib.py)
    - [sierpinski_triangle](other_x/sierpinski_triangle.py)
    - [tower_of_hanoi](other_x/tower_of_hanoi.py)
    - [two_sum](other_x/two_sum.py)
    - [word_patterns](other_x/word_patterns.py)
    - [sol1](problem_01/sol1.py)
    - [sol2](problem_01/sol2.py)
    - [sol3](problem_01/sol3.py)
    - [sol4](problem_01/sol4.py)
    - [sol5](problem_01/sol5.py)
    - [sol6](problem_01/sol6.py)
    - [sol1](problem_02/sol1.py)
    - [sol2](problem_02/sol2.py)
    - [sol3](problem_02/sol3.py)
    - [sol4](problem_02/sol4.py)
    - [sol1](problem_03/sol1.py)
    - [sol2](problem_03/sol2.py)
    - [sol1](problem_04/sol1.py)
    - [sol2](problem_04/sol2.py)
    - [sol1](problem_05/sol1.py)
    - [sol2](problem_05/sol2.py)
    - [sol1](problem_06/sol1.py)
    - [sol2](problem_06/sol2.py)
    - [sol3](problem_06/sol3.py)
    - [sol1](problem_07/sol1.py)
    - [sol2](problem_07/sol2.py)
    - [sol3](problem_07/sol3.py)
    - [sol1](problem_08/sol1.py)
    - [sol2](problem_08/sol2.py)
    - [sol1](problem_09/sol1.py)
    - [sol2](problem_09/sol2.py)
    - [sol3](problem_09/sol3.py)
    - [sol1](problem_10/sol1.py)
    - [sol2](problem_10/sol2.py)
    - [sol3](problem_10/sol3.py)
    - [sol1](problem_11/sol1.py)
    - [sol2](problem_11/sol2.py)
    - [sol1](problem_12/sol1.py)
    - [sol2](problem_12/sol2.py)
    - [sol1](problem_13/sol1.py)
    - [sol1](problem_14/sol1.py)
    - [sol2](problem_14/sol2.py)
    - [sol1](problem_15/sol1.py)
    - [sol1](problem_16/sol1.py)
    - [sol2](problem_16/sol2.py)
    - [sol1](problem_17/sol1.py)
    - [sol1](problem_19/sol1.py)
    - [sol1](problem_20/sol1.py)
    - [sol2](problem_20/sol2.py)
    - [sol1](problem_21/sol1.py)
    - [sol1](problem_22/sol1.py)
    - [sol2](problem_22/sol2.py)
    - [sol1](problem_234/sol1.py)
    - [sol1](problem_24/sol1.py)
    - [sol1](problem_25/sol1.py)
    - [sol2](problem_25/sol2.py)
    - [sol1](problem_28/sol1.py)
    - [solution](problem_29/solution.py)
    - [sol1](problem_31/sol1.py)
    - [sol1](problem_36/sol1.py)
    - [sol1](problem_40/sol1.py)
    - [sol1](problem_48/sol1.py)
    - [sol1](problem_52/sol1.py)
    - [sol1](problem_53/sol1.py)
    - [sol1](problem_551/sol1.py)
    - [sol1](problem_56/sol1.py)
    - [sol1](problem_76/sol1.py)
    - [build_directory_md](scripts_x/build_directory_md.py)
    - [validate_filenames](scripts_x/validate_filenames.py)
    - [1.binary_search](searches/1.binary_search.py)
    - [10.jump_search](searches/10.jump_search.py)
    - [11.linear_search](searches/11.linear_search.py)
    - [2.interpolation_search](searches/2.interpolation_search.py)
    - [3.jump_search](searches/3.jump_search.py)
    - [4.linear_search](searches/4.linear_search.py)
    - [5.quick_select](searches/5.quick_select.py)
    - [6.sentinel_linear_search](searches/6.sentinel_linear_search.py)
    - [7.ternary_search](searches/7.ternary_search.py)
    - [8.binary_search](searches/8.binary_search.py)
    - [9.interpolation_search](searches/9.interpolation_search.py)
    - [binary_search](searches/binary_search.py)
    - [linear_search](searches/linear_search.py)
    - [quick_select](searches/quick_select.py)
    - [sentinel_linear_search](searches/sentinel_linear_search.py)
    - [tabu_search](searches/tabu_search.py)
    - [ternary_search](searches/ternary_search.py)
    - [1.bitonic_sort](sorts/1.bitonic_sort.py)
    - [10.heap_sort](sorts/10.heap_sort.py)
    - [11.insertion_sort](sorts/11.insertion_sort.py)
    - [12.merge_sort](sorts/12.merge_sort.py)
    - [13.merge_sort_fastest](sorts/13.merge_sort_fastest.py)
    - [14.odd_even_transposition_parallel](sorts/14.odd_even_transposition_parallel.py)
    - [15.odd_even_transposition_single_threaded](sorts/15.odd_even_transposition_single_threaded.py)
    - [16.pancake_sort](sorts/16.pancake_sort.py)
    - [18.external_sort](sorts/18.external_sort.py)
    - [19.pancake_sort](sorts/19.pancake_sort.py)
    - [2.bogo_sort](sorts/2.bogo_sort.py)
    - [20.pigeon_sort](sorts/20.pigeon_sort.py)
    - [21.quick_sort](sorts/21.quick_sort.py)
    - [22.quick_sort_3_partition](sorts/22.quick_sort_3_partition.py)
    - [23.radix_sort](sorts/23.radix_sort.py)
    - [24.random_pivot_quick_sort](sorts/24.random_pivot_quick_sort.py)
    - [25.selection_sort](sorts/25.selection_sort.py)
    - [26.shell_sort](sorts/26.shell_sort.py)
    - [27.tim_sort](sorts/27.tim_sort.py)
    - [28.topological_sort](sorts/28.topological_sort.py)
    - [29.tree_sort](sorts/29.tree_sort.py)
    - [3.bubble_sort](sorts/3.bubble_sort.py)
    - [30.wiggle_sort](sorts/30.wiggle_sort.py)
    - [4.bucket_sort](sorts/4.bucket_sort.py)
    - [5.cocktail_shaker_sort](sorts/5.cocktail_shaker_sort.py)
    - [6.comb_sort](sorts/6.comb_sort.py)
    - [7.counting_sort](sorts/7.counting_sort.py)
    - [8.cycle_sort](sorts/8.cycle_sort.py)
    - [9.gnome_sort](sorts/9.gnome_sort.py)
    - [bitonic_sort](sorts/bitonic_sort.py)
    - [bogo_sort](sorts/bogo_sort.py)
    - [bubble_sort](sorts/bubble_sort.py)
    - [bucket_sort](sorts/bucket_sort.py)
    - [cocktail_shaker_sort](sorts/cocktail_shaker_sort.py)
    - [comb_sort](sorts/comb_sort.py)
    - [counting_sort](sorts/counting_sort.py)
    - [cycle_sort](sorts/cycle_sort.py)
    - [external_sort](sorts/external_sort.py)
    - [gnome_sort](sorts/gnome_sort.py)
    - [heap_sort](sorts/heap_sort.py)
    - [insertion_sort](sorts/insertion_sort.py)
    - [merge_sort](sorts/merge_sort.py)
    - [merge_sort_fastest](sorts/merge_sort_fastest.py)
    - [odd_even_transposition_parallel](sorts/odd_even_transposition_parallel.py)
    - [odd_even_transposition_single_threaded](sorts/odd_even_transposition_single_threaded.py)
    - [pancake_sort](sorts/pancake_sort.py)
    - [quick_sort](sorts/quick_sort.py)
    - [quick_sort_3_partition](sorts/quick_sort_3_partition.py)
    - [radix_sort](sorts/radix_sort.py)
    - [random_normal_distribution_quicksort_x](sorts/random_normal_distribution_quicksort_x.py)
    - [random_pivot_quick_sort](sorts/random_pivot_quick_sort.py)
    - [selection_sort](sorts/selection_sort.py)
    - [shell_sort](sorts/shell_sort.py)
    - [tim_sort](sorts/tim_sort.py)
    - [topological_sort](sorts/topological_sort.py)
    - [tree_sort](sorts/tree_sort.py)
    - [wiggle_sort](sorts/wiggle_sort.py)
    - [1.boyer_moore_search](strings/1.boyer_moore_search.py)
    - [2.knuth_morris_pratt](strings/2.knuth_morris_pratt.py)
    - [levenshtein_distance](strings/levenshtein_distance.py)
    - [manacher](strings/manacher.py)
    - [min_cost_string_conversion](strings/min_cost_string_conversion.py)
    - [naive_string_search](strings/naive_string_search.py)
    - [rabin_karp](strings/rabin_karp.py)
    - [binary_tree_traversals](traversals/binary_tree_traversals.py)
    - [bisection](arithmetic_analysis/bisection.py)
    - [intersection](arithmetic_analysis/intersection.py)
    - [in_static_equilibrium](arithmetic_analysis/in_static_equilibrium.py)
    - [lu_decomposition](arithmetic_analysis/lu_decomposition.py)
    - [newton_method](arithmetic_analysis/newton_method.py)
    - [newton_raphson_method](arithmetic_analysis/newton_raphson_method.py)
    - [all_combinations](backtracking/all_combinations.py)
    - [all_permutations](backtracking/all_permutations.py)
    - [all_subsequences](backtracking/all_subsequences.py)
    - [minimax](backtracking/minimax.py)
    - [n_queens](backtracking/n_queens.py)
    - [sudoku](backtracking/sudoku.py)
    - [sum_of_subsets](backtracking/sum_of_subsets.py)
    - [quine_mc_cluskey](boolean_algebra/quine_mc_cluskey.py)
    - [affine_cipher](ciphers/affine_cipher.py)
    - [atbash](ciphers/atbash.py)
    - [base16](ciphers/base16.py)
    - [base32](ciphers/base32.py)
    - [base64_cipher](ciphers/base64_cipher.py)
    - [base85](ciphers/base85.py)
    - [brute_force_caesar_cipher](ciphers/brute_force_caesar_cipher.py)
    - [caesar_cipher](ciphers/caesar_cipher.py)
    - [cryptomath_module](ciphers/cryptomath_module.py)
    - [elgamal_key_generator](ciphers/elgamal_key_generator.py)
    - [hill_cipher](ciphers/hill_cipher.py)
    - [morse_code_implementation](ciphers/morse_code_implementation.py)
    - [onepad_cipher](ciphers/onepad_cipher.py)
    - [playfair_cipher](ciphers/playfair_cipher.py)
    - [rabin_miller](ciphers/rabin_miller.py)
    - [rot13](ciphers/rot13.py)
    - [rsa_cipher](ciphers/rsa_cipher.py)
    - [rsa_key_generator](ciphers/rsa_key_generator.py)
    - [simple_substitution_cipher](ciphers/simple_substitution_cipher.py)
    - [trafid_cipher](ciphers/trafid_cipher.py)
    - [transposition_cipher](ciphers/transposition_cipher.py)
    - [transposition_cipher_encrypt_decrypt_file](ciphers/transposition_cipher_encrypt_decrypt_file.py)
    - [vigenere_cipher](ciphers/vigenere_cipher.py)
    - [xor_cipher](ciphers/xor_cipher.py)
    - [burrows_wheeler](compression/burrows_wheeler.py)
    - [huffman](compression/huffman.py)
    - [peak_signal_to_noise_ratio](compression/peak_signal_to_noise_ratio.py)
    - [decimal_to_binary](conversions/decimal_to_binary.py)
    - [decimal_to_hexadecimal](conversions/decimal_to_hexadecimal.py)
    - [decimal_to_octal](conversions/decimal_to_octal.py)
    - [avl_tree](binary_tree/avl_tree.py)
    - [basic_binary_tree](binary_tree/basic_binary_tree.py)
    - [binary_search_tree](binary_tree/binary_search_tree.py)
    - [fenwick_tree](binary_tree/fenwick_tree.py)
    - [lazy_segment_tree](binary_tree/lazy_segment_tree.py)
    - [lca](binary_tree/lca.py)
    - [red_black_tree](binary_tree/red_black_tree.py)
    - [segment_tree](binary_tree/segment_tree.py)
    - [treap](binary_tree/treap.py)
    - [double_hash](hashing/double_hash.py)
    - [hash_table](hashing/hash_table.py)
    - [hash_table_with_linked_list](hashing/hash_table_with_linked_list.py)
    - [quadratic_probing](hashing/quadratic_probing.py)
    - [prime_numbers](number_theory/prime_numbers.py)
    - [binomial_heap](heap/binomial_heap.py)
    - [heap](heap/heap.py)
    - [doubly_linked_list](linked_list/doubly_linked_list.py)
    - [is_palindrome](linked_list/is_palindrome.py)
    - [singly_linked_list](linked_list/singly_linked_list.py)
    - [swap_nodes](linked_list/swap_nodes.py)
    - [double_ended_queue](queue/double_ended_queue.py)
    - [queue_on_list](queue/queue_on_list.py)
    - [queue_on_pseudo_stack](queue/queue_on_pseudo_stack.py)
    - [balanced_parentheses](stacks/balanced_parentheses.py)
    - [infix_to_postfix_conversion](stacks/infix_to_postfix_conversion.py)
    - [infix_to_prefix_conversion](stacks/infix_to_prefix_conversion.py)
    - [next_greater_element](stacks/next_greater_element.py)
    - [postfix_evaluation](stacks/postfix_evaluation.py)
    - [stack](stacks/stack.py)
    - [stock_span_problem](stacks/stock_span_problem.py)
    - [trie](trie/trie.py)
    - [change_contrast](digital_image_processing/change_contrast.py)
    - [test_digital_image_processing](digital_image_processing/test_digital_image_processing.py)
    - [canny](edge_detection/canny.py)
    - [convolve](filters/convolve.py)
    - [gaussian_filter](filters/gaussian_filter.py)
    - [median_filter](filters/median_filter.py)
    - [sobel_filter](filters/sobel_filter.py)
    - [closest_pair_of_points](divide_and_conquer/closest_pair_of_points.py)
    - [convex_hull](divide_and_conquer/convex_hull.py)
    - [inversions](divide_and_conquer/inversions.py)
    - [max_subarray_sum](divide_and_conquer/max_subarray_sum.py)
    - [abbreviation](dynamic_programming/abbreviation.py)
    - [bitmask](dynamic_programming/bitmask.py)
    - [climbing_stairs](dynamic_programming/climbing_stairs.py)
    - [coin_change](dynamic_programming/coin_change.py)
    - [edit_distance](dynamic_programming/edit_distance.py)
    - [factorial](dynamic_programming/factorial.py)
    - [fast_fibonacci](dynamic_programming/fast_fibonacci.py)
    - [fibonacci](dynamic_programming/fibonacci.py)
    - [floyd_warshall](dynamic_programming/floyd_warshall.py)
    - [fractional_knapsack](dynamic_programming/fractional_knapsack.py)
    - [integer_partition](dynamic_programming/integer_partition.py)
    - [knapsack](dynamic_programming/knapsack.py)
    - [k_means_clustering_tensorflow](dynamic_programming/k_means_clustering_tensorflow.py)
    - [longest_common_subsequence](dynamic_programming/longest_common_subsequence.py)
    - [longest_increasing_subsequence](dynamic_programming/longest_increasing_subsequence.py)
    - [longest_increasing_subsequence_o(nlogn)](dynamic_programming/longest_increasing_subsequence_o(nlogn).py)
    - [longest_sub_array](dynamic_programming/longest_sub_array.py)
    - [matrix_chain_order](dynamic_programming/matrix_chain_order.py)
    - [max_sub_array](dynamic_programming/max_sub_array.py)
    - [minimum_partition](dynamic_programming/minimum_partition.py)
    - [rod_cutting](dynamic_programming/rod_cutting.py)
    - [subset_generation](dynamic_programming/subset_generation.py)
    - [sum_of_subset](dynamic_programming/sum_of_subset.py)
    - [recieve_file](file_transfer/recieve_file.py)
    - [send_file](file_transfer/send_file.py)
    - [articulation_points](graphs/articulation_points.py)
    - [a_star](graphs/a_star.py)
    - [basic_graphs](graphs/basic_graphs.py)
    - [bellman_ford](graphs/bellman_ford.py)
    - [bfs](graphs/bfs.py)
    - [bfs_shortest_path](graphs/bfs_shortest_path.py)
    - [breadth_first_search](graphs/breadth_first_search.py)
    - [check_bipartite_graph_bfs](graphs/check_bipartite_graph_bfs.py)
    - [check_bipartite_graph_dfs](graphs/check_bipartite_graph_dfs.py)
    - [depth_first_search](graphs/depth_first_search.py)
    - [dfs](graphs/dfs.py)
    - [dijkstra](graphs/dijkstra.py)
    - [dijkstra_2](graphs/dijkstra_2.py)
    - [dijkstra_algorithm](graphs/dijkstra_algorithm.py)
    - [directed_and_undirected_(weighted)_graph](graphs/directed_and_undirected_(weighted)_graph.py)
    - [edmonds_karp_multiple_source_and_sink](graphs/edmonds_karp_multiple_source_and_sink.py)
    - [eulerian_path_and_circuit_for_undirected_graph](graphs/eulerian_path_and_circuit_for_undirected_graph.py)
    - [even_tree](graphs/even_tree.py)
    - [finding_bridges](graphs/finding_bridges.py)
    - [graphs_floyd_warshall](graphs/graphs_floyd_warshall.py)
    - [graph_list](graphs/graph_list.py)
    - [graph_matrix](graphs/graph_matrix.py)
    - [kahns_algorithm_long](graphs/kahns_algorithm_long.py)
    - [kahns_algorithm_topo](graphs/kahns_algorithm_topo.py)
    - [minimum_spanning_tree_kruskal](graphs/minimum_spanning_tree_kruskal.py)
    - [minimum_spanning_tree_prims](graphs/minimum_spanning_tree_prims.py)
    - [multi_hueristic_astar](graphs/multi_hueristic_astar.py)
    - [page_rank](graphs/page_rank.py)
    - [prim](graphs/prim.py)
    - [scc_kosaraju](graphs/scc_kosaraju.py)
    - [tarjans_scc](graphs/tarjans_scc.py)
    - [chaos_machine](hashes/chaos_machine.py)
    - [enigma_machine](hashes/enigma_machine.py)
    - [md5](hashes/md5.py)
    - [sha1](hashes/sha1.py)
    - [lib](src/lib.py)
    - [polynom-for-points](src/polynom-for-points.py)
    - [tests](src/tests.py)
    - [decision_tree](machine_learning/decision_tree.py)
    - [gradient_descent](machine_learning/gradient_descent.py)
    - [knn_sklearn](machine_learning/knn_sklearn.py)
    - [k_means_clust](machine_learning/k_means_clust.py)
    - [linear_regression](machine_learning/linear_regression.py)
    - [logistic_regression](machine_learning/logistic_regression.py)
    - [scoring_functions](machine_learning/scoring_functions.py)
    - [sorted_vector_machines](machine_learning/sorted_vector_machines.py)
    - [random_forest_classification](random_forest_classification/random_forest_classification.py)
    - [random_forest_regression](random_forest_regression/random_forest_regression.py)
    - [3n+1](maths/3n+1.py)
    - [abs](maths/abs.py)
    - [abs_max](maths/abs_max.py)
    - [abs_min](maths/abs_min.py)
    - [average_mean](maths/average_mean.py)
    - [average_median](maths/average_median.py)
    - [basic_maths](maths/basic_maths.py)
    - [binary_exponentiation](maths/binary_exponentiation.py)
    - [collatz_sequence](maths/collatz_sequence.py)
    - [extended_euclidean_algorithm](maths/extended_euclidean_algorithm.py)
    - [factorial_python](maths/factorial_python.py)
    - [factorial_recursive](maths/factorial_recursive.py)
    - [fermat_little_theorem](maths/fermat_little_theorem.py)
    - [fibonacci](maths/fibonacci.py)
    - [fibonacci_sequence_recursion](maths/fibonacci_sequence_recursion.py)
    - [find_lcm](maths/find_lcm.py)
    - [find_max](maths/find_max.py)
    - [find_min](maths/find_min.py)
    - [gaussian](maths/gaussian.py)
    - [greater_common_divisor](maths/greater_common_divisor.py)
    - [is_square_free](maths/is_square_free.py)
    - [largest_of_very_large_numbers](maths/largest_of_very_large_numbers.py)
    - [lucas_lehmer_primality_test](maths/lucas_lehmer_primality_test.py)
    - [lucas_series](maths/lucas_series.py)
    - [mobius_function](maths/mobius_function.py)
    - [modular_exponential](maths/modular_exponential.py)
    - [newton_raphson](maths/newton_raphson.py)
    - [prime_check](maths/prime_check.py)
    - [prime_factors](maths/prime_factors.py)
    - [quadratic_equations_complex_numbers](maths/quadratic_equations_complex_numbers.py)
    - [radix2_fft](maths/radix2_fft.py)
    - [segmented_sieve](maths/segmented_sieve.py)
    - [sieve_of_eratosthenes](maths/sieve_of_eratosthenes.py)
    - [simpson_rule](maths/simpson_rule.py)
    - [test_prime_check](maths/test_prime_check.py)
    - [trapezoidal_rule](maths/trapezoidal_rule.py)
    - [volume](maths/volume.py)
    - [zellers_congruence](maths/zellers_congruence.py)
    - [matrix_operation](matrix/matrix_operation.py)
    - [nth_fibonacci_using_matrix_exponentiation](matrix/nth_fibonacci_using_matrix_exponentiation.py)
    - [rotate_matrix](matrix/rotate_matrix.py)
    - [searching_in_sorted_matrix](matrix/searching_in_sorted_matrix.py)
    - [sherman_morrison](matrix/sherman_morrison.py)
    - [spiral_print](matrix/spiral_print.py)
    - [test_matrix_operation](tests/test_matrix_operation.py)
    - [ford_fulkerson](networking_flow/ford_fulkerson.py)
    - [minimum_cut](networking_flow/minimum_cut.py)
    - [back_propagation_neural_network](neural_network/back_propagation_neural_network.py)
    - [convolution_neural_network](neural_network/convolution_neural_network.py)
    - [perceptron](neural_network/perceptron.py)
    - [anagrams](other/anagrams.py)
    - [binary_exponentiation](other/binary_exponentiation.py)
    - [binary_exponentiation_2](other/binary_exponentiation_2.py)
    - [detecting_english_programmatically](other/detecting_english_programmatically.py)
    - [euclidean_gcd](other/euclidean_gcd.py)
    - [fischer_yates_shuffle](other/fischer_yates_shuffle.py)
    - [frequency_finder](other/frequency_finder.py)
    - [game_of_life](other/game_of_life.py)
    - [linear_congruential_generator](other/linear_congruential_generator.py)
    - [nested_brackets](other/nested_brackets.py)
    - [palindrome](other/palindrome.py)
    - [password_generator](other/password_generator.py)
    - [primelib](other/primelib.py)
    - [sierpinski_triangle](other/sierpinski_triangle.py)
    - [tower_of_hanoi](other/tower_of_hanoi.py)
    - [two_sum](other/two_sum.py)
    - [word_patterns](other/word_patterns.py)
    - [sol1](problem_01/sol1.py)
    - [sol2](problem_01/sol2.py)
    - [sol3](problem_01/sol3.py)
    - [sol4](problem_01/sol4.py)
    - [sol5](problem_01/sol5.py)
    - [sol6](problem_01/sol6.py)
    - [sol1](problem_02/sol1.py)
    - [sol2](problem_02/sol2.py)
    - [sol3](problem_02/sol3.py)
    - [sol4](problem_02/sol4.py)
    - [sol1](problem_03/sol1.py)
    - [sol2](problem_03/sol2.py)
    - [sol1](problem_04/sol1.py)
    - [sol2](problem_04/sol2.py)
    - [sol1](problem_05/sol1.py)
    - [sol2](problem_05/sol2.py)
    - [sol1](problem_06/sol1.py)
    - [sol2](problem_06/sol2.py)
    - [sol3](problem_06/sol3.py)
    - [sol1](problem_07/sol1.py)
    - [sol2](problem_07/sol2.py)
    - [sol3](problem_07/sol3.py)
    - [sol1](problem_08/sol1.py)
    - [sol2](problem_08/sol2.py)
    - [sol1](problem_09/sol1.py)
    - [sol2](problem_09/sol2.py)
    - [sol3](problem_09/sol3.py)
    - [sol1](problem_10/sol1.py)
    - [sol2](problem_10/sol2.py)
    - [sol3](problem_10/sol3.py)
    - [sol1](problem_11/sol1.py)
    - [sol2](problem_11/sol2.py)
    - [sol1](problem_12/sol1.py)
    - [sol2](problem_12/sol2.py)
    - [sol1](problem_13/sol1.py)
    - [sol1](problem_14/sol1.py)
    - [sol2](problem_14/sol2.py)
    - [sol1](problem_15/sol1.py)
    - [sol1](problem_16/sol1.py)
    - [sol2](problem_16/sol2.py)
    - [sol1](problem_17/sol1.py)
    - [sol1](problem_19/sol1.py)
    - [sol1](problem_20/sol1.py)
    - [sol2](problem_20/sol2.py)
    - [sol1](problem_21/sol1.py)
    - [sol1](problem_22/sol1.py)
    - [sol2](problem_22/sol2.py)
    - [sol1](problem_234/sol1.py)
    - [sol1](problem_24/sol1.py)
    - [sol1](problem_25/sol1.py)
    - [sol2](problem_25/sol2.py)
    - [sol1](problem_28/sol1.py)
    - [solution](problem_29/solution.py)
    - [sol1](problem_31/sol1.py)
    - [sol1](problem_36/sol1.py)
    - [sol1](problem_40/sol1.py)
    - [sol1](problem_48/sol1.py)
    - [sol1](problem_52/sol1.py)
    - [sol1](problem_53/sol1.py)
    - [sol1](problem_551/sol1.py)
    - [sol1](problem_56/sol1.py)
    - [sol1](problem_76/sol1.py)
    - [build_directory_md](scripts/build_directory_md.py)
    - [validate_filenames](scripts/validate_filenames.py)
    - [binary_search](searches/binary_search.py)
    - [interpolation_search](searches/interpolation_search.py)
    - [jump_search](searches/jump_search.py)
    - [linear_search](searches/linear_search.py)
    - [quick_select](searches/quick_select.py)
    - [sentinel_linear_search](searches/sentinel_linear_search.py)
    - [tabu_search](searches/tabu_search.py)
    - [ternary_search](searches/ternary_search.py)
    - [bitonic_sort](sorts/bitonic_sort.py)
    - [bogo_sort](sorts/bogo_sort.py)
    - [bubble_sort](sorts/bubble_sort.py)
    - [bucket_sort](sorts/bucket_sort.py)
    - [cocktail_shaker_sort](sorts/cocktail_shaker_sort.py)
    - [comb_sort](sorts/comb_sort.py)
    - [counting_sort](sorts/counting_sort.py)
    - [cycle_sort](sorts/cycle_sort.py)
    - [external_sort](sorts/external_sort.py)
    - [gnome_sort](sorts/gnome_sort.py)
    - [heap_sort](sorts/heap_sort.py)
    - [insertion_sort](sorts/insertion_sort.py)
    - [merge_sort](sorts/merge_sort.py)
    - [merge_sort_fastest](sorts/merge_sort_fastest.py)
    - [odd_even_transposition_parallel](sorts/odd_even_transposition_parallel.py)
    - [odd_even_transposition_single_threaded](sorts/odd_even_transposition_single_threaded.py)
    - [pancake_sort](sorts/pancake_sort.py)
    - [pigeon_sort](sorts/pigeon_sort.py)
    - [quick_sort](sorts/quick_sort.py)
    - [quick_sort_3_partition](sorts/quick_sort_3_partition.py)
    - [radix_sort](sorts/radix_sort.py)
    - [random_normal_distribution_quicksort](sorts/random_normal_distribution_quicksort.py)
    - [random_pivot_quick_sort](sorts/random_pivot_quick_sort.py)
    - [selection_sort](sorts/selection_sort.py)
    - [shell_sort](sorts/shell_sort.py)
    - [tim_sort](sorts/tim_sort.py)
    - [topological_sort](sorts/topological_sort.py)
    - [tree_sort](sorts/tree_sort.py)
    - [wiggle_sort](sorts/wiggle_sort.py)
    - [boyer_moore_search](strings/boyer_moore_search.py)
    - [knuth_morris_pratt](strings/knuth_morris_pratt.py)
    - [levenshtein_distance](strings/levenshtein_distance.py)
    - [manacher](strings/manacher.py)
    - [min_cost_string_conversion](strings/min_cost_string_conversion.py)
    - [naive_string_search](strings/naive_string_search.py)
    - [rabin_karp](strings/rabin_karp.py)
    - [binary_tree_traversals](traversals/binary_tree_traversals.py)

## Arithmetic Analysis
  * [bisection](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/bisection.py)
  * [in static equilibrium](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/in_static_equilibrium.py)
  * [intersection](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/intersection.py)
  * [lu decomposition](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/lu_decomposition.py)
  * [newton method](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/newton_method.py)
  * [newton raphson method](https://github.com/TheAlgorithms/Python/blob/master/arithmetic_analysis/newton_raphson_method.py)
## Backtracking
  * [all combinations](https://github.com/TheAlgorithms/Python/blob/master/backtracking/all_combinations.py)
  * [all permutations](https://github.com/TheAlgorithms/Python/blob/master/backtracking/all_permutations.py)
  * [all subsequences](https://github.com/TheAlgorithms/Python/blob/master/backtracking/all_subsequences.py)
  * [minimax](https://github.com/TheAlgorithms/Python/blob/master/backtracking/minimax.py)
  * [n queens](https://github.com/TheAlgorithms/Python/blob/master/backtracking/n_queens.py)
  * [sudoku](https://github.com/TheAlgorithms/Python/blob/master/backtracking/sudoku.py)
  * [sum of subsets](https://github.com/TheAlgorithms/Python/blob/master/backtracking/sum_of_subsets.py)
## Boolean Algebra
  * [quine mc cluskey](https://github.com/TheAlgorithms/Python/blob/master/boolean_algebra/quine_mc_cluskey.py)
## Ciphers
  * [affine cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/affine_cipher.py)
  * [atbash](https://github.com/TheAlgorithms/Python/blob/master/ciphers/atbash.py)
  * [base16](https://github.com/TheAlgorithms/Python/blob/master/ciphers/base16.py)
  * [base32](https://github.com/TheAlgorithms/Python/blob/master/ciphers/base32.py)
  * [base64 cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/base64_cipher.py)
  * [base85](https://github.com/TheAlgorithms/Python/blob/master/ciphers/base85.py)
  * [brute force caesar cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/brute_force_caesar_cipher.py)
  * [caesar cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/caesar_cipher.py)
  * [cryptomath module](https://github.com/TheAlgorithms/Python/blob/master/ciphers/cryptomath_module.py)
  * [elgamal key generator](https://github.com/TheAlgorithms/Python/blob/master/ciphers/elgamal_key_generator.py)
  * [hill cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/hill_cipher.py)
  * [morse code implementation](https://github.com/TheAlgorithms/Python/blob/master/ciphers/morse_code_implementation.py)
  * [onepad cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/onepad_cipher.py)
  * [playfair cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/playfair_cipher.py)
  * [rabin miller](https://github.com/TheAlgorithms/Python/blob/master/ciphers/rabin_miller.py)
  * [rot13](https://github.com/TheAlgorithms/Python/blob/master/ciphers/rot13.py)
  * [rsa cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/rsa_cipher.py)
  * [rsa key generator](https://github.com/TheAlgorithms/Python/blob/master/ciphers/rsa_key_generator.py)
  * [simple substitution cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/simple_substitution_cipher.py)
  * [trafid cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/trafid_cipher.py)
  * [transposition cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/transposition_cipher.py)
  * [transposition cipher encrypt decrypt file](https://github.com/TheAlgorithms/Python/blob/master/ciphers/transposition_cipher_encrypt_decrypt_file.py)
  * [vigenere cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/vigenere_cipher.py)
  * [xor cipher](https://github.com/TheAlgorithms/Python/blob/master/ciphers/xor_cipher.py)
## Compression
  * [burrows wheeler](https://github.com/TheAlgorithms/Python/blob/master/compression/burrows_wheeler.py)
  * [huffman](https://github.com/TheAlgorithms/Python/blob/master/compression/huffman.py)
  * [peak signal to noise ratio](https://github.com/TheAlgorithms/Python/blob/master/compression/peak_signal_to_noise_ratio.py)
## Conversions
  * [decimal to binary](https://github.com/TheAlgorithms/Python/blob/master/conversions/decimal_to_binary.py)
  * [decimal to hexadecimal](https://github.com/TheAlgorithms/Python/blob/master/conversions/decimal_to_hexadecimal.py)
  * [decimal to octal](https://github.com/TheAlgorithms/Python/blob/master/conversions/decimal_to_octal.py)
## Data Structures
  * Binary Tree
    * [avl tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/avl_tree.py)
    * [basic binary tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/basic_binary_tree.py)
    * [binary search tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/binary_search_tree.py)
    * [fenwick tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/fenwick_tree.py)
    * [lazy segment tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/lazy_segment_tree.py)
    * [lca](https://github.com/TheAlgorithms/Python/blob/master/data_structures/lca.py)
    * [red black tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/red_black_tree.py)
    * [segment tree](https://github.com/TheAlgorithms/Python/blob/master/data_structures/segment_tree.py)
    * [treap](https://github.com/TheAlgorithms/Python/blob/master/data_structures/treap.py)
  * Hashing
    * [double hash](https://github.com/TheAlgorithms/Python/blob/master/data_structures/double_hash.py)
    * [hash table](https://github.com/TheAlgorithms/Python/blob/master/data_structures/hash_table.py)
    * [hash table with linked list](https://github.com/TheAlgorithms/Python/blob/master/data_structures/hash_table_with_linked_list.py)
  * Number Theory
    * [prime numbers](https://github.com/TheAlgorithms/Python/blob/master/data_structures/prime_numbers.py)
    * [quadratic probing](https://github.com/TheAlgorithms/Python/blob/master/data_structures/quadratic_probing.py)
  * Heap
    * [heap](https://github.com/TheAlgorithms/Python/blob/master/data_structures/heap.py)
  * Linked List
    * [doubly linked list](https://github.com/TheAlgorithms/Python/blob/master/data_structures/doubly_linked_list.py)
    * [is palindrome](https://github.com/TheAlgorithms/Python/blob/master/data_structures/is_palindrome.py)
    * [singly linked list](https://github.com/TheAlgorithms/Python/blob/master/data_structures/singly_linked_list.py)
    * [swap nodes](https://github.com/TheAlgorithms/Python/blob/master/data_structures/swap_nodes.py)
  * Queue
    * [double ended queue](https://github.com/TheAlgorithms/Python/blob/master/data_structures/double_ended_queue.py)
    * [queue on list](https://github.com/TheAlgorithms/Python/blob/master/data_structures/queue_on_list.py)
    * [queue on pseudo stack](https://github.com/TheAlgorithms/Python/blob/master/data_structures/queue_on_pseudo_stack.py)
  * Stacks
    * [balanced parentheses](https://github.com/TheAlgorithms/Python/blob/master/data_structures/balanced_parentheses.py)
    * [infix to postfix conversion](https://github.com/TheAlgorithms/Python/blob/master/data_structures/infix_to_postfix_conversion.py)
    * [infix to prefix conversion](https://github.com/TheAlgorithms/Python/blob/master/data_structures/infix_to_prefix_conversion.py)
    * [next greater element](https://github.com/TheAlgorithms/Python/blob/master/data_structures/next_greater_element.py)
    * [postfix evaluation](https://github.com/TheAlgorithms/Python/blob/master/data_structures/postfix_evaluation.py)
    * [stack](https://github.com/TheAlgorithms/Python/blob/master/data_structures/stack.py)
    * [stock span problem](https://github.com/TheAlgorithms/Python/blob/master/data_structures/stock_span_problem.py)
  * Trie
    * [trie](https://github.com/TheAlgorithms/Python/blob/master/data_structures/trie.py)
## Digital Image Processing
    * [change contrast](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/change_contrast.py)
  * Edge Detection
    * [canny](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/canny.py)
  * Filters
    * [convolve](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/convolve.py)
    * [gaussian filter](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/gaussian_filter.py)
    * [median filter](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/median_filter.py)
    * [sobel filter](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/sobel_filter.py)
    * [test digital image processing](https://github.com/TheAlgorithms/Python/blob/master/digital_image_processing/test_digital_image_processing.py)
## Divide And Conquer
  * [closest pair of points](https://github.com/TheAlgorithms/Python/blob/master/divide_and_conquer/closest_pair_of_points.py)
  * [convex hull](https://github.com/TheAlgorithms/Python/blob/master/divide_and_conquer/convex_hull.py)
  * [inversions](https://github.com/TheAlgorithms/Python/blob/master/divide_and_conquer/inversions.py)
  * [max subarray sum](https://github.com/TheAlgorithms/Python/blob/master/divide_and_conquer/max_subarray_sum.py)
## Dynamic Programming
  * [abbreviation](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/abbreviation.py)
  * [bitmask](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/bitmask.py)
  * [climbing stairs](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/climbing_stairs.py)
  * [coin change](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/coin_change.py)
  * [edit distance](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/edit_distance.py)
  * [factorial](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/factorial.py)
  * [fast fibonacci](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/fast_fibonacci.py)
  * [fibonacci](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/fibonacci.py)
  * [floyd warshall](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/floyd_warshall.py)
  * [fractional knapsack](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/fractional_knapsack.py)
  * [integer partition](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/integer_partition.py)
  * [k means clustering tensorflow](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/k_means_clustering_tensorflow.py)
  * [knapsack](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/knapsack.py)
  * [longest common subsequence](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/longest_common_subsequence.py)
  * [longest increasing subsequence](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/longest_increasing_subsequence.py)
  * [longest increasing subsequence o(nlogn)](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/longest_increasing_subsequence_o(nlogn).py)
  * [longest sub array](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/longest_sub_array.py)
  * [matrix chain order](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/matrix_chain_order.py)
  * [max sub array](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/max_sub_array.py)
  * [minimum partition](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/minimum_partition.py)
  * [rod cutting](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/rod_cutting.py)
  * [subset generation](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/subset_generation.py)
  * [sum of subset](https://github.com/TheAlgorithms/Python/blob/master/dynamic_programming/sum_of_subset.py)
## File Transfer
  * [recieve file](https://github.com/TheAlgorithms/Python/blob/master/file_transfer/recieve_file.py)
  * [send file](https://github.com/TheAlgorithms/Python/blob/master/file_transfer/send_file.py)
## Graphs
  * [a star](https://github.com/TheAlgorithms/Python/blob/master/graphs/a_star.py)
  * [articulation points](https://github.com/TheAlgorithms/Python/blob/master/graphs/articulation_points.py)
  * [basic graphs](https://github.com/TheAlgorithms/Python/blob/master/graphs/basic_graphs.py)
  * [bellman ford](https://github.com/TheAlgorithms/Python/blob/master/graphs/bellman_ford.py)
  * [bfs](https://github.com/TheAlgorithms/Python/blob/master/graphs/bfs.py)
  * [bfs shortest path](https://github.com/TheAlgorithms/Python/blob/master/graphs/bfs_shortest_path.py)
  * [breadth first search](https://github.com/TheAlgorithms/Python/blob/master/graphs/breadth_first_search.py)
  * [check bipartite graph bfs](https://github.com/TheAlgorithms/Python/blob/master/graphs/check_bipartite_graph_bfs.py)
  * [check bipartite graph dfs](https://github.com/TheAlgorithms/Python/blob/master/graphs/check_bipartite_graph_dfs.py)
  * [depth first search](https://github.com/TheAlgorithms/Python/blob/master/graphs/depth_first_search.py)
  * [dfs](https://github.com/TheAlgorithms/Python/blob/master/graphs/dfs.py)
  * [dijkstra](https://github.com/TheAlgorithms/Python/blob/master/graphs/dijkstra.py)
  * [dijkstra 2](https://github.com/TheAlgorithms/Python/blob/master/graphs/dijkstra_2.py)
  * [dijkstra algorithm](https://github.com/TheAlgorithms/Python/blob/master/graphs/dijkstra_algorithm.py)
  * [directed and undirected (weighted) graph](https://github.com/TheAlgorithms/Python/blob/master/graphs/directed_and_undirected_(weighted)_graph.py)
  * [edmonds karp multiple source and sink](https://github.com/TheAlgorithms/Python/blob/master/graphs/edmonds_karp_multiple_source_and_sink.py)
  * [eulerian path and circuit for undirected graph](https://github.com/TheAlgorithms/Python/blob/master/graphs/eulerian_path_and_circuit_for_undirected_graph.py)
  * [even tree](https://github.com/TheAlgorithms/Python/blob/master/graphs/even_tree.py)
  * [finding bridges](https://github.com/TheAlgorithms/Python/blob/master/graphs/finding_bridges.py)
  * [graph list](https://github.com/TheAlgorithms/Python/blob/master/graphs/graph_list.py)
  * [graph matrix](https://github.com/TheAlgorithms/Python/blob/master/graphs/graph_matrix.py)
  * [graphs floyd warshall](https://github.com/TheAlgorithms/Python/blob/master/graphs/graphs_floyd_warshall.py)
  * [kahns algorithm long](https://github.com/TheAlgorithms/Python/blob/master/graphs/kahns_algorithm_long.py)
  * [kahns algorithm topo](https://github.com/TheAlgorithms/Python/blob/master/graphs/kahns_algorithm_topo.py)
  * [minimum spanning tree kruskal](https://github.com/TheAlgorithms/Python/blob/master/graphs/minimum_spanning_tree_kruskal.py)
  * [minimum spanning tree prims](https://github.com/TheAlgorithms/Python/blob/master/graphs/minimum_spanning_tree_prims.py)
  * [multi hueristic astar](https://github.com/TheAlgorithms/Python/blob/master/graphs/multi_hueristic_astar.py)
  * [page rank](https://github.com/TheAlgorithms/Python/blob/master/graphs/page_rank.py)
  * [prim](https://github.com/TheAlgorithms/Python/blob/master/graphs/prim.py)
  * [scc kosaraju](https://github.com/TheAlgorithms/Python/blob/master/graphs/scc_kosaraju.py)
  * [tarjans scc](https://github.com/TheAlgorithms/Python/blob/master/graphs/tarjans_scc.py)
## Hashes
  * [chaos machine](https://github.com/TheAlgorithms/Python/blob/master/hashes/chaos_machine.py)
  * [enigma machine](https://github.com/TheAlgorithms/Python/blob/master/hashes/enigma_machine.py)
  * [md5](https://github.com/TheAlgorithms/Python/blob/master/hashes/md5.py)
  * [sha1](https://github.com/TheAlgorithms/Python/blob/master/hashes/sha1.py)
## Linear Algebra
  * Src
    * [lib](https://github.com/TheAlgorithms/Python/blob/master/linear_algebra/lib.py)
    * [polynom-for-points](https://github.com/TheAlgorithms/Python/blob/master/linear_algebra/polynom-for-points.py)
    * [tests](https://github.com/TheAlgorithms/Python/blob/master/linear_algebra/tests.py)
## Machine Learning
  * [decision tree](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/decision_tree.py)
  * [gradient descent](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/gradient_descent.py)
  * [k means clust](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/k_means_clust.py)
  * [knn sklearn](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/knn_sklearn.py)
  * [linear regression](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/linear_regression.py)
  * [logistic regression](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/logistic_regression.py)
  * [naive bayes](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/naive_bayes.ipynb)
  * Random Forest Classification
    * [random forest classification](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/random_forest_classification.py)
    * [random forest classifier](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/random_forest_classifier.ipynb)
  * Random Forest Regression
    * [random forest regression](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/random_forest_regression.ipynb)
    * [random forest regression](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/random_forest_regression.py)
  * [reuters one vs rest classifier](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/reuters_one_vs_rest_classifier.ipynb)
  * [scoring functions](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/scoring_functions.py)
  * [sorted vector machines](https://github.com/TheAlgorithms/Python/blob/master/machine_learning/sorted_vector_machines.py)
## Maths
  * [3n+1](https://github.com/TheAlgorithms/Python/blob/master/maths/3n+1.py)
  * [abs](https://github.com/TheAlgorithms/Python/blob/master/maths/abs.py)
  * [abs max](https://github.com/TheAlgorithms/Python/blob/master/maths/abs_max.py)
  * [abs min](https://github.com/TheAlgorithms/Python/blob/master/maths/abs_min.py)
  * [average mean](https://github.com/TheAlgorithms/Python/blob/master/maths/average_mean.py)
  * [average median](https://github.com/TheAlgorithms/Python/blob/master/maths/average_median.py)
  * [basic maths](https://github.com/TheAlgorithms/Python/blob/master/maths/basic_maths.py)
  * [binary exponentiation](https://github.com/TheAlgorithms/Python/blob/master/maths/binary_exponentiation.py)
  * [collatz sequence](https://github.com/TheAlgorithms/Python/blob/master/maths/collatz_sequence.py)
  * [extended euclidean algorithm](https://github.com/TheAlgorithms/Python/blob/master/maths/extended_euclidean_algorithm.py)
  * [factorial python](https://github.com/TheAlgorithms/Python/blob/master/maths/factorial_python.py)
  * [factorial recursive](https://github.com/TheAlgorithms/Python/blob/master/maths/factorial_recursive.py)
  * [fermat little theorem](https://github.com/TheAlgorithms/Python/blob/master/maths/fermat_little_theorem.py)
  * [fibonacci](https://github.com/TheAlgorithms/Python/blob/master/maths/fibonacci.py)
  * [fibonacci sequence recursion](https://github.com/TheAlgorithms/Python/blob/master/maths/fibonacci_sequence_recursion.py)
  * [find lcm](https://github.com/TheAlgorithms/Python/blob/master/maths/find_lcm.py)
  * [find max](https://github.com/TheAlgorithms/Python/blob/master/maths/find_max.py)
  * [find min](https://github.com/TheAlgorithms/Python/blob/master/maths/find_min.py)
  * [gaussian](https://github.com/TheAlgorithms/Python/blob/master/maths/gaussian.py)
  * [greater common divisor](https://github.com/TheAlgorithms/Python/blob/master/maths/greater_common_divisor.py)
  * [is square free](https://github.com/TheAlgorithms/Python/blob/master/maths/is_square_free.py)
  * [largest of very large numbers](https://github.com/TheAlgorithms/Python/blob/master/maths/largest_of_very_large_numbers.py)
  * [lucas lehmer primality test](https://github.com/TheAlgorithms/Python/blob/master/maths/lucas_lehmer_primality_test.py)
  * [lucas series](https://github.com/TheAlgorithms/Python/blob/master/maths/lucas_series.py)
  * [mobius function](https://github.com/TheAlgorithms/Python/blob/master/maths/mobius_function.py)
  * [modular exponential](https://github.com/TheAlgorithms/Python/blob/master/maths/modular_exponential.py)
  * [newton raphson](https://github.com/TheAlgorithms/Python/blob/master/maths/newton_raphson.py)
  * [prime check](https://github.com/TheAlgorithms/Python/blob/master/maths/prime_check.py)
  * [prime factors](https://github.com/TheAlgorithms/Python/blob/master/maths/prime_factors.py)
  * [quadratic equations complex numbers](https://github.com/TheAlgorithms/Python/blob/master/maths/quadratic_equations_complex_numbers.py)
  * [segmented sieve](https://github.com/TheAlgorithms/Python/blob/master/maths/segmented_sieve.py)
  * [sieve of eratosthenes](https://github.com/TheAlgorithms/Python/blob/master/maths/sieve_of_eratosthenes.py)
  * [simpson rule](https://github.com/TheAlgorithms/Python/blob/master/maths/simpson_rule.py)
  * [test prime check](https://github.com/TheAlgorithms/Python/blob/master/maths/test_prime_check.py)
  * [trapezoidal rule](https://github.com/TheAlgorithms/Python/blob/master/maths/trapezoidal_rule.py)
  * [volume](https://github.com/TheAlgorithms/Python/blob/master/maths/volume.py)
  * [zellers congruence](https://github.com/TheAlgorithms/Python/blob/master/maths/zellers_congruence.py)
## Matrix
  * [matrix operation](https://github.com/TheAlgorithms/Python/blob/master/matrix/matrix_operation.py)
  * [nth fibonacci using matrix exponentiation](https://github.com/TheAlgorithms/Python/blob/master/matrix/nth_fibonacci_using_matrix_exponentiation.py)
  * [rotate matrix](https://github.com/TheAlgorithms/Python/blob/master/matrix/rotate_matrix.py)
  * [searching in sorted matrix](https://github.com/TheAlgorithms/Python/blob/master/matrix/searching_in_sorted_matrix.py)
  * [spiral print](https://github.com/TheAlgorithms/Python/blob/master/matrix/spiral_print.py)
  * Tests
    * [test matrix operation](https://github.com/TheAlgorithms/Python/blob/master/matrix/test_matrix_operation.py)
## Networking Flow
  * [ford fulkerson](https://github.com/TheAlgorithms/Python/blob/master/networking_flow/ford_fulkerson.py)
  * [minimum cut](https://github.com/TheAlgorithms/Python/blob/master/networking_flow/minimum_cut.py)
## Neural Network
  * [back propagation neural network](https://github.com/TheAlgorithms/Python/blob/master/neural_network/back_propagation_neural_network.py)
  * [convolution neural network](https://github.com/TheAlgorithms/Python/blob/master/neural_network/convolution_neural_network.py)
  * [fully connected neural network](https://github.com/TheAlgorithms/Python/blob/master/neural_network/fully_connected_neural_network.ipynb)
  * [perceptron](https://github.com/TheAlgorithms/Python/blob/master/neural_network/perceptron.py)
## Other
  * [anagrams](https://github.com/TheAlgorithms/Python/blob/master/other/anagrams.py)
  * [binary exponentiation](https://github.com/TheAlgorithms/Python/blob/master/other/binary_exponentiation.py)
  * [binary exponentiation 2](https://github.com/TheAlgorithms/Python/blob/master/other/binary_exponentiation_2.py)
  * [detecting english programmatically](https://github.com/TheAlgorithms/Python/blob/master/other/detecting_english_programmatically.py)
  * [euclidean gcd](https://github.com/TheAlgorithms/Python/blob/master/other/euclidean_gcd.py)
  * [fischer yates shuffle](https://github.com/TheAlgorithms/Python/blob/master/other/fischer_yates_shuffle.py)
  * [food wastage analysis from 1961-2013 fao](https://github.com/TheAlgorithms/Python/blob/master/other/food_wastage_analysis_from_1961-2013_fao.ipynb)
  * [frequency finder](https://github.com/TheAlgorithms/Python/blob/master/other/frequency_finder.py)
  * [game of life](https://github.com/TheAlgorithms/Python/blob/master/other/game_of_life.py)
  * [linear congruential generator](https://github.com/TheAlgorithms/Python/blob/master/other/linear_congruential_generator.py)
  * [nested brackets](https://github.com/TheAlgorithms/Python/blob/master/other/nested_brackets.py)
  * [palindrome](https://github.com/TheAlgorithms/Python/blob/master/other/palindrome.py)
  * [password generator](https://github.com/TheAlgorithms/Python/blob/master/other/password_generator.py)
  * [primelib](https://github.com/TheAlgorithms/Python/blob/master/other/primelib.py)
  * [sierpinski triangle](https://github.com/TheAlgorithms/Python/blob/master/other/sierpinski_triangle.py)
  * [tower of hanoi](https://github.com/TheAlgorithms/Python/blob/master/other/tower_of_hanoi.py)
  * [two sum](https://github.com/TheAlgorithms/Python/blob/master/other/two_sum.py)
  * [word patterns](https://github.com/TheAlgorithms/Python/blob/master/other/word_patterns.py)
## Project Euler
  * Problem 01
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
    * [sol4](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol4.py)
    * [sol5](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol5.py)
    * [sol6](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol6.py)
  * Problem 02
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
    * [sol4](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol4.py)
  * Problem 03
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 04
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 05
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 06
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
  * Problem 07
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
  * Problem 08
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 09
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
  * Problem 10
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
    * [sol3](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol3.py)
  * Problem 11
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 12
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 13
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 14
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 15
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 16
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 17
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 18
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 19
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 20
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 21
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 22
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 234
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 24
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 25
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
    * [sol2](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol2.py)
  * Problem 28
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 29
    * [solution](https://github.com/TheAlgorithms/Python/blob/master/project_euler/solution.py)
  * Problem 31
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 36
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 40
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 48
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 52
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 53
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 56
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
  * Problem 76
    * [sol1](https://github.com/TheAlgorithms/Python/blob/master/project_euler/sol1.py)
## Searches
  * [binary search](https://github.com/TheAlgorithms/Python/blob/master/searches/binary_search.py)
  * [interpolation search](https://github.com/TheAlgorithms/Python/blob/master/searches/interpolation_search.py)
  * [jump search](https://github.com/TheAlgorithms/Python/blob/master/searches/jump_search.py)
  * [linear search](https://github.com/TheAlgorithms/Python/blob/master/searches/linear_search.py)
  * [quick select](https://github.com/TheAlgorithms/Python/blob/master/searches/quick_select.py)
  * [sentinel linear search](https://github.com/TheAlgorithms/Python/blob/master/searches/sentinel_linear_search.py)
  * [tabu search](https://github.com/TheAlgorithms/Python/blob/master/searches/tabu_search.py)
  * [ternary search](https://github.com/TheAlgorithms/Python/blob/master/searches/ternary_search.py)
## Sorts
  * [bitonic sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/bitonic_sort.py)
  * [bogo sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/bogo_sort.py)
  * [bubble sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/bubble_sort.py)
  * [bucket sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/bucket_sort.py)
  * [cocktail shaker sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/cocktail_shaker_sort.py)
  * [comb sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/comb_sort.py)
  * [counting sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/counting_sort.py)
  * [cycle sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/cycle_sort.py)
  * [external sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/external_sort.py)
  * [gnome sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/gnome_sort.py)
  * [heap sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/heap_sort.py)
  * [insertion sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/insertion_sort.py)
  * [merge sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/merge_sort.py)
  * [merge sort fastest](https://github.com/TheAlgorithms/Python/blob/master/sorts/merge_sort_fastest.py)
  * [odd even transposition parallel](https://github.com/TheAlgorithms/Python/blob/master/sorts/odd_even_transposition_parallel.py)
  * [odd even transposition single threaded](https://github.com/TheAlgorithms/Python/blob/master/sorts/odd_even_transposition_single_threaded.py)
  * [pancake sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/pancake_sort.py)
  * [pigeon sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/pigeon_sort.py)
  * [quick sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/quick_sort.py)
  * [quick sort 3 partition](https://github.com/TheAlgorithms/Python/blob/master/sorts/quick_sort_3_partition.py)
  * [radix sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/radix_sort.py)
  * [random normal distribution quicksort](https://github.com/TheAlgorithms/Python/blob/master/sorts/random_normal_distribution_quicksort.py)
  * [random pivot quick sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/random_pivot_quick_sort.py)
  * [selection sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/selection_sort.py)
  * [shell sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/shell_sort.py)
  * [tim sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/tim_sort.py)
  * [topological sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/topological_sort.py)
  * [tree sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/tree_sort.py)
  * [wiggle sort](https://github.com/TheAlgorithms/Python/blob/master/sorts/wiggle_sort.py)
## Strings
  * [boyer moore search](https://github.com/TheAlgorithms/Python/blob/master/strings/boyer_moore_search.py)
  * [knuth morris pratt](https://github.com/TheAlgorithms/Python/blob/master/strings/knuth_morris_pratt.py)
  * [levenshtein distance](https://github.com/TheAlgorithms/Python/blob/master/strings/levenshtein_distance.py)
  * [manacher](https://github.com/TheAlgorithms/Python/blob/master/strings/manacher.py)
  * [min cost string conversion](https://github.com/TheAlgorithms/Python/blob/master/strings/min_cost_string_conversion.py)
  * [naive string search](https://github.com/TheAlgorithms/Python/blob/master/strings/naive_string_search.py)
  * [rabin karp](https://github.com/TheAlgorithms/Python/blob/master/strings/rabin_karp.py)
## Traversals
  * [binary tree traversals](https://github.com/TheAlgorithms/Python/blob/master/traversals/binary_tree_traversals.py)

