import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Panorama::ApplicationInstance`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html
 */
export interface CfnApplicationInstanceProps {
    /**
     * `AWS::Panorama::ApplicationInstance.DefaultRuntimeContextDevice`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-defaultruntimecontextdevice
     */
    readonly defaultRuntimeContextDevice: string;
    /**
     * `AWS::Panorama::ApplicationInstance.ManifestPayload`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-manifestpayload
     */
    readonly manifestPayload: CfnApplicationInstance.ManifestPayloadProperty | cdk.IResolvable;
    /**
     * `AWS::Panorama::ApplicationInstance.ApplicationInstanceIdToReplace`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-applicationinstanceidtoreplace
     */
    readonly applicationInstanceIdToReplace?: string;
    /**
     * `AWS::Panorama::ApplicationInstance.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-description
     */
    readonly description?: string;
    /**
     * `AWS::Panorama::ApplicationInstance.DeviceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-deviceid
     */
    readonly deviceId?: string;
    /**
     * `AWS::Panorama::ApplicationInstance.ManifestOverridesPayload`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-manifestoverridespayload
     */
    readonly manifestOverridesPayload?: CfnApplicationInstance.ManifestOverridesPayloadProperty | cdk.IResolvable;
    /**
     * `AWS::Panorama::ApplicationInstance.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-name
     */
    readonly name?: string;
    /**
     * `AWS::Panorama::ApplicationInstance.RuntimeRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-runtimerolearn
     */
    readonly runtimeRoleArn?: string;
    /**
     * `AWS::Panorama::ApplicationInstance.StatusFilter`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-statusfilter
     */
    readonly statusFilter?: string;
    /**
     * `AWS::Panorama::ApplicationInstance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Panorama::ApplicationInstance`.
 *
 * @external
 * @cloudformationResource AWS::Panorama::ApplicationInstance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html
 */
export declare class CfnApplicationInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Panorama::ApplicationInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplicationInstance;
    /**
     * @external
     * @cloudformationAttribute ApplicationInstanceId
     */
    readonly attrApplicationInstanceId: string;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: number;
    /**
     * @external
     * @cloudformationAttribute DefaultRuntimeContextDeviceName
     */
    readonly attrDefaultRuntimeContextDeviceName: string;
    /**
     * @external
     * @cloudformationAttribute HealthStatus
     */
    readonly attrHealthStatus: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: number;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * @external
     * @cloudformationAttribute StatusDescription
     */
    readonly attrStatusDescription: string;
    /**
     * `AWS::Panorama::ApplicationInstance.DefaultRuntimeContextDevice`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-defaultruntimecontextdevice
     */
    defaultRuntimeContextDevice: string;
    /**
     * `AWS::Panorama::ApplicationInstance.ManifestPayload`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-manifestpayload
     */
    manifestPayload: CfnApplicationInstance.ManifestPayloadProperty | cdk.IResolvable;
    /**
     * `AWS::Panorama::ApplicationInstance.ApplicationInstanceIdToReplace`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-applicationinstanceidtoreplace
     */
    applicationInstanceIdToReplace: string | undefined;
    /**
     * `AWS::Panorama::ApplicationInstance.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-description
     */
    description: string | undefined;
    /**
     * `AWS::Panorama::ApplicationInstance.DeviceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-deviceid
     */
    deviceId: string | undefined;
    /**
     * `AWS::Panorama::ApplicationInstance.ManifestOverridesPayload`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-manifestoverridespayload
     */
    manifestOverridesPayload: CfnApplicationInstance.ManifestOverridesPayloadProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Panorama::ApplicationInstance.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-name
     */
    name: string | undefined;
    /**
     * `AWS::Panorama::ApplicationInstance.RuntimeRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-runtimerolearn
     */
    runtimeRoleArn: string | undefined;
    /**
     * `AWS::Panorama::ApplicationInstance.StatusFilter`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-statusfilter
     */
    statusFilter: string | undefined;
    /**
     * `AWS::Panorama::ApplicationInstance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Panorama::ApplicationInstance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Panorama::ApplicationInstance`.
 *
 * @external
 * @cloudformationResource AWS::Panorama::ApplicationInstance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html
 */
export declare namespace CfnApplicationInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-applicationinstance-manifestoverridespayload.html
     */
    interface ManifestOverridesPayloadProperty {
        /**
         * `CfnApplicationInstance.ManifestOverridesPayloadProperty.PayloadData`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-applicationinstance-manifestoverridespayload.html#cfn-panorama-applicationinstance-manifestoverridespayload-payloaddata
         */
        readonly payloadData?: string;
    }
}
/**
 * A CloudFormation `AWS::Panorama::ApplicationInstance`.
 *
 * @external
 * @cloudformationResource AWS::Panorama::ApplicationInstance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html
 */
export declare namespace CfnApplicationInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-applicationinstance-manifestpayload.html
     */
    interface ManifestPayloadProperty {
        /**
         * `CfnApplicationInstance.ManifestPayloadProperty.PayloadData`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-applicationinstance-manifestpayload.html#cfn-panorama-applicationinstance-manifestpayload-payloaddata
         */
        readonly payloadData?: string;
    }
}
/**
 * Properties for defining a `AWS::Panorama::Package`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html
 */
export interface CfnPackageProps {
    /**
     * `AWS::Panorama::Package.PackageName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-packagename
     */
    readonly packageName: string;
    /**
     * `AWS::Panorama::Package.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Panorama::Package`.
 *
 * @external
 * @cloudformationResource AWS::Panorama::Package
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html
 */
export declare class CfnPackage extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Panorama::Package";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPackage;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: number;
    /**
     * @external
     * @cloudformationAttribute PackageId
     */
    readonly attrPackageId: string;
    /**
     * `AWS::Panorama::Package.PackageName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-packagename
     */
    packageName: string;
    /**
     * `AWS::Panorama::Package.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Panorama::Package`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPackageProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Panorama::PackageVersion`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html
 */
export interface CfnPackageVersionProps {
    /**
     * `AWS::Panorama::PackageVersion.PackageId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-packageid
     */
    readonly packageId: string;
    /**
     * `AWS::Panorama::PackageVersion.PackageVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-packageversion
     */
    readonly packageVersion: string;
    /**
     * `AWS::Panorama::PackageVersion.PatchVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-patchversion
     */
    readonly patchVersion: string;
    /**
     * `AWS::Panorama::PackageVersion.MarkLatest`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-marklatest
     */
    readonly markLatest?: boolean | cdk.IResolvable;
    /**
     * `AWS::Panorama::PackageVersion.OwnerAccount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-owneraccount
     */
    readonly ownerAccount?: string;
    /**
     * `AWS::Panorama::PackageVersion.UpdatedLatestPatchVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-updatedlatestpatchversion
     */
    readonly updatedLatestPatchVersion?: string;
}
/**
 * A CloudFormation `AWS::Panorama::PackageVersion`.
 *
 * @external
 * @cloudformationResource AWS::Panorama::PackageVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html
 */
export declare class CfnPackageVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Panorama::PackageVersion";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPackageVersion;
    /**
     * @external
     * @cloudformationAttribute IsLatestPatch
     */
    readonly attrIsLatestPatch: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute PackageArn
     */
    readonly attrPackageArn: string;
    /**
     * @external
     * @cloudformationAttribute PackageName
     */
    readonly attrPackageName: string;
    /**
     * @external
     * @cloudformationAttribute RegisteredTime
     */
    readonly attrRegisteredTime: number;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * @external
     * @cloudformationAttribute StatusDescription
     */
    readonly attrStatusDescription: string;
    /**
     * `AWS::Panorama::PackageVersion.PackageId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-packageid
     */
    packageId: string;
    /**
     * `AWS::Panorama::PackageVersion.PackageVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-packageversion
     */
    packageVersion: string;
    /**
     * `AWS::Panorama::PackageVersion.PatchVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-patchversion
     */
    patchVersion: string;
    /**
     * `AWS::Panorama::PackageVersion.MarkLatest`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-marklatest
     */
    markLatest: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Panorama::PackageVersion.OwnerAccount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-owneraccount
     */
    ownerAccount: string | undefined;
    /**
     * `AWS::Panorama::PackageVersion.UpdatedLatestPatchVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-packageversion.html#cfn-panorama-packageversion-updatedlatestpatchversion
     */
    updatedLatestPatchVersion: string | undefined;
    /**
     * Create a new `AWS::Panorama::PackageVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPackageVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
