/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SASURI;
import com.sas.security.sspi.SSPIAuth;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionRequest;
import com.sas.services.connection.Credential;
import com.sas.services.connection.LoggerFactory;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class Server
implements Cloneable,
Serializable {
    @SASScope
    public static final int SERVERTYPE_NOT_IOM = -1;
    @SASScope
    public static final int SERVERTYPE_UNDESIGNATED = 0;
    @SASScope
    public static final int SERVERTYPE_SAS = 1;
    @SASScope
    public static final int SERVERTYPE_SASGMS = 2;
    @SASScope
    public static final int SERVERTYPE_SASMDX = 3;
    @SASScope
    public static final int SERVERTYPE_SASMQX = 4;
    @SASScope
    public static final int SERVERTYPE_SASOMI = 5;
    @SASScope
    public static final int SERVERTYPE_SASSTP = 6;
    @SASScope
    public static final int SERVERTYPE_OBJSPAWN = 7;
    @SASScope
    public static final int SERVERTYPE_SASTableServer = 8;
    public static final String CLSID_SAS_1_0 = "440196d4-90f0-11d0-9f41-00a024bb830c";
    public static final String CLSID_SAS_1_1 = "cf7bc7e6-c7e8-11d5-87e3-00c04f38f9f6";
    public static final String CLSID_SAS_1_2 = "e251b1bf-8e46-4cbe-ad83-6389185ba373";
    public static final String CLSID_SAS = "440196d4-90f0-11d0-9f41-00a024bb830c";
    public static final String CLSID_POOLED_SAS_1_0 = "620963ee-32bf-4128-bf5f-4b0df8ff90eb";
    public static final String CLSID_POOLED_SAS = "620963ee-32bf-4128-bf5f-4b0df8ff90eb";
    public static final String CLSID_SASGMS_1_0 = "9c186a64-83e4-11d2-b956-00c04f81993c";
    public static final String CLSID_SASGMS = "9c186a64-83e4-11d2-b956-00c04f81993c";
    public static final String CLSID_SASMDX_1_0 = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
    public static final String CLSID_SASMDX = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
    public static final String CLSID_SASMQX_1_0 = "8d9ef489-8d1e-11d2-b94f-00c04f8198c0";
    public static final String CLSID_SASMQX = "8d9ef489-8d1e-11d2-b94f-00c04f8198c0";
    public static final String CLSID_SASOMI_1_0 = "2887e7d7-4780-11d4-879f-00c04f38f0db";
    public static final String CLSID_SASOMI_1_1 = "6e56fd50-cfc1-11d5-87bd-00c04f38f0db";
    public static final String CLSID_SASOMI_2_0 = "0217e202-b560-11db-ad91-001083ff6836";
    public static final String CLSID_SASOMI = "0217e202-b560-11db-ad91-001083ff6836";
    public static final String CLSID_SASSTP_1_0 = "15931e31-667f-11d5-8804-00c04f35ac8c";
    public static final String CLSID_SASSTP = "15931e31-667f-11d5-8804-00c04f35ac8c";
    public static final String CLSID_OBJSPAWN_1_0 = "0e3b1810-6646-11d5-8863-00c04f48bc53";
    public static final String CLSID_OBJSPAWN_1_1 = "6a829631-be4a-4cff-82f6-b378705df34c";
    public static final String CLSID_OBJSPAWN = "0e3b1810-6646-11d5-8863-00c04f48bc53";
    public static final String CLSID_SASTableServer_1_0 = "e803e04b-aaf0-4c74-86a6-f7008aa702dc";
    public static final String CLSID_SASTableServer = "e803e04b-aaf0-4c74-86a6-f7008aa702dc";
    public static final String CLSID_ABM_1_0 = "510A5F10-8E07-44AC-942B-EFB5A4782A39";
    public static final String CLSID_ABM = "510A5F10-8E07-44AC-942B-EFB5A4782A39";
    public static final String CLSID_UNDESIGNATED = "00000000-0000-0000-0000-000000000000";
    public static final String OBJSPAWN_ID = "IOM Spawner";
    public static final String AUTH_SERVICE_HOST = "Host";
    public static final String AUTH_SERVICE_METADATA = "Metadata";
    public static final String AUTH_SERVICE_PROMPT = "Prompt";
    public static final String AUTH_SERVICE_NONE = "None";
    public static final String SECURITY_PACKAGE_KERBEROS = "Kerberos";
    public static final String SECURITY_PACKAGE_NTLM = "NTLM";
    public static final String SECURITY_PACKAGE_NEGOTIATE = "Negotiate";
    public static final String SECURITY_PACKAGE_LIST_DEFAULT = "Kerberos,NTLM";
    private static final String[] authServiceEnum = new String[]{"Host", "Metadata", "Prompt", "None"};
    private static final long serialVersionUID = 4922187406001339540L;
    private static final String xIntro = "The value for \"";
    private static final String xOutro = "\" must be one of ";
    private static final int xIntroL = "The value for \"".length();
    private static final int xOutroL = "\" must be one of ".length();
    private static Pattern _delim;
    private static Map _serverTypeMap;
    private String _origClassID;
    private String _normClassID;
    private int _maxClients = 10;
    private int _reactivationLimit;
    private int _shutdownAfterMinutes = -1;
    private String _domain = "";
    private String _serverComponentURI;
    private String _authService;
    private String _origSecurityPackage;
    private String _normSecurityPackage;
    private String _origSecurityPackageList;
    private String _normSecurityPackageList;
    private String _spn;
    private Map _optionMap;

    public Server(String classID) {
        this.setClassID(classID);
        this.setAuthService(AUTH_SERVICE_NONE);
        this.setSecurityPackageList(SECURITY_PACKAGE_LIST_DEFAULT);
        this._optionMap = new HashMap();
    }

    public synchronized void setClassID(String classID) {
        if (classID == null) {
            throw new IllegalArgumentException("\"classID\" cannot be null.");
        }
        this._origClassID = classID;
        this._normClassID = classID.toLowerCase(Locale.US);
    }

    public synchronized String getClassID() {
        return this._origClassID;
    }

    public synchronized String getNormalizedClassID() {
        return this._normClassID;
    }

    public synchronized void setMaxClients(int maxClients) {
        if (maxClients <= 0) {
            throw new IllegalArgumentException("\"maxClients\" cannot be less than 1.");
        }
        this._maxClients = maxClients;
    }

    public synchronized int getMaxClients() {
        return this._maxClients;
    }

    public synchronized void setReactivationLimit(int reactivationLimit) {
        if (reactivationLimit < 0) {
            throw new IllegalArgumentException("\"reactivationLimit\" cannot be less than 0.");
        }
        this._reactivationLimit = reactivationLimit;
    }

    public synchronized int getReactivationLimit() {
        return this._reactivationLimit;
    }

    public synchronized void setShutdownAfterMinutes(int shutdownAfterMinutes) {
        if (shutdownAfterMinutes < -1) {
            throw new IllegalArgumentException("\"shutdownAfterMinutes\" cannot be less than -1");
        }
        this._shutdownAfterMinutes = shutdownAfterMinutes;
    }

    public synchronized int getShutdownAfterMinutes() {
        return this._shutdownAfterMinutes;
    }

    public synchronized void setDomain(String domain) {
        this._domain = domain != null ? domain : "";
    }

    public synchronized String getDomain() {
        return this._domain;
    }

    public synchronized void setServerComponentURI(String serverComponentURI) {
        this._serverComponentURI = serverComponentURI;
    }

    public synchronized String getServerComponentURI() {
        return this._serverComponentURI;
    }

    public synchronized String getAuthService() {
        return this._authService;
    }

    public synchronized void setAuthService(String authService) {
        Server.validateAuthService(authService);
        this._authService = authService;
    }

    public synchronized String getSecurityPackage() {
        return this._origSecurityPackage;
    }

    public synchronized String getNormalizedSecurityPackage() {
        return this._normSecurityPackage;
    }

    public synchronized void setSecurityPackage(String securityPackage) {
        this._origSecurityPackage = securityPackage;
        this._normSecurityPackage = Server.normalizeSecurityPackage(securityPackage);
    }

    public synchronized String getSecurityPackageList() {
        return this._origSecurityPackageList;
    }

    public synchronized String getNormalizedSecurityPackageList() {
        return this._normSecurityPackageList;
    }

    public synchronized void setSecurityPackageList(String securityPackageList) {
        this._origSecurityPackageList = securityPackageList;
        this._normSecurityPackageList = Server.normalizeSecurityPackageList(securityPackageList);
    }

    public synchronized String getSPN() {
        return this._spn;
    }

    public synchronized void setSPN(String spn) {
        this._spn = spn;
    }

    public synchronized String getOption(String name) {
        Server.checkName(name);
        String value = null;
        value = "classfactory".equals(name) || "clsid".equals(name) ? this.getClassID() : ("domain".equals(name) ? this.getDomain() : ("securitypackage".equals(name) ? this.getSecurityPackage() : ("securitypackagelist".equals(name) ? this.getSecurityPackageList() : ("spn".equals(name) ? this.getSPN() : ("authservice".equals(name) ? this.getAuthService() : (String)this._optionMap.get(name))))));
        return value;
    }

    public synchronized String setOption(String name, String value) {
        Server.checkName(name);
        String previousValue = null;
        if ("classfactory".equals(name) || "clsid".equals(name)) {
            previousValue = this.getClassID();
            this.setClassID(value);
        } else if ("domain".equals(name)) {
            previousValue = this.getDomain();
            this.setDomain(value);
        } else if ("securitypackage".equals(name)) {
            previousValue = this.getSecurityPackage();
            this.setSecurityPackage(value);
        } else if ("securitypackagelist".equals(name)) {
            previousValue = this.getSecurityPackageList();
            this.setSecurityPackageList(value);
        } else if ("spn".equals(name)) {
            previousValue = this.getSPN();
            this.setSPN(value);
        } else if ("authservice".equals(name)) {
            previousValue = this.getAuthService();
            this.setAuthService(value);
        } else {
            previousValue = this.getOption(name);
            this._optionMap.put(name, value);
        }
        return previousValue;
    }

    public synchronized String removeOption(String name) {
        Server.checkName(name);
        String previousValue = null;
        if ("classfactory".equals(name) || "clsid".equals(name)) {
            previousValue = this.getClassID();
            this.setClassID(null);
        } else if ("domain".equals(name)) {
            previousValue = this.getDomain();
            this.setDomain(null);
        } else if ("securitypackage".equals(name)) {
            previousValue = this.getSecurityPackage();
            this.setSecurityPackage(null);
        } else if ("securitypackagelist".equals(name)) {
            previousValue = this.getSecurityPackageList();
            this.setSecurityPackageList(null);
        } else if ("spn".equals(name)) {
            previousValue = this.getSPN();
            this.setSPN(null);
        } else {
            previousValue = this.getOption(name);
            this._optionMap.remove(name);
        }
        return previousValue;
    }

    @SASScope
    public final SASURI toURI(ConnectionRequest cxReq) {
        ConnectionFactoryKernel kernel;
        ConnectionFactoryRequest cxfReq;
        ConnectionFactoryConfiguration cxfConfig;
        boolean noRedirect;
        Credential cred = null;
        String cxID = null;
        if (cxReq != null) {
            cred = cxReq.getCredential();
            ConnectionFactoryKernel kernel2 = cxReq.getFactory();
            long kernelID = kernel2.getKernelID();
            long cxNum = kernel2.assignConnectionID();
            cxID = LoggerFactory.formatOrderedPair('f', kernelID, 'c', cxNum);
        }
        SASURI uri = this.toURI(cred, cxID);
        if (cxReq != null && (noRedirect = (cxfConfig = (cxfReq = (kernel = cxReq.getFactory()).getRequest()).getOriginalConfiguration()).isNoRedirect())) {
            Map attrMap = uri.getAttributes();
            HashMap<String, Boolean> nrAttrMap = new HashMap<String, Boolean>(attrMap);
            nrAttrMap.put("noredirect", Boolean.TRUE);
            String scheme = uri.getScheme();
            uri = new SASURI(scheme, nrAttrMap);
        }
        return uri;
    }

    @SASScope
    public abstract SASURI toURI(Credential var1, String var2);

    public static Server fromURI(SASURI uri) {
        BridgeServer server = null;
        String scheme = uri.getScheme().toUpperCase(Locale.US);
        if (!"BRIDGE".equals(scheme) && !"IOM".equals(scheme)) {
            throw new IllegalArgumentException();
        }
        server = BridgeServer.bridgeServerFromURI(uri);
        return server;
    }

    public synchronized boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !this.getClass().getName().equals(that.getClass().getName())) {
            return false;
        }
        Server thatServer = (Server)that;
        String thatNormClassID = thatServer.getNormalizedClassID();
        if (!this._normClassID.equals(thatNormClassID)) {
            return false;
        }
        int thatMaxClients = thatServer.getMaxClients();
        if (this._maxClients != thatMaxClients) {
            return false;
        }
        int thatReactivationLimit = thatServer.getReactivationLimit();
        if (this._reactivationLimit != thatReactivationLimit) {
            return false;
        }
        int thatShutdownAfterMinutes = thatServer.getShutdownAfterMinutes();
        if (this._shutdownAfterMinutes != thatShutdownAfterMinutes) {
            return false;
        }
        String thatDomain = thatServer.getDomain();
        if (!this._domain.equals(thatDomain)) {
            return false;
        }
        String thatServerComponentURI = thatServer.getServerComponentURI();
        if (this._serverComponentURI != null ? !this._serverComponentURI.equals(thatServerComponentURI) : thatServerComponentURI != null) {
            return false;
        }
        String thatAuthService = thatServer.getAuthService();
        if (!this._authService.equals(thatAuthService)) {
            return false;
        }
        String thatSecurityPackage = thatServer.getNormalizedSecurityPackage();
        if (this._normSecurityPackage != null ? !this._normSecurityPackage.equals(thatSecurityPackage) : thatSecurityPackage != null) {
            return false;
        }
        String thatSecurityPackageList = thatServer.getNormalizedSecurityPackageList();
        if (this._normSecurityPackageList != null ? !this._normSecurityPackageList.equals(thatSecurityPackageList) : thatSecurityPackageList != null) {
            return false;
        }
        String thatSPN = thatServer.getSPN();
        if (this._spn != null ? !this._spn.equals(thatSPN) : thatSPN != null) {
            return false;
        }
        Map thatOptionMap = thatServer.getOptionMap();
        return !(this._optionMap != null ? !((Object)this._optionMap).equals(thatOptionMap) : thatOptionMap != null);
    }

    public synchronized int hashCode() {
        int hc = this.getClass().getName().hashCode();
        hc ^= this._normClassID.hashCode();
        hc ^= this._maxClients;
        hc ^= this._reactivationLimit;
        hc ^= this._shutdownAfterMinutes;
        hc ^= this._domain.hashCode();
        hc ^= ((Object)this._optionMap).hashCode();
        if (this._serverComponentURI != null) {
            hc ^= this._serverComponentURI.hashCode();
        }
        hc ^= this._authService.hashCode();
        if (this._normSecurityPackage != null) {
            hc ^= this._normSecurityPackage.hashCode();
        }
        if (this._normSecurityPackageList != null) {
            hc ^= this._normSecurityPackageList.hashCode();
        }
        if (this._spn != null) {
            hc ^= this._spn.hashCode();
        }
        return hc;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("A Cloneable object threw CloneNotSupportedException.");
        }
    }

    public String toString() {
        SASURI uri = this.toURI(null);
        String str = uri.toString();
        return str;
    }

    @SASScope
    public static int clsidToServerType(String clsid) {
        String norm;
        Map serverTypeMap = Server.getServerTypeMap();
        Integer serverTypeI = (Integer)serverTypeMap.get(norm = Server.normalizeClsid(clsid));
        int serverType = serverTypeI != null ? serverTypeI : -1;
        return serverType;
    }

    @SASScope
    public static boolean isPooledSasClsid(String clsid) {
        String norm = Server.normalizeClsid(clsid);
        return "620963ee-32bf-4128-bf5f-4b0df8ff90eb".equals(norm);
    }

    @SASScope
    public static String clsidNameToValue(String name) {
        String value = null;
        try {
            Field field = Server.class.getField(name);
            int modifiers = field.getModifiers();
            Class<?> fieldType = field.getType();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && String.class.equals(fieldType) && name.startsWith("CLSID_")) {
                value = (String)field.get(null);
            }
        }
        catch (NoSuchFieldException nsfe) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (value == null) {
            throw new IllegalArgumentException(name);
        }
        return value;
    }

    @SASScope
    public static void validateAuthService(String authService) {
        String name = "authService";
        Server.enumArgumentCheck(name, authService, authServiceEnum, true);
    }

    public static String normalizeSecurityPackage(String securityPackage) {
        String result = SSPIAuth.normalizeSecurityPackage((String)securityPackage);
        return result;
    }

    public static String normalizeSecurityPackageList(String securityPackageList) {
        if (securityPackageList == null) {
            return null;
        }
        String result = SSPIAuth.normalizeSecurityPackageList((String)securityPackageList);
        return result;
    }

    @SASScope
    protected boolean isSecurityPackageAllowed() {
        boolean supported = AUTH_SERVICE_HOST.equals(this._authService) && this._normSecurityPackage != null;
        return supported;
    }

    @SASScope
    protected String getEntryPoint() {
        String entryPoint = this.toString();
        return entryPoint;
    }

    @SASScope
    protected Map getOptionMap() {
        return this._optionMap;
    }

    @SASScope
    protected static void enumArgumentCheck(String name, String value, String[] allowedArr, boolean caseSensitive) {
        if (!caseSensitive && value != null) {
            value = value.toLowerCase(Locale.US);
        }
        for (int i = 0; i < allowedArr.length; ++i) {
            String allowed = allowedArr[i];
            if (!(allowed != null ? allowed.equals(value) : value == null)) continue;
            return;
        }
        throw Server.enumArgumentException(name, allowedArr);
    }

    @SASScope
    protected static IllegalArgumentException enumArgumentException(String name, String[] allowedArr) {
        int msgL = xIntroL + name.length() + xOutroL + SASURI.lParenL + SASURI.rParenL;
        for (int i = 0; i < allowedArr.length; ++i) {
            msgL += SASURI.commaL;
            String allowed = allowedArr[i];
            if (allowed == null) continue;
            msgL += allowed.length();
        }
        StringBuffer msgBuf = new StringBuffer(msgL);
        msgBuf.append(xIntro).append(name).append(xOutro);
        msgBuf.append("(");
        for (int i = 0; i < allowedArr.length; ++i) {
            if (i > 0) {
                msgBuf.append(",");
            }
            msgBuf.append(allowedArr[i]);
        }
        msgBuf.append(")");
        String msg = msgBuf.toString();
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        return iae;
    }

    @SASScope
    protected static synchronized Pattern getDelim() {
        if (_delim == null) {
            _delim = Pattern.compile("([\\s]*,[\\s]*)+");
        }
        return _delim;
    }

    @SASScope
    protected static boolean isMetadataServerClassID(String classID) {
        int serverType = Server.clsidToServerType(classID);
        boolean result = serverType == 5;
        return result;
    }

    private static synchronized Map getServerTypeMap() {
        if (_serverTypeMap == null) {
            _serverTypeMap = new HashMap(36);
            Integer serverTypeUndesignated = new Integer(0);
            _serverTypeMap.put(CLSID_UNDESIGNATED, serverTypeUndesignated);
            Integer serverTypeSAS = new Integer(1);
            _serverTypeMap.put("440196d4-90f0-11d0-9f41-00a024bb830c", serverTypeSAS);
            _serverTypeMap.put("440196d4-90f0-11d0-9f41-00a024bb830c", serverTypeSAS);
            _serverTypeMap.put(CLSID_SAS_1_1, serverTypeSAS);
            _serverTypeMap.put(CLSID_SAS_1_2, serverTypeSAS);
            _serverTypeMap.put("620963ee-32bf-4128-bf5f-4b0df8ff90eb", serverTypeSAS);
            _serverTypeMap.put("620963ee-32bf-4128-bf5f-4b0df8ff90eb", serverTypeSAS);
            Integer serverTypeSASGMS = new Integer(2);
            _serverTypeMap.put("9c186a64-83e4-11d2-b956-00c04f81993c", serverTypeSASGMS);
            _serverTypeMap.put("9c186a64-83e4-11d2-b956-00c04f81993c", serverTypeSASGMS);
            Integer serverTypeSASMDX = new Integer(3);
            _serverTypeMap.put("f3f46472-1e31-11d5-87c2-00c04f38f9f6", serverTypeSASMDX);
            _serverTypeMap.put("f3f46472-1e31-11d5-87c2-00c04f38f9f6", serverTypeSASMDX);
            Integer serverTypeSASMQX = new Integer(4);
            _serverTypeMap.put("8d9ef489-8d1e-11d2-b94f-00c04f8198c0", serverTypeSASMQX);
            _serverTypeMap.put("8d9ef489-8d1e-11d2-b94f-00c04f8198c0", serverTypeSASMQX);
            Integer serverTypeSASOMI = new Integer(5);
            _serverTypeMap.put("0217e202-b560-11db-ad91-001083ff6836", serverTypeSASOMI);
            _serverTypeMap.put(CLSID_SASOMI_1_0, serverTypeSASOMI);
            _serverTypeMap.put(CLSID_SASOMI_1_1, serverTypeSASOMI);
            _serverTypeMap.put("0217e202-b560-11db-ad91-001083ff6836", serverTypeSASOMI);
            Integer serverTypeSASSTP = new Integer(6);
            _serverTypeMap.put("15931e31-667f-11d5-8804-00c04f35ac8c", serverTypeSASSTP);
            _serverTypeMap.put("15931e31-667f-11d5-8804-00c04f35ac8c", serverTypeSASSTP);
            Integer serverTypeSASTableServer = new Integer(8);
            _serverTypeMap.put("e803e04b-aaf0-4c74-86a6-f7008aa702dc", serverTypeSASTableServer);
            _serverTypeMap.put("e803e04b-aaf0-4c74-86a6-f7008aa702dc", serverTypeSASTableServer);
            Integer serverTypeOBJSPAWN = new Integer(7);
            _serverTypeMap.put("0e3b1810-6646-11d5-8863-00c04f48bc53", serverTypeOBJSPAWN);
            _serverTypeMap.put("0e3b1810-6646-11d5-8863-00c04f48bc53", serverTypeOBJSPAWN);
            _serverTypeMap.put(CLSID_OBJSPAWN_1_1, serverTypeOBJSPAWN);
            _serverTypeMap.put(OBJSPAWN_ID, serverTypeOBJSPAWN);
        }
        return _serverTypeMap;
    }

    private static void checkName(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
    }

    private static String normalizeClsid(String clsid) {
        return clsid != null ? (!OBJSPAWN_ID.equals(clsid) ? clsid.toLowerCase(Locale.US) : clsid) : null;
    }
}

