/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.ThreadPool;
import com.sas.iom.orb.ThreadPoolEvent;
import com.sas.iom.orb.ThreadPoolEventListenerInterface;
import com.sas.iom.orb.ThreadPoolFactoryInterface;
import com.sas.services.connection.ConnectionFactory;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionFactoryShell;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.connection.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ConnectionFactoryManager
extends LoggerFactory {
    public static ConnectionFactoryManager defaultManager = new ConnectionFactoryManager();
    private static final String _parentLoggerName = ConnectionFactoryManager.class.getPackage().getName();
    private static ConnectionResources _cxResourcesDefault;
    private static long _idCounter;
    private long _id;
    private long _requestIDCounter;
    private Map _kernelMap = new HashMap();
    private Map _loggerMap = new WeakHashMap();
    private ConnectionResources _cxResources;

    public ConnectionFactoryManager() {
        this._id = ConnectionFactoryManager.assignID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getFactoryLoggerName(ConnectionFactoryConfiguration cxfConfig) {
        Map map = this._kernelMap;
        synchronized (map) {
            String loggerName = (String)this._loggerMap.get(cxfConfig);
            if (loggerName != null) {
                return loggerName;
            }
            int parentLoggerNameL = _parentLoggerName.length();
            int bufL = parentLoggerNameL + 25;
            StringBuffer loggerNameBuffer = new StringBuffer(bufL);
            loggerNameBuffer.append(_parentLoggerName).append(".f");
            int mhc = this.hashCode();
            if (mhc < 0) {
                loggerNameBuffer.append(0);
                mhc = -mhc;
            }
            loggerNameBuffer.append(mhc).append("-");
            int hc = cxfConfig.hashCode();
            if (hc < 0) {
                loggerNameBuffer.append(0);
                hc = -hc;
            }
            while (true) {
                String suffix = Integer.toString(hc);
                loggerNameBuffer.append(suffix);
                loggerName = loggerNameBuffer.toString();
                if (!this._loggerMap.containsValue(loggerName)) break;
                int suffixL = suffix.length();
                int loggerNameL = loggerName.length();
                int resetL = loggerNameL - suffixL;
                loggerNameBuffer.setLength(resetL);
                ++hc;
            }
            this._loggerMap.put(cxfConfig, loggerName);
            return loggerName;
        }
    }

    public final ConnectionFactoryInterface getFactory(ConnectionFactoryConfiguration cxfConfig) throws ConnectionFactoryException {
        ConnectionFactory shell = this.createShell(cxfConfig);
        LoggerFactory loggerFactory = this.getLoggerFactory(cxfConfig, shell);
        this.activateShell(shell, cxfConfig, loggerFactory);
        this.shellActivated(cxfConfig, shell, loggerFactory);
        return shell;
    }

    @SASScope
    public final synchronized void setConnectionResources(ConnectionResources cxResources) {
        this._cxResources = cxResources != null ? new ConnectionResourcesWrapper(cxResources) : null;
    }

    @SASScope
    public final synchronized ConnectionResources getConnectionResources() {
        if (this._cxResources == null) {
            this._cxResources = ConnectionFactoryManager.getConnectionResourcesDefault();
        }
        return this._cxResources;
    }

    public static String getConnectionFactoryLoggerName(ConnectionFactoryConfiguration cxfConfig) {
        return defaultManager.getFactoryLoggerName(cxfConfig);
    }

    public static ConnectionFactoryInterface getConnectionFactory(ConnectionFactoryConfiguration cxfConfig) throws ConnectionFactoryException {
        return defaultManager.getFactory(cxfConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void activateShell(ConnectionFactoryShell shell, ConnectionFactoryConfiguration cxfConfig, LoggerFactory loggerFactory) throws ConnectionFactoryException {
        ConnectionFactoryKernel kernel = null;
        Map map = this._kernelMap;
        synchronized (map) {
            kernel = (ConnectionFactoryKernel)this._kernelMap.get(cxfConfig);
            if (kernel == null) {
                ConnectionFactoryRequest cxfReq = ConnectionFactoryRequest.wrap(this, cxfConfig);
                if (cxfReq.isLoggableFINE()) {
                    String msg = "connection factory get: " + cxfReq.toString();
                    cxfReq.logFINE(msg);
                }
                kernel = cxfConfig.getKernel(cxfReq);
                if (cxfReq.isLoggableFINE()) {
                    long kernelID = kernel.getKernelID();
                    String kid = 'f' + Long.toHexString(kernelID);
                    String msg = "connection factory get OK: " + kid;
                    cxfReq.logFINE(msg);
                }
                this._kernelMap.put(cxfConfig, kernel);
            }
        }
        shell.setKernel(kernel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeKernel(ConnectionFactoryKernel kernel) {
        Map map = this._kernelMap;
        synchronized (map) {
            ConnectionFactoryConfiguration cxfConfig = kernel.getConfig();
            this._kernelMap.remove(cxfConfig);
        }
    }

    @SASScope
    protected ConnectionFactory createShell(ConnectionFactoryConfiguration cxfConfig) {
        ConnectionFactory shell = new ConnectionFactory();
        return shell;
    }

    @SASScope
    protected LoggerFactory getLoggerFactory(ConnectionFactoryConfiguration cxfConfig, ConnectionFactory shell) {
        return this;
    }

    @SASScope
    protected void shellActivated(ConnectionFactoryConfiguration cxfConfig, ConnectionFactory shell, LoggerFactory loggerFactory) throws ConnectionFactoryException {
    }

    @SASScope
    protected long getManagerID() {
        return this._id;
    }

    @SASScope
    protected synchronized long assignRequestID() {
        long requestID = this._requestIDCounter++;
        return requestID;
    }

    private static synchronized ConnectionResources getConnectionResourcesDefault() {
        if (_cxResourcesDefault == null) {
            _cxResourcesDefault = new ConnectionResourcesDefault();
        }
        return _cxResourcesDefault;
    }

    private static synchronized long assignID() {
        long id = _idCounter++;
        return id;
    }

    @SASScope
    private static class ConnectionResourcesWrapper
    implements ConnectionResources {
        private static final long serialVersionUID = 6281956752774787027L;
        private ConnectionResources _delegate;

        private ConnectionResourcesWrapper(ConnectionResources delegate) {
            this._delegate = delegate;
        }

        @Override
        public SelectionHub getSelectionHub() {
            SelectionHub hub = this._delegate.getSelectionHub();
            if (hub == null) {
                ConnectionResources def = ConnectionFactoryManager.getConnectionResourcesDefault();
                hub = def.getSelectionHub();
            }
            return hub;
        }

        @Override
        public ThreadPool getThreadPool() {
            ThreadPool threadPool = this._delegate.getThreadPool();
            if (threadPool == null) {
                ConnectionResources def = ConnectionFactoryManager.getConnectionResourcesDefault();
                threadPool = def.getThreadPool();
            }
            return threadPool;
        }
    }

    @SASScope
    private static class ConnectionResourcesDefault
    implements ConnectionResources,
    ThreadPoolFactoryInterface,
    ThreadPoolEventListenerInterface {
        private static final long serialVersionUID = 2851933961333353424L;
        private ThreadPool _threadPool;
        private SelectionHub _selectionHub;

        private ConnectionResourcesDefault() {
            HashMap<String, ConnectionResourcesDefault> hubMap = new HashMap<String, ConnectionResourcesDefault>(1);
            hubMap.put(SelectionHub.THREAD_POOL_FACTORY_KEY, this);
            this._selectionHub = new SelectionHub(hubMap);
        }

        @Override
        public SelectionHub getSelectionHub() {
            return this._selectionHub;
        }

        @Override
        public synchronized ThreadPool getThreadPool() {
            if (this._threadPool == null) {
                this._threadPool = new ThreadPool(SelectionHub.THREAD_NAME_BASE);
                this._threadPool.addListener(this);
            }
            return this._threadPool;
        }

        @Override
        public synchronized void handleThreadPoolEvent(ThreadPoolEvent event) {
            ThreadPoolEvent.Type type = event.getType();
            ThreadPool source = event.getThreadPool();
            if (ThreadPoolEvent.Type.TERMINATION.equals((Object)type) && source.equals(this._threadPool)) {
                this._threadPool.removeListener(this);
                this._threadPool = null;
            }
        }
    }
}

